from agent import *
from envs import *
import argparse
from warnings import filterwarnings
import yaml
def set_seed(seed):
    random.seed(seed)
    np.random.seed(seed)
    torch.manual_seed(seed)
    if torch.cuda.is_available():
        torch.cuda.manual_seed(seed)
        torch.cuda.manual_seed_all(seed)
    torch.backends.cudnn.deterministic = True
    torch.backends.cudnn.benchmark = False

if __name__ == "__main__":
    args = read_args()
    args.test=True
    setup_logging(args.log_level)
    set_seed(args.seed) 
    torch.set_num_threads(torch.get_num_threads())
    ac = torch.load(args.path, map_location=device).to(device)
    logger.info("Model set to evaluation mode")
    ac.pi.eval() 
    print(ac.pi) 
    env = build_env(args, render_mode="human")() #gym.make(args.env, width=1200, height=1200, render_mode="human") 
    for _ in range(1000):
        with torch.no_grad():
            o, d, ep_ret, ep_len = env.reset()[0], False, 0, 0
            while not (d) and ep_len < 5000:
                a, logp_a, pi, mu, std, cov, *_ = ac.pi(
                    torch.as_tensor(
                        np.expand_dims(o, axis=0), dtype=torch.float32
                    ).to(device),
                    deterministic=True, 
                )
                print("Action: ", a)
                a = a.cpu().numpy()
                o2, r, d, _, info = env.step(a[0])
                o = o2
                ep_len += 1
                ep_ret += r 
    print("Episode Return: ", ep_ret)
    print("Episode Length: ", ep_len)
    env.close()

