# Mitigating Barren Plateaus in Quantum Neural Networks via an AI-Driven Submartingale-Based Framework

### Authors: anonymous

### Abstract:
> <p align="justify">
In the era of noisy intermediate-scale quantum (NISQ) computing, Quantum Neural Networks (QNNs) have emerged as a promising approach for various applications, yet their training is often hindered by barren plateaus (BPs), where gradient variance vanishes exponentially in terms of the qubit size. Most existing initialization-based mitigation strategies rely heavily on pre-designed static parameter distributions, thereby lacking adaptability to diverse model sizes or data conditions. To address these limitations, we propose AdaInit, a foundational framework that leverages generative models with the submartingale property to iteratively synthesize initial parameters for QNNs that yield non-negligible gradient variance, thereby mitigating BPs. Unlike conventional one-shot initialization methods, AdaInit adaptively explores the parameter space by incorporating dataset characteristics and gradient feedback, with theoretical guarantees of convergence to finding a set of effective initial parameters for QNNs. We provide rigorous theoretical analyses of the submartingale-based process and empirically validate that AdaInit consistently outperforms existing initialization methods in maintaining higher gradient variance across various QNN scales. We believe this work may initiate a new avenue to mitigate BPs.
</p>

### Dataset:
> We use four public datasets, including Iris, Wine, Titanic, and MNIST.

### Getting Started:
#### Prerequisites
> Linux or macOS \
> CPU or NVIDIA GPU + CUDA CuDNN \
> Python 3.11 \
> pytorch, pennylane, openai, vertexai, numpy, sklearn, pandas, scipy

#### Clone this repo
> ```git clone https://github.com/[User_Name]/AdaInit.git``` \
> ```cd AdaInit```

#### Install dependencies
> For pip users, please type the command: ```pip install -r requirements.txt``` \
> For Conda users, you may create a new Conda environment using: ```conda env create -f environment.yml``` \
> Ensure you already installed CUDA and cuDNN.

#### Directories
> **config**: the config files. \
> **data**: contain four datasets. \
> **src**: contain scripts. \
	│── **main.py** # main scripts \
	│── **model.py** # QNN models \
	│── **train_eval.py** # train and evaluation functions \
	│── **utils.py** # util functions \
	│── **basic_init.py** # classic initialization methods

#### Run
> Update the config file with your Vertex AI project id and/or OpenAI key. \
> You can run the main scripy under "src" by ```python main.py --config_file model``` \
> The main file includes the search function with QNN training and evaluation. \
> Our work doesn't contain pre-trained models.

#### Results
> We present our main results in the Experiment section.
