import requests

SERVER_URL = "XXXX"   # 如果部署在远端，换成公网地址
# TEXT = """
# The quick brown fox jumps over the lazy dog.
# Here is a very long prompt you want to compress before feeding it to the LLM …
# """
# RATE = 0.6                                      # 压缩比例（0‒1]

# payload = {
#     "text": TEXT,
#     "rate": RATE
# }


# curl -X POST "XXXX"  -H "Content-Type: application/json" -d '{"text": "<|fim_prefix|>", "rate": 0.6}'


def compress_prompt(text, rate):
    payload = {
        "text": text,
        "rate": rate
    }
    try:
        resp = requests.post(SERVER_URL, json=payload, timeout=30)
        resp.raise_for_status()                     # HTTP 4xx/5xx 会抛异常
        data = resp.json()
        return data
    except requests.exceptions.RequestException as e:
        print("网络或服务器错误:", e)
    except ValueError:
        print("返回的不是合法 JSON:", resp.text)