#!/usr/bin/env python

"""
Implements utility functions for the training pipeline.
"""

### IMPORTS ###
# Built-in imports
import os
import random

# Lib imports
import numpy as np
import torch

# Custom imports
import const


### FUNCTIONS ###
def set_seed(seed: int) -> None:
    """
    Set random seeds for reproducability of results

    Parameters
    ----------
    seed : int
        Random seed number.
    """

    np.random.seed(seed)
    random.seed(seed)
    torch.manual_seed(seed)
    torch.cuda.manual_seed(seed)
    torch.cuda.manual_seed_all(seed)
    torch.backends.cudnn.deterministic = True
    torch.backends.cudnn.benchmark = False
    os.environ["PYTHONHASHSEED"] = str(seed)
