# SUPPLEMENT - A Scale-Invariant Sorting Criterion to Find a Causal Order in Additive Noise Models

### The main algorithmic contributions can be found in our library [CausalDisco](https://causaldisco.github.io/CausalDisco).

Refer to CausalDisco for implementations of var-/R^2-sortability and -SortnRegress ready-to-use for your own experiments. This archive contains code to simulate data, evaluate algorithms, and reproduce the figures in the publication.

---

All code is based on Python 3.10 and the setup presumes a system with [python3.10](https://www.python.org/downloads/release/python-3100/), as well as [venv](https://docs.python.org/3/library/venv.html) and [tkinter](https://docs.python.org/3/library/tkinter.html) (for python3.10) installed. Plotting also requires a local latex installation.

1. Create a virtual environment and install dependencies:
__setup.sh__

2. Run a suite of experiments:
__run.sh__

3. Inspect results in __src/results__, for example: 
    - **Figure 1**: src/results/PerformanceRsb/ER/ER_std/_viz/thr_0_20nodes/sortability_standard_0_SHD__std_R2.pdf
    - **Figure 2**: src/results/Convergence/50_SF/\$R^2\$-sortability_convergence_size.pdf

---

The default experiments in __run.sh__ are configured to run quickly and without installing additional components. A complete run with the settings specified in the paper requires adapting the experiment settings and code, as well as installing the following additional components (system-specific installation):

- [R](https://www.r-project.org/)
- [rpy2](https://rpy2.github.io/)
- [SID](https://cran.r-project.org/src/contrib/Archive/SID/) (compatible with R3.6.3, archival versions of some dependencies may have to be installed manually)
- [EqVarDAG](https://github.com/WY-Chen/EqVarDAG)
- [Py-Causal](https://github.com/bd2kccd/py-causal)
- [Java8](https://www.oracle.com/fr/java/technologies/javase/javase8-archive-downloads.html) JRE and JDK
