cat imagenet_eff.sh

export CUDA_VISIBLE_DEVICES=0,1,2,3;
python -m pdb main.py \
    --dataset imagenet \
    --train-batch-size 512 \
    --test-batch-size 256 \
    --prune-batch-size 256 \
    --optimizer momentum \
    --model effcientnetb0\
    --post-epochs 150 \
    --lr 0.16 \
    --lr-scheduler drop \
    --lr-step-size 1 \
    --lr-drop-rate 0.99 \
    --pruner synflow \
    --mask-scope global \
    --compression 0.7 \
    --compression-flops 0.99 \
    --weight-decay 1e-5 \
    --prune-epochs 0 \
    --expid imagenet_effnetb0_preconfig \
    --data-dir {PATH_TO_DATA} \
    --print-model \
    --verbose \
    --parallel \
    --workers 20 \
    --prune-pw-only \
    --no-prune-linear

# pruner = {synflow, opt_flops, opt_params, opt_both}
# scope = {global, filter, precropping}
# use the argument `compression-flops` to specify the flops pruning ratio when using scope OptBoth
