# DCO: Optimizing Language Models for Crosslingual Knowledge Consistency


# Environment Setup
## Install Dependencies from environment.yml
```bash
conda env create -f environment.yml
conda activate dco
```

## Prepare HF_TOKEN

The code will upload the post-DCO models to your HF repo. Please create `.env` and put your HF token inside, like
```
export HF_TOKEN="hf_xxxx"
```
# Step1: Data Preparation
## MMMLU
```bash
bash 1_prepare_data_mmmlu.sh
```

# Step2: Train models on three datasets
## MMMLU
```bash
bash 2_train_mmmlu.sh
```

# Step3: Getting the predictions (Probing)
## MMMLU
```bash
bash 3_eval_mmmlu.sh
```

# Step4: Compute CLC and ACC
## MMMLU
```bash
bash 4_compute_clc_mmmlu.sh
bash 4_compute_acc_mmmlu.sh
```