# GödelNNs – Logic of Hypotheses

This repository contains an implementation of the *Logic of Hypotheses (LoH)* framework.

## Dependencies
* ML core: `torch`, `torchvision`, `numpy`, `scikit-learn`, `pandas`
* Experiment tooling: `optuna`, `wandb`
* Logic: `sympy`, `pyparsing`
* Baselines: `xgboost`, `difflogic`
* Data: `ucimlrepo`

## Reproducing the main experiments

Each script accepts `--help` for additional flags. 

### Tabular benchmarks (from UCI‑ML)

To train LoH models and MLLP baselines on the *adult* dataset and replicate the experiment:

```bash
# LoH (ours)
python GodelNNs/experiments/uciml_experiment.py --dataset=adult --epochs=200 --repetitions=10 --nohypertuning

# MLLP baseline
python GodelNNs/experiments/uciml_baseline_mllp.py -d adult -e 200 --nohypertuning

# DLN baseline
python GodelNNs/experiments/uciml_baseline_difflogic.py -d adult -e 200 --nohypertuning

# Other baselines
python  GodelNNs/experiments/uciml_baselines.py --dataset=adult --epochs=200
```

Replace `adult` with any dataset in `{bank_marketing, banknote, blogger, …}` to run the experiments with the other datasets. 
Results and Hyperparameters are stored in `./experiments/results/uciml_results.json` (and similar files for the baselines).


### Visual Tic‑Tac‑Toe

To train (as an example) the dnf LoH model and the cnf baselines:

```bash
# LoH – DNF
python GodelNNs/experiments/MNISTttt.py --cnf_or_dnf=dnf --nohypertuning

# MLLP baseline – CNF 
python GodelNNs/experiments/MNISTttt_mllp.py --cnf_or_dnf=cnf --nohypertuning

# DLN baseline
python GodelNNs/experiments/MNISTttt_difflogic.py --nohypertuning

# NN baseline
python  GodelNNs/experiments/MNISTttt.py --nn_baseline --tune_n_bits --nohypertuning
```

Results and Hyperparameters are stored in `./experiments/results/MNISTttt-results.json` (and similar files for the baselines).

## Project layout

```
GodelNNs/
├── experiments/                    # scripts for the experiments
│   ├── data/                          # tabular datasets
│   ├── results/                       # json files containing the hyperparams, and storing the results
│   ├── notebooks/                     # notebooks producing the plots
│   ├── uciml_experiment.py            # LoH on tabular data
│   ├── uciml_baseline_difflogic.py    # DLN baseline on tabular data
│   ├── uciml_baseline_mllp.py         # MLLP baseline on tabular data
│   ├── uciml_baselines.py             # Other baselines on tabular data
│   ├── MNISTttt.py                    # LoH (and NN baseline) on Visual tic-tac-toe
│   ├── MNISTttt_difflogic.py          # DLN baseline on Visual tic-tac-toe 
│   └── MNISTttt_mllp.py               # MLLP baseline on Visual tic-tac-toe
├── general_models.py               # functions for compiling general LoH formulas
├── generate_data.py                # functions for producing artificial datasets
├── model.py                        # class for the rule-learning LoH neural network
├── layers.py                       # classes for the rule-learning LoH layers
└── utils.py                        # utility functions
```
