# Setting
```sh
conda create -n ds python=3.9
conda activate ds
```
[Install pytorch 2.2.1 with torchvision 0.17.1](https://pytorch.org/get-started/previous-versions/)
```
pip install -r requirements.txt
```

# Training

### Run experiments for all attributes for each learning rate and model configuration.
1. Set the dataset directory ('DATASET_DIR') in 'do_exp.sh' and 'do_exp_pretrain.sh' 

2. In the 'run_exp.sh' file, set the dataset, model configuration, learning rate, and output directory information:
```sh
OUTDIR=../exps
# real-world datasets
DATASET=FMOW
                                 #GPU #dataset #algo  #arch     #aug     #log path  #lr
bash scripts/run_real_dataset.sh 0    $DATASET ERM    resnet18  no_aug   $OUTDIR   0.001 PRETRAIN   &

# controlled datasets
DATASET=DSPRITES
bash scripts/run_attr_group.sh   1    $DATASET ERM    resnet18  no_aug   $OUTDIR   0.01  &
```
3. Run the command:
```sh
sh run_exp.sh
```

### Zero-shot experiments
Run the command:
```sh
python run_zeroshot.py --gpu {gpu_id} --mode {model_name} --prompt_type {prompt_type}
```

## License

This source code is released under the MIT license, included [here](LICENSE).
