You will be given:
1. A math problem
2. A ground-truth answer
3. A series of reasoning chunks (from another model or a human)

Your task has two parts:

========================================
STEP 1: CHUNK FILTERING

For each reasoning chunk, decide whether to KEEP AS IS or REMOVE it.

- Mark a chunk as KEEP AS IS if it contributes in **any** meaningful way to solving the problem. This includes:
  - Interpreting or clarifying the problem
  - Narrowing down possibilities
  - Performing relevant checks or computations
  - Showing or explaining **intermediate calculations**
  - Providing partial insight, even if incomplete
  - Reinforcing understanding, even through repetition
  - Highlighting or eliminating wrong paths (if it clarifies overall direction)

**Err on the side of KEEPING.** Unless a chunk is clearly misleading, irrelevant, or adds zero value, KEEP it AS IS.

- Mark a chunk as REMOVE only if:
  - It adds no insight, meaning, or progress
  - It is factually incorrect in a way that derails the reasoning
  - It is completely off-topic or redundant **without improving clarity or flow**

This is a **conservative filter**: If you’re unsure, KEEP AS IS.

========================================
STEP 2: RECONSTRUCT FINAL REASONING

Using **only the KEPT chunks**, write a logically complete and clean explanation that leads to the final boxed answer.

- You must **concatenate the chunks marked as KEEP AS IS in a way that preserves their original wording and structure as strictly as possible**.
- KEEP AS IS chunks must remain **exactly as written** and should be used **verbatim**, with only the most minimal edits allowed strictly for connecting one chunk to another. Do not modify the content or structure within any individual chunk.
- Do **not paraphrase, rewrite, summarize, or alter** the content of any kept chunk.
- Do NOT skip or rephrase any ideas from the kept chunks.
- Do NOT add any new reasoning beyond what’s already there.
- Maintain the original tone and style of the chunks — whether informal, reflective, or exploratory. Do not rewrite in a more formal or deductive voice.

End the reasoning with the correct final answer in boxed format: \boxed{{...}}

========================================
OUTPUT FORMAT (Strictly follow this):
```
[OUTPUT]

[CHUNK_FILTERING_RESULTS]
[Chunk 1] KEEP AS IS
[Chunk 2] KEEP AS IS
[Chunk 3] REMOVE
...
[Chunk N] KEEP AS IS

[FINAL_RECONSTRUCTED_REASONING]
"""
<Clean, logically ordered explanation using only the kept chunks, with only minimal edits made to ensure smooth transitions between ideas. End with the boxed final answer.> 
"""
```

Now here is your input:
### Problem:
{problem}

### Ground-Truth Answer:
{ground_truth_answer}

### Reasoning Chunks:
{chunks}