# Diverse Influence Component Analysis

The scripts for experiments are located in folders `mixture`, `sergio`, and `mnist`, using `Python 3.9`. To install all required packages via `pip`, use:

`pip install -r requirements.txt`

## Synthetic Simulations

The scripts are located in `mixture` folder. To run synthetic simulation with mixture `EXP` (from `a`, `b`, `c`) using criterion type `TYPE` (from `dica`, `base`, `sparse`), use:

`python train.py --type TYPE --exp EXP --latent_dim LATENT_DIM --input_dim INPUT_DIM`

## Single-cell Transcriptomics Analysis (with SERGIO)

The scripts are located in `sergio` folder. The TRRUST data file is provided in `trrust_rawdata.mouse.tsv`, which can be downloaded from [https://www.grnpedia.org/trrust/](https://www.grnpedia.org/trrust/). The pre-simulated data from SERGIO is provided as `.csv` files in the folder. To run the experiment with our pre-simulated data, using `TYPE` criterion (from `dica`, `base`, `sparse`), use:

`python train.py --type TYPE`

To simulate new data with SERGIO, use:

`python data_mouse.py`

## MNIST

The scripts are located in `mnist` folder. To run the experiment, use:

`python train.py`