import os

# Required classes
from .simulator_class.SokobanFlipSimulator import SokobanFlipSimulator
from .sampler_interface.SokobanSampler import SokobanFlipSampler
from .concept_class.SokobanFlip import SokobanFlipConceptClass

from .simulator_class.SokobanGravity import SokobanGravity
from .sampler_interface.SokobanSampler import SokobanGravitySampler
from .concept_class.SokobanGravity import SokobanGravityConceptClass

CONC_MAX = 3 #10
FULL_SAMPLE_BUDGET = 750

SAMPLE_BUDGET = 10

CONCEPT_CLASS_MAP = {'sokoban-gravity': SokobanGravityConceptClass,
                     'sokoban-flip' : SokobanFlipConceptClass}
SAMPLER_INTERFACE_CLASS_MAP = {'sokoban-gravity': SokobanGravitySampler,
                               'sokoban-flip': SokobanFlipSampler}
SIMULATOR_INTERFACE_CLASS_MAP = {'sokoban-gravity': SokobanGravity,
                                 'sokoban-flip': SokobanFlipSimulator}
OBSERVATION_MODEL_GRAVITY = {'concept_blank_cell_below': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.1}}, 'NOT_concept_blank_cell_below': {'Ob_conc': {'conc': 0.9, 'not_conc': 0.0}}, 'concept_blank_cell_on_left': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.03333333333333333}}, 'NOT_concept_blank_cell_on_left': {'Ob_conc': {'conc': 0.9666666666666667, 'not_conc': 0.0}}, 'concept_box_below': {'Ob_conc': {'conc': 0.0, 'not_conc': 0.0}}, 'NOT_concept_box_below': {'Ob_conc': {'conc': 1.0, 'not_conc': 1.0}}, 'concept_box_on_left': {'Ob_conc': {'conc': 0.0, 'not_conc': 0.0}}, 'NOT_concept_box_on_left': {'Ob_conc': {'conc': 1.0, 'not_conc': 1.0}}, 'concept_box_on_right': {'Ob_conc': {'conc': 0.0, 'not_conc': 0.0}}, 'NOT_concept_box_on_right': {'Ob_conc': {'conc': 1.0, 'not_conc': 1.0}}, 'concept_box_on_top': {'Ob_conc': {'conc': 0.0, 'not_conc': 0.0}}, 'NOT_concept_box_on_top': {'Ob_conc': {'conc': 1.0, 'not_conc': 1.0}}, 'concept_no_pink_cell_below_m': {'Ob_conc': {'conc': 0.9940828402366864, 'not_conc': 0.0}}, 'NOT_concept_no_pink_cell_below_m': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.005917159763313609}}, 'concept_no_pink_cell_on_top_m': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}}, 'NOT_concept_no_pink_cell_on_top_m': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}}, 'concept_no_wall_below_m': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}}, 'NOT_concept_no_wall_below_m': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}}, 'concept_no_wall_on_left_m': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}}, 'NOT_concept_no_wall_on_left_m': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}}, 'concept_no_wall_on_right_m': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}}, 'NOT_concept_no_wall_on_right_m': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}}, 'concept_no_wall_on_top_m': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}}, 'NOT_concept_no_wall_on_top_m': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}}, 'concept_on_pink_cell': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}}, 'NOT_concept_on_pink_cell': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}}, 'concept_pink_cell_below': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}}, 'NOT_concept_pink_cell_below': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}}, 'concept_pink_cell_on_left': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}}, 'NOT_concept_pink_cell_on_left': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}}, 'concept_pink_cell_on_right': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.009302325581395349}}, 'NOT_concept_pink_cell_on_right': {'Ob_conc': {'conc': 0.9906976744186047, 'not_conc': 0.0}}, 'concept_pink_cell_on_top': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.004878048780487805}}, 'NOT_concept_pink_cell_on_top': {'Ob_conc': {'conc': 0.9951219512195122, 'not_conc': 0.0}}, 'concept_target_on_right': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}}, 'NOT_concept_target_on_right': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}}, 'concept_target_on_top': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.004545454545454545}}, 'NOT_concept_target_on_top': {'Ob_conc': {'conc': 0.9954545454545455, 'not_conc': 0.0}}, 'concept_wall_above_box': {'Ob_conc': {'conc': 0.9, 'not_conc': 0.0}}, 'NOT_concept_wall_above_box': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.1}}, 'concept_wall_below': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}}, 'NOT_concept_wall_below': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}}, 'concept_wall_below_box': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}}, 'NOT_concept_wall_below_box': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}}, 'concept_wall_down_left': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}}, 'NOT_concept_wall_down_left': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}}, 'concept_wall_down_right': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}}, 'NOT_concept_wall_down_right': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}}, 'concept_wall_on_left': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}}, 'NOT_concept_wall_on_left': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}}, 'concept_wall_on_left_of_box': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}}, 'NOT_concept_wall_on_left_of_box': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}}, 'concept_wall_on_right': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}}, 'NOT_concept_wall_on_right': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}}, 'concept_wall_on_right_of_box': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}}, 'NOT_concept_wall_on_right_of_box': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}}, 'concept_wall_on_top': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}}, 'NOT_concept_wall_on_top': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}}, 'concept_wall_top_left': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}}, 'NOT_concept_wall_top_left': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}}, 'concept_wall_top_right': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}}, 'NOT_concept_wall_top_right': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}}, 'concept_wall_up_down_right': {'Ob_conc': {'conc': 0.0, 'not_conc': 0.0}}, 'NOT_concept_wall_up_down_right': {'Ob_conc': {'conc': 1.0, 'not_conc': 1.0}}}

# OBSERVATION_MODEL_GRAVITY = {'concept_blank_cell_below': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.13157894736842105}},
#                              'NOT_concept_blank_cell_below': {'Ob_conc': {'conc': 0.868421052631579, 'not_conc': 0.0}},
#                              'concept_blank_cell_on_left': {'Ob_conc': {'conc': 0.9929078014184397, 'not_conc': 0.03488372093023256}},
#                              'NOT_concept_blank_cell_on_left': {'Ob_conc': {'conc': 0.9651162790697675, 'not_conc': 0.0070921985815602835}},
#                              'concept_box_below': {'Ob_conc': {'conc': 0.0, 'not_conc': 0.0}},
#                              'NOT_concept_box_below': {'Ob_conc': {'conc': 1.0, 'not_conc': 1.0}},
#                              'concept_box_on_left': {'Ob_conc': {'conc': 0.0, 'not_conc': 0.0}},
#                              'NOT_concept_box_on_left': {'Ob_conc': {'conc': 1.0, 'not_conc': 1.0}},
#                              'concept_box_on_right': {'Ob_conc': {'conc': 0.0, 'not_conc': 0.0}},
#                              'NOT_concept_box_on_right': {'Ob_conc': {'conc': 1.0, 'not_conc': 1.0}},
#                              'concept_box_on_top': {'Ob_conc': {'conc': 0.0, 'not_conc': 0.0}},
#                              'NOT_concept_box_on_top': {'Ob_conc': {'conc': 1.0, 'not_conc': 1.0}},
#                              'concept_no_pink_cell_below_m': {'Ob_conc': {'conc': 0.9942528735632183, 'not_conc': 0.0}},
#                              'NOT_concept_no_pink_cell_below_m': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.005747126436781609}},
#                              'concept_no_pink_cell_on_top_m': {'Ob_conc': {'conc': 0.9943181818181818, 'not_conc': 0.0}},
#                              'NOT_concept_no_pink_cell_on_top_m': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.005681818181818182}},
#                              'concept_no_wall_below_m': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}},
#                              'NOT_concept_no_wall_below_m': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}},
#                              'concept_no_wall_on_left_m': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}},
#                              'NOT_concept_no_wall_on_left_m': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}},
#                              'concept_no_wall_on_right_m': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}},
#                              'NOT_concept_no_wall_on_right_m': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}},
#                              'concept_no_wall_on_top_m': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}},
#                              'NOT_concept_no_wall_on_top_m': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}},
#                              'concept_on_pink_cell': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}},
#                              'NOT_concept_on_pink_cell': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}},
#                              'concept_pink_cell_below': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.004830917874396135}},
#                              'NOT_concept_pink_cell_below': {'Ob_conc': {'conc': 0.9951690821256038, 'not_conc': 0.0}},
#                              'concept_pink_cell_on_left': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.004830917874396135}},
#                              'NOT_concept_pink_cell_on_left': {'Ob_conc': {'conc': 0.9951690821256038, 'not_conc': 0.0}},
#                              'concept_pink_cell_on_right': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}},
#                              'NOT_concept_pink_cell_on_right': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}},
#                              'concept_pink_cell_on_top': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.004878048780487805}},
#                              'NOT_concept_pink_cell_on_top': {'Ob_conc': {'conc': 0.9951219512195122, 'not_conc': 0.0}},
#                              'concept_target_on_right': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}},
#                              'NOT_concept_target_on_right': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}},
#                              'concept_target_on_top': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.004545454545454545}},
#                              'NOT_concept_target_on_top': {'Ob_conc': {'conc': 0.9954545454545455, 'not_conc': 0.0}},
#                              'concept_wall_above_box': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}},
#                              'NOT_concept_wall_above_box': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}},
#                              'concept_wall_below': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}},
#                              'NOT_concept_wall_below': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}},
#                              'concept_wall_below_box': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}},
#                              'NOT_concept_wall_below_box': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}},
#                              'concept_wall_down_left': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}},
#                              'NOT_concept_wall_down_left': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}},
#                              'concept_wall_down_right': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}},
#                              'NOT_concept_wall_down_right': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}},
#                              'concept_wall_on_left': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}},
#                              'NOT_concept_wall_on_left': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}},
#                              'concept_wall_on_left_of_box': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}},
#                              'NOT_concept_wall_on_left_of_box': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}},
#                              'concept_wall_on_right': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}},
#                              'NOT_concept_wall_on_right': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}},
#                              'concept_wall_on_right_of_box': {'Ob_conc': {'conc': 0.9791666666666666, 'not_conc': 0.0}},
#                              'NOT_concept_wall_on_right_of_box': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.020833333333333332}},
#                              'concept_wall_on_top': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}},
#                              'NOT_concept_wall_on_top': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}},
#                              'concept_wall_top_left': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}},
#                              'NOT_concept_wall_top_left': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}},
#                              'concept_wall_top_right': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}},
#                              'NOT_concept_wall_top_right': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}},
#                              'concept_wall_up_down_right': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}},
#                              'NOT_concept_wall_up_down_right': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}}}

OBSERVATION_MODEL_FLIP = {'concept_above_switch': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}}, 'NOT_concept_above_switch': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}}, 'concept_box_above': {'Ob_conc': {'conc': 0.0, 'not_conc': 0.0}}, 'NOT_concept_box_above': {'Ob_conc': {'conc': 1.0, 'not_conc': 1.0}}, 'concept_box_below': {'Ob_conc': {'conc': 0.0, 'not_conc': 0.0}}, 'NOT_concept_box_below': {'Ob_conc': {'conc': 1.0, 'not_conc': 1.0}}, 'concept_box_left': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}}, 'NOT_concept_box_left': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}}, 'concept_box_right': {'Ob_conc': {'conc': 0.8571428571428571, 'not_conc': 0.0}}, 'NOT_concept_box_right': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.14285714285714285}}, 'concept_empty_above': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}}, 'NOT_concept_empty_above': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}}, 'concept_empty_below': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}}, 'NOT_concept_empty_below': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}}, 'concept_empty_left': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0707070707070707}}, 'NOT_concept_empty_left': {'Ob_conc': {'conc': 0.9292929292929293, 'not_conc': 0.0}}, 'concept_empty_right': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.02586206896551724}}, 'NOT_concept_empty_right': {'Ob_conc': {'conc': 0.9741379310344828, 'not_conc': 0.0}}, 'concept_left_switch': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}}, 'NOT_concept_left_switch': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}}, 'concept_switch_on': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}}, 'NOT_concept_switch_on': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}}, 'concept_target_above': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0035460992907801418}}, 'NOT_concept_target_above': {'Ob_conc': {'conc': 0.9964539007092199, 'not_conc': 0.0}}, 'concept_target_below': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}}, 'NOT_concept_target_below': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}}, 'concept_target_left': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}}, 'NOT_concept_target_left': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}}, 'concept_target_right': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}}, 'NOT_concept_target_right': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}}, 'concept_wall_above': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}}, 'NOT_concept_wall_above': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}}, 'concept_wall_below': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}}, 'NOT_concept_wall_below': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}}, 'concept_wall_left': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}}, 'NOT_concept_wall_left': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}}, 'concept_wall_left_below_ofbox': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}}, 'NOT_concept_wall_left_below_ofbox': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}}, 'concept_wall_right': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}}, 'NOT_concept_wall_right': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}}}

# OBSERVATION_MODEL_FLIP = {'concept_above_switch': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}},
#                           'NOT_concept_above_switch': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}},
#                           'concept_box_above': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}},
#                           'NOT_concept_box_above': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}},
#                           'concept_box_below': {'Ob_conc': {'conc': 0.0, 'not_conc': 0.0}},
#                           'NOT_concept_box_below': {'Ob_conc': {'conc': 1.0, 'not_conc': 1.0}},
#                           'concept_box_left': {'Ob_conc': {'conc': 0.0, 'not_conc': 0.0}},
#                           'NOT_concept_box_left': {'Ob_conc': {'conc': 1.0, 'not_conc': 1.0}},
#                           'concept_box_right': {'Ob_conc': {'conc': 0.0, 'not_conc': 0.0}},
#                           'NOT_concept_box_right': {'Ob_conc': {'conc': 1.0, 'not_conc': 1.0}},
#                           'concept_empty_above': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.037037037037037035}},
#                           'NOT_concept_empty_above': {'Ob_conc': {'conc': 0.9629629629629629, 'not_conc': 0.0}},
#                           'concept_empty_below': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}},
#                           'NOT_concept_empty_below': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}},
#                           'concept_empty_left': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}},
#                           'NOT_concept_empty_left': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}},
#                           'concept_empty_right': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.008333333333333333}},
#                           'NOT_concept_empty_right': {'Ob_conc': {'conc': 0.9916666666666667, 'not_conc': 0.0}},
#                           'concept_left_switch': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}},
#                           'NOT_concept_left_switch': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}},
#                           'concept_switch_on': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}},
#                           'NOT_concept_switch_on': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}},
#                           'concept_target_above': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0034965034965034965}},
#                           'NOT_concept_target_above': {'Ob_conc': {'conc': 0.9965034965034965, 'not_conc': 0.0}},
#                           'concept_target_below': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}},
#                           'NOT_concept_target_below': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}},
#                           'concept_target_left': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}},
#                           'NOT_concept_target_left': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}},
#                           'concept_target_right': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}},
#                           'NOT_concept_target_right': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}},
#                           'concept_wall_above': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}},
#                           'NOT_concept_wall_above': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}},
#                           'concept_wall_below': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}},
#                           'NOT_concept_wall_below': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}},
#                           'concept_wall_left': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}},
#                           'NOT_concept_wall_left': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}},
#                           'concept_wall_left_below_ofbox': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}},
#                           'NOT_concept_wall_left_below_ofbox': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}},
#                           'concept_wall_right': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}},
#                           'NOT_concept_wall_right': {'Ob_conc': {'conc': 1.0, 'not_conc': 0.0}}}


NEGATION_PREFIX = "NOT_"

#CONCEPT_SET_FOR_FLIP = set(['concept_above_switch','concept_box_above','concept_box_below','concept_box_left',
#                            'concept_box_right','concept_empty_above','concept_empty_below','concept_empty_left',
#                            'concept_empty_right','concept_left_switch','concept_switch_on','concept_target_above',
#                            'concept_target_below','concept_target_left','concept_target_right','concept_wall_above',
#                            'concept_wall_below','concept_wall_left_below_ofbox','concept_wall_left','concept_wall_right'])

CONCEPT_SET_FOR_FLIP = set(['concept_above_switch','concept_box_left',
                            'concept_box_right','concept_empty_above','concept_empty_below','concept_empty_left',
                            'concept_empty_right','concept_left_switch','concept_switch_on','concept_target_above',
                            'concept_target_below','concept_target_left','concept_target_right','concept_wall_above',
                            'concept_wall_below','concept_wall_left_below_ofbox','concept_wall_left','concept_wall_right'])




CONCEPT_SET_FOR_GRAVITY = set(['concept_blank_cell_below','concept_blank_cell_on_left','concept_box_below',
                                     'concept_box_on_left','concept_box_on_right','concept_box_on_top',
                                     'concept_no_pink_cell_below_m','concept_no_pink_cell_on_top_m',
                                     'concept_no_wall_below_m','concept_no_wall_on_left_m',
                                     'concept_no_wall_on_right_m','concept_no_wall_on_top_m',
                                     'concept_on_pink_cell','concept_pink_cell_below','concept_pink_cell_on_left',
                                     'concept_pink_cell_on_right','concept_pink_cell_on_top','concept_target_on_right',
                                     'concept_target_on_top','concept_wall_above_box','concept_wall_below_box',
                                     'concept_wall_below','concept_wall_down_left','concept_wall_down_right',
                                     'concept_wall_on_left_of_box','concept_wall_on_left','concept_wall_on_right_of_box',
                                     'concept_wall_on_right','concept_wall_on_top','concept_wall_top_left',
                                     'concept_wall_top_right','concept_wall_up_down_right'])


CONCEPT_PRIOR_FOR_GRAVITY = {1: {'NOT_concept_wall_down_right': 1.0, 'NOT_concept_wall_top_right': 1.0, 'NOT_concept_target_on_right': 1.0, 'NOT_concept_pink_cell_on_right': 0.8421052631578947, 'concept_no_pink_cell_on_top_m': 0.7894736842105263, 'concept_blank_cell_on_left': 0.5263157894736842, 'NOT_concept_wall_below_box': 1.0, 'concept_no_wall_on_right_m': 0.5263157894736842, 'NOT_concept_blank_cell_below': 0.3157894736842105, 'NOT_concept_wall_top_left': 1.0, 'NOT_concept_wall_on_top': 1.0, 'NOT_concept_wall_up_down_right': 1.0, 'NOT_concept_target_on_top': 1.0, 'NOT_concept_box_on_top': 1.0, 'NOT_concept_no_wall_below_m': 0.3684210526315789, 'NOT_concept_wall_on_right_of_box': 0.7894736842105263, 'NOT_concept_wall_above_box': 1.0, 'NOT_concept_on_pink_cell': 0.8421052631578947, 'NOT_concept_wall_on_left': 0.6842105263157895, 'NOT_concept_wall_on_left_of_box': 0.7368421052631579, 'NOT_concept_no_wall_on_left_m': 0.6842105263157895, 'concept_no_wall_on_top_m': 1.0, 'NOT_concept_box_below': 1.0, 'NOT_concept_wall_down_left': 0.9473684210526315, 'NOT_concept_pink_cell_on_left': 0.8421052631578947, 'NOT_concept_box_on_right': 1.0, 'NOT_concept_box_on_left': 1.0, 'NOT_concept_pink_cell_on_top': 0.8421052631578947, 'NOT_concept_wall_on_right': 0.7894736842105263, 'NOT_concept_no_pink_cell_below_m': 0.3157894736842105, 'NOT_concept_pink_cell_below': 0.8947368421052632, 'concept_wall_below': 0.21052631578947367, 'NOT_concept_no_pink_cell_on_top_m': 0.25, 'NOT_concept_wall_below': 0.8, 'NOT_concept_no_wall_on_right_m': 0.5, 'concept_blank_cell_below': 0.7, 'concept_no_pink_cell_below_m': 0.7, 'concept_on_pink_cell': 0.19047619047619047, 'concept_pink_cell_on_top': 0.19047619047619047, 'concept_no_wall_below_m': 0.6363636363636364, 'concept_pink_cell_below': 0.13636363636363635, 'concept_pink_cell_on_right': 0.16666666666666666, 'concept_pink_cell_on_left': 0.16666666666666666, 'concept_wall_top_right': 0.0, 'concept_box_below': 0.0, 'concept_box_on_right': 0.0, 'concept_no_wall_on_left_m': 0.3333333333333333, 'concept_wall_down_right': 0.0, 'concept_wall_top_left': 0.0, 'concept_target_on_right': 0.0, 'NOT_concept_no_wall_on_top_m': 0.0, 'concept_target_on_top': 0.0, 'concept_wall_down_left': 0.05555555555555555, 'concept_wall_on_left': 0.3333333333333333, 'concept_wall_up_down_right': 0.0, 'concept_wall_on_top': 0.0, 'concept_wall_above_box': 0.0, 'concept_wall_on_right_of_box': 0.2222222222222222, 'concept_box_on_left': 0.0, 'concept_wall_below_box': 0.0, 'concept_wall_on_right': 0.2222222222222222, 'NOT_concept_blank_cell_on_left': 0.5, 'concept_box_on_top': 0.0, 'concept_wall_on_left_of_box': 0.2777777777777778, 'concept_blank_cell_below_concept_pink_cell_on_right': 0.16666666666666666, 'concept_pink_cell_on_left_concept_pink_cell_on_right': 0.0, 'concept_pink_cell_on_right_concept_wall_top_right': 0.0, 'concept_box_below_concept_pink_cell_on_right': 0.0, 'NOT_concept_wall_down_right_concept_pink_cell_on_right': 0.16666666666666666, 'concept_box_on_right_concept_pink_cell_on_right': 0.0, 'NOT_concept_wall_on_left_of_box_concept_pink_cell_on_right': 0.05555555555555555, 'NOT_concept_wall_up_down_right_concept_pink_cell_on_right': 0.16666666666666666, 'concept_no_wall_on_left_m_concept_pink_cell_on_right': 0.0, 'concept_pink_cell_on_right_concept_wall_down_right': 0.0, 'NOT_concept_pink_cell_on_left_concept_pink_cell_on_right': 0.16666666666666666, 'NOT_concept_wall_below_box_concept_pink_cell_on_right': 0.16666666666666666, 'NOT_concept_wall_on_top_concept_pink_cell_on_right': 0.16666666666666666, 'NOT_concept_no_wall_on_right_m_concept_pink_cell_on_right': 0.0, 'NOT_concept_on_pink_cell_concept_pink_cell_on_right': 0.16666666666666666, 'NOT_concept_box_on_right_concept_pink_cell_on_right': 0.16666666666666666, 'concept_pink_cell_on_right_concept_wall_top_left': 0.0, 'concept_pink_cell_on_right_concept_target_on_right': 0.0, 'NOT_concept_blank_cell_below_concept_pink_cell_on_right': 0.0, 'concept_no_wall_on_right_m_concept_pink_cell_on_right': 0.16666666666666666, 'concept_pink_cell_on_right_concept_wall_below': 0.0, 'NOT_concept_no_wall_on_left_m_concept_pink_cell_on_right': 0.16666666666666666, 'NOT_concept_wall_top_left_concept_pink_cell_on_right': 0.16666666666666666, 'NOT_concept_box_below_concept_pink_cell_on_right': 0.16666666666666666, 'NOT_concept_wall_above_box_concept_pink_cell_on_right': 0.16666666666666666, 'concept_pink_cell_on_right_concept_pink_cell_on_top': 0.0, 'NOT_concept_no_pink_cell_on_top_m_concept_pink_cell_on_right': 0.0, 'NOT_concept_wall_on_right_of_box_concept_pink_cell_on_right': 0.16666666666666666, 'NOT_concept_no_wall_on_top_m_concept_pink_cell_on_right': 0.0, 'concept_on_pink_cell_concept_pink_cell_on_right': 0.0, 'concept_pink_cell_on_right_concept_target_on_top': 0.0, 'concept_pink_cell_on_right_concept_wall_down_left': 0.0, 'concept_pink_cell_on_right_concept_wall_on_left': 0.16666666666666666, 'NOT_concept_no_pink_cell_below_m_concept_pink_cell_on_right': 0.0, 'concept_pink_cell_on_right_concept_wall_up_down_right': 0.0, 'concept_pink_cell_on_right_concept_wall_on_top': 0.0, 'concept_pink_cell_on_right_concept_wall_above_box': 0.0, 'concept_pink_cell_on_right_concept_wall_on_right_of_box': 0.0, 'concept_box_on_left_concept_pink_cell_on_right': 0.0, 'concept_no_wall_on_top_m_concept_pink_cell_on_right': 0.16666666666666666, 'NOT_concept_pink_cell_on_top_concept_pink_cell_on_right': 0.16666666666666666, 'concept_no_pink_cell_on_top_m_concept_pink_cell_on_right': 0.16666666666666666, 'NOT_concept_no_wall_below_m_concept_pink_cell_on_right': 0.0, 'concept_pink_cell_on_right_concept_wall_below_box': 0.0, 'concept_pink_cell_on_right_concept_wall_on_right': 0.0, 'concept_pink_cell_below_concept_pink_cell_on_right': 0.0, 'NOT_concept_blank_cell_on_left_concept_pink_cell_on_right': 0.16666666666666666, 'NOT_concept_target_on_right_concept_pink_cell_on_right': 0.16666666666666666, 'concept_no_pink_cell_below_m_concept_pink_cell_on_right': 0.16666666666666666, 'NOT_concept_target_on_top_concept_pink_cell_on_right': 0.16666666666666666, 'NOT_concept_wall_top_right_concept_pink_cell_on_right': 0.16666666666666666, 'concept_box_on_top_concept_pink_cell_on_right': 0.0, 'concept_no_wall_below_m_concept_pink_cell_on_right': 0.16666666666666666, 'NOT_concept_wall_on_left_concept_pink_cell_on_right': 0.0, 'concept_pink_cell_on_right_concept_wall_on_left_of_box': 0.1111111111111111, 'NOT_concept_box_on_top_concept_pink_cell_on_right': 0.16666666666666666, 'concept_blank_cell_on_left_concept_pink_cell_on_right': 0.0, 'NOT_concept_wall_on_right_concept_pink_cell_on_right': 0.16666666666666666, 'NOT_concept_pink_cell_on_right_concept_pink_cell_on_right': 0.0, 'NOT_concept_box_on_left_concept_pink_cell_on_right': 0.16666666666666666, 'NOT_concept_wall_down_left_concept_pink_cell_on_right': 0.16666666666666666, 'NOT_concept_pink_cell_below_concept_pink_cell_on_right': 0.16666666666666666, 'NOT_concept_wall_below_concept_pink_cell_on_right': 0.16666666666666666, 'concept_blank_cell_below_concept_pink_cell_on_left': 0.16666666666666666, 'concept_blank_cell_below_concept_wall_top_right': 0.0, 'concept_blank_cell_below_concept_box_below': 0.0, 'NOT_concept_wall_down_right_concept_blank_cell_below': 0.7222222222222222, 'concept_blank_cell_below_concept_box_on_right': 0.0, 'NOT_concept_wall_on_left_of_box_concept_blank_cell_below': 0.5, 'NOT_concept_wall_up_down_right_concept_blank_cell_below': 0.7222222222222222, 'concept_blank_cell_below_concept_no_wall_on_left_m': 0.2777777777777778, 'concept_blank_cell_below_concept_wall_down_right': 0.0, 'NOT_concept_pink_cell_on_left_concept_blank_cell_below': 0.5555555555555556, 'NOT_concept_wall_below_box_concept_blank_cell_below': 0.7222222222222222, 'NOT_concept_wall_on_top_concept_blank_cell_below': 0.7222222222222222, 'NOT_concept_no_wall_on_right_m_concept_blank_cell_below': 0.4444444444444444, 'NOT_concept_on_pink_cell_concept_blank_cell_below': 0.6111111111111112, 'NOT_concept_box_on_right_concept_blank_cell_below': 0.7222222222222222, 'concept_blank_cell_below_concept_wall_top_left': 0.0, 'concept_blank_cell_below_concept_target_on_right': 0.0, 'NOT_concept_blank_cell_below_concept_blank_cell_below': 0.0, 'concept_blank_cell_below_concept_no_wall_on_right_m': 0.2777777777777778, 'concept_blank_cell_below_concept_wall_below': 0.0, 'NOT_concept_no_wall_on_left_m_concept_blank_cell_below': 0.4444444444444444, 'NOT_concept_wall_top_left_concept_blank_cell_below': 0.7222222222222222, 'NOT_concept_box_below_concept_blank_cell_below': 0.7222222222222222, 'NOT_concept_wall_above_box_concept_blank_cell_below': 0.7222222222222222, 'concept_blank_cell_below_concept_pink_cell_on_top': 0.1111111111111111, 'NOT_concept_no_pink_cell_on_top_m_concept_blank_cell_below': 0.16666666666666666, 'NOT_concept_wall_on_right_of_box_concept_blank_cell_below': 0.5555555555555556, 'NOT_concept_no_wall_on_top_m_concept_blank_cell_below': 0.0, 'concept_blank_cell_below_concept_on_pink_cell': 0.1111111111111111, 'concept_blank_cell_below_concept_target_on_top': 0.0, 'concept_blank_cell_below_concept_wall_down_left': 0.0, 'concept_blank_cell_below_concept_wall_on_left': 0.2777777777777778, 'NOT_concept_no_pink_cell_below_m_concept_blank_cell_below': 0.0, 'concept_blank_cell_below_concept_wall_up_down_right': 0.0, 'concept_blank_cell_below_concept_wall_on_top': 0.0, 'concept_blank_cell_below_concept_wall_above_box': 0.0, 'concept_blank_cell_below_concept_wall_on_right_of_box': 0.16666666666666666, 'concept_blank_cell_below_concept_box_on_left': 0.0, 'concept_blank_cell_below_concept_no_wall_on_top_m': 0.7222222222222222, 'NOT_concept_pink_cell_on_top_concept_blank_cell_below': 0.6111111111111112, 'concept_blank_cell_below_concept_no_pink_cell_on_top_m': 0.5555555555555556, 'NOT_concept_no_wall_below_m_concept_blank_cell_below': 0.16666666666666666, 'concept_blank_cell_below_concept_wall_below_box': 0.0, 'concept_blank_cell_below_concept_wall_on_right': 0.2222222222222222, 'concept_blank_cell_below_concept_pink_cell_below': 0.0, 'NOT_concept_blank_cell_on_left_concept_blank_cell_below': 0.4444444444444444, 'NOT_concept_target_on_right_concept_blank_cell_below': 0.7222222222222222, 'concept_blank_cell_below_concept_no_pink_cell_below_m': 0.7222222222222222, 'NOT_concept_target_on_top_concept_blank_cell_below': 0.7222222222222222, 'NOT_concept_wall_top_right_concept_blank_cell_below': 0.7222222222222222, 'concept_blank_cell_below_concept_box_on_top': 0.0, 'concept_blank_cell_below_concept_no_wall_below_m': 0.5555555555555556, 'NOT_concept_wall_on_left_concept_blank_cell_below': 0.4444444444444444, 'concept_blank_cell_below_concept_wall_on_left_of_box': 0.2222222222222222, 'NOT_concept_box_on_top_concept_blank_cell_below': 0.7222222222222222, 'concept_blank_cell_below_concept_blank_cell_on_left': 0.2777777777777778, 'NOT_concept_wall_on_right_concept_blank_cell_below': 0.5, 'NOT_concept_pink_cell_on_right_concept_blank_cell_below': 0.5555555555555556, 'NOT_concept_box_on_left_concept_blank_cell_below': 0.7222222222222222, 'NOT_concept_wall_down_left_concept_blank_cell_below': 0.7222222222222222, 'NOT_concept_pink_cell_below_concept_blank_cell_below': 0.7222222222222222, 'NOT_concept_wall_below_concept_blank_cell_below': 0.7222222222222222, 'concept_pink_cell_on_left_concept_wall_top_right': 0.0, 'concept_box_below_concept_pink_cell_on_left': 0.0, 'NOT_concept_wall_down_right_concept_pink_cell_on_left': 0.16666666666666666, 'concept_box_on_right_concept_pink_cell_on_left': 0.0, 'NOT_concept_wall_on_left_of_box_concept_pink_cell_on_left': 0.16666666666666666, 'NOT_concept_wall_up_down_right_concept_pink_cell_on_left': 0.16666666666666666, 'concept_no_wall_on_left_m_concept_pink_cell_on_left': 0.16666666666666666, 'concept_pink_cell_on_left_concept_wall_down_right': 0.0, 'NOT_concept_pink_cell_on_left_concept_pink_cell_on_left': 0.0, 'NOT_concept_wall_below_box_concept_pink_cell_on_left': 0.16666666666666666, 'NOT_concept_wall_on_top_concept_pink_cell_on_left': 0.16666666666666666, 'NOT_concept_no_wall_on_right_m_concept_pink_cell_on_left': 0.16666666666666666, 'NOT_concept_on_pink_cell_concept_pink_cell_on_left': 0.16666666666666666, 'NOT_concept_box_on_right_concept_pink_cell_on_left': 0.16666666666666666, 'concept_pink_cell_on_left_concept_wall_top_left': 0.0, 'concept_pink_cell_on_left_concept_target_on_right': 0.0, 'NOT_concept_blank_cell_below_concept_pink_cell_on_left': 0.0, 'concept_no_wall_on_right_m_concept_pink_cell_on_left': 0.0, 'concept_pink_cell_on_left_concept_wall_below': 0.0, 'NOT_concept_no_wall_on_left_m_concept_pink_cell_on_left': 0.0, 'NOT_concept_wall_top_left_concept_pink_cell_on_left': 0.16666666666666666, 'NOT_concept_box_below_concept_pink_cell_on_left': 0.16666666666666666, 'NOT_concept_wall_above_box_concept_pink_cell_on_left': 0.16666666666666666, 'concept_pink_cell_on_left_concept_pink_cell_on_top': 0.0, 'NOT_concept_no_pink_cell_on_top_m_concept_pink_cell_on_left': 0.0, 'NOT_concept_wall_on_right_of_box_concept_pink_cell_on_left': 0.1111111111111111, 'NOT_concept_no_wall_on_top_m_concept_pink_cell_on_left': 0.0, 'concept_on_pink_cell_concept_pink_cell_on_left': 0.0, 'concept_pink_cell_on_left_concept_target_on_top': 0.0, 'concept_pink_cell_on_left_concept_wall_down_left': 0.0, 'concept_pink_cell_on_left_concept_wall_on_left': 0.0, 'NOT_concept_no_pink_cell_below_m_concept_pink_cell_on_left': 0.0, 'concept_pink_cell_on_left_concept_wall_up_down_right': 0.0, 'concept_pink_cell_on_left_concept_wall_on_top': 0.0, 'concept_pink_cell_on_left_concept_wall_above_box': 0.0, 'concept_pink_cell_on_left_concept_wall_on_right_of_box': 0.05555555555555555, 'concept_box_on_left_concept_pink_cell_on_left': 0.0, 'concept_no_wall_on_top_m_concept_pink_cell_on_left': 0.16666666666666666, 'NOT_concept_pink_cell_on_top_concept_pink_cell_on_left': 0.16666666666666666, 'concept_no_pink_cell_on_top_m_concept_pink_cell_on_left': 0.16666666666666666, 'NOT_concept_no_wall_below_m_concept_pink_cell_on_left': 0.0, 'concept_pink_cell_on_left_concept_wall_below_box': 0.0, 'concept_pink_cell_on_left_concept_wall_on_right': 0.1111111111111111, 'concept_pink_cell_below_concept_pink_cell_on_left': 0.0, 'NOT_concept_blank_cell_on_left_concept_pink_cell_on_left': 0.16666666666666666, 'NOT_concept_target_on_right_concept_pink_cell_on_left': 0.16666666666666666, 'concept_no_pink_cell_below_m_concept_pink_cell_on_left': 0.16666666666666666, 'NOT_concept_target_on_top_concept_pink_cell_on_left': 0.16666666666666666, 'NOT_concept_wall_top_right_concept_pink_cell_on_left': 0.16666666666666666, 'concept_box_on_top_concept_pink_cell_on_left': 0.0, 'concept_no_wall_below_m_concept_pink_cell_on_left': 0.16666666666666666, 'NOT_concept_wall_on_left_concept_pink_cell_on_left': 0.16666666666666666, 'concept_pink_cell_on_left_concept_wall_on_left_of_box': 0.0, 'NOT_concept_box_on_top_concept_pink_cell_on_left': 0.16666666666666666, 'concept_blank_cell_on_left_concept_pink_cell_on_left': 0.0, 'NOT_concept_wall_on_right_concept_pink_cell_on_left': 0.05555555555555555, 'NOT_concept_pink_cell_on_right_concept_pink_cell_on_left': 0.16666666666666666, 'NOT_concept_box_on_left_concept_pink_cell_on_left': 0.16666666666666666, 'NOT_concept_wall_down_left_concept_pink_cell_on_left': 0.16666666666666666, 'NOT_concept_pink_cell_below_concept_pink_cell_on_left': 0.16666666666666666, 'NOT_concept_wall_below_concept_pink_cell_on_left': 0.16666666666666666, 'concept_box_below_concept_wall_top_right': 0.0, 'NOT_concept_wall_down_right_concept_wall_top_right': 0.0, 'concept_box_on_right_concept_wall_top_right': 0.0, 'NOT_concept_wall_on_left_of_box_concept_wall_top_right': 0.0, 'NOT_concept_wall_up_down_right_concept_wall_top_right': 0.0, 'concept_no_wall_on_left_m_concept_wall_top_right': 0.0, 'concept_wall_down_right_concept_wall_top_right': 0.0, 'NOT_concept_pink_cell_on_left_concept_wall_top_right': 0.0, 'NOT_concept_wall_below_box_concept_wall_top_right': 0.0, 'NOT_concept_wall_on_top_concept_wall_top_right': 0.0, 'NOT_concept_no_wall_on_right_m_concept_wall_top_right': 0.0, 'NOT_concept_on_pink_cell_concept_wall_top_right': 0.0, 'NOT_concept_box_on_right_concept_wall_top_right': 0.0, 'concept_wall_top_left_concept_wall_top_right': 0.0, 'concept_target_on_right_concept_wall_top_right': 0.0, 'NOT_concept_blank_cell_below_concept_wall_top_right': 0.0, 'concept_no_wall_on_right_m_concept_wall_top_right': 0.0, 'concept_wall_below_concept_wall_top_right': 0.0, 'NOT_concept_no_wall_on_left_m_concept_wall_top_right': 0.0, 'NOT_concept_wall_top_left_concept_wall_top_right': 0.0, 'NOT_concept_box_below_concept_wall_top_right': 0.0, 'NOT_concept_wall_above_box_concept_wall_top_right': 0.0, 'concept_pink_cell_on_top_concept_wall_top_right': 0.0, 'NOT_concept_no_pink_cell_on_top_m_concept_wall_top_right': 0.0, 'NOT_concept_wall_on_right_of_box_concept_wall_top_right': 0.0, 'NOT_concept_no_wall_on_top_m_concept_wall_top_right': 0.0, 'concept_on_pink_cell_concept_wall_top_right': 0.0, 'concept_target_on_top_concept_wall_top_right': 0.0, 'concept_wall_down_left_concept_wall_top_right': 0.0, 'concept_wall_on_left_concept_wall_top_right': 0.0, 'NOT_concept_no_pink_cell_below_m_concept_wall_top_right': 0.0, 'concept_wall_top_right_concept_wall_up_down_right': 0.0, 'concept_wall_on_top_concept_wall_top_right': 0.0, 'concept_wall_above_box_concept_wall_top_right': 0.0, 'concept_wall_on_right_of_box_concept_wall_top_right': 0.0, 'concept_box_on_left_concept_wall_top_right': 0.0, 'concept_no_wall_on_top_m_concept_wall_top_right': 0.0, 'NOT_concept_pink_cell_on_top_concept_wall_top_right': 0.0, 'concept_no_pink_cell_on_top_m_concept_wall_top_right': 0.0, 'NOT_concept_no_wall_below_m_concept_wall_top_right': 0.0, 'concept_wall_below_box_concept_wall_top_right': 0.0, 'concept_wall_on_right_concept_wall_top_right': 0.0, 'concept_pink_cell_below_concept_wall_top_right': 0.0, 'NOT_concept_blank_cell_on_left_concept_wall_top_right': 0.0, 'NOT_concept_target_on_right_concept_wall_top_right': 0.0, 'concept_no_pink_cell_below_m_concept_wall_top_right': 0.0, 'NOT_concept_target_on_top_concept_wall_top_right': 0.0, 'NOT_concept_wall_top_right_concept_wall_top_right': 0.0, 'concept_box_on_top_concept_wall_top_right': 0.0, 'concept_no_wall_below_m_concept_wall_top_right': 0.0, 'NOT_concept_wall_on_left_concept_wall_top_right': 0.0, 'concept_wall_on_left_of_box_concept_wall_top_right': 0.0, 'NOT_concept_box_on_top_concept_wall_top_right': 0.0, 'concept_blank_cell_on_left_concept_wall_top_right': 0.0, 'NOT_concept_wall_on_right_concept_wall_top_right': 0.0, 'NOT_concept_pink_cell_on_right_concept_wall_top_right': 0.0, 'NOT_concept_box_on_left_concept_wall_top_right': 0.0, 'NOT_concept_wall_down_left_concept_wall_top_right': 0.0, 'NOT_concept_pink_cell_below_concept_wall_top_right': 0.0, 'NOT_concept_wall_below_concept_wall_top_right': 0.0, 'NOT_concept_wall_down_right_concept_box_below': 0.0, 'concept_box_below_concept_box_on_right': 0.0, 'NOT_concept_wall_on_left_of_box_concept_box_below': 0.0, 'NOT_concept_wall_up_down_right_concept_box_below': 0.0, 'concept_box_below_concept_no_wall_on_left_m': 0.0, 'concept_box_below_concept_wall_down_right': 0.0, 'NOT_concept_pink_cell_on_left_concept_box_below': 0.0, 'NOT_concept_wall_below_box_concept_box_below': 0.0, 'NOT_concept_wall_on_top_concept_box_below': 0.0, 'NOT_concept_no_wall_on_right_m_concept_box_below': 0.0, 'NOT_concept_on_pink_cell_concept_box_below': 0.0, 'NOT_concept_box_on_right_concept_box_below': 0.0, 'concept_box_below_concept_wall_top_left': 0.0, 'concept_box_below_concept_target_on_right': 0.0, 'NOT_concept_blank_cell_below_concept_box_below': 0.0, 'concept_box_below_concept_no_wall_on_right_m': 0.0, 'concept_box_below_concept_wall_below': 0.0, 'NOT_concept_no_wall_on_left_m_concept_box_below': 0.0, 'NOT_concept_wall_top_left_concept_box_below': 0.0, 'NOT_concept_box_below_concept_box_below': 0.0, 'NOT_concept_wall_above_box_concept_box_below': 0.0, 'concept_box_below_concept_pink_cell_on_top': 0.0, 'NOT_concept_no_pink_cell_on_top_m_concept_box_below': 0.0, 'NOT_concept_wall_on_right_of_box_concept_box_below': 0.0, 'NOT_concept_no_wall_on_top_m_concept_box_below': 0.0, 'concept_box_below_concept_on_pink_cell': 0.0, 'concept_box_below_concept_target_on_top': 0.0, 'concept_box_below_concept_wall_down_left': 0.0, 'concept_box_below_concept_wall_on_left': 0.0, 'NOT_concept_no_pink_cell_below_m_concept_box_below': 0.0, 'concept_box_below_concept_wall_up_down_right': 0.0, 'concept_box_below_concept_wall_on_top': 0.0, 'concept_box_below_concept_wall_above_box': 0.0, 'concept_box_below_concept_wall_on_right_of_box': 0.0, 'concept_box_below_concept_box_on_left': 0.0, 'concept_box_below_concept_no_wall_on_top_m': 0.0, 'NOT_concept_pink_cell_on_top_concept_box_below': 0.0, 'concept_box_below_concept_no_pink_cell_on_top_m': 0.0, 'NOT_concept_no_wall_below_m_concept_box_below': 0.0, 'concept_box_below_concept_wall_below_box': 0.0, 'concept_box_below_concept_wall_on_right': 0.0, 'concept_box_below_concept_pink_cell_below': 0.0, 'NOT_concept_blank_cell_on_left_concept_box_below': 0.0, 'NOT_concept_target_on_right_concept_box_below': 0.0, 'concept_box_below_concept_no_pink_cell_below_m': 0.0, 'NOT_concept_target_on_top_concept_box_below': 0.0, 'NOT_concept_wall_top_right_concept_box_below': 0.0, 'concept_box_below_concept_box_on_top': 0.0, 'concept_box_below_concept_no_wall_below_m': 0.0, 'NOT_concept_wall_on_left_concept_box_below': 0.0, 'concept_box_below_concept_wall_on_left_of_box': 0.0, 'NOT_concept_box_on_top_concept_box_below': 0.0, 'concept_blank_cell_on_left_concept_box_below': 0.0, 'NOT_concept_wall_on_right_concept_box_below': 0.0, 'NOT_concept_pink_cell_on_right_concept_box_below': 0.0, 'NOT_concept_box_on_left_concept_box_below': 0.0, 'NOT_concept_wall_down_left_concept_box_below': 0.0, 'NOT_concept_pink_cell_below_concept_box_below': 0.0, 'NOT_concept_wall_below_concept_box_below': 0.0, 'NOT_concept_wall_down_right_concept_box_on_right': 0.0, 'NOT_concept_wall_down_right_NOT_concept_wall_on_left_of_box': 0.7222222222222222, 'NOT_concept_wall_down_right_NOT_concept_wall_up_down_right': 1.0, 'NOT_concept_wall_down_right_concept_no_wall_on_left_m': 0.3333333333333333, 'NOT_concept_wall_down_right_concept_wall_down_right': 0.0, 'NOT_concept_pink_cell_on_left_NOT_concept_wall_down_right': 0.8333333333333334, 'NOT_concept_wall_below_box_NOT_concept_wall_down_right': 1.0, 'NOT_concept_wall_down_right_NOT_concept_wall_on_top': 1.0, 'NOT_concept_no_wall_on_right_m_NOT_concept_wall_down_right': 0.5, 'NOT_concept_on_pink_cell_NOT_concept_wall_down_right': 0.8333333333333334, 'NOT_concept_box_on_right_NOT_concept_wall_down_right': 1.0, 'NOT_concept_wall_down_right_concept_wall_top_left': 0.0, 'NOT_concept_wall_down_right_concept_target_on_right': 0.0, 'NOT_concept_blank_cell_below_NOT_concept_wall_down_right': 0.2777777777777778, 'NOT_concept_wall_down_right_concept_no_wall_on_right_m': 0.5, 'NOT_concept_wall_down_right_concept_wall_below': 0.16666666666666666, 'NOT_concept_no_wall_on_left_m_NOT_concept_wall_down_right': 0.6666666666666666, 'NOT_concept_wall_down_right_NOT_concept_wall_top_left': 1.0, 'NOT_concept_box_below_NOT_concept_wall_down_right': 1.0, 'NOT_concept_wall_above_box_NOT_concept_wall_down_right': 1.0, 'NOT_concept_wall_down_right_concept_pink_cell_on_top': 0.16666666666666666, 'NOT_concept_no_pink_cell_on_top_m_NOT_concept_wall_down_right': 0.2222222222222222, 'NOT_concept_wall_down_right_NOT_concept_wall_on_right_of_box': 0.7777777777777778, 'NOT_concept_no_wall_on_top_m_NOT_concept_wall_down_right': 0.0, 'NOT_concept_wall_down_right_concept_on_pink_cell': 0.16666666666666666, 'NOT_concept_wall_down_right_concept_target_on_top': 0.0, 'NOT_concept_wall_down_right_concept_wall_down_left': 0.05555555555555555, 'NOT_concept_wall_down_right_concept_wall_on_left': 0.3333333333333333, 'NOT_concept_no_pink_cell_below_m_NOT_concept_wall_down_right': 0.2777777777777778, 'NOT_concept_wall_down_right_concept_wall_up_down_right': 0.0, 'NOT_concept_wall_down_right_concept_wall_on_top': 0.0, 'NOT_concept_wall_down_right_concept_wall_above_box': 0.0, 'NOT_concept_wall_down_right_concept_wall_on_right_of_box': 0.2222222222222222, 'NOT_concept_wall_down_right_concept_box_on_left': 0.0, 'NOT_concept_wall_down_right_concept_no_wall_on_top_m': 1.0, 'NOT_concept_pink_cell_on_top_NOT_concept_wall_down_right': 0.8333333333333334, 'NOT_concept_wall_down_right_concept_no_pink_cell_on_top_m': 0.7777777777777778, 'NOT_concept_no_wall_below_m_NOT_concept_wall_down_right': 0.3333333333333333, 'NOT_concept_wall_down_right_concept_wall_below_box': 0.0, 'NOT_concept_wall_down_right_concept_wall_on_right': 0.2222222222222222, 'NOT_concept_wall_down_right_concept_pink_cell_below': 0.1111111111111111, 'NOT_concept_blank_cell_on_left_NOT_concept_wall_down_right': 0.5, 'NOT_concept_target_on_right_NOT_concept_wall_down_right': 1.0, 'NOT_concept_wall_down_right_concept_no_pink_cell_below_m': 0.7222222222222222, 'NOT_concept_target_on_top_NOT_concept_wall_down_right': 1.0, 'NOT_concept_wall_down_right_NOT_concept_wall_top_right': 1.0, 'NOT_concept_wall_down_right_concept_box_on_top': 0.0, 'NOT_concept_wall_down_right_concept_no_wall_below_m': 0.6666666666666666, 'NOT_concept_wall_down_right_NOT_concept_wall_on_left': 0.6666666666666666, 'NOT_concept_wall_down_right_concept_wall_on_left_of_box': 0.2777777777777778, 'NOT_concept_box_on_top_NOT_concept_wall_down_right': 1.0, 'NOT_concept_wall_down_right_concept_blank_cell_on_left': 0.5, 'NOT_concept_wall_down_right_NOT_concept_wall_on_right': 0.7777777777777778, 'NOT_concept_pink_cell_on_right_NOT_concept_wall_down_right': 0.8333333333333334, 'NOT_concept_box_on_left_NOT_concept_wall_down_right': 1.0, 'NOT_concept_wall_down_left_NOT_concept_wall_down_right': 0.9444444444444444, 'NOT_concept_pink_cell_below_NOT_concept_wall_down_right': 0.8888888888888888, 'NOT_concept_wall_below_NOT_concept_wall_down_right': 0.8333333333333334, 'NOT_concept_wall_on_left_of_box_concept_box_on_right': 0.0, 'NOT_concept_wall_up_down_right_concept_box_on_right': 0.0, 'concept_box_on_right_concept_no_wall_on_left_m': 0.0, 'concept_box_on_right_concept_wall_down_right': 0.0, 'NOT_concept_pink_cell_on_left_concept_box_on_right': 0.0, 'NOT_concept_wall_below_box_concept_box_on_right': 0.0, 'NOT_concept_wall_on_top_concept_box_on_right': 0.0, 'NOT_concept_no_wall_on_right_m_concept_box_on_right': 0.0, 'NOT_concept_on_pink_cell_concept_box_on_right': 0.0, 'NOT_concept_box_on_right_concept_box_on_right': 0.0, 'concept_box_on_right_concept_wall_top_left': 0.0, 'concept_box_on_right_concept_target_on_right': 0.0, 'NOT_concept_blank_cell_below_concept_box_on_right': 0.0, 'concept_box_on_right_concept_no_wall_on_right_m': 0.0, 'concept_box_on_right_concept_wall_below': 0.0, 'NOT_concept_no_wall_on_left_m_concept_box_on_right': 0.0, 'NOT_concept_wall_top_left_concept_box_on_right': 0.0, 'NOT_concept_box_below_concept_box_on_right': 0.0, 'NOT_concept_wall_above_box_concept_box_on_right': 0.0, 'concept_box_on_right_concept_pink_cell_on_top': 0.0, 'NOT_concept_no_pink_cell_on_top_m_concept_box_on_right': 0.0, 'NOT_concept_wall_on_right_of_box_concept_box_on_right': 0.0, 'NOT_concept_no_wall_on_top_m_concept_box_on_right': 0.0, 'concept_box_on_right_concept_on_pink_cell': 0.0, 'concept_box_on_right_concept_target_on_top': 0.0, 'concept_box_on_right_concept_wall_down_left': 0.0, 'concept_box_on_right_concept_wall_on_left': 0.0, 'NOT_concept_no_pink_cell_below_m_concept_box_on_right': 0.0, 'concept_box_on_right_concept_wall_up_down_right': 0.0, 'concept_box_on_right_concept_wall_on_top': 0.0, 'concept_box_on_right_concept_wall_above_box': 0.0, 'concept_box_on_right_concept_wall_on_right_of_box': 0.0, 'concept_box_on_left_concept_box_on_right': 0.0, 'concept_box_on_right_concept_no_wall_on_top_m': 0.0, 'NOT_concept_pink_cell_on_top_concept_box_on_right': 0.0, 'concept_box_on_right_concept_no_pink_cell_on_top_m': 0.0, 'NOT_concept_no_wall_below_m_concept_box_on_right': 0.0, 'concept_box_on_right_concept_wall_below_box': 0.0, 'concept_box_on_right_concept_wall_on_right': 0.0, 'concept_box_on_right_concept_pink_cell_below': 0.0, 'NOT_concept_blank_cell_on_left_concept_box_on_right': 0.0, 'NOT_concept_target_on_right_concept_box_on_right': 0.0, 'concept_box_on_right_concept_no_pink_cell_below_m': 0.0, 'NOT_concept_target_on_top_concept_box_on_right': 0.0, 'NOT_concept_wall_top_right_concept_box_on_right': 0.0, 'concept_box_on_right_concept_box_on_top': 0.0, 'concept_box_on_right_concept_no_wall_below_m': 0.0, 'NOT_concept_wall_on_left_concept_box_on_right': 0.0, 'concept_box_on_right_concept_wall_on_left_of_box': 0.0, 'NOT_concept_box_on_top_concept_box_on_right': 0.0, 'concept_blank_cell_on_left_concept_box_on_right': 0.0, 'NOT_concept_wall_on_right_concept_box_on_right': 0.0, 'NOT_concept_pink_cell_on_right_concept_box_on_right': 0.0, 'NOT_concept_box_on_left_concept_box_on_right': 0.0, 'NOT_concept_wall_down_left_concept_box_on_right': 0.0, 'NOT_concept_pink_cell_below_concept_box_on_right': 0.0, 'NOT_concept_wall_below_concept_box_on_right': 0.0, 'NOT_concept_wall_on_left_of_box_NOT_concept_wall_up_down_right': 0.7222222222222222, 'NOT_concept_wall_on_left_of_box_concept_no_wall_on_left_m': 0.3333333333333333, 'NOT_concept_wall_on_left_of_box_concept_wall_down_right': 0.0, 'NOT_concept_pink_cell_on_left_NOT_concept_wall_on_left_of_box': 0.5555555555555556, 'NOT_concept_wall_below_box_NOT_concept_wall_on_left_of_box': 0.7222222222222222, 'NOT_concept_wall_on_left_of_box_NOT_concept_wall_on_top': 0.7222222222222222, 'NOT_concept_no_wall_on_right_m_NOT_concept_wall_on_left_of_box': 0.5, 'NOT_concept_on_pink_cell_NOT_concept_wall_on_left_of_box': 0.5555555555555556, 'NOT_concept_box_on_right_NOT_concept_wall_on_left_of_box': 0.7222222222222222, 'NOT_concept_wall_on_left_of_box_concept_wall_top_left': 0.0, 'NOT_concept_wall_on_left_of_box_concept_target_on_right': 0.0, 'NOT_concept_blank_cell_below_NOT_concept_wall_on_left_of_box': 0.2222222222222222, 'NOT_concept_wall_on_left_of_box_concept_no_wall_on_right_m': 0.2222222222222222, 'NOT_concept_wall_on_left_of_box_concept_wall_below': 0.1111111111111111, 'NOT_concept_no_wall_on_left_m_NOT_concept_wall_on_left_of_box': 0.3888888888888889, 'NOT_concept_wall_on_left_of_box_NOT_concept_wall_top_left': 0.7222222222222222, 'NOT_concept_box_below_NOT_concept_wall_on_left_of_box': 0.7222222222222222, 'NOT_concept_wall_above_box_NOT_concept_wall_on_left_of_box': 0.7222222222222222, 'NOT_concept_wall_on_left_of_box_concept_pink_cell_on_top': 0.16666666666666666, 'NOT_concept_no_pink_cell_on_top_m_NOT_concept_wall_on_left_of_box': 0.2222222222222222, 'NOT_concept_wall_on_left_of_box_NOT_concept_wall_on_right_of_box': 0.5, 'NOT_concept_no_wall_on_top_m_NOT_concept_wall_on_left_of_box': 0.0, 'NOT_concept_wall_on_left_of_box_concept_on_pink_cell': 0.16666666666666666, 'NOT_concept_wall_on_left_of_box_concept_target_on_top': 0.0, 'NOT_concept_wall_on_left_of_box_concept_wall_down_left': 0.0, 'NOT_concept_wall_on_left_of_box_concept_wall_on_left': 0.05555555555555555, 'NOT_concept_no_pink_cell_below_m_NOT_concept_wall_on_left_of_box': 0.2222222222222222, 'NOT_concept_wall_on_left_of_box_concept_wall_up_down_right': 0.0, 'NOT_concept_wall_on_left_of_box_concept_wall_on_top': 0.0, 'NOT_concept_wall_on_left_of_box_concept_wall_above_box': 0.0, 'NOT_concept_wall_on_left_of_box_concept_wall_on_right_of_box': 0.2222222222222222, 'NOT_concept_wall_on_left_of_box_concept_box_on_left': 0.0, 'NOT_concept_wall_on_left_of_box_concept_no_wall_on_top_m': 0.7222222222222222, 'NOT_concept_pink_cell_on_top_NOT_concept_wall_on_left_of_box': 0.5555555555555556, 'NOT_concept_wall_on_left_of_box_concept_no_pink_cell_on_top_m': 0.5, 'NOT_concept_no_wall_below_m_NOT_concept_wall_on_left_of_box': 0.2222222222222222, 'NOT_concept_wall_on_left_of_box_concept_wall_below_box': 0.0, 'NOT_concept_wall_on_left_of_box_concept_wall_on_right': 0.2222222222222222, 'NOT_concept_wall_on_left_of_box_concept_pink_cell_below': 0.1111111111111111, 'NOT_concept_blank_cell_on_left_NOT_concept_wall_on_left_of_box': 0.2222222222222222, 'NOT_concept_target_on_right_NOT_concept_wall_on_left_of_box': 0.7222222222222222, 'NOT_concept_wall_on_left_of_box_concept_no_pink_cell_below_m': 0.5, 'NOT_concept_target_on_top_NOT_concept_wall_on_left_of_box': 0.7222222222222222, 'NOT_concept_wall_on_left_of_box_NOT_concept_wall_top_right': 0.7222222222222222, 'NOT_concept_wall_on_left_of_box_concept_box_on_top': 0.0, 'NOT_concept_wall_on_left_of_box_concept_no_wall_below_m': 0.5, 'NOT_concept_wall_on_left_NOT_concept_wall_on_left_of_box': 0.6666666666666666, 'NOT_concept_wall_on_left_of_box_concept_wall_on_left_of_box': 0.0, 'NOT_concept_box_on_top_NOT_concept_wall_on_left_of_box': 0.7222222222222222, 'NOT_concept_wall_on_left_of_box_concept_blank_cell_on_left': 0.5, 'NOT_concept_wall_on_left_of_box_NOT_concept_wall_on_right': 0.5, 'NOT_concept_pink_cell_on_right_NOT_concept_wall_on_left_of_box': 0.6666666666666666, 'NOT_concept_box_on_left_NOT_concept_wall_on_left_of_box': 0.7222222222222222, 'NOT_concept_wall_down_left_NOT_concept_wall_on_left_of_box': 0.7222222222222222, 'NOT_concept_pink_cell_below_NOT_concept_wall_on_left_of_box': 0.6111111111111112, 'NOT_concept_wall_below_NOT_concept_wall_on_left_of_box': 0.6111111111111112, 'NOT_concept_wall_up_down_right_concept_no_wall_on_left_m': 0.3333333333333333, 'NOT_concept_wall_up_down_right_concept_wall_down_right': 0.0, 'NOT_concept_pink_cell_on_left_NOT_concept_wall_up_down_right': 0.8333333333333334, 'NOT_concept_wall_below_box_NOT_concept_wall_up_down_right': 1.0, 'NOT_concept_wall_on_top_NOT_concept_wall_up_down_right': 1.0, 'NOT_concept_no_wall_on_right_m_NOT_concept_wall_up_down_right': 0.5, 'NOT_concept_on_pink_cell_NOT_concept_wall_up_down_right': 0.8333333333333334, 'NOT_concept_box_on_right_NOT_concept_wall_up_down_right': 1.0, 'NOT_concept_wall_up_down_right_concept_wall_top_left': 0.0, 'NOT_concept_wall_up_down_right_concept_target_on_right': 0.0, 'NOT_concept_blank_cell_below_NOT_concept_wall_up_down_right': 0.2777777777777778, 'NOT_concept_wall_up_down_right_concept_no_wall_on_right_m': 0.5, 'NOT_concept_wall_up_down_right_concept_wall_below': 0.16666666666666666, 'NOT_concept_no_wall_on_left_m_NOT_concept_wall_up_down_right': 0.6666666666666666, 'NOT_concept_wall_top_left_NOT_concept_wall_up_down_right': 1.0, 'NOT_concept_box_below_NOT_concept_wall_up_down_right': 1.0, 'NOT_concept_wall_above_box_NOT_concept_wall_up_down_right': 1.0, 'NOT_concept_wall_up_down_right_concept_pink_cell_on_top': 0.16666666666666666, 'NOT_concept_no_pink_cell_on_top_m_NOT_concept_wall_up_down_right': 0.2222222222222222, 'NOT_concept_wall_on_right_of_box_NOT_concept_wall_up_down_right': 0.7777777777777778, 'NOT_concept_no_wall_on_top_m_NOT_concept_wall_up_down_right': 0.0, 'NOT_concept_wall_up_down_right_concept_on_pink_cell': 0.16666666666666666, 'NOT_concept_wall_up_down_right_concept_target_on_top': 0.0, 'NOT_concept_wall_up_down_right_concept_wall_down_left': 0.05555555555555555, 'NOT_concept_wall_up_down_right_concept_wall_on_left': 0.3333333333333333, 'NOT_concept_no_pink_cell_below_m_NOT_concept_wall_up_down_right': 0.2777777777777778, 'NOT_concept_wall_up_down_right_concept_wall_up_down_right': 0.0, 'NOT_concept_wall_up_down_right_concept_wall_on_top': 0.0, 'NOT_concept_wall_up_down_right_concept_wall_above_box': 0.0, 'NOT_concept_wall_up_down_right_concept_wall_on_right_of_box': 0.2222222222222222, 'NOT_concept_wall_up_down_right_concept_box_on_left': 0.0, 'NOT_concept_wall_up_down_right_concept_no_wall_on_top_m': 1.0, 'NOT_concept_pink_cell_on_top_NOT_concept_wall_up_down_right': 0.8333333333333334, 'NOT_concept_wall_up_down_right_concept_no_pink_cell_on_top_m': 0.7777777777777778, 'NOT_concept_no_wall_below_m_NOT_concept_wall_up_down_right': 0.3333333333333333, 'NOT_concept_wall_up_down_right_concept_wall_below_box': 0.0, 'NOT_concept_wall_up_down_right_concept_wall_on_right': 0.2222222222222222, 'NOT_concept_wall_up_down_right_concept_pink_cell_below': 0.1111111111111111, 'NOT_concept_blank_cell_on_left_NOT_concept_wall_up_down_right': 0.5, 'NOT_concept_target_on_right_NOT_concept_wall_up_down_right': 1.0, 'NOT_concept_wall_up_down_right_concept_no_pink_cell_below_m': 0.7222222222222222, 'NOT_concept_target_on_top_NOT_concept_wall_up_down_right': 1.0, 'NOT_concept_wall_top_right_NOT_concept_wall_up_down_right': 1.0, 'NOT_concept_wall_up_down_right_concept_box_on_top': 0.0, 'NOT_concept_wall_up_down_right_concept_no_wall_below_m': 0.6666666666666666, 'NOT_concept_wall_on_left_NOT_concept_wall_up_down_right': 0.6666666666666666, 'NOT_concept_wall_up_down_right_concept_wall_on_left_of_box': 0.2777777777777778, 'NOT_concept_box_on_top_NOT_concept_wall_up_down_right': 1.0, 'NOT_concept_wall_up_down_right_concept_blank_cell_on_left': 0.5, 'NOT_concept_wall_on_right_NOT_concept_wall_up_down_right': 0.7777777777777778, 'NOT_concept_pink_cell_on_right_NOT_concept_wall_up_down_right': 0.8333333333333334, 'NOT_concept_box_on_left_NOT_concept_wall_up_down_right': 1.0, 'NOT_concept_wall_down_left_NOT_concept_wall_up_down_right': 0.9444444444444444, 'NOT_concept_pink_cell_below_NOT_concept_wall_up_down_right': 0.8888888888888888, 'NOT_concept_wall_below_NOT_concept_wall_up_down_right': 0.8333333333333334, 'concept_no_wall_on_left_m_concept_wall_down_right': 0.0, 'NOT_concept_pink_cell_on_left_concept_no_wall_on_left_m': 0.16666666666666666, 'NOT_concept_wall_below_box_concept_no_wall_on_left_m': 0.3333333333333333, 'NOT_concept_wall_on_top_concept_no_wall_on_left_m': 0.3333333333333333, 'NOT_concept_no_wall_on_right_m_concept_no_wall_on_left_m': 0.2777777777777778, 'NOT_concept_on_pink_cell_concept_no_wall_on_left_m': 0.3333333333333333, 'NOT_concept_box_on_right_concept_no_wall_on_left_m': 0.3333333333333333, 'concept_no_wall_on_left_m_concept_wall_top_left': 0.0, 'concept_no_wall_on_left_m_concept_target_on_right': 0.0, 'NOT_concept_blank_cell_below_concept_no_wall_on_left_m': 0.05555555555555555, 'concept_no_wall_on_left_m_concept_no_wall_on_right_m': 0.05555555555555555, 'concept_no_wall_on_left_m_concept_wall_below': 0.05555555555555555, 'NOT_concept_no_wall_on_left_m_concept_no_wall_on_left_m': 0.0, 'NOT_concept_wall_top_left_concept_no_wall_on_left_m': 0.3333333333333333, 'NOT_concept_box_below_concept_no_wall_on_left_m': 0.3333333333333333, 'NOT_concept_wall_above_box_concept_no_wall_on_left_m': 0.3333333333333333, 'concept_no_wall_on_left_m_concept_pink_cell_on_top': 0.0, 'NOT_concept_no_pink_cell_on_top_m_concept_no_wall_on_left_m': 0.0, 'NOT_concept_wall_on_right_of_box_concept_no_wall_on_left_m': 0.1111111111111111, 'NOT_concept_no_wall_on_top_m_concept_no_wall_on_left_m': 0.0, 'concept_no_wall_on_left_m_concept_on_pink_cell': 0.0, 'concept_no_wall_on_left_m_concept_target_on_top': 0.0, 'concept_no_wall_on_left_m_concept_wall_down_left': 0.0, 'concept_no_wall_on_left_m_concept_wall_on_left': 0.0, 'NOT_concept_no_pink_cell_below_m_concept_no_wall_on_left_m': 0.05555555555555555, 'concept_no_wall_on_left_m_concept_wall_up_down_right': 0.0, 'concept_no_wall_on_left_m_concept_wall_on_top': 0.0, 'concept_no_wall_on_left_m_concept_wall_above_box': 0.0, 'concept_no_wall_on_left_m_concept_wall_on_right_of_box': 0.2222222222222222, 'concept_box_on_left_concept_no_wall_on_left_m': 0.0, 'concept_no_wall_on_left_m_concept_no_wall_on_top_m': 0.3333333333333333, 'NOT_concept_pink_cell_on_top_concept_no_wall_on_left_m': 0.3333333333333333, 'concept_no_pink_cell_on_top_m_concept_no_wall_on_left_m': 0.3333333333333333, 'NOT_concept_no_wall_below_m_concept_no_wall_on_left_m': 0.1111111111111111, 'concept_no_wall_on_left_m_concept_wall_below_box': 0.0, 'concept_no_wall_on_left_m_concept_wall_on_right': 0.2222222222222222, 'concept_no_wall_on_left_m_concept_pink_cell_below': 0.0, 'NOT_concept_blank_cell_on_left_concept_no_wall_on_left_m': 0.16666666666666666, 'NOT_concept_target_on_right_concept_no_wall_on_left_m': 0.3333333333333333, 'concept_no_pink_cell_below_m_concept_no_wall_on_left_m': 0.2777777777777778, 'NOT_concept_target_on_top_concept_no_wall_on_left_m': 0.3333333333333333, 'NOT_concept_wall_top_right_concept_no_wall_on_left_m': 0.3333333333333333, 'concept_box_on_top_concept_no_wall_on_left_m': 0.0, 'concept_no_wall_below_m_concept_no_wall_on_left_m': 0.2222222222222222, 'NOT_concept_wall_on_left_concept_no_wall_on_left_m': 0.3333333333333333, 'concept_no_wall_on_left_m_concept_wall_on_left_of_box': 0.0, 'NOT_concept_box_on_top_concept_no_wall_on_left_m': 0.3333333333333333, 'concept_blank_cell_on_left_concept_no_wall_on_left_m': 0.16666666666666666, 'NOT_concept_wall_on_right_concept_no_wall_on_left_m': 0.1111111111111111, 'NOT_concept_pink_cell_on_right_concept_no_wall_on_left_m': 0.3333333333333333, 'NOT_concept_box_on_left_concept_no_wall_on_left_m': 0.3333333333333333, 'NOT_concept_wall_down_left_concept_no_wall_on_left_m': 0.3333333333333333, 'NOT_concept_pink_cell_below_concept_no_wall_on_left_m': 0.3333333333333333, 'NOT_concept_wall_below_concept_no_wall_on_left_m': 0.2777777777777778, 'NOT_concept_pink_cell_on_left_concept_wall_down_right': 0.0, 'NOT_concept_wall_below_box_concept_wall_down_right': 0.0, 'NOT_concept_wall_on_top_concept_wall_down_right': 0.0, 'NOT_concept_no_wall_on_right_m_concept_wall_down_right': 0.0, 'NOT_concept_on_pink_cell_concept_wall_down_right': 0.0, 'NOT_concept_box_on_right_concept_wall_down_right': 0.0, 'concept_wall_down_right_concept_wall_top_left': 0.0, 'concept_target_on_right_concept_wall_down_right': 0.0, 'NOT_concept_blank_cell_below_concept_wall_down_right': 0.0, 'concept_no_wall_on_right_m_concept_wall_down_right': 0.0, 'concept_wall_below_concept_wall_down_right': 0.0, 'NOT_concept_no_wall_on_left_m_concept_wall_down_right': 0.0, 'NOT_concept_wall_top_left_concept_wall_down_right': 0.0, 'NOT_concept_box_below_concept_wall_down_right': 0.0, 'NOT_concept_wall_above_box_concept_wall_down_right': 0.0, 'concept_pink_cell_on_top_concept_wall_down_right': 0.0, 'NOT_concept_no_pink_cell_on_top_m_concept_wall_down_right': 0.0, 'NOT_concept_wall_on_right_of_box_concept_wall_down_right': 0.0, 'NOT_concept_no_wall_on_top_m_concept_wall_down_right': 0.0, 'concept_on_pink_cell_concept_wall_down_right': 0.0, 'concept_target_on_top_concept_wall_down_right': 0.0, 'concept_wall_down_left_concept_wall_down_right': 0.0, 'concept_wall_down_right_concept_wall_on_left': 0.0, 'NOT_concept_no_pink_cell_below_m_concept_wall_down_right': 0.0, 'concept_wall_down_right_concept_wall_up_down_right': 0.0, 'concept_wall_down_right_concept_wall_on_top': 0.0, 'concept_wall_above_box_concept_wall_down_right': 0.0, 'concept_wall_down_right_concept_wall_on_right_of_box': 0.0, 'concept_box_on_left_concept_wall_down_right': 0.0, 'concept_no_wall_on_top_m_concept_wall_down_right': 0.0, 'NOT_concept_pink_cell_on_top_concept_wall_down_right': 0.0, 'concept_no_pink_cell_on_top_m_concept_wall_down_right': 0.0, 'NOT_concept_no_wall_below_m_concept_wall_down_right': 0.0, 'concept_wall_below_box_concept_wall_down_right': 0.0, 'concept_wall_down_right_concept_wall_on_right': 0.0, 'concept_pink_cell_below_concept_wall_down_right': 0.0, 'NOT_concept_blank_cell_on_left_concept_wall_down_right': 0.0, 'NOT_concept_target_on_right_concept_wall_down_right': 0.0, 'concept_no_pink_cell_below_m_concept_wall_down_right': 0.0, 'NOT_concept_target_on_top_concept_wall_down_right': 0.0, 'NOT_concept_wall_top_right_concept_wall_down_right': 0.0, 'concept_box_on_top_concept_wall_down_right': 0.0, 'concept_no_wall_below_m_concept_wall_down_right': 0.0, 'NOT_concept_wall_on_left_concept_wall_down_right': 0.0, 'concept_wall_down_right_concept_wall_on_left_of_box': 0.0, 'NOT_concept_box_on_top_concept_wall_down_right': 0.0, 'concept_blank_cell_on_left_concept_wall_down_right': 0.0, 'NOT_concept_wall_on_right_concept_wall_down_right': 0.0, 'NOT_concept_pink_cell_on_right_concept_wall_down_right': 0.0, 'NOT_concept_box_on_left_concept_wall_down_right': 0.0, 'NOT_concept_wall_down_left_concept_wall_down_right': 0.0, 'NOT_concept_pink_cell_below_concept_wall_down_right': 0.0, 'NOT_concept_wall_below_concept_wall_down_right': 0.0, 'NOT_concept_pink_cell_on_left_NOT_concept_wall_below_box': 0.8333333333333334, 'NOT_concept_pink_cell_on_left_NOT_concept_wall_on_top': 0.8333333333333334, 'NOT_concept_no_wall_on_right_m_NOT_concept_pink_cell_on_left': 0.3333333333333333, 'NOT_concept_on_pink_cell_NOT_concept_pink_cell_on_left': 0.6666666666666666, 'NOT_concept_box_on_right_NOT_concept_pink_cell_on_left': 0.8333333333333334, 'NOT_concept_pink_cell_on_left_concept_wall_top_left': 0.0, 'NOT_concept_pink_cell_on_left_concept_target_on_right': 0.0, 'NOT_concept_blank_cell_below_NOT_concept_pink_cell_on_left': 0.2777777777777778, 'NOT_concept_pink_cell_on_left_concept_no_wall_on_right_m': 0.5, 'NOT_concept_pink_cell_on_left_concept_wall_below': 0.16666666666666666, 'NOT_concept_no_wall_on_left_m_NOT_concept_pink_cell_on_left': 0.6666666666666666, 'NOT_concept_pink_cell_on_left_NOT_concept_wall_top_left': 0.8333333333333334, 'NOT_concept_box_below_NOT_concept_pink_cell_on_left': 0.8333333333333334, 'NOT_concept_pink_cell_on_left_NOT_concept_wall_above_box': 0.8333333333333334, 'NOT_concept_pink_cell_on_left_concept_pink_cell_on_top': 0.16666666666666666, 'NOT_concept_no_pink_cell_on_top_m_NOT_concept_pink_cell_on_left': 0.2222222222222222, 'NOT_concept_pink_cell_on_left_NOT_concept_wall_on_right_of_box': 0.6666666666666666, 'NOT_concept_no_wall_on_top_m_NOT_concept_pink_cell_on_left': 0.0, 'NOT_concept_pink_cell_on_left_concept_on_pink_cell': 0.16666666666666666, 'NOT_concept_pink_cell_on_left_concept_target_on_top': 0.0, 'NOT_concept_pink_cell_on_left_concept_wall_down_left': 0.05555555555555555, 'NOT_concept_pink_cell_on_left_concept_wall_on_left': 0.3333333333333333, 'NOT_concept_no_pink_cell_below_m_NOT_concept_pink_cell_on_left': 0.2777777777777778, 'NOT_concept_pink_cell_on_left_concept_wall_up_down_right': 0.0, 'NOT_concept_pink_cell_on_left_concept_wall_on_top': 0.0, 'NOT_concept_pink_cell_on_left_concept_wall_above_box': 0.0, 'NOT_concept_pink_cell_on_left_concept_wall_on_right_of_box': 0.16666666666666666, 'NOT_concept_pink_cell_on_left_concept_box_on_left': 0.0, 'NOT_concept_pink_cell_on_left_concept_no_wall_on_top_m': 0.8333333333333334, 'NOT_concept_pink_cell_on_left_NOT_concept_pink_cell_on_top': 0.6666666666666666, 'NOT_concept_pink_cell_on_left_concept_no_pink_cell_on_top_m': 0.6111111111111112, 'NOT_concept_no_wall_below_m_NOT_concept_pink_cell_on_left': 0.3333333333333333, 'NOT_concept_pink_cell_on_left_concept_wall_below_box': 0.0, 'NOT_concept_pink_cell_on_left_concept_wall_on_right': 0.1111111111111111, 'NOT_concept_pink_cell_on_left_concept_pink_cell_below': 0.1111111111111111, 'NOT_concept_blank_cell_on_left_NOT_concept_pink_cell_on_left': 0.3333333333333333, 'NOT_concept_pink_cell_on_left_NOT_concept_target_on_right': 0.8333333333333334, 'NOT_concept_pink_cell_on_left_concept_no_pink_cell_below_m': 0.5555555555555556, 'NOT_concept_pink_cell_on_left_NOT_concept_target_on_top': 0.8333333333333334, 'NOT_concept_pink_cell_on_left_NOT_concept_wall_top_right': 0.8333333333333334, 'NOT_concept_pink_cell_on_left_concept_box_on_top': 0.0, 'NOT_concept_pink_cell_on_left_concept_no_wall_below_m': 0.5, 'NOT_concept_pink_cell_on_left_NOT_concept_wall_on_left': 0.5, 'NOT_concept_pink_cell_on_left_concept_wall_on_left_of_box': 0.2777777777777778, 'NOT_concept_box_on_top_NOT_concept_pink_cell_on_left': 0.8333333333333334, 'NOT_concept_pink_cell_on_left_concept_blank_cell_on_left': 0.5, 'NOT_concept_pink_cell_on_left_NOT_concept_wall_on_right': 0.7222222222222222, 'NOT_concept_pink_cell_on_left_NOT_concept_pink_cell_on_right': 0.6666666666666666, 'NOT_concept_box_on_left_NOT_concept_pink_cell_on_left': 0.8333333333333334, 'NOT_concept_pink_cell_on_left_NOT_concept_wall_down_left': 0.7777777777777778, 'NOT_concept_pink_cell_below_NOT_concept_pink_cell_on_left': 0.7222222222222222, 'NOT_concept_pink_cell_on_left_NOT_concept_wall_below': 0.6666666666666666, 'NOT_concept_wall_below_box_NOT_concept_wall_on_top': 1.0, 'NOT_concept_no_wall_on_right_m_NOT_concept_wall_below_box': 0.5, 'NOT_concept_on_pink_cell_NOT_concept_wall_below_box': 0.8333333333333334, 'NOT_concept_box_on_right_NOT_concept_wall_below_box': 1.0, 'NOT_concept_wall_below_box_concept_wall_top_left': 0.0, 'NOT_concept_wall_below_box_concept_target_on_right': 0.0, 'NOT_concept_blank_cell_below_NOT_concept_wall_below_box': 0.2777777777777778, 'NOT_concept_wall_below_box_concept_no_wall_on_right_m': 0.5, 'NOT_concept_wall_below_box_concept_wall_below': 0.16666666666666666, 'NOT_concept_no_wall_on_left_m_NOT_concept_wall_below_box': 0.6666666666666666, 'NOT_concept_wall_below_box_NOT_concept_wall_top_left': 1.0, 'NOT_concept_box_below_NOT_concept_wall_below_box': 1.0, 'NOT_concept_wall_above_box_NOT_concept_wall_below_box': 1.0, 'NOT_concept_wall_below_box_concept_pink_cell_on_top': 0.16666666666666666, 'NOT_concept_no_pink_cell_on_top_m_NOT_concept_wall_below_box': 0.2222222222222222, 'NOT_concept_wall_below_box_NOT_concept_wall_on_right_of_box': 0.7777777777777778, 'NOT_concept_no_wall_on_top_m_NOT_concept_wall_below_box': 0.0, 'NOT_concept_wall_below_box_concept_on_pink_cell': 0.16666666666666666, 'NOT_concept_wall_below_box_concept_target_on_top': 0.0, 'NOT_concept_wall_below_box_concept_wall_down_left': 0.05555555555555555, 'NOT_concept_wall_below_box_concept_wall_on_left': 0.3333333333333333, 'NOT_concept_no_pink_cell_below_m_NOT_concept_wall_below_box': 0.2777777777777778, 'NOT_concept_wall_below_box_concept_wall_up_down_right': 0.0, 'NOT_concept_wall_below_box_concept_wall_on_top': 0.0, 'NOT_concept_wall_below_box_concept_wall_above_box': 0.0, 'NOT_concept_wall_below_box_concept_wall_on_right_of_box': 0.2222222222222222, 'NOT_concept_wall_below_box_concept_box_on_left': 0.0, 'NOT_concept_wall_below_box_concept_no_wall_on_top_m': 1.0, 'NOT_concept_pink_cell_on_top_NOT_concept_wall_below_box': 0.8333333333333334, 'NOT_concept_wall_below_box_concept_no_pink_cell_on_top_m': 0.7777777777777778, 'NOT_concept_no_wall_below_m_NOT_concept_wall_below_box': 0.3333333333333333, 'NOT_concept_wall_below_box_concept_wall_below_box': 0.0, 'NOT_concept_wall_below_box_concept_wall_on_right': 0.2222222222222222, 'NOT_concept_wall_below_box_concept_pink_cell_below': 0.1111111111111111, 'NOT_concept_blank_cell_on_left_NOT_concept_wall_below_box': 0.5, 'NOT_concept_target_on_right_NOT_concept_wall_below_box': 1.0, 'NOT_concept_wall_below_box_concept_no_pink_cell_below_m': 0.7222222222222222, 'NOT_concept_target_on_top_NOT_concept_wall_below_box': 1.0, 'NOT_concept_wall_below_box_NOT_concept_wall_top_right': 1.0, 'NOT_concept_wall_below_box_concept_box_on_top': 0.0, 'NOT_concept_wall_below_box_concept_no_wall_below_m': 0.6666666666666666, 'NOT_concept_wall_below_box_NOT_concept_wall_on_left': 0.6666666666666666, 'NOT_concept_wall_below_box_concept_wall_on_left_of_box': 0.2777777777777778, 'NOT_concept_box_on_top_NOT_concept_wall_below_box': 1.0, 'NOT_concept_wall_below_box_concept_blank_cell_on_left': 0.5, 'NOT_concept_wall_below_box_NOT_concept_wall_on_right': 0.7777777777777778, 'NOT_concept_pink_cell_on_right_NOT_concept_wall_below_box': 0.8333333333333334, 'NOT_concept_box_on_left_NOT_concept_wall_below_box': 1.0, 'NOT_concept_wall_below_box_NOT_concept_wall_down_left': 0.9444444444444444, 'NOT_concept_pink_cell_below_NOT_concept_wall_below_box': 0.8888888888888888, 'NOT_concept_wall_below_NOT_concept_wall_below_box': 0.8333333333333334, 'NOT_concept_no_wall_on_right_m_NOT_concept_wall_on_top': 0.5, 'NOT_concept_on_pink_cell_NOT_concept_wall_on_top': 0.8333333333333334, 'NOT_concept_box_on_right_NOT_concept_wall_on_top': 1.0, 'NOT_concept_wall_on_top_concept_wall_top_left': 0.0, 'NOT_concept_wall_on_top_concept_target_on_right': 0.0, 'NOT_concept_blank_cell_below_NOT_concept_wall_on_top': 0.2777777777777778, 'NOT_concept_wall_on_top_concept_no_wall_on_right_m': 0.5, 'NOT_concept_wall_on_top_concept_wall_below': 0.16666666666666666, 'NOT_concept_no_wall_on_left_m_NOT_concept_wall_on_top': 0.6666666666666666, 'NOT_concept_wall_on_top_NOT_concept_wall_top_left': 1.0, 'NOT_concept_box_below_NOT_concept_wall_on_top': 1.0, 'NOT_concept_wall_above_box_NOT_concept_wall_on_top': 1.0, 'NOT_concept_wall_on_top_concept_pink_cell_on_top': 0.16666666666666666, 'NOT_concept_no_pink_cell_on_top_m_NOT_concept_wall_on_top': 0.2222222222222222, 'NOT_concept_wall_on_right_of_box_NOT_concept_wall_on_top': 0.7777777777777778, 'NOT_concept_no_wall_on_top_m_NOT_concept_wall_on_top': 0.0, 'NOT_concept_wall_on_top_concept_on_pink_cell': 0.16666666666666666, 'NOT_concept_wall_on_top_concept_target_on_top': 0.0, 'NOT_concept_wall_on_top_concept_wall_down_left': 0.05555555555555555, 'NOT_concept_wall_on_top_concept_wall_on_left': 0.3333333333333333, 'NOT_concept_no_pink_cell_below_m_NOT_concept_wall_on_top': 0.2777777777777778, 'NOT_concept_wall_on_top_concept_wall_up_down_right': 0.0, 'NOT_concept_wall_on_top_concept_wall_on_top': 0.0, 'NOT_concept_wall_on_top_concept_wall_above_box': 0.0, 'NOT_concept_wall_on_top_concept_wall_on_right_of_box': 0.2222222222222222, 'NOT_concept_wall_on_top_concept_box_on_left': 0.0, 'NOT_concept_wall_on_top_concept_no_wall_on_top_m': 1.0, 'NOT_concept_pink_cell_on_top_NOT_concept_wall_on_top': 0.8333333333333334, 'NOT_concept_wall_on_top_concept_no_pink_cell_on_top_m': 0.7777777777777778, 'NOT_concept_no_wall_below_m_NOT_concept_wall_on_top': 0.3333333333333333, 'NOT_concept_wall_on_top_concept_wall_below_box': 0.0, 'NOT_concept_wall_on_top_concept_wall_on_right': 0.2222222222222222, 'NOT_concept_wall_on_top_concept_pink_cell_below': 0.1111111111111111, 'NOT_concept_blank_cell_on_left_NOT_concept_wall_on_top': 0.5, 'NOT_concept_target_on_right_NOT_concept_wall_on_top': 1.0, 'NOT_concept_wall_on_top_concept_no_pink_cell_below_m': 0.7222222222222222, 'NOT_concept_target_on_top_NOT_concept_wall_on_top': 1.0, 'NOT_concept_wall_on_top_NOT_concept_wall_top_right': 1.0, 'NOT_concept_wall_on_top_concept_box_on_top': 0.0, 'NOT_concept_wall_on_top_concept_no_wall_below_m': 0.6666666666666666, 'NOT_concept_wall_on_left_NOT_concept_wall_on_top': 0.6666666666666666, 'NOT_concept_wall_on_top_concept_wall_on_left_of_box': 0.2777777777777778, 'NOT_concept_box_on_top_NOT_concept_wall_on_top': 1.0, 'NOT_concept_wall_on_top_concept_blank_cell_on_left': 0.5, 'NOT_concept_wall_on_right_NOT_concept_wall_on_top': 0.7777777777777778, 'NOT_concept_pink_cell_on_right_NOT_concept_wall_on_top': 0.8333333333333334, 'NOT_concept_box_on_left_NOT_concept_wall_on_top': 1.0, 'NOT_concept_wall_down_left_NOT_concept_wall_on_top': 0.9444444444444444, 'NOT_concept_pink_cell_below_NOT_concept_wall_on_top': 0.8888888888888888, 'NOT_concept_wall_below_NOT_concept_wall_on_top': 0.8333333333333334, 'NOT_concept_no_wall_on_right_m_NOT_concept_on_pink_cell': 0.3333333333333333, 'NOT_concept_box_on_right_NOT_concept_no_wall_on_right_m': 0.5, 'NOT_concept_no_wall_on_right_m_concept_wall_top_left': 0.0, 'NOT_concept_no_wall_on_right_m_concept_target_on_right': 0.0, 'NOT_concept_blank_cell_below_NOT_concept_no_wall_on_right_m': 0.05555555555555555, 'NOT_concept_no_wall_on_right_m_concept_no_wall_on_right_m': 0.0, 'NOT_concept_no_wall_on_right_m_concept_wall_below': 0.0, 'NOT_concept_no_wall_on_left_m_NOT_concept_no_wall_on_right_m': 0.2222222222222222, 'NOT_concept_no_wall_on_right_m_NOT_concept_wall_top_left': 0.5, 'NOT_concept_box_below_NOT_concept_no_wall_on_right_m': 0.5, 'NOT_concept_no_wall_on_right_m_NOT_concept_wall_above_box': 0.5, 'NOT_concept_no_wall_on_right_m_concept_pink_cell_on_top': 0.16666666666666666, 'NOT_concept_no_pink_cell_on_top_m_NOT_concept_no_wall_on_right_m': 0.2222222222222222, 'NOT_concept_no_wall_on_right_m_NOT_concept_wall_on_right_of_box': 0.3333333333333333, 'NOT_concept_no_wall_on_right_m_NOT_concept_no_wall_on_top_m': 0.0, 'NOT_concept_no_wall_on_right_m_concept_on_pink_cell': 0.16666666666666666, 'NOT_concept_no_wall_on_right_m_concept_target_on_top': 0.0, 'NOT_concept_no_wall_on_right_m_concept_wall_down_left': 0.0, 'NOT_concept_no_wall_on_right_m_concept_wall_on_left': 0.0, 'NOT_concept_no_pink_cell_below_m_NOT_concept_no_wall_on_right_m': 0.05555555555555555, 'NOT_concept_no_wall_on_right_m_concept_wall_up_down_right': 0.0, 'NOT_concept_no_wall_on_right_m_concept_wall_on_top': 0.0, 'NOT_concept_no_wall_on_right_m_concept_wall_above_box': 0.0, 'NOT_concept_no_wall_on_right_m_concept_wall_on_right_of_box': 0.16666666666666666, 'NOT_concept_no_wall_on_right_m_concept_box_on_left': 0.0, 'NOT_concept_no_wall_on_right_m_concept_no_wall_on_top_m': 0.5, 'NOT_concept_no_wall_on_right_m_NOT_concept_pink_cell_on_top': 0.3333333333333333, 'NOT_concept_no_wall_on_right_m_concept_no_pink_cell_on_top_m': 0.2777777777777778, 'NOT_concept_no_wall_below_m_NOT_concept_no_wall_on_right_m': 0.1111111111111111, 'NOT_concept_no_wall_on_right_m_concept_wall_below_box': 0.0, 'NOT_concept_no_wall_on_right_m_concept_wall_on_right': 0.2222222222222222, 'NOT_concept_no_wall_on_right_m_concept_pink_cell_below': 0.05555555555555555, 'NOT_concept_blank_cell_on_left_NOT_concept_no_wall_on_right_m': 0.16666666666666666, 'NOT_concept_no_wall_on_right_m_NOT_concept_target_on_right': 0.5, 'NOT_concept_no_wall_on_right_m_concept_no_pink_cell_below_m': 0.4444444444444444, 'NOT_concept_no_wall_on_right_m_NOT_concept_target_on_top': 0.5, 'NOT_concept_no_wall_on_right_m_NOT_concept_wall_top_right': 0.5, 'NOT_concept_no_wall_on_right_m_concept_box_on_top': 0.0, 'NOT_concept_no_wall_on_right_m_concept_no_wall_below_m': 0.3888888888888889, 'NOT_concept_no_wall_on_right_m_NOT_concept_wall_on_left': 0.5, 'NOT_concept_no_wall_on_right_m_concept_wall_on_left_of_box': 0.0, 'NOT_concept_box_on_top_NOT_concept_no_wall_on_right_m': 0.5, 'NOT_concept_no_wall_on_right_m_concept_blank_cell_on_left': 0.3333333333333333, 'NOT_concept_no_wall_on_right_m_NOT_concept_wall_on_right': 0.2777777777777778, 'NOT_concept_no_wall_on_right_m_NOT_concept_pink_cell_on_right': 0.5, 'NOT_concept_box_on_left_NOT_concept_no_wall_on_right_m': 0.5, 'NOT_concept_no_wall_on_right_m_NOT_concept_wall_down_left': 0.5, 'NOT_concept_no_wall_on_right_m_NOT_concept_pink_cell_below': 0.4444444444444444, 'NOT_concept_no_wall_on_right_m_NOT_concept_wall_below': 0.5, 'NOT_concept_box_on_right_NOT_concept_on_pink_cell': 0.8333333333333334, 'NOT_concept_on_pink_cell_concept_wall_top_left': 0.0, 'NOT_concept_on_pink_cell_concept_target_on_right': 0.0, 'NOT_concept_blank_cell_below_NOT_concept_on_pink_cell': 0.2222222222222222, 'NOT_concept_on_pink_cell_concept_no_wall_on_right_m': 0.5, 'NOT_concept_on_pink_cell_concept_wall_below': 0.16666666666666666, 'NOT_concept_no_wall_on_left_m_NOT_concept_on_pink_cell': 0.5, 'NOT_concept_on_pink_cell_NOT_concept_wall_top_left': 0.8333333333333334, 'NOT_concept_box_below_NOT_concept_on_pink_cell': 0.8333333333333334, 'NOT_concept_on_pink_cell_NOT_concept_wall_above_box': 0.8333333333333334, 'NOT_concept_on_pink_cell_concept_pink_cell_on_top': 0.0, 'NOT_concept_no_pink_cell_on_top_m_NOT_concept_on_pink_cell': 0.05555555555555555, 'NOT_concept_on_pink_cell_NOT_concept_wall_on_right_of_box': 0.6111111111111112, 'NOT_concept_no_wall_on_top_m_NOT_concept_on_pink_cell': 0.0, 'NOT_concept_on_pink_cell_concept_on_pink_cell': 0.0, 'NOT_concept_on_pink_cell_concept_target_on_top': 0.0, 'NOT_concept_on_pink_cell_concept_wall_down_left': 0.05555555555555555, 'NOT_concept_on_pink_cell_concept_wall_on_left': 0.3333333333333333, 'NOT_concept_no_pink_cell_below_m_NOT_concept_on_pink_cell': 0.2222222222222222, 'NOT_concept_on_pink_cell_concept_wall_up_down_right': 0.0, 'NOT_concept_on_pink_cell_concept_wall_on_top': 0.0, 'NOT_concept_on_pink_cell_concept_wall_above_box': 0.0, 'NOT_concept_on_pink_cell_concept_wall_on_right_of_box': 0.2222222222222222, 'NOT_concept_on_pink_cell_concept_box_on_left': 0.0, 'NOT_concept_on_pink_cell_concept_no_wall_on_top_m': 0.8333333333333334, 'NOT_concept_on_pink_cell_NOT_concept_pink_cell_on_top': 0.8333333333333334, 'NOT_concept_on_pink_cell_concept_no_pink_cell_on_top_m': 0.7777777777777778, 'NOT_concept_no_wall_below_m_NOT_concept_on_pink_cell': 0.3333333333333333, 'NOT_concept_on_pink_cell_concept_wall_below_box': 0.0, 'NOT_concept_on_pink_cell_concept_wall_on_right': 0.2222222222222222, 'NOT_concept_on_pink_cell_concept_pink_cell_below': 0.05555555555555555, 'NOT_concept_blank_cell_on_left_NOT_concept_on_pink_cell': 0.5, 'NOT_concept_on_pink_cell_NOT_concept_target_on_right': 0.8333333333333334, 'NOT_concept_on_pink_cell_concept_no_pink_cell_below_m': 0.6111111111111112, 'NOT_concept_on_pink_cell_NOT_concept_target_on_top': 0.8333333333333334, 'NOT_concept_on_pink_cell_NOT_concept_wall_top_right': 0.8333333333333334, 'NOT_concept_on_pink_cell_concept_box_on_top': 0.0, 'NOT_concept_on_pink_cell_concept_no_wall_below_m': 0.5, 'NOT_concept_on_pink_cell_NOT_concept_wall_on_left': 0.5, 'NOT_concept_on_pink_cell_concept_wall_on_left_of_box': 0.2777777777777778, 'NOT_concept_box_on_top_NOT_concept_on_pink_cell': 0.8333333333333334, 'NOT_concept_on_pink_cell_concept_blank_cell_on_left': 0.3333333333333333, 'NOT_concept_on_pink_cell_NOT_concept_wall_on_right': 0.6111111111111112, 'NOT_concept_on_pink_cell_NOT_concept_pink_cell_on_right': 0.6666666666666666, 'NOT_concept_box_on_left_NOT_concept_on_pink_cell': 0.8333333333333334, 'NOT_concept_on_pink_cell_NOT_concept_wall_down_left': 0.7777777777777778, 'NOT_concept_on_pink_cell_NOT_concept_pink_cell_below': 0.7777777777777778, 'NOT_concept_on_pink_cell_NOT_concept_wall_below': 0.6666666666666666, 'NOT_concept_box_on_right_concept_wall_top_left': 0.0, 'NOT_concept_box_on_right_concept_target_on_right': 0.0, 'NOT_concept_blank_cell_below_NOT_concept_box_on_right': 0.2777777777777778, 'NOT_concept_box_on_right_concept_no_wall_on_right_m': 0.5, 'NOT_concept_box_on_right_concept_wall_below': 0.16666666666666666, 'NOT_concept_box_on_right_NOT_concept_no_wall_on_left_m': 0.6666666666666666, 'NOT_concept_box_on_right_NOT_concept_wall_top_left': 1.0, 'NOT_concept_box_below_NOT_concept_box_on_right': 1.0, 'NOT_concept_box_on_right_NOT_concept_wall_above_box': 1.0, 'NOT_concept_box_on_right_concept_pink_cell_on_top': 0.16666666666666666, 'NOT_concept_box_on_right_NOT_concept_no_pink_cell_on_top_m': 0.2222222222222222, 'NOT_concept_box_on_right_NOT_concept_wall_on_right_of_box': 0.7777777777777778, 'NOT_concept_box_on_right_NOT_concept_no_wall_on_top_m': 0.0, 'NOT_concept_box_on_right_concept_on_pink_cell': 0.16666666666666666, 'NOT_concept_box_on_right_concept_target_on_top': 0.0, 'NOT_concept_box_on_right_concept_wall_down_left': 0.05555555555555555, 'NOT_concept_box_on_right_concept_wall_on_left': 0.3333333333333333, 'NOT_concept_box_on_right_NOT_concept_no_pink_cell_below_m': 0.2777777777777778, 'NOT_concept_box_on_right_concept_wall_up_down_right': 0.0, 'NOT_concept_box_on_right_concept_wall_on_top': 0.0, 'NOT_concept_box_on_right_concept_wall_above_box': 0.0, 'NOT_concept_box_on_right_concept_wall_on_right_of_box': 0.2222222222222222, 'NOT_concept_box_on_right_concept_box_on_left': 0.0, 'NOT_concept_box_on_right_concept_no_wall_on_top_m': 1.0, 'NOT_concept_box_on_right_NOT_concept_pink_cell_on_top': 0.8333333333333334, 'NOT_concept_box_on_right_concept_no_pink_cell_on_top_m': 0.7777777777777778, 'NOT_concept_box_on_right_NOT_concept_no_wall_below_m': 0.3333333333333333, 'NOT_concept_box_on_right_concept_wall_below_box': 0.0, 'NOT_concept_box_on_right_concept_wall_on_right': 0.2222222222222222, 'NOT_concept_box_on_right_concept_pink_cell_below': 0.1111111111111111, 'NOT_concept_blank_cell_on_left_NOT_concept_box_on_right': 0.5, 'NOT_concept_box_on_right_NOT_concept_target_on_right': 1.0, 'NOT_concept_box_on_right_concept_no_pink_cell_below_m': 0.7222222222222222, 'NOT_concept_box_on_right_NOT_concept_target_on_top': 1.0, 'NOT_concept_box_on_right_NOT_concept_wall_top_right': 1.0, 'NOT_concept_box_on_right_concept_box_on_top': 0.0, 'NOT_concept_box_on_right_concept_no_wall_below_m': 0.6666666666666666, 'NOT_concept_box_on_right_NOT_concept_wall_on_left': 0.6666666666666666, 'NOT_concept_box_on_right_concept_wall_on_left_of_box': 0.2777777777777778, 'NOT_concept_box_on_right_NOT_concept_box_on_top': 1.0, 'NOT_concept_box_on_right_concept_blank_cell_on_left': 0.5, 'NOT_concept_box_on_right_NOT_concept_wall_on_right': 0.7777777777777778, 'NOT_concept_box_on_right_NOT_concept_pink_cell_on_right': 0.8333333333333334, 'NOT_concept_box_on_left_NOT_concept_box_on_right': 1.0, 'NOT_concept_box_on_right_NOT_concept_wall_down_left': 0.9444444444444444, 'NOT_concept_box_on_right_NOT_concept_pink_cell_below': 0.8888888888888888, 'NOT_concept_box_on_right_NOT_concept_wall_below': 0.8333333333333334, 'concept_target_on_right_concept_wall_top_left': 0.0, 'NOT_concept_blank_cell_below_concept_wall_top_left': 0.0, 'concept_no_wall_on_right_m_concept_wall_top_left': 0.0, 'concept_wall_below_concept_wall_top_left': 0.0, 'NOT_concept_no_wall_on_left_m_concept_wall_top_left': 0.0, 'NOT_concept_wall_top_left_concept_wall_top_left': 0.0, 'NOT_concept_box_below_concept_wall_top_left': 0.0, 'NOT_concept_wall_above_box_concept_wall_top_left': 0.0, 'concept_pink_cell_on_top_concept_wall_top_left': 0.0, 'NOT_concept_no_pink_cell_on_top_m_concept_wall_top_left': 0.0, 'NOT_concept_wall_on_right_of_box_concept_wall_top_left': 0.0, 'NOT_concept_no_wall_on_top_m_concept_wall_top_left': 0.0, 'concept_on_pink_cell_concept_wall_top_left': 0.0, 'concept_target_on_top_concept_wall_top_left': 0.0, 'concept_wall_down_left_concept_wall_top_left': 0.0, 'concept_wall_on_left_concept_wall_top_left': 0.0, 'NOT_concept_no_pink_cell_below_m_concept_wall_top_left': 0.0, 'concept_wall_top_left_concept_wall_up_down_right': 0.0, 'concept_wall_on_top_concept_wall_top_left': 0.0, 'concept_wall_above_box_concept_wall_top_left': 0.0, 'concept_wall_on_right_of_box_concept_wall_top_left': 0.0, 'concept_box_on_left_concept_wall_top_left': 0.0, 'concept_no_wall_on_top_m_concept_wall_top_left': 0.0, 'NOT_concept_pink_cell_on_top_concept_wall_top_left': 0.0, 'concept_no_pink_cell_on_top_m_concept_wall_top_left': 0.0, 'NOT_concept_no_wall_below_m_concept_wall_top_left': 0.0, 'concept_wall_below_box_concept_wall_top_left': 0.0, 'concept_wall_on_right_concept_wall_top_left': 0.0, 'concept_pink_cell_below_concept_wall_top_left': 0.0, 'NOT_concept_blank_cell_on_left_concept_wall_top_left': 0.0, 'NOT_concept_target_on_right_concept_wall_top_left': 0.0, 'concept_no_pink_cell_below_m_concept_wall_top_left': 0.0, 'NOT_concept_target_on_top_concept_wall_top_left': 0.0, 'NOT_concept_wall_top_right_concept_wall_top_left': 0.0, 'concept_box_on_top_concept_wall_top_left': 0.0, 'concept_no_wall_below_m_concept_wall_top_left': 0.0, 'NOT_concept_wall_on_left_concept_wall_top_left': 0.0, 'concept_wall_on_left_of_box_concept_wall_top_left': 0.0, 'NOT_concept_box_on_top_concept_wall_top_left': 0.0, 'concept_blank_cell_on_left_concept_wall_top_left': 0.0, 'NOT_concept_wall_on_right_concept_wall_top_left': 0.0, 'NOT_concept_pink_cell_on_right_concept_wall_top_left': 0.0, 'NOT_concept_box_on_left_concept_wall_top_left': 0.0, 'NOT_concept_wall_down_left_concept_wall_top_left': 0.0, 'NOT_concept_pink_cell_below_concept_wall_top_left': 0.0, 'NOT_concept_wall_below_concept_wall_top_left': 0.0, 'NOT_concept_blank_cell_below_concept_target_on_right': 0.0, 'concept_no_wall_on_right_m_concept_target_on_right': 0.0, 'concept_target_on_right_concept_wall_below': 0.0, 'NOT_concept_no_wall_on_left_m_concept_target_on_right': 0.0, 'NOT_concept_wall_top_left_concept_target_on_right': 0.0, 'NOT_concept_box_below_concept_target_on_right': 0.0, 'NOT_concept_wall_above_box_concept_target_on_right': 0.0, 'concept_pink_cell_on_top_concept_target_on_right': 0.0, 'NOT_concept_no_pink_cell_on_top_m_concept_target_on_right': 0.0, 'NOT_concept_wall_on_right_of_box_concept_target_on_right': 0.0, 'NOT_concept_no_wall_on_top_m_concept_target_on_right': 0.0, 'concept_on_pink_cell_concept_target_on_right': 0.0, 'concept_target_on_right_concept_target_on_top': 0.0, 'concept_target_on_right_concept_wall_down_left': 0.0, 'concept_target_on_right_concept_wall_on_left': 0.0, 'NOT_concept_no_pink_cell_below_m_concept_target_on_right': 0.0, 'concept_target_on_right_concept_wall_up_down_right': 0.0, 'concept_target_on_right_concept_wall_on_top': 0.0, 'concept_target_on_right_concept_wall_above_box': 0.0, 'concept_target_on_right_concept_wall_on_right_of_box': 0.0, 'concept_box_on_left_concept_target_on_right': 0.0, 'concept_no_wall_on_top_m_concept_target_on_right': 0.0, 'NOT_concept_pink_cell_on_top_concept_target_on_right': 0.0, 'concept_no_pink_cell_on_top_m_concept_target_on_right': 0.0, 'NOT_concept_no_wall_below_m_concept_target_on_right': 0.0, 'concept_target_on_right_concept_wall_below_box': 0.0, 'concept_target_on_right_concept_wall_on_right': 0.0, 'concept_pink_cell_below_concept_target_on_right': 0.0, 'NOT_concept_blank_cell_on_left_concept_target_on_right': 0.0, 'NOT_concept_target_on_right_concept_target_on_right': 0.0, 'concept_no_pink_cell_below_m_concept_target_on_right': 0.0, 'NOT_concept_target_on_top_concept_target_on_right': 0.0, 'NOT_concept_wall_top_right_concept_target_on_right': 0.0, 'concept_box_on_top_concept_target_on_right': 0.0, 'concept_no_wall_below_m_concept_target_on_right': 0.0, 'NOT_concept_wall_on_left_concept_target_on_right': 0.0, 'concept_target_on_right_concept_wall_on_left_of_box': 0.0, 'NOT_concept_box_on_top_concept_target_on_right': 0.0, 'concept_blank_cell_on_left_concept_target_on_right': 0.0, 'NOT_concept_wall_on_right_concept_target_on_right': 0.0, 'NOT_concept_pink_cell_on_right_concept_target_on_right': 0.0, 'NOT_concept_box_on_left_concept_target_on_right': 0.0, 'NOT_concept_wall_down_left_concept_target_on_right': 0.0, 'NOT_concept_pink_cell_below_concept_target_on_right': 0.0, 'NOT_concept_wall_below_concept_target_on_right': 0.0, 'NOT_concept_blank_cell_below_concept_no_wall_on_right_m': 0.2222222222222222, 'NOT_concept_blank_cell_below_concept_wall_below': 0.16666666666666666, 'NOT_concept_blank_cell_below_NOT_concept_no_wall_on_left_m': 0.2222222222222222, 'NOT_concept_blank_cell_below_NOT_concept_wall_top_left': 0.2777777777777778, 'NOT_concept_blank_cell_below_NOT_concept_box_below': 0.2777777777777778, 'NOT_concept_blank_cell_below_NOT_concept_wall_above_box': 0.2777777777777778, 'NOT_concept_blank_cell_below_concept_pink_cell_on_top': 0.05555555555555555, 'NOT_concept_blank_cell_below_NOT_concept_no_pink_cell_on_top_m': 0.05555555555555555, 'NOT_concept_blank_cell_below_NOT_concept_wall_on_right_of_box': 0.2222222222222222, 'NOT_concept_blank_cell_below_NOT_concept_no_wall_on_top_m': 0.0, 'NOT_concept_blank_cell_below_concept_on_pink_cell': 0.05555555555555555, 'NOT_concept_blank_cell_below_concept_target_on_top': 0.0, 'NOT_concept_blank_cell_below_concept_wall_down_left': 0.05555555555555555, 'NOT_concept_blank_cell_below_concept_wall_on_left': 0.05555555555555555, 'NOT_concept_blank_cell_below_NOT_concept_no_pink_cell_below_m': 0.2777777777777778, 'NOT_concept_blank_cell_below_concept_wall_up_down_right': 0.0, 'NOT_concept_blank_cell_below_concept_wall_on_top': 0.0, 'NOT_concept_blank_cell_below_concept_wall_above_box': 0.0, 'NOT_concept_blank_cell_below_concept_wall_on_right_of_box': 0.05555555555555555, 'NOT_concept_blank_cell_below_concept_box_on_left': 0.0, 'NOT_concept_blank_cell_below_concept_no_wall_on_top_m': 0.2777777777777778, 'NOT_concept_blank_cell_below_NOT_concept_pink_cell_on_top': 0.2222222222222222, 'NOT_concept_blank_cell_below_concept_no_pink_cell_on_top_m': 0.2222222222222222, 'NOT_concept_blank_cell_below_NOT_concept_no_wall_below_m': 0.16666666666666666, 'NOT_concept_blank_cell_below_concept_wall_below_box': 0.0, 'NOT_concept_blank_cell_below_concept_wall_on_right': 0.0, 'NOT_concept_blank_cell_below_concept_pink_cell_below': 0.1111111111111111, 'NOT_concept_blank_cell_below_NOT_concept_blank_cell_on_left': 0.05555555555555555, 'NOT_concept_blank_cell_below_NOT_concept_target_on_right': 0.2777777777777778, 'NOT_concept_blank_cell_below_concept_no_pink_cell_below_m': 0.0, 'NOT_concept_blank_cell_below_NOT_concept_target_on_top': 0.2777777777777778, 'NOT_concept_blank_cell_below_NOT_concept_wall_top_right': 0.2777777777777778, 'NOT_concept_blank_cell_below_concept_box_on_top': 0.0, 'NOT_concept_blank_cell_below_concept_no_wall_below_m': 0.1111111111111111, 'NOT_concept_blank_cell_below_NOT_concept_wall_on_left': 0.2222222222222222, 'NOT_concept_blank_cell_below_concept_wall_on_left_of_box': 0.05555555555555555, 'NOT_concept_blank_cell_below_NOT_concept_box_on_top': 0.2777777777777778, 'NOT_concept_blank_cell_below_concept_blank_cell_on_left': 0.2222222222222222, 'NOT_concept_blank_cell_below_NOT_concept_wall_on_right': 0.2777777777777778, 'NOT_concept_blank_cell_below_NOT_concept_pink_cell_on_right': 0.2777777777777778, 'NOT_concept_blank_cell_below_NOT_concept_box_on_left': 0.2777777777777778, 'NOT_concept_blank_cell_below_NOT_concept_wall_down_left': 0.2222222222222222, 'NOT_concept_blank_cell_below_NOT_concept_pink_cell_below': 0.16666666666666666, 'NOT_concept_blank_cell_below_NOT_concept_wall_below': 0.1111111111111111, 'concept_no_wall_on_right_m_concept_wall_below': 0.16666666666666666, 'NOT_concept_no_wall_on_left_m_concept_no_wall_on_right_m': 0.4444444444444444, 'NOT_concept_wall_top_left_concept_no_wall_on_right_m': 0.5, 'NOT_concept_box_below_concept_no_wall_on_right_m': 0.5, 'NOT_concept_wall_above_box_concept_no_wall_on_right_m': 0.5, 'concept_no_wall_on_right_m_concept_pink_cell_on_top': 0.0, 'NOT_concept_no_pink_cell_on_top_m_concept_no_wall_on_right_m': 0.0, 'NOT_concept_wall_on_right_of_box_concept_no_wall_on_right_m': 0.4444444444444444, 'NOT_concept_no_wall_on_top_m_concept_no_wall_on_right_m': 0.0, 'concept_no_wall_on_right_m_concept_on_pink_cell': 0.0, 'concept_no_wall_on_right_m_concept_target_on_top': 0.0, 'concept_no_wall_on_right_m_concept_wall_down_left': 0.05555555555555555, 'concept_no_wall_on_right_m_concept_wall_on_left': 0.3333333333333333, 'NOT_concept_no_pink_cell_below_m_concept_no_wall_on_right_m': 0.2222222222222222, 'concept_no_wall_on_right_m_concept_wall_up_down_right': 0.0, 'concept_no_wall_on_right_m_concept_wall_on_top': 0.0, 'concept_no_wall_on_right_m_concept_wall_above_box': 0.0, 'concept_no_wall_on_right_m_concept_wall_on_right_of_box': 0.05555555555555555, 'concept_box_on_left_concept_no_wall_on_right_m': 0.0, 'concept_no_wall_on_right_m_concept_no_wall_on_top_m': 0.5, 'NOT_concept_pink_cell_on_top_concept_no_wall_on_right_m': 0.5, 'concept_no_pink_cell_on_top_m_concept_no_wall_on_right_m': 0.5, 'NOT_concept_no_wall_below_m_concept_no_wall_on_right_m': 0.2222222222222222, 'concept_no_wall_on_right_m_concept_wall_below_box': 0.0, 'concept_no_wall_on_right_m_concept_wall_on_right': 0.0, 'concept_no_wall_on_right_m_concept_pink_cell_below': 0.05555555555555555, 'NOT_concept_blank_cell_on_left_concept_no_wall_on_right_m': 0.3333333333333333, 'NOT_concept_target_on_right_concept_no_wall_on_right_m': 0.5, 'concept_no_pink_cell_below_m_concept_no_wall_on_right_m': 0.2777777777777778, 'NOT_concept_target_on_top_concept_no_wall_on_right_m': 0.5, 'NOT_concept_wall_top_right_concept_no_wall_on_right_m': 0.5, 'concept_box_on_top_concept_no_wall_on_right_m': 0.0, 'concept_no_wall_below_m_concept_no_wall_on_right_m': 0.2777777777777778, 'NOT_concept_wall_on_left_concept_no_wall_on_right_m': 0.16666666666666666, 'concept_no_wall_on_right_m_concept_wall_on_left_of_box': 0.2777777777777778, 'NOT_concept_box_on_top_concept_no_wall_on_right_m': 0.5, 'concept_blank_cell_on_left_concept_no_wall_on_right_m': 0.16666666666666666, 'NOT_concept_wall_on_right_concept_no_wall_on_right_m': 0.5, 'NOT_concept_pink_cell_on_right_concept_no_wall_on_right_m': 0.3333333333333333, 'NOT_concept_box_on_left_concept_no_wall_on_right_m': 0.5, 'NOT_concept_wall_down_left_concept_no_wall_on_right_m': 0.4444444444444444, 'NOT_concept_pink_cell_below_concept_no_wall_on_right_m': 0.4444444444444444, 'NOT_concept_wall_below_concept_no_wall_on_right_m': 0.3333333333333333, 'NOT_concept_no_wall_on_left_m_concept_wall_below': 0.1111111111111111, 'NOT_concept_wall_top_left_concept_wall_below': 0.16666666666666666, 'NOT_concept_box_below_concept_wall_below': 0.16666666666666666, 'NOT_concept_wall_above_box_concept_wall_below': 0.16666666666666666, 'concept_pink_cell_on_top_concept_wall_below': 0.0, 'NOT_concept_no_pink_cell_on_top_m_concept_wall_below': 0.0, 'NOT_concept_wall_on_right_of_box_concept_wall_below': 0.1111111111111111, 'NOT_concept_no_wall_on_top_m_concept_wall_below': 0.0, 'concept_on_pink_cell_concept_wall_below': 0.0, 'concept_target_on_top_concept_wall_below': 0.0, 'concept_wall_below_concept_wall_down_left': 0.05555555555555555, 'concept_wall_below_concept_wall_on_left': 0.05555555555555555, 'NOT_concept_no_pink_cell_below_m_concept_wall_below': 0.16666666666666666, 'concept_wall_below_concept_wall_up_down_right': 0.0, 'concept_wall_below_concept_wall_on_top': 0.0, 'concept_wall_above_box_concept_wall_below': 0.0, 'concept_wall_below_concept_wall_on_right_of_box': 0.05555555555555555, 'concept_box_on_left_concept_wall_below': 0.0, 'concept_no_wall_on_top_m_concept_wall_below': 0.16666666666666666, 'NOT_concept_pink_cell_on_top_concept_wall_below': 0.16666666666666666, 'concept_no_pink_cell_on_top_m_concept_wall_below': 0.16666666666666666, 'NOT_concept_no_wall_below_m_concept_wall_below': 0.16666666666666666, 'concept_wall_below_concept_wall_below_box': 0.0, 'concept_wall_below_concept_wall_on_right': 0.0, 'concept_pink_cell_below_concept_wall_below': 0.0, 'NOT_concept_blank_cell_on_left_concept_wall_below': 0.05555555555555555, 'NOT_concept_target_on_right_concept_wall_below': 0.16666666666666666, 'concept_no_pink_cell_below_m_concept_wall_below': 0.0, 'NOT_concept_target_on_top_concept_wall_below': 0.16666666666666666, 'NOT_concept_wall_top_right_concept_wall_below': 0.16666666666666666, 'concept_box_on_top_concept_wall_below': 0.0, 'concept_no_wall_below_m_concept_wall_below': 0.0, 'NOT_concept_wall_on_left_concept_wall_below': 0.1111111111111111, 'concept_wall_below_concept_wall_on_left_of_box': 0.05555555555555555, 'NOT_concept_box_on_top_concept_wall_below': 0.16666666666666666, 'concept_blank_cell_on_left_concept_wall_below': 0.1111111111111111, 'NOT_concept_wall_on_right_concept_wall_below': 0.16666666666666666, 'NOT_concept_pink_cell_on_right_concept_wall_below': 0.16666666666666666, 'NOT_concept_box_on_left_concept_wall_below': 0.16666666666666666, 'NOT_concept_wall_down_left_concept_wall_below': 0.1111111111111111, 'NOT_concept_pink_cell_below_concept_wall_below': 0.16666666666666666, 'NOT_concept_wall_below_concept_wall_below': 0.0, 'NOT_concept_no_wall_on_left_m_NOT_concept_wall_top_left': 0.6666666666666666, 'NOT_concept_box_below_NOT_concept_no_wall_on_left_m': 0.6666666666666666, 'NOT_concept_no_wall_on_left_m_NOT_concept_wall_above_box': 0.6666666666666666, 'NOT_concept_no_wall_on_left_m_concept_pink_cell_on_top': 0.16666666666666666, 'NOT_concept_no_pink_cell_on_top_m_NOT_concept_no_wall_on_left_m': 0.2222222222222222, 'NOT_concept_no_wall_on_left_m_NOT_concept_wall_on_right_of_box': 0.6666666666666666, 'NOT_concept_no_wall_on_left_m_NOT_concept_no_wall_on_top_m': 0.0, 'NOT_concept_no_wall_on_left_m_concept_on_pink_cell': 0.16666666666666666, 'NOT_concept_no_wall_on_left_m_concept_target_on_top': 0.0, 'NOT_concept_no_wall_on_left_m_concept_wall_down_left': 0.05555555555555555, 'NOT_concept_no_wall_on_left_m_concept_wall_on_left': 0.3333333333333333, 'NOT_concept_no_pink_cell_below_m_NOT_concept_no_wall_on_left_m': 0.2222222222222222, 'NOT_concept_no_wall_on_left_m_concept_wall_up_down_right': 0.0, 'NOT_concept_no_wall_on_left_m_concept_wall_on_top': 0.0, 'NOT_concept_no_wall_on_left_m_concept_wall_above_box': 0.0, 'NOT_concept_no_wall_on_left_m_concept_wall_on_right_of_box': 0.0, 'NOT_concept_no_wall_on_left_m_concept_box_on_left': 0.0, 'NOT_concept_no_wall_on_left_m_concept_no_wall_on_top_m': 0.6666666666666666, 'NOT_concept_no_wall_on_left_m_NOT_concept_pink_cell_on_top': 0.5, 'NOT_concept_no_wall_on_left_m_concept_no_pink_cell_on_top_m': 0.4444444444444444, 'NOT_concept_no_wall_below_m_NOT_concept_no_wall_on_left_m': 0.2222222222222222, 'NOT_concept_no_wall_on_left_m_concept_wall_below_box': 0.0, 'NOT_concept_no_wall_on_left_m_concept_wall_on_right': 0.0, 'NOT_concept_no_wall_on_left_m_concept_pink_cell_below': 0.1111111111111111, 'NOT_concept_blank_cell_on_left_NOT_concept_no_wall_on_left_m': 0.3333333333333333, 'NOT_concept_no_wall_on_left_m_NOT_concept_target_on_right': 0.6666666666666666, 'NOT_concept_no_wall_on_left_m_concept_no_pink_cell_below_m': 0.4444444444444444, 'NOT_concept_no_wall_on_left_m_NOT_concept_target_on_top': 0.6666666666666666, 'NOT_concept_no_wall_on_left_m_NOT_concept_wall_top_right': 0.6666666666666666, 'NOT_concept_no_wall_on_left_m_concept_box_on_top': 0.0, 'NOT_concept_no_wall_on_left_m_concept_no_wall_below_m': 0.4444444444444444, 'NOT_concept_no_wall_on_left_m_NOT_concept_wall_on_left': 0.3333333333333333, 'NOT_concept_no_wall_on_left_m_concept_wall_on_left_of_box': 0.2777777777777778, 'NOT_concept_box_on_top_NOT_concept_no_wall_on_left_m': 0.6666666666666666, 'NOT_concept_no_wall_on_left_m_concept_blank_cell_on_left': 0.3333333333333333, 'NOT_concept_no_wall_on_left_m_NOT_concept_wall_on_right': 0.6666666666666666, 'NOT_concept_no_wall_on_left_m_NOT_concept_pink_cell_on_right': 0.5, 'NOT_concept_box_on_left_NOT_concept_no_wall_on_left_m': 0.6666666666666666, 'NOT_concept_no_wall_on_left_m_NOT_concept_wall_down_left': 0.6111111111111112, 'NOT_concept_no_wall_on_left_m_NOT_concept_pink_cell_below': 0.5555555555555556, 'NOT_concept_no_wall_on_left_m_NOT_concept_wall_below': 0.5555555555555556, 'NOT_concept_box_below_NOT_concept_wall_top_left': 1.0, 'NOT_concept_wall_above_box_NOT_concept_wall_top_left': 1.0, 'NOT_concept_wall_top_left_concept_pink_cell_on_top': 0.16666666666666666, 'NOT_concept_no_pink_cell_on_top_m_NOT_concept_wall_top_left': 0.2222222222222222, 'NOT_concept_wall_on_right_of_box_NOT_concept_wall_top_left': 0.7777777777777778, 'NOT_concept_no_wall_on_top_m_NOT_concept_wall_top_left': 0.0, 'NOT_concept_wall_top_left_concept_on_pink_cell': 0.16666666666666666, 'NOT_concept_wall_top_left_concept_target_on_top': 0.0, 'NOT_concept_wall_top_left_concept_wall_down_left': 0.05555555555555555, 'NOT_concept_wall_top_left_concept_wall_on_left': 0.3333333333333333, 'NOT_concept_no_pink_cell_below_m_NOT_concept_wall_top_left': 0.2777777777777778, 'NOT_concept_wall_top_left_concept_wall_up_down_right': 0.0, 'NOT_concept_wall_top_left_concept_wall_on_top': 0.0, 'NOT_concept_wall_top_left_concept_wall_above_box': 0.0, 'NOT_concept_wall_top_left_concept_wall_on_right_of_box': 0.2222222222222222, 'NOT_concept_wall_top_left_concept_box_on_left': 0.0, 'NOT_concept_wall_top_left_concept_no_wall_on_top_m': 1.0, 'NOT_concept_pink_cell_on_top_NOT_concept_wall_top_left': 0.8333333333333334, 'NOT_concept_wall_top_left_concept_no_pink_cell_on_top_m': 0.7777777777777778, 'NOT_concept_no_wall_below_m_NOT_concept_wall_top_left': 0.3333333333333333, 'NOT_concept_wall_top_left_concept_wall_below_box': 0.0, 'NOT_concept_wall_top_left_concept_wall_on_right': 0.2222222222222222, 'NOT_concept_wall_top_left_concept_pink_cell_below': 0.1111111111111111, 'NOT_concept_blank_cell_on_left_NOT_concept_wall_top_left': 0.5, 'NOT_concept_target_on_right_NOT_concept_wall_top_left': 1.0, 'NOT_concept_wall_top_left_concept_no_pink_cell_below_m': 0.7222222222222222, 'NOT_concept_target_on_top_NOT_concept_wall_top_left': 1.0, 'NOT_concept_wall_top_left_NOT_concept_wall_top_right': 1.0, 'NOT_concept_wall_top_left_concept_box_on_top': 0.0, 'NOT_concept_wall_top_left_concept_no_wall_below_m': 0.6666666666666666, 'NOT_concept_wall_on_left_NOT_concept_wall_top_left': 0.6666666666666666, 'NOT_concept_wall_top_left_concept_wall_on_left_of_box': 0.2777777777777778, 'NOT_concept_box_on_top_NOT_concept_wall_top_left': 1.0, 'NOT_concept_wall_top_left_concept_blank_cell_on_left': 0.5, 'NOT_concept_wall_on_right_NOT_concept_wall_top_left': 0.7777777777777778, 'NOT_concept_pink_cell_on_right_NOT_concept_wall_top_left': 0.8333333333333334, 'NOT_concept_box_on_left_NOT_concept_wall_top_left': 1.0, 'NOT_concept_wall_down_left_NOT_concept_wall_top_left': 0.9444444444444444, 'NOT_concept_pink_cell_below_NOT_concept_wall_top_left': 0.8888888888888888, 'NOT_concept_wall_below_NOT_concept_wall_top_left': 0.8333333333333334, 'NOT_concept_box_below_NOT_concept_wall_above_box': 1.0, 'NOT_concept_box_below_concept_pink_cell_on_top': 0.16666666666666666, 'NOT_concept_box_below_NOT_concept_no_pink_cell_on_top_m': 0.2222222222222222, 'NOT_concept_box_below_NOT_concept_wall_on_right_of_box': 0.7777777777777778, 'NOT_concept_box_below_NOT_concept_no_wall_on_top_m': 0.0, 'NOT_concept_box_below_concept_on_pink_cell': 0.16666666666666666, 'NOT_concept_box_below_concept_target_on_top': 0.0, 'NOT_concept_box_below_concept_wall_down_left': 0.05555555555555555, 'NOT_concept_box_below_concept_wall_on_left': 0.3333333333333333, 'NOT_concept_box_below_NOT_concept_no_pink_cell_below_m': 0.2777777777777778, 'NOT_concept_box_below_concept_wall_up_down_right': 0.0, 'NOT_concept_box_below_concept_wall_on_top': 0.0, 'NOT_concept_box_below_concept_wall_above_box': 0.0, 'NOT_concept_box_below_concept_wall_on_right_of_box': 0.2222222222222222, 'NOT_concept_box_below_concept_box_on_left': 0.0, 'NOT_concept_box_below_concept_no_wall_on_top_m': 1.0, 'NOT_concept_box_below_NOT_concept_pink_cell_on_top': 0.8333333333333334, 'NOT_concept_box_below_concept_no_pink_cell_on_top_m': 0.7777777777777778, 'NOT_concept_box_below_NOT_concept_no_wall_below_m': 0.3333333333333333, 'NOT_concept_box_below_concept_wall_below_box': 0.0, 'NOT_concept_box_below_concept_wall_on_right': 0.2222222222222222, 'NOT_concept_box_below_concept_pink_cell_below': 0.1111111111111111, 'NOT_concept_blank_cell_on_left_NOT_concept_box_below': 0.5, 'NOT_concept_box_below_NOT_concept_target_on_right': 1.0, 'NOT_concept_box_below_concept_no_pink_cell_below_m': 0.7222222222222222, 'NOT_concept_box_below_NOT_concept_target_on_top': 1.0, 'NOT_concept_box_below_NOT_concept_wall_top_right': 1.0, 'NOT_concept_box_below_concept_box_on_top': 0.0, 'NOT_concept_box_below_concept_no_wall_below_m': 0.6666666666666666, 'NOT_concept_box_below_NOT_concept_wall_on_left': 0.6666666666666666, 'NOT_concept_box_below_concept_wall_on_left_of_box': 0.2777777777777778, 'NOT_concept_box_below_NOT_concept_box_on_top': 1.0, 'NOT_concept_box_below_concept_blank_cell_on_left': 0.5, 'NOT_concept_box_below_NOT_concept_wall_on_right': 0.7777777777777778, 'NOT_concept_box_below_NOT_concept_pink_cell_on_right': 0.8333333333333334, 'NOT_concept_box_below_NOT_concept_box_on_left': 1.0, 'NOT_concept_box_below_NOT_concept_wall_down_left': 0.9444444444444444, 'NOT_concept_box_below_NOT_concept_pink_cell_below': 0.8888888888888888, 'NOT_concept_box_below_NOT_concept_wall_below': 0.8333333333333334, 'NOT_concept_wall_above_box_concept_pink_cell_on_top': 0.16666666666666666, 'NOT_concept_no_pink_cell_on_top_m_NOT_concept_wall_above_box': 0.2222222222222222, 'NOT_concept_wall_above_box_NOT_concept_wall_on_right_of_box': 0.7777777777777778, 'NOT_concept_no_wall_on_top_m_NOT_concept_wall_above_box': 0.0, 'NOT_concept_wall_above_box_concept_on_pink_cell': 0.16666666666666666, 'NOT_concept_wall_above_box_concept_target_on_top': 0.0, 'NOT_concept_wall_above_box_concept_wall_down_left': 0.05555555555555555, 'NOT_concept_wall_above_box_concept_wall_on_left': 0.3333333333333333, 'NOT_concept_no_pink_cell_below_m_NOT_concept_wall_above_box': 0.2777777777777778, 'NOT_concept_wall_above_box_concept_wall_up_down_right': 0.0, 'NOT_concept_wall_above_box_concept_wall_on_top': 0.0, 'NOT_concept_wall_above_box_concept_wall_above_box': 0.0, 'NOT_concept_wall_above_box_concept_wall_on_right_of_box': 0.2222222222222222, 'NOT_concept_wall_above_box_concept_box_on_left': 0.0, 'NOT_concept_wall_above_box_concept_no_wall_on_top_m': 1.0, 'NOT_concept_pink_cell_on_top_NOT_concept_wall_above_box': 0.8333333333333334, 'NOT_concept_wall_above_box_concept_no_pink_cell_on_top_m': 0.7777777777777778, 'NOT_concept_no_wall_below_m_NOT_concept_wall_above_box': 0.3333333333333333, 'NOT_concept_wall_above_box_concept_wall_below_box': 0.0, 'NOT_concept_wall_above_box_concept_wall_on_right': 0.2222222222222222, 'NOT_concept_wall_above_box_concept_pink_cell_below': 0.1111111111111111, 'NOT_concept_blank_cell_on_left_NOT_concept_wall_above_box': 0.5, 'NOT_concept_target_on_right_NOT_concept_wall_above_box': 1.0, 'NOT_concept_wall_above_box_concept_no_pink_cell_below_m': 0.7222222222222222, 'NOT_concept_target_on_top_NOT_concept_wall_above_box': 1.0, 'NOT_concept_wall_above_box_NOT_concept_wall_top_right': 1.0, 'NOT_concept_wall_above_box_concept_box_on_top': 0.0, 'NOT_concept_wall_above_box_concept_no_wall_below_m': 0.6666666666666666, 'NOT_concept_wall_above_box_NOT_concept_wall_on_left': 0.6666666666666666, 'NOT_concept_wall_above_box_concept_wall_on_left_of_box': 0.2777777777777778, 'NOT_concept_box_on_top_NOT_concept_wall_above_box': 1.0, 'NOT_concept_wall_above_box_concept_blank_cell_on_left': 0.5, 'NOT_concept_wall_above_box_NOT_concept_wall_on_right': 0.7777777777777778, 'NOT_concept_pink_cell_on_right_NOT_concept_wall_above_box': 0.8333333333333334, 'NOT_concept_box_on_left_NOT_concept_wall_above_box': 1.0, 'NOT_concept_wall_above_box_NOT_concept_wall_down_left': 0.9444444444444444, 'NOT_concept_pink_cell_below_NOT_concept_wall_above_box': 0.8888888888888888, 'NOT_concept_wall_above_box_NOT_concept_wall_below': 0.8333333333333334, 'NOT_concept_no_pink_cell_on_top_m_concept_pink_cell_on_top': 0.16666666666666666, 'NOT_concept_wall_on_right_of_box_concept_pink_cell_on_top': 0.16666666666666666, 'NOT_concept_no_wall_on_top_m_concept_pink_cell_on_top': 0.0, 'concept_on_pink_cell_concept_pink_cell_on_top': 0.16666666666666666, 'concept_pink_cell_on_top_concept_target_on_top': 0.0, 'concept_pink_cell_on_top_concept_wall_down_left': 0.0, 'concept_pink_cell_on_top_concept_wall_on_left': 0.0, 'NOT_concept_no_pink_cell_below_m_concept_pink_cell_on_top': 0.05555555555555555, 'concept_pink_cell_on_top_concept_wall_up_down_right': 0.0, 'concept_pink_cell_on_top_concept_wall_on_top': 0.0, 'concept_pink_cell_on_top_concept_wall_above_box': 0.0, 'concept_pink_cell_on_top_concept_wall_on_right_of_box': 0.0, 'concept_box_on_left_concept_pink_cell_on_top': 0.0, 'concept_no_wall_on_top_m_concept_pink_cell_on_top': 0.16666666666666666, 'NOT_concept_pink_cell_on_top_concept_pink_cell_on_top': 0.0, 'concept_no_pink_cell_on_top_m_concept_pink_cell_on_top': 0.0, 'NOT_concept_no_wall_below_m_concept_pink_cell_on_top': 0.0, 'concept_pink_cell_on_top_concept_wall_below_box': 0.0, 'concept_pink_cell_on_top_concept_wall_on_right': 0.0, 'concept_pink_cell_below_concept_pink_cell_on_top': 0.05555555555555555, 'NOT_concept_blank_cell_on_left_concept_pink_cell_on_top': 0.0, 'NOT_concept_target_on_right_concept_pink_cell_on_top': 0.16666666666666666, 'concept_no_pink_cell_below_m_concept_pink_cell_on_top': 0.1111111111111111, 'NOT_concept_target_on_top_concept_pink_cell_on_top': 0.16666666666666666, 'NOT_concept_wall_top_right_concept_pink_cell_on_top': 0.16666666666666666, 'concept_box_on_top_concept_pink_cell_on_top': 0.0, 'concept_no_wall_below_m_concept_pink_cell_on_top': 0.16666666666666666, 'NOT_concept_wall_on_left_concept_pink_cell_on_top': 0.16666666666666666, 'concept_pink_cell_on_top_concept_wall_on_left_of_box': 0.0, 'NOT_concept_box_on_top_concept_pink_cell_on_top': 0.16666666666666666, 'concept_blank_cell_on_left_concept_pink_cell_on_top': 0.16666666666666666, 'NOT_concept_wall_on_right_concept_pink_cell_on_top': 0.16666666666666666, 'NOT_concept_pink_cell_on_right_concept_pink_cell_on_top': 0.16666666666666666, 'NOT_concept_box_on_left_concept_pink_cell_on_top': 0.16666666666666666, 'NOT_concept_wall_down_left_concept_pink_cell_on_top': 0.16666666666666666, 'NOT_concept_pink_cell_below_concept_pink_cell_on_top': 0.1111111111111111, 'NOT_concept_wall_below_concept_pink_cell_on_top': 0.16666666666666666, 'NOT_concept_no_pink_cell_on_top_m_NOT_concept_wall_on_right_of_box': 0.2222222222222222, 'NOT_concept_no_pink_cell_on_top_m_NOT_concept_no_wall_on_top_m': 0.0, 'NOT_concept_no_pink_cell_on_top_m_concept_on_pink_cell': 0.16666666666666666, 'NOT_concept_no_pink_cell_on_top_m_concept_target_on_top': 0.0, 'NOT_concept_no_pink_cell_on_top_m_concept_wall_down_left': 0.0, 'NOT_concept_no_pink_cell_on_top_m_concept_wall_on_left': 0.0, 'NOT_concept_no_pink_cell_below_m_NOT_concept_no_pink_cell_on_top_m': 0.05555555555555555, 'NOT_concept_no_pink_cell_on_top_m_concept_wall_up_down_right': 0.0, 'NOT_concept_no_pink_cell_on_top_m_concept_wall_on_top': 0.0, 'NOT_concept_no_pink_cell_on_top_m_concept_wall_above_box': 0.0, 'NOT_concept_no_pink_cell_on_top_m_concept_wall_on_right_of_box': 0.0, 'NOT_concept_no_pink_cell_on_top_m_concept_box_on_left': 0.0, 'NOT_concept_no_pink_cell_on_top_m_concept_no_wall_on_top_m': 0.2222222222222222, 'NOT_concept_no_pink_cell_on_top_m_NOT_concept_pink_cell_on_top': 0.05555555555555555, 'NOT_concept_no_pink_cell_on_top_m_concept_no_pink_cell_on_top_m': 0.0, 'NOT_concept_no_pink_cell_on_top_m_NOT_concept_no_wall_below_m': 0.05555555555555555, 'NOT_concept_no_pink_cell_on_top_m_concept_wall_below_box': 0.0, 'NOT_concept_no_pink_cell_on_top_m_concept_wall_on_right': 0.0, 'NOT_concept_no_pink_cell_on_top_m_concept_pink_cell_below': 0.05555555555555555, 'NOT_concept_blank_cell_on_left_NOT_concept_no_pink_cell_on_top_m': 0.0, 'NOT_concept_no_pink_cell_on_top_m_NOT_concept_target_on_right': 0.2222222222222222, 'NOT_concept_no_pink_cell_on_top_m_concept_no_pink_cell_below_m': 0.16666666666666666, 'NOT_concept_no_pink_cell_on_top_m_NOT_concept_target_on_top': 0.2222222222222222, 'NOT_concept_no_pink_cell_on_top_m_NOT_concept_wall_top_right': 0.2222222222222222, 'NOT_concept_no_pink_cell_on_top_m_concept_box_on_top': 0.0, 'NOT_concept_no_pink_cell_on_top_m_concept_no_wall_below_m': 0.16666666666666666, 'NOT_concept_no_pink_cell_on_top_m_NOT_concept_wall_on_left': 0.2222222222222222, 'NOT_concept_no_pink_cell_on_top_m_concept_wall_on_left_of_box': 0.0, 'NOT_concept_box_on_top_NOT_concept_no_pink_cell_on_top_m': 0.2222222222222222, 'NOT_concept_no_pink_cell_on_top_m_concept_blank_cell_on_left': 0.2222222222222222, 'NOT_concept_no_pink_cell_on_top_m_NOT_concept_wall_on_right': 0.2222222222222222, 'NOT_concept_no_pink_cell_on_top_m_NOT_concept_pink_cell_on_right': 0.2222222222222222, 'NOT_concept_box_on_left_NOT_concept_no_pink_cell_on_top_m': 0.2222222222222222, 'NOT_concept_no_pink_cell_on_top_m_NOT_concept_wall_down_left': 0.2222222222222222, 'NOT_concept_no_pink_cell_on_top_m_NOT_concept_pink_cell_below': 0.16666666666666666, 'NOT_concept_no_pink_cell_on_top_m_NOT_concept_wall_below': 0.2222222222222222, 'NOT_concept_no_wall_on_top_m_NOT_concept_wall_on_right_of_box': 0.0, 'NOT_concept_wall_on_right_of_box_concept_on_pink_cell': 0.16666666666666666, 'NOT_concept_wall_on_right_of_box_concept_target_on_top': 0.0, 'NOT_concept_wall_on_right_of_box_concept_wall_down_left': 0.05555555555555555, 'NOT_concept_wall_on_right_of_box_concept_wall_on_left': 0.3333333333333333, 'NOT_concept_no_pink_cell_below_m_NOT_concept_wall_on_right_of_box': 0.2222222222222222, 'NOT_concept_wall_on_right_of_box_concept_wall_up_down_right': 0.0, 'NOT_concept_wall_on_right_of_box_concept_wall_on_top': 0.0, 'NOT_concept_wall_on_right_of_box_concept_wall_above_box': 0.0, 'NOT_concept_wall_on_right_of_box_concept_wall_on_right_of_box': 0.0, 'NOT_concept_wall_on_right_of_box_concept_box_on_left': 0.0, 'NOT_concept_wall_on_right_of_box_concept_no_wall_on_top_m': 0.7777777777777778, 'NOT_concept_pink_cell_on_top_NOT_concept_wall_on_right_of_box': 0.6111111111111112, 'NOT_concept_wall_on_right_of_box_concept_no_pink_cell_on_top_m': 0.5555555555555556, 'NOT_concept_no_wall_below_m_NOT_concept_wall_on_right_of_box': 0.2222222222222222, 'NOT_concept_wall_on_right_of_box_concept_wall_below_box': 0.0, 'NOT_concept_wall_on_right_of_box_concept_wall_on_right': 0.05555555555555555, 'NOT_concept_wall_on_right_of_box_concept_pink_cell_below': 0.1111111111111111, 'NOT_concept_blank_cell_on_left_NOT_concept_wall_on_right_of_box': 0.4444444444444444, 'NOT_concept_target_on_right_NOT_concept_wall_on_right_of_box': 0.7777777777777778, 'NOT_concept_wall_on_right_of_box_concept_no_pink_cell_below_m': 0.5555555555555556, 'NOT_concept_target_on_top_NOT_concept_wall_on_right_of_box': 0.7777777777777778, 'NOT_concept_wall_on_right_of_box_NOT_concept_wall_top_right': 0.7777777777777778, 'NOT_concept_wall_on_right_of_box_concept_box_on_top': 0.0, 'NOT_concept_wall_on_right_of_box_concept_no_wall_below_m': 0.5555555555555556, 'NOT_concept_wall_on_left_NOT_concept_wall_on_right_of_box': 0.4444444444444444, 'NOT_concept_wall_on_right_of_box_concept_wall_on_left_of_box': 0.2777777777777778, 'NOT_concept_box_on_top_NOT_concept_wall_on_right_of_box': 0.7777777777777778, 'NOT_concept_wall_on_right_of_box_concept_blank_cell_on_left': 0.3333333333333333, 'NOT_concept_wall_on_right_NOT_concept_wall_on_right_of_box': 0.7222222222222222, 'NOT_concept_pink_cell_on_right_NOT_concept_wall_on_right_of_box': 0.6111111111111112, 'NOT_concept_box_on_left_NOT_concept_wall_on_right_of_box': 0.7777777777777778, 'NOT_concept_wall_down_left_NOT_concept_wall_on_right_of_box': 0.7222222222222222, 'NOT_concept_pink_cell_below_NOT_concept_wall_on_right_of_box': 0.6666666666666666, 'NOT_concept_wall_below_NOT_concept_wall_on_right_of_box': 0.6666666666666666, 'NOT_concept_no_wall_on_top_m_concept_on_pink_cell': 0.0, 'NOT_concept_no_wall_on_top_m_concept_target_on_top': 0.0, 'NOT_concept_no_wall_on_top_m_concept_wall_down_left': 0.0, 'NOT_concept_no_wall_on_top_m_concept_wall_on_left': 0.0, 'NOT_concept_no_pink_cell_below_m_NOT_concept_no_wall_on_top_m': 0.0, 'NOT_concept_no_wall_on_top_m_concept_wall_up_down_right': 0.0, 'NOT_concept_no_wall_on_top_m_concept_wall_on_top': 0.0, 'NOT_concept_no_wall_on_top_m_concept_wall_above_box': 0.0, 'NOT_concept_no_wall_on_top_m_concept_wall_on_right_of_box': 0.0, 'NOT_concept_no_wall_on_top_m_concept_box_on_left': 0.0, 'NOT_concept_no_wall_on_top_m_concept_no_wall_on_top_m': 0.0, 'NOT_concept_no_wall_on_top_m_NOT_concept_pink_cell_on_top': 0.0, 'NOT_concept_no_wall_on_top_m_concept_no_pink_cell_on_top_m': 0.0, 'NOT_concept_no_wall_below_m_NOT_concept_no_wall_on_top_m': 0.0, 'NOT_concept_no_wall_on_top_m_concept_wall_below_box': 0.0, 'NOT_concept_no_wall_on_top_m_concept_wall_on_right': 0.0, 'NOT_concept_no_wall_on_top_m_concept_pink_cell_below': 0.0, 'NOT_concept_blank_cell_on_left_NOT_concept_no_wall_on_top_m': 0.0, 'NOT_concept_no_wall_on_top_m_NOT_concept_target_on_right': 0.0, 'NOT_concept_no_wall_on_top_m_concept_no_pink_cell_below_m': 0.0, 'NOT_concept_no_wall_on_top_m_NOT_concept_target_on_top': 0.0, 'NOT_concept_no_wall_on_top_m_NOT_concept_wall_top_right': 0.0, 'NOT_concept_no_wall_on_top_m_concept_box_on_top': 0.0, 'NOT_concept_no_wall_on_top_m_concept_no_wall_below_m': 0.0, 'NOT_concept_no_wall_on_top_m_NOT_concept_wall_on_left': 0.0, 'NOT_concept_no_wall_on_top_m_concept_wall_on_left_of_box': 0.0, 'NOT_concept_box_on_top_NOT_concept_no_wall_on_top_m': 0.0, 'NOT_concept_no_wall_on_top_m_concept_blank_cell_on_left': 0.0, 'NOT_concept_no_wall_on_top_m_NOT_concept_wall_on_right': 0.0, 'NOT_concept_no_wall_on_top_m_NOT_concept_pink_cell_on_right': 0.0, 'NOT_concept_box_on_left_NOT_concept_no_wall_on_top_m': 0.0, 'NOT_concept_no_wall_on_top_m_NOT_concept_wall_down_left': 0.0, 'NOT_concept_no_wall_on_top_m_NOT_concept_pink_cell_below': 0.0, 'NOT_concept_no_wall_on_top_m_NOT_concept_wall_below': 0.0, 'concept_on_pink_cell_concept_target_on_top': 0.0, 'concept_on_pink_cell_concept_wall_down_left': 0.0, 'concept_on_pink_cell_concept_wall_on_left': 0.0, 'NOT_concept_no_pink_cell_below_m_concept_on_pink_cell': 0.05555555555555555, 'concept_on_pink_cell_concept_wall_up_down_right': 0.0, 'concept_on_pink_cell_concept_wall_on_top': 0.0, 'concept_on_pink_cell_concept_wall_above_box': 0.0, 'concept_on_pink_cell_concept_wall_on_right_of_box': 0.0, 'concept_box_on_left_concept_on_pink_cell': 0.0, 'concept_no_wall_on_top_m_concept_on_pink_cell': 0.16666666666666666, 'NOT_concept_pink_cell_on_top_concept_on_pink_cell': 0.0, 'concept_no_pink_cell_on_top_m_concept_on_pink_cell': 0.0, 'NOT_concept_no_wall_below_m_concept_on_pink_cell': 0.0, 'concept_on_pink_cell_concept_wall_below_box': 0.0, 'concept_on_pink_cell_concept_wall_on_right': 0.0, 'concept_on_pink_cell_concept_pink_cell_below': 0.05555555555555555, 'NOT_concept_blank_cell_on_left_concept_on_pink_cell': 0.0, 'NOT_concept_target_on_right_concept_on_pink_cell': 0.16666666666666666, 'concept_no_pink_cell_below_m_concept_on_pink_cell': 0.1111111111111111, 'NOT_concept_target_on_top_concept_on_pink_cell': 0.16666666666666666, 'NOT_concept_wall_top_right_concept_on_pink_cell': 0.16666666666666666, 'concept_box_on_top_concept_on_pink_cell': 0.0, 'concept_no_wall_below_m_concept_on_pink_cell': 0.16666666666666666, 'NOT_concept_wall_on_left_concept_on_pink_cell': 0.16666666666666666, 'concept_on_pink_cell_concept_wall_on_left_of_box': 0.0, 'NOT_concept_box_on_top_concept_on_pink_cell': 0.16666666666666666, 'concept_blank_cell_on_left_concept_on_pink_cell': 0.16666666666666666, 'NOT_concept_wall_on_right_concept_on_pink_cell': 0.16666666666666666, 'NOT_concept_pink_cell_on_right_concept_on_pink_cell': 0.16666666666666666, 'NOT_concept_box_on_left_concept_on_pink_cell': 0.16666666666666666, 'NOT_concept_wall_down_left_concept_on_pink_cell': 0.16666666666666666, 'NOT_concept_pink_cell_below_concept_on_pink_cell': 0.1111111111111111, 'NOT_concept_wall_below_concept_on_pink_cell': 0.16666666666666666, 'concept_target_on_top_concept_wall_down_left': 0.0, 'concept_target_on_top_concept_wall_on_left': 0.0, 'NOT_concept_no_pink_cell_below_m_concept_target_on_top': 0.0, 'concept_target_on_top_concept_wall_up_down_right': 0.0, 'concept_target_on_top_concept_wall_on_top': 0.0, 'concept_target_on_top_concept_wall_above_box': 0.0, 'concept_target_on_top_concept_wall_on_right_of_box': 0.0, 'concept_box_on_left_concept_target_on_top': 0.0, 'concept_no_wall_on_top_m_concept_target_on_top': 0.0, 'NOT_concept_pink_cell_on_top_concept_target_on_top': 0.0, 'concept_no_pink_cell_on_top_m_concept_target_on_top': 0.0, 'NOT_concept_no_wall_below_m_concept_target_on_top': 0.0, 'concept_target_on_top_concept_wall_below_box': 0.0, 'concept_target_on_top_concept_wall_on_right': 0.0, 'concept_pink_cell_below_concept_target_on_top': 0.0, 'NOT_concept_blank_cell_on_left_concept_target_on_top': 0.0, 'NOT_concept_target_on_right_concept_target_on_top': 0.0, 'concept_no_pink_cell_below_m_concept_target_on_top': 0.0, 'NOT_concept_target_on_top_concept_target_on_top': 0.0, 'NOT_concept_wall_top_right_concept_target_on_top': 0.0, 'concept_box_on_top_concept_target_on_top': 0.0, 'concept_no_wall_below_m_concept_target_on_top': 0.0, 'NOT_concept_wall_on_left_concept_target_on_top': 0.0, 'concept_target_on_top_concept_wall_on_left_of_box': 0.0, 'NOT_concept_box_on_top_concept_target_on_top': 0.0, 'concept_blank_cell_on_left_concept_target_on_top': 0.0, 'NOT_concept_wall_on_right_concept_target_on_top': 0.0, 'NOT_concept_pink_cell_on_right_concept_target_on_top': 0.0, 'NOT_concept_box_on_left_concept_target_on_top': 0.0, 'NOT_concept_wall_down_left_concept_target_on_top': 0.0, 'NOT_concept_pink_cell_below_concept_target_on_top': 0.0, 'NOT_concept_wall_below_concept_target_on_top': 0.0, 'concept_wall_down_left_concept_wall_on_left': 0.05555555555555555, 'NOT_concept_no_pink_cell_below_m_concept_wall_down_left': 0.05555555555555555, 'concept_wall_down_left_concept_wall_up_down_right': 0.0, 'concept_wall_down_left_concept_wall_on_top': 0.0, 'concept_wall_above_box_concept_wall_down_left': 0.0, 'concept_wall_down_left_concept_wall_on_right_of_box': 0.0, 'concept_box_on_left_concept_wall_down_left': 0.0, 'concept_no_wall_on_top_m_concept_wall_down_left': 0.05555555555555555, 'NOT_concept_pink_cell_on_top_concept_wall_down_left': 0.05555555555555555, 'concept_no_pink_cell_on_top_m_concept_wall_down_left': 0.05555555555555555, 'NOT_concept_no_wall_below_m_concept_wall_down_left': 0.05555555555555555, 'concept_wall_below_box_concept_wall_down_left': 0.0, 'concept_wall_down_left_concept_wall_on_right': 0.0, 'concept_pink_cell_below_concept_wall_down_left': 0.0, 'NOT_concept_blank_cell_on_left_concept_wall_down_left': 0.05555555555555555, 'NOT_concept_target_on_right_concept_wall_down_left': 0.05555555555555555, 'concept_no_pink_cell_below_m_concept_wall_down_left': 0.0, 'NOT_concept_target_on_top_concept_wall_down_left': 0.05555555555555555, 'NOT_concept_wall_top_right_concept_wall_down_left': 0.05555555555555555, 'concept_box_on_top_concept_wall_down_left': 0.0, 'concept_no_wall_below_m_concept_wall_down_left': 0.0, 'NOT_concept_wall_on_left_concept_wall_down_left': 0.0, 'concept_wall_down_left_concept_wall_on_left_of_box': 0.05555555555555555, 'NOT_concept_box_on_top_concept_wall_down_left': 0.05555555555555555, 'concept_blank_cell_on_left_concept_wall_down_left': 0.0, 'NOT_concept_wall_on_right_concept_wall_down_left': 0.05555555555555555, 'NOT_concept_pink_cell_on_right_concept_wall_down_left': 0.05555555555555555, 'NOT_concept_box_on_left_concept_wall_down_left': 0.05555555555555555, 'NOT_concept_wall_down_left_concept_wall_down_left': 0.0, 'NOT_concept_pink_cell_below_concept_wall_down_left': 0.05555555555555555, 'NOT_concept_wall_below_concept_wall_down_left': 0.0, 'NOT_concept_no_pink_cell_below_m_concept_wall_on_left': 0.05555555555555555, 'concept_wall_on_left_concept_wall_up_down_right': 0.0, 'concept_wall_on_left_concept_wall_on_top': 0.0, 'concept_wall_above_box_concept_wall_on_left': 0.0, 'concept_wall_on_left_concept_wall_on_right_of_box': 0.0, 'concept_box_on_left_concept_wall_on_left': 0.0, 'concept_no_wall_on_top_m_concept_wall_on_left': 0.3333333333333333, 'NOT_concept_pink_cell_on_top_concept_wall_on_left': 0.3333333333333333, 'concept_no_pink_cell_on_top_m_concept_wall_on_left': 0.3333333333333333, 'NOT_concept_no_wall_below_m_concept_wall_on_left': 0.1111111111111111, 'concept_wall_below_box_concept_wall_on_left': 0.0, 'concept_wall_on_left_concept_wall_on_right': 0.0, 'concept_pink_cell_below_concept_wall_on_left': 0.0, 'NOT_concept_blank_cell_on_left_concept_wall_on_left': 0.3333333333333333, 'NOT_concept_target_on_right_concept_wall_on_left': 0.3333333333333333, 'concept_no_pink_cell_below_m_concept_wall_on_left': 0.2777777777777778, 'NOT_concept_target_on_top_concept_wall_on_left': 0.3333333333333333, 'NOT_concept_wall_top_right_concept_wall_on_left': 0.3333333333333333, 'concept_box_on_top_concept_wall_on_left': 0.0, 'concept_no_wall_below_m_concept_wall_on_left': 0.2222222222222222, 'NOT_concept_wall_on_left_concept_wall_on_left': 0.0, 'concept_wall_on_left_concept_wall_on_left_of_box': 0.2777777777777778, 'NOT_concept_box_on_top_concept_wall_on_left': 0.3333333333333333, 'concept_blank_cell_on_left_concept_wall_on_left': 0.0, 'NOT_concept_wall_on_right_concept_wall_on_left': 0.3333333333333333, 'NOT_concept_pink_cell_on_right_concept_wall_on_left': 0.16666666666666666, 'NOT_concept_box_on_left_concept_wall_on_left': 0.3333333333333333, 'NOT_concept_wall_down_left_concept_wall_on_left': 0.2777777777777778, 'NOT_concept_pink_cell_below_concept_wall_on_left': 0.3333333333333333, 'NOT_concept_wall_below_concept_wall_on_left': 0.2777777777777778, 'NOT_concept_no_pink_cell_below_m_concept_wall_up_down_right': 0.0, 'NOT_concept_no_pink_cell_below_m_concept_wall_on_top': 0.0, 'NOT_concept_no_pink_cell_below_m_concept_wall_above_box': 0.0, 'NOT_concept_no_pink_cell_below_m_concept_wall_on_right_of_box': 0.05555555555555555, 'NOT_concept_no_pink_cell_below_m_concept_box_on_left': 0.0, 'NOT_concept_no_pink_cell_below_m_concept_no_wall_on_top_m': 0.2777777777777778, 'NOT_concept_no_pink_cell_below_m_NOT_concept_pink_cell_on_top': 0.2222222222222222, 'NOT_concept_no_pink_cell_below_m_concept_no_pink_cell_on_top_m': 0.2222222222222222, 'NOT_concept_no_pink_cell_below_m_NOT_concept_no_wall_below_m': 0.16666666666666666, 'NOT_concept_no_pink_cell_below_m_concept_wall_below_box': 0.0, 'NOT_concept_no_pink_cell_below_m_concept_wall_on_right': 0.0, 'NOT_concept_no_pink_cell_below_m_concept_pink_cell_below': 0.1111111111111111, 'NOT_concept_blank_cell_on_left_NOT_concept_no_pink_cell_below_m': 0.05555555555555555, 'NOT_concept_no_pink_cell_below_m_NOT_concept_target_on_right': 0.2777777777777778, 'NOT_concept_no_pink_cell_below_m_concept_no_pink_cell_below_m': 0.0, 'NOT_concept_no_pink_cell_below_m_NOT_concept_target_on_top': 0.2777777777777778, 'NOT_concept_no_pink_cell_below_m_NOT_concept_wall_top_right': 0.2777777777777778, 'NOT_concept_no_pink_cell_below_m_concept_box_on_top': 0.0, 'NOT_concept_no_pink_cell_below_m_concept_no_wall_below_m': 0.1111111111111111, 'NOT_concept_no_pink_cell_below_m_NOT_concept_wall_on_left': 0.2222222222222222, 'NOT_concept_no_pink_cell_below_m_concept_wall_on_left_of_box': 0.05555555555555555, 'NOT_concept_box_on_top_NOT_concept_no_pink_cell_below_m': 0.2777777777777778, 'NOT_concept_no_pink_cell_below_m_concept_blank_cell_on_left': 0.2222222222222222, 'NOT_concept_no_pink_cell_below_m_NOT_concept_wall_on_right': 0.2777777777777778, 'NOT_concept_no_pink_cell_below_m_NOT_concept_pink_cell_on_right': 0.2777777777777778, 'NOT_concept_box_on_left_NOT_concept_no_pink_cell_below_m': 0.2777777777777778, 'NOT_concept_no_pink_cell_below_m_NOT_concept_wall_down_left': 0.2222222222222222, 'NOT_concept_no_pink_cell_below_m_NOT_concept_pink_cell_below': 0.16666666666666666, 'NOT_concept_no_pink_cell_below_m_NOT_concept_wall_below': 0.1111111111111111, 'concept_wall_on_top_concept_wall_up_down_right': 0.0, 'concept_wall_above_box_concept_wall_up_down_right': 0.0, 'concept_wall_on_right_of_box_concept_wall_up_down_right': 0.0, 'concept_box_on_left_concept_wall_up_down_right': 0.0, 'concept_no_wall_on_top_m_concept_wall_up_down_right': 0.0, 'NOT_concept_pink_cell_on_top_concept_wall_up_down_right': 0.0, 'concept_no_pink_cell_on_top_m_concept_wall_up_down_right': 0.0, 'NOT_concept_no_wall_below_m_concept_wall_up_down_right': 0.0, 'concept_wall_below_box_concept_wall_up_down_right': 0.0, 'concept_wall_on_right_concept_wall_up_down_right': 0.0, 'concept_pink_cell_below_concept_wall_up_down_right': 0.0, 'NOT_concept_blank_cell_on_left_concept_wall_up_down_right': 0.0, 'NOT_concept_target_on_right_concept_wall_up_down_right': 0.0, 'concept_no_pink_cell_below_m_concept_wall_up_down_right': 0.0, 'NOT_concept_target_on_top_concept_wall_up_down_right': 0.0, 'NOT_concept_wall_top_right_concept_wall_up_down_right': 0.0, 'concept_box_on_top_concept_wall_up_down_right': 0.0, 'concept_no_wall_below_m_concept_wall_up_down_right': 0.0, 'NOT_concept_wall_on_left_concept_wall_up_down_right': 0.0, 'concept_wall_on_left_of_box_concept_wall_up_down_right': 0.0, 'NOT_concept_box_on_top_concept_wall_up_down_right': 0.0, 'concept_blank_cell_on_left_concept_wall_up_down_right': 0.0, 'NOT_concept_wall_on_right_concept_wall_up_down_right': 0.0, 'NOT_concept_pink_cell_on_right_concept_wall_up_down_right': 0.0, 'NOT_concept_box_on_left_concept_wall_up_down_right': 0.0, 'NOT_concept_wall_down_left_concept_wall_up_down_right': 0.0, 'NOT_concept_pink_cell_below_concept_wall_up_down_right': 0.0, 'NOT_concept_wall_below_concept_wall_up_down_right': 0.0, 'concept_wall_above_box_concept_wall_on_top': 0.0, 'concept_wall_on_right_of_box_concept_wall_on_top': 0.0, 'concept_box_on_left_concept_wall_on_top': 0.0, 'concept_no_wall_on_top_m_concept_wall_on_top': 0.0, 'NOT_concept_pink_cell_on_top_concept_wall_on_top': 0.0, 'concept_no_pink_cell_on_top_m_concept_wall_on_top': 0.0, 'NOT_concept_no_wall_below_m_concept_wall_on_top': 0.0, 'concept_wall_below_box_concept_wall_on_top': 0.0, 'concept_wall_on_right_concept_wall_on_top': 0.0, 'concept_pink_cell_below_concept_wall_on_top': 0.0, 'NOT_concept_blank_cell_on_left_concept_wall_on_top': 0.0, 'NOT_concept_target_on_right_concept_wall_on_top': 0.0, 'concept_no_pink_cell_below_m_concept_wall_on_top': 0.0, 'NOT_concept_target_on_top_concept_wall_on_top': 0.0, 'NOT_concept_wall_top_right_concept_wall_on_top': 0.0, 'concept_box_on_top_concept_wall_on_top': 0.0, 'concept_no_wall_below_m_concept_wall_on_top': 0.0, 'NOT_concept_wall_on_left_concept_wall_on_top': 0.0, 'concept_wall_on_left_of_box_concept_wall_on_top': 0.0, 'NOT_concept_box_on_top_concept_wall_on_top': 0.0, 'concept_blank_cell_on_left_concept_wall_on_top': 0.0, 'NOT_concept_wall_on_right_concept_wall_on_top': 0.0, 'NOT_concept_pink_cell_on_right_concept_wall_on_top': 0.0, 'NOT_concept_box_on_left_concept_wall_on_top': 0.0, 'NOT_concept_wall_down_left_concept_wall_on_top': 0.0, 'NOT_concept_pink_cell_below_concept_wall_on_top': 0.0, 'NOT_concept_wall_below_concept_wall_on_top': 0.0, 'concept_wall_above_box_concept_wall_on_right_of_box': 0.0, 'concept_box_on_left_concept_wall_above_box': 0.0, 'concept_no_wall_on_top_m_concept_wall_above_box': 0.0, 'NOT_concept_pink_cell_on_top_concept_wall_above_box': 0.0, 'concept_no_pink_cell_on_top_m_concept_wall_above_box': 0.0, 'NOT_concept_no_wall_below_m_concept_wall_above_box': 0.0, 'concept_wall_above_box_concept_wall_below_box': 0.0, 'concept_wall_above_box_concept_wall_on_right': 0.0, 'concept_pink_cell_below_concept_wall_above_box': 0.0, 'NOT_concept_blank_cell_on_left_concept_wall_above_box': 0.0, 'NOT_concept_target_on_right_concept_wall_above_box': 0.0, 'concept_no_pink_cell_below_m_concept_wall_above_box': 0.0, 'NOT_concept_target_on_top_concept_wall_above_box': 0.0, 'NOT_concept_wall_top_right_concept_wall_above_box': 0.0, 'concept_box_on_top_concept_wall_above_box': 0.0, 'concept_no_wall_below_m_concept_wall_above_box': 0.0, 'NOT_concept_wall_on_left_concept_wall_above_box': 0.0, 'concept_wall_above_box_concept_wall_on_left_of_box': 0.0, 'NOT_concept_box_on_top_concept_wall_above_box': 0.0, 'concept_blank_cell_on_left_concept_wall_above_box': 0.0, 'NOT_concept_wall_on_right_concept_wall_above_box': 0.0, 'NOT_concept_pink_cell_on_right_concept_wall_above_box': 0.0, 'NOT_concept_box_on_left_concept_wall_above_box': 0.0, 'NOT_concept_wall_down_left_concept_wall_above_box': 0.0, 'NOT_concept_pink_cell_below_concept_wall_above_box': 0.0, 'NOT_concept_wall_below_concept_wall_above_box': 0.0, 'concept_box_on_left_concept_wall_on_right_of_box': 0.0, 'concept_no_wall_on_top_m_concept_wall_on_right_of_box': 0.2222222222222222, 'NOT_concept_pink_cell_on_top_concept_wall_on_right_of_box': 0.2222222222222222, 'concept_no_pink_cell_on_top_m_concept_wall_on_right_of_box': 0.2222222222222222, 'NOT_concept_no_wall_below_m_concept_wall_on_right_of_box': 0.1111111111111111, 'concept_wall_below_box_concept_wall_on_right_of_box': 0.0, 'concept_wall_on_right_concept_wall_on_right_of_box': 0.16666666666666666, 'concept_pink_cell_below_concept_wall_on_right_of_box': 0.0, 'NOT_concept_blank_cell_on_left_concept_wall_on_right_of_box': 0.05555555555555555, 'NOT_concept_target_on_right_concept_wall_on_right_of_box': 0.2222222222222222, 'concept_no_pink_cell_below_m_concept_wall_on_right_of_box': 0.16666666666666666, 'NOT_concept_target_on_top_concept_wall_on_right_of_box': 0.2222222222222222, 'NOT_concept_wall_top_right_concept_wall_on_right_of_box': 0.2222222222222222, 'concept_box_on_top_concept_wall_on_right_of_box': 0.0, 'concept_no_wall_below_m_concept_wall_on_right_of_box': 0.1111111111111111, 'NOT_concept_wall_on_left_concept_wall_on_right_of_box': 0.2222222222222222, 'concept_wall_on_left_of_box_concept_wall_on_right_of_box': 0.0, 'NOT_concept_box_on_top_concept_wall_on_right_of_box': 0.2222222222222222, 'concept_blank_cell_on_left_concept_wall_on_right_of_box': 0.16666666666666666, 'NOT_concept_wall_on_right_concept_wall_on_right_of_box': 0.05555555555555555, 'NOT_concept_pink_cell_on_right_concept_wall_on_right_of_box': 0.2222222222222222, 'NOT_concept_box_on_left_concept_wall_on_right_of_box': 0.2222222222222222, 'NOT_concept_wall_down_left_concept_wall_on_right_of_box': 0.2222222222222222, 'NOT_concept_pink_cell_below_concept_wall_on_right_of_box': 0.2222222222222222, 'NOT_concept_wall_below_concept_wall_on_right_of_box': 0.16666666666666666, 'concept_box_on_left_concept_no_wall_on_top_m': 0.0, 'NOT_concept_pink_cell_on_top_concept_box_on_left': 0.0, 'concept_box_on_left_concept_no_pink_cell_on_top_m': 0.0, 'NOT_concept_no_wall_below_m_concept_box_on_left': 0.0, 'concept_box_on_left_concept_wall_below_box': 0.0, 'concept_box_on_left_concept_wall_on_right': 0.0, 'concept_box_on_left_concept_pink_cell_below': 0.0, 'NOT_concept_blank_cell_on_left_concept_box_on_left': 0.0, 'NOT_concept_target_on_right_concept_box_on_left': 0.0, 'concept_box_on_left_concept_no_pink_cell_below_m': 0.0, 'NOT_concept_target_on_top_concept_box_on_left': 0.0, 'NOT_concept_wall_top_right_concept_box_on_left': 0.0, 'concept_box_on_left_concept_box_on_top': 0.0, 'concept_box_on_left_concept_no_wall_below_m': 0.0, 'NOT_concept_wall_on_left_concept_box_on_left': 0.0, 'concept_box_on_left_concept_wall_on_left_of_box': 0.0, 'NOT_concept_box_on_top_concept_box_on_left': 0.0, 'concept_blank_cell_on_left_concept_box_on_left': 0.0, 'NOT_concept_wall_on_right_concept_box_on_left': 0.0, 'NOT_concept_pink_cell_on_right_concept_box_on_left': 0.0, 'NOT_concept_box_on_left_concept_box_on_left': 0.0, 'NOT_concept_wall_down_left_concept_box_on_left': 0.0, 'NOT_concept_pink_cell_below_concept_box_on_left': 0.0, 'NOT_concept_wall_below_concept_box_on_left': 0.0, 'NOT_concept_pink_cell_on_top_concept_no_wall_on_top_m': 0.8333333333333334, 'concept_no_pink_cell_on_top_m_concept_no_wall_on_top_m': 0.7777777777777778, 'NOT_concept_no_wall_below_m_concept_no_wall_on_top_m': 0.3333333333333333, 'concept_no_wall_on_top_m_concept_wall_below_box': 0.0, 'concept_no_wall_on_top_m_concept_wall_on_right': 0.2222222222222222, 'concept_no_wall_on_top_m_concept_pink_cell_below': 0.1111111111111111, 'NOT_concept_blank_cell_on_left_concept_no_wall_on_top_m': 0.5, 'NOT_concept_target_on_right_concept_no_wall_on_top_m': 1.0, 'concept_no_pink_cell_below_m_concept_no_wall_on_top_m': 0.7222222222222222, 'NOT_concept_target_on_top_concept_no_wall_on_top_m': 1.0, 'NOT_concept_wall_top_right_concept_no_wall_on_top_m': 1.0, 'concept_box_on_top_concept_no_wall_on_top_m': 0.0, 'concept_no_wall_below_m_concept_no_wall_on_top_m': 0.6666666666666666, 'NOT_concept_wall_on_left_concept_no_wall_on_top_m': 0.6666666666666666, 'concept_no_wall_on_top_m_concept_wall_on_left_of_box': 0.2777777777777778, 'NOT_concept_box_on_top_concept_no_wall_on_top_m': 1.0, 'concept_blank_cell_on_left_concept_no_wall_on_top_m': 0.5, 'NOT_concept_wall_on_right_concept_no_wall_on_top_m': 0.7777777777777778, 'NOT_concept_pink_cell_on_right_concept_no_wall_on_top_m': 0.8333333333333334, 'NOT_concept_box_on_left_concept_no_wall_on_top_m': 1.0, 'NOT_concept_wall_down_left_concept_no_wall_on_top_m': 0.9444444444444444, 'NOT_concept_pink_cell_below_concept_no_wall_on_top_m': 0.8888888888888888, 'NOT_concept_wall_below_concept_no_wall_on_top_m': 0.8333333333333334, 'NOT_concept_pink_cell_on_top_concept_no_pink_cell_on_top_m': 0.7777777777777778, 'NOT_concept_no_wall_below_m_NOT_concept_pink_cell_on_top': 0.3333333333333333, 'NOT_concept_pink_cell_on_top_concept_wall_below_box': 0.0, 'NOT_concept_pink_cell_on_top_concept_wall_on_right': 0.2222222222222222, 'NOT_concept_pink_cell_on_top_concept_pink_cell_below': 0.05555555555555555, 'NOT_concept_blank_cell_on_left_NOT_concept_pink_cell_on_top': 0.5, 'NOT_concept_pink_cell_on_top_NOT_concept_target_on_right': 0.8333333333333334, 'NOT_concept_pink_cell_on_top_concept_no_pink_cell_below_m': 0.6111111111111112, 'NOT_concept_pink_cell_on_top_NOT_concept_target_on_top': 0.8333333333333334, 'NOT_concept_pink_cell_on_top_NOT_concept_wall_top_right': 0.8333333333333334, 'NOT_concept_pink_cell_on_top_concept_box_on_top': 0.0, 'NOT_concept_pink_cell_on_top_concept_no_wall_below_m': 0.5, 'NOT_concept_pink_cell_on_top_NOT_concept_wall_on_left': 0.5, 'NOT_concept_pink_cell_on_top_concept_wall_on_left_of_box': 0.2777777777777778, 'NOT_concept_box_on_top_NOT_concept_pink_cell_on_top': 0.8333333333333334, 'NOT_concept_pink_cell_on_top_concept_blank_cell_on_left': 0.3333333333333333, 'NOT_concept_pink_cell_on_top_NOT_concept_wall_on_right': 0.6111111111111112, 'NOT_concept_pink_cell_on_right_NOT_concept_pink_cell_on_top': 0.6666666666666666, 'NOT_concept_box_on_left_NOT_concept_pink_cell_on_top': 0.8333333333333334, 'NOT_concept_pink_cell_on_top_NOT_concept_wall_down_left': 0.7777777777777778, 'NOT_concept_pink_cell_below_NOT_concept_pink_cell_on_top': 0.7777777777777778, 'NOT_concept_pink_cell_on_top_NOT_concept_wall_below': 0.6666666666666666, 'NOT_concept_no_wall_below_m_concept_no_pink_cell_on_top_m': 0.2777777777777778, 'concept_no_pink_cell_on_top_m_concept_wall_below_box': 0.0, 'concept_no_pink_cell_on_top_m_concept_wall_on_right': 0.2222222222222222, 'concept_no_pink_cell_on_top_m_concept_pink_cell_below': 0.05555555555555555, 'NOT_concept_blank_cell_on_left_concept_no_pink_cell_on_top_m': 0.5, 'NOT_concept_target_on_right_concept_no_pink_cell_on_top_m': 0.7777777777777778, 'concept_no_pink_cell_below_m_concept_no_pink_cell_on_top_m': 0.5555555555555556, 'NOT_concept_target_on_top_concept_no_pink_cell_on_top_m': 0.7777777777777778, 'NOT_concept_wall_top_right_concept_no_pink_cell_on_top_m': 0.7777777777777778, 'concept_box_on_top_concept_no_pink_cell_on_top_m': 0.0, 'concept_no_pink_cell_on_top_m_concept_no_wall_below_m': 0.5, 'NOT_concept_wall_on_left_concept_no_pink_cell_on_top_m': 0.4444444444444444, 'concept_no_pink_cell_on_top_m_concept_wall_on_left_of_box': 0.2777777777777778, 'NOT_concept_box_on_top_concept_no_pink_cell_on_top_m': 0.7777777777777778, 'concept_blank_cell_on_left_concept_no_pink_cell_on_top_m': 0.2777777777777778, 'NOT_concept_wall_on_right_concept_no_pink_cell_on_top_m': 0.5555555555555556, 'NOT_concept_pink_cell_on_right_concept_no_pink_cell_on_top_m': 0.6111111111111112, 'NOT_concept_box_on_left_concept_no_pink_cell_on_top_m': 0.7777777777777778, 'NOT_concept_wall_down_left_concept_no_pink_cell_on_top_m': 0.7222222222222222, 'NOT_concept_pink_cell_below_concept_no_pink_cell_on_top_m': 0.7222222222222222, 'NOT_concept_wall_below_concept_no_pink_cell_on_top_m': 0.6111111111111112, 'NOT_concept_no_wall_below_m_concept_wall_below_box': 0.0, 'NOT_concept_no_wall_below_m_concept_wall_on_right': 0.05555555555555555, 'NOT_concept_no_wall_below_m_concept_pink_cell_below': 0.0, 'NOT_concept_blank_cell_on_left_NOT_concept_no_wall_below_m': 0.1111111111111111, 'NOT_concept_no_wall_below_m_NOT_concept_target_on_right': 0.3333333333333333, 'NOT_concept_no_wall_below_m_concept_no_pink_cell_below_m': 0.16666666666666666, 'NOT_concept_no_wall_below_m_NOT_concept_target_on_top': 0.3333333333333333, 'NOT_concept_no_wall_below_m_NOT_concept_wall_top_right': 0.3333333333333333, 'NOT_concept_no_wall_below_m_concept_box_on_top': 0.0, 'NOT_concept_no_wall_below_m_concept_no_wall_below_m': 0.0, 'NOT_concept_no_wall_below_m_NOT_concept_wall_on_left': 0.2222222222222222, 'NOT_concept_no_wall_below_m_concept_wall_on_left_of_box': 0.1111111111111111, 'NOT_concept_box_on_top_NOT_concept_no_wall_below_m': 0.3333333333333333, 'NOT_concept_no_wall_below_m_concept_blank_cell_on_left': 0.2222222222222222, 'NOT_concept_no_wall_below_m_NOT_concept_wall_on_right': 0.2777777777777778, 'NOT_concept_no_wall_below_m_NOT_concept_pink_cell_on_right': 0.3333333333333333, 'NOT_concept_box_on_left_NOT_concept_no_wall_below_m': 0.3333333333333333, 'NOT_concept_no_wall_below_m_NOT_concept_wall_down_left': 0.2777777777777778, 'NOT_concept_no_wall_below_m_NOT_concept_pink_cell_below': 0.3333333333333333, 'NOT_concept_no_wall_below_m_NOT_concept_wall_below': 0.16666666666666666, 'concept_wall_below_box_concept_wall_on_right': 0.0, 'concept_pink_cell_below_concept_wall_below_box': 0.0, 'NOT_concept_blank_cell_on_left_concept_wall_below_box': 0.0, 'NOT_concept_target_on_right_concept_wall_below_box': 0.0, 'concept_no_pink_cell_below_m_concept_wall_below_box': 0.0, 'NOT_concept_target_on_top_concept_wall_below_box': 0.0, 'NOT_concept_wall_top_right_concept_wall_below_box': 0.0, 'concept_box_on_top_concept_wall_below_box': 0.0, 'concept_no_wall_below_m_concept_wall_below_box': 0.0, 'NOT_concept_wall_on_left_concept_wall_below_box': 0.0, 'concept_wall_below_box_concept_wall_on_left_of_box': 0.0, 'NOT_concept_box_on_top_concept_wall_below_box': 0.0, 'concept_blank_cell_on_left_concept_wall_below_box': 0.0, 'NOT_concept_wall_on_right_concept_wall_below_box': 0.0, 'NOT_concept_pink_cell_on_right_concept_wall_below_box': 0.0, 'NOT_concept_box_on_left_concept_wall_below_box': 0.0, 'NOT_concept_wall_down_left_concept_wall_below_box': 0.0, 'NOT_concept_pink_cell_below_concept_wall_below_box': 0.0, 'NOT_concept_wall_below_concept_wall_below_box': 0.0, 'concept_pink_cell_below_concept_wall_on_right': 0.0, 'NOT_concept_blank_cell_on_left_concept_wall_on_right': 0.1111111111111111, 'NOT_concept_target_on_right_concept_wall_on_right': 0.2222222222222222, 'concept_no_pink_cell_below_m_concept_wall_on_right': 0.2222222222222222, 'NOT_concept_target_on_top_concept_wall_on_right': 0.2222222222222222, 'NOT_concept_wall_top_right_concept_wall_on_right': 0.2222222222222222, 'concept_box_on_top_concept_wall_on_right': 0.0, 'concept_no_wall_below_m_concept_wall_on_right': 0.16666666666666666, 'NOT_concept_wall_on_left_concept_wall_on_right': 0.2222222222222222, 'concept_wall_on_left_of_box_concept_wall_on_right': 0.0, 'NOT_concept_box_on_top_concept_wall_on_right': 0.2222222222222222, 'concept_blank_cell_on_left_concept_wall_on_right': 0.1111111111111111, 'NOT_concept_wall_on_right_concept_wall_on_right': 0.0, 'NOT_concept_pink_cell_on_right_concept_wall_on_right': 0.2222222222222222, 'NOT_concept_box_on_left_concept_wall_on_right': 0.2222222222222222, 'NOT_concept_wall_down_left_concept_wall_on_right': 0.2222222222222222, 'NOT_concept_pink_cell_below_concept_wall_on_right': 0.2222222222222222, 'NOT_concept_wall_below_concept_wall_on_right': 0.2222222222222222, 'NOT_concept_blank_cell_on_left_concept_pink_cell_below': 0.0, 'NOT_concept_target_on_right_concept_pink_cell_below': 0.1111111111111111, 'concept_no_pink_cell_below_m_concept_pink_cell_below': 0.0, 'NOT_concept_target_on_top_concept_pink_cell_below': 0.1111111111111111, 'NOT_concept_wall_top_right_concept_pink_cell_below': 0.1111111111111111, 'concept_box_on_top_concept_pink_cell_below': 0.0, 'concept_no_wall_below_m_concept_pink_cell_below': 0.1111111111111111, 'NOT_concept_wall_on_left_concept_pink_cell_below': 0.1111111111111111, 'concept_pink_cell_below_concept_wall_on_left_of_box': 0.0, 'NOT_concept_box_on_top_concept_pink_cell_below': 0.1111111111111111, 'concept_blank_cell_on_left_concept_pink_cell_below': 0.1111111111111111, 'NOT_concept_wall_on_right_concept_pink_cell_below': 0.1111111111111111, 'NOT_concept_pink_cell_on_right_concept_pink_cell_below': 0.1111111111111111, 'NOT_concept_box_on_left_concept_pink_cell_below': 0.1111111111111111, 'NOT_concept_wall_down_left_concept_pink_cell_below': 0.1111111111111111, 'NOT_concept_pink_cell_below_concept_pink_cell_below': 0.0, 'NOT_concept_wall_below_concept_pink_cell_below': 0.1111111111111111, 'NOT_concept_blank_cell_on_left_NOT_concept_target_on_right': 0.5, 'NOT_concept_blank_cell_on_left_concept_no_pink_cell_below_m': 0.4444444444444444, 'NOT_concept_blank_cell_on_left_NOT_concept_target_on_top': 0.5, 'NOT_concept_blank_cell_on_left_NOT_concept_wall_top_right': 0.5, 'NOT_concept_blank_cell_on_left_concept_box_on_top': 0.0, 'NOT_concept_blank_cell_on_left_concept_no_wall_below_m': 0.3888888888888889, 'NOT_concept_blank_cell_on_left_NOT_concept_wall_on_left': 0.16666666666666666, 'NOT_concept_blank_cell_on_left_concept_wall_on_left_of_box': 0.2777777777777778, 'NOT_concept_blank_cell_on_left_NOT_concept_box_on_top': 0.5, 'NOT_concept_blank_cell_on_left_concept_blank_cell_on_left': 0.0, 'NOT_concept_blank_cell_on_left_NOT_concept_wall_on_right': 0.3888888888888889, 'NOT_concept_blank_cell_on_left_NOT_concept_pink_cell_on_right': 0.3333333333333333, 'NOT_concept_blank_cell_on_left_NOT_concept_box_on_left': 0.5, 'NOT_concept_blank_cell_on_left_NOT_concept_wall_down_left': 0.4444444444444444, 'NOT_concept_blank_cell_on_left_NOT_concept_pink_cell_below': 0.5, 'NOT_concept_blank_cell_on_left_NOT_concept_wall_below': 0.4444444444444444, 'NOT_concept_target_on_right_concept_no_pink_cell_below_m': 0.7222222222222222, 'NOT_concept_target_on_right_NOT_concept_target_on_top': 1.0, 'NOT_concept_target_on_right_NOT_concept_wall_top_right': 1.0, 'NOT_concept_target_on_right_concept_box_on_top': 0.0, 'NOT_concept_target_on_right_concept_no_wall_below_m': 0.6666666666666666, 'NOT_concept_target_on_right_NOT_concept_wall_on_left': 0.6666666666666666, 'NOT_concept_target_on_right_concept_wall_on_left_of_box': 0.2777777777777778, 'NOT_concept_box_on_top_NOT_concept_target_on_right': 1.0, 'NOT_concept_target_on_right_concept_blank_cell_on_left': 0.5, 'NOT_concept_target_on_right_NOT_concept_wall_on_right': 0.7777777777777778, 'NOT_concept_pink_cell_on_right_NOT_concept_target_on_right': 0.8333333333333334, 'NOT_concept_box_on_left_NOT_concept_target_on_right': 1.0, 'NOT_concept_target_on_right_NOT_concept_wall_down_left': 0.9444444444444444, 'NOT_concept_pink_cell_below_NOT_concept_target_on_right': 0.8888888888888888, 'NOT_concept_target_on_right_NOT_concept_wall_below': 0.8333333333333334, 'NOT_concept_target_on_top_concept_no_pink_cell_below_m': 0.7222222222222222, 'NOT_concept_wall_top_right_concept_no_pink_cell_below_m': 0.7222222222222222, 'concept_box_on_top_concept_no_pink_cell_below_m': 0.0, 'concept_no_pink_cell_below_m_concept_no_wall_below_m': 0.5555555555555556, 'NOT_concept_wall_on_left_concept_no_pink_cell_below_m': 0.4444444444444444, 'concept_no_pink_cell_below_m_concept_wall_on_left_of_box': 0.2222222222222222, 'NOT_concept_box_on_top_concept_no_pink_cell_below_m': 0.7222222222222222, 'concept_blank_cell_on_left_concept_no_pink_cell_below_m': 0.2777777777777778, 'NOT_concept_wall_on_right_concept_no_pink_cell_below_m': 0.5, 'NOT_concept_pink_cell_on_right_concept_no_pink_cell_below_m': 0.5555555555555556, 'NOT_concept_box_on_left_concept_no_pink_cell_below_m': 0.7222222222222222, 'NOT_concept_wall_down_left_concept_no_pink_cell_below_m': 0.7222222222222222, 'NOT_concept_pink_cell_below_concept_no_pink_cell_below_m': 0.7222222222222222, 'NOT_concept_wall_below_concept_no_pink_cell_below_m': 0.7222222222222222, 'NOT_concept_target_on_top_NOT_concept_wall_top_right': 1.0, 'NOT_concept_target_on_top_concept_box_on_top': 0.0, 'NOT_concept_target_on_top_concept_no_wall_below_m': 0.6666666666666666, 'NOT_concept_target_on_top_NOT_concept_wall_on_left': 0.6666666666666666, 'NOT_concept_target_on_top_concept_wall_on_left_of_box': 0.2777777777777778, 'NOT_concept_box_on_top_NOT_concept_target_on_top': 1.0, 'NOT_concept_target_on_top_concept_blank_cell_on_left': 0.5, 'NOT_concept_target_on_top_NOT_concept_wall_on_right': 0.7777777777777778, 'NOT_concept_pink_cell_on_right_NOT_concept_target_on_top': 0.8333333333333334, 'NOT_concept_box_on_left_NOT_concept_target_on_top': 1.0, 'NOT_concept_target_on_top_NOT_concept_wall_down_left': 0.9444444444444444, 'NOT_concept_pink_cell_below_NOT_concept_target_on_top': 0.8888888888888888, 'NOT_concept_target_on_top_NOT_concept_wall_below': 0.8333333333333334, 'NOT_concept_wall_top_right_concept_box_on_top': 0.0, 'NOT_concept_wall_top_right_concept_no_wall_below_m': 0.6666666666666666, 'NOT_concept_wall_on_left_NOT_concept_wall_top_right': 0.6666666666666666, 'NOT_concept_wall_top_right_concept_wall_on_left_of_box': 0.2777777777777778, 'NOT_concept_box_on_top_NOT_concept_wall_top_right': 1.0, 'NOT_concept_wall_top_right_concept_blank_cell_on_left': 0.5, 'NOT_concept_wall_on_right_NOT_concept_wall_top_right': 0.7777777777777778, 'NOT_concept_pink_cell_on_right_NOT_concept_wall_top_right': 0.8333333333333334, 'NOT_concept_box_on_left_NOT_concept_wall_top_right': 1.0, 'NOT_concept_wall_down_left_NOT_concept_wall_top_right': 0.9444444444444444, 'NOT_concept_pink_cell_below_NOT_concept_wall_top_right': 0.8888888888888888, 'NOT_concept_wall_below_NOT_concept_wall_top_right': 0.8333333333333334, 'concept_box_on_top_concept_no_wall_below_m': 0.0, 'NOT_concept_wall_on_left_concept_box_on_top': 0.0, 'concept_box_on_top_concept_wall_on_left_of_box': 0.0, 'NOT_concept_box_on_top_concept_box_on_top': 0.0, 'concept_blank_cell_on_left_concept_box_on_top': 0.0, 'NOT_concept_wall_on_right_concept_box_on_top': 0.0, 'NOT_concept_pink_cell_on_right_concept_box_on_top': 0.0, 'NOT_concept_box_on_left_concept_box_on_top': 0.0, 'NOT_concept_wall_down_left_concept_box_on_top': 0.0, 'NOT_concept_pink_cell_below_concept_box_on_top': 0.0, 'NOT_concept_wall_below_concept_box_on_top': 0.0, 'NOT_concept_wall_on_left_concept_no_wall_below_m': 0.4444444444444444, 'concept_no_wall_below_m_concept_wall_on_left_of_box': 0.16666666666666666, 'NOT_concept_box_on_top_concept_no_wall_below_m': 0.6666666666666666, 'concept_blank_cell_on_left_concept_no_wall_below_m': 0.2777777777777778, 'NOT_concept_wall_on_right_concept_no_wall_below_m': 0.5, 'NOT_concept_pink_cell_on_right_concept_no_wall_below_m': 0.5, 'NOT_concept_box_on_left_concept_no_wall_below_m': 0.6666666666666666, 'NOT_concept_wall_down_left_concept_no_wall_below_m': 0.6666666666666666, 'NOT_concept_pink_cell_below_concept_no_wall_below_m': 0.5555555555555556, 'NOT_concept_wall_below_concept_no_wall_below_m': 0.6666666666666666, 'NOT_concept_wall_on_left_concept_wall_on_left_of_box': 0.0, 'NOT_concept_box_on_top_NOT_concept_wall_on_left': 0.6666666666666666, 'NOT_concept_wall_on_left_concept_blank_cell_on_left': 0.5, 'NOT_concept_wall_on_left_NOT_concept_wall_on_right': 0.4444444444444444, 'NOT_concept_pink_cell_on_right_NOT_concept_wall_on_left': 0.6666666666666666, 'NOT_concept_box_on_left_NOT_concept_wall_on_left': 0.6666666666666666, 'NOT_concept_wall_down_left_NOT_concept_wall_on_left': 0.6666666666666666, 'NOT_concept_pink_cell_below_NOT_concept_wall_on_left': 0.5555555555555556, 'NOT_concept_wall_below_NOT_concept_wall_on_left': 0.5555555555555556, 'NOT_concept_box_on_top_concept_wall_on_left_of_box': 0.2777777777777778, 'concept_blank_cell_on_left_concept_wall_on_left_of_box': 0.0, 'NOT_concept_wall_on_right_concept_wall_on_left_of_box': 0.2777777777777778, 'NOT_concept_pink_cell_on_right_concept_wall_on_left_of_box': 0.16666666666666666, 'NOT_concept_box_on_left_concept_wall_on_left_of_box': 0.2777777777777778, 'NOT_concept_wall_down_left_concept_wall_on_left_of_box': 0.2222222222222222, 'NOT_concept_pink_cell_below_concept_wall_on_left_of_box': 0.2777777777777778, 'NOT_concept_wall_below_concept_wall_on_left_of_box': 0.2222222222222222, 'NOT_concept_box_on_top_concept_blank_cell_on_left': 0.5, 'NOT_concept_box_on_top_NOT_concept_wall_on_right': 0.7777777777777778, 'NOT_concept_box_on_top_NOT_concept_pink_cell_on_right': 0.8333333333333334, 'NOT_concept_box_on_left_NOT_concept_box_on_top': 1.0, 'NOT_concept_box_on_top_NOT_concept_wall_down_left': 0.9444444444444444, 'NOT_concept_box_on_top_NOT_concept_pink_cell_below': 0.8888888888888888, 'NOT_concept_box_on_top_NOT_concept_wall_below': 0.8333333333333334, 'NOT_concept_wall_on_right_concept_blank_cell_on_left': 0.3888888888888889, 'NOT_concept_pink_cell_on_right_concept_blank_cell_on_left': 0.5, 'NOT_concept_box_on_left_concept_blank_cell_on_left': 0.5, 'NOT_concept_wall_down_left_concept_blank_cell_on_left': 0.5, 'NOT_concept_pink_cell_below_concept_blank_cell_on_left': 0.3888888888888889, 'NOT_concept_wall_below_concept_blank_cell_on_left': 0.3888888888888889, 'NOT_concept_pink_cell_on_right_NOT_concept_wall_on_right': 0.6111111111111112, 'NOT_concept_box_on_left_NOT_concept_wall_on_right': 0.7777777777777778, 'NOT_concept_wall_down_left_NOT_concept_wall_on_right': 0.7222222222222222, 'NOT_concept_pink_cell_below_NOT_concept_wall_on_right': 0.6666666666666666, 'NOT_concept_wall_below_NOT_concept_wall_on_right': 0.6111111111111112, 'NOT_concept_box_on_left_NOT_concept_pink_cell_on_right': 0.8333333333333334, 'NOT_concept_pink_cell_on_right_NOT_concept_wall_down_left': 0.7777777777777778, 'NOT_concept_pink_cell_below_NOT_concept_pink_cell_on_right': 0.7222222222222222, 'NOT_concept_pink_cell_on_right_NOT_concept_wall_below': 0.6666666666666666, 'NOT_concept_box_on_left_NOT_concept_wall_down_left': 0.9444444444444444, 'NOT_concept_box_on_left_NOT_concept_pink_cell_below': 0.8888888888888888, 'NOT_concept_box_on_left_NOT_concept_wall_below': 0.8333333333333334, 'NOT_concept_pink_cell_below_NOT_concept_wall_down_left': 0.8333333333333334, 'NOT_concept_wall_below_NOT_concept_wall_down_left': 0.8333333333333334, 'NOT_concept_pink_cell_below_NOT_concept_wall_below': 0.7222222222222222}, 7: {'NOT_concept_wall_down_right': 0.87, 'NOT_concept_wall_top_right': 0.906, 'NOT_concept_target_on_right': 0.956, 'NOT_concept_pink_cell_on_right': 1.0, 'concept_no_pink_cell_on_top_m': 0.712, 'NOT_concept_wall_below': 0.752, 'concept_blank_cell_on_left': 0.87, 'concept_no_wall_below_m': 0.612, 'NOT_concept_wall_below_box': 0.888, 'concept_no_wall_on_right_m': 0.3, 'NOT_concept_blank_cell_below': 0.36, 'NOT_concept_wall_top_left': 1.0, 'concept_no_wall_on_left_m': 0.606, 'NOT_concept_wall_on_top': 0.752, 'NOT_concept_wall_up_down_right': 1.0, 'NOT_concept_target_on_top': 0.954, 'NOT_concept_box_on_top': 1.0, 'NOT_concept_wall_on_right_of_box': 0.788, 'NOT_concept_on_pink_cell': 0.886, 'NOT_concept_wall_on_left': 1.0, 'concept_pink_cell_below': 0.122, 'NOT_concept_no_wall_on_top_m': 0.44, 'NOT_concept_wall_on_left_of_box': 0.784, 'NOT_concept_box_below': 1.0, 'NOT_concept_wall_down_left': 1.0, 'concept_wall_above_box': 0.124, 'NOT_concept_pink_cell_on_left': 0.866, 'NOT_concept_box_on_right': 1.0, 'NOT_concept_box_on_left': 1.0, 'NOT_concept_pink_cell_on_top': 0.872, 'NOT_concept_wall_on_right': 0.622, 'NOT_concept_no_pink_cell_below_m': 0.308, 'concept_pink_cell_on_right': 0.0, 'concept_blank_cell_below': 0.632, 'concept_pink_cell_on_left': 0.126, 'concept_wall_top_right': 0.096, 'concept_box_below': 0.0, 'concept_box_on_right': 0.0, 'concept_wall_down_right': 0.124, 'NOT_concept_no_wall_on_right_m': 0.724, 'concept_wall_top_left': 0.0, 'concept_target_on_right': 0.034, 'concept_wall_below': 0.242, 'NOT_concept_no_wall_on_left_m': 0.396, 'NOT_concept_wall_above_box': 0.876, 'concept_pink_cell_on_top': 0.128, 'NOT_concept_no_pink_cell_on_top_m': 0.298, 'concept_on_pink_cell': 0.126, 'concept_target_on_top': 0.04, 'concept_wall_down_left': 0.0, 'concept_wall_on_left': 0.0, 'concept_wall_up_down_right': 0.0, 'concept_wall_on_top': 0.248, 'concept_wall_on_right_of_box': 0.21, 'concept_box_on_left': 0.0, 'concept_no_wall_on_top_m': 0.562, 'NOT_concept_no_wall_below_m': 0.386, 'concept_wall_below_box': 0.11, 'concept_wall_on_right': 0.368, 'NOT_concept_blank_cell_on_left': 0.124, 'concept_no_pink_cell_below_m': 0.694, 'concept_box_on_top': 0.0, 'concept_wall_on_left_of_box': 0.196, 'NOT_concept_pink_cell_below': 0.872, 'concept_blank_cell_below_concept_pink_cell_on_right': 0.0, 'concept_pink_cell_on_left_concept_pink_cell_on_right': 0.0, 'concept_pink_cell_on_right_concept_wall_top_right': 0.0, 'concept_box_below_concept_pink_cell_on_right': 0.0, 'NOT_concept_wall_down_right_concept_pink_cell_on_right': 0.0, 'concept_box_on_right_concept_pink_cell_on_right': 0.0, 'NOT_concept_wall_on_left_of_box_concept_pink_cell_on_right': 0.0, 'NOT_concept_wall_up_down_right_concept_pink_cell_on_right': 0.0, 'concept_no_wall_on_left_m_concept_pink_cell_on_right': 0.0, 'concept_pink_cell_on_right_concept_wall_down_right': 0.0, 'NOT_concept_pink_cell_on_left_concept_pink_cell_on_right': 0.0, 'NOT_concept_wall_below_box_concept_pink_cell_on_right': 0.0, 'NOT_concept_wall_on_top_concept_pink_cell_on_right': 0.0, 'NOT_concept_no_wall_on_right_m_concept_pink_cell_on_right': 0.0, 'NOT_concept_on_pink_cell_concept_pink_cell_on_right': 0.0, 'NOT_concept_box_on_right_concept_pink_cell_on_right': 0.0, 'concept_pink_cell_on_right_concept_wall_top_left': 0.0, 'concept_pink_cell_on_right_concept_target_on_right': 0.0, 'NOT_concept_blank_cell_below_concept_pink_cell_on_right': 0.0, 'concept_no_wall_on_right_m_concept_pink_cell_on_right': 0.0, 'concept_pink_cell_on_right_concept_wall_below': 0.0, 'NOT_concept_no_wall_on_left_m_concept_pink_cell_on_right': 0.0, 'NOT_concept_wall_top_left_concept_pink_cell_on_right': 0.0, 'NOT_concept_box_below_concept_pink_cell_on_right': 0.0, 'NOT_concept_wall_above_box_concept_pink_cell_on_right': 0.0, 'concept_pink_cell_on_right_concept_pink_cell_on_top': 0.0, 'NOT_concept_no_pink_cell_on_top_m_concept_pink_cell_on_right': 0.0, 'NOT_concept_wall_on_right_of_box_concept_pink_cell_on_right': 0.0, 'NOT_concept_no_wall_on_top_m_concept_pink_cell_on_right': 0.0, 'concept_on_pink_cell_concept_pink_cell_on_right': 0.0, 'concept_pink_cell_on_right_concept_target_on_top': 0.0, 'concept_pink_cell_on_right_concept_wall_down_left': 0.0, 'concept_pink_cell_on_right_concept_wall_on_left': 0.0, 'NOT_concept_no_pink_cell_below_m_concept_pink_cell_on_right': 0.0, 'concept_pink_cell_on_right_concept_wall_up_down_right': 0.0, 'concept_pink_cell_on_right_concept_wall_on_top': 0.0, 'concept_pink_cell_on_right_concept_wall_above_box': 0.0, 'concept_pink_cell_on_right_concept_wall_on_right_of_box': 0.0, 'concept_box_on_left_concept_pink_cell_on_right': 0.0, 'concept_no_wall_on_top_m_concept_pink_cell_on_right': 0.0, 'NOT_concept_pink_cell_on_top_concept_pink_cell_on_right': 0.0, 'concept_no_pink_cell_on_top_m_concept_pink_cell_on_right': 0.0, 'NOT_concept_no_wall_below_m_concept_pink_cell_on_right': 0.0, 'concept_pink_cell_on_right_concept_wall_below_box': 0.0, 'concept_pink_cell_on_right_concept_wall_on_right': 0.0, 'concept_pink_cell_below_concept_pink_cell_on_right': 0.0, 'NOT_concept_blank_cell_on_left_concept_pink_cell_on_right': 0.0, 'NOT_concept_target_on_right_concept_pink_cell_on_right': 0.0, 'concept_no_pink_cell_below_m_concept_pink_cell_on_right': 0.0, 'NOT_concept_target_on_top_concept_pink_cell_on_right': 0.0, 'NOT_concept_wall_top_right_concept_pink_cell_on_right': 0.0, 'concept_box_on_top_concept_pink_cell_on_right': 0.0, 'concept_no_wall_below_m_concept_pink_cell_on_right': 0.0, 'NOT_concept_wall_on_left_concept_pink_cell_on_right': 0.0, 'concept_pink_cell_on_right_concept_wall_on_left_of_box': 0.0, 'NOT_concept_box_on_top_concept_pink_cell_on_right': 0.0, 'concept_blank_cell_on_left_concept_pink_cell_on_right': 0.0, 'NOT_concept_wall_on_right_concept_pink_cell_on_right': 0.0, 'NOT_concept_pink_cell_on_right_concept_pink_cell_on_right': 0.0, 'NOT_concept_box_on_left_concept_pink_cell_on_right': 0.0, 'NOT_concept_wall_down_left_concept_pink_cell_on_right': 0.0, 'NOT_concept_pink_cell_below_concept_pink_cell_on_right': 0.0, 'NOT_concept_wall_below_concept_pink_cell_on_right': 0.0, 'concept_blank_cell_below_concept_pink_cell_on_left': 0.13, 'concept_blank_cell_below_concept_wall_top_right': 0.06, 'concept_blank_cell_below_concept_box_below': 0.0, 'NOT_concept_wall_down_right_concept_blank_cell_below': 0.636, 'concept_blank_cell_below_concept_box_on_right': 0.0, 'NOT_concept_wall_on_left_of_box_concept_blank_cell_below': 0.504, 'NOT_concept_wall_up_down_right_concept_blank_cell_below': 0.636, 'concept_blank_cell_below_concept_no_wall_on_left_m': 0.372, 'concept_blank_cell_below_concept_wall_down_right': 0.0, 'NOT_concept_pink_cell_on_left_concept_blank_cell_below': 0.502, 'NOT_concept_wall_below_box_concept_blank_cell_below': 0.554, 'NOT_concept_wall_on_top_concept_blank_cell_below': 0.462, 'NOT_concept_no_wall_on_right_m_concept_blank_cell_below': 0.516, 'NOT_concept_on_pink_cell_concept_blank_cell_below': 0.558, 'NOT_concept_box_on_right_concept_blank_cell_below': 0.632, 'concept_blank_cell_below_concept_wall_top_left': 0.0, 'concept_blank_cell_below_concept_target_on_right': 0.042, 'NOT_concept_blank_cell_below_concept_blank_cell_below': 0.0, 'concept_blank_cell_below_concept_no_wall_on_right_m': 0.124, 'concept_blank_cell_below_concept_wall_below': 0.0, 'NOT_concept_no_wall_on_left_m_concept_blank_cell_below': 0.254, 'NOT_concept_wall_top_left_concept_blank_cell_below': 0.622, 'NOT_concept_box_below_concept_blank_cell_below': 0.626, 'NOT_concept_wall_above_box_concept_blank_cell_below': 0.554, 'concept_blank_cell_below_concept_pink_cell_on_top': 0.084, 'NOT_concept_no_pink_cell_on_top_m_concept_blank_cell_below': 0.256, 'NOT_concept_wall_on_right_of_box_concept_blank_cell_below': 0.522, 'NOT_concept_no_wall_on_top_m_concept_blank_cell_below': 0.282, 'concept_blank_cell_below_concept_on_pink_cell': 0.074, 'concept_blank_cell_below_concept_target_on_top': 0.04, 'concept_blank_cell_below_concept_wall_down_left': 0.0, 'concept_blank_cell_below_concept_wall_on_left': 0.0, 'NOT_concept_no_pink_cell_below_m_concept_blank_cell_below': 0.046, 'concept_blank_cell_below_concept_wall_up_down_right': 0.0, 'concept_blank_cell_below_concept_wall_on_top': 0.18, 'concept_blank_cell_below_concept_wall_above_box': 0.084, 'concept_blank_cell_below_concept_wall_on_right_of_box': 0.134, 'concept_blank_cell_below_concept_box_on_left': 0.0, 'concept_blank_cell_below_concept_no_wall_on_top_m': 0.342, 'NOT_concept_pink_cell_on_top_concept_blank_cell_below': 0.546, 'concept_blank_cell_below_concept_no_pink_cell_on_top_m': 0.374, 'NOT_concept_no_wall_below_m_concept_blank_cell_below': 0.152, 'concept_blank_cell_below_concept_wall_below_box': 0.074, 'concept_blank_cell_below_concept_wall_on_right': 0.254, 'concept_blank_cell_below_concept_pink_cell_below': 0.0, 'NOT_concept_blank_cell_on_left_concept_blank_cell_below': 0.13, 'NOT_concept_target_on_right_concept_blank_cell_below': 0.586, 'concept_blank_cell_below_concept_no_pink_cell_below_m': 0.586, 'NOT_concept_target_on_top_concept_blank_cell_below': 0.586, 'NOT_concept_wall_top_right_concept_blank_cell_below': 0.57, 'concept_blank_cell_below_concept_box_on_top': 0.0, 'concept_blank_cell_below_concept_no_wall_below_m': 0.47, 'NOT_concept_wall_on_left_concept_blank_cell_below': 0.632, 'concept_blank_cell_below_concept_wall_on_left_of_box': 0.134, 'NOT_concept_box_on_top_concept_blank_cell_below': 0.632, 'concept_blank_cell_below_concept_blank_cell_on_left': 0.498, 'NOT_concept_wall_on_right_concept_blank_cell_below': 0.372, 'NOT_concept_pink_cell_on_right_concept_blank_cell_below': 0.636, 'NOT_concept_box_on_left_concept_blank_cell_below': 0.636, 'NOT_concept_wall_down_left_concept_blank_cell_below': 0.63, 'NOT_concept_pink_cell_below_concept_blank_cell_below': 0.638, 'NOT_concept_wall_below_concept_blank_cell_below': 0.622, 'concept_pink_cell_on_left_concept_wall_top_right': 0.0, 'concept_box_below_concept_pink_cell_on_left': 0.0, 'NOT_concept_wall_down_right_concept_pink_cell_on_left': 0.124, 'concept_box_on_right_concept_pink_cell_on_left': 0.0, 'NOT_concept_wall_on_left_of_box_concept_pink_cell_on_left': 0.114, 'NOT_concept_wall_up_down_right_concept_pink_cell_on_left': 0.134, 'concept_no_wall_on_left_m_concept_pink_cell_on_left': 0.132, 'concept_pink_cell_on_left_concept_wall_down_right': 0.0, 'NOT_concept_pink_cell_on_left_concept_pink_cell_on_left': 0.0, 'NOT_concept_wall_below_box_concept_pink_cell_on_left': 0.11, 'NOT_concept_wall_on_top_concept_pink_cell_on_left': 0.122, 'NOT_concept_no_wall_on_right_m_concept_pink_cell_on_left': 0.134, 'NOT_concept_on_pink_cell_concept_pink_cell_on_left': 0.114, 'NOT_concept_box_on_right_concept_pink_cell_on_left': 0.13, 'concept_pink_cell_on_left_concept_wall_top_left': 0.0, 'concept_pink_cell_on_left_concept_target_on_right': 0.0, 'NOT_concept_blank_cell_below_concept_pink_cell_on_left': 0.0, 'concept_no_wall_on_right_m_concept_pink_cell_on_left': 0.0, 'concept_pink_cell_on_left_concept_wall_below': 0.0, 'NOT_concept_no_wall_on_left_m_concept_pink_cell_on_left': 0.0, 'NOT_concept_wall_top_left_concept_pink_cell_on_left': 0.142, 'NOT_concept_box_below_concept_pink_cell_on_left': 0.14, 'NOT_concept_wall_above_box_concept_pink_cell_on_left': 0.112, 'concept_pink_cell_on_left_concept_pink_cell_on_top': 0.0, 'NOT_concept_no_pink_cell_on_top_m_concept_pink_cell_on_left': 0.0, 'NOT_concept_wall_on_right_of_box_concept_pink_cell_on_left': 0.108, 'NOT_concept_no_wall_on_top_m_concept_pink_cell_on_left': 0.0, 'concept_on_pink_cell_concept_pink_cell_on_left': 0.012, 'concept_pink_cell_on_left_concept_target_on_top': 0.0, 'concept_pink_cell_on_left_concept_wall_down_left': 0.0, 'concept_pink_cell_on_left_concept_wall_on_left': 0.0, 'NOT_concept_no_pink_cell_below_m_concept_pink_cell_on_left': 0.0, 'concept_pink_cell_on_left_concept_wall_up_down_right': 0.0, 'concept_pink_cell_on_left_concept_wall_on_top': 0.0, 'concept_pink_cell_on_left_concept_wall_above_box': 0.02, 'concept_pink_cell_on_left_concept_wall_on_right_of_box': 0.022, 'concept_box_on_left_concept_pink_cell_on_left': 0.0, 'concept_no_wall_on_top_m_concept_pink_cell_on_left': 0.122, 'NOT_concept_pink_cell_on_top_concept_pink_cell_on_left': 0.134, 'concept_no_pink_cell_on_top_m_concept_pink_cell_on_left': 0.138, 'NOT_concept_no_wall_below_m_concept_pink_cell_on_left': 0.0, 'concept_pink_cell_on_left_concept_wall_below_box': 0.02, 'concept_pink_cell_on_left_concept_wall_on_right': 0.096, 'concept_pink_cell_below_concept_pink_cell_on_left': 0.0, 'NOT_concept_blank_cell_on_left_concept_pink_cell_on_left': 0.142, 'NOT_concept_target_on_right_concept_pink_cell_on_left': 0.136, 'concept_no_pink_cell_below_m_concept_pink_cell_on_left': 0.126, 'NOT_concept_target_on_top_concept_pink_cell_on_left': 0.126, 'NOT_concept_wall_top_right_concept_pink_cell_on_left': 0.128, 'concept_box_on_top_concept_pink_cell_on_left': 0.0, 'concept_no_wall_below_m_concept_pink_cell_on_left': 0.138, 'NOT_concept_wall_on_left_concept_pink_cell_on_left': 0.126, 'concept_pink_cell_on_left_concept_wall_on_left_of_box': 0.028, 'NOT_concept_box_on_top_concept_pink_cell_on_left': 0.144, 'concept_blank_cell_on_left_concept_pink_cell_on_left': 0.0, 'NOT_concept_wall_on_right_concept_pink_cell_on_left': 0.038, 'NOT_concept_pink_cell_on_right_concept_pink_cell_on_left': 0.132, 'NOT_concept_box_on_left_concept_pink_cell_on_left': 0.132, 'NOT_concept_wall_down_left_concept_pink_cell_on_left': 0.144, 'NOT_concept_pink_cell_below_concept_pink_cell_on_left': 0.13, 'NOT_concept_wall_below_concept_pink_cell_on_left': 0.132, 'concept_box_below_concept_wall_top_right': 0.0, 'NOT_concept_wall_down_right_concept_wall_top_right': 0.066, 'concept_box_on_right_concept_wall_top_right': 0.0, 'NOT_concept_wall_on_left_of_box_concept_wall_top_right': 0.08, 'NOT_concept_wall_up_down_right_concept_wall_top_right': 0.088, 'concept_no_wall_on_left_m_concept_wall_top_right': 0.07, 'concept_wall_down_right_concept_wall_top_right': 0.038, 'NOT_concept_pink_cell_on_left_concept_wall_top_right': 0.09, 'NOT_concept_wall_below_box_concept_wall_top_right': 0.084, 'NOT_concept_wall_on_top_concept_wall_top_right': 0.0, 'NOT_concept_no_wall_on_right_m_concept_wall_top_right': 0.092, 'NOT_concept_on_pink_cell_concept_wall_top_right': 0.08, 'NOT_concept_box_on_right_concept_wall_top_right': 0.096, 'concept_wall_top_left_concept_wall_top_right': 0.0, 'concept_target_on_right_concept_wall_top_right': 0.0, 'NOT_concept_blank_cell_below_concept_wall_top_right': 0.036, 'concept_no_wall_on_right_m_concept_wall_top_right': 0.0, 'concept_wall_below_concept_wall_top_right': 0.038, 'NOT_concept_no_wall_on_left_m_concept_wall_top_right': 0.022, 'NOT_concept_wall_top_left_concept_wall_top_right': 0.098, 'NOT_concept_box_below_concept_wall_top_right': 0.1, 'NOT_concept_wall_above_box_concept_wall_top_right': 0.086, 'concept_pink_cell_on_top_concept_wall_top_right': 0.0, 'NOT_concept_no_pink_cell_on_top_m_concept_wall_top_right': 0.03, 'NOT_concept_wall_on_right_of_box_concept_wall_top_right': 0.072, 'NOT_concept_no_wall_on_top_m_concept_wall_top_right': 0.094, 'concept_on_pink_cell_concept_wall_top_right': 0.018, 'concept_target_on_top_concept_wall_top_right': 0.0, 'concept_wall_down_left_concept_wall_top_right': 0.0, 'concept_wall_on_left_concept_wall_top_right': 0.0, 'NOT_concept_no_pink_cell_below_m_concept_wall_top_right': 0.0, 'concept_wall_top_right_concept_wall_up_down_right': 0.0, 'concept_wall_on_top_concept_wall_top_right': 0.104, 'concept_wall_above_box_concept_wall_top_right': 0.006, 'concept_wall_on_right_of_box_concept_wall_top_right': 0.018, 'concept_box_on_left_concept_wall_top_right': 0.0, 'concept_no_wall_on_top_m_concept_wall_top_right': 0.0, 'NOT_concept_pink_cell_on_top_concept_wall_top_right': 0.088, 'concept_no_pink_cell_on_top_m_concept_wall_top_right': 0.05, 'NOT_concept_no_wall_below_m_concept_wall_top_right': 0.034, 'concept_wall_below_box_concept_wall_top_right': 0.006, 'concept_wall_on_right_concept_wall_top_right': 0.096, 'concept_pink_cell_below_concept_wall_top_right': 0.0, 'NOT_concept_blank_cell_on_left_concept_wall_top_right': 0.0, 'NOT_concept_target_on_right_concept_wall_top_right': 0.096, 'concept_no_pink_cell_below_m_concept_wall_top_right': 0.092, 'NOT_concept_target_on_top_concept_wall_top_right': 0.092, 'NOT_concept_wall_top_right_concept_wall_top_right': 0.0, 'concept_box_on_top_concept_wall_top_right': 0.0, 'concept_no_wall_below_m_concept_wall_top_right': 0.066, 'NOT_concept_wall_on_left_concept_wall_top_right': 0.094, 'concept_wall_on_left_of_box_concept_wall_top_right': 0.016, 'NOT_concept_box_on_top_concept_wall_top_right': 0.086, 'concept_blank_cell_on_left_concept_wall_top_right': 0.098, 'NOT_concept_wall_on_right_concept_wall_top_right': 0.0, 'NOT_concept_pink_cell_on_right_concept_wall_top_right': 0.092, 'NOT_concept_box_on_left_concept_wall_top_right': 0.09, 'NOT_concept_wall_down_left_concept_wall_top_right': 0.096, 'NOT_concept_pink_cell_below_concept_wall_top_right': 0.1, 'NOT_concept_wall_below_concept_wall_top_right': 0.054, 'NOT_concept_wall_down_right_concept_box_below': 0.0, 'concept_box_below_concept_box_on_right': 0.0, 'NOT_concept_wall_on_left_of_box_concept_box_below': 0.0, 'NOT_concept_wall_up_down_right_concept_box_below': 0.0, 'concept_box_below_concept_no_wall_on_left_m': 0.0, 'concept_box_below_concept_wall_down_right': 0.0, 'NOT_concept_pink_cell_on_left_concept_box_below': 0.0, 'NOT_concept_wall_below_box_concept_box_below': 0.0, 'NOT_concept_wall_on_top_concept_box_below': 0.0, 'NOT_concept_no_wall_on_right_m_concept_box_below': 0.0, 'NOT_concept_on_pink_cell_concept_box_below': 0.0, 'NOT_concept_box_on_right_concept_box_below': 0.0, 'concept_box_below_concept_wall_top_left': 0.0, 'concept_box_below_concept_target_on_right': 0.0, 'NOT_concept_blank_cell_below_concept_box_below': 0.0, 'concept_box_below_concept_no_wall_on_right_m': 0.0, 'concept_box_below_concept_wall_below': 0.0, 'NOT_concept_no_wall_on_left_m_concept_box_below': 0.0, 'NOT_concept_wall_top_left_concept_box_below': 0.0, 'NOT_concept_box_below_concept_box_below': 0.0, 'NOT_concept_wall_above_box_concept_box_below': 0.0, 'concept_box_below_concept_pink_cell_on_top': 0.0, 'NOT_concept_no_pink_cell_on_top_m_concept_box_below': 0.0, 'NOT_concept_wall_on_right_of_box_concept_box_below': 0.0, 'NOT_concept_no_wall_on_top_m_concept_box_below': 0.0, 'concept_box_below_concept_on_pink_cell': 0.0, 'concept_box_below_concept_target_on_top': 0.0, 'concept_box_below_concept_wall_down_left': 0.0, 'concept_box_below_concept_wall_on_left': 0.0, 'NOT_concept_no_pink_cell_below_m_concept_box_below': 0.0, 'concept_box_below_concept_wall_up_down_right': 0.0, 'concept_box_below_concept_wall_on_top': 0.0, 'concept_box_below_concept_wall_above_box': 0.0, 'concept_box_below_concept_wall_on_right_of_box': 0.0, 'concept_box_below_concept_box_on_left': 0.0, 'concept_box_below_concept_no_wall_on_top_m': 0.0, 'NOT_concept_pink_cell_on_top_concept_box_below': 0.0, 'concept_box_below_concept_no_pink_cell_on_top_m': 0.0, 'NOT_concept_no_wall_below_m_concept_box_below': 0.0, 'concept_box_below_concept_wall_below_box': 0.0, 'concept_box_below_concept_wall_on_right': 0.0, 'concept_box_below_concept_pink_cell_below': 0.0, 'NOT_concept_blank_cell_on_left_concept_box_below': 0.0, 'NOT_concept_target_on_right_concept_box_below': 0.0, 'concept_box_below_concept_no_pink_cell_below_m': 0.0, 'NOT_concept_target_on_top_concept_box_below': 0.0, 'NOT_concept_wall_top_right_concept_box_below': 0.0, 'concept_box_below_concept_box_on_top': 0.0, 'concept_box_below_concept_no_wall_below_m': 0.0, 'NOT_concept_wall_on_left_concept_box_below': 0.0, 'concept_box_below_concept_wall_on_left_of_box': 0.0, 'NOT_concept_box_on_top_concept_box_below': 0.0, 'concept_blank_cell_on_left_concept_box_below': 0.0, 'NOT_concept_wall_on_right_concept_box_below': 0.0, 'NOT_concept_pink_cell_on_right_concept_box_below': 0.0, 'NOT_concept_box_on_left_concept_box_below': 0.0, 'NOT_concept_wall_down_left_concept_box_below': 0.0, 'NOT_concept_pink_cell_below_concept_box_below': 0.0, 'NOT_concept_wall_below_concept_box_below': 0.0, 'NOT_concept_wall_down_right_concept_box_on_right': 0.0, 'NOT_concept_wall_down_right_NOT_concept_wall_on_left_of_box': 0.698, 'NOT_concept_wall_down_right_NOT_concept_wall_up_down_right': 0.876, 'NOT_concept_wall_down_right_concept_no_wall_on_left_m': 0.484, 'NOT_concept_wall_down_right_concept_wall_down_right': 0.0, 'NOT_concept_pink_cell_on_left_NOT_concept_wall_down_right': 0.74, 'NOT_concept_wall_below_box_NOT_concept_wall_down_right': 0.768, 'NOT_concept_wall_down_right_NOT_concept_wall_on_top': 0.652, 'NOT_concept_no_wall_on_right_m_NOT_concept_wall_down_right': 0.572, 'NOT_concept_on_pink_cell_NOT_concept_wall_down_right': 0.79, 'NOT_concept_box_on_right_NOT_concept_wall_down_right': 0.878, 'NOT_concept_wall_down_right_concept_wall_top_left': 0.0, 'NOT_concept_wall_down_right_concept_target_on_right': 0.044, 'NOT_concept_blank_cell_below_NOT_concept_wall_down_right': 0.234, 'NOT_concept_wall_down_right_concept_no_wall_on_right_m': 0.284, 'NOT_concept_wall_down_right_concept_wall_below': 0.124, 'NOT_concept_no_wall_on_left_m_NOT_concept_wall_down_right': 0.382, 'NOT_concept_wall_down_right_NOT_concept_wall_top_left': 0.878, 'NOT_concept_box_below_NOT_concept_wall_down_right': 0.872, 'NOT_concept_wall_above_box_NOT_concept_wall_down_right': 0.778, 'NOT_concept_wall_down_right_concept_pink_cell_on_top': 0.118, 'NOT_concept_no_pink_cell_on_top_m_NOT_concept_wall_down_right': 0.3, 'NOT_concept_wall_down_right_NOT_concept_wall_on_right_of_box': 0.7, 'NOT_concept_no_wall_on_top_m_NOT_concept_wall_down_right': 0.36, 'NOT_concept_wall_down_right_concept_on_pink_cell': 0.102, 'NOT_concept_wall_down_right_concept_target_on_top': 0.04, 'NOT_concept_wall_down_right_concept_wall_down_left': 0.0, 'NOT_concept_wall_down_right_concept_wall_on_left': 0.0, 'NOT_concept_no_pink_cell_below_m_NOT_concept_wall_down_right': 0.284, 'NOT_concept_wall_down_right_concept_wall_up_down_right': 0.0, 'NOT_concept_wall_down_right_concept_wall_on_top': 0.204, 'NOT_concept_wall_down_right_concept_wall_above_box': 0.104, 'NOT_concept_wall_down_right_concept_wall_on_right_of_box': 0.194, 'NOT_concept_wall_down_right_concept_box_on_left': 0.0, 'NOT_concept_wall_down_right_concept_no_wall_on_top_m': 0.536, 'NOT_concept_pink_cell_on_top_NOT_concept_wall_down_right': 0.738, 'NOT_concept_wall_down_right_concept_no_pink_cell_on_top_m': 0.604, 'NOT_concept_no_wall_below_m_NOT_concept_wall_down_right': 0.26, 'NOT_concept_wall_down_right_concept_wall_below_box': 0.108, 'NOT_concept_wall_down_right_concept_wall_on_right': 0.256, 'NOT_concept_wall_down_right_concept_pink_cell_below': 0.116, 'NOT_concept_blank_cell_on_left_NOT_concept_wall_down_right': 0.128, 'NOT_concept_target_on_right_NOT_concept_wall_down_right': 0.826, 'NOT_concept_wall_down_right_concept_no_pink_cell_below_m': 0.586, 'NOT_concept_target_on_top_NOT_concept_wall_down_right': 0.834, 'NOT_concept_wall_down_right_NOT_concept_wall_top_right': 0.81, 'NOT_concept_wall_down_right_concept_box_on_top': 0.0, 'NOT_concept_wall_down_right_concept_no_wall_below_m': 0.618, 'NOT_concept_wall_down_right_NOT_concept_wall_on_left': 0.882, 'NOT_concept_wall_down_right_concept_wall_on_left_of_box': 0.184, 'NOT_concept_box_on_top_NOT_concept_wall_down_right': 0.884, 'NOT_concept_wall_down_right_concept_blank_cell_on_left': 0.74, 'NOT_concept_wall_down_right_NOT_concept_wall_on_right': 0.632, 'NOT_concept_pink_cell_on_right_NOT_concept_wall_down_right': 0.88, 'NOT_concept_box_on_left_NOT_concept_wall_down_right': 0.872, 'NOT_concept_wall_down_left_NOT_concept_wall_down_right': 0.868, 'NOT_concept_pink_cell_below_NOT_concept_wall_down_right': 0.754, 'NOT_concept_wall_below_NOT_concept_wall_down_right': 0.76, 'NOT_concept_wall_on_left_of_box_concept_box_on_right': 0.0, 'NOT_concept_wall_up_down_right_concept_box_on_right': 0.0, 'concept_box_on_right_concept_no_wall_on_left_m': 0.0, 'concept_box_on_right_concept_wall_down_right': 0.0, 'NOT_concept_pink_cell_on_left_concept_box_on_right': 0.0, 'NOT_concept_wall_below_box_concept_box_on_right': 0.0, 'NOT_concept_wall_on_top_concept_box_on_right': 0.0, 'NOT_concept_no_wall_on_right_m_concept_box_on_right': 0.0, 'NOT_concept_on_pink_cell_concept_box_on_right': 0.0, 'NOT_concept_box_on_right_concept_box_on_right': 0.0, 'concept_box_on_right_concept_wall_top_left': 0.0, 'concept_box_on_right_concept_target_on_right': 0.0, 'NOT_concept_blank_cell_below_concept_box_on_right': 0.0, 'concept_box_on_right_concept_no_wall_on_right_m': 0.0, 'concept_box_on_right_concept_wall_below': 0.0, 'NOT_concept_no_wall_on_left_m_concept_box_on_right': 0.0, 'NOT_concept_wall_top_left_concept_box_on_right': 0.0, 'NOT_concept_box_below_concept_box_on_right': 0.0, 'NOT_concept_wall_above_box_concept_box_on_right': 0.0, 'concept_box_on_right_concept_pink_cell_on_top': 0.0, 'NOT_concept_no_pink_cell_on_top_m_concept_box_on_right': 0.0, 'NOT_concept_wall_on_right_of_box_concept_box_on_right': 0.0, 'NOT_concept_no_wall_on_top_m_concept_box_on_right': 0.0, 'concept_box_on_right_concept_on_pink_cell': 0.0, 'concept_box_on_right_concept_target_on_top': 0.0, 'concept_box_on_right_concept_wall_down_left': 0.0, 'concept_box_on_right_concept_wall_on_left': 0.0, 'NOT_concept_no_pink_cell_below_m_concept_box_on_right': 0.0, 'concept_box_on_right_concept_wall_up_down_right': 0.0, 'concept_box_on_right_concept_wall_on_top': 0.0, 'concept_box_on_right_concept_wall_above_box': 0.0, 'concept_box_on_right_concept_wall_on_right_of_box': 0.0, 'concept_box_on_left_concept_box_on_right': 0.0, 'concept_box_on_right_concept_no_wall_on_top_m': 0.0, 'NOT_concept_pink_cell_on_top_concept_box_on_right': 0.0, 'concept_box_on_right_concept_no_pink_cell_on_top_m': 0.0, 'NOT_concept_no_wall_below_m_concept_box_on_right': 0.0, 'concept_box_on_right_concept_wall_below_box': 0.0, 'concept_box_on_right_concept_wall_on_right': 0.0, 'concept_box_on_right_concept_pink_cell_below': 0.0, 'NOT_concept_blank_cell_on_left_concept_box_on_right': 0.0, 'NOT_concept_target_on_right_concept_box_on_right': 0.0, 'concept_box_on_right_concept_no_pink_cell_below_m': 0.0, 'NOT_concept_target_on_top_concept_box_on_right': 0.0, 'NOT_concept_wall_top_right_concept_box_on_right': 0.0, 'concept_box_on_right_concept_box_on_top': 0.0, 'concept_box_on_right_concept_no_wall_below_m': 0.0, 'NOT_concept_wall_on_left_concept_box_on_right': 0.0, 'concept_box_on_right_concept_wall_on_left_of_box': 0.0, 'NOT_concept_box_on_top_concept_box_on_right': 0.0, 'concept_blank_cell_on_left_concept_box_on_right': 0.0, 'NOT_concept_wall_on_right_concept_box_on_right': 0.0, 'NOT_concept_pink_cell_on_right_concept_box_on_right': 0.0, 'NOT_concept_box_on_left_concept_box_on_right': 0.0, 'NOT_concept_wall_down_left_concept_box_on_right': 0.0, 'NOT_concept_pink_cell_below_concept_box_on_right': 0.0, 'NOT_concept_wall_below_concept_box_on_right': 0.0, 'NOT_concept_wall_on_left_of_box_NOT_concept_wall_up_down_right': 0.792, 'NOT_concept_wall_on_left_of_box_concept_no_wall_on_left_m': 0.462, 'NOT_concept_wall_on_left_of_box_concept_wall_down_right': 0.106, 'NOT_concept_pink_cell_on_left_NOT_concept_wall_on_left_of_box': 0.688, 'NOT_concept_wall_below_box_NOT_concept_wall_on_left_of_box': 0.69, 'NOT_concept_wall_on_left_of_box_NOT_concept_wall_on_top': 0.598, 'NOT_concept_no_wall_on_right_m_NOT_concept_wall_on_left_of_box': 0.582, 'NOT_concept_on_pink_cell_NOT_concept_wall_on_left_of_box': 0.678, 'NOT_concept_box_on_right_NOT_concept_wall_on_left_of_box': 0.794, 'NOT_concept_wall_on_left_of_box_concept_wall_top_left': 0.0, 'NOT_concept_wall_on_left_of_box_concept_target_on_right': 0.034, 'NOT_concept_blank_cell_below_NOT_concept_wall_on_left_of_box': 0.288, 'NOT_concept_wall_on_left_of_box_concept_no_wall_on_right_m': 0.246, 'NOT_concept_wall_on_left_of_box_concept_wall_below': 0.182, 'NOT_concept_no_wall_on_left_m_NOT_concept_wall_on_left_of_box': 0.334, 'NOT_concept_wall_on_left_of_box_NOT_concept_wall_top_left': 0.786, 'NOT_concept_box_below_NOT_concept_wall_on_left_of_box': 0.798, 'NOT_concept_wall_above_box_NOT_concept_wall_on_left_of_box': 0.668, 'NOT_concept_wall_on_left_of_box_concept_pink_cell_on_top': 0.102, 'NOT_concept_no_pink_cell_on_top_m_NOT_concept_wall_on_left_of_box': 0.242, 'NOT_concept_wall_on_left_of_box_NOT_concept_wall_on_right_of_box': 0.572, 'NOT_concept_no_wall_on_top_m_NOT_concept_wall_on_left_of_box': 0.344, 'NOT_concept_wall_on_left_of_box_concept_on_pink_cell': 0.13, 'NOT_concept_wall_on_left_of_box_concept_target_on_top': 0.03, 'NOT_concept_wall_on_left_of_box_concept_wall_down_left': 0.0, 'NOT_concept_wall_on_left_of_box_concept_wall_on_left': 0.0, 'NOT_concept_no_pink_cell_below_m_NOT_concept_wall_on_left_of_box': 0.234, 'NOT_concept_wall_on_left_of_box_concept_wall_up_down_right': 0.0, 'NOT_concept_wall_on_left_of_box_concept_wall_on_top': 0.202, 'NOT_concept_wall_on_left_of_box_concept_wall_above_box': 0.122, 'NOT_concept_wall_on_left_of_box_concept_wall_on_right_of_box': 0.208, 'NOT_concept_wall_on_left_of_box_concept_box_on_left': 0.0, 'NOT_concept_wall_on_left_of_box_concept_no_wall_on_top_m': 0.44, 'NOT_concept_pink_cell_on_top_NOT_concept_wall_on_left_of_box': 0.686, 'NOT_concept_wall_on_left_of_box_concept_no_pink_cell_on_top_m': 0.566, 'NOT_concept_no_wall_below_m_NOT_concept_wall_on_left_of_box': 0.296, 'NOT_concept_wall_on_left_of_box_concept_wall_below_box': 0.088, 'NOT_concept_wall_on_left_of_box_concept_wall_on_right': 0.3, 'NOT_concept_wall_on_left_of_box_concept_pink_cell_below': 0.098, 'NOT_concept_blank_cell_on_left_NOT_concept_wall_on_left_of_box': 0.104, 'NOT_concept_target_on_right_NOT_concept_wall_on_left_of_box': 0.764, 'NOT_concept_wall_on_left_of_box_concept_no_pink_cell_below_m': 0.564, 'NOT_concept_target_on_top_NOT_concept_wall_on_left_of_box': 0.748, 'NOT_concept_wall_on_left_of_box_NOT_concept_wall_top_right': 0.708, 'NOT_concept_wall_on_left_of_box_concept_box_on_top': 0.0, 'NOT_concept_wall_on_left_of_box_concept_no_wall_below_m': 0.502, 'NOT_concept_wall_on_left_NOT_concept_wall_on_left_of_box': 0.802, 'NOT_concept_wall_on_left_of_box_concept_wall_on_left_of_box': 0.0, 'NOT_concept_box_on_top_NOT_concept_wall_on_left_of_box': 0.8, 'NOT_concept_wall_on_left_of_box_concept_blank_cell_on_left': 0.7, 'NOT_concept_wall_on_left_of_box_NOT_concept_wall_on_right': 0.5, 'NOT_concept_pink_cell_on_right_NOT_concept_wall_on_left_of_box': 0.786, 'NOT_concept_box_on_left_NOT_concept_wall_on_left_of_box': 0.8, 'NOT_concept_wall_down_left_NOT_concept_wall_on_left_of_box': 0.802, 'NOT_concept_pink_cell_below_NOT_concept_wall_on_left_of_box': 0.696, 'NOT_concept_wall_below_NOT_concept_wall_on_left_of_box': 0.606, 'NOT_concept_wall_up_down_right_concept_no_wall_on_left_m': 0.608, 'NOT_concept_wall_up_down_right_concept_wall_down_right': 0.136, 'NOT_concept_pink_cell_on_left_NOT_concept_wall_up_down_right': 0.862, 'NOT_concept_wall_below_box_NOT_concept_wall_up_down_right': 0.88, 'NOT_concept_wall_on_top_NOT_concept_wall_up_down_right': 0.74, 'NOT_concept_no_wall_on_right_m_NOT_concept_wall_up_down_right': 0.714, 'NOT_concept_on_pink_cell_NOT_concept_wall_up_down_right': 0.876, 'NOT_concept_box_on_right_NOT_concept_wall_up_down_right': 1.0, 'NOT_concept_wall_up_down_right_concept_wall_top_left': 0.0, 'NOT_concept_wall_up_down_right_concept_target_on_right': 0.04, 'NOT_concept_blank_cell_below_NOT_concept_wall_up_down_right': 0.352, 'NOT_concept_wall_up_down_right_concept_no_wall_on_right_m': 0.274, 'NOT_concept_wall_up_down_right_concept_wall_below': 0.236, 'NOT_concept_no_wall_on_left_m_NOT_concept_wall_up_down_right': 0.424, 'NOT_concept_wall_top_left_NOT_concept_wall_up_down_right': 1.0, 'NOT_concept_box_below_NOT_concept_wall_up_down_right': 1.0, 'NOT_concept_wall_above_box_NOT_concept_wall_up_down_right': 0.888, 'NOT_concept_wall_up_down_right_concept_pink_cell_on_top': 0.136, 'NOT_concept_no_pink_cell_on_top_m_NOT_concept_wall_up_down_right': 0.282, 'NOT_concept_wall_on_right_of_box_NOT_concept_wall_up_down_right': 0.774, 'NOT_concept_no_wall_on_top_m_NOT_concept_wall_up_down_right': 0.44, 'NOT_concept_wall_up_down_right_concept_on_pink_cell': 0.128, 'NOT_concept_wall_up_down_right_concept_target_on_top': 0.048, 'NOT_concept_wall_up_down_right_concept_wall_down_left': 0.0, 'NOT_concept_wall_up_down_right_concept_wall_on_left': 0.0, 'NOT_concept_no_pink_cell_below_m_NOT_concept_wall_up_down_right': 0.32, 'NOT_concept_wall_up_down_right_concept_wall_up_down_right': 0.0, 'NOT_concept_wall_up_down_right_concept_wall_on_top': 0.254, 'NOT_concept_wall_up_down_right_concept_wall_above_box': 0.126, 'NOT_concept_wall_up_down_right_concept_wall_on_right_of_box': 0.212, 'NOT_concept_wall_up_down_right_concept_box_on_left': 0.0, 'NOT_concept_wall_up_down_right_concept_no_wall_on_top_m': 0.568, 'NOT_concept_pink_cell_on_top_NOT_concept_wall_up_down_right': 0.872, 'NOT_concept_wall_up_down_right_concept_no_pink_cell_on_top_m': 0.7, 'NOT_concept_no_wall_below_m_NOT_concept_wall_up_down_right': 0.384, 'NOT_concept_wall_up_down_right_concept_wall_below_box': 0.1, 'NOT_concept_wall_up_down_right_concept_wall_on_right': 0.374, 'NOT_concept_wall_up_down_right_concept_pink_cell_below': 0.128, 'NOT_concept_blank_cell_on_left_NOT_concept_wall_up_down_right': 0.128, 'NOT_concept_target_on_right_NOT_concept_wall_up_down_right': 0.956, 'NOT_concept_wall_up_down_right_concept_no_pink_cell_below_m': 0.688, 'NOT_concept_target_on_top_NOT_concept_wall_up_down_right': 0.96, 'NOT_concept_wall_top_right_NOT_concept_wall_up_down_right': 0.896, 'NOT_concept_wall_up_down_right_concept_box_on_top': 0.0, 'NOT_concept_wall_up_down_right_concept_no_wall_below_m': 0.626, 'NOT_concept_wall_on_left_NOT_concept_wall_up_down_right': 1.0, 'NOT_concept_wall_up_down_right_concept_wall_on_left_of_box': 0.208, 'NOT_concept_box_on_top_NOT_concept_wall_up_down_right': 1.0, 'NOT_concept_wall_up_down_right_concept_blank_cell_on_left': 0.88, 'NOT_concept_wall_on_right_NOT_concept_wall_up_down_right': 0.616, 'NOT_concept_pink_cell_on_right_NOT_concept_wall_up_down_right': 1.0, 'NOT_concept_box_on_left_NOT_concept_wall_up_down_right': 1.0, 'NOT_concept_wall_down_left_NOT_concept_wall_up_down_right': 1.0, 'NOT_concept_pink_cell_below_NOT_concept_wall_up_down_right': 0.878, 'NOT_concept_wall_below_NOT_concept_wall_up_down_right': 0.758, 'concept_no_wall_on_left_m_concept_wall_down_right': 0.098, 'NOT_concept_pink_cell_on_left_concept_no_wall_on_left_m': 0.486, 'NOT_concept_wall_below_box_concept_no_wall_on_left_m': 0.524, 'NOT_concept_wall_on_top_concept_no_wall_on_left_m': 0.406, 'NOT_concept_no_wall_on_right_m_concept_no_wall_on_left_m': 0.486, 'NOT_concept_on_pink_cell_concept_no_wall_on_left_m': 0.526, 'NOT_concept_box_on_right_concept_no_wall_on_left_m': 0.596, 'concept_no_wall_on_left_m_concept_wall_top_left': 0.0, 'concept_no_wall_on_left_m_concept_target_on_right': 0.036, 'NOT_concept_blank_cell_below_concept_no_wall_on_left_m': 0.228, 'concept_no_wall_on_left_m_concept_no_wall_on_right_m': 0.132, 'concept_no_wall_on_left_m_concept_wall_below': 0.168, 'NOT_concept_no_wall_on_left_m_concept_no_wall_on_left_m': 0.0, 'NOT_concept_wall_top_left_concept_no_wall_on_left_m': 0.6, 'NOT_concept_box_below_concept_no_wall_on_left_m': 0.59, 'NOT_concept_wall_above_box_concept_no_wall_on_left_m': 0.512, 'concept_no_wall_on_left_m_concept_pink_cell_on_top': 0.0, 'NOT_concept_no_pink_cell_on_top_m_concept_no_wall_on_left_m': 0.09, 'NOT_concept_wall_on_right_of_box_concept_no_wall_on_left_m': 0.482, 'NOT_concept_no_wall_on_top_m_concept_no_wall_on_left_m': 0.31, 'concept_no_wall_on_left_m_concept_on_pink_cell': 0.068, 'concept_no_wall_on_left_m_concept_target_on_top': 0.042, 'concept_no_wall_on_left_m_concept_wall_down_left': 0.0, 'concept_no_wall_on_left_m_concept_wall_on_left': 0.0, 'NOT_concept_no_pink_cell_below_m_concept_no_wall_on_left_m': 0.182, 'concept_no_wall_on_left_m_concept_wall_up_down_right': 0.0, 'concept_no_wall_on_left_m_concept_wall_on_top': 0.186, 'concept_no_wall_on_left_m_concept_wall_above_box': 0.08, 'concept_no_wall_on_left_m_concept_wall_on_right_of_box': 0.126, 'concept_box_on_left_concept_no_wall_on_left_m': 0.0, 'concept_no_wall_on_left_m_concept_no_wall_on_top_m': 0.276, 'NOT_concept_pink_cell_on_top_concept_no_wall_on_left_m': 0.596, 'concept_no_pink_cell_on_top_m_concept_no_wall_on_left_m': 0.522, 'NOT_concept_no_wall_below_m_concept_no_wall_on_left_m': 0.254, 'concept_no_wall_on_left_m_concept_wall_below_box': 0.068, 'concept_no_wall_on_left_m_concept_wall_on_right': 0.312, 'concept_no_wall_on_left_m_concept_pink_cell_below': 0.04, 'NOT_concept_blank_cell_on_left_concept_no_wall_on_left_m': 0.134, 'NOT_concept_target_on_right_concept_no_wall_on_left_m': 0.55, 'concept_no_pink_cell_below_m_concept_no_wall_on_left_m': 0.404, 'NOT_concept_target_on_top_concept_no_wall_on_left_m': 0.552, 'NOT_concept_wall_top_right_concept_no_wall_on_left_m': 0.522, 'concept_box_on_top_concept_no_wall_on_left_m': 0.0, 'concept_no_wall_below_m_concept_no_wall_on_left_m': 0.344, 'NOT_concept_wall_on_left_concept_no_wall_on_left_m': 0.608, 'concept_no_wall_on_left_m_concept_wall_on_left_of_box': 0.132, 'NOT_concept_box_on_top_concept_no_wall_on_left_m': 0.596, 'concept_blank_cell_on_left_concept_no_wall_on_left_m': 0.48, 'NOT_concept_wall_on_right_concept_no_wall_on_left_m': 0.274, 'NOT_concept_pink_cell_on_right_concept_no_wall_on_left_m': 0.594, 'NOT_concept_box_on_left_concept_no_wall_on_left_m': 0.584, 'NOT_concept_wall_down_left_concept_no_wall_on_left_m': 0.608, 'NOT_concept_pink_cell_below_concept_no_wall_on_left_m': 0.564, 'NOT_concept_wall_below_concept_no_wall_on_left_m': 0.434, 'NOT_concept_pink_cell_on_left_concept_wall_down_right': 0.128, 'NOT_concept_wall_below_box_concept_wall_down_right': 0.122, 'NOT_concept_wall_on_top_concept_wall_down_right': 0.094, 'NOT_concept_no_wall_on_right_m_concept_wall_down_right': 0.134, 'NOT_concept_on_pink_cell_concept_wall_down_right': 0.106, 'NOT_concept_box_on_right_concept_wall_down_right': 0.128, 'concept_wall_down_right_concept_wall_top_left': 0.0, 'concept_target_on_right_concept_wall_down_right': 0.0, 'NOT_concept_blank_cell_below_concept_wall_down_right': 0.118, 'concept_no_wall_on_right_m_concept_wall_down_right': 0.0, 'concept_wall_below_concept_wall_down_right': 0.128, 'NOT_concept_no_wall_on_left_m_concept_wall_down_right': 0.018, 'NOT_concept_wall_top_left_concept_wall_down_right': 0.128, 'NOT_concept_box_below_concept_wall_down_right': 0.13, 'NOT_concept_wall_above_box_concept_wall_down_right': 0.106, 'concept_pink_cell_on_top_concept_wall_down_right': 0.0, 'NOT_concept_no_pink_cell_on_top_m_concept_wall_down_right': 0.0, 'NOT_concept_wall_on_right_of_box_concept_wall_down_right': 0.098, 'NOT_concept_no_wall_on_top_m_concept_wall_down_right': 0.078, 'concept_on_pink_cell_concept_wall_down_right': 0.022, 'concept_target_on_top_concept_wall_down_right': 0.0, 'concept_wall_down_left_concept_wall_down_right': 0.0, 'concept_wall_down_right_concept_wall_on_left': 0.0, 'NOT_concept_no_pink_cell_below_m_concept_wall_down_right': 0.024, 'concept_wall_down_right_concept_wall_up_down_right': 0.0, 'concept_wall_down_right_concept_wall_on_top': 0.036, 'concept_wall_above_box_concept_wall_down_right': 0.014, 'concept_wall_down_right_concept_wall_on_right_of_box': 0.026, 'concept_box_on_left_concept_wall_down_right': 0.0, 'concept_no_wall_on_top_m_concept_wall_down_right': 0.05, 'NOT_concept_pink_cell_on_top_concept_wall_down_right': 0.138, 'concept_no_pink_cell_on_top_m_concept_wall_down_right': 0.132, 'NOT_concept_no_wall_below_m_concept_wall_down_right': 0.126, 'concept_wall_below_box_concept_wall_down_right': 0.008, 'concept_wall_down_right_concept_wall_on_right': 0.128, 'concept_pink_cell_below_concept_wall_down_right': 0.0, 'NOT_concept_blank_cell_on_left_concept_wall_down_right': 0.0, 'NOT_concept_target_on_right_concept_wall_down_right': 0.128, 'concept_no_pink_cell_below_m_concept_wall_down_right': 0.094, 'NOT_concept_target_on_top_concept_wall_down_right': 0.122, 'NOT_concept_wall_top_right_concept_wall_down_right': 0.092, 'concept_box_on_top_concept_wall_down_right': 0.0, 'concept_no_wall_below_m_concept_wall_down_right': 0.0, 'NOT_concept_wall_on_left_concept_wall_down_right': 0.126, 'concept_wall_down_right_concept_wall_on_left_of_box': 0.022, 'NOT_concept_box_on_top_concept_wall_down_right': 0.134, 'concept_blank_cell_on_left_concept_wall_down_right': 0.124, 'NOT_concept_wall_on_right_concept_wall_down_right': 0.0, 'NOT_concept_pink_cell_on_right_concept_wall_down_right': 0.124, 'NOT_concept_box_on_left_concept_wall_down_right': 0.126, 'NOT_concept_wall_down_left_concept_wall_down_right': 0.128, 'NOT_concept_pink_cell_below_concept_wall_down_right': 0.132, 'NOT_concept_wall_below_concept_wall_down_right': 0.0, 'NOT_concept_pink_cell_on_left_NOT_concept_wall_below_box': 0.77, 'NOT_concept_pink_cell_on_left_NOT_concept_wall_on_top': 0.62, 'NOT_concept_no_wall_on_right_m_NOT_concept_pink_cell_on_left': 0.57, 'NOT_concept_on_pink_cell_NOT_concept_pink_cell_on_left': 0.752, 'NOT_concept_box_on_right_NOT_concept_pink_cell_on_left': 0.864, 'NOT_concept_pink_cell_on_left_concept_wall_top_left': 0.0, 'NOT_concept_pink_cell_on_left_concept_target_on_right': 0.044, 'NOT_concept_blank_cell_below_NOT_concept_pink_cell_on_left': 0.378, 'NOT_concept_pink_cell_on_left_concept_no_wall_on_right_m': 0.29, 'NOT_concept_pink_cell_on_left_concept_wall_below': 0.244, 'NOT_concept_no_wall_on_left_m_NOT_concept_pink_cell_on_left': 0.404, 'NOT_concept_pink_cell_on_left_NOT_concept_wall_top_left': 0.864, 'NOT_concept_box_below_NOT_concept_pink_cell_on_left': 0.87, 'NOT_concept_pink_cell_on_left_NOT_concept_wall_above_box': 0.766, 'NOT_concept_pink_cell_on_left_concept_pink_cell_on_top': 0.136, 'NOT_concept_no_pink_cell_on_top_m_NOT_concept_pink_cell_on_left': 0.3, 'NOT_concept_pink_cell_on_left_NOT_concept_wall_on_right_of_box': 0.674, 'NOT_concept_no_wall_on_top_m_NOT_concept_pink_cell_on_left': 0.438, 'NOT_concept_pink_cell_on_left_concept_on_pink_cell': 0.108, 'NOT_concept_pink_cell_on_left_concept_target_on_top': 0.042, 'NOT_concept_pink_cell_on_left_concept_wall_down_left': 0.0, 'NOT_concept_pink_cell_on_left_concept_wall_on_left': 0.0, 'NOT_concept_no_pink_cell_below_m_NOT_concept_pink_cell_on_left': 0.306, 'NOT_concept_pink_cell_on_left_concept_wall_up_down_right': 0.0, 'NOT_concept_pink_cell_on_left_concept_wall_on_top': 0.26, 'NOT_concept_pink_cell_on_left_concept_wall_above_box': 0.106, 'NOT_concept_pink_cell_on_left_concept_wall_on_right_of_box': 0.178, 'NOT_concept_pink_cell_on_left_concept_box_on_left': 0.0, 'NOT_concept_pink_cell_on_left_concept_no_wall_on_top_m': 0.422, 'NOT_concept_pink_cell_on_left_NOT_concept_pink_cell_on_top': 0.728, 'NOT_concept_pink_cell_on_left_concept_no_pink_cell_on_top_m': 0.556, 'NOT_concept_no_wall_below_m_NOT_concept_pink_cell_on_left': 0.404, 'NOT_concept_pink_cell_on_left_concept_wall_below_box': 0.102, 'NOT_concept_pink_cell_on_left_concept_wall_on_right': 0.302, 'NOT_concept_pink_cell_on_left_concept_pink_cell_below': 0.138, 'NOT_concept_blank_cell_on_left_NOT_concept_pink_cell_on_left': 0.0, 'NOT_concept_pink_cell_on_left_NOT_concept_target_on_right': 0.828, 'NOT_concept_pink_cell_on_left_concept_no_pink_cell_below_m': 0.564, 'NOT_concept_pink_cell_on_left_NOT_concept_target_on_top': 0.832, 'NOT_concept_pink_cell_on_left_NOT_concept_wall_top_right': 0.774, 'NOT_concept_pink_cell_on_left_concept_box_on_top': 0.0, 'NOT_concept_pink_cell_on_left_concept_no_wall_below_m': 0.476, 'NOT_concept_pink_cell_on_left_NOT_concept_wall_on_left': 0.868, 'NOT_concept_pink_cell_on_left_concept_wall_on_left_of_box': 0.182, 'NOT_concept_box_on_top_NOT_concept_pink_cell_on_left': 0.876, 'NOT_concept_pink_cell_on_left_concept_blank_cell_on_left': 0.866, 'NOT_concept_pink_cell_on_left_NOT_concept_wall_on_right': 0.576, 'NOT_concept_pink_cell_on_left_NOT_concept_pink_cell_on_right': 0.882, 'NOT_concept_box_on_left_NOT_concept_pink_cell_on_left': 0.864, 'NOT_concept_pink_cell_on_left_NOT_concept_wall_down_left': 0.868, 'NOT_concept_pink_cell_below_NOT_concept_pink_cell_on_left': 0.73, 'NOT_concept_pink_cell_on_left_NOT_concept_wall_below': 0.626, 'NOT_concept_wall_below_box_NOT_concept_wall_on_top': 0.66, 'NOT_concept_no_wall_on_right_m_NOT_concept_wall_below_box': 0.626, 'NOT_concept_on_pink_cell_NOT_concept_wall_below_box': 0.746, 'NOT_concept_box_on_right_NOT_concept_wall_below_box': 0.886, 'NOT_concept_wall_below_box_concept_wall_top_left': 0.0, 'NOT_concept_wall_below_box_concept_target_on_right': 0.042, 'NOT_concept_blank_cell_below_NOT_concept_wall_below_box': 0.322, 'NOT_concept_wall_below_box_concept_no_wall_on_right_m': 0.248, 'NOT_concept_wall_below_box_concept_wall_below': 0.212, 'NOT_concept_no_wall_on_left_m_NOT_concept_wall_below_box': 0.358, 'NOT_concept_wall_below_box_NOT_concept_wall_top_left': 0.882, 'NOT_concept_box_below_NOT_concept_wall_below_box': 0.888, 'NOT_concept_wall_above_box_NOT_concept_wall_below_box': 0.774, 'NOT_concept_wall_below_box_concept_pink_cell_on_top': 0.116, 'NOT_concept_no_pink_cell_on_top_m_NOT_concept_wall_below_box': 0.25, 'NOT_concept_wall_below_box_NOT_concept_wall_on_right_of_box': 0.708, 'NOT_concept_no_wall_on_top_m_NOT_concept_wall_below_box': 0.402, 'NOT_concept_wall_below_box_concept_on_pink_cell': 0.122, 'NOT_concept_wall_below_box_concept_target_on_top': 0.036, 'NOT_concept_wall_below_box_concept_wall_down_left': 0.0, 'NOT_concept_wall_below_box_concept_wall_on_left': 0.0, 'NOT_concept_no_pink_cell_below_m_NOT_concept_wall_below_box': 0.282, 'NOT_concept_wall_below_box_concept_wall_up_down_right': 0.0, 'NOT_concept_wall_below_box_concept_wall_on_top': 0.232, 'NOT_concept_wall_below_box_concept_wall_above_box': 0.108, 'NOT_concept_wall_below_box_concept_wall_on_right_of_box': 0.178, 'NOT_concept_wall_below_box_concept_box_on_left': 0.0, 'NOT_concept_wall_below_box_concept_no_wall_on_top_m': 0.486, 'NOT_concept_pink_cell_on_top_NOT_concept_wall_below_box': 0.772, 'NOT_concept_wall_below_box_concept_no_pink_cell_on_top_m': 0.622, 'NOT_concept_no_wall_below_m_NOT_concept_wall_below_box': 0.33, 'NOT_concept_wall_below_box_concept_wall_below_box': 0.0, 'NOT_concept_wall_below_box_concept_wall_on_right': 0.33, 'NOT_concept_wall_below_box_concept_pink_cell_below': 0.106, 'NOT_concept_blank_cell_on_left_NOT_concept_wall_below_box': 0.108, 'NOT_concept_target_on_right_NOT_concept_wall_below_box': 0.852, 'NOT_concept_wall_below_box_concept_no_pink_cell_below_m': 0.62, 'NOT_concept_target_on_top_NOT_concept_wall_below_box': 0.842, 'NOT_concept_wall_below_box_NOT_concept_wall_top_right': 0.778, 'NOT_concept_wall_below_box_concept_box_on_top': 0.0, 'NOT_concept_wall_below_box_concept_no_wall_below_m': 0.538, 'NOT_concept_wall_below_box_NOT_concept_wall_on_left': 0.892, 'NOT_concept_wall_below_box_concept_wall_on_left_of_box': 0.192, 'NOT_concept_box_on_top_NOT_concept_wall_below_box': 0.884, 'NOT_concept_wall_below_box_concept_blank_cell_on_left': 0.77, 'NOT_concept_wall_below_box_NOT_concept_wall_on_right': 0.542, 'NOT_concept_pink_cell_on_right_NOT_concept_wall_below_box': 0.878, 'NOT_concept_box_on_left_NOT_concept_wall_below_box': 0.89, 'NOT_concept_wall_below_box_NOT_concept_wall_down_left': 0.88, 'NOT_concept_pink_cell_below_NOT_concept_wall_below_box': 0.774, 'NOT_concept_wall_below_NOT_concept_wall_below_box': 0.666, 'NOT_concept_no_wall_on_right_m_NOT_concept_wall_on_top': 0.51, 'NOT_concept_on_pink_cell_NOT_concept_wall_on_top': 0.662, 'NOT_concept_box_on_right_NOT_concept_wall_on_top': 0.756, 'NOT_concept_wall_on_top_concept_wall_top_left': 0.0, 'NOT_concept_wall_on_top_concept_target_on_right': 0.0, 'NOT_concept_blank_cell_below_NOT_concept_wall_on_top': 0.308, 'NOT_concept_wall_on_top_concept_no_wall_on_right_m': 0.256, 'NOT_concept_wall_on_top_concept_wall_below': 0.17, 'NOT_concept_no_wall_on_left_m_NOT_concept_wall_on_top': 0.344, 'NOT_concept_wall_on_top_NOT_concept_wall_top_left': 0.766, 'NOT_concept_box_below_NOT_concept_wall_on_top': 0.746, 'NOT_concept_wall_above_box_NOT_concept_wall_on_top': 0.664, 'NOT_concept_wall_on_top_concept_pink_cell_on_top': 0.136, 'NOT_concept_no_pink_cell_on_top_m_NOT_concept_wall_on_top': 0.174, 'NOT_concept_wall_on_right_of_box_NOT_concept_wall_on_top': 0.594, 'NOT_concept_no_wall_on_top_m_NOT_concept_wall_on_top': 0.186, 'NOT_concept_wall_on_top_concept_on_pink_cell': 0.09, 'NOT_concept_wall_on_top_concept_target_on_top': 0.046, 'NOT_concept_wall_on_top_concept_wall_down_left': 0.0, 'NOT_concept_wall_on_top_concept_wall_on_left': 0.0, 'NOT_concept_no_pink_cell_below_m_NOT_concept_wall_on_top': 0.236, 'NOT_concept_wall_on_top_concept_wall_up_down_right': 0.0, 'NOT_concept_wall_on_top_concept_wall_on_top': 0.0, 'NOT_concept_wall_on_top_concept_wall_above_box': 0.086, 'NOT_concept_wall_on_top_concept_wall_on_right_of_box': 0.156, 'NOT_concept_wall_on_top_concept_box_on_left': 0.0, 'NOT_concept_wall_on_top_concept_no_wall_on_top_m': 0.552, 'NOT_concept_pink_cell_on_top_NOT_concept_wall_on_top': 0.642, 'NOT_concept_wall_on_top_concept_no_pink_cell_on_top_m': 0.584, 'NOT_concept_no_wall_below_m_NOT_concept_wall_on_top': 0.292, 'NOT_concept_wall_on_top_concept_wall_below_box': 0.104, 'NOT_concept_wall_on_top_concept_wall_on_right': 0.286, 'NOT_concept_wall_on_top_concept_pink_cell_below': 0.126, 'NOT_concept_blank_cell_on_left_NOT_concept_wall_on_top': 0.13, 'NOT_concept_target_on_right_NOT_concept_wall_on_top': 0.764, 'NOT_concept_wall_on_top_concept_no_pink_cell_below_m': 0.504, 'NOT_concept_target_on_top_NOT_concept_wall_on_top': 0.72, 'NOT_concept_wall_on_top_NOT_concept_wall_top_right': 0.738, 'NOT_concept_wall_on_top_concept_box_on_top': 0.0, 'NOT_concept_wall_on_top_concept_no_wall_below_m': 0.46, 'NOT_concept_wall_on_left_NOT_concept_wall_on_top': 0.758, 'NOT_concept_wall_on_top_concept_wall_on_left_of_box': 0.158, 'NOT_concept_box_on_top_NOT_concept_wall_on_top': 0.746, 'NOT_concept_wall_on_top_concept_blank_cell_on_left': 0.626, 'NOT_concept_wall_on_right_NOT_concept_wall_on_top': 0.482, 'NOT_concept_pink_cell_on_right_NOT_concept_wall_on_top': 0.754, 'NOT_concept_box_on_left_NOT_concept_wall_on_top': 0.758, 'NOT_concept_wall_down_left_NOT_concept_wall_on_top': 0.742, 'NOT_concept_pink_cell_below_NOT_concept_wall_on_top': 0.634, 'NOT_concept_wall_below_NOT_concept_wall_on_top': 0.564, 'NOT_concept_no_wall_on_right_m_NOT_concept_on_pink_cell': 0.608, 'NOT_concept_box_on_right_NOT_concept_no_wall_on_right_m': 0.702, 'NOT_concept_no_wall_on_right_m_concept_wall_top_left': 0.0, 'NOT_concept_no_wall_on_right_m_concept_target_on_right': 0.042, 'NOT_concept_blank_cell_below_NOT_concept_no_wall_on_right_m': 0.202, 'NOT_concept_no_wall_on_right_m_concept_no_wall_on_right_m': 0.0, 'NOT_concept_no_wall_on_right_m_concept_wall_below': 0.16, 'NOT_concept_no_wall_on_left_m_NOT_concept_no_wall_on_right_m': 0.24, 'NOT_concept_no_wall_on_right_m_NOT_concept_wall_top_left': 0.72, 'NOT_concept_box_below_NOT_concept_no_wall_on_right_m': 0.708, 'NOT_concept_no_wall_on_right_m_NOT_concept_wall_above_box': 0.634, 'NOT_concept_no_wall_on_right_m_concept_pink_cell_on_top': 0.126, 'NOT_concept_no_pink_cell_on_top_m_NOT_concept_no_wall_on_right_m': 0.238, 'NOT_concept_no_wall_on_right_m_NOT_concept_wall_on_right_of_box': 0.572, 'NOT_concept_no_wall_on_right_m_NOT_concept_no_wall_on_top_m': 0.274, 'NOT_concept_no_wall_on_right_m_concept_on_pink_cell': 0.088, 'NOT_concept_no_wall_on_right_m_concept_target_on_top': 0.0, 'NOT_concept_no_wall_on_right_m_concept_wall_down_left': 0.0, 'NOT_concept_no_wall_on_right_m_concept_wall_on_left': 0.0, 'NOT_concept_no_pink_cell_below_m_NOT_concept_no_wall_on_right_m': 0.144, 'NOT_concept_no_wall_on_right_m_concept_wall_up_down_right': 0.0, 'NOT_concept_no_wall_on_right_m_concept_wall_on_top': 0.2, 'NOT_concept_no_wall_on_right_m_concept_wall_above_box': 0.084, 'NOT_concept_no_wall_on_right_m_concept_wall_on_right_of_box': 0.144, 'NOT_concept_no_wall_on_right_m_concept_box_on_left': 0.0, 'NOT_concept_no_wall_on_right_m_concept_no_wall_on_top_m': 0.436, 'NOT_concept_no_wall_on_right_m_NOT_concept_pink_cell_on_top': 0.578, 'NOT_concept_no_wall_on_right_m_concept_no_pink_cell_on_top_m': 0.458, 'NOT_concept_no_wall_below_m_NOT_concept_no_wall_on_right_m': 0.294, 'NOT_concept_no_wall_on_right_m_concept_wall_below_box': 0.08, 'NOT_concept_no_wall_on_right_m_concept_wall_on_right': 0.38, 'NOT_concept_no_wall_on_right_m_concept_pink_cell_below': 0.046, 'NOT_concept_blank_cell_on_left_NOT_concept_no_wall_on_right_m': 0.126, 'NOT_concept_no_wall_on_right_m_NOT_concept_target_on_right': 0.664, 'NOT_concept_no_wall_on_right_m_concept_no_pink_cell_below_m': 0.568, 'NOT_concept_no_wall_on_right_m_NOT_concept_target_on_top': 0.7, 'NOT_concept_no_wall_on_right_m_NOT_concept_wall_top_right': 0.62, 'NOT_concept_no_wall_on_right_m_concept_box_on_top': 0.0, 'NOT_concept_no_wall_on_right_m_concept_no_wall_below_m': 0.42, 'NOT_concept_no_wall_on_right_m_NOT_concept_wall_on_left': 0.704, 'NOT_concept_no_wall_on_right_m_concept_wall_on_left_of_box': 0.154, 'NOT_concept_box_on_top_NOT_concept_no_wall_on_right_m': 0.708, 'NOT_concept_no_wall_on_right_m_concept_blank_cell_on_left': 0.566, 'NOT_concept_no_wall_on_right_m_NOT_concept_wall_on_right': 0.33, 'NOT_concept_no_wall_on_right_m_NOT_concept_pink_cell_on_right': 0.698, 'NOT_concept_box_on_left_NOT_concept_no_wall_on_right_m': 0.71, 'NOT_concept_no_wall_on_right_m_NOT_concept_wall_down_left': 0.7, 'NOT_concept_no_wall_on_right_m_NOT_concept_pink_cell_below': 0.67, 'NOT_concept_no_wall_on_right_m_NOT_concept_wall_below': 0.536, 'NOT_concept_box_on_right_NOT_concept_on_pink_cell': 0.88, 'NOT_concept_on_pink_cell_concept_wall_top_left': 0.0, 'NOT_concept_on_pink_cell_concept_target_on_right': 0.04, 'NOT_concept_blank_cell_below_NOT_concept_on_pink_cell': 0.32, 'NOT_concept_on_pink_cell_concept_no_wall_on_right_m': 0.25, 'NOT_concept_on_pink_cell_concept_wall_below': 0.204, 'NOT_concept_no_wall_on_left_m_NOT_concept_on_pink_cell': 0.354, 'NOT_concept_on_pink_cell_NOT_concept_wall_top_left': 0.886, 'NOT_concept_box_below_NOT_concept_on_pink_cell': 0.878, 'NOT_concept_on_pink_cell_NOT_concept_wall_above_box': 0.752, 'NOT_concept_on_pink_cell_concept_pink_cell_on_top': 0.11, 'NOT_concept_no_pink_cell_on_top_m_NOT_concept_on_pink_cell': 0.246, 'NOT_concept_on_pink_cell_NOT_concept_wall_on_right_of_box': 0.662, 'NOT_concept_no_wall_on_top_m_NOT_concept_on_pink_cell': 0.368, 'NOT_concept_on_pink_cell_concept_on_pink_cell': 0.0, 'NOT_concept_on_pink_cell_concept_target_on_top': 0.044, 'NOT_concept_on_pink_cell_concept_wall_down_left': 0.0, 'NOT_concept_on_pink_cell_concept_wall_on_left': 0.0, 'NOT_concept_no_pink_cell_below_m_NOT_concept_on_pink_cell': 0.284, 'NOT_concept_on_pink_cell_concept_wall_up_down_right': 0.0, 'NOT_concept_on_pink_cell_concept_wall_on_top': 0.214, 'NOT_concept_on_pink_cell_concept_wall_above_box': 0.124, 'NOT_concept_on_pink_cell_concept_wall_on_right_of_box': 0.222, 'NOT_concept_on_pink_cell_concept_box_on_left': 0.0, 'NOT_concept_on_pink_cell_concept_no_wall_on_top_m': 0.518, 'NOT_concept_on_pink_cell_NOT_concept_pink_cell_on_top': 0.758, 'NOT_concept_on_pink_cell_concept_no_pink_cell_on_top_m': 0.618, 'NOT_concept_no_wall_below_m_NOT_concept_on_pink_cell': 0.338, 'NOT_concept_on_pink_cell_concept_wall_below_box': 0.116, 'NOT_concept_on_pink_cell_concept_wall_on_right': 0.338, 'NOT_concept_on_pink_cell_concept_pink_cell_below': 0.116, 'NOT_concept_blank_cell_on_left_NOT_concept_on_pink_cell': 0.126, 'NOT_concept_on_pink_cell_NOT_concept_target_on_right': 0.844, 'NOT_concept_on_pink_cell_concept_no_pink_cell_below_m': 0.616, 'NOT_concept_on_pink_cell_NOT_concept_target_on_top': 0.842, 'NOT_concept_on_pink_cell_NOT_concept_wall_top_right': 0.79, 'NOT_concept_on_pink_cell_concept_box_on_top': 0.0, 'NOT_concept_on_pink_cell_concept_no_wall_below_m': 0.546, 'NOT_concept_on_pink_cell_NOT_concept_wall_on_left': 0.878, 'NOT_concept_on_pink_cell_concept_wall_on_left_of_box': 0.212, 'NOT_concept_box_on_top_NOT_concept_on_pink_cell': 0.882, 'NOT_concept_on_pink_cell_concept_blank_cell_on_left': 0.774, 'NOT_concept_on_pink_cell_NOT_concept_wall_on_right': 0.548, 'NOT_concept_on_pink_cell_NOT_concept_pink_cell_on_right': 0.884, 'NOT_concept_box_on_left_NOT_concept_on_pink_cell': 0.878, 'NOT_concept_on_pink_cell_NOT_concept_wall_down_left': 0.876, 'NOT_concept_on_pink_cell_NOT_concept_pink_cell_below': 0.766, 'NOT_concept_on_pink_cell_NOT_concept_wall_below': 0.694, 'NOT_concept_box_on_right_concept_wall_top_left': 0.0, 'NOT_concept_box_on_right_concept_target_on_right': 0.044, 'NOT_concept_blank_cell_below_NOT_concept_box_on_right': 0.376, 'NOT_concept_box_on_right_concept_no_wall_on_right_m': 0.288, 'NOT_concept_box_on_right_concept_wall_below': 0.256, 'NOT_concept_box_on_right_NOT_concept_no_wall_on_left_m': 0.392, 'NOT_concept_box_on_right_NOT_concept_wall_top_left': 1.0, 'NOT_concept_box_below_NOT_concept_box_on_right': 1.0, 'NOT_concept_box_on_right_NOT_concept_wall_above_box': 0.88, 'NOT_concept_box_on_right_concept_pink_cell_on_top': 0.142, 'NOT_concept_box_on_right_NOT_concept_no_pink_cell_on_top_m': 0.298, 'NOT_concept_box_on_right_NOT_concept_wall_on_right_of_box': 0.78, 'NOT_concept_box_on_right_NOT_concept_no_wall_on_top_m': 0.454, 'NOT_concept_box_on_right_concept_on_pink_cell': 0.124, 'NOT_concept_box_on_right_concept_target_on_top': 0.044, 'NOT_concept_box_on_right_concept_wall_down_left': 0.0, 'NOT_concept_box_on_right_concept_wall_on_left': 0.0, 'NOT_concept_box_on_right_NOT_concept_no_pink_cell_below_m': 0.314, 'NOT_concept_box_on_right_concept_wall_up_down_right': 0.0, 'NOT_concept_box_on_right_concept_wall_on_top': 0.266, 'NOT_concept_box_on_right_concept_wall_above_box': 0.132, 'NOT_concept_box_on_right_concept_wall_on_right_of_box': 0.208, 'NOT_concept_box_on_right_concept_box_on_left': 0.0, 'NOT_concept_box_on_right_concept_no_wall_on_top_m': 0.566, 'NOT_concept_box_on_right_NOT_concept_pink_cell_on_top': 0.866, 'NOT_concept_box_on_right_concept_no_pink_cell_on_top_m': 0.706, 'NOT_concept_box_on_right_NOT_concept_no_wall_below_m': 0.394, 'NOT_concept_box_on_right_concept_wall_below_box': 0.12, 'NOT_concept_box_on_right_concept_wall_on_right': 0.376, 'NOT_concept_box_on_right_concept_pink_cell_below': 0.114, 'NOT_concept_blank_cell_on_left_NOT_concept_box_on_right': 0.13, 'NOT_concept_box_on_right_NOT_concept_target_on_right': 0.958, 'NOT_concept_box_on_right_concept_no_pink_cell_below_m': 0.672, 'NOT_concept_box_on_right_NOT_concept_target_on_top': 0.954, 'NOT_concept_box_on_right_NOT_concept_wall_top_right': 0.898, 'NOT_concept_box_on_right_concept_box_on_top': 0.0, 'NOT_concept_box_on_right_concept_no_wall_below_m': 0.604, 'NOT_concept_box_on_right_NOT_concept_wall_on_left': 1.0, 'NOT_concept_box_on_right_concept_wall_on_left_of_box': 0.198, 'NOT_concept_box_on_right_NOT_concept_box_on_top': 1.0, 'NOT_concept_box_on_right_concept_blank_cell_on_left': 0.856, 'NOT_concept_box_on_right_NOT_concept_wall_on_right': 0.622, 'NOT_concept_box_on_right_NOT_concept_pink_cell_on_right': 1.0, 'NOT_concept_box_on_left_NOT_concept_box_on_right': 1.0, 'NOT_concept_box_on_right_NOT_concept_wall_down_left': 1.0, 'NOT_concept_box_on_right_NOT_concept_pink_cell_below': 0.876, 'NOT_concept_box_on_right_NOT_concept_wall_below': 0.75, 'concept_target_on_right_concept_wall_top_left': 0.0, 'NOT_concept_blank_cell_below_concept_wall_top_left': 0.0, 'concept_no_wall_on_right_m_concept_wall_top_left': 0.0, 'concept_wall_below_concept_wall_top_left': 0.0, 'NOT_concept_no_wall_on_left_m_concept_wall_top_left': 0.0, 'NOT_concept_wall_top_left_concept_wall_top_left': 0.0, 'NOT_concept_box_below_concept_wall_top_left': 0.0, 'NOT_concept_wall_above_box_concept_wall_top_left': 0.0, 'concept_pink_cell_on_top_concept_wall_top_left': 0.0, 'NOT_concept_no_pink_cell_on_top_m_concept_wall_top_left': 0.0, 'NOT_concept_wall_on_right_of_box_concept_wall_top_left': 0.0, 'NOT_concept_no_wall_on_top_m_concept_wall_top_left': 0.0, 'concept_on_pink_cell_concept_wall_top_left': 0.0, 'concept_target_on_top_concept_wall_top_left': 0.0, 'concept_wall_down_left_concept_wall_top_left': 0.0, 'concept_wall_on_left_concept_wall_top_left': 0.0, 'NOT_concept_no_pink_cell_below_m_concept_wall_top_left': 0.0, 'concept_wall_top_left_concept_wall_up_down_right': 0.0, 'concept_wall_on_top_concept_wall_top_left': 0.0, 'concept_wall_above_box_concept_wall_top_left': 0.0, 'concept_wall_on_right_of_box_concept_wall_top_left': 0.0, 'concept_box_on_left_concept_wall_top_left': 0.0, 'concept_no_wall_on_top_m_concept_wall_top_left': 0.0, 'NOT_concept_pink_cell_on_top_concept_wall_top_left': 0.0, 'concept_no_pink_cell_on_top_m_concept_wall_top_left': 0.0, 'NOT_concept_no_wall_below_m_concept_wall_top_left': 0.0, 'concept_wall_below_box_concept_wall_top_left': 0.0, 'concept_wall_on_right_concept_wall_top_left': 0.0, 'concept_pink_cell_below_concept_wall_top_left': 0.0, 'NOT_concept_blank_cell_on_left_concept_wall_top_left': 0.0, 'NOT_concept_target_on_right_concept_wall_top_left': 0.0, 'concept_no_pink_cell_below_m_concept_wall_top_left': 0.0, 'NOT_concept_target_on_top_concept_wall_top_left': 0.0, 'NOT_concept_wall_top_right_concept_wall_top_left': 0.0, 'concept_box_on_top_concept_wall_top_left': 0.0, 'concept_no_wall_below_m_concept_wall_top_left': 0.0, 'NOT_concept_wall_on_left_concept_wall_top_left': 0.0, 'concept_wall_on_left_of_box_concept_wall_top_left': 0.0, 'NOT_concept_box_on_top_concept_wall_top_left': 0.0, 'concept_blank_cell_on_left_concept_wall_top_left': 0.0, 'NOT_concept_wall_on_right_concept_wall_top_left': 0.0, 'NOT_concept_pink_cell_on_right_concept_wall_top_left': 0.0, 'NOT_concept_box_on_left_concept_wall_top_left': 0.0, 'NOT_concept_wall_down_left_concept_wall_top_left': 0.0, 'NOT_concept_pink_cell_below_concept_wall_top_left': 0.0, 'NOT_concept_wall_below_concept_wall_top_left': 0.0, 'NOT_concept_blank_cell_below_concept_target_on_right': 0.0, 'concept_no_wall_on_right_m_concept_target_on_right': 0.0, 'concept_target_on_right_concept_wall_below': 0.0, 'NOT_concept_no_wall_on_left_m_concept_target_on_right': 0.0, 'NOT_concept_wall_top_left_concept_target_on_right': 0.04, 'NOT_concept_box_below_concept_target_on_right': 0.042, 'NOT_concept_wall_above_box_concept_target_on_right': 0.04, 'concept_pink_cell_on_top_concept_target_on_right': 0.0, 'NOT_concept_no_pink_cell_on_top_m_concept_target_on_right': 0.04, 'NOT_concept_wall_on_right_of_box_concept_target_on_right': 0.026, 'NOT_concept_no_wall_on_top_m_concept_target_on_right': 0.038, 'concept_on_pink_cell_concept_target_on_right': 0.004, 'concept_target_on_right_concept_target_on_top': 0.0, 'concept_target_on_right_concept_wall_down_left': 0.0, 'concept_target_on_right_concept_wall_on_left': 0.0, 'NOT_concept_no_pink_cell_below_m_concept_target_on_right': 0.036, 'concept_target_on_right_concept_wall_up_down_right': 0.0, 'concept_target_on_right_concept_wall_on_top': 0.046, 'concept_target_on_right_concept_wall_above_box': 0.002, 'concept_target_on_right_concept_wall_on_right_of_box': 0.01, 'concept_box_on_left_concept_target_on_right': 0.0, 'concept_no_wall_on_top_m_concept_target_on_right': 0.0, 'NOT_concept_pink_cell_on_top_concept_target_on_right': 0.042, 'concept_no_pink_cell_on_top_m_concept_target_on_right': 0.0, 'NOT_concept_no_wall_below_m_concept_target_on_right': 0.0, 'concept_target_on_right_concept_wall_below_box': 0.002, 'concept_target_on_right_concept_wall_on_right': 0.0, 'concept_pink_cell_below_concept_target_on_right': 0.0, 'NOT_concept_blank_cell_on_left_concept_target_on_right': 0.0, 'NOT_concept_target_on_right_concept_target_on_right': 0.0, 'concept_no_pink_cell_below_m_concept_target_on_right': 0.0, 'NOT_concept_target_on_top_concept_target_on_right': 0.042, 'NOT_concept_wall_top_right_concept_target_on_right': 0.038, 'concept_box_on_top_concept_target_on_right': 0.0, 'concept_no_wall_below_m_concept_target_on_right': 0.044, 'NOT_concept_wall_on_left_concept_target_on_right': 0.038, 'concept_target_on_right_concept_wall_on_left_of_box': 0.008, 'NOT_concept_box_on_top_concept_target_on_right': 0.036, 'concept_blank_cell_on_left_concept_target_on_right': 0.042, 'NOT_concept_wall_on_right_concept_target_on_right': 0.044, 'NOT_concept_pink_cell_on_right_concept_target_on_right': 0.04, 'NOT_concept_box_on_left_concept_target_on_right': 0.042, 'NOT_concept_wall_down_left_concept_target_on_right': 0.038, 'NOT_concept_pink_cell_below_concept_target_on_right': 0.04, 'NOT_concept_wall_below_concept_target_on_right': 0.038, 'NOT_concept_blank_cell_below_concept_no_wall_on_right_m': 0.172, 'NOT_concept_blank_cell_below_concept_wall_below': 0.254, 'NOT_concept_blank_cell_below_NOT_concept_no_wall_on_left_m': 0.138, 'NOT_concept_blank_cell_below_NOT_concept_wall_top_left': 0.36, 'NOT_concept_blank_cell_below_NOT_concept_box_below': 0.376, 'NOT_concept_blank_cell_below_NOT_concept_wall_above_box': 0.314, 'NOT_concept_blank_cell_below_concept_pink_cell_on_top': 0.036, 'NOT_concept_blank_cell_below_NOT_concept_no_pink_cell_on_top_m': 0.046, 'NOT_concept_blank_cell_below_NOT_concept_wall_on_right_of_box': 0.278, 'NOT_concept_blank_cell_below_NOT_concept_no_wall_on_top_m': 0.15, 'NOT_concept_blank_cell_below_concept_on_pink_cell': 0.048, 'NOT_concept_blank_cell_below_concept_target_on_top': 0.0, 'NOT_concept_blank_cell_below_concept_wall_down_left': 0.0, 'NOT_concept_blank_cell_below_concept_wall_on_left': 0.0, 'NOT_concept_blank_cell_below_NOT_concept_no_pink_cell_below_m': 0.278, 'NOT_concept_blank_cell_below_concept_wall_up_down_right': 0.0, 'NOT_concept_blank_cell_below_concept_wall_on_top': 0.068, 'NOT_concept_blank_cell_below_concept_wall_above_box': 0.044, 'NOT_concept_blank_cell_below_concept_wall_on_right_of_box': 0.084, 'NOT_concept_blank_cell_below_concept_box_on_left': 0.0, 'NOT_concept_blank_cell_below_concept_no_wall_on_top_m': 0.21, 'NOT_concept_blank_cell_below_NOT_concept_pink_cell_on_top': 0.322, 'NOT_concept_blank_cell_below_concept_no_pink_cell_on_top_m': 0.33, 'NOT_concept_blank_cell_below_NOT_concept_no_wall_below_m': 0.256, 'NOT_concept_blank_cell_below_concept_wall_below_box': 0.04, 'NOT_concept_blank_cell_below_concept_wall_on_right': 0.122, 'NOT_concept_blank_cell_below_concept_pink_cell_below': 0.126, 'NOT_concept_blank_cell_below_NOT_concept_blank_cell_on_left': 0.0, 'NOT_concept_blank_cell_below_NOT_concept_target_on_right': 0.366, 'NOT_concept_blank_cell_below_concept_no_pink_cell_below_m': 0.098, 'NOT_concept_blank_cell_below_NOT_concept_target_on_top': 0.356, 'NOT_concept_blank_cell_below_NOT_concept_wall_top_right': 0.342, 'NOT_concept_blank_cell_below_concept_box_on_top': 0.0, 'NOT_concept_blank_cell_below_concept_no_wall_below_m': 0.124, 'NOT_concept_blank_cell_below_NOT_concept_wall_on_left': 0.364, 'NOT_concept_blank_cell_below_concept_wall_on_left_of_box': 0.076, 'NOT_concept_blank_cell_below_NOT_concept_box_on_top': 0.368, 'NOT_concept_blank_cell_below_concept_blank_cell_on_left': 0.378, 'NOT_concept_blank_cell_below_NOT_concept_wall_on_right': 0.246, 'NOT_concept_blank_cell_below_NOT_concept_pink_cell_on_right': 0.366, 'NOT_concept_blank_cell_below_NOT_concept_box_on_left': 0.364, 'NOT_concept_blank_cell_below_NOT_concept_wall_down_left': 0.364, 'NOT_concept_blank_cell_below_NOT_concept_pink_cell_below': 0.244, 'NOT_concept_blank_cell_below_NOT_concept_wall_below': 0.12, 'concept_no_wall_on_right_m_concept_wall_below': 0.084, 'NOT_concept_no_wall_on_left_m_concept_no_wall_on_right_m': 0.168, 'NOT_concept_wall_top_left_concept_no_wall_on_right_m': 0.286, 'NOT_concept_box_below_concept_no_wall_on_right_m': 0.288, 'NOT_concept_wall_above_box_concept_no_wall_on_right_m': 0.26, 'concept_no_wall_on_right_m_concept_pink_cell_on_top': 0.0, 'NOT_concept_no_pink_cell_on_top_m_concept_no_wall_on_right_m': 0.048, 'NOT_concept_wall_on_right_of_box_concept_no_wall_on_right_m': 0.222, 'NOT_concept_no_wall_on_top_m_concept_no_wall_on_right_m': 0.166, 'concept_no_wall_on_right_m_concept_on_pink_cell': 0.032, 'concept_no_wall_on_right_m_concept_target_on_top': 0.04, 'concept_no_wall_on_right_m_concept_wall_down_left': 0.0, 'concept_no_wall_on_right_m_concept_wall_on_left': 0.0, 'NOT_concept_no_pink_cell_below_m_concept_no_wall_on_right_m': 0.166, 'concept_no_wall_on_right_m_concept_wall_up_down_right': 0.0, 'concept_no_wall_on_right_m_concept_wall_on_top': 0.044, 'concept_no_wall_on_right_m_concept_wall_above_box': 0.036, 'concept_no_wall_on_right_m_concept_wall_on_right_of_box': 0.072, 'concept_box_on_left_concept_no_wall_on_right_m': 0.0, 'concept_no_wall_on_right_m_concept_no_wall_on_top_m': 0.128, 'NOT_concept_pink_cell_on_top_concept_no_wall_on_right_m': 0.27, 'concept_no_pink_cell_on_top_m_concept_no_wall_on_right_m': 0.25, 'NOT_concept_no_wall_below_m_concept_no_wall_on_right_m': 0.086, 'concept_no_wall_on_right_m_concept_wall_below_box': 0.036, 'concept_no_wall_on_right_m_concept_wall_on_right': 0.0, 'concept_no_wall_on_right_m_concept_pink_cell_below': 0.074, 'NOT_concept_blank_cell_on_left_concept_no_wall_on_right_m': 0.0, 'NOT_concept_target_on_right_concept_no_wall_on_right_m': 0.302, 'concept_no_pink_cell_below_m_concept_no_wall_on_right_m': 0.126, 'NOT_concept_target_on_top_concept_no_wall_on_right_m': 0.258, 'NOT_concept_wall_top_right_concept_no_wall_on_right_m': 0.292, 'concept_box_on_top_concept_no_wall_on_right_m': 0.0, 'concept_no_wall_below_m_concept_no_wall_on_right_m': 0.204, 'NOT_concept_wall_on_left_concept_no_wall_on_right_m': 0.284, 'concept_no_wall_on_right_m_concept_wall_on_left_of_box': 0.056, 'NOT_concept_box_on_top_concept_no_wall_on_right_m': 0.278, 'concept_blank_cell_on_left_concept_no_wall_on_right_m': 0.27, 'NOT_concept_wall_on_right_concept_no_wall_on_right_m': 0.286, 'NOT_concept_pink_cell_on_right_concept_no_wall_on_right_m': 0.29, 'NOT_concept_box_on_left_concept_no_wall_on_right_m': 0.294, 'NOT_concept_wall_down_left_concept_no_wall_on_right_m': 0.282, 'NOT_concept_pink_cell_below_concept_no_wall_on_right_m': 0.214, 'NOT_concept_wall_below_concept_no_wall_on_right_m': 0.214, 'NOT_concept_no_wall_on_left_m_concept_wall_below': 0.064, 'NOT_concept_wall_top_left_concept_wall_below': 0.246, 'NOT_concept_box_below_concept_wall_below': 0.246, 'NOT_concept_wall_above_box_concept_wall_below': 0.212, 'concept_pink_cell_on_top_concept_wall_below': 0.0, 'NOT_concept_no_pink_cell_on_top_m_concept_wall_below': 0.0, 'NOT_concept_wall_on_right_of_box_concept_wall_below': 0.182, 'NOT_concept_no_wall_on_top_m_concept_wall_below': 0.108, 'concept_on_pink_cell_concept_wall_below': 0.036, 'concept_target_on_top_concept_wall_below': 0.0, 'concept_wall_below_concept_wall_down_left': 0.0, 'concept_wall_below_concept_wall_on_left': 0.0, 'NOT_concept_no_pink_cell_below_m_concept_wall_below': 0.13, 'concept_wall_below_concept_wall_up_down_right': 0.0, 'concept_wall_below_concept_wall_on_top': 0.058, 'concept_wall_above_box_concept_wall_below': 0.024, 'concept_wall_below_concept_wall_on_right_of_box': 0.064, 'concept_box_on_left_concept_wall_below': 0.0, 'concept_no_wall_on_top_m_concept_wall_below': 0.138, 'NOT_concept_pink_cell_on_top_concept_wall_below': 0.236, 'concept_no_pink_cell_on_top_m_concept_wall_below': 0.256, 'NOT_concept_no_wall_below_m_concept_wall_below': 0.256, 'concept_wall_below_concept_wall_below_box': 0.024, 'concept_wall_below_concept_wall_on_right': 0.108, 'concept_pink_cell_below_concept_wall_below': 0.0, 'NOT_concept_blank_cell_on_left_concept_wall_below': 0.0, 'NOT_concept_target_on_right_concept_wall_below': 0.236, 'concept_no_pink_cell_below_m_concept_wall_below': 0.086, 'NOT_concept_target_on_top_concept_wall_below': 0.24, 'NOT_concept_wall_top_right_concept_wall_below': 0.224, 'concept_box_on_top_concept_wall_below': 0.0, 'concept_no_wall_below_m_concept_wall_below': 0.0, 'NOT_concept_wall_on_left_concept_wall_below': 0.24, 'concept_wall_below_concept_wall_on_left_of_box': 0.046, 'NOT_concept_box_on_top_concept_wall_below': 0.246, 'concept_blank_cell_on_left_concept_wall_below': 0.248, 'NOT_concept_wall_on_right_concept_wall_below': 0.116, 'NOT_concept_pink_cell_on_right_concept_wall_below': 0.24, 'NOT_concept_box_on_left_concept_wall_below': 0.256, 'NOT_concept_wall_down_left_concept_wall_below': 0.234, 'NOT_concept_pink_cell_below_concept_wall_below': 0.238, 'NOT_concept_wall_below_concept_wall_below': 0.0, 'NOT_concept_no_wall_on_left_m_NOT_concept_wall_top_left': 0.382, 'NOT_concept_box_below_NOT_concept_no_wall_on_left_m': 0.418, 'NOT_concept_no_wall_on_left_m_NOT_concept_wall_above_box': 0.36, 'NOT_concept_no_wall_on_left_m_concept_pink_cell_on_top': 0.132, 'NOT_concept_no_pink_cell_on_top_m_NOT_concept_no_wall_on_left_m': 0.222, 'NOT_concept_no_wall_on_left_m_NOT_concept_wall_on_right_of_box': 0.318, 'NOT_concept_no_wall_on_left_m_NOT_concept_no_wall_on_top_m': 0.112, 'NOT_concept_no_wall_on_left_m_concept_on_pink_cell': 0.052, 'NOT_concept_no_wall_on_left_m_concept_target_on_top': 0.0, 'NOT_concept_no_wall_on_left_m_concept_wall_down_left': 0.0, 'NOT_concept_no_wall_on_left_m_concept_wall_on_left': 0.0, 'NOT_concept_no_pink_cell_below_m_NOT_concept_no_wall_on_left_m': 0.122, 'NOT_concept_no_wall_on_left_m_concept_wall_up_down_right': 0.0, 'NOT_concept_no_wall_on_left_m_concept_wall_on_top': 0.062, 'NOT_concept_no_wall_on_left_m_concept_wall_above_box': 0.046, 'NOT_concept_no_wall_on_left_m_concept_wall_on_right_of_box': 0.076, 'NOT_concept_no_wall_on_left_m_concept_box_on_left': 0.0, 'NOT_concept_no_wall_on_left_m_concept_no_wall_on_top_m': 0.282, 'NOT_concept_no_wall_on_left_m_NOT_concept_pink_cell_on_top': 0.286, 'NOT_concept_no_wall_on_left_m_concept_no_pink_cell_on_top_m': 0.192, 'NOT_concept_no_wall_below_m_NOT_concept_no_wall_on_left_m': 0.128, 'NOT_concept_no_wall_on_left_m_concept_wall_below_box': 0.046, 'NOT_concept_no_wall_on_left_m_concept_wall_on_right': 0.054, 'NOT_concept_no_wall_on_left_m_concept_pink_cell_below': 0.086, 'NOT_concept_blank_cell_on_left_NOT_concept_no_wall_on_left_m': 0.0, 'NOT_concept_no_wall_on_left_m_NOT_concept_target_on_right': 0.406, 'NOT_concept_no_wall_on_left_m_concept_no_pink_cell_below_m': 0.278, 'NOT_concept_no_wall_on_left_m_NOT_concept_target_on_top': 0.39, 'NOT_concept_no_wall_on_left_m_NOT_concept_wall_top_right': 0.39, 'NOT_concept_no_wall_on_left_m_concept_box_on_top': 0.0, 'NOT_concept_no_wall_on_left_m_concept_no_wall_below_m': 0.276, 'NOT_concept_no_wall_on_left_m_NOT_concept_wall_on_left': 0.388, 'NOT_concept_no_wall_on_left_m_concept_wall_on_left_of_box': 0.078, 'NOT_concept_box_on_top_NOT_concept_no_wall_on_left_m': 0.406, 'NOT_concept_no_wall_on_left_m_concept_blank_cell_on_left': 0.402, 'NOT_concept_no_wall_on_left_m_NOT_concept_wall_on_right': 0.338, 'NOT_concept_no_wall_on_left_m_NOT_concept_pink_cell_on_right': 0.4, 'NOT_concept_box_on_left_NOT_concept_no_wall_on_left_m': 0.402, 'NOT_concept_no_wall_on_left_m_NOT_concept_wall_down_left': 0.414, 'NOT_concept_no_wall_on_left_m_NOT_concept_pink_cell_below': 0.314, 'NOT_concept_no_wall_on_left_m_NOT_concept_wall_below': 0.342, 'NOT_concept_box_below_NOT_concept_wall_top_left': 1.0, 'NOT_concept_wall_above_box_NOT_concept_wall_top_left': 0.874, 'NOT_concept_wall_top_left_concept_pink_cell_on_top': 0.126, 'NOT_concept_no_pink_cell_on_top_m_NOT_concept_wall_top_left': 0.278, 'NOT_concept_wall_on_right_of_box_NOT_concept_wall_top_left': 0.78, 'NOT_concept_no_wall_on_top_m_NOT_concept_wall_top_left': 0.446, 'NOT_concept_wall_top_left_concept_on_pink_cell': 0.12, 'NOT_concept_wall_top_left_concept_target_on_top': 0.044, 'NOT_concept_wall_top_left_concept_wall_down_left': 0.0, 'NOT_concept_wall_top_left_concept_wall_on_left': 0.0, 'NOT_concept_no_pink_cell_below_m_NOT_concept_wall_top_left': 0.298, 'NOT_concept_wall_top_left_concept_wall_up_down_right': 0.0, 'NOT_concept_wall_top_left_concept_wall_on_top': 0.252, 'NOT_concept_wall_top_left_concept_wall_above_box': 0.118, 'NOT_concept_wall_top_left_concept_wall_on_right_of_box': 0.198, 'NOT_concept_wall_top_left_concept_box_on_left': 0.0, 'NOT_concept_wall_top_left_concept_no_wall_on_top_m': 0.556, 'NOT_concept_pink_cell_on_top_NOT_concept_wall_top_left': 0.868, 'NOT_concept_wall_top_left_concept_no_pink_cell_on_top_m': 0.712, 'NOT_concept_no_wall_below_m_NOT_concept_wall_top_left': 0.39, 'NOT_concept_wall_top_left_concept_wall_below_box': 0.12, 'NOT_concept_wall_top_left_concept_wall_on_right': 0.384, 'NOT_concept_wall_top_left_concept_pink_cell_below': 0.13, 'NOT_concept_blank_cell_on_left_NOT_concept_wall_top_left': 0.128, 'NOT_concept_target_on_right_NOT_concept_wall_top_left': 0.958, 'NOT_concept_wall_top_left_concept_no_pink_cell_below_m': 0.686, 'NOT_concept_target_on_top_NOT_concept_wall_top_left': 0.96, 'NOT_concept_wall_top_left_NOT_concept_wall_top_right': 0.91, 'NOT_concept_wall_top_left_concept_box_on_top': 0.0, 'NOT_concept_wall_top_left_concept_no_wall_below_m': 0.618, 'NOT_concept_wall_on_left_NOT_concept_wall_top_left': 1.0, 'NOT_concept_wall_top_left_concept_wall_on_left_of_box': 0.2, 'NOT_concept_box_on_top_NOT_concept_wall_top_left': 1.0, 'NOT_concept_wall_top_left_concept_blank_cell_on_left': 0.87, 'NOT_concept_wall_on_right_NOT_concept_wall_top_left': 0.63, 'NOT_concept_pink_cell_on_right_NOT_concept_wall_top_left': 1.0, 'NOT_concept_box_on_left_NOT_concept_wall_top_left': 1.0, 'NOT_concept_wall_down_left_NOT_concept_wall_top_left': 1.0, 'NOT_concept_pink_cell_below_NOT_concept_wall_top_left': 0.876, 'NOT_concept_wall_below_NOT_concept_wall_top_left': 0.778, 'NOT_concept_box_below_NOT_concept_wall_above_box': 0.892, 'NOT_concept_box_below_concept_pink_cell_on_top': 0.128, 'NOT_concept_box_below_NOT_concept_no_pink_cell_on_top_m': 0.3, 'NOT_concept_box_below_NOT_concept_wall_on_right_of_box': 0.772, 'NOT_concept_box_below_NOT_concept_no_wall_on_top_m': 0.434, 'NOT_concept_box_below_concept_on_pink_cell': 0.128, 'NOT_concept_box_below_concept_target_on_top': 0.034, 'NOT_concept_box_below_concept_wall_down_left': 0.0, 'NOT_concept_box_below_concept_wall_on_left': 0.0, 'NOT_concept_box_below_NOT_concept_no_pink_cell_below_m': 0.294, 'NOT_concept_box_below_concept_wall_up_down_right': 0.0, 'NOT_concept_box_below_concept_wall_on_top': 0.248, 'NOT_concept_box_below_concept_wall_above_box': 0.124, 'NOT_concept_box_below_concept_wall_on_right_of_box': 0.22, 'NOT_concept_box_below_concept_box_on_left': 0.0, 'NOT_concept_box_below_concept_no_wall_on_top_m': 0.556, 'NOT_concept_box_below_NOT_concept_pink_cell_on_top': 0.87, 'NOT_concept_box_below_concept_no_pink_cell_on_top_m': 0.71, 'NOT_concept_box_below_NOT_concept_no_wall_below_m': 0.382, 'NOT_concept_box_below_concept_wall_below_box': 0.108, 'NOT_concept_box_below_concept_wall_on_right': 0.374, 'NOT_concept_box_below_concept_pink_cell_below': 0.136, 'NOT_concept_blank_cell_on_left_NOT_concept_box_below': 0.132, 'NOT_concept_box_below_NOT_concept_target_on_right': 0.958, 'NOT_concept_box_below_concept_no_pink_cell_below_m': 0.702, 'NOT_concept_box_below_NOT_concept_target_on_top': 0.962, 'NOT_concept_box_below_NOT_concept_wall_top_right': 0.906, 'NOT_concept_box_below_concept_box_on_top': 0.0, 'NOT_concept_box_below_concept_no_wall_below_m': 0.608, 'NOT_concept_box_below_NOT_concept_wall_on_left': 1.0, 'NOT_concept_box_below_concept_wall_on_left_of_box': 0.218, 'NOT_concept_box_below_NOT_concept_box_on_top': 1.0, 'NOT_concept_box_below_concept_blank_cell_on_left': 0.872, 'NOT_concept_box_below_NOT_concept_wall_on_right': 0.626, 'NOT_concept_box_below_NOT_concept_pink_cell_on_right': 1.0, 'NOT_concept_box_below_NOT_concept_box_on_left': 1.0, 'NOT_concept_box_below_NOT_concept_wall_down_left': 1.0, 'NOT_concept_box_below_NOT_concept_pink_cell_below': 0.868, 'NOT_concept_box_below_NOT_concept_wall_below': 0.758, 'NOT_concept_wall_above_box_concept_pink_cell_on_top': 0.118, 'NOT_concept_no_pink_cell_on_top_m_NOT_concept_wall_above_box': 0.262, 'NOT_concept_wall_above_box_NOT_concept_wall_on_right_of_box': 0.662, 'NOT_concept_no_wall_on_top_m_NOT_concept_wall_above_box': 0.382, 'NOT_concept_wall_above_box_concept_on_pink_cell': 0.114, 'NOT_concept_wall_above_box_concept_target_on_top': 0.038, 'NOT_concept_wall_above_box_concept_wall_down_left': 0.0, 'NOT_concept_wall_above_box_concept_wall_on_left': 0.0, 'NOT_concept_no_pink_cell_below_m_NOT_concept_wall_above_box': 0.256, 'NOT_concept_wall_above_box_concept_wall_up_down_right': 0.0, 'NOT_concept_wall_above_box_concept_wall_on_top': 0.218, 'NOT_concept_wall_above_box_concept_wall_above_box': 0.0, 'NOT_concept_wall_above_box_concept_wall_on_right_of_box': 0.206, 'NOT_concept_wall_above_box_concept_box_on_left': 0.0, 'NOT_concept_wall_above_box_concept_no_wall_on_top_m': 0.512, 'NOT_concept_pink_cell_on_top_NOT_concept_wall_above_box': 0.766, 'NOT_concept_wall_above_box_concept_no_pink_cell_on_top_m': 0.622, 'NOT_concept_no_wall_below_m_NOT_concept_wall_above_box': 0.334, 'NOT_concept_wall_above_box_concept_wall_below_box': 0.1, 'NOT_concept_wall_above_box_concept_wall_on_right': 0.332, 'NOT_concept_wall_above_box_concept_pink_cell_below': 0.114, 'NOT_concept_blank_cell_on_left_NOT_concept_wall_above_box': 0.114, 'NOT_concept_target_on_right_NOT_concept_wall_above_box': 0.838, 'NOT_concept_wall_above_box_concept_no_pink_cell_below_m': 0.624, 'NOT_concept_target_on_top_NOT_concept_wall_above_box': 0.844, 'NOT_concept_wall_above_box_NOT_concept_wall_top_right': 0.784, 'NOT_concept_wall_above_box_concept_box_on_top': 0.0, 'NOT_concept_wall_above_box_concept_no_wall_below_m': 0.544, 'NOT_concept_wall_above_box_NOT_concept_wall_on_left': 0.88, 'NOT_concept_wall_above_box_concept_wall_on_left_of_box': 0.2, 'NOT_concept_box_on_top_NOT_concept_wall_above_box': 0.882, 'NOT_concept_wall_above_box_concept_blank_cell_on_left': 0.774, 'NOT_concept_wall_above_box_NOT_concept_wall_on_right': 0.532, 'NOT_concept_pink_cell_on_right_NOT_concept_wall_above_box': 0.874, 'NOT_concept_box_on_left_NOT_concept_wall_above_box': 0.876, 'NOT_concept_wall_above_box_NOT_concept_wall_down_left': 0.884, 'NOT_concept_pink_cell_below_NOT_concept_wall_above_box': 0.77, 'NOT_concept_wall_above_box_NOT_concept_wall_below': 0.666, 'NOT_concept_no_pink_cell_on_top_m_concept_pink_cell_on_top': 0.136, 'NOT_concept_wall_on_right_of_box_concept_pink_cell_on_top': 0.106, 'NOT_concept_no_wall_on_top_m_concept_pink_cell_on_top': 0.0, 'concept_on_pink_cell_concept_pink_cell_on_top': 0.01, 'concept_pink_cell_on_top_concept_target_on_top': 0.0, 'concept_pink_cell_on_top_concept_wall_down_left': 0.0, 'concept_pink_cell_on_top_concept_wall_on_left': 0.0, 'NOT_concept_no_pink_cell_below_m_concept_pink_cell_on_top': 0.04, 'concept_pink_cell_on_top_concept_wall_up_down_right': 0.0, 'concept_pink_cell_on_top_concept_wall_on_top': 0.0, 'concept_pink_cell_on_top_concept_wall_above_box': 0.016, 'concept_pink_cell_on_top_concept_wall_on_right_of_box': 0.028, 'concept_box_on_left_concept_pink_cell_on_top': 0.0, 'concept_no_wall_on_top_m_concept_pink_cell_on_top': 0.128, 'NOT_concept_pink_cell_on_top_concept_pink_cell_on_top': 0.0, 'concept_no_pink_cell_on_top_m_concept_pink_cell_on_top': 0.0, 'NOT_concept_no_wall_below_m_concept_pink_cell_on_top': 0.0, 'concept_pink_cell_on_top_concept_wall_below_box': 0.024, 'concept_pink_cell_on_top_concept_wall_on_right': 0.0, 'concept_pink_cell_below_concept_pink_cell_on_top': 0.046, 'NOT_concept_blank_cell_on_left_concept_pink_cell_on_top': 0.0, 'NOT_concept_target_on_right_concept_pink_cell_on_top': 0.136, 'concept_no_pink_cell_below_m_concept_pink_cell_on_top': 0.092, 'NOT_concept_target_on_top_concept_pink_cell_on_top': 0.132, 'NOT_concept_wall_top_right_concept_pink_cell_on_top': 0.132, 'concept_box_on_top_concept_pink_cell_on_top': 0.0, 'concept_no_wall_below_m_concept_pink_cell_on_top': 0.124, 'NOT_concept_wall_on_left_concept_pink_cell_on_top': 0.128, 'concept_pink_cell_on_top_concept_wall_on_left_of_box': 0.022, 'NOT_concept_box_on_top_concept_pink_cell_on_top': 0.134, 'concept_blank_cell_on_left_concept_pink_cell_on_top': 0.126, 'NOT_concept_wall_on_right_concept_pink_cell_on_top': 0.126, 'NOT_concept_pink_cell_on_right_concept_pink_cell_on_top': 0.13, 'NOT_concept_box_on_left_concept_pink_cell_on_top': 0.128, 'NOT_concept_wall_down_left_concept_pink_cell_on_top': 0.112, 'NOT_concept_pink_cell_below_concept_pink_cell_on_top': 0.092, 'NOT_concept_wall_below_concept_pink_cell_on_top': 0.128, 'NOT_concept_no_pink_cell_on_top_m_NOT_concept_wall_on_right_of_box': 0.232, 'NOT_concept_no_pink_cell_on_top_m_NOT_concept_no_wall_on_top_m': 0.132, 'NOT_concept_no_pink_cell_on_top_m_concept_on_pink_cell': 0.032, 'NOT_concept_no_pink_cell_on_top_m_concept_target_on_top': 0.0, 'NOT_concept_no_pink_cell_on_top_m_concept_wall_down_left': 0.0, 'NOT_concept_no_pink_cell_on_top_m_concept_wall_on_left': 0.0, 'NOT_concept_no_pink_cell_below_m_NOT_concept_no_pink_cell_on_top_m': 0.084, 'NOT_concept_no_pink_cell_on_top_m_concept_wall_up_down_right': 0.0, 'NOT_concept_no_pink_cell_on_top_m_concept_wall_on_top': 0.118, 'NOT_concept_no_pink_cell_on_top_m_concept_wall_above_box': 0.036, 'NOT_concept_no_pink_cell_on_top_m_concept_wall_on_right_of_box': 0.066, 'NOT_concept_no_pink_cell_on_top_m_concept_box_on_left': 0.0, 'NOT_concept_no_pink_cell_on_top_m_concept_no_wall_on_top_m': 0.184, 'NOT_concept_no_pink_cell_on_top_m_NOT_concept_pink_cell_on_top': 0.17, 'NOT_concept_no_pink_cell_on_top_m_concept_no_pink_cell_on_top_m': 0.0, 'NOT_concept_no_pink_cell_on_top_m_NOT_concept_no_wall_below_m': 0.048, 'NOT_concept_no_pink_cell_on_top_m_concept_wall_below_box': 0.034, 'NOT_concept_no_pink_cell_on_top_m_concept_wall_on_right': 0.04, 'NOT_concept_no_pink_cell_on_top_m_concept_pink_cell_below': 0.044, 'NOT_concept_blank_cell_on_left_NOT_concept_no_pink_cell_on_top_m': 0.0, 'NOT_concept_no_pink_cell_on_top_m_NOT_concept_target_on_right': 0.252, 'NOT_concept_no_pink_cell_on_top_m_concept_no_pink_cell_below_m': 0.214, 'NOT_concept_no_pink_cell_on_top_m_NOT_concept_target_on_top': 0.296, 'NOT_concept_no_pink_cell_on_top_m_NOT_concept_wall_top_right': 0.25, 'NOT_concept_no_pink_cell_on_top_m_concept_box_on_top': 0.0, 'NOT_concept_no_pink_cell_on_top_m_concept_no_wall_below_m': 0.264, 'NOT_concept_no_pink_cell_on_top_m_NOT_concept_wall_on_left': 0.278, 'NOT_concept_no_pink_cell_on_top_m_concept_wall_on_left_of_box': 0.06, 'NOT_concept_box_on_top_NOT_concept_no_pink_cell_on_top_m': 0.304, 'NOT_concept_no_pink_cell_on_top_m_concept_blank_cell_on_left': 0.306, 'NOT_concept_no_pink_cell_on_top_m_NOT_concept_wall_on_right': 0.254, 'NOT_concept_no_pink_cell_on_top_m_NOT_concept_pink_cell_on_right': 0.292, 'NOT_concept_box_on_left_NOT_concept_no_pink_cell_on_top_m': 0.304, 'NOT_concept_no_pink_cell_on_top_m_NOT_concept_wall_down_left': 0.294, 'NOT_concept_no_pink_cell_on_top_m_NOT_concept_pink_cell_below': 0.26, 'NOT_concept_no_pink_cell_on_top_m_NOT_concept_wall_below': 0.298, 'NOT_concept_no_wall_on_top_m_NOT_concept_wall_on_right_of_box': 0.344, 'NOT_concept_wall_on_right_of_box_concept_on_pink_cell': 0.116, 'NOT_concept_wall_on_right_of_box_concept_target_on_top': 0.03, 'NOT_concept_wall_on_right_of_box_concept_wall_down_left': 0.0, 'NOT_concept_wall_on_right_of_box_concept_wall_on_left': 0.0, 'NOT_concept_no_pink_cell_below_m_NOT_concept_wall_on_right_of_box': 0.244, 'NOT_concept_wall_on_right_of_box_concept_wall_up_down_right': 0.0, 'NOT_concept_wall_on_right_of_box_concept_wall_on_top': 0.19, 'NOT_concept_wall_on_right_of_box_concept_wall_above_box': 0.118, 'NOT_concept_wall_on_right_of_box_concept_wall_on_right_of_box': 0.0, 'NOT_concept_wall_on_right_of_box_concept_box_on_left': 0.0, 'NOT_concept_wall_on_right_of_box_concept_no_wall_on_top_m': 0.458, 'NOT_concept_pink_cell_on_top_NOT_concept_wall_on_right_of_box': 0.69, 'NOT_concept_wall_on_right_of_box_concept_no_pink_cell_on_top_m': 0.542, 'NOT_concept_no_wall_below_m_NOT_concept_wall_on_right_of_box': 0.29, 'NOT_concept_wall_on_right_of_box_concept_wall_below_box': 0.07, 'NOT_concept_wall_on_right_of_box_concept_wall_on_right': 0.296, 'NOT_concept_wall_on_right_of_box_concept_pink_cell_below': 0.088, 'NOT_concept_blank_cell_on_left_NOT_concept_wall_on_right_of_box': 0.098, 'NOT_concept_target_on_right_NOT_concept_wall_on_right_of_box': 0.766, 'NOT_concept_wall_on_right_of_box_concept_no_pink_cell_below_m': 0.568, 'NOT_concept_target_on_top_NOT_concept_wall_on_right_of_box': 0.752, 'NOT_concept_wall_on_right_of_box_NOT_concept_wall_top_right': 0.714, 'NOT_concept_wall_on_right_of_box_concept_box_on_top': 0.0, 'NOT_concept_wall_on_right_of_box_concept_no_wall_below_m': 0.498, 'NOT_concept_wall_on_left_NOT_concept_wall_on_right_of_box': 0.784, 'NOT_concept_wall_on_right_of_box_concept_wall_on_left_of_box': 0.21, 'NOT_concept_box_on_top_NOT_concept_wall_on_right_of_box': 0.798, 'NOT_concept_wall_on_right_of_box_concept_blank_cell_on_left': 0.68, 'NOT_concept_wall_on_right_NOT_concept_wall_on_right_of_box': 0.468, 'NOT_concept_pink_cell_on_right_NOT_concept_wall_on_right_of_box': 0.774, 'NOT_concept_box_on_left_NOT_concept_wall_on_right_of_box': 0.782, 'NOT_concept_wall_down_left_NOT_concept_wall_on_right_of_box': 0.784, 'NOT_concept_pink_cell_below_NOT_concept_wall_on_right_of_box': 0.68, 'NOT_concept_wall_below_NOT_concept_wall_on_right_of_box': 0.594, 'NOT_concept_no_wall_on_top_m_concept_on_pink_cell': 0.054, 'NOT_concept_no_wall_on_top_m_concept_target_on_top': 0.042, 'NOT_concept_no_wall_on_top_m_concept_wall_down_left': 0.0, 'NOT_concept_no_wall_on_top_m_concept_wall_on_left': 0.0, 'NOT_concept_no_pink_cell_below_m_NOT_concept_no_wall_on_top_m': 0.118, 'NOT_concept_no_wall_on_top_m_concept_wall_up_down_right': 0.0, 'NOT_concept_no_wall_on_top_m_concept_wall_on_top': 0.25, 'NOT_concept_no_wall_on_top_m_concept_wall_above_box': 0.054, 'NOT_concept_no_wall_on_top_m_concept_wall_on_right_of_box': 0.104, 'NOT_concept_no_wall_on_top_m_concept_box_on_left': 0.0, 'NOT_concept_no_wall_on_top_m_concept_no_wall_on_top_m': 0.0, 'NOT_concept_no_wall_on_top_m_NOT_concept_pink_cell_on_top': 0.426, 'NOT_concept_no_wall_on_top_m_concept_no_pink_cell_on_top_m': 0.308, 'NOT_concept_no_wall_below_m_NOT_concept_no_wall_on_top_m': 0.172, 'NOT_concept_no_wall_on_top_m_concept_wall_below_box': 0.036, 'NOT_concept_no_wall_on_top_m_concept_wall_on_right': 0.16, 'NOT_concept_no_wall_on_top_m_concept_pink_cell_below': 0.042, 'NOT_concept_blank_cell_on_left_NOT_concept_no_wall_on_top_m': 0.0, 'NOT_concept_no_wall_on_top_m_NOT_concept_target_on_right': 0.406, 'NOT_concept_no_wall_on_top_m_concept_no_pink_cell_below_m': 0.328, 'NOT_concept_no_wall_on_top_m_NOT_concept_target_on_top': 0.394, 'NOT_concept_no_wall_on_top_m_NOT_concept_wall_top_right': 0.33, 'NOT_concept_no_wall_on_top_m_concept_box_on_top': 0.0, 'NOT_concept_no_wall_on_top_m_concept_no_wall_below_m': 0.254, 'NOT_concept_no_wall_on_top_m_NOT_concept_wall_on_left': 0.414, 'NOT_concept_no_wall_on_top_m_concept_wall_on_left_of_box': 0.084, 'NOT_concept_box_on_top_NOT_concept_no_wall_on_top_m': 0.434, 'NOT_concept_no_wall_on_top_m_concept_blank_cell_on_left': 0.456, 'NOT_concept_no_wall_on_top_m_NOT_concept_wall_on_right': 0.27, 'NOT_concept_no_wall_on_top_m_NOT_concept_pink_cell_on_right': 0.428, 'NOT_concept_box_on_left_NOT_concept_no_wall_on_top_m': 0.428, 'NOT_concept_no_wall_on_top_m_NOT_concept_wall_down_left': 0.442, 'NOT_concept_no_wall_on_top_m_NOT_concept_pink_cell_below': 0.4, 'NOT_concept_no_wall_on_top_m_NOT_concept_wall_below': 0.328, 'concept_on_pink_cell_concept_target_on_top': 0.002, 'concept_on_pink_cell_concept_wall_down_left': 0.0, 'concept_on_pink_cell_concept_wall_on_left': 0.0, 'NOT_concept_no_pink_cell_below_m_concept_on_pink_cell': 0.032, 'concept_on_pink_cell_concept_wall_up_down_right': 0.0, 'concept_on_pink_cell_concept_wall_on_top': 0.038, 'concept_on_pink_cell_concept_wall_above_box': 0.0, 'concept_on_pink_cell_concept_wall_on_right_of_box': 0.0, 'concept_box_on_left_concept_on_pink_cell': 0.0, 'concept_no_wall_on_top_m_concept_on_pink_cell': 0.064, 'NOT_concept_pink_cell_on_top_concept_on_pink_cell': 0.114, 'concept_no_pink_cell_on_top_m_concept_on_pink_cell': 0.086, 'NOT_concept_no_wall_below_m_concept_on_pink_cell': 0.054, 'concept_on_pink_cell_concept_wall_below_box': 0.0, 'concept_on_pink_cell_concept_wall_on_right': 0.052, 'concept_on_pink_cell_concept_pink_cell_below': 0.012, 'NOT_concept_blank_cell_on_left_concept_on_pink_cell': 0.01, 'NOT_concept_target_on_right_concept_on_pink_cell': 0.112, 'concept_no_pink_cell_below_m_concept_on_pink_cell': 0.064, 'NOT_concept_target_on_top_concept_on_pink_cell': 0.118, 'NOT_concept_wall_top_right_concept_on_pink_cell': 0.104, 'concept_box_on_top_concept_on_pink_cell': 0.0, 'concept_no_wall_below_m_concept_on_pink_cell': 0.062, 'NOT_concept_wall_on_left_concept_on_pink_cell': 0.126, 'concept_on_pink_cell_concept_wall_on_left_of_box': 0.0, 'NOT_concept_box_on_top_concept_on_pink_cell': 0.132, 'concept_blank_cell_on_left_concept_on_pink_cell': 0.108, 'NOT_concept_wall_on_right_concept_on_pink_cell': 0.07, 'NOT_concept_pink_cell_on_right_concept_on_pink_cell': 0.118, 'NOT_concept_box_on_left_concept_on_pink_cell': 0.13, 'NOT_concept_wall_down_left_concept_on_pink_cell': 0.112, 'NOT_concept_pink_cell_below_concept_on_pink_cell': 0.108, 'NOT_concept_wall_below_concept_on_pink_cell': 0.082, 'concept_target_on_top_concept_wall_down_left': 0.0, 'concept_target_on_top_concept_wall_on_left': 0.0, 'NOT_concept_no_pink_cell_below_m_concept_target_on_top': 0.0, 'concept_target_on_top_concept_wall_up_down_right': 0.0, 'concept_target_on_top_concept_wall_on_top': 0.0, 'concept_target_on_top_concept_wall_above_box': 0.006, 'concept_target_on_top_concept_wall_on_right_of_box': 0.012, 'concept_box_on_left_concept_target_on_top': 0.0, 'concept_no_wall_on_top_m_concept_target_on_top': 0.0, 'NOT_concept_pink_cell_on_top_concept_target_on_top': 0.042, 'concept_no_pink_cell_on_top_m_concept_target_on_top': 0.036, 'NOT_concept_no_wall_below_m_concept_target_on_top': 0.0, 'concept_target_on_top_concept_wall_below_box': 0.004, 'concept_target_on_top_concept_wall_on_right': 0.0, 'concept_pink_cell_below_concept_target_on_top': 0.0, 'NOT_concept_blank_cell_on_left_concept_target_on_top': 0.0, 'NOT_concept_target_on_right_concept_target_on_top': 0.04, 'concept_no_pink_cell_below_m_concept_target_on_top': 0.044, 'NOT_concept_target_on_top_concept_target_on_top': 0.0, 'NOT_concept_wall_top_right_concept_target_on_top': 0.038, 'concept_box_on_top_concept_target_on_top': 0.0, 'concept_no_wall_below_m_concept_target_on_top': 0.046, 'NOT_concept_wall_on_left_concept_target_on_top': 0.04, 'concept_target_on_top_concept_wall_on_left_of_box': 0.006, 'NOT_concept_box_on_top_concept_target_on_top': 0.042, 'concept_blank_cell_on_left_concept_target_on_top': 0.038, 'NOT_concept_wall_on_right_concept_target_on_top': 0.046, 'NOT_concept_pink_cell_on_right_concept_target_on_top': 0.046, 'NOT_concept_box_on_left_concept_target_on_top': 0.042, 'NOT_concept_wall_down_left_concept_target_on_top': 0.044, 'NOT_concept_pink_cell_below_concept_target_on_top': 0.034, 'NOT_concept_wall_below_concept_target_on_top': 0.042, 'concept_wall_down_left_concept_wall_on_left': 0.0, 'NOT_concept_no_pink_cell_below_m_concept_wall_down_left': 0.0, 'concept_wall_down_left_concept_wall_up_down_right': 0.0, 'concept_wall_down_left_concept_wall_on_top': 0.0, 'concept_wall_above_box_concept_wall_down_left': 0.0, 'concept_wall_down_left_concept_wall_on_right_of_box': 0.0, 'concept_box_on_left_concept_wall_down_left': 0.0, 'concept_no_wall_on_top_m_concept_wall_down_left': 0.0, 'NOT_concept_pink_cell_on_top_concept_wall_down_left': 0.0, 'concept_no_pink_cell_on_top_m_concept_wall_down_left': 0.0, 'NOT_concept_no_wall_below_m_concept_wall_down_left': 0.0, 'concept_wall_below_box_concept_wall_down_left': 0.0, 'concept_wall_down_left_concept_wall_on_right': 0.0, 'concept_pink_cell_below_concept_wall_down_left': 0.0, 'NOT_concept_blank_cell_on_left_concept_wall_down_left': 0.0, 'NOT_concept_target_on_right_concept_wall_down_left': 0.0, 'concept_no_pink_cell_below_m_concept_wall_down_left': 0.0, 'NOT_concept_target_on_top_concept_wall_down_left': 0.0, 'NOT_concept_wall_top_right_concept_wall_down_left': 0.0, 'concept_box_on_top_concept_wall_down_left': 0.0, 'concept_no_wall_below_m_concept_wall_down_left': 0.0, 'NOT_concept_wall_on_left_concept_wall_down_left': 0.0, 'concept_wall_down_left_concept_wall_on_left_of_box': 0.0, 'NOT_concept_box_on_top_concept_wall_down_left': 0.0, 'concept_blank_cell_on_left_concept_wall_down_left': 0.0, 'NOT_concept_wall_on_right_concept_wall_down_left': 0.0, 'NOT_concept_pink_cell_on_right_concept_wall_down_left': 0.0, 'NOT_concept_box_on_left_concept_wall_down_left': 0.0, 'NOT_concept_wall_down_left_concept_wall_down_left': 0.0, 'NOT_concept_pink_cell_below_concept_wall_down_left': 0.0, 'NOT_concept_wall_below_concept_wall_down_left': 0.0, 'NOT_concept_no_pink_cell_below_m_concept_wall_on_left': 0.0, 'concept_wall_on_left_concept_wall_up_down_right': 0.0, 'concept_wall_on_left_concept_wall_on_top': 0.0, 'concept_wall_above_box_concept_wall_on_left': 0.0, 'concept_wall_on_left_concept_wall_on_right_of_box': 0.0, 'concept_box_on_left_concept_wall_on_left': 0.0, 'concept_no_wall_on_top_m_concept_wall_on_left': 0.0, 'NOT_concept_pink_cell_on_top_concept_wall_on_left': 0.0, 'concept_no_pink_cell_on_top_m_concept_wall_on_left': 0.0, 'NOT_concept_no_wall_below_m_concept_wall_on_left': 0.0, 'concept_wall_below_box_concept_wall_on_left': 0.0, 'concept_wall_on_left_concept_wall_on_right': 0.0, 'concept_pink_cell_below_concept_wall_on_left': 0.0, 'NOT_concept_blank_cell_on_left_concept_wall_on_left': 0.0, 'NOT_concept_target_on_right_concept_wall_on_left': 0.0, 'concept_no_pink_cell_below_m_concept_wall_on_left': 0.0, 'NOT_concept_target_on_top_concept_wall_on_left': 0.0, 'NOT_concept_wall_top_right_concept_wall_on_left': 0.0, 'concept_box_on_top_concept_wall_on_left': 0.0, 'concept_no_wall_below_m_concept_wall_on_left': 0.0, 'NOT_concept_wall_on_left_concept_wall_on_left': 0.0, 'concept_wall_on_left_concept_wall_on_left_of_box': 0.0, 'NOT_concept_box_on_top_concept_wall_on_left': 0.0, 'concept_blank_cell_on_left_concept_wall_on_left': 0.0, 'NOT_concept_wall_on_right_concept_wall_on_left': 0.0, 'NOT_concept_pink_cell_on_right_concept_wall_on_left': 0.0, 'NOT_concept_box_on_left_concept_wall_on_left': 0.0, 'NOT_concept_wall_down_left_concept_wall_on_left': 0.0, 'NOT_concept_pink_cell_below_concept_wall_on_left': 0.0, 'NOT_concept_wall_below_concept_wall_on_left': 0.0, 'NOT_concept_no_pink_cell_below_m_concept_wall_up_down_right': 0.0, 'NOT_concept_no_pink_cell_below_m_concept_wall_on_top': 0.076, 'NOT_concept_no_pink_cell_below_m_concept_wall_above_box': 0.034, 'NOT_concept_no_pink_cell_below_m_concept_wall_on_right_of_box': 0.078, 'NOT_concept_no_pink_cell_below_m_concept_box_on_left': 0.0, 'NOT_concept_no_pink_cell_below_m_concept_no_wall_on_top_m': 0.194, 'NOT_concept_no_pink_cell_below_m_NOT_concept_pink_cell_on_top': 0.256, 'NOT_concept_no_pink_cell_below_m_concept_no_pink_cell_on_top_m': 0.24, 'NOT_concept_no_pink_cell_below_m_NOT_concept_no_wall_below_m': 0.154, 'NOT_concept_no_pink_cell_below_m_concept_wall_below_box': 0.024, 'NOT_concept_no_pink_cell_below_m_concept_wall_on_right': 0.022, 'NOT_concept_no_pink_cell_below_m_concept_pink_cell_below': 0.128, 'NOT_concept_blank_cell_on_left_NOT_concept_no_pink_cell_below_m': 0.0, 'NOT_concept_no_pink_cell_below_m_NOT_concept_target_on_right': 0.26, 'NOT_concept_no_pink_cell_below_m_concept_no_pink_cell_below_m': 0.0, 'NOT_concept_no_pink_cell_below_m_NOT_concept_target_on_top': 0.298, 'NOT_concept_no_pink_cell_below_m_NOT_concept_wall_top_right': 0.308, 'NOT_concept_no_pink_cell_below_m_concept_box_on_top': 0.0, 'NOT_concept_no_pink_cell_below_m_concept_no_wall_below_m': 0.15, 'NOT_concept_no_pink_cell_below_m_NOT_concept_wall_on_left': 0.316, 'NOT_concept_no_pink_cell_below_m_concept_wall_on_left_of_box': 0.064, 'NOT_concept_box_on_top_NOT_concept_no_pink_cell_below_m': 0.308, 'NOT_concept_no_pink_cell_below_m_concept_blank_cell_on_left': 0.294, 'NOT_concept_no_pink_cell_below_m_NOT_concept_wall_on_right': 0.272, 'NOT_concept_no_pink_cell_below_m_NOT_concept_pink_cell_on_right': 0.314, 'NOT_concept_box_on_left_NOT_concept_no_pink_cell_below_m': 0.312, 'NOT_concept_no_pink_cell_below_m_NOT_concept_wall_down_left': 0.314, 'NOT_concept_no_pink_cell_below_m_NOT_concept_pink_cell_below': 0.166, 'NOT_concept_no_pink_cell_below_m_NOT_concept_wall_below': 0.178, 'concept_wall_on_top_concept_wall_up_down_right': 0.0, 'concept_wall_above_box_concept_wall_up_down_right': 0.0, 'concept_wall_on_right_of_box_concept_wall_up_down_right': 0.0, 'concept_box_on_left_concept_wall_up_down_right': 0.0, 'concept_no_wall_on_top_m_concept_wall_up_down_right': 0.0, 'NOT_concept_pink_cell_on_top_concept_wall_up_down_right': 0.0, 'concept_no_pink_cell_on_top_m_concept_wall_up_down_right': 0.0, 'NOT_concept_no_wall_below_m_concept_wall_up_down_right': 0.0, 'concept_wall_below_box_concept_wall_up_down_right': 0.0, 'concept_wall_on_right_concept_wall_up_down_right': 0.0, 'concept_pink_cell_below_concept_wall_up_down_right': 0.0, 'NOT_concept_blank_cell_on_left_concept_wall_up_down_right': 0.0, 'NOT_concept_target_on_right_concept_wall_up_down_right': 0.0, 'concept_no_pink_cell_below_m_concept_wall_up_down_right': 0.0, 'NOT_concept_target_on_top_concept_wall_up_down_right': 0.0, 'NOT_concept_wall_top_right_concept_wall_up_down_right': 0.0, 'concept_box_on_top_concept_wall_up_down_right': 0.0, 'concept_no_wall_below_m_concept_wall_up_down_right': 0.0, 'NOT_concept_wall_on_left_concept_wall_up_down_right': 0.0, 'concept_wall_on_left_of_box_concept_wall_up_down_right': 0.0, 'NOT_concept_box_on_top_concept_wall_up_down_right': 0.0, 'concept_blank_cell_on_left_concept_wall_up_down_right': 0.0, 'NOT_concept_wall_on_right_concept_wall_up_down_right': 0.0, 'NOT_concept_pink_cell_on_right_concept_wall_up_down_right': 0.0, 'NOT_concept_box_on_left_concept_wall_up_down_right': 0.0, 'NOT_concept_wall_down_left_concept_wall_up_down_right': 0.0, 'NOT_concept_pink_cell_below_concept_wall_up_down_right': 0.0, 'NOT_concept_wall_below_concept_wall_up_down_right': 0.0, 'concept_wall_above_box_concept_wall_on_top': 0.024, 'concept_wall_on_right_of_box_concept_wall_on_top': 0.064, 'concept_box_on_left_concept_wall_on_top': 0.0, 'concept_no_wall_on_top_m_concept_wall_on_top': 0.0, 'NOT_concept_pink_cell_on_top_concept_wall_on_top': 0.252, 'concept_no_pink_cell_on_top_m_concept_wall_on_top': 0.118, 'NOT_concept_no_wall_below_m_concept_wall_on_top': 0.108, 'concept_wall_below_box_concept_wall_on_top': 0.02, 'concept_wall_on_right_concept_wall_on_top': 0.098, 'concept_pink_cell_below_concept_wall_on_top': 0.0, 'NOT_concept_blank_cell_on_left_concept_wall_on_top': 0.0, 'NOT_concept_target_on_right_concept_wall_on_top': 0.202, 'concept_no_pink_cell_below_m_concept_wall_on_top': 0.17, 'NOT_concept_target_on_top_concept_wall_on_top': 0.25, 'NOT_concept_wall_top_right_concept_wall_on_top': 0.16, 'concept_box_on_top_concept_wall_on_top': 0.0, 'concept_no_wall_below_m_concept_wall_on_top': 0.152, 'NOT_concept_wall_on_left_concept_wall_on_top': 0.244, 'concept_wall_on_left_of_box_concept_wall_on_top': 0.046, 'NOT_concept_box_on_top_concept_wall_on_top': 0.25, 'concept_blank_cell_on_left_concept_wall_on_top': 0.238, 'NOT_concept_wall_on_right_concept_wall_on_top': 0.16, 'NOT_concept_pink_cell_on_right_concept_wall_on_top': 0.244, 'NOT_concept_box_on_left_concept_wall_on_top': 0.25, 'NOT_concept_wall_down_left_concept_wall_on_top': 0.248, 'NOT_concept_pink_cell_below_concept_wall_on_top': 0.242, 'NOT_concept_wall_below_concept_wall_on_top': 0.188, 'concept_wall_above_box_concept_wall_on_right_of_box': 0.002, 'concept_box_on_left_concept_wall_above_box': 0.0, 'concept_no_wall_on_top_m_concept_wall_above_box': 0.064, 'NOT_concept_pink_cell_on_top_concept_wall_above_box': 0.106, 'concept_no_pink_cell_on_top_m_concept_wall_above_box': 0.09, 'NOT_concept_no_wall_below_m_concept_wall_above_box': 0.046, 'concept_wall_above_box_concept_wall_below_box': 0.018, 'concept_wall_above_box_concept_wall_on_right': 0.04, 'concept_pink_cell_below_concept_wall_above_box': 0.012, 'NOT_concept_blank_cell_on_left_concept_wall_above_box': 0.018, 'NOT_concept_target_on_right_concept_wall_above_box': 0.116, 'concept_no_pink_cell_below_m_concept_wall_above_box': 0.08, 'NOT_concept_target_on_top_concept_wall_above_box': 0.106, 'NOT_concept_wall_top_right_concept_wall_above_box': 0.114, 'concept_box_on_top_concept_wall_above_box': 0.0, 'concept_no_wall_below_m_concept_wall_above_box': 0.068, 'NOT_concept_wall_on_left_concept_wall_above_box': 0.128, 'concept_wall_above_box_concept_wall_on_left_of_box': 0.0, 'NOT_concept_box_on_top_concept_wall_above_box': 0.118, 'concept_blank_cell_on_left_concept_wall_above_box': 0.106, 'NOT_concept_wall_on_right_concept_wall_above_box': 0.08, 'NOT_concept_pink_cell_on_right_concept_wall_above_box': 0.128, 'NOT_concept_box_on_left_concept_wall_above_box': 0.12, 'NOT_concept_wall_down_left_concept_wall_above_box': 0.112, 'NOT_concept_pink_cell_below_concept_wall_above_box': 0.11, 'NOT_concept_wall_below_concept_wall_above_box': 0.082, 'concept_box_on_left_concept_wall_on_right_of_box': 0.0, 'concept_no_wall_on_top_m_concept_wall_on_right_of_box': 0.104, 'NOT_concept_pink_cell_on_top_concept_wall_on_right_of_box': 0.186, 'concept_no_pink_cell_on_top_m_concept_wall_on_right_of_box': 0.164, 'NOT_concept_no_wall_below_m_concept_wall_on_right_of_box': 0.088, 'concept_wall_below_box_concept_wall_on_right_of_box': 0.04, 'concept_wall_on_right_concept_wall_on_right_of_box': 0.076, 'concept_pink_cell_below_concept_wall_on_right_of_box': 0.026, 'NOT_concept_blank_cell_on_left_concept_wall_on_right_of_box': 0.016, 'NOT_concept_target_on_right_concept_wall_on_right_of_box': 0.198, 'concept_no_pink_cell_below_m_concept_wall_on_right_of_box': 0.148, 'NOT_concept_target_on_top_concept_wall_on_right_of_box': 0.212, 'NOT_concept_wall_top_right_concept_wall_on_right_of_box': 0.19, 'concept_box_on_top_concept_wall_on_right_of_box': 0.0, 'concept_no_wall_below_m_concept_wall_on_right_of_box': 0.13, 'NOT_concept_wall_on_left_concept_wall_on_right_of_box': 0.21, 'concept_wall_on_left_of_box_concept_wall_on_right_of_box': 0.0, 'NOT_concept_box_on_top_concept_wall_on_right_of_box': 0.202, 'concept_blank_cell_on_left_concept_wall_on_right_of_box': 0.186, 'NOT_concept_wall_on_right_concept_wall_on_right_of_box': 0.14, 'NOT_concept_pink_cell_on_right_concept_wall_on_right_of_box': 0.208, 'NOT_concept_box_on_left_concept_wall_on_right_of_box': 0.212, 'NOT_concept_wall_down_left_concept_wall_on_right_of_box': 0.212, 'NOT_concept_pink_cell_below_concept_wall_on_right_of_box': 0.184, 'NOT_concept_wall_below_concept_wall_on_right_of_box': 0.152, 'concept_box_on_left_concept_no_wall_on_top_m': 0.0, 'NOT_concept_pink_cell_on_top_concept_box_on_left': 0.0, 'concept_box_on_left_concept_no_pink_cell_on_top_m': 0.0, 'NOT_concept_no_wall_below_m_concept_box_on_left': 0.0, 'concept_box_on_left_concept_wall_below_box': 0.0, 'concept_box_on_left_concept_wall_on_right': 0.0, 'concept_box_on_left_concept_pink_cell_below': 0.0, 'NOT_concept_blank_cell_on_left_concept_box_on_left': 0.0, 'NOT_concept_target_on_right_concept_box_on_left': 0.0, 'concept_box_on_left_concept_no_pink_cell_below_m': 0.0, 'NOT_concept_target_on_top_concept_box_on_left': 0.0, 'NOT_concept_wall_top_right_concept_box_on_left': 0.0, 'concept_box_on_left_concept_box_on_top': 0.0, 'concept_box_on_left_concept_no_wall_below_m': 0.0, 'NOT_concept_wall_on_left_concept_box_on_left': 0.0, 'concept_box_on_left_concept_wall_on_left_of_box': 0.0, 'NOT_concept_box_on_top_concept_box_on_left': 0.0, 'concept_blank_cell_on_left_concept_box_on_left': 0.0, 'NOT_concept_wall_on_right_concept_box_on_left': 0.0, 'NOT_concept_pink_cell_on_right_concept_box_on_left': 0.0, 'NOT_concept_box_on_left_concept_box_on_left': 0.0, 'NOT_concept_wall_down_left_concept_box_on_left': 0.0, 'NOT_concept_pink_cell_below_concept_box_on_left': 0.0, 'NOT_concept_wall_below_concept_box_on_left': 0.0, 'NOT_concept_pink_cell_on_top_concept_no_wall_on_top_m': 0.436, 'concept_no_pink_cell_on_top_m_concept_no_wall_on_top_m': 0.388, 'NOT_concept_no_wall_below_m_concept_no_wall_on_top_m': 0.218, 'concept_no_wall_on_top_m_concept_wall_below_box': 0.08, 'concept_no_wall_on_top_m_concept_wall_on_right': 0.23, 'concept_no_wall_on_top_m_concept_pink_cell_below': 0.078, 'NOT_concept_blank_cell_on_left_concept_no_wall_on_top_m': 0.132, 'NOT_concept_target_on_right_concept_no_wall_on_top_m': 0.56, 'concept_no_pink_cell_below_m_concept_no_wall_on_top_m': 0.372, 'NOT_concept_target_on_top_concept_no_wall_on_top_m': 0.558, 'NOT_concept_wall_top_right_concept_no_wall_on_top_m': 0.556, 'concept_box_on_top_concept_no_wall_on_top_m': 0.0, 'concept_no_wall_below_m_concept_no_wall_on_top_m': 0.342, 'NOT_concept_wall_on_left_concept_no_wall_on_top_m': 0.562, 'concept_no_wall_on_top_m_concept_wall_on_left_of_box': 0.116, 'NOT_concept_box_on_top_concept_no_wall_on_top_m': 0.574, 'concept_blank_cell_on_left_concept_no_wall_on_top_m': 0.428, 'NOT_concept_wall_on_right_concept_no_wall_on_top_m': 0.346, 'NOT_concept_pink_cell_on_right_concept_no_wall_on_top_m': 0.58, 'NOT_concept_box_on_left_concept_no_wall_on_top_m': 0.558, 'NOT_concept_wall_down_left_concept_no_wall_on_top_m': 0.56, 'NOT_concept_pink_cell_below_concept_no_wall_on_top_m': 0.478, 'NOT_concept_wall_below_concept_no_wall_on_top_m': 0.438, 'NOT_concept_pink_cell_on_top_concept_no_pink_cell_on_top_m': 0.71, 'NOT_concept_no_wall_below_m_NOT_concept_pink_cell_on_top': 0.384, 'NOT_concept_pink_cell_on_top_concept_wall_below_box': 0.096, 'NOT_concept_pink_cell_on_top_concept_wall_on_right': 0.384, 'NOT_concept_pink_cell_on_top_concept_pink_cell_below': 0.088, 'NOT_concept_blank_cell_on_left_NOT_concept_pink_cell_on_top': 0.132, 'NOT_concept_pink_cell_on_top_NOT_concept_target_on_right': 0.83, 'NOT_concept_pink_cell_on_top_concept_no_pink_cell_below_m': 0.602, 'NOT_concept_pink_cell_on_top_NOT_concept_target_on_top': 0.83, 'NOT_concept_pink_cell_on_top_NOT_concept_wall_top_right': 0.77, 'NOT_concept_pink_cell_on_top_concept_box_on_top': 0.0, 'NOT_concept_pink_cell_on_top_concept_no_wall_below_m': 0.48, 'NOT_concept_pink_cell_on_top_NOT_concept_wall_on_left': 0.87, 'NOT_concept_pink_cell_on_top_concept_wall_on_left_of_box': 0.178, 'NOT_concept_box_on_top_NOT_concept_pink_cell_on_top': 0.864, 'NOT_concept_pink_cell_on_top_concept_blank_cell_on_left': 0.738, 'NOT_concept_pink_cell_on_top_NOT_concept_wall_on_right': 0.484, 'NOT_concept_pink_cell_on_right_NOT_concept_pink_cell_on_top': 0.87, 'NOT_concept_box_on_left_NOT_concept_pink_cell_on_top': 0.864, 'NOT_concept_pink_cell_on_top_NOT_concept_wall_down_left': 0.87, 'NOT_concept_pink_cell_below_NOT_concept_pink_cell_on_top': 0.778, 'NOT_concept_pink_cell_on_top_NOT_concept_wall_below': 0.618, 'NOT_concept_no_wall_below_m_concept_no_pink_cell_on_top_m': 0.34, 'concept_no_pink_cell_on_top_m_concept_wall_below_box': 0.082, 'concept_no_pink_cell_on_top_m_concept_wall_on_right': 0.346, 'concept_no_pink_cell_on_top_m_concept_pink_cell_below': 0.076, 'NOT_concept_blank_cell_on_left_concept_no_pink_cell_on_top_m': 0.14, 'NOT_concept_target_on_right_concept_no_pink_cell_on_top_m': 0.722, 'concept_no_pink_cell_below_m_concept_no_pink_cell_on_top_m': 0.476, 'NOT_concept_target_on_top_concept_no_pink_cell_on_top_m': 0.666, 'NOT_concept_wall_top_right_concept_no_pink_cell_on_top_m': 0.644, 'concept_box_on_top_concept_no_pink_cell_on_top_m': 0.0, 'concept_no_pink_cell_on_top_m_concept_no_wall_below_m': 0.36, 'NOT_concept_wall_on_left_concept_no_pink_cell_on_top_m': 0.71, 'concept_no_pink_cell_on_top_m_concept_wall_on_left_of_box': 0.146, 'NOT_concept_box_on_top_concept_no_pink_cell_on_top_m': 0.708, 'concept_blank_cell_on_left_concept_no_pink_cell_on_top_m': 0.588, 'NOT_concept_wall_on_right_concept_no_pink_cell_on_top_m': 0.366, 'NOT_concept_pink_cell_on_right_concept_no_pink_cell_on_top_m': 0.696, 'NOT_concept_box_on_left_concept_no_pink_cell_on_top_m': 0.694, 'NOT_concept_wall_down_left_concept_no_pink_cell_on_top_m': 0.714, 'NOT_concept_pink_cell_below_concept_no_pink_cell_on_top_m': 0.632, 'NOT_concept_wall_below_concept_no_pink_cell_on_top_m': 0.454, 'NOT_concept_no_wall_below_m_concept_wall_below_box': 0.036, 'NOT_concept_no_wall_below_m_concept_wall_on_right': 0.186, 'NOT_concept_no_wall_below_m_concept_pink_cell_below': 0.0, 'NOT_concept_blank_cell_on_left_NOT_concept_no_wall_below_m': 0.0, 'NOT_concept_no_wall_below_m_NOT_concept_target_on_right': 0.39, 'NOT_concept_no_wall_below_m_concept_no_pink_cell_below_m': 0.234, 'NOT_concept_no_wall_below_m_NOT_concept_target_on_top': 0.374, 'NOT_concept_no_wall_below_m_NOT_concept_wall_top_right': 0.354, 'NOT_concept_no_wall_below_m_concept_box_on_top': 0.0, 'NOT_concept_no_wall_below_m_concept_no_wall_below_m': 0.0, 'NOT_concept_no_wall_below_m_NOT_concept_wall_on_left': 0.378, 'NOT_concept_no_wall_below_m_concept_wall_on_left_of_box': 0.082, 'NOT_concept_box_on_top_NOT_concept_no_wall_below_m': 0.376, 'NOT_concept_no_wall_below_m_concept_blank_cell_on_left': 0.392, 'NOT_concept_no_wall_below_m_NOT_concept_wall_on_right': 0.212, 'NOT_concept_no_wall_below_m_NOT_concept_pink_cell_on_right': 0.392, 'NOT_concept_box_on_left_NOT_concept_no_wall_below_m': 0.394, 'NOT_concept_no_wall_below_m_NOT_concept_wall_down_left': 0.392, 'NOT_concept_no_wall_below_m_NOT_concept_pink_cell_below': 0.396, 'NOT_concept_no_wall_below_m_NOT_concept_wall_below': 0.154, 'concept_wall_below_box_concept_wall_on_right': 0.036, 'concept_pink_cell_below_concept_wall_below_box': 0.014, 'NOT_concept_blank_cell_on_left_concept_wall_below_box': 0.024, 'NOT_concept_target_on_right_concept_wall_below_box': 0.114, 'concept_no_pink_cell_below_m_concept_wall_below_box': 0.088, 'NOT_concept_target_on_top_concept_wall_below_box': 0.11, 'NOT_concept_wall_top_right_concept_wall_below_box': 0.116, 'concept_box_on_top_concept_wall_below_box': 0.0, 'concept_no_wall_below_m_concept_wall_below_box': 0.066, 'NOT_concept_wall_on_left_concept_wall_below_box': 0.12, 'concept_wall_below_box_concept_wall_on_left_of_box': 0.022, 'NOT_concept_box_on_top_concept_wall_below_box': 0.12, 'concept_blank_cell_on_left_concept_wall_below_box': 0.104, 'NOT_concept_wall_on_right_concept_wall_below_box': 0.078, 'NOT_concept_pink_cell_on_right_concept_wall_below_box': 0.12, 'NOT_concept_box_on_left_concept_wall_below_box': 0.116, 'NOT_concept_wall_down_left_concept_wall_below_box': 0.106, 'NOT_concept_pink_cell_below_concept_wall_below_box': 0.098, 'NOT_concept_wall_below_concept_wall_below_box': 0.088, 'concept_pink_cell_below_concept_wall_on_right': 0.0, 'NOT_concept_blank_cell_on_left_concept_wall_on_right': 0.086, 'NOT_concept_target_on_right_concept_wall_on_right': 0.388, 'concept_no_pink_cell_below_m_concept_wall_on_right': 0.352, 'NOT_concept_target_on_top_concept_wall_on_right': 0.376, 'NOT_concept_wall_top_right_concept_wall_on_right': 0.284, 'concept_box_on_top_concept_wall_on_right': 0.0, 'concept_no_wall_below_m_concept_wall_on_right': 0.192, 'NOT_concept_wall_on_left_concept_wall_on_right': 0.396, 'concept_wall_on_left_of_box_concept_wall_on_right': 0.084, 'NOT_concept_box_on_top_concept_wall_on_right': 0.376, 'concept_blank_cell_on_left_concept_wall_on_right': 0.292, 'NOT_concept_wall_on_right_concept_wall_on_right': 0.0, 'NOT_concept_pink_cell_on_right_concept_wall_on_right': 0.39, 'NOT_concept_box_on_left_concept_wall_on_right': 0.39, 'NOT_concept_wall_down_left_concept_wall_on_right': 0.372, 'NOT_concept_pink_cell_below_concept_wall_on_right': 0.368, 'NOT_concept_wall_below_concept_wall_on_right': 0.26, 'NOT_concept_blank_cell_on_left_concept_pink_cell_below': 0.0, 'NOT_concept_target_on_right_concept_pink_cell_below': 0.132, 'concept_no_pink_cell_below_m_concept_pink_cell_below': 0.0, 'NOT_concept_target_on_top_concept_pink_cell_below': 0.12, 'NOT_concept_wall_top_right_concept_pink_cell_below': 0.134, 'concept_box_on_top_concept_pink_cell_below': 0.0, 'concept_no_wall_below_m_concept_pink_cell_below': 0.12, 'NOT_concept_wall_on_left_concept_pink_cell_below': 0.126, 'concept_pink_cell_below_concept_wall_on_left_of_box': 0.026, 'NOT_concept_box_on_top_concept_pink_cell_below': 0.122, 'concept_blank_cell_on_left_concept_pink_cell_below': 0.132, 'NOT_concept_wall_on_right_concept_pink_cell_below': 0.134, 'NOT_concept_pink_cell_on_right_concept_pink_cell_below': 0.122, 'NOT_concept_box_on_left_concept_pink_cell_below': 0.126, 'NOT_concept_wall_down_left_concept_pink_cell_below': 0.132, 'NOT_concept_pink_cell_below_concept_pink_cell_below': 0.0, 'NOT_concept_wall_below_concept_pink_cell_below': 0.12, 'NOT_concept_blank_cell_on_left_NOT_concept_target_on_right': 0.134, 'NOT_concept_blank_cell_on_left_concept_no_pink_cell_below_m': 0.132, 'NOT_concept_blank_cell_on_left_NOT_concept_target_on_top': 0.124, 'NOT_concept_blank_cell_on_left_NOT_concept_wall_top_right': 0.138, 'NOT_concept_blank_cell_on_left_concept_box_on_top': 0.0, 'NOT_concept_blank_cell_on_left_concept_no_wall_below_m': 0.122, 'NOT_concept_blank_cell_on_left_NOT_concept_wall_on_left': 0.14, 'NOT_concept_blank_cell_on_left_concept_wall_on_left_of_box': 0.028, 'NOT_concept_blank_cell_on_left_NOT_concept_box_on_top': 0.136, 'NOT_concept_blank_cell_on_left_concept_blank_cell_on_left': 0.0, 'NOT_concept_blank_cell_on_left_NOT_concept_wall_on_right': 0.038, 'NOT_concept_blank_cell_on_left_NOT_concept_pink_cell_on_right': 0.13, 'NOT_concept_blank_cell_on_left_NOT_concept_box_on_left': 0.126, 'NOT_concept_blank_cell_on_left_NOT_concept_wall_down_left': 0.134, 'NOT_concept_blank_cell_on_left_NOT_concept_pink_cell_below': 0.134, 'NOT_concept_blank_cell_on_left_NOT_concept_wall_below': 0.128, 'NOT_concept_target_on_right_concept_no_pink_cell_below_m': 0.696, 'NOT_concept_target_on_right_NOT_concept_target_on_top': 0.92, 'NOT_concept_target_on_right_NOT_concept_wall_top_right': 0.868, 'NOT_concept_target_on_right_concept_box_on_top': 0.0, 'NOT_concept_target_on_right_concept_no_wall_below_m': 0.58, 'NOT_concept_target_on_right_NOT_concept_wall_on_left': 0.96, 'NOT_concept_target_on_right_concept_wall_on_left_of_box': 0.2, 'NOT_concept_box_on_top_NOT_concept_target_on_right': 0.964, 'NOT_concept_target_on_right_concept_blank_cell_on_left': 0.838, 'NOT_concept_target_on_right_NOT_concept_wall_on_right': 0.572, 'NOT_concept_pink_cell_on_right_NOT_concept_target_on_right': 0.956, 'NOT_concept_box_on_left_NOT_concept_target_on_right': 0.96, 'NOT_concept_target_on_right_NOT_concept_wall_down_left': 0.96, 'NOT_concept_pink_cell_below_NOT_concept_target_on_right': 0.828, 'NOT_concept_target_on_right_NOT_concept_wall_below': 0.726, 'NOT_concept_target_on_top_concept_no_pink_cell_below_m': 0.644, 'NOT_concept_wall_top_right_concept_no_pink_cell_below_m': 0.6, 'concept_box_on_top_concept_no_pink_cell_below_m': 0.0, 'concept_no_pink_cell_below_m_concept_no_wall_below_m': 0.452, 'NOT_concept_wall_on_left_concept_no_pink_cell_below_m': 0.688, 'concept_no_pink_cell_below_m_concept_wall_on_left_of_box': 0.13, 'NOT_concept_box_on_top_concept_no_pink_cell_below_m': 0.684, 'concept_blank_cell_on_left_concept_no_pink_cell_below_m': 0.56, 'NOT_concept_wall_on_right_concept_no_pink_cell_below_m': 0.34, 'NOT_concept_pink_cell_on_right_concept_no_pink_cell_below_m': 0.688, 'NOT_concept_box_on_left_concept_no_pink_cell_below_m': 0.686, 'NOT_concept_wall_down_left_concept_no_pink_cell_below_m': 0.694, 'NOT_concept_pink_cell_below_concept_no_pink_cell_below_m': 0.694, 'NOT_concept_wall_below_concept_no_pink_cell_below_m': 0.61, 'NOT_concept_target_on_top_NOT_concept_wall_top_right': 0.87, 'NOT_concept_target_on_top_concept_box_on_top': 0.0, 'NOT_concept_target_on_top_concept_no_wall_below_m': 0.578, 'NOT_concept_target_on_top_NOT_concept_wall_on_left': 0.96, 'NOT_concept_target_on_top_concept_wall_on_left_of_box': 0.194, 'NOT_concept_box_on_top_NOT_concept_target_on_top': 0.964, 'NOT_concept_target_on_top_concept_blank_cell_on_left': 0.824, 'NOT_concept_target_on_top_NOT_concept_wall_on_right': 0.574, 'NOT_concept_pink_cell_on_right_NOT_concept_target_on_top': 0.956, 'NOT_concept_box_on_left_NOT_concept_target_on_top': 0.958, 'NOT_concept_target_on_top_NOT_concept_wall_down_left': 0.96, 'NOT_concept_pink_cell_below_NOT_concept_target_on_top': 0.832, 'NOT_concept_target_on_top_NOT_concept_wall_below': 0.714, 'NOT_concept_wall_top_right_concept_box_on_top': 0.0, 'NOT_concept_wall_top_right_concept_no_wall_below_m': 0.552, 'NOT_concept_wall_on_left_NOT_concept_wall_top_right': 0.898, 'NOT_concept_wall_top_right_concept_wall_on_left_of_box': 0.184, 'NOT_concept_box_on_top_NOT_concept_wall_top_right': 0.908, 'NOT_concept_wall_top_right_concept_blank_cell_on_left': 0.764, 'NOT_concept_wall_on_right_NOT_concept_wall_top_right': 0.618, 'NOT_concept_pink_cell_on_right_NOT_concept_wall_top_right': 0.898, 'NOT_concept_box_on_left_NOT_concept_wall_top_right': 0.906, 'NOT_concept_wall_down_left_NOT_concept_wall_top_right': 0.902, 'NOT_concept_pink_cell_below_NOT_concept_wall_top_right': 0.784, 'NOT_concept_wall_below_NOT_concept_wall_top_right': 0.706, 'concept_box_on_top_concept_no_wall_below_m': 0.0, 'NOT_concept_wall_on_left_concept_box_on_top': 0.0, 'concept_box_on_top_concept_wall_on_left_of_box': 0.0, 'NOT_concept_box_on_top_concept_box_on_top': 0.0, 'concept_blank_cell_on_left_concept_box_on_top': 0.0, 'NOT_concept_wall_on_right_concept_box_on_top': 0.0, 'NOT_concept_pink_cell_on_right_concept_box_on_top': 0.0, 'NOT_concept_box_on_left_concept_box_on_top': 0.0, 'NOT_concept_wall_down_left_concept_box_on_top': 0.0, 'NOT_concept_pink_cell_below_concept_box_on_top': 0.0, 'NOT_concept_wall_below_concept_box_on_top': 0.0, 'NOT_concept_wall_on_left_concept_no_wall_below_m': 0.598, 'concept_no_wall_below_m_concept_wall_on_left_of_box': 0.128, 'NOT_concept_box_on_top_concept_no_wall_below_m': 0.606, 'concept_blank_cell_on_left_concept_no_wall_below_m': 0.502, 'NOT_concept_wall_on_right_concept_no_wall_below_m': 0.44, 'NOT_concept_pink_cell_on_right_concept_no_wall_below_m': 0.616, 'NOT_concept_box_on_left_concept_no_wall_below_m': 0.598, 'NOT_concept_wall_down_left_concept_no_wall_below_m': 0.606, 'NOT_concept_pink_cell_below_concept_no_wall_below_m': 0.486, 'NOT_concept_wall_below_concept_no_wall_below_m': 0.59, 'NOT_concept_wall_on_left_concept_wall_on_left_of_box': 0.204, 'NOT_concept_box_on_top_NOT_concept_wall_on_left': 1.0, 'NOT_concept_wall_on_left_concept_blank_cell_on_left': 0.868, 'NOT_concept_wall_on_left_NOT_concept_wall_on_right': 0.64, 'NOT_concept_pink_cell_on_right_NOT_concept_wall_on_left': 1.0, 'NOT_concept_box_on_left_NOT_concept_wall_on_left': 1.0, 'NOT_concept_wall_down_left_NOT_concept_wall_on_left': 1.0, 'NOT_concept_pink_cell_below_NOT_concept_wall_on_left': 0.876, 'NOT_concept_wall_below_NOT_concept_wall_on_left': 0.774, 'NOT_concept_box_on_top_concept_wall_on_left_of_box': 0.2, 'concept_blank_cell_on_left_concept_wall_on_left_of_box': 0.18, 'NOT_concept_wall_on_right_concept_wall_on_left_of_box': 0.13, 'NOT_concept_pink_cell_on_right_concept_wall_on_left_of_box': 0.206, 'NOT_concept_box_on_left_concept_wall_on_left_of_box': 0.208, 'NOT_concept_wall_down_left_concept_wall_on_left_of_box': 0.208, 'NOT_concept_pink_cell_below_concept_wall_on_left_of_box': 0.188, 'NOT_concept_wall_below_concept_wall_on_left_of_box': 0.146, 'NOT_concept_box_on_top_concept_blank_cell_on_left': 0.874, 'NOT_concept_box_on_top_NOT_concept_wall_on_right': 0.612, 'NOT_concept_box_on_top_NOT_concept_pink_cell_on_right': 1.0, 'NOT_concept_box_on_left_NOT_concept_box_on_top': 1.0, 'NOT_concept_box_on_top_NOT_concept_wall_down_left': 1.0, 'NOT_concept_box_on_top_NOT_concept_pink_cell_below': 0.874, 'NOT_concept_box_on_top_NOT_concept_wall_below': 0.752, 'NOT_concept_wall_on_right_concept_blank_cell_on_left': 0.586, 'NOT_concept_pink_cell_on_right_concept_blank_cell_on_left': 0.876, 'NOT_concept_box_on_left_concept_blank_cell_on_left': 0.868, 'NOT_concept_wall_down_left_concept_blank_cell_on_left': 0.86, 'NOT_concept_pink_cell_below_concept_blank_cell_on_left': 0.732, 'NOT_concept_wall_below_concept_blank_cell_on_left': 0.632, 'NOT_concept_pink_cell_on_right_NOT_concept_wall_on_right': 0.616, 'NOT_concept_box_on_left_NOT_concept_wall_on_right': 0.63, 'NOT_concept_wall_down_left_NOT_concept_wall_on_right': 0.624, 'NOT_concept_pink_cell_below_NOT_concept_wall_on_right': 0.502, 'NOT_concept_wall_below_NOT_concept_wall_on_right': 0.496, 'NOT_concept_box_on_left_NOT_concept_pink_cell_on_right': 1.0, 'NOT_concept_pink_cell_on_right_NOT_concept_wall_down_left': 1.0, 'NOT_concept_pink_cell_below_NOT_concept_pink_cell_on_right': 0.87, 'NOT_concept_pink_cell_on_right_NOT_concept_wall_below': 0.756, 'NOT_concept_box_on_left_NOT_concept_wall_down_left': 1.0, 'NOT_concept_box_on_left_NOT_concept_pink_cell_below': 0.87, 'NOT_concept_box_on_left_NOT_concept_wall_below': 0.762, 'NOT_concept_pink_cell_below_NOT_concept_wall_down_left': 0.858, 'NOT_concept_wall_below_NOT_concept_wall_down_left': 0.758, 'NOT_concept_pink_cell_below_NOT_concept_wall_below': 0.632}, 5: {'NOT_concept_wall_down_right': 0.916, 'NOT_concept_wall_top_right': 1.0, 'NOT_concept_target_on_right': 1.0, 'NOT_concept_pink_cell_on_right': 0.884, 'concept_no_pink_cell_on_top_m': 0.83, 'NOT_concept_wall_below': 0.75, 'concept_blank_cell_on_left': 0.566, 'concept_no_wall_below_m': 0.604, 'NOT_concept_wall_below_box': 0.868, 'concept_no_wall_on_right_m': 0.506, 'NOT_concept_wall_top_left': 1.0, 'NOT_concept_wall_on_top': 1.0, 'NOT_concept_wall_up_down_right': 1.0, 'NOT_concept_target_on_top': 0.96, 'NOT_concept_box_on_top': 1.0, 'NOT_concept_wall_on_right_of_box': 0.82, 'NOT_concept_on_pink_cell': 0.876, 'NOT_concept_wall_on_left': 0.688, 'NOT_concept_no_wall_on_top_m': 0.224, 'concept_blank_cell_below': 0.658, 'concept_no_pink_cell_below_m': 0.728, 'NOT_concept_wall_on_left_of_box': 0.81, 'NOT_concept_no_wall_on_left_m': 0.624, 'NOT_concept_box_below': 1.0, 'NOT_concept_wall_down_left': 0.932, 'concept_wall_above_box': 0.124, 'NOT_concept_pink_cell_on_left': 0.868, 'NOT_concept_box_on_right': 1.0, 'NOT_concept_box_on_left': 1.0, 'NOT_concept_pink_cell_on_top': 0.886, 'NOT_concept_wall_on_right': 0.722, 'NOT_concept_pink_cell_below': 0.89, 'concept_pink_cell_on_right': 0.12, 'concept_pink_cell_on_left': 0.122, 'concept_wall_top_right': 0.0, 'concept_box_below': 0.0, 'concept_box_on_right': 0.0, 'concept_no_wall_on_left_m': 0.366, 'concept_wall_down_right': 0.09, 'NOT_concept_no_wall_on_right_m': 0.5, 'concept_wall_top_left': 0.0, 'concept_target_on_right': 0.0, 'NOT_concept_blank_cell_below': 0.344, 'concept_wall_below': 0.21, 'NOT_concept_wall_above_box': 0.884, 'concept_pink_cell_on_top': 0.122, 'NOT_concept_no_pink_cell_on_top_m': 0.16, 'concept_on_pink_cell': 0.12, 'concept_target_on_top': 0.032, 'concept_wall_down_left': 0.072, 'concept_wall_on_left': 0.324, 'NOT_concept_no_pink_cell_below_m': 0.24, 'concept_wall_up_down_right': 0.0, 'concept_wall_on_top': 0.0, 'concept_wall_on_right_of_box': 0.184, 'concept_box_on_left': 0.0, 'concept_no_wall_on_top_m': 0.764, 'NOT_concept_no_wall_below_m': 0.388, 'concept_wall_below_box': 0.13, 'concept_wall_on_right': 0.252, 'concept_pink_cell_below': 0.108, 'NOT_concept_blank_cell_on_left': 0.412, 'concept_box_on_top': 0.0, 'concept_wall_on_left_of_box': 0.214, 'concept_blank_cell_below_concept_pink_cell_on_right': 0.118, 'concept_pink_cell_on_left_concept_pink_cell_on_right': 0.0, 'concept_pink_cell_on_right_concept_wall_top_right': 0.0, 'concept_box_below_concept_pink_cell_on_right': 0.0, 'NOT_concept_wall_down_right_concept_pink_cell_on_right': 0.118, 'concept_box_on_right_concept_pink_cell_on_right': 0.0, 'NOT_concept_wall_on_left_of_box_concept_pink_cell_on_right': 0.1, 'NOT_concept_wall_up_down_right_concept_pink_cell_on_right': 0.122, 'concept_no_wall_on_left_m_concept_pink_cell_on_right': 0.0, 'concept_pink_cell_on_right_concept_wall_down_right': 0.0, 'NOT_concept_pink_cell_on_left_concept_pink_cell_on_right': 0.114, 'NOT_concept_wall_below_box_concept_pink_cell_on_right': 0.104, 'NOT_concept_wall_on_top_concept_pink_cell_on_right': 0.106, 'NOT_concept_no_wall_on_right_m_concept_pink_cell_on_right': 0.0, 'NOT_concept_on_pink_cell_concept_pink_cell_on_right': 0.088, 'NOT_concept_box_on_right_concept_pink_cell_on_right': 0.104, 'concept_pink_cell_on_right_concept_wall_top_left': 0.0, 'concept_pink_cell_on_right_concept_target_on_right': 0.0, 'NOT_concept_blank_cell_below_concept_pink_cell_on_right': 0.0, 'concept_no_wall_on_right_m_concept_pink_cell_on_right': 0.124, 'concept_pink_cell_on_right_concept_wall_below': 0.0, 'NOT_concept_no_wall_on_left_m_concept_pink_cell_on_right': 0.12, 'NOT_concept_wall_top_left_concept_pink_cell_on_right': 0.126, 'NOT_concept_box_below_concept_pink_cell_on_right': 0.122, 'NOT_concept_wall_above_box_concept_pink_cell_on_right': 0.094, 'concept_pink_cell_on_right_concept_pink_cell_on_top': 0.0, 'NOT_concept_no_pink_cell_on_top_m_concept_pink_cell_on_right': 0.0, 'NOT_concept_wall_on_right_of_box_concept_pink_cell_on_right': 0.09, 'NOT_concept_no_wall_on_top_m_concept_pink_cell_on_right': 0.0, 'concept_on_pink_cell_concept_pink_cell_on_right': 0.01, 'concept_pink_cell_on_right_concept_target_on_top': 0.0, 'concept_pink_cell_on_right_concept_wall_down_left': 0.0, 'concept_pink_cell_on_right_concept_wall_on_left': 0.124, 'NOT_concept_no_pink_cell_below_m_concept_pink_cell_on_right': 0.0, 'concept_pink_cell_on_right_concept_wall_up_down_right': 0.0, 'concept_pink_cell_on_right_concept_wall_on_top': 0.0, 'concept_pink_cell_on_right_concept_wall_above_box': 0.01, 'concept_pink_cell_on_right_concept_wall_on_right_of_box': 0.026, 'concept_box_on_left_concept_pink_cell_on_right': 0.0, 'concept_no_wall_on_top_m_concept_pink_cell_on_right': 0.112, 'NOT_concept_pink_cell_on_top_concept_pink_cell_on_right': 0.112, 'concept_no_pink_cell_on_top_m_concept_pink_cell_on_right': 0.12, 'NOT_concept_no_wall_below_m_concept_pink_cell_on_right': 0.0, 'concept_pink_cell_on_right_concept_wall_below_box': 0.016, 'concept_pink_cell_on_right_concept_wall_on_right': 0.0, 'concept_pink_cell_below_concept_pink_cell_on_right': 0.0, 'NOT_concept_blank_cell_on_left_concept_pink_cell_on_right': 0.114, 'NOT_concept_target_on_right_concept_pink_cell_on_right': 0.118, 'concept_no_pink_cell_below_m_concept_pink_cell_on_right': 0.104, 'NOT_concept_target_on_top_concept_pink_cell_on_right': 0.114, 'NOT_concept_wall_top_right_concept_pink_cell_on_right': 0.116, 'concept_box_on_top_concept_pink_cell_on_right': 0.0, 'concept_no_wall_below_m_concept_pink_cell_on_right': 0.122, 'NOT_concept_wall_on_left_concept_pink_cell_on_right': 0.0, 'concept_pink_cell_on_right_concept_wall_on_left_of_box': 0.024, 'NOT_concept_box_on_top_concept_pink_cell_on_right': 0.116, 'concept_blank_cell_on_left_concept_pink_cell_on_right': 0.0, 'NOT_concept_wall_on_right_concept_pink_cell_on_right': 0.124, 'NOT_concept_pink_cell_on_right_concept_pink_cell_on_right': 0.0, 'NOT_concept_box_on_left_concept_pink_cell_on_right': 0.112, 'NOT_concept_wall_down_left_concept_pink_cell_on_right': 0.1, 'NOT_concept_pink_cell_below_concept_pink_cell_on_right': 0.124, 'NOT_concept_wall_below_concept_pink_cell_on_right': 0.122, 'concept_blank_cell_below_concept_pink_cell_on_left': 0.112, 'concept_blank_cell_below_concept_wall_top_right': 0.0, 'concept_blank_cell_below_concept_box_below': 0.0, 'NOT_concept_wall_down_right_concept_blank_cell_below': 0.662, 'concept_blank_cell_below_concept_box_on_right': 0.0, 'NOT_concept_wall_on_left_of_box_concept_blank_cell_below': 0.538, 'NOT_concept_wall_up_down_right_concept_blank_cell_below': 0.676, 'concept_blank_cell_below_concept_no_wall_on_left_m': 0.25, 'concept_blank_cell_below_concept_wall_down_right': 0.0, 'NOT_concept_pink_cell_on_left_concept_blank_cell_below': 0.518, 'NOT_concept_wall_below_box_concept_blank_cell_below': 0.562, 'NOT_concept_wall_on_top_concept_blank_cell_below': 0.638, 'NOT_concept_no_wall_on_right_m_concept_blank_cell_below': 0.392, 'NOT_concept_on_pink_cell_concept_blank_cell_below': 0.57, 'NOT_concept_box_on_right_concept_blank_cell_below': 0.666, 'concept_blank_cell_below_concept_wall_top_left': 0.0, 'concept_blank_cell_below_concept_target_on_right': 0.0, 'NOT_concept_blank_cell_below_concept_blank_cell_below': 0.0, 'concept_blank_cell_below_concept_no_wall_on_right_m': 0.272, 'concept_blank_cell_below_concept_wall_below': 0.0, 'NOT_concept_no_wall_on_left_m_concept_blank_cell_below': 0.416, 'NOT_concept_wall_top_left_concept_blank_cell_below': 0.642, 'NOT_concept_box_below_concept_blank_cell_below': 0.66, 'NOT_concept_wall_above_box_concept_blank_cell_below': 0.584, 'concept_blank_cell_below_concept_pink_cell_on_top': 0.086, 'NOT_concept_no_pink_cell_on_top_m_concept_blank_cell_below': 0.136, 'NOT_concept_wall_on_right_of_box_concept_blank_cell_below': 0.542, 'NOT_concept_no_wall_on_top_m_concept_blank_cell_below': 0.112, 'concept_blank_cell_below_concept_on_pink_cell': 0.078, 'concept_blank_cell_below_concept_target_on_top': 0.044, 'concept_blank_cell_below_concept_wall_down_left': 0.0, 'concept_blank_cell_below_concept_wall_on_left': 0.24, 'NOT_concept_no_pink_cell_below_m_concept_blank_cell_below': 0.0, 'concept_blank_cell_below_concept_wall_up_down_right': 0.0, 'concept_blank_cell_below_concept_wall_on_top': 0.0, 'concept_blank_cell_below_concept_wall_above_box': 0.08, 'concept_blank_cell_below_concept_wall_on_right_of_box': 0.118, 'concept_blank_cell_below_concept_box_on_left': 0.0, 'concept_blank_cell_below_concept_no_wall_on_top_m': 0.546, 'NOT_concept_pink_cell_on_top_concept_blank_cell_below': 0.56, 'concept_blank_cell_below_concept_no_pink_cell_on_top_m': 0.534, 'NOT_concept_no_wall_below_m_concept_blank_cell_below': 0.162, 'concept_blank_cell_below_concept_wall_below_box': 0.094, 'concept_blank_cell_below_concept_wall_on_right': 0.186, 'concept_blank_cell_below_concept_pink_cell_below': 0.0, 'NOT_concept_blank_cell_on_left_concept_blank_cell_below': 0.376, 'NOT_concept_target_on_right_concept_blank_cell_below': 0.666, 'concept_blank_cell_below_concept_no_pink_cell_below_m': 0.662, 'NOT_concept_target_on_top_concept_blank_cell_below': 0.628, 'NOT_concept_wall_top_right_concept_blank_cell_below': 0.658, 'concept_blank_cell_below_concept_box_on_top': 0.0, 'concept_blank_cell_below_concept_no_wall_below_m': 0.484, 'NOT_concept_wall_on_left_concept_blank_cell_below': 0.422, 'concept_blank_cell_below_concept_wall_on_left_of_box': 0.144, 'NOT_concept_box_on_top_concept_blank_cell_below': 0.644, 'concept_blank_cell_below_concept_blank_cell_on_left': 0.308, 'NOT_concept_wall_on_right_concept_blank_cell_below': 0.474, 'NOT_concept_pink_cell_on_right_concept_blank_cell_below': 0.546, 'NOT_concept_box_on_left_concept_blank_cell_below': 0.646, 'NOT_concept_wall_down_left_concept_blank_cell_below': 0.638, 'NOT_concept_pink_cell_below_concept_blank_cell_below': 0.676, 'NOT_concept_wall_below_concept_blank_cell_below': 0.646, 'concept_pink_cell_on_left_concept_wall_top_right': 0.0, 'concept_box_below_concept_pink_cell_on_left': 0.0, 'NOT_concept_wall_down_right_concept_pink_cell_on_left': 0.118, 'concept_box_on_right_concept_pink_cell_on_left': 0.0, 'NOT_concept_wall_on_left_of_box_concept_pink_cell_on_left': 0.094, 'NOT_concept_wall_up_down_right_concept_pink_cell_on_left': 0.116, 'concept_no_wall_on_left_m_concept_pink_cell_on_left': 0.114, 'concept_pink_cell_on_left_concept_wall_down_right': 0.0, 'NOT_concept_pink_cell_on_left_concept_pink_cell_on_left': 0.0, 'NOT_concept_wall_below_box_concept_pink_cell_on_left': 0.102, 'NOT_concept_wall_on_top_concept_pink_cell_on_left': 0.114, 'NOT_concept_no_wall_on_right_m_concept_pink_cell_on_left': 0.124, 'NOT_concept_on_pink_cell_concept_pink_cell_on_left': 0.108, 'NOT_concept_box_on_right_concept_pink_cell_on_left': 0.122, 'concept_pink_cell_on_left_concept_wall_top_left': 0.0, 'concept_pink_cell_on_left_concept_target_on_right': 0.0, 'NOT_concept_blank_cell_below_concept_pink_cell_on_left': 0.0, 'concept_no_wall_on_right_m_concept_pink_cell_on_left': 0.0, 'concept_pink_cell_on_left_concept_wall_below': 0.0, 'NOT_concept_no_wall_on_left_m_concept_pink_cell_on_left': 0.0, 'NOT_concept_wall_top_left_concept_pink_cell_on_left': 0.118, 'NOT_concept_box_below_concept_pink_cell_on_left': 0.12, 'NOT_concept_wall_above_box_concept_pink_cell_on_left': 0.098, 'concept_pink_cell_on_left_concept_pink_cell_on_top': 0.0, 'NOT_concept_no_pink_cell_on_top_m_concept_pink_cell_on_left': 0.0, 'NOT_concept_wall_on_right_of_box_concept_pink_cell_on_left': 0.092, 'NOT_concept_no_wall_on_top_m_concept_pink_cell_on_left': 0.0, 'concept_on_pink_cell_concept_pink_cell_on_left': 0.012, 'concept_pink_cell_on_left_concept_target_on_top': 0.0, 'concept_pink_cell_on_left_concept_wall_down_left': 0.0, 'concept_pink_cell_on_left_concept_wall_on_left': 0.0, 'NOT_concept_no_pink_cell_below_m_concept_pink_cell_on_left': 0.0, 'concept_pink_cell_on_left_concept_wall_up_down_right': 0.0, 'concept_pink_cell_on_left_concept_wall_on_top': 0.0, 'concept_pink_cell_on_left_concept_wall_above_box': 0.016, 'concept_pink_cell_on_left_concept_wall_on_right_of_box': 0.018, 'concept_box_on_left_concept_pink_cell_on_left': 0.0, 'concept_no_wall_on_top_m_concept_pink_cell_on_left': 0.122, 'NOT_concept_pink_cell_on_top_concept_pink_cell_on_left': 0.114, 'concept_no_pink_cell_on_top_m_concept_pink_cell_on_left': 0.132, 'NOT_concept_no_wall_below_m_concept_pink_cell_on_left': 0.0, 'concept_pink_cell_on_left_concept_wall_below_box': 0.018, 'concept_pink_cell_on_left_concept_wall_on_right': 0.086, 'concept_pink_cell_below_concept_pink_cell_on_left': 0.0, 'NOT_concept_blank_cell_on_left_concept_pink_cell_on_left': 0.112, 'NOT_concept_target_on_right_concept_pink_cell_on_left': 0.114, 'concept_no_pink_cell_below_m_concept_pink_cell_on_left': 0.128, 'NOT_concept_target_on_top_concept_pink_cell_on_left': 0.118, 'NOT_concept_wall_top_right_concept_pink_cell_on_left': 0.112, 'concept_box_on_top_concept_pink_cell_on_left': 0.0, 'concept_no_wall_below_m_concept_pink_cell_on_left': 0.12, 'NOT_concept_wall_on_left_concept_pink_cell_on_left': 0.102, 'concept_pink_cell_on_left_concept_wall_on_left_of_box': 0.028, 'NOT_concept_box_on_top_concept_pink_cell_on_left': 0.124, 'concept_blank_cell_on_left_concept_pink_cell_on_left': 0.0, 'NOT_concept_wall_on_right_concept_pink_cell_on_left': 0.044, 'NOT_concept_pink_cell_on_right_concept_pink_cell_on_left': 0.106, 'NOT_concept_box_on_left_concept_pink_cell_on_left': 0.132, 'NOT_concept_wall_down_left_concept_pink_cell_on_left': 0.126, 'NOT_concept_pink_cell_below_concept_pink_cell_on_left': 0.12, 'NOT_concept_wall_below_concept_pink_cell_on_left': 0.116, 'concept_box_below_concept_wall_top_right': 0.0, 'NOT_concept_wall_down_right_concept_wall_top_right': 0.0, 'concept_box_on_right_concept_wall_top_right': 0.0, 'NOT_concept_wall_on_left_of_box_concept_wall_top_right': 0.0, 'NOT_concept_wall_up_down_right_concept_wall_top_right': 0.0, 'concept_no_wall_on_left_m_concept_wall_top_right': 0.0, 'concept_wall_down_right_concept_wall_top_right': 0.0, 'NOT_concept_pink_cell_on_left_concept_wall_top_right': 0.0, 'NOT_concept_wall_below_box_concept_wall_top_right': 0.0, 'NOT_concept_wall_on_top_concept_wall_top_right': 0.0, 'NOT_concept_no_wall_on_right_m_concept_wall_top_right': 0.0, 'NOT_concept_on_pink_cell_concept_wall_top_right': 0.0, 'NOT_concept_box_on_right_concept_wall_top_right': 0.0, 'concept_wall_top_left_concept_wall_top_right': 0.0, 'concept_target_on_right_concept_wall_top_right': 0.0, 'NOT_concept_blank_cell_below_concept_wall_top_right': 0.0, 'concept_no_wall_on_right_m_concept_wall_top_right': 0.0, 'concept_wall_below_concept_wall_top_right': 0.0, 'NOT_concept_no_wall_on_left_m_concept_wall_top_right': 0.0, 'NOT_concept_wall_top_left_concept_wall_top_right': 0.0, 'NOT_concept_box_below_concept_wall_top_right': 0.0, 'NOT_concept_wall_above_box_concept_wall_top_right': 0.0, 'concept_pink_cell_on_top_concept_wall_top_right': 0.0, 'NOT_concept_no_pink_cell_on_top_m_concept_wall_top_right': 0.0, 'NOT_concept_wall_on_right_of_box_concept_wall_top_right': 0.0, 'NOT_concept_no_wall_on_top_m_concept_wall_top_right': 0.0, 'concept_on_pink_cell_concept_wall_top_right': 0.0, 'concept_target_on_top_concept_wall_top_right': 0.0, 'concept_wall_down_left_concept_wall_top_right': 0.0, 'concept_wall_on_left_concept_wall_top_right': 0.0, 'NOT_concept_no_pink_cell_below_m_concept_wall_top_right': 0.0, 'concept_wall_top_right_concept_wall_up_down_right': 0.0, 'concept_wall_on_top_concept_wall_top_right': 0.0, 'concept_wall_above_box_concept_wall_top_right': 0.0, 'concept_wall_on_right_of_box_concept_wall_top_right': 0.0, 'concept_box_on_left_concept_wall_top_right': 0.0, 'concept_no_wall_on_top_m_concept_wall_top_right': 0.0, 'NOT_concept_pink_cell_on_top_concept_wall_top_right': 0.0, 'concept_no_pink_cell_on_top_m_concept_wall_top_right': 0.0, 'NOT_concept_no_wall_below_m_concept_wall_top_right': 0.0, 'concept_wall_below_box_concept_wall_top_right': 0.0, 'concept_wall_on_right_concept_wall_top_right': 0.0, 'concept_pink_cell_below_concept_wall_top_right': 0.0, 'NOT_concept_blank_cell_on_left_concept_wall_top_right': 0.0, 'NOT_concept_target_on_right_concept_wall_top_right': 0.0, 'concept_no_pink_cell_below_m_concept_wall_top_right': 0.0, 'NOT_concept_target_on_top_concept_wall_top_right': 0.0, 'NOT_concept_wall_top_right_concept_wall_top_right': 0.0, 'concept_box_on_top_concept_wall_top_right': 0.0, 'concept_no_wall_below_m_concept_wall_top_right': 0.0, 'NOT_concept_wall_on_left_concept_wall_top_right': 0.0, 'concept_wall_on_left_of_box_concept_wall_top_right': 0.0, 'NOT_concept_box_on_top_concept_wall_top_right': 0.0, 'concept_blank_cell_on_left_concept_wall_top_right': 0.0, 'NOT_concept_wall_on_right_concept_wall_top_right': 0.0, 'NOT_concept_pink_cell_on_right_concept_wall_top_right': 0.0, 'NOT_concept_box_on_left_concept_wall_top_right': 0.0, 'NOT_concept_wall_down_left_concept_wall_top_right': 0.0, 'NOT_concept_pink_cell_below_concept_wall_top_right': 0.0, 'NOT_concept_wall_below_concept_wall_top_right': 0.0, 'NOT_concept_wall_down_right_concept_box_below': 0.0, 'concept_box_below_concept_box_on_right': 0.0, 'NOT_concept_wall_on_left_of_box_concept_box_below': 0.0, 'NOT_concept_wall_up_down_right_concept_box_below': 0.0, 'concept_box_below_concept_no_wall_on_left_m': 0.0, 'concept_box_below_concept_wall_down_right': 0.0, 'NOT_concept_pink_cell_on_left_concept_box_below': 0.0, 'NOT_concept_wall_below_box_concept_box_below': 0.0, 'NOT_concept_wall_on_top_concept_box_below': 0.0, 'NOT_concept_no_wall_on_right_m_concept_box_below': 0.0, 'NOT_concept_on_pink_cell_concept_box_below': 0.0, 'NOT_concept_box_on_right_concept_box_below': 0.0, 'concept_box_below_concept_wall_top_left': 0.0, 'concept_box_below_concept_target_on_right': 0.0, 'NOT_concept_blank_cell_below_concept_box_below': 0.0, 'concept_box_below_concept_no_wall_on_right_m': 0.0, 'concept_box_below_concept_wall_below': 0.0, 'NOT_concept_no_wall_on_left_m_concept_box_below': 0.0, 'NOT_concept_wall_top_left_concept_box_below': 0.0, 'NOT_concept_box_below_concept_box_below': 0.0, 'NOT_concept_wall_above_box_concept_box_below': 0.0, 'concept_box_below_concept_pink_cell_on_top': 0.0, 'NOT_concept_no_pink_cell_on_top_m_concept_box_below': 0.0, 'NOT_concept_wall_on_right_of_box_concept_box_below': 0.0, 'NOT_concept_no_wall_on_top_m_concept_box_below': 0.0, 'concept_box_below_concept_on_pink_cell': 0.0, 'concept_box_below_concept_target_on_top': 0.0, 'concept_box_below_concept_wall_down_left': 0.0, 'concept_box_below_concept_wall_on_left': 0.0, 'NOT_concept_no_pink_cell_below_m_concept_box_below': 0.0, 'concept_box_below_concept_wall_up_down_right': 0.0, 'concept_box_below_concept_wall_on_top': 0.0, 'concept_box_below_concept_wall_above_box': 0.0, 'concept_box_below_concept_wall_on_right_of_box': 0.0, 'concept_box_below_concept_box_on_left': 0.0, 'concept_box_below_concept_no_wall_on_top_m': 0.0, 'NOT_concept_pink_cell_on_top_concept_box_below': 0.0, 'concept_box_below_concept_no_pink_cell_on_top_m': 0.0, 'NOT_concept_no_wall_below_m_concept_box_below': 0.0, 'concept_box_below_concept_wall_below_box': 0.0, 'concept_box_below_concept_wall_on_right': 0.0, 'concept_box_below_concept_pink_cell_below': 0.0, 'NOT_concept_blank_cell_on_left_concept_box_below': 0.0, 'NOT_concept_target_on_right_concept_box_below': 0.0, 'concept_box_below_concept_no_pink_cell_below_m': 0.0, 'NOT_concept_target_on_top_concept_box_below': 0.0, 'NOT_concept_wall_top_right_concept_box_below': 0.0, 'concept_box_below_concept_box_on_top': 0.0, 'concept_box_below_concept_no_wall_below_m': 0.0, 'NOT_concept_wall_on_left_concept_box_below': 0.0, 'concept_box_below_concept_wall_on_left_of_box': 0.0, 'NOT_concept_box_on_top_concept_box_below': 0.0, 'concept_blank_cell_on_left_concept_box_below': 0.0, 'NOT_concept_wall_on_right_concept_box_below': 0.0, 'NOT_concept_pink_cell_on_right_concept_box_below': 0.0, 'NOT_concept_box_on_left_concept_box_below': 0.0, 'NOT_concept_wall_down_left_concept_box_below': 0.0, 'NOT_concept_pink_cell_below_concept_box_below': 0.0, 'NOT_concept_wall_below_concept_box_below': 0.0, 'NOT_concept_wall_down_right_concept_box_on_right': 0.0, 'NOT_concept_wall_down_right_NOT_concept_wall_on_left_of_box': 0.718, 'NOT_concept_wall_down_right_NOT_concept_wall_up_down_right': 0.926, 'NOT_concept_wall_down_right_concept_no_wall_on_left_m': 0.318, 'NOT_concept_wall_down_right_concept_wall_down_right': 0.0, 'NOT_concept_pink_cell_on_left_NOT_concept_wall_down_right': 0.788, 'NOT_concept_wall_below_box_NOT_concept_wall_down_right': 0.792, 'NOT_concept_wall_down_right_NOT_concept_wall_on_top': 0.92, 'NOT_concept_no_wall_on_right_m_NOT_concept_wall_down_right': 0.414, 'NOT_concept_on_pink_cell_NOT_concept_wall_down_right': 0.808, 'NOT_concept_box_on_right_NOT_concept_wall_down_right': 0.922, 'NOT_concept_wall_down_right_concept_wall_top_left': 0.0, 'NOT_concept_wall_down_right_concept_target_on_right': 0.0, 'NOT_concept_blank_cell_below_NOT_concept_wall_down_right': 0.258, 'NOT_concept_wall_down_right_concept_no_wall_on_right_m': 0.494, 'NOT_concept_wall_down_right_concept_wall_below': 0.148, 'NOT_concept_no_wall_on_left_m_NOT_concept_wall_down_right': 0.608, 'NOT_concept_wall_down_right_NOT_concept_wall_top_left': 0.91, 'NOT_concept_box_below_NOT_concept_wall_down_right': 0.918, 'NOT_concept_wall_above_box_NOT_concept_wall_down_right': 0.796, 'NOT_concept_wall_down_right_concept_pink_cell_on_top': 0.118, 'NOT_concept_no_pink_cell_on_top_m_NOT_concept_wall_down_right': 0.16, 'NOT_concept_wall_down_right_NOT_concept_wall_on_right_of_box': 0.742, 'NOT_concept_no_wall_on_top_m_NOT_concept_wall_down_right': 0.198, 'NOT_concept_wall_down_right_concept_on_pink_cell': 0.106, 'NOT_concept_wall_down_right_concept_target_on_top': 0.032, 'NOT_concept_wall_down_right_concept_wall_down_left': 0.06, 'NOT_concept_wall_down_right_concept_wall_on_left': 0.306, 'NOT_concept_no_pink_cell_below_m_NOT_concept_wall_down_right': 0.234, 'NOT_concept_wall_down_right_concept_wall_up_down_right': 0.0, 'NOT_concept_wall_down_right_concept_wall_on_top': 0.0, 'NOT_concept_wall_down_right_concept_wall_above_box': 0.116, 'NOT_concept_wall_down_right_concept_wall_on_right_of_box': 0.164, 'NOT_concept_wall_down_right_concept_box_on_left': 0.0, 'NOT_concept_wall_down_right_concept_no_wall_on_top_m': 0.706, 'NOT_concept_pink_cell_on_top_NOT_concept_wall_down_right': 0.794, 'NOT_concept_wall_down_right_concept_no_pink_cell_on_top_m': 0.752, 'NOT_concept_no_wall_below_m_NOT_concept_wall_down_right': 0.314, 'NOT_concept_wall_down_right_concept_wall_below_box': 0.132, 'NOT_concept_wall_down_right_concept_wall_on_right': 0.164, 'NOT_concept_wall_down_right_concept_pink_cell_below': 0.112, 'NOT_concept_blank_cell_on_left_NOT_concept_wall_down_right': 0.448, 'NOT_concept_target_on_right_NOT_concept_wall_down_right': 0.902, 'NOT_concept_wall_down_right_concept_no_pink_cell_below_m': 0.682, 'NOT_concept_target_on_top_NOT_concept_wall_down_right': 0.882, 'NOT_concept_wall_down_right_NOT_concept_wall_top_right': 0.912, 'NOT_concept_wall_down_right_concept_box_on_top': 0.0, 'NOT_concept_wall_down_right_concept_no_wall_below_m': 0.616, 'NOT_concept_wall_down_right_NOT_concept_wall_on_left': 0.618, 'NOT_concept_wall_down_right_concept_wall_on_left_of_box': 0.194, 'NOT_concept_box_on_top_NOT_concept_wall_down_right': 0.904, 'NOT_concept_wall_down_right_concept_blank_cell_on_left': 0.49, 'NOT_concept_wall_down_right_NOT_concept_wall_on_right': 0.732, 'NOT_concept_pink_cell_on_right_NOT_concept_wall_down_right': 0.794, 'NOT_concept_box_on_left_NOT_concept_wall_down_right': 0.926, 'NOT_concept_wall_down_left_NOT_concept_wall_down_right': 0.842, 'NOT_concept_pink_cell_below_NOT_concept_wall_down_right': 0.796, 'NOT_concept_wall_below_NOT_concept_wall_down_right': 0.78, 'NOT_concept_wall_on_left_of_box_concept_box_on_right': 0.0, 'NOT_concept_wall_up_down_right_concept_box_on_right': 0.0, 'concept_box_on_right_concept_no_wall_on_left_m': 0.0, 'concept_box_on_right_concept_wall_down_right': 0.0, 'NOT_concept_pink_cell_on_left_concept_box_on_right': 0.0, 'NOT_concept_wall_below_box_concept_box_on_right': 0.0, 'NOT_concept_wall_on_top_concept_box_on_right': 0.0, 'NOT_concept_no_wall_on_right_m_concept_box_on_right': 0.0, 'NOT_concept_on_pink_cell_concept_box_on_right': 0.0, 'NOT_concept_box_on_right_concept_box_on_right': 0.0, 'concept_box_on_right_concept_wall_top_left': 0.0, 'concept_box_on_right_concept_target_on_right': 0.0, 'NOT_concept_blank_cell_below_concept_box_on_right': 0.0, 'concept_box_on_right_concept_no_wall_on_right_m': 0.0, 'concept_box_on_right_concept_wall_below': 0.0, 'NOT_concept_no_wall_on_left_m_concept_box_on_right': 0.0, 'NOT_concept_wall_top_left_concept_box_on_right': 0.0, 'NOT_concept_box_below_concept_box_on_right': 0.0, 'NOT_concept_wall_above_box_concept_box_on_right': 0.0, 'concept_box_on_right_concept_pink_cell_on_top': 0.0, 'NOT_concept_no_pink_cell_on_top_m_concept_box_on_right': 0.0, 'NOT_concept_wall_on_right_of_box_concept_box_on_right': 0.0, 'NOT_concept_no_wall_on_top_m_concept_box_on_right': 0.0, 'concept_box_on_right_concept_on_pink_cell': 0.0, 'concept_box_on_right_concept_target_on_top': 0.0, 'concept_box_on_right_concept_wall_down_left': 0.0, 'concept_box_on_right_concept_wall_on_left': 0.0, 'NOT_concept_no_pink_cell_below_m_concept_box_on_right': 0.0, 'concept_box_on_right_concept_wall_up_down_right': 0.0, 'concept_box_on_right_concept_wall_on_top': 0.0, 'concept_box_on_right_concept_wall_above_box': 0.0, 'concept_box_on_right_concept_wall_on_right_of_box': 0.0, 'concept_box_on_left_concept_box_on_right': 0.0, 'concept_box_on_right_concept_no_wall_on_top_m': 0.0, 'NOT_concept_pink_cell_on_top_concept_box_on_right': 0.0, 'concept_box_on_right_concept_no_pink_cell_on_top_m': 0.0, 'NOT_concept_no_wall_below_m_concept_box_on_right': 0.0, 'concept_box_on_right_concept_wall_below_box': 0.0, 'concept_box_on_right_concept_wall_on_right': 0.0, 'concept_box_on_right_concept_pink_cell_below': 0.0, 'NOT_concept_blank_cell_on_left_concept_box_on_right': 0.0, 'NOT_concept_target_on_right_concept_box_on_right': 0.0, 'concept_box_on_right_concept_no_pink_cell_below_m': 0.0, 'NOT_concept_target_on_top_concept_box_on_right': 0.0, 'NOT_concept_wall_top_right_concept_box_on_right': 0.0, 'concept_box_on_right_concept_box_on_top': 0.0, 'concept_box_on_right_concept_no_wall_below_m': 0.0, 'NOT_concept_wall_on_left_concept_box_on_right': 0.0, 'concept_box_on_right_concept_wall_on_left_of_box': 0.0, 'NOT_concept_box_on_top_concept_box_on_right': 0.0, 'concept_blank_cell_on_left_concept_box_on_right': 0.0, 'NOT_concept_wall_on_right_concept_box_on_right': 0.0, 'NOT_concept_pink_cell_on_right_concept_box_on_right': 0.0, 'NOT_concept_box_on_left_concept_box_on_right': 0.0, 'NOT_concept_wall_down_left_concept_box_on_right': 0.0, 'NOT_concept_pink_cell_below_concept_box_on_right': 0.0, 'NOT_concept_wall_below_concept_box_on_right': 0.0, 'NOT_concept_wall_on_left_of_box_NOT_concept_wall_up_down_right': 0.792, 'NOT_concept_wall_on_left_of_box_concept_no_wall_on_left_m': 0.296, 'NOT_concept_wall_on_left_of_box_concept_wall_down_right': 0.068, 'NOT_concept_pink_cell_on_left_NOT_concept_wall_on_left_of_box': 0.694, 'NOT_concept_wall_below_box_NOT_concept_wall_on_left_of_box': 0.668, 'NOT_concept_wall_on_left_of_box_NOT_concept_wall_on_top': 0.792, 'NOT_concept_no_wall_on_right_m_NOT_concept_wall_on_left_of_box': 0.38, 'NOT_concept_on_pink_cell_NOT_concept_wall_on_left_of_box': 0.696, 'NOT_concept_box_on_right_NOT_concept_wall_on_left_of_box': 0.792, 'NOT_concept_wall_on_left_of_box_concept_wall_top_left': 0.0, 'NOT_concept_wall_on_left_of_box_concept_target_on_right': 0.0, 'NOT_concept_blank_cell_below_NOT_concept_wall_on_left_of_box': 0.268, 'NOT_concept_wall_on_left_of_box_concept_no_wall_on_right_m': 0.404, 'NOT_concept_wall_on_left_of_box_concept_wall_below': 0.166, 'NOT_concept_no_wall_on_left_m_NOT_concept_wall_on_left_of_box': 0.506, 'NOT_concept_wall_on_left_of_box_NOT_concept_wall_top_left': 0.794, 'NOT_concept_box_below_NOT_concept_wall_on_left_of_box': 0.774, 'NOT_concept_wall_above_box_NOT_concept_wall_on_left_of_box': 0.688, 'NOT_concept_wall_on_left_of_box_concept_pink_cell_on_top': 0.098, 'NOT_concept_no_pink_cell_on_top_m_NOT_concept_wall_on_left_of_box': 0.122, 'NOT_concept_wall_on_left_of_box_NOT_concept_wall_on_right_of_box': 0.596, 'NOT_concept_no_wall_on_top_m_NOT_concept_wall_on_left_of_box': 0.178, 'NOT_concept_wall_on_left_of_box_concept_on_pink_cell': 0.128, 'NOT_concept_wall_on_left_of_box_concept_target_on_top': 0.034, 'NOT_concept_wall_on_left_of_box_concept_wall_down_left': 0.058, 'NOT_concept_wall_on_left_of_box_concept_wall_on_left': 0.238, 'NOT_concept_no_pink_cell_below_m_NOT_concept_wall_on_left_of_box': 0.196, 'NOT_concept_wall_on_left_of_box_concept_wall_up_down_right': 0.0, 'NOT_concept_wall_on_left_of_box_concept_wall_on_top': 0.0, 'NOT_concept_wall_on_left_of_box_concept_wall_above_box': 0.11, 'NOT_concept_wall_on_left_of_box_concept_wall_on_right_of_box': 0.198, 'NOT_concept_wall_on_left_of_box_concept_box_on_left': 0.0, 'NOT_concept_wall_on_left_of_box_concept_no_wall_on_top_m': 0.598, 'NOT_concept_pink_cell_on_top_NOT_concept_wall_on_left_of_box': 0.696, 'NOT_concept_wall_on_left_of_box_concept_no_pink_cell_on_top_m': 0.664, 'NOT_concept_no_wall_below_m_NOT_concept_wall_on_left_of_box': 0.3, 'NOT_concept_wall_on_left_of_box_concept_wall_below_box': 0.102, 'NOT_concept_wall_on_left_of_box_concept_wall_on_right': 0.2, 'NOT_concept_wall_on_left_of_box_concept_pink_cell_below': 0.096, 'NOT_concept_blank_cell_on_left_NOT_concept_wall_on_left_of_box': 0.356, 'NOT_concept_target_on_right_NOT_concept_wall_on_left_of_box': 0.798, 'NOT_concept_wall_on_left_of_box_concept_no_pink_cell_below_m': 0.608, 'NOT_concept_target_on_top_NOT_concept_wall_on_left_of_box': 0.77, 'NOT_concept_wall_on_left_of_box_NOT_concept_wall_top_right': 0.796, 'NOT_concept_wall_on_left_of_box_concept_box_on_top': 0.0, 'NOT_concept_wall_on_left_of_box_concept_no_wall_below_m': 0.478, 'NOT_concept_wall_on_left_NOT_concept_wall_on_left_of_box': 0.536, 'NOT_concept_wall_on_left_of_box_concept_wall_on_left_of_box': 0.0, 'NOT_concept_box_on_top_NOT_concept_wall_on_left_of_box': 0.792, 'NOT_concept_wall_on_left_of_box_concept_blank_cell_on_left': 0.452, 'NOT_concept_wall_on_left_of_box_NOT_concept_wall_on_right': 0.578, 'NOT_concept_pink_cell_on_right_NOT_concept_wall_on_left_of_box': 0.68, 'NOT_concept_box_on_left_NOT_concept_wall_on_left_of_box': 0.81, 'NOT_concept_wall_down_left_NOT_concept_wall_on_left_of_box': 0.736, 'NOT_concept_pink_cell_below_NOT_concept_wall_on_left_of_box': 0.694, 'NOT_concept_wall_below_NOT_concept_wall_on_left_of_box': 0.624, 'NOT_concept_wall_up_down_right_concept_no_wall_on_left_m': 0.366, 'NOT_concept_wall_up_down_right_concept_wall_down_right': 0.094, 'NOT_concept_pink_cell_on_left_NOT_concept_wall_up_down_right': 0.894, 'NOT_concept_wall_below_box_NOT_concept_wall_up_down_right': 0.862, 'NOT_concept_wall_on_top_NOT_concept_wall_up_down_right': 1.0, 'NOT_concept_no_wall_on_right_m_NOT_concept_wall_up_down_right': 0.49, 'NOT_concept_on_pink_cell_NOT_concept_wall_up_down_right': 0.892, 'NOT_concept_box_on_right_NOT_concept_wall_up_down_right': 1.0, 'NOT_concept_wall_up_down_right_concept_wall_top_left': 0.0, 'NOT_concept_wall_up_down_right_concept_target_on_right': 0.0, 'NOT_concept_blank_cell_below_NOT_concept_wall_up_down_right': 0.344, 'NOT_concept_wall_up_down_right_concept_no_wall_on_right_m': 0.492, 'NOT_concept_wall_up_down_right_concept_wall_below': 0.238, 'NOT_concept_no_wall_on_left_m_NOT_concept_wall_up_down_right': 0.626, 'NOT_concept_wall_top_left_NOT_concept_wall_up_down_right': 1.0, 'NOT_concept_box_below_NOT_concept_wall_up_down_right': 1.0, 'NOT_concept_wall_above_box_NOT_concept_wall_up_down_right': 0.874, 'NOT_concept_wall_up_down_right_concept_pink_cell_on_top': 0.126, 'NOT_concept_no_pink_cell_on_top_m_NOT_concept_wall_up_down_right': 0.158, 'NOT_concept_wall_on_right_of_box_NOT_concept_wall_up_down_right': 0.814, 'NOT_concept_no_wall_on_top_m_NOT_concept_wall_up_down_right': 0.23, 'NOT_concept_wall_up_down_right_concept_on_pink_cell': 0.124, 'NOT_concept_wall_up_down_right_concept_target_on_top': 0.038, 'NOT_concept_wall_up_down_right_concept_wall_down_left': 0.074, 'NOT_concept_wall_up_down_right_concept_wall_on_left': 0.298, 'NOT_concept_no_pink_cell_below_m_NOT_concept_wall_up_down_right': 0.244, 'NOT_concept_wall_up_down_right_concept_wall_up_down_right': 0.0, 'NOT_concept_wall_up_down_right_concept_wall_on_top': 0.0, 'NOT_concept_wall_up_down_right_concept_wall_above_box': 0.126, 'NOT_concept_wall_up_down_right_concept_wall_on_right_of_box': 0.188, 'NOT_concept_wall_up_down_right_concept_box_on_left': 0.0, 'NOT_concept_wall_up_down_right_concept_no_wall_on_top_m': 0.784, 'NOT_concept_pink_cell_on_top_NOT_concept_wall_up_down_right': 0.904, 'NOT_concept_wall_up_down_right_concept_no_pink_cell_on_top_m': 0.854, 'NOT_concept_no_wall_below_m_NOT_concept_wall_up_down_right': 0.402, 'NOT_concept_wall_up_down_right_concept_wall_below_box': 0.132, 'NOT_concept_wall_up_down_right_concept_wall_on_right': 0.262, 'NOT_concept_wall_up_down_right_concept_pink_cell_below': 0.118, 'NOT_concept_blank_cell_on_left_NOT_concept_wall_up_down_right': 0.436, 'NOT_concept_target_on_right_NOT_concept_wall_up_down_right': 1.0, 'NOT_concept_wall_up_down_right_concept_no_pink_cell_below_m': 0.75, 'NOT_concept_target_on_top_NOT_concept_wall_up_down_right': 0.954, 'NOT_concept_wall_top_right_NOT_concept_wall_up_down_right': 1.0, 'NOT_concept_wall_up_down_right_concept_box_on_top': 0.0, 'NOT_concept_wall_up_down_right_concept_no_wall_below_m': 0.618, 'NOT_concept_wall_on_left_NOT_concept_wall_up_down_right': 0.702, 'NOT_concept_wall_up_down_right_concept_wall_on_left_of_box': 0.22, 'NOT_concept_box_on_top_NOT_concept_wall_up_down_right': 1.0, 'NOT_concept_wall_up_down_right_concept_blank_cell_on_left': 0.57, 'NOT_concept_wall_on_right_NOT_concept_wall_up_down_right': 0.724, 'NOT_concept_pink_cell_on_right_NOT_concept_wall_up_down_right': 0.898, 'NOT_concept_box_on_left_NOT_concept_wall_up_down_right': 1.0, 'NOT_concept_wall_down_left_NOT_concept_wall_up_down_right': 0.938, 'NOT_concept_pink_cell_below_NOT_concept_wall_up_down_right': 0.892, 'NOT_concept_wall_below_NOT_concept_wall_up_down_right': 0.77, 'concept_no_wall_on_left_m_concept_wall_down_right': 0.064, 'NOT_concept_pink_cell_on_left_concept_no_wall_on_left_m': 0.25, 'NOT_concept_wall_below_box_concept_no_wall_on_left_m': 0.322, 'NOT_concept_wall_on_top_concept_no_wall_on_left_m': 0.378, 'NOT_concept_no_wall_on_right_m_concept_no_wall_on_left_m': 0.256, 'NOT_concept_on_pink_cell_concept_no_wall_on_left_m': 0.332, 'NOT_concept_box_on_right_concept_no_wall_on_left_m': 0.374, 'concept_no_wall_on_left_m_concept_wall_top_left': 0.0, 'concept_no_wall_on_left_m_concept_target_on_right': 0.0, 'NOT_concept_blank_cell_below_concept_no_wall_on_left_m': 0.136, 'concept_no_wall_on_left_m_concept_no_wall_on_right_m': 0.108, 'concept_no_wall_on_left_m_concept_wall_below': 0.1, 'NOT_concept_no_wall_on_left_m_concept_no_wall_on_left_m': 0.0, 'NOT_concept_wall_top_left_concept_no_wall_on_left_m': 0.396, 'NOT_concept_box_below_concept_no_wall_on_left_m': 0.38, 'NOT_concept_wall_above_box_concept_no_wall_on_left_m': 0.324, 'concept_no_wall_on_left_m_concept_pink_cell_on_top': 0.0, 'NOT_concept_no_pink_cell_on_top_m_concept_no_wall_on_left_m': 0.0, 'NOT_concept_wall_on_right_of_box_concept_no_wall_on_left_m': 0.32, 'NOT_concept_no_wall_on_top_m_concept_no_wall_on_left_m': 0.11, 'concept_no_wall_on_left_m_concept_on_pink_cell': 0.05, 'concept_no_wall_on_left_m_concept_target_on_top': 0.038, 'concept_no_wall_on_left_m_concept_wall_down_left': 0.0, 'concept_no_wall_on_left_m_concept_wall_on_left': 0.0, 'NOT_concept_no_pink_cell_below_m_concept_no_wall_on_left_m': 0.096, 'concept_no_wall_on_left_m_concept_wall_up_down_right': 0.0, 'concept_no_wall_on_left_m_concept_wall_on_top': 0.0, 'concept_no_wall_on_left_m_concept_wall_above_box': 0.046, 'concept_no_wall_on_left_m_concept_wall_on_right_of_box': 0.06, 'concept_box_on_left_concept_no_wall_on_left_m': 0.0, 'concept_no_wall_on_left_m_concept_no_wall_on_top_m': 0.264, 'NOT_concept_pink_cell_on_top_concept_no_wall_on_left_m': 0.378, 'concept_no_pink_cell_on_top_m_concept_no_wall_on_left_m': 0.36, 'NOT_concept_no_wall_below_m_concept_no_wall_on_left_m': 0.14, 'concept_no_wall_on_left_m_concept_wall_below_box': 0.05, 'concept_no_wall_on_left_m_concept_wall_on_right': 0.232, 'concept_no_wall_on_left_m_concept_pink_cell_below': 0.04, 'NOT_concept_blank_cell_on_left_concept_no_wall_on_left_m': 0.13, 'NOT_concept_target_on_right_concept_no_wall_on_left_m': 0.376, 'concept_no_pink_cell_below_m_concept_no_wall_on_left_m': 0.282, 'NOT_concept_target_on_top_concept_no_wall_on_left_m': 0.338, 'NOT_concept_wall_top_right_concept_no_wall_on_left_m': 0.388, 'concept_box_on_top_concept_no_wall_on_left_m': 0.0, 'concept_no_wall_below_m_concept_no_wall_on_left_m': 0.244, 'NOT_concept_wall_on_left_concept_no_wall_on_left_m': 0.376, 'concept_no_wall_on_left_m_concept_wall_on_left_of_box': 0.096, 'NOT_concept_box_on_top_concept_no_wall_on_left_m': 0.386, 'concept_blank_cell_on_left_concept_no_wall_on_left_m': 0.24, 'NOT_concept_wall_on_right_concept_no_wall_on_left_m': 0.154, 'NOT_concept_pink_cell_on_right_concept_no_wall_on_left_m': 0.366, 'NOT_concept_box_on_left_concept_no_wall_on_left_m': 0.38, 'NOT_concept_wall_down_left_concept_no_wall_on_left_m': 0.384, 'NOT_concept_pink_cell_below_concept_no_wall_on_left_m': 0.338, 'NOT_concept_wall_below_concept_no_wall_on_left_m': 0.29, 'NOT_concept_pink_cell_on_left_concept_wall_down_right': 0.082, 'NOT_concept_wall_below_box_concept_wall_down_right': 0.084, 'NOT_concept_wall_on_top_concept_wall_down_right': 0.078, 'NOT_concept_no_wall_on_right_m_concept_wall_down_right': 0.088, 'NOT_concept_on_pink_cell_concept_wall_down_right': 0.074, 'NOT_concept_box_on_right_concept_wall_down_right': 0.094, 'concept_wall_down_right_concept_wall_top_left': 0.0, 'concept_target_on_right_concept_wall_down_right': 0.0, 'NOT_concept_blank_cell_below_concept_wall_down_right': 0.092, 'concept_no_wall_on_right_m_concept_wall_down_right': 0.0, 'concept_wall_below_concept_wall_down_right': 0.092, 'NOT_concept_no_wall_on_left_m_concept_wall_down_right': 0.024, 'NOT_concept_wall_top_left_concept_wall_down_right': 0.092, 'NOT_concept_box_below_concept_wall_down_right': 0.088, 'NOT_concept_wall_above_box_concept_wall_down_right': 0.072, 'concept_pink_cell_on_top_concept_wall_down_right': 0.0, 'NOT_concept_no_pink_cell_on_top_m_concept_wall_down_right': 0.0, 'NOT_concept_wall_on_right_of_box_concept_wall_down_right': 0.062, 'NOT_concept_no_wall_on_top_m_concept_wall_down_right': 0.03, 'concept_on_pink_cell_concept_wall_down_right': 0.014, 'concept_target_on_top_concept_wall_down_right': 0.0, 'concept_wall_down_left_concept_wall_down_right': 0.0, 'concept_wall_down_right_concept_wall_on_left': 0.0, 'NOT_concept_no_pink_cell_below_m_concept_wall_down_right': 0.028, 'concept_wall_down_right_concept_wall_up_down_right': 0.0, 'concept_wall_down_right_concept_wall_on_top': 0.0, 'concept_wall_above_box_concept_wall_down_right': 0.01, 'concept_wall_down_right_concept_wall_on_right_of_box': 0.024, 'concept_box_on_left_concept_wall_down_right': 0.0, 'concept_no_wall_on_top_m_concept_wall_down_right': 0.038, 'NOT_concept_pink_cell_on_top_concept_wall_down_right': 0.082, 'concept_no_pink_cell_on_top_m_concept_wall_down_right': 0.088, 'NOT_concept_no_wall_below_m_concept_wall_down_right': 0.08, 'concept_wall_below_box_concept_wall_down_right': 0.004, 'concept_wall_down_right_concept_wall_on_right': 0.09, 'concept_pink_cell_below_concept_wall_down_right': 0.0, 'NOT_concept_blank_cell_on_left_concept_wall_down_right': 0.0, 'NOT_concept_target_on_right_concept_wall_down_right': 0.08, 'concept_no_pink_cell_below_m_concept_wall_down_right': 0.062, 'NOT_concept_target_on_top_concept_wall_down_right': 0.08, 'NOT_concept_wall_top_right_concept_wall_down_right': 0.098, 'concept_box_on_top_concept_wall_down_right': 0.0, 'concept_no_wall_below_m_concept_wall_down_right': 0.0, 'NOT_concept_wall_on_left_concept_wall_down_right': 0.08, 'concept_wall_down_right_concept_wall_on_left_of_box': 0.014, 'NOT_concept_box_on_top_concept_wall_down_right': 0.09, 'concept_blank_cell_on_left_concept_wall_down_right': 0.08, 'NOT_concept_wall_on_right_concept_wall_down_right': 0.0, 'NOT_concept_pink_cell_on_right_concept_wall_down_right': 0.086, 'NOT_concept_box_on_left_concept_wall_down_right': 0.084, 'NOT_concept_wall_down_left_concept_wall_down_right': 0.09, 'NOT_concept_pink_cell_below_concept_wall_down_right': 0.084, 'NOT_concept_wall_below_concept_wall_down_right': 0.0, 'NOT_concept_pink_cell_on_left_NOT_concept_wall_below_box': 0.77, 'NOT_concept_pink_cell_on_left_NOT_concept_wall_on_top': 0.882, 'NOT_concept_no_wall_on_right_m_NOT_concept_pink_cell_on_left': 0.382, 'NOT_concept_on_pink_cell_NOT_concept_pink_cell_on_left': 0.78, 'NOT_concept_box_on_right_NOT_concept_pink_cell_on_left': 0.874, 'NOT_concept_pink_cell_on_left_concept_wall_top_left': 0.0, 'NOT_concept_pink_cell_on_left_concept_target_on_right': 0.0, 'NOT_concept_blank_cell_below_NOT_concept_pink_cell_on_left': 0.348, 'NOT_concept_pink_cell_on_left_concept_no_wall_on_right_m': 0.512, 'NOT_concept_pink_cell_on_left_concept_wall_below': 0.216, 'NOT_concept_no_wall_on_left_m_NOT_concept_pink_cell_on_left': 0.63, 'NOT_concept_pink_cell_on_left_NOT_concept_wall_top_left': 0.88, 'NOT_concept_box_below_NOT_concept_pink_cell_on_left': 0.886, 'NOT_concept_pink_cell_on_left_NOT_concept_wall_above_box': 0.762, 'NOT_concept_pink_cell_on_left_concept_pink_cell_on_top': 0.12, 'NOT_concept_no_pink_cell_on_top_m_NOT_concept_pink_cell_on_left': 0.166, 'NOT_concept_pink_cell_on_left_NOT_concept_wall_on_right_of_box': 0.69, 'NOT_concept_no_wall_on_top_m_NOT_concept_pink_cell_on_left': 0.232, 'NOT_concept_pink_cell_on_left_concept_on_pink_cell': 0.098, 'NOT_concept_pink_cell_on_left_concept_target_on_top': 0.042, 'NOT_concept_pink_cell_on_left_concept_wall_down_left': 0.068, 'NOT_concept_pink_cell_on_left_concept_wall_on_left': 0.316, 'NOT_concept_no_pink_cell_below_m_NOT_concept_pink_cell_on_left': 0.256, 'NOT_concept_pink_cell_on_left_concept_wall_up_down_right': 0.0, 'NOT_concept_pink_cell_on_left_concept_wall_on_top': 0.0, 'NOT_concept_pink_cell_on_left_concept_wall_above_box': 0.1, 'NOT_concept_pink_cell_on_left_concept_wall_on_right_of_box': 0.17, 'NOT_concept_pink_cell_on_left_concept_box_on_left': 0.0, 'NOT_concept_pink_cell_on_left_concept_no_wall_on_top_m': 0.66, 'NOT_concept_pink_cell_on_left_NOT_concept_pink_cell_on_top': 0.764, 'NOT_concept_pink_cell_on_left_concept_no_pink_cell_on_top_m': 0.73, 'NOT_concept_no_wall_below_m_NOT_concept_pink_cell_on_left': 0.392, 'NOT_concept_pink_cell_on_left_concept_wall_below_box': 0.118, 'NOT_concept_pink_cell_on_left_concept_wall_on_right': 0.178, 'NOT_concept_pink_cell_on_left_concept_pink_cell_below': 0.112, 'NOT_concept_blank_cell_on_left_NOT_concept_pink_cell_on_left': 0.326, 'NOT_concept_pink_cell_on_left_NOT_concept_target_on_right': 0.876, 'NOT_concept_pink_cell_on_left_concept_no_pink_cell_below_m': 0.624, 'NOT_concept_pink_cell_on_left_NOT_concept_target_on_top': 0.842, 'NOT_concept_pink_cell_on_left_NOT_concept_wall_top_right': 0.886, 'NOT_concept_pink_cell_on_left_concept_box_on_top': 0.0, 'NOT_concept_pink_cell_on_left_concept_no_wall_below_m': 0.494, 'NOT_concept_pink_cell_on_left_NOT_concept_wall_on_left': 0.566, 'NOT_concept_pink_cell_on_left_concept_wall_on_left_of_box': 0.186, 'NOT_concept_box_on_top_NOT_concept_pink_cell_on_left': 0.888, 'NOT_concept_pink_cell_on_left_concept_blank_cell_on_left': 0.564, 'NOT_concept_pink_cell_on_left_NOT_concept_wall_on_right': 0.686, 'NOT_concept_pink_cell_on_left_NOT_concept_pink_cell_on_right': 0.76, 'NOT_concept_box_on_left_NOT_concept_pink_cell_on_left': 0.886, 'NOT_concept_pink_cell_on_left_NOT_concept_wall_down_left': 0.83, 'NOT_concept_pink_cell_below_NOT_concept_pink_cell_on_left': 0.754, 'NOT_concept_pink_cell_on_left_NOT_concept_wall_below': 0.658, 'NOT_concept_wall_below_box_NOT_concept_wall_on_top': 0.87, 'NOT_concept_no_wall_on_right_m_NOT_concept_wall_below_box': 0.448, 'NOT_concept_on_pink_cell_NOT_concept_wall_below_box': 0.738, 'NOT_concept_box_on_right_NOT_concept_wall_below_box': 0.888, 'NOT_concept_wall_below_box_concept_wall_top_left': 0.0, 'NOT_concept_wall_below_box_concept_target_on_right': 0.0, 'NOT_concept_blank_cell_below_NOT_concept_wall_below_box': 0.298, 'NOT_concept_wall_below_box_concept_no_wall_on_right_m': 0.412, 'NOT_concept_wall_below_box_concept_wall_below': 0.212, 'NOT_concept_no_wall_on_left_m_NOT_concept_wall_below_box': 0.528, 'NOT_concept_wall_below_box_NOT_concept_wall_top_left': 0.86, 'NOT_concept_box_below_NOT_concept_wall_below_box': 0.862, 'NOT_concept_wall_above_box_NOT_concept_wall_below_box': 0.764, 'NOT_concept_wall_below_box_concept_pink_cell_on_top': 0.116, 'NOT_concept_no_pink_cell_on_top_m_NOT_concept_wall_below_box': 0.138, 'NOT_concept_wall_below_box_NOT_concept_wall_on_right_of_box': 0.724, 'NOT_concept_no_wall_on_top_m_NOT_concept_wall_below_box': 0.192, 'NOT_concept_wall_below_box_concept_on_pink_cell': 0.112, 'NOT_concept_wall_below_box_concept_target_on_top': 0.038, 'NOT_concept_wall_below_box_concept_wall_down_left': 0.054, 'NOT_concept_wall_below_box_concept_wall_on_left': 0.26, 'NOT_concept_no_pink_cell_below_m_NOT_concept_wall_below_box': 0.214, 'NOT_concept_wall_below_box_concept_wall_up_down_right': 0.0, 'NOT_concept_wall_below_box_concept_wall_on_top': 0.0, 'NOT_concept_wall_below_box_concept_wall_above_box': 0.096, 'NOT_concept_wall_below_box_concept_wall_on_right_of_box': 0.172, 'NOT_concept_wall_below_box_concept_box_on_left': 0.0, 'NOT_concept_wall_below_box_concept_no_wall_on_top_m': 0.676, 'NOT_concept_pink_cell_on_top_NOT_concept_wall_below_box': 0.764, 'NOT_concept_wall_below_box_concept_no_pink_cell_on_top_m': 0.732, 'NOT_concept_no_wall_below_m_NOT_concept_wall_below_box': 0.332, 'NOT_concept_wall_below_box_concept_wall_below_box': 0.0, 'NOT_concept_wall_below_box_concept_wall_on_right': 0.22, 'NOT_concept_wall_below_box_concept_pink_cell_below': 0.092, 'NOT_concept_blank_cell_on_left_NOT_concept_wall_below_box': 0.376, 'NOT_concept_target_on_right_NOT_concept_wall_below_box': 0.872, 'NOT_concept_wall_below_box_concept_no_pink_cell_below_m': 0.634, 'NOT_concept_target_on_top_NOT_concept_wall_below_box': 0.814, 'NOT_concept_wall_below_box_NOT_concept_wall_top_right': 0.854, 'NOT_concept_wall_below_box_concept_box_on_top': 0.0, 'NOT_concept_wall_below_box_concept_no_wall_below_m': 0.53, 'NOT_concept_wall_below_box_NOT_concept_wall_on_left': 0.634, 'NOT_concept_wall_below_box_concept_wall_on_left_of_box': 0.18, 'NOT_concept_box_on_top_NOT_concept_wall_below_box': 0.866, 'NOT_concept_wall_below_box_concept_blank_cell_on_left': 0.486, 'NOT_concept_wall_below_box_NOT_concept_wall_on_right': 0.64, 'NOT_concept_pink_cell_on_right_NOT_concept_wall_below_box': 0.77, 'NOT_concept_box_on_left_NOT_concept_wall_below_box': 0.872, 'NOT_concept_wall_below_box_NOT_concept_wall_down_left': 0.818, 'NOT_concept_pink_cell_below_NOT_concept_wall_below_box': 0.764, 'NOT_concept_wall_below_NOT_concept_wall_below_box': 0.662, 'NOT_concept_no_wall_on_right_m_NOT_concept_wall_on_top': 0.494, 'NOT_concept_on_pink_cell_NOT_concept_wall_on_top': 0.89, 'NOT_concept_box_on_right_NOT_concept_wall_on_top': 1.0, 'NOT_concept_wall_on_top_concept_wall_top_left': 0.0, 'NOT_concept_wall_on_top_concept_target_on_right': 0.0, 'NOT_concept_blank_cell_below_NOT_concept_wall_on_top': 0.34, 'NOT_concept_wall_on_top_concept_no_wall_on_right_m': 0.498, 'NOT_concept_wall_on_top_concept_wall_below': 0.226, 'NOT_concept_no_wall_on_left_m_NOT_concept_wall_on_top': 0.632, 'NOT_concept_wall_on_top_NOT_concept_wall_top_left': 1.0, 'NOT_concept_box_below_NOT_concept_wall_on_top': 1.0, 'NOT_concept_wall_above_box_NOT_concept_wall_on_top': 0.876, 'NOT_concept_wall_on_top_concept_pink_cell_on_top': 0.118, 'NOT_concept_no_pink_cell_on_top_m_NOT_concept_wall_on_top': 0.168, 'NOT_concept_wall_on_right_of_box_NOT_concept_wall_on_top': 0.814, 'NOT_concept_no_wall_on_top_m_NOT_concept_wall_on_top': 0.224, 'NOT_concept_wall_on_top_concept_on_pink_cell': 0.122, 'NOT_concept_wall_on_top_concept_target_on_top': 0.044, 'NOT_concept_wall_on_top_concept_wall_down_left': 0.07, 'NOT_concept_wall_on_top_concept_wall_on_left': 0.306, 'NOT_concept_no_pink_cell_below_m_NOT_concept_wall_on_top': 0.254, 'NOT_concept_wall_on_top_concept_wall_up_down_right': 0.0, 'NOT_concept_wall_on_top_concept_wall_on_top': 0.0, 'NOT_concept_wall_on_top_concept_wall_above_box': 0.118, 'NOT_concept_wall_on_top_concept_wall_on_right_of_box': 0.182, 'NOT_concept_wall_on_top_concept_box_on_left': 0.0, 'NOT_concept_wall_on_top_concept_no_wall_on_top_m': 0.768, 'NOT_concept_pink_cell_on_top_NOT_concept_wall_on_top': 0.87, 'NOT_concept_wall_on_top_concept_no_pink_cell_on_top_m': 0.834, 'NOT_concept_no_wall_below_m_NOT_concept_wall_on_top': 0.394, 'NOT_concept_wall_on_top_concept_wall_below_box': 0.12, 'NOT_concept_wall_on_top_concept_wall_on_right': 0.248, 'NOT_concept_wall_on_top_concept_pink_cell_below': 0.112, 'NOT_concept_blank_cell_on_left_NOT_concept_wall_on_top': 0.456, 'NOT_concept_target_on_right_NOT_concept_wall_on_top': 1.0, 'NOT_concept_wall_on_top_concept_no_pink_cell_below_m': 0.746, 'NOT_concept_target_on_top_NOT_concept_wall_on_top': 0.96, 'NOT_concept_wall_on_top_NOT_concept_wall_top_right': 1.0, 'NOT_concept_wall_on_top_concept_box_on_top': 0.0, 'NOT_concept_wall_on_top_concept_no_wall_below_m': 0.598, 'NOT_concept_wall_on_left_NOT_concept_wall_on_top': 0.702, 'NOT_concept_wall_on_top_concept_wall_on_left_of_box': 0.22, 'NOT_concept_box_on_top_NOT_concept_wall_on_top': 1.0, 'NOT_concept_wall_on_top_concept_blank_cell_on_left': 0.566, 'NOT_concept_wall_on_right_NOT_concept_wall_on_top': 0.742, 'NOT_concept_pink_cell_on_right_NOT_concept_wall_on_top': 0.884, 'NOT_concept_box_on_left_NOT_concept_wall_on_top': 1.0, 'NOT_concept_wall_down_left_NOT_concept_wall_on_top': 0.934, 'NOT_concept_pink_cell_below_NOT_concept_wall_on_top': 0.876, 'NOT_concept_wall_below_NOT_concept_wall_on_top': 0.782, 'NOT_concept_no_wall_on_right_m_NOT_concept_on_pink_cell': 0.432, 'NOT_concept_box_on_right_NOT_concept_no_wall_on_right_m': 0.518, 'NOT_concept_no_wall_on_right_m_concept_wall_top_left': 0.0, 'NOT_concept_no_wall_on_right_m_concept_target_on_right': 0.0, 'NOT_concept_blank_cell_below_NOT_concept_no_wall_on_right_m': 0.116, 'NOT_concept_no_wall_on_right_m_concept_no_wall_on_right_m': 0.0, 'NOT_concept_no_wall_on_right_m_concept_wall_below': 0.088, 'NOT_concept_no_wall_on_left_m_NOT_concept_no_wall_on_right_m': 0.236, 'NOT_concept_no_wall_on_right_m_NOT_concept_wall_top_left': 0.492, 'NOT_concept_box_below_NOT_concept_no_wall_on_right_m': 0.492, 'NOT_concept_no_wall_on_right_m_NOT_concept_wall_above_box': 0.448, 'NOT_concept_no_wall_on_right_m_concept_pink_cell_on_top': 0.124, 'NOT_concept_no_pink_cell_on_top_m_NOT_concept_no_wall_on_right_m': 0.176, 'NOT_concept_no_wall_on_right_m_NOT_concept_wall_on_right_of_box': 0.418, 'NOT_concept_no_wall_on_right_m_NOT_concept_no_wall_on_top_m': 0.076, 'NOT_concept_no_wall_on_right_m_concept_on_pink_cell': 0.058, 'NOT_concept_no_wall_on_right_m_concept_target_on_top': 0.0, 'NOT_concept_no_wall_on_right_m_concept_wall_down_left': 0.0, 'NOT_concept_no_wall_on_right_m_concept_wall_on_left': 0.046, 'NOT_concept_no_pink_cell_below_m_NOT_concept_no_wall_on_right_m': 0.058, 'NOT_concept_no_wall_on_right_m_concept_wall_up_down_right': 0.0, 'NOT_concept_no_wall_on_right_m_concept_wall_on_top': 0.0, 'NOT_concept_no_wall_on_right_m_concept_wall_above_box': 0.068, 'NOT_concept_no_wall_on_right_m_concept_wall_on_right_of_box': 0.096, 'NOT_concept_no_wall_on_right_m_concept_box_on_left': 0.0, 'NOT_concept_no_wall_on_right_m_concept_no_wall_on_top_m': 0.428, 'NOT_concept_no_wall_on_right_m_NOT_concept_pink_cell_on_top': 0.392, 'NOT_concept_no_wall_on_right_m_concept_no_pink_cell_on_top_m': 0.33, 'NOT_concept_no_wall_below_m_NOT_concept_no_wall_on_right_m': 0.204, 'NOT_concept_no_wall_on_right_m_concept_wall_below_box': 0.07, 'NOT_concept_no_wall_on_right_m_concept_wall_on_right': 0.256, 'NOT_concept_no_wall_on_right_m_concept_pink_cell_below': 0.038, 'NOT_concept_blank_cell_on_left_NOT_concept_no_wall_on_right_m': 0.18, 'NOT_concept_no_wall_on_right_m_NOT_concept_target_on_right': 0.496, 'NOT_concept_no_wall_on_right_m_concept_no_pink_cell_below_m': 0.444, 'NOT_concept_no_wall_on_right_m_NOT_concept_target_on_top': 0.504, 'NOT_concept_no_wall_on_right_m_NOT_concept_wall_top_right': 0.494, 'NOT_concept_no_wall_on_right_m_concept_box_on_top': 0.0, 'NOT_concept_no_wall_on_right_m_concept_no_wall_below_m': 0.294, 'NOT_concept_no_wall_on_right_m_NOT_concept_wall_on_left': 0.456, 'NOT_concept_no_wall_on_right_m_concept_wall_on_left_of_box': 0.1, 'NOT_concept_box_on_top_NOT_concept_no_wall_on_right_m': 0.52, 'NOT_concept_no_wall_on_right_m_concept_blank_cell_on_left': 0.34, 'NOT_concept_no_wall_on_right_m_NOT_concept_wall_on_right': 0.238, 'NOT_concept_no_wall_on_right_m_NOT_concept_pink_cell_on_right': 0.524, 'NOT_concept_box_on_left_NOT_concept_no_wall_on_right_m': 0.518, 'NOT_concept_no_wall_on_right_m_NOT_concept_wall_down_left': 0.504, 'NOT_concept_no_wall_on_right_m_NOT_concept_pink_cell_below': 0.444, 'NOT_concept_no_wall_on_right_m_NOT_concept_wall_below': 0.436, 'NOT_concept_box_on_right_NOT_concept_on_pink_cell': 0.884, 'NOT_concept_on_pink_cell_concept_wall_top_left': 0.0, 'NOT_concept_on_pink_cell_concept_target_on_right': 0.0, 'NOT_concept_blank_cell_below_NOT_concept_on_pink_cell': 0.294, 'NOT_concept_on_pink_cell_concept_no_wall_on_right_m': 0.432, 'NOT_concept_on_pink_cell_concept_wall_below': 0.184, 'NOT_concept_no_wall_on_left_m_NOT_concept_on_pink_cell': 0.552, 'NOT_concept_on_pink_cell_NOT_concept_wall_top_left': 0.88, 'NOT_concept_box_below_NOT_concept_on_pink_cell': 0.886, 'NOT_concept_on_pink_cell_NOT_concept_wall_above_box': 0.774, 'NOT_concept_on_pink_cell_concept_pink_cell_on_top': 0.116, 'NOT_concept_no_pink_cell_on_top_m_NOT_concept_on_pink_cell': 0.146, 'NOT_concept_on_pink_cell_NOT_concept_wall_on_right_of_box': 0.676, 'NOT_concept_no_wall_on_top_m_NOT_concept_on_pink_cell': 0.194, 'NOT_concept_on_pink_cell_concept_on_pink_cell': 0.0, 'NOT_concept_on_pink_cell_concept_target_on_top': 0.036, 'NOT_concept_on_pink_cell_concept_wall_down_left': 0.058, 'NOT_concept_on_pink_cell_concept_wall_on_left': 0.256, 'NOT_concept_no_pink_cell_below_m_NOT_concept_on_pink_cell': 0.232, 'NOT_concept_on_pink_cell_concept_wall_up_down_right': 0.0, 'NOT_concept_on_pink_cell_concept_wall_on_top': 0.0, 'NOT_concept_on_pink_cell_concept_wall_above_box': 0.108, 'NOT_concept_on_pink_cell_concept_wall_on_right_of_box': 0.196, 'NOT_concept_on_pink_cell_concept_box_on_left': 0.0, 'NOT_concept_on_pink_cell_concept_no_wall_on_top_m': 0.7, 'NOT_concept_on_pink_cell_NOT_concept_pink_cell_on_top': 0.742, 'NOT_concept_on_pink_cell_concept_no_pink_cell_on_top_m': 0.738, 'NOT_concept_no_wall_below_m_NOT_concept_on_pink_cell': 0.312, 'NOT_concept_on_pink_cell_concept_wall_below_box': 0.126, 'NOT_concept_on_pink_cell_concept_wall_on_right': 0.234, 'NOT_concept_on_pink_cell_concept_pink_cell_below': 0.11, 'NOT_concept_blank_cell_on_left_NOT_concept_on_pink_cell': 0.378, 'NOT_concept_on_pink_cell_NOT_concept_target_on_right': 0.876, 'NOT_concept_on_pink_cell_concept_no_pink_cell_below_m': 0.642, 'NOT_concept_on_pink_cell_NOT_concept_target_on_top': 0.86, 'NOT_concept_on_pink_cell_NOT_concept_wall_top_right': 0.882, 'NOT_concept_on_pink_cell_concept_box_on_top': 0.0, 'NOT_concept_on_pink_cell_concept_no_wall_below_m': 0.556, 'NOT_concept_on_pink_cell_NOT_concept_wall_on_left': 0.622, 'NOT_concept_on_pink_cell_concept_wall_on_left_of_box': 0.198, 'NOT_concept_box_on_top_NOT_concept_on_pink_cell': 0.892, 'NOT_concept_on_pink_cell_concept_blank_cell_on_left': 0.484, 'NOT_concept_on_pink_cell_NOT_concept_wall_on_right': 0.644, 'NOT_concept_on_pink_cell_NOT_concept_pink_cell_on_right': 0.758, 'NOT_concept_box_on_left_NOT_concept_on_pink_cell': 0.892, 'NOT_concept_on_pink_cell_NOT_concept_wall_down_left': 0.83, 'NOT_concept_on_pink_cell_NOT_concept_pink_cell_below': 0.768, 'NOT_concept_on_pink_cell_NOT_concept_wall_below': 0.672, 'NOT_concept_box_on_right_concept_wall_top_left': 0.0, 'NOT_concept_box_on_right_concept_target_on_right': 0.0, 'NOT_concept_blank_cell_below_NOT_concept_box_on_right': 0.326, 'NOT_concept_box_on_right_concept_no_wall_on_right_m': 0.49, 'NOT_concept_box_on_right_concept_wall_below': 0.222, 'NOT_concept_box_on_right_NOT_concept_no_wall_on_left_m': 0.624, 'NOT_concept_box_on_right_NOT_concept_wall_top_left': 1.0, 'NOT_concept_box_below_NOT_concept_box_on_right': 1.0, 'NOT_concept_box_on_right_NOT_concept_wall_above_box': 0.874, 'NOT_concept_box_on_right_concept_pink_cell_on_top': 0.118, 'NOT_concept_box_on_right_NOT_concept_no_pink_cell_on_top_m': 0.14, 'NOT_concept_box_on_right_NOT_concept_wall_on_right_of_box': 0.802, 'NOT_concept_box_on_right_NOT_concept_no_wall_on_top_m': 0.214, 'NOT_concept_box_on_right_concept_on_pink_cell': 0.11, 'NOT_concept_box_on_right_concept_target_on_top': 0.036, 'NOT_concept_box_on_right_concept_wall_down_left': 0.062, 'NOT_concept_box_on_right_concept_wall_on_left': 0.308, 'NOT_concept_box_on_right_NOT_concept_no_pink_cell_below_m': 0.26, 'NOT_concept_box_on_right_concept_wall_up_down_right': 0.0, 'NOT_concept_box_on_right_concept_wall_on_top': 0.0, 'NOT_concept_box_on_right_concept_wall_above_box': 0.102, 'NOT_concept_box_on_right_concept_wall_on_right_of_box': 0.18, 'NOT_concept_box_on_right_concept_box_on_left': 0.0, 'NOT_concept_box_on_right_concept_no_wall_on_top_m': 0.764, 'NOT_concept_box_on_right_NOT_concept_pink_cell_on_top': 0.882, 'NOT_concept_box_on_right_concept_no_pink_cell_on_top_m': 0.844, 'NOT_concept_box_on_right_NOT_concept_no_wall_below_m': 0.392, 'NOT_concept_box_on_right_concept_wall_below_box': 0.136, 'NOT_concept_box_on_right_concept_wall_on_right': 0.278, 'NOT_concept_box_on_right_concept_pink_cell_below': 0.12, 'NOT_concept_blank_cell_on_left_NOT_concept_box_on_right': 0.44, 'NOT_concept_box_on_right_NOT_concept_target_on_right': 1.0, 'NOT_concept_box_on_right_concept_no_pink_cell_below_m': 0.736, 'NOT_concept_box_on_right_NOT_concept_target_on_top': 0.964, 'NOT_concept_box_on_right_NOT_concept_wall_top_right': 1.0, 'NOT_concept_box_on_right_concept_box_on_top': 0.0, 'NOT_concept_box_on_right_concept_no_wall_below_m': 0.604, 'NOT_concept_box_on_right_NOT_concept_wall_on_left': 0.696, 'NOT_concept_box_on_right_concept_wall_on_left_of_box': 0.198, 'NOT_concept_box_on_right_NOT_concept_box_on_top': 1.0, 'NOT_concept_box_on_right_concept_blank_cell_on_left': 0.568, 'NOT_concept_box_on_right_NOT_concept_wall_on_right': 0.734, 'NOT_concept_box_on_right_NOT_concept_pink_cell_on_right': 0.89, 'NOT_concept_box_on_left_NOT_concept_box_on_right': 1.0, 'NOT_concept_box_on_right_NOT_concept_wall_down_left': 0.938, 'NOT_concept_box_on_right_NOT_concept_pink_cell_below': 0.884, 'NOT_concept_box_on_right_NOT_concept_wall_below': 0.78, 'concept_target_on_right_concept_wall_top_left': 0.0, 'NOT_concept_blank_cell_below_concept_wall_top_left': 0.0, 'concept_no_wall_on_right_m_concept_wall_top_left': 0.0, 'concept_wall_below_concept_wall_top_left': 0.0, 'NOT_concept_no_wall_on_left_m_concept_wall_top_left': 0.0, 'NOT_concept_wall_top_left_concept_wall_top_left': 0.0, 'NOT_concept_box_below_concept_wall_top_left': 0.0, 'NOT_concept_wall_above_box_concept_wall_top_left': 0.0, 'concept_pink_cell_on_top_concept_wall_top_left': 0.0, 'NOT_concept_no_pink_cell_on_top_m_concept_wall_top_left': 0.0, 'NOT_concept_wall_on_right_of_box_concept_wall_top_left': 0.0, 'NOT_concept_no_wall_on_top_m_concept_wall_top_left': 0.0, 'concept_on_pink_cell_concept_wall_top_left': 0.0, 'concept_target_on_top_concept_wall_top_left': 0.0, 'concept_wall_down_left_concept_wall_top_left': 0.0, 'concept_wall_on_left_concept_wall_top_left': 0.0, 'NOT_concept_no_pink_cell_below_m_concept_wall_top_left': 0.0, 'concept_wall_top_left_concept_wall_up_down_right': 0.0, 'concept_wall_on_top_concept_wall_top_left': 0.0, 'concept_wall_above_box_concept_wall_top_left': 0.0, 'concept_wall_on_right_of_box_concept_wall_top_left': 0.0, 'concept_box_on_left_concept_wall_top_left': 0.0, 'concept_no_wall_on_top_m_concept_wall_top_left': 0.0, 'NOT_concept_pink_cell_on_top_concept_wall_top_left': 0.0, 'concept_no_pink_cell_on_top_m_concept_wall_top_left': 0.0, 'NOT_concept_no_wall_below_m_concept_wall_top_left': 0.0, 'concept_wall_below_box_concept_wall_top_left': 0.0, 'concept_wall_on_right_concept_wall_top_left': 0.0, 'concept_pink_cell_below_concept_wall_top_left': 0.0, 'NOT_concept_blank_cell_on_left_concept_wall_top_left': 0.0, 'NOT_concept_target_on_right_concept_wall_top_left': 0.0, 'concept_no_pink_cell_below_m_concept_wall_top_left': 0.0, 'NOT_concept_target_on_top_concept_wall_top_left': 0.0, 'NOT_concept_wall_top_right_concept_wall_top_left': 0.0, 'concept_box_on_top_concept_wall_top_left': 0.0, 'concept_no_wall_below_m_concept_wall_top_left': 0.0, 'NOT_concept_wall_on_left_concept_wall_top_left': 0.0, 'concept_wall_on_left_of_box_concept_wall_top_left': 0.0, 'NOT_concept_box_on_top_concept_wall_top_left': 0.0, 'concept_blank_cell_on_left_concept_wall_top_left': 0.0, 'NOT_concept_wall_on_right_concept_wall_top_left': 0.0, 'NOT_concept_pink_cell_on_right_concept_wall_top_left': 0.0, 'NOT_concept_box_on_left_concept_wall_top_left': 0.0, 'NOT_concept_wall_down_left_concept_wall_top_left': 0.0, 'NOT_concept_pink_cell_below_concept_wall_top_left': 0.0, 'NOT_concept_wall_below_concept_wall_top_left': 0.0, 'NOT_concept_blank_cell_below_concept_target_on_right': 0.0, 'concept_no_wall_on_right_m_concept_target_on_right': 0.0, 'concept_target_on_right_concept_wall_below': 0.0, 'NOT_concept_no_wall_on_left_m_concept_target_on_right': 0.0, 'NOT_concept_wall_top_left_concept_target_on_right': 0.0, 'NOT_concept_box_below_concept_target_on_right': 0.0, 'NOT_concept_wall_above_box_concept_target_on_right': 0.0, 'concept_pink_cell_on_top_concept_target_on_right': 0.0, 'NOT_concept_no_pink_cell_on_top_m_concept_target_on_right': 0.0, 'NOT_concept_wall_on_right_of_box_concept_target_on_right': 0.0, 'NOT_concept_no_wall_on_top_m_concept_target_on_right': 0.0, 'concept_on_pink_cell_concept_target_on_right': 0.0, 'concept_target_on_right_concept_target_on_top': 0.0, 'concept_target_on_right_concept_wall_down_left': 0.0, 'concept_target_on_right_concept_wall_on_left': 0.0, 'NOT_concept_no_pink_cell_below_m_concept_target_on_right': 0.0, 'concept_target_on_right_concept_wall_up_down_right': 0.0, 'concept_target_on_right_concept_wall_on_top': 0.0, 'concept_target_on_right_concept_wall_above_box': 0.0, 'concept_target_on_right_concept_wall_on_right_of_box': 0.0, 'concept_box_on_left_concept_target_on_right': 0.0, 'concept_no_wall_on_top_m_concept_target_on_right': 0.0, 'NOT_concept_pink_cell_on_top_concept_target_on_right': 0.0, 'concept_no_pink_cell_on_top_m_concept_target_on_right': 0.0, 'NOT_concept_no_wall_below_m_concept_target_on_right': 0.0, 'concept_target_on_right_concept_wall_below_box': 0.0, 'concept_target_on_right_concept_wall_on_right': 0.0, 'concept_pink_cell_below_concept_target_on_right': 0.0, 'NOT_concept_blank_cell_on_left_concept_target_on_right': 0.0, 'NOT_concept_target_on_right_concept_target_on_right': 0.0, 'concept_no_pink_cell_below_m_concept_target_on_right': 0.0, 'NOT_concept_target_on_top_concept_target_on_right': 0.0, 'NOT_concept_wall_top_right_concept_target_on_right': 0.0, 'concept_box_on_top_concept_target_on_right': 0.0, 'concept_no_wall_below_m_concept_target_on_right': 0.0, 'NOT_concept_wall_on_left_concept_target_on_right': 0.0, 'concept_target_on_right_concept_wall_on_left_of_box': 0.0, 'NOT_concept_box_on_top_concept_target_on_right': 0.0, 'concept_blank_cell_on_left_concept_target_on_right': 0.0, 'NOT_concept_wall_on_right_concept_target_on_right': 0.0, 'NOT_concept_pink_cell_on_right_concept_target_on_right': 0.0, 'NOT_concept_box_on_left_concept_target_on_right': 0.0, 'NOT_concept_wall_down_left_concept_target_on_right': 0.0, 'NOT_concept_pink_cell_below_concept_target_on_right': 0.0, 'NOT_concept_wall_below_concept_target_on_right': 0.0, 'NOT_concept_blank_cell_below_concept_no_wall_on_right_m': 0.224, 'NOT_concept_blank_cell_below_concept_wall_below': 0.23, 'NOT_concept_blank_cell_below_NOT_concept_no_wall_on_left_m': 0.208, 'NOT_concept_blank_cell_below_NOT_concept_wall_top_left': 0.354, 'NOT_concept_blank_cell_below_NOT_concept_box_below': 0.35, 'NOT_concept_blank_cell_below_NOT_concept_wall_above_box': 0.308, 'NOT_concept_blank_cell_below_concept_pink_cell_on_top': 0.04, 'NOT_concept_blank_cell_below_NOT_concept_no_pink_cell_on_top_m': 0.034, 'NOT_concept_blank_cell_below_NOT_concept_wall_on_right_of_box': 0.264, 'NOT_concept_blank_cell_below_NOT_concept_no_wall_on_top_m': 0.112, 'NOT_concept_blank_cell_below_concept_on_pink_cell': 0.03, 'NOT_concept_blank_cell_below_concept_target_on_top': 0.0, 'NOT_concept_blank_cell_below_concept_wall_down_left': 0.064, 'NOT_concept_blank_cell_below_concept_wall_on_left': 0.074, 'NOT_concept_blank_cell_below_NOT_concept_no_pink_cell_below_m': 0.258, 'NOT_concept_blank_cell_below_concept_wall_up_down_right': 0.0, 'NOT_concept_blank_cell_below_concept_wall_on_top': 0.0, 'NOT_concept_blank_cell_below_concept_wall_above_box': 0.042, 'NOT_concept_blank_cell_below_concept_wall_on_right_of_box': 0.076, 'NOT_concept_blank_cell_below_concept_box_on_left': 0.0, 'NOT_concept_blank_cell_below_concept_no_wall_on_top_m': 0.238, 'NOT_concept_blank_cell_below_NOT_concept_pink_cell_on_top': 0.312, 'NOT_concept_blank_cell_below_concept_no_pink_cell_on_top_m': 0.298, 'NOT_concept_blank_cell_below_NOT_concept_no_wall_below_m': 0.222, 'NOT_concept_blank_cell_below_concept_wall_below_box': 0.038, 'NOT_concept_blank_cell_below_concept_wall_on_right': 0.092, 'NOT_concept_blank_cell_below_concept_pink_cell_below': 0.124, 'NOT_concept_blank_cell_below_NOT_concept_blank_cell_on_left': 0.068, 'NOT_concept_blank_cell_below_NOT_concept_target_on_right': 0.33, 'NOT_concept_blank_cell_below_concept_no_pink_cell_below_m': 0.078, 'NOT_concept_blank_cell_below_NOT_concept_target_on_top': 0.336, 'NOT_concept_blank_cell_below_NOT_concept_wall_top_right': 0.34, 'NOT_concept_blank_cell_below_concept_box_on_top': 0.0, 'NOT_concept_blank_cell_below_concept_no_wall_below_m': 0.114, 'NOT_concept_blank_cell_below_NOT_concept_wall_on_left': 0.276, 'NOT_concept_blank_cell_below_concept_wall_on_left_of_box': 0.064, 'NOT_concept_blank_cell_below_NOT_concept_box_on_top': 0.352, 'NOT_concept_blank_cell_below_concept_blank_cell_on_left': 0.272, 'NOT_concept_blank_cell_below_NOT_concept_wall_on_right': 0.26, 'NOT_concept_blank_cell_below_NOT_concept_pink_cell_on_right': 0.338, 'NOT_concept_blank_cell_below_NOT_concept_box_on_left': 0.344, 'NOT_concept_blank_cell_below_NOT_concept_wall_down_left': 0.292, 'NOT_concept_blank_cell_below_NOT_concept_pink_cell_below': 0.224, 'NOT_concept_blank_cell_below_NOT_concept_wall_below': 0.122, 'concept_no_wall_on_right_m_concept_wall_below': 0.138, 'NOT_concept_no_wall_on_left_m_concept_no_wall_on_right_m': 0.384, 'NOT_concept_wall_top_left_concept_no_wall_on_right_m': 0.488, 'NOT_concept_box_below_concept_no_wall_on_right_m': 0.492, 'NOT_concept_wall_above_box_concept_no_wall_on_right_m': 0.462, 'concept_no_wall_on_right_m_concept_pink_cell_on_top': 0.0, 'NOT_concept_no_pink_cell_on_top_m_concept_no_wall_on_right_m': 0.0, 'NOT_concept_wall_on_right_of_box_concept_no_wall_on_right_m': 0.41, 'NOT_concept_no_wall_on_top_m_concept_no_wall_on_right_m': 0.156, 'concept_no_wall_on_right_m_concept_on_pink_cell': 0.062, 'concept_no_wall_on_right_m_concept_target_on_top': 0.042, 'concept_no_wall_on_right_m_concept_wall_down_left': 0.076, 'concept_no_wall_on_right_m_concept_wall_on_left': 0.266, 'NOT_concept_no_pink_cell_below_m_concept_no_wall_on_right_m': 0.196, 'concept_no_wall_on_right_m_concept_wall_up_down_right': 0.0, 'concept_no_wall_on_right_m_concept_wall_on_top': 0.0, 'concept_no_wall_on_right_m_concept_wall_above_box': 0.056, 'concept_no_wall_on_right_m_concept_wall_on_right_of_box': 0.082, 'concept_box_on_left_concept_no_wall_on_right_m': 0.0, 'concept_no_wall_on_right_m_concept_no_wall_on_top_m': 0.34, 'NOT_concept_pink_cell_on_top_concept_no_wall_on_right_m': 0.498, 'concept_no_pink_cell_on_top_m_concept_no_wall_on_right_m': 0.492, 'NOT_concept_no_wall_below_m_concept_no_wall_on_right_m': 0.182, 'concept_no_wall_on_right_m_concept_wall_below_box': 0.068, 'concept_no_wall_on_right_m_concept_wall_on_right': 0.0, 'concept_no_wall_on_right_m_concept_pink_cell_below': 0.072, 'NOT_concept_blank_cell_on_left_concept_no_wall_on_right_m': 0.282, 'NOT_concept_target_on_right_concept_no_wall_on_right_m': 0.522, 'concept_no_pink_cell_below_m_concept_no_wall_on_right_m': 0.3, 'NOT_concept_target_on_top_concept_no_wall_on_right_m': 0.452, 'NOT_concept_wall_top_right_concept_no_wall_on_right_m': 0.492, 'concept_box_on_top_concept_no_wall_on_right_m': 0.0, 'concept_no_wall_below_m_concept_no_wall_on_right_m': 0.3, 'NOT_concept_wall_on_left_concept_no_wall_on_right_m': 0.248, 'concept_no_wall_on_right_m_concept_wall_on_left_of_box': 0.096, 'NOT_concept_box_on_top_concept_no_wall_on_right_m': 0.49, 'concept_blank_cell_on_left_concept_no_wall_on_right_m': 0.224, 'NOT_concept_wall_on_right_concept_no_wall_on_right_m': 0.49, 'NOT_concept_pink_cell_on_right_concept_no_wall_on_right_m': 0.372, 'NOT_concept_box_on_left_concept_no_wall_on_right_m': 0.51, 'NOT_concept_wall_down_left_concept_no_wall_on_right_m': 0.438, 'NOT_concept_pink_cell_below_concept_no_wall_on_right_m': 0.418, 'NOT_concept_wall_below_concept_no_wall_on_right_m': 0.348, 'NOT_concept_no_wall_on_left_m_concept_wall_below': 0.126, 'NOT_concept_wall_top_left_concept_wall_below': 0.246, 'NOT_concept_box_below_concept_wall_below': 0.21, 'NOT_concept_wall_above_box_concept_wall_below': 0.176, 'concept_pink_cell_on_top_concept_wall_below': 0.0, 'NOT_concept_no_pink_cell_on_top_m_concept_wall_below': 0.0, 'NOT_concept_wall_on_right_of_box_concept_wall_below': 0.174, 'NOT_concept_no_wall_on_top_m_concept_wall_below': 0.068, 'concept_on_pink_cell_concept_wall_below': 0.034, 'concept_target_on_top_concept_wall_below': 0.0, 'concept_wall_below_concept_wall_down_left': 0.064, 'concept_wall_below_concept_wall_on_left': 0.058, 'NOT_concept_no_pink_cell_below_m_concept_wall_below': 0.136, 'concept_wall_below_concept_wall_up_down_right': 0.0, 'concept_wall_below_concept_wall_on_top': 0.0, 'concept_wall_above_box_concept_wall_below': 0.026, 'concept_wall_below_concept_wall_on_right_of_box': 0.05, 'concept_box_on_left_concept_wall_below': 0.0, 'concept_no_wall_on_top_m_concept_wall_below': 0.168, 'NOT_concept_pink_cell_on_top_concept_wall_below': 0.248, 'concept_no_pink_cell_on_top_m_concept_wall_below': 0.22, 'NOT_concept_no_wall_below_m_concept_wall_below': 0.23, 'concept_wall_below_concept_wall_below_box': 0.026, 'concept_wall_below_concept_wall_on_right': 0.076, 'concept_pink_cell_below_concept_wall_below': 0.0, 'NOT_concept_blank_cell_on_left_concept_wall_below': 0.062, 'NOT_concept_target_on_right_concept_wall_below': 0.232, 'concept_no_pink_cell_below_m_concept_wall_below': 0.09, 'NOT_concept_target_on_top_concept_wall_below': 0.244, 'NOT_concept_wall_top_right_concept_wall_below': 0.228, 'concept_box_on_top_concept_wall_below': 0.0, 'concept_no_wall_below_m_concept_wall_below': 0.0, 'NOT_concept_wall_on_left_concept_wall_below': 0.16, 'concept_wall_below_concept_wall_on_left_of_box': 0.046, 'NOT_concept_box_on_top_concept_wall_below': 0.234, 'concept_blank_cell_on_left_concept_wall_below': 0.17, 'NOT_concept_wall_on_right_concept_wall_below': 0.156, 'NOT_concept_pink_cell_on_right_concept_wall_below': 0.232, 'NOT_concept_box_on_left_concept_wall_below': 0.232, 'NOT_concept_wall_down_left_concept_wall_below': 0.154, 'NOT_concept_pink_cell_below_concept_wall_below': 0.248, 'NOT_concept_wall_below_concept_wall_below': 0.0, 'NOT_concept_no_wall_on_left_m_NOT_concept_wall_top_left': 0.62, 'NOT_concept_box_below_NOT_concept_no_wall_on_left_m': 0.62, 'NOT_concept_no_wall_on_left_m_NOT_concept_wall_above_box': 0.552, 'NOT_concept_no_wall_on_left_m_concept_pink_cell_on_top': 0.118, 'NOT_concept_no_pink_cell_on_top_m_NOT_concept_no_wall_on_left_m': 0.154, 'NOT_concept_no_wall_on_left_m_NOT_concept_wall_on_right_of_box': 0.49, 'NOT_concept_no_wall_on_left_m_NOT_concept_no_wall_on_top_m': 0.106, 'NOT_concept_no_wall_on_left_m_concept_on_pink_cell': 0.078, 'NOT_concept_no_wall_on_left_m_concept_target_on_top': 0.0, 'NOT_concept_no_wall_on_left_m_concept_wall_down_left': 0.064, 'NOT_concept_no_wall_on_left_m_concept_wall_on_left': 0.302, 'NOT_concept_no_pink_cell_below_m_NOT_concept_no_wall_on_left_m': 0.14, 'NOT_concept_no_wall_on_left_m_concept_wall_up_down_right': 0.0, 'NOT_concept_no_wall_on_left_m_concept_wall_on_top': 0.0, 'NOT_concept_no_wall_on_left_m_concept_wall_above_box': 0.072, 'NOT_concept_no_wall_on_left_m_concept_wall_on_right_of_box': 0.132, 'NOT_concept_no_wall_on_left_m_concept_box_on_left': 0.0, 'NOT_concept_no_wall_on_left_m_concept_no_wall_on_top_m': 0.498, 'NOT_concept_no_wall_on_left_m_NOT_concept_pink_cell_on_top': 0.5, 'NOT_concept_no_wall_on_left_m_concept_no_pink_cell_on_top_m': 0.46, 'NOT_concept_no_wall_below_m_NOT_concept_no_wall_on_left_m': 0.268, 'NOT_concept_no_wall_on_left_m_concept_wall_below_box': 0.078, 'NOT_concept_no_wall_on_left_m_concept_wall_on_right': 0.034, 'NOT_concept_no_wall_on_left_m_concept_pink_cell_below': 0.078, 'NOT_concept_blank_cell_on_left_NOT_concept_no_wall_on_left_m': 0.312, 'NOT_concept_no_wall_on_left_m_NOT_concept_target_on_right': 0.63, 'NOT_concept_no_wall_on_left_m_concept_no_pink_cell_below_m': 0.468, 'NOT_concept_no_wall_on_left_m_NOT_concept_target_on_top': 0.638, 'NOT_concept_no_wall_on_left_m_NOT_concept_wall_top_right': 0.632, 'NOT_concept_no_wall_on_left_m_concept_box_on_top': 0.0, 'NOT_concept_no_wall_on_left_m_concept_no_wall_below_m': 0.37, 'NOT_concept_no_wall_on_left_m_NOT_concept_wall_on_left': 0.334, 'NOT_concept_no_wall_on_left_m_concept_wall_on_left_of_box': 0.114, 'NOT_concept_box_on_top_NOT_concept_no_wall_on_left_m': 0.616, 'NOT_concept_no_wall_on_left_m_concept_blank_cell_on_left': 0.304, 'NOT_concept_no_wall_on_left_m_NOT_concept_wall_on_right': 0.588, 'NOT_concept_no_wall_on_left_m_NOT_concept_pink_cell_on_right': 0.512, 'NOT_concept_box_on_left_NOT_concept_no_wall_on_left_m': 0.63, 'NOT_concept_no_wall_on_left_m_NOT_concept_wall_down_left': 0.568, 'NOT_concept_no_wall_on_left_m_NOT_concept_pink_cell_below': 0.538, 'NOT_concept_no_wall_on_left_m_NOT_concept_wall_below': 0.49, 'NOT_concept_box_below_NOT_concept_wall_top_left': 1.0, 'NOT_concept_wall_above_box_NOT_concept_wall_top_left': 0.878, 'NOT_concept_wall_top_left_concept_pink_cell_on_top': 0.126, 'NOT_concept_no_pink_cell_on_top_m_NOT_concept_wall_top_left': 0.156, 'NOT_concept_wall_on_right_of_box_NOT_concept_wall_top_left': 0.804, 'NOT_concept_no_wall_on_top_m_NOT_concept_wall_top_left': 0.238, 'NOT_concept_wall_top_left_concept_on_pink_cell': 0.116, 'NOT_concept_wall_top_left_concept_target_on_top': 0.038, 'NOT_concept_wall_top_left_concept_wall_down_left': 0.07, 'NOT_concept_wall_top_left_concept_wall_on_left': 0.3, 'NOT_concept_no_pink_cell_below_m_NOT_concept_wall_top_left': 0.274, 'NOT_concept_wall_top_left_concept_wall_up_down_right': 0.0, 'NOT_concept_wall_top_left_concept_wall_on_top': 0.0, 'NOT_concept_wall_top_left_concept_wall_above_box': 0.1, 'NOT_concept_wall_top_left_concept_wall_on_right_of_box': 0.2, 'NOT_concept_wall_top_left_concept_box_on_left': 0.0, 'NOT_concept_wall_top_left_concept_no_wall_on_top_m': 0.784, 'NOT_concept_pink_cell_on_top_NOT_concept_wall_top_left': 0.872, 'NOT_concept_wall_top_left_concept_no_pink_cell_on_top_m': 0.83, 'NOT_concept_no_wall_below_m_NOT_concept_wall_top_left': 0.378, 'NOT_concept_wall_top_left_concept_wall_below_box': 0.13, 'NOT_concept_wall_top_left_concept_wall_on_right': 0.258, 'NOT_concept_wall_top_left_concept_pink_cell_below': 0.114, 'NOT_concept_blank_cell_on_left_NOT_concept_wall_top_left': 0.442, 'NOT_concept_target_on_right_NOT_concept_wall_top_left': 1.0, 'NOT_concept_wall_top_left_concept_no_pink_cell_below_m': 0.742, 'NOT_concept_target_on_top_NOT_concept_wall_top_left': 0.96, 'NOT_concept_wall_top_left_NOT_concept_wall_top_right': 1.0, 'NOT_concept_wall_top_left_concept_box_on_top': 0.0, 'NOT_concept_wall_top_left_concept_no_wall_below_m': 0.604, 'NOT_concept_wall_on_left_NOT_concept_wall_top_left': 0.706, 'NOT_concept_wall_top_left_concept_wall_on_left_of_box': 0.218, 'NOT_concept_box_on_top_NOT_concept_wall_top_left': 1.0, 'NOT_concept_wall_top_left_concept_blank_cell_on_left': 0.574, 'NOT_concept_wall_on_right_NOT_concept_wall_top_left': 0.744, 'NOT_concept_pink_cell_on_right_NOT_concept_wall_top_left': 0.886, 'NOT_concept_box_on_left_NOT_concept_wall_top_left': 1.0, 'NOT_concept_wall_down_left_NOT_concept_wall_top_left': 0.93, 'NOT_concept_pink_cell_below_NOT_concept_wall_top_left': 0.88, 'NOT_concept_wall_below_NOT_concept_wall_top_left': 0.754, 'NOT_concept_box_below_NOT_concept_wall_above_box': 0.886, 'NOT_concept_box_below_concept_pink_cell_on_top': 0.134, 'NOT_concept_box_below_NOT_concept_no_pink_cell_on_top_m': 0.164, 'NOT_concept_box_below_NOT_concept_wall_on_right_of_box': 0.81, 'NOT_concept_box_below_NOT_concept_no_wall_on_top_m': 0.222, 'NOT_concept_box_below_concept_on_pink_cell': 0.12, 'NOT_concept_box_below_concept_target_on_top': 0.04, 'NOT_concept_box_below_concept_wall_down_left': 0.07, 'NOT_concept_box_below_concept_wall_on_left': 0.3, 'NOT_concept_box_below_NOT_concept_no_pink_cell_below_m': 0.236, 'NOT_concept_box_below_concept_wall_up_down_right': 0.0, 'NOT_concept_box_below_concept_wall_on_top': 0.0, 'NOT_concept_box_below_concept_wall_above_box': 0.114, 'NOT_concept_box_below_concept_wall_on_right_of_box': 0.204, 'NOT_concept_box_below_concept_box_on_left': 0.0, 'NOT_concept_box_below_concept_no_wall_on_top_m': 0.774, 'NOT_concept_box_below_NOT_concept_pink_cell_on_top': 0.884, 'NOT_concept_box_below_concept_no_pink_cell_on_top_m': 0.85, 'NOT_concept_box_below_NOT_concept_no_wall_below_m': 0.38, 'NOT_concept_box_below_concept_wall_below_box': 0.138, 'NOT_concept_box_below_concept_wall_on_right': 0.254, 'NOT_concept_box_below_concept_pink_cell_below': 0.122, 'NOT_concept_blank_cell_on_left_NOT_concept_box_below': 0.448, 'NOT_concept_box_below_NOT_concept_target_on_right': 1.0, 'NOT_concept_box_below_concept_no_pink_cell_below_m': 0.748, 'NOT_concept_box_below_NOT_concept_target_on_top': 0.96, 'NOT_concept_box_below_NOT_concept_wall_top_right': 1.0, 'NOT_concept_box_below_concept_box_on_top': 0.0, 'NOT_concept_box_below_concept_no_wall_below_m': 0.588, 'NOT_concept_box_below_NOT_concept_wall_on_left': 0.692, 'NOT_concept_box_below_concept_wall_on_left_of_box': 0.214, 'NOT_concept_box_below_NOT_concept_box_on_top': 1.0, 'NOT_concept_box_below_concept_blank_cell_on_left': 0.57, 'NOT_concept_box_below_NOT_concept_wall_on_right': 0.722, 'NOT_concept_box_below_NOT_concept_pink_cell_on_right': 0.892, 'NOT_concept_box_below_NOT_concept_box_on_left': 1.0, 'NOT_concept_box_below_NOT_concept_wall_down_left': 0.932, 'NOT_concept_box_below_NOT_concept_pink_cell_below': 0.87, 'NOT_concept_box_below_NOT_concept_wall_below': 0.776, 'NOT_concept_wall_above_box_concept_pink_cell_on_top': 0.106, 'NOT_concept_no_pink_cell_on_top_m_NOT_concept_wall_above_box': 0.146, 'NOT_concept_wall_above_box_NOT_concept_wall_on_right_of_box': 0.684, 'NOT_concept_no_wall_on_top_m_NOT_concept_wall_above_box': 0.202, 'NOT_concept_wall_above_box_concept_on_pink_cell': 0.13, 'NOT_concept_wall_above_box_concept_target_on_top': 0.026, 'NOT_concept_wall_above_box_concept_wall_down_left': 0.06, 'NOT_concept_wall_above_box_concept_wall_on_left': 0.266, 'NOT_concept_no_pink_cell_below_m_NOT_concept_wall_above_box': 0.216, 'NOT_concept_wall_above_box_concept_wall_up_down_right': 0.0, 'NOT_concept_wall_above_box_concept_wall_on_top': 0.0, 'NOT_concept_wall_above_box_concept_wall_above_box': 0.0, 'NOT_concept_wall_above_box_concept_wall_on_right_of_box': 0.19, 'NOT_concept_wall_above_box_concept_box_on_left': 0.0, 'NOT_concept_wall_above_box_concept_no_wall_on_top_m': 0.698, 'NOT_concept_pink_cell_on_top_NOT_concept_wall_above_box': 0.77, 'NOT_concept_wall_above_box_concept_no_pink_cell_on_top_m': 0.742, 'NOT_concept_no_wall_below_m_NOT_concept_wall_above_box': 0.316, 'NOT_concept_wall_above_box_concept_wall_below_box': 0.136, 'NOT_concept_wall_above_box_concept_wall_on_right': 0.228, 'NOT_concept_wall_above_box_concept_pink_cell_below': 0.104, 'NOT_concept_blank_cell_on_left_NOT_concept_wall_above_box': 0.396, 'NOT_concept_target_on_right_NOT_concept_wall_above_box': 0.882, 'NOT_concept_wall_above_box_concept_no_pink_cell_below_m': 0.654, 'NOT_concept_target_on_top_NOT_concept_wall_above_box': 0.85, 'NOT_concept_wall_above_box_NOT_concept_wall_top_right': 0.894, 'NOT_concept_wall_above_box_concept_box_on_top': 0.0, 'NOT_concept_wall_above_box_concept_no_wall_below_m': 0.53, 'NOT_concept_wall_above_box_NOT_concept_wall_on_left': 0.612, 'NOT_concept_wall_above_box_concept_wall_on_left_of_box': 0.22, 'NOT_concept_box_on_top_NOT_concept_wall_above_box': 0.88, 'NOT_concept_wall_above_box_concept_blank_cell_on_left': 0.482, 'NOT_concept_wall_above_box_NOT_concept_wall_on_right': 0.652, 'NOT_concept_pink_cell_on_right_NOT_concept_wall_above_box': 0.796, 'NOT_concept_box_on_left_NOT_concept_wall_above_box': 0.882, 'NOT_concept_wall_above_box_NOT_concept_wall_down_left': 0.816, 'NOT_concept_pink_cell_below_NOT_concept_wall_above_box': 0.776, 'NOT_concept_wall_above_box_NOT_concept_wall_below': 0.668, 'NOT_concept_no_pink_cell_on_top_m_concept_pink_cell_on_top': 0.128, 'NOT_concept_wall_on_right_of_box_concept_pink_cell_on_top': 0.096, 'NOT_concept_no_wall_on_top_m_concept_pink_cell_on_top': 0.0, 'concept_on_pink_cell_concept_pink_cell_on_top': 0.008, 'concept_pink_cell_on_top_concept_target_on_top': 0.0, 'concept_pink_cell_on_top_concept_wall_down_left': 0.0, 'concept_pink_cell_on_top_concept_wall_on_left': 0.0, 'NOT_concept_no_pink_cell_below_m_concept_pink_cell_on_top': 0.042, 'concept_pink_cell_on_top_concept_wall_up_down_right': 0.0, 'concept_pink_cell_on_top_concept_wall_on_top': 0.0, 'concept_pink_cell_on_top_concept_wall_above_box': 0.012, 'concept_pink_cell_on_top_concept_wall_on_right_of_box': 0.024, 'concept_box_on_left_concept_pink_cell_on_top': 0.0, 'concept_no_wall_on_top_m_concept_pink_cell_on_top': 0.114, 'NOT_concept_pink_cell_on_top_concept_pink_cell_on_top': 0.0, 'concept_no_pink_cell_on_top_m_concept_pink_cell_on_top': 0.0, 'NOT_concept_no_wall_below_m_concept_pink_cell_on_top': 0.0, 'concept_pink_cell_on_top_concept_wall_below_box': 0.024, 'concept_pink_cell_on_top_concept_wall_on_right': 0.0, 'concept_pink_cell_below_concept_pink_cell_on_top': 0.036, 'NOT_concept_blank_cell_on_left_concept_pink_cell_on_top': 0.004, 'NOT_concept_target_on_right_concept_pink_cell_on_top': 0.122, 'concept_no_pink_cell_below_m_concept_pink_cell_on_top': 0.086, 'NOT_concept_target_on_top_concept_pink_cell_on_top': 0.126, 'NOT_concept_wall_top_right_concept_pink_cell_on_top': 0.128, 'concept_box_on_top_concept_pink_cell_on_top': 0.0, 'concept_no_wall_below_m_concept_pink_cell_on_top': 0.114, 'NOT_concept_wall_on_left_concept_pink_cell_on_top': 0.122, 'concept_pink_cell_on_top_concept_wall_on_left_of_box': 0.03, 'NOT_concept_box_on_top_concept_pink_cell_on_top': 0.114, 'concept_blank_cell_on_left_concept_pink_cell_on_top': 0.122, 'NOT_concept_wall_on_right_concept_pink_cell_on_top': 0.12, 'NOT_concept_pink_cell_on_right_concept_pink_cell_on_top': 0.12, 'NOT_concept_box_on_left_concept_pink_cell_on_top': 0.132, 'NOT_concept_wall_down_left_concept_pink_cell_on_top': 0.122, 'NOT_concept_pink_cell_below_concept_pink_cell_on_top': 0.08, 'NOT_concept_wall_below_concept_pink_cell_on_top': 0.126, 'NOT_concept_no_pink_cell_on_top_m_NOT_concept_wall_on_right_of_box': 0.138, 'NOT_concept_no_pink_cell_on_top_m_NOT_concept_no_wall_on_top_m': 0.0, 'NOT_concept_no_pink_cell_on_top_m_concept_on_pink_cell': 0.01, 'NOT_concept_no_pink_cell_on_top_m_concept_target_on_top': 0.0, 'NOT_concept_no_pink_cell_on_top_m_concept_wall_down_left': 0.0, 'NOT_concept_no_pink_cell_on_top_m_concept_wall_on_left': 0.0, 'NOT_concept_no_pink_cell_below_m_NOT_concept_no_pink_cell_on_top_m': 0.038, 'NOT_concept_no_pink_cell_on_top_m_concept_wall_up_down_right': 0.0, 'NOT_concept_no_pink_cell_on_top_m_concept_wall_on_top': 0.0, 'NOT_concept_no_pink_cell_on_top_m_concept_wall_above_box': 0.018, 'NOT_concept_no_pink_cell_on_top_m_concept_wall_on_right_of_box': 0.028, 'NOT_concept_no_pink_cell_on_top_m_concept_box_on_left': 0.0, 'NOT_concept_no_pink_cell_on_top_m_concept_no_wall_on_top_m': 0.158, 'NOT_concept_no_pink_cell_on_top_m_NOT_concept_pink_cell_on_top': 0.038, 'NOT_concept_no_pink_cell_on_top_m_concept_no_pink_cell_on_top_m': 0.0, 'NOT_concept_no_pink_cell_on_top_m_NOT_concept_no_wall_below_m': 0.034, 'NOT_concept_no_pink_cell_on_top_m_concept_wall_below_box': 0.02, 'NOT_concept_no_pink_cell_on_top_m_concept_wall_on_right': 0.0, 'NOT_concept_no_pink_cell_on_top_m_concept_pink_cell_below': 0.042, 'NOT_concept_blank_cell_on_left_NOT_concept_no_pink_cell_on_top_m': 0.004, 'NOT_concept_no_pink_cell_on_top_m_NOT_concept_target_on_right': 0.148, 'NOT_concept_no_pink_cell_on_top_m_concept_no_pink_cell_below_m': 0.122, 'NOT_concept_no_pink_cell_on_top_m_NOT_concept_target_on_top': 0.166, 'NOT_concept_no_pink_cell_on_top_m_NOT_concept_wall_top_right': 0.152, 'NOT_concept_no_pink_cell_on_top_m_concept_box_on_top': 0.0, 'NOT_concept_no_pink_cell_on_top_m_concept_no_wall_below_m': 0.124, 'NOT_concept_no_pink_cell_on_top_m_NOT_concept_wall_on_left': 0.174, 'NOT_concept_no_pink_cell_on_top_m_concept_wall_on_left_of_box': 0.036, 'NOT_concept_box_on_top_NOT_concept_no_pink_cell_on_top_m': 0.154, 'NOT_concept_no_pink_cell_on_top_m_concept_blank_cell_on_left': 0.166, 'NOT_concept_no_pink_cell_on_top_m_NOT_concept_wall_on_right': 0.17, 'NOT_concept_no_pink_cell_on_top_m_NOT_concept_pink_cell_on_right': 0.16, 'NOT_concept_box_on_left_NOT_concept_no_pink_cell_on_top_m': 0.148, 'NOT_concept_no_pink_cell_on_top_m_NOT_concept_wall_down_left': 0.164, 'NOT_concept_no_pink_cell_on_top_m_NOT_concept_pink_cell_below': 0.116, 'NOT_concept_no_pink_cell_on_top_m_NOT_concept_wall_below': 0.152, 'NOT_concept_no_wall_on_top_m_NOT_concept_wall_on_right_of_box': 0.18, 'NOT_concept_wall_on_right_of_box_concept_on_pink_cell': 0.126, 'NOT_concept_wall_on_right_of_box_concept_target_on_top': 0.028, 'NOT_concept_wall_on_right_of_box_concept_wall_down_left': 0.05, 'NOT_concept_wall_on_right_of_box_concept_wall_on_left': 0.236, 'NOT_concept_no_pink_cell_below_m_NOT_concept_wall_on_right_of_box': 0.194, 'NOT_concept_wall_on_right_of_box_concept_wall_up_down_right': 0.0, 'NOT_concept_wall_on_right_of_box_concept_wall_on_top': 0.0, 'NOT_concept_wall_on_right_of_box_concept_wall_above_box': 0.118, 'NOT_concept_wall_on_right_of_box_concept_wall_on_right_of_box': 0.0, 'NOT_concept_wall_on_right_of_box_concept_box_on_left': 0.0, 'NOT_concept_wall_on_right_of_box_concept_no_wall_on_top_m': 0.622, 'NOT_concept_pink_cell_on_top_NOT_concept_wall_on_right_of_box': 0.706, 'NOT_concept_wall_on_right_of_box_concept_no_pink_cell_on_top_m': 0.676, 'NOT_concept_no_wall_below_m_NOT_concept_wall_on_right_of_box': 0.308, 'NOT_concept_wall_on_right_of_box_concept_wall_below_box': 0.094, 'NOT_concept_wall_on_right_of_box_concept_wall_on_right': 0.206, 'NOT_concept_wall_on_right_of_box_concept_pink_cell_below': 0.084, 'NOT_concept_blank_cell_on_left_NOT_concept_wall_on_right_of_box': 0.37, 'NOT_concept_target_on_right_NOT_concept_wall_on_right_of_box': 0.822, 'NOT_concept_wall_on_right_of_box_concept_no_pink_cell_below_m': 0.604, 'NOT_concept_target_on_top_NOT_concept_wall_on_right_of_box': 0.786, 'NOT_concept_wall_on_right_of_box_NOT_concept_wall_top_right': 0.804, 'NOT_concept_wall_on_right_of_box_concept_box_on_top': 0.0, 'NOT_concept_wall_on_right_of_box_concept_no_wall_below_m': 0.496, 'NOT_concept_wall_on_left_NOT_concept_wall_on_right_of_box': 0.562, 'NOT_concept_wall_on_right_of_box_concept_wall_on_left_of_box': 0.218, 'NOT_concept_box_on_top_NOT_concept_wall_on_right_of_box': 0.81, 'NOT_concept_wall_on_right_of_box_concept_blank_cell_on_left': 0.422, 'NOT_concept_wall_on_right_NOT_concept_wall_on_right_of_box': 0.586, 'NOT_concept_pink_cell_on_right_NOT_concept_wall_on_right_of_box': 0.732, 'NOT_concept_box_on_left_NOT_concept_wall_on_right_of_box': 0.808, 'NOT_concept_wall_down_left_NOT_concept_wall_on_right_of_box': 0.756, 'NOT_concept_pink_cell_below_NOT_concept_wall_on_right_of_box': 0.712, 'NOT_concept_wall_below_NOT_concept_wall_on_right_of_box': 0.632, 'NOT_concept_no_wall_on_top_m_concept_on_pink_cell': 0.032, 'NOT_concept_no_wall_on_top_m_concept_target_on_top': 0.032, 'NOT_concept_no_wall_on_top_m_concept_wall_down_left': 0.034, 'NOT_concept_no_wall_on_top_m_concept_wall_on_left': 0.048, 'NOT_concept_no_pink_cell_below_m_NOT_concept_no_wall_on_top_m': 0.038, 'NOT_concept_no_wall_on_top_m_concept_wall_up_down_right': 0.0, 'NOT_concept_no_wall_on_top_m_concept_wall_on_top': 0.0, 'NOT_concept_no_wall_on_top_m_concept_wall_above_box': 0.018, 'NOT_concept_no_wall_on_top_m_concept_wall_on_right_of_box': 0.044, 'NOT_concept_no_wall_on_top_m_concept_box_on_left': 0.0, 'NOT_concept_no_wall_on_top_m_concept_no_wall_on_top_m': 0.0, 'NOT_concept_no_wall_on_top_m_NOT_concept_pink_cell_on_top': 0.22, 'NOT_concept_no_wall_on_top_m_concept_no_pink_cell_on_top_m': 0.238, 'NOT_concept_no_wall_below_m_NOT_concept_no_wall_on_top_m': 0.104, 'NOT_concept_no_wall_on_top_m_concept_wall_below_box': 0.018, 'NOT_concept_no_wall_on_top_m_concept_wall_on_right': 0.07, 'NOT_concept_no_wall_on_top_m_concept_pink_cell_below': 0.036, 'NOT_concept_blank_cell_on_left_NOT_concept_no_wall_on_top_m': 0.062, 'NOT_concept_no_wall_on_top_m_NOT_concept_target_on_right': 0.21, 'NOT_concept_no_wall_on_top_m_concept_no_pink_cell_below_m': 0.188, 'NOT_concept_no_wall_on_top_m_NOT_concept_target_on_top': 0.188, 'NOT_concept_no_wall_on_top_m_NOT_concept_wall_top_right': 0.232, 'NOT_concept_no_wall_on_top_m_concept_box_on_top': 0.0, 'NOT_concept_no_wall_on_top_m_concept_no_wall_below_m': 0.132, 'NOT_concept_no_wall_on_top_m_NOT_concept_wall_on_left': 0.186, 'NOT_concept_no_wall_on_top_m_concept_wall_on_left_of_box': 0.038, 'NOT_concept_box_on_top_NOT_concept_no_wall_on_top_m': 0.234, 'NOT_concept_no_wall_on_top_m_concept_blank_cell_on_left': 0.168, 'NOT_concept_no_wall_on_top_m_NOT_concept_wall_on_right': 0.172, 'NOT_concept_no_wall_on_top_m_NOT_concept_pink_cell_on_right': 0.232, 'NOT_concept_box_on_left_NOT_concept_no_wall_on_top_m': 0.22, 'NOT_concept_no_wall_on_top_m_NOT_concept_wall_down_left': 0.188, 'NOT_concept_no_wall_on_top_m_NOT_concept_pink_cell_below': 0.182, 'NOT_concept_no_wall_on_top_m_NOT_concept_wall_below': 0.146, 'concept_on_pink_cell_concept_target_on_top': 0.006, 'concept_on_pink_cell_concept_wall_down_left': 0.01, 'concept_on_pink_cell_concept_wall_on_left': 0.042, 'NOT_concept_no_pink_cell_below_m_concept_on_pink_cell': 0.028, 'concept_on_pink_cell_concept_wall_up_down_right': 0.0, 'concept_on_pink_cell_concept_wall_on_top': 0.0, 'concept_on_pink_cell_concept_wall_above_box': 0.0, 'concept_on_pink_cell_concept_wall_on_right_of_box': 0.0, 'concept_box_on_left_concept_on_pink_cell': 0.0, 'concept_no_wall_on_top_m_concept_on_pink_cell': 0.094, 'NOT_concept_pink_cell_on_top_concept_on_pink_cell': 0.108, 'concept_no_pink_cell_on_top_m_concept_on_pink_cell': 0.116, 'NOT_concept_no_wall_below_m_concept_on_pink_cell': 0.046, 'concept_on_pink_cell_concept_wall_below_box': 0.0, 'concept_on_pink_cell_concept_wall_on_right': 0.038, 'concept_on_pink_cell_concept_pink_cell_below': 0.006, 'NOT_concept_blank_cell_on_left_concept_on_pink_cell': 0.056, 'NOT_concept_target_on_right_concept_on_pink_cell': 0.11, 'concept_no_pink_cell_below_m_concept_on_pink_cell': 0.098, 'NOT_concept_target_on_top_concept_on_pink_cell': 0.106, 'NOT_concept_wall_top_right_concept_on_pink_cell': 0.124, 'concept_box_on_top_concept_on_pink_cell': 0.0, 'concept_no_wall_below_m_concept_on_pink_cell': 0.06, 'NOT_concept_wall_on_left_concept_on_pink_cell': 0.074, 'concept_on_pink_cell_concept_wall_on_left_of_box': 0.0, 'NOT_concept_box_on_top_concept_on_pink_cell': 0.124, 'concept_blank_cell_on_left_concept_on_pink_cell': 0.07, 'NOT_concept_wall_on_right_concept_on_pink_cell': 0.092, 'NOT_concept_pink_cell_on_right_concept_on_pink_cell': 0.098, 'NOT_concept_box_on_left_concept_on_pink_cell': 0.116, 'NOT_concept_wall_down_left_concept_on_pink_cell': 0.104, 'NOT_concept_pink_cell_below_concept_on_pink_cell': 0.122, 'NOT_concept_wall_below_concept_on_pink_cell': 0.096, 'concept_target_on_top_concept_wall_down_left': 0.0, 'concept_target_on_top_concept_wall_on_left': 0.0, 'NOT_concept_no_pink_cell_below_m_concept_target_on_top': 0.0, 'concept_target_on_top_concept_wall_up_down_right': 0.0, 'concept_target_on_top_concept_wall_on_top': 0.0, 'concept_target_on_top_concept_wall_above_box': 0.006, 'concept_target_on_top_concept_wall_on_right_of_box': 0.006, 'concept_box_on_left_concept_target_on_top': 0.0, 'concept_no_wall_on_top_m_concept_target_on_top': 0.0, 'NOT_concept_pink_cell_on_top_concept_target_on_top': 0.032, 'concept_no_pink_cell_on_top_m_concept_target_on_top': 0.04, 'NOT_concept_no_wall_below_m_concept_target_on_top': 0.0, 'concept_target_on_top_concept_wall_below_box': 0.002, 'concept_target_on_top_concept_wall_on_right': 0.0, 'concept_pink_cell_below_concept_target_on_top': 0.0, 'NOT_concept_blank_cell_on_left_concept_target_on_top': 0.0, 'NOT_concept_target_on_right_concept_target_on_top': 0.04, 'concept_no_pink_cell_below_m_concept_target_on_top': 0.036, 'NOT_concept_target_on_top_concept_target_on_top': 0.0, 'NOT_concept_wall_top_right_concept_target_on_top': 0.038, 'concept_box_on_top_concept_target_on_top': 0.0, 'concept_no_wall_below_m_concept_target_on_top': 0.042, 'NOT_concept_wall_on_left_concept_target_on_top': 0.038, 'concept_target_on_top_concept_wall_on_left_of_box': 0.008, 'NOT_concept_box_on_top_concept_target_on_top': 0.038, 'concept_blank_cell_on_left_concept_target_on_top': 0.042, 'NOT_concept_wall_on_right_concept_target_on_top': 0.042, 'NOT_concept_pink_cell_on_right_concept_target_on_top': 0.038, 'NOT_concept_box_on_left_concept_target_on_top': 0.038, 'NOT_concept_wall_down_left_concept_target_on_top': 0.042, 'NOT_concept_pink_cell_below_concept_target_on_top': 0.04, 'NOT_concept_wall_below_concept_target_on_top': 0.03, 'concept_wall_down_left_concept_wall_on_left': 0.066, 'NOT_concept_no_pink_cell_below_m_concept_wall_down_left': 0.032, 'concept_wall_down_left_concept_wall_up_down_right': 0.0, 'concept_wall_down_left_concept_wall_on_top': 0.0, 'concept_wall_above_box_concept_wall_down_left': 0.004, 'concept_wall_down_left_concept_wall_on_right_of_box': 0.014, 'concept_box_on_left_concept_wall_down_left': 0.0, 'concept_no_wall_on_top_m_concept_wall_down_left': 0.04, 'NOT_concept_pink_cell_on_top_concept_wall_down_left': 0.062, 'concept_no_pink_cell_on_top_m_concept_wall_down_left': 0.068, 'NOT_concept_no_wall_below_m_concept_wall_down_left': 0.064, 'concept_wall_below_box_concept_wall_down_left': 0.006, 'concept_wall_down_left_concept_wall_on_right': 0.0, 'concept_pink_cell_below_concept_wall_down_left': 0.0, 'NOT_concept_blank_cell_on_left_concept_wall_down_left': 0.072, 'NOT_concept_target_on_right_concept_wall_down_left': 0.06, 'concept_no_pink_cell_below_m_concept_wall_down_left': 0.026, 'NOT_concept_target_on_top_concept_wall_down_left': 0.074, 'NOT_concept_wall_top_right_concept_wall_down_left': 0.07, 'concept_box_on_top_concept_wall_down_left': 0.0, 'concept_no_wall_below_m_concept_wall_down_left': 0.0, 'NOT_concept_wall_on_left_concept_wall_down_left': 0.0, 'concept_wall_down_left_concept_wall_on_left_of_box': 0.014, 'NOT_concept_box_on_top_concept_wall_down_left': 0.072, 'concept_blank_cell_on_left_concept_wall_down_left': 0.0, 'NOT_concept_wall_on_right_concept_wall_down_left': 0.074, 'NOT_concept_pink_cell_on_right_concept_wall_down_left': 0.07, 'NOT_concept_box_on_left_concept_wall_down_left': 0.06, 'NOT_concept_wall_down_left_concept_wall_down_left': 0.0, 'NOT_concept_pink_cell_below_concept_wall_down_left': 0.078, 'NOT_concept_wall_below_concept_wall_down_left': 0.0, 'NOT_concept_no_pink_cell_below_m_concept_wall_on_left': 0.04, 'concept_wall_on_left_concept_wall_up_down_right': 0.0, 'concept_wall_on_left_concept_wall_on_top': 0.0, 'concept_wall_above_box_concept_wall_on_left': 0.036, 'concept_wall_on_left_concept_wall_on_right_of_box': 0.06, 'concept_box_on_left_concept_wall_on_left': 0.0, 'concept_no_wall_on_top_m_concept_wall_on_left': 0.264, 'NOT_concept_pink_cell_on_top_concept_wall_on_left': 0.314, 'concept_no_pink_cell_on_top_m_concept_wall_on_left': 0.314, 'NOT_concept_no_wall_below_m_concept_wall_on_left': 0.128, 'concept_wall_below_box_concept_wall_on_left': 0.042, 'concept_wall_on_left_concept_wall_on_right': 0.0, 'concept_pink_cell_below_concept_wall_on_left': 0.0, 'NOT_concept_blank_cell_on_left_concept_wall_on_left': 0.304, 'NOT_concept_target_on_right_concept_wall_on_left': 0.318, 'concept_no_pink_cell_below_m_concept_wall_on_left': 0.26, 'NOT_concept_target_on_top_concept_wall_on_left': 0.302, 'NOT_concept_wall_top_right_concept_wall_on_left': 0.326, 'concept_box_on_top_concept_wall_on_left': 0.0, 'concept_no_wall_below_m_concept_wall_on_left': 0.178, 'NOT_concept_wall_on_left_concept_wall_on_left': 0.0, 'concept_wall_on_left_concept_wall_on_left_of_box': 0.058, 'NOT_concept_box_on_top_concept_wall_on_left': 0.314, 'concept_blank_cell_on_left_concept_wall_on_left': 0.0, 'NOT_concept_wall_on_right_concept_wall_on_left': 0.302, 'NOT_concept_pink_cell_on_right_concept_wall_on_left': 0.188, 'NOT_concept_box_on_left_concept_wall_on_left': 0.292, 'NOT_concept_wall_down_left_concept_wall_on_left': 0.248, 'NOT_concept_pink_cell_below_concept_wall_on_left': 0.304, 'NOT_concept_wall_below_concept_wall_on_left': 0.238, 'NOT_concept_no_pink_cell_below_m_concept_wall_up_down_right': 0.0, 'NOT_concept_no_pink_cell_below_m_concept_wall_on_top': 0.0, 'NOT_concept_no_pink_cell_below_m_concept_wall_above_box': 0.034, 'NOT_concept_no_pink_cell_below_m_concept_wall_on_right_of_box': 0.054, 'NOT_concept_no_pink_cell_below_m_concept_box_on_left': 0.0, 'NOT_concept_no_pink_cell_below_m_concept_no_wall_on_top_m': 0.208, 'NOT_concept_no_pink_cell_below_m_NOT_concept_pink_cell_on_top': 0.214, 'NOT_concept_no_pink_cell_below_m_concept_no_pink_cell_on_top_m': 0.214, 'NOT_concept_no_pink_cell_below_m_NOT_concept_no_wall_below_m': 0.142, 'NOT_concept_no_pink_cell_below_m_concept_wall_below_box': 0.036, 'NOT_concept_no_pink_cell_below_m_concept_wall_on_right': 0.028, 'NOT_concept_no_pink_cell_below_m_concept_pink_cell_below': 0.12, 'NOT_concept_blank_cell_on_left_NOT_concept_no_pink_cell_below_m': 0.038, 'NOT_concept_no_pink_cell_below_m_NOT_concept_target_on_right': 0.252, 'NOT_concept_no_pink_cell_below_m_concept_no_pink_cell_below_m': 0.0, 'NOT_concept_no_pink_cell_below_m_NOT_concept_target_on_top': 0.256, 'NOT_concept_no_pink_cell_below_m_NOT_concept_wall_top_right': 0.26, 'NOT_concept_no_pink_cell_below_m_concept_box_on_top': 0.0, 'NOT_concept_no_pink_cell_below_m_concept_no_wall_below_m': 0.124, 'NOT_concept_no_pink_cell_below_m_NOT_concept_wall_on_left': 0.206, 'NOT_concept_no_pink_cell_below_m_concept_wall_on_left_of_box': 0.06, 'NOT_concept_box_on_top_NOT_concept_no_pink_cell_below_m': 0.252, 'NOT_concept_no_pink_cell_below_m_concept_blank_cell_on_left': 0.212, 'NOT_concept_no_pink_cell_below_m_NOT_concept_wall_on_right': 0.228, 'NOT_concept_no_pink_cell_below_m_NOT_concept_pink_cell_on_right': 0.256, 'NOT_concept_box_on_left_NOT_concept_no_pink_cell_below_m': 0.264, 'NOT_concept_no_pink_cell_below_m_NOT_concept_wall_down_left': 0.208, 'NOT_concept_no_pink_cell_below_m_NOT_concept_pink_cell_below': 0.134, 'NOT_concept_no_pink_cell_below_m_NOT_concept_wall_below': 0.116, 'concept_wall_on_top_concept_wall_up_down_right': 0.0, 'concept_wall_above_box_concept_wall_up_down_right': 0.0, 'concept_wall_on_right_of_box_concept_wall_up_down_right': 0.0, 'concept_box_on_left_concept_wall_up_down_right': 0.0, 'concept_no_wall_on_top_m_concept_wall_up_down_right': 0.0, 'NOT_concept_pink_cell_on_top_concept_wall_up_down_right': 0.0, 'concept_no_pink_cell_on_top_m_concept_wall_up_down_right': 0.0, 'NOT_concept_no_wall_below_m_concept_wall_up_down_right': 0.0, 'concept_wall_below_box_concept_wall_up_down_right': 0.0, 'concept_wall_on_right_concept_wall_up_down_right': 0.0, 'concept_pink_cell_below_concept_wall_up_down_right': 0.0, 'NOT_concept_blank_cell_on_left_concept_wall_up_down_right': 0.0, 'NOT_concept_target_on_right_concept_wall_up_down_right': 0.0, 'concept_no_pink_cell_below_m_concept_wall_up_down_right': 0.0, 'NOT_concept_target_on_top_concept_wall_up_down_right': 0.0, 'NOT_concept_wall_top_right_concept_wall_up_down_right': 0.0, 'concept_box_on_top_concept_wall_up_down_right': 0.0, 'concept_no_wall_below_m_concept_wall_up_down_right': 0.0, 'NOT_concept_wall_on_left_concept_wall_up_down_right': 0.0, 'concept_wall_on_left_of_box_concept_wall_up_down_right': 0.0, 'NOT_concept_box_on_top_concept_wall_up_down_right': 0.0, 'concept_blank_cell_on_left_concept_wall_up_down_right': 0.0, 'NOT_concept_wall_on_right_concept_wall_up_down_right': 0.0, 'NOT_concept_pink_cell_on_right_concept_wall_up_down_right': 0.0, 'NOT_concept_box_on_left_concept_wall_up_down_right': 0.0, 'NOT_concept_wall_down_left_concept_wall_up_down_right': 0.0, 'NOT_concept_pink_cell_below_concept_wall_up_down_right': 0.0, 'NOT_concept_wall_below_concept_wall_up_down_right': 0.0, 'concept_wall_above_box_concept_wall_on_top': 0.0, 'concept_wall_on_right_of_box_concept_wall_on_top': 0.0, 'concept_box_on_left_concept_wall_on_top': 0.0, 'concept_no_wall_on_top_m_concept_wall_on_top': 0.0, 'NOT_concept_pink_cell_on_top_concept_wall_on_top': 0.0, 'concept_no_pink_cell_on_top_m_concept_wall_on_top': 0.0, 'NOT_concept_no_wall_below_m_concept_wall_on_top': 0.0, 'concept_wall_below_box_concept_wall_on_top': 0.0, 'concept_wall_on_right_concept_wall_on_top': 0.0, 'concept_pink_cell_below_concept_wall_on_top': 0.0, 'NOT_concept_blank_cell_on_left_concept_wall_on_top': 0.0, 'NOT_concept_target_on_right_concept_wall_on_top': 0.0, 'concept_no_pink_cell_below_m_concept_wall_on_top': 0.0, 'NOT_concept_target_on_top_concept_wall_on_top': 0.0, 'NOT_concept_wall_top_right_concept_wall_on_top': 0.0, 'concept_box_on_top_concept_wall_on_top': 0.0, 'concept_no_wall_below_m_concept_wall_on_top': 0.0, 'NOT_concept_wall_on_left_concept_wall_on_top': 0.0, 'concept_wall_on_left_of_box_concept_wall_on_top': 0.0, 'NOT_concept_box_on_top_concept_wall_on_top': 0.0, 'concept_blank_cell_on_left_concept_wall_on_top': 0.0, 'NOT_concept_wall_on_right_concept_wall_on_top': 0.0, 'NOT_concept_pink_cell_on_right_concept_wall_on_top': 0.0, 'NOT_concept_box_on_left_concept_wall_on_top': 0.0, 'NOT_concept_wall_down_left_concept_wall_on_top': 0.0, 'NOT_concept_pink_cell_below_concept_wall_on_top': 0.0, 'NOT_concept_wall_below_concept_wall_on_top': 0.0, 'concept_wall_above_box_concept_wall_on_right_of_box': 0.0, 'concept_box_on_left_concept_wall_above_box': 0.0, 'concept_no_wall_on_top_m_concept_wall_above_box': 0.104, 'NOT_concept_pink_cell_on_top_concept_wall_above_box': 0.104, 'concept_no_pink_cell_on_top_m_concept_wall_above_box': 0.096, 'NOT_concept_no_wall_below_m_concept_wall_above_box': 0.038, 'concept_wall_above_box_concept_wall_below_box': 0.018, 'concept_wall_above_box_concept_wall_on_right': 0.034, 'concept_pink_cell_below_concept_wall_above_box': 0.01, 'NOT_concept_blank_cell_on_left_concept_wall_above_box': 0.052, 'NOT_concept_target_on_right_concept_wall_above_box': 0.118, 'concept_no_pink_cell_below_m_concept_wall_above_box': 0.084, 'NOT_concept_target_on_top_concept_wall_above_box': 0.11, 'NOT_concept_wall_top_right_concept_wall_above_box': 0.112, 'concept_box_on_top_concept_wall_above_box': 0.0, 'concept_no_wall_below_m_concept_wall_above_box': 0.08, 'NOT_concept_wall_on_left_concept_wall_above_box': 0.084, 'concept_wall_above_box_concept_wall_on_left_of_box': 0.0, 'NOT_concept_box_on_top_concept_wall_above_box': 0.114, 'concept_blank_cell_on_left_concept_wall_above_box': 0.066, 'NOT_concept_wall_on_right_concept_wall_above_box': 0.086, 'NOT_concept_pink_cell_on_right_concept_wall_above_box': 0.1, 'NOT_concept_box_on_left_concept_wall_above_box': 0.12, 'NOT_concept_wall_down_left_concept_wall_above_box': 0.114, 'NOT_concept_pink_cell_below_concept_wall_above_box': 0.102, 'NOT_concept_wall_below_concept_wall_above_box': 0.082, 'concept_box_on_left_concept_wall_on_right_of_box': 0.0, 'concept_no_wall_on_top_m_concept_wall_on_right_of_box': 0.148, 'NOT_concept_pink_cell_on_top_concept_wall_on_right_of_box': 0.186, 'concept_no_pink_cell_on_top_m_concept_wall_on_right_of_box': 0.158, 'NOT_concept_no_wall_below_m_concept_wall_on_right_of_box': 0.068, 'concept_wall_below_box_concept_wall_on_right_of_box': 0.038, 'concept_wall_on_right_concept_wall_on_right_of_box': 0.052, 'concept_pink_cell_below_concept_wall_on_right_of_box': 0.024, 'NOT_concept_blank_cell_on_left_concept_wall_on_right_of_box': 0.076, 'NOT_concept_target_on_right_concept_wall_on_right_of_box': 0.208, 'concept_no_pink_cell_below_m_concept_wall_on_right_of_box': 0.138, 'NOT_concept_target_on_top_concept_wall_on_right_of_box': 0.176, 'NOT_concept_wall_top_right_concept_wall_on_right_of_box': 0.202, 'concept_box_on_top_concept_wall_on_right_of_box': 0.0, 'concept_no_wall_below_m_concept_wall_on_right_of_box': 0.112, 'NOT_concept_wall_on_left_concept_wall_on_right_of_box': 0.132, 'concept_wall_on_left_of_box_concept_wall_on_right_of_box': 0.0, 'NOT_concept_box_on_top_concept_wall_on_right_of_box': 0.188, 'concept_blank_cell_on_left_concept_wall_on_right_of_box': 0.11, 'NOT_concept_wall_on_right_concept_wall_on_right_of_box': 0.15, 'NOT_concept_pink_cell_on_right_concept_wall_on_right_of_box': 0.164, 'NOT_concept_box_on_left_concept_wall_on_right_of_box': 0.19, 'NOT_concept_wall_down_left_concept_wall_on_right_of_box': 0.174, 'NOT_concept_pink_cell_below_concept_wall_on_right_of_box': 0.168, 'NOT_concept_wall_below_concept_wall_on_right_of_box': 0.15, 'concept_box_on_left_concept_no_wall_on_top_m': 0.0, 'NOT_concept_pink_cell_on_top_concept_box_on_left': 0.0, 'concept_box_on_left_concept_no_pink_cell_on_top_m': 0.0, 'NOT_concept_no_wall_below_m_concept_box_on_left': 0.0, 'concept_box_on_left_concept_wall_below_box': 0.0, 'concept_box_on_left_concept_wall_on_right': 0.0, 'concept_box_on_left_concept_pink_cell_below': 0.0, 'NOT_concept_blank_cell_on_left_concept_box_on_left': 0.0, 'NOT_concept_target_on_right_concept_box_on_left': 0.0, 'concept_box_on_left_concept_no_pink_cell_below_m': 0.0, 'NOT_concept_target_on_top_concept_box_on_left': 0.0, 'NOT_concept_wall_top_right_concept_box_on_left': 0.0, 'concept_box_on_left_concept_box_on_top': 0.0, 'concept_box_on_left_concept_no_wall_below_m': 0.0, 'NOT_concept_wall_on_left_concept_box_on_left': 0.0, 'concept_box_on_left_concept_wall_on_left_of_box': 0.0, 'NOT_concept_box_on_top_concept_box_on_left': 0.0, 'concept_blank_cell_on_left_concept_box_on_left': 0.0, 'NOT_concept_wall_on_right_concept_box_on_left': 0.0, 'NOT_concept_pink_cell_on_right_concept_box_on_left': 0.0, 'NOT_concept_box_on_left_concept_box_on_left': 0.0, 'NOT_concept_wall_down_left_concept_box_on_left': 0.0, 'NOT_concept_pink_cell_below_concept_box_on_left': 0.0, 'NOT_concept_wall_below_concept_box_on_left': 0.0, 'NOT_concept_pink_cell_on_top_concept_no_wall_on_top_m': 0.662, 'concept_no_pink_cell_on_top_m_concept_no_wall_on_top_m': 0.624, 'NOT_concept_no_wall_below_m_concept_no_wall_on_top_m': 0.29, 'concept_no_wall_on_top_m_concept_wall_below_box': 0.124, 'concept_no_wall_on_top_m_concept_wall_on_right': 0.204, 'concept_no_wall_on_top_m_concept_pink_cell_below': 0.082, 'NOT_concept_blank_cell_on_left_concept_no_wall_on_top_m': 0.402, 'NOT_concept_target_on_right_concept_no_wall_on_top_m': 0.774, 'concept_no_pink_cell_below_m_concept_no_wall_on_top_m': 0.566, 'NOT_concept_target_on_top_concept_no_wall_on_top_m': 0.794, 'NOT_concept_wall_top_right_concept_no_wall_on_top_m': 0.774, 'concept_box_on_top_concept_no_wall_on_top_m': 0.0, 'concept_no_wall_below_m_concept_no_wall_on_top_m': 0.452, 'NOT_concept_wall_on_left_concept_no_wall_on_top_m': 0.526, 'concept_no_wall_on_top_m_concept_wall_on_left_of_box': 0.172, 'NOT_concept_box_on_top_concept_no_wall_on_top_m': 0.764, 'concept_blank_cell_on_left_concept_no_wall_on_top_m': 0.404, 'NOT_concept_wall_on_right_concept_no_wall_on_top_m': 0.566, 'NOT_concept_pink_cell_on_right_concept_no_wall_on_top_m': 0.664, 'NOT_concept_box_on_left_concept_no_wall_on_top_m': 0.776, 'NOT_concept_wall_down_left_concept_no_wall_on_top_m': 0.748, 'NOT_concept_pink_cell_below_concept_no_wall_on_top_m': 0.7, 'NOT_concept_wall_below_concept_no_wall_on_top_m': 0.612, 'NOT_concept_pink_cell_on_top_concept_no_pink_cell_on_top_m': 0.83, 'NOT_concept_no_wall_below_m_NOT_concept_pink_cell_on_top': 0.392, 'NOT_concept_pink_cell_on_top_concept_wall_below_box': 0.118, 'NOT_concept_pink_cell_on_top_concept_wall_on_right': 0.254, 'NOT_concept_pink_cell_on_top_concept_pink_cell_below': 0.08, 'NOT_concept_blank_cell_on_left_NOT_concept_pink_cell_on_top': 0.438, 'NOT_concept_pink_cell_on_top_NOT_concept_target_on_right': 0.874, 'NOT_concept_pink_cell_on_top_concept_no_pink_cell_below_m': 0.67, 'NOT_concept_pink_cell_on_top_NOT_concept_target_on_top': 0.842, 'NOT_concept_pink_cell_on_top_NOT_concept_wall_top_right': 0.882, 'NOT_concept_pink_cell_on_top_concept_box_on_top': 0.0, 'NOT_concept_pink_cell_on_top_concept_no_wall_below_m': 0.492, 'NOT_concept_pink_cell_on_top_NOT_concept_wall_on_left': 0.566, 'NOT_concept_pink_cell_on_top_concept_wall_on_left_of_box': 0.17, 'NOT_concept_box_on_top_NOT_concept_pink_cell_on_top': 0.866, 'NOT_concept_pink_cell_on_top_concept_blank_cell_on_left': 0.458, 'NOT_concept_pink_cell_on_top_NOT_concept_wall_on_right': 0.622, 'NOT_concept_pink_cell_on_right_NOT_concept_pink_cell_on_top': 0.74, 'NOT_concept_box_on_left_NOT_concept_pink_cell_on_top': 0.878, 'NOT_concept_pink_cell_on_top_NOT_concept_wall_down_left': 0.818, 'NOT_concept_pink_cell_below_NOT_concept_pink_cell_on_top': 0.808, 'NOT_concept_pink_cell_on_top_NOT_concept_wall_below': 0.656, 'NOT_concept_no_wall_below_m_concept_no_pink_cell_on_top_m': 0.356, 'concept_no_pink_cell_on_top_m_concept_wall_below_box': 0.104, 'concept_no_pink_cell_on_top_m_concept_wall_on_right': 0.274, 'concept_no_pink_cell_on_top_m_concept_pink_cell_below': 0.074, 'NOT_concept_blank_cell_on_left_concept_no_pink_cell_on_top_m': 0.438, 'NOT_concept_target_on_right_concept_no_pink_cell_on_top_m': 0.836, 'concept_no_pink_cell_below_m_concept_no_pink_cell_on_top_m': 0.62, 'NOT_concept_target_on_top_concept_no_pink_cell_on_top_m': 0.808, 'NOT_concept_wall_top_right_concept_no_pink_cell_on_top_m': 0.844, 'concept_box_on_top_concept_no_pink_cell_on_top_m': 0.0, 'concept_no_pink_cell_on_top_m_concept_no_wall_below_m': 0.488, 'NOT_concept_wall_on_left_concept_no_pink_cell_on_top_m': 0.526, 'concept_no_pink_cell_on_top_m_concept_wall_on_left_of_box': 0.186, 'NOT_concept_box_on_top_concept_no_pink_cell_on_top_m': 0.832, 'concept_blank_cell_on_left_concept_no_pink_cell_on_top_m': 0.4, 'NOT_concept_wall_on_right_concept_no_pink_cell_on_top_m': 0.574, 'NOT_concept_pink_cell_on_right_concept_no_pink_cell_on_top_m': 0.73, 'NOT_concept_box_on_left_concept_no_pink_cell_on_top_m': 0.848, 'NOT_concept_wall_down_left_concept_no_pink_cell_on_top_m': 0.756, 'NOT_concept_pink_cell_below_concept_no_pink_cell_on_top_m': 0.756, 'NOT_concept_wall_below_concept_no_pink_cell_on_top_m': 0.61, 'NOT_concept_no_wall_below_m_concept_wall_below_box': 0.038, 'NOT_concept_no_wall_below_m_concept_wall_on_right': 0.148, 'NOT_concept_no_wall_below_m_concept_pink_cell_below': 0.0, 'NOT_concept_blank_cell_on_left_NOT_concept_no_wall_below_m': 0.14, 'NOT_concept_no_wall_below_m_NOT_concept_target_on_right': 0.39, 'NOT_concept_no_wall_below_m_concept_no_pink_cell_below_m': 0.26, 'NOT_concept_no_wall_below_m_NOT_concept_target_on_top': 0.39, 'NOT_concept_no_wall_below_m_NOT_concept_wall_top_right': 0.394, 'NOT_concept_no_wall_below_m_concept_box_on_top': 0.0, 'NOT_concept_no_wall_below_m_concept_no_wall_below_m': 0.0, 'NOT_concept_no_wall_below_m_NOT_concept_wall_on_left': 0.264, 'NOT_concept_no_wall_below_m_concept_wall_on_left_of_box': 0.082, 'NOT_concept_box_on_top_NOT_concept_no_wall_below_m': 0.388, 'NOT_concept_no_wall_below_m_concept_blank_cell_on_left': 0.256, 'NOT_concept_no_wall_below_m_NOT_concept_wall_on_right': 0.25, 'NOT_concept_no_wall_below_m_NOT_concept_pink_cell_on_right': 0.4, 'NOT_concept_box_on_left_NOT_concept_no_wall_below_m': 0.404, 'NOT_concept_no_wall_below_m_NOT_concept_wall_down_left': 0.334, 'NOT_concept_no_wall_below_m_NOT_concept_pink_cell_below': 0.398, 'NOT_concept_no_wall_below_m_NOT_concept_wall_below': 0.16, 'concept_wall_below_box_concept_wall_on_right': 0.032, 'concept_pink_cell_below_concept_wall_below_box': 0.014, 'NOT_concept_blank_cell_on_left_concept_wall_below_box': 0.054, 'NOT_concept_target_on_right_concept_wall_below_box': 0.132, 'concept_no_pink_cell_below_m_concept_wall_below_box': 0.108, 'NOT_concept_target_on_top_concept_wall_below_box': 0.122, 'NOT_concept_wall_top_right_concept_wall_below_box': 0.13, 'concept_box_on_top_concept_wall_below_box': 0.0, 'concept_no_wall_below_m_concept_wall_below_box': 0.094, 'NOT_concept_wall_on_left_concept_wall_below_box': 0.09, 'concept_wall_below_box_concept_wall_on_left_of_box': 0.02, 'NOT_concept_box_on_top_concept_wall_below_box': 0.128, 'concept_blank_cell_on_left_concept_wall_below_box': 0.078, 'NOT_concept_wall_on_right_concept_wall_below_box': 0.106, 'NOT_concept_pink_cell_on_right_concept_wall_below_box': 0.108, 'NOT_concept_box_on_left_concept_wall_below_box': 0.128, 'NOT_concept_wall_down_left_concept_wall_below_box': 0.124, 'NOT_concept_pink_cell_below_concept_wall_below_box': 0.128, 'NOT_concept_wall_below_concept_wall_below_box': 0.098, 'concept_pink_cell_below_concept_wall_on_right': 0.0, 'NOT_concept_blank_cell_on_left_concept_wall_on_right': 0.094, 'NOT_concept_target_on_right_concept_wall_on_right': 0.252, 'concept_no_pink_cell_below_m_concept_wall_on_right': 0.218, 'NOT_concept_target_on_top_concept_wall_on_right': 0.256, 'NOT_concept_wall_top_right_concept_wall_on_right': 0.274, 'concept_box_on_top_concept_wall_on_right': 0.0, 'concept_no_wall_below_m_concept_wall_on_right': 0.118, 'NOT_concept_wall_on_left_concept_wall_on_right': 0.262, 'concept_wall_on_left_of_box_concept_wall_on_right': 0.058, 'NOT_concept_box_on_top_concept_wall_on_right': 0.268, 'concept_blank_cell_on_left_concept_wall_on_right': 0.18, 'NOT_concept_wall_on_right_concept_wall_on_right': 0.0, 'NOT_concept_pink_cell_on_right_concept_wall_on_right': 0.278, 'NOT_concept_box_on_left_concept_wall_on_right': 0.264, 'NOT_concept_wall_down_left_concept_wall_on_right': 0.26, 'NOT_concept_pink_cell_below_concept_wall_on_right': 0.266, 'NOT_concept_wall_below_concept_wall_on_right': 0.164, 'NOT_concept_blank_cell_on_left_concept_pink_cell_below': 0.002, 'NOT_concept_target_on_right_concept_pink_cell_below': 0.12, 'concept_no_pink_cell_below_m_concept_pink_cell_below': 0.0, 'NOT_concept_target_on_top_concept_pink_cell_below': 0.126, 'NOT_concept_wall_top_right_concept_pink_cell_below': 0.116, 'concept_box_on_top_concept_pink_cell_below': 0.0, 'concept_no_wall_below_m_concept_pink_cell_below': 0.118, 'NOT_concept_wall_on_left_concept_pink_cell_below': 0.124, 'concept_pink_cell_below_concept_wall_on_left_of_box': 0.028, 'NOT_concept_box_on_top_concept_pink_cell_below': 0.104, 'concept_blank_cell_on_left_concept_pink_cell_below': 0.098, 'NOT_concept_wall_on_right_concept_pink_cell_below': 0.122, 'NOT_concept_pink_cell_on_right_concept_pink_cell_below': 0.124, 'NOT_concept_box_on_left_concept_pink_cell_below': 0.116, 'NOT_concept_wall_down_left_concept_pink_cell_below': 0.112, 'NOT_concept_pink_cell_below_concept_pink_cell_below': 0.0, 'NOT_concept_wall_below_concept_pink_cell_below': 0.116, 'NOT_concept_blank_cell_on_left_NOT_concept_target_on_right': 0.448, 'NOT_concept_blank_cell_on_left_concept_no_pink_cell_below_m': 0.406, 'NOT_concept_blank_cell_on_left_NOT_concept_target_on_top': 0.42, 'NOT_concept_blank_cell_on_left_NOT_concept_wall_top_right': 0.45, 'NOT_concept_blank_cell_on_left_concept_box_on_top': 0.0, 'NOT_concept_blank_cell_on_left_concept_no_wall_below_m': 0.314, 'NOT_concept_blank_cell_on_left_NOT_concept_wall_on_left': 0.126, 'NOT_concept_blank_cell_on_left_concept_wall_on_left_of_box': 0.08, 'NOT_concept_blank_cell_on_left_NOT_concept_box_on_top': 0.426, 'NOT_concept_blank_cell_on_left_concept_blank_cell_on_left': 0.0, 'NOT_concept_blank_cell_on_left_NOT_concept_wall_on_right': 0.354, 'NOT_concept_blank_cell_on_left_NOT_concept_pink_cell_on_right': 0.318, 'NOT_concept_blank_cell_on_left_NOT_concept_box_on_left': 0.43, 'NOT_concept_blank_cell_on_left_NOT_concept_wall_down_left': 0.366, 'NOT_concept_blank_cell_on_left_NOT_concept_pink_cell_below': 0.436, 'NOT_concept_blank_cell_on_left_NOT_concept_wall_below': 0.382, 'NOT_concept_target_on_right_concept_no_pink_cell_below_m': 0.758, 'NOT_concept_target_on_right_NOT_concept_target_on_top': 0.962, 'NOT_concept_target_on_right_NOT_concept_wall_top_right': 1.0, 'NOT_concept_target_on_right_concept_box_on_top': 0.0, 'NOT_concept_target_on_right_concept_no_wall_below_m': 0.604, 'NOT_concept_target_on_right_NOT_concept_wall_on_left': 0.688, 'NOT_concept_target_on_right_concept_wall_on_left_of_box': 0.21, 'NOT_concept_box_on_top_NOT_concept_target_on_right': 1.0, 'NOT_concept_target_on_right_concept_blank_cell_on_left': 0.582, 'NOT_concept_target_on_right_NOT_concept_wall_on_right': 0.748, 'NOT_concept_pink_cell_on_right_NOT_concept_target_on_right': 0.888, 'NOT_concept_box_on_left_NOT_concept_target_on_right': 1.0, 'NOT_concept_target_on_right_NOT_concept_wall_down_left': 0.936, 'NOT_concept_pink_cell_below_NOT_concept_target_on_right': 0.884, 'NOT_concept_target_on_right_NOT_concept_wall_below': 0.756, 'NOT_concept_target_on_top_concept_no_pink_cell_below_m': 0.698, 'NOT_concept_wall_top_right_concept_no_pink_cell_below_m': 0.738, 'concept_box_on_top_concept_no_pink_cell_below_m': 0.0, 'concept_no_pink_cell_below_m_concept_no_wall_below_m': 0.51, 'NOT_concept_wall_on_left_concept_no_pink_cell_below_m': 0.492, 'concept_no_pink_cell_below_m_concept_wall_on_left_of_box': 0.142, 'NOT_concept_box_on_top_concept_no_pink_cell_below_m': 0.76, 'concept_blank_cell_on_left_concept_no_pink_cell_below_m': 0.346, 'NOT_concept_wall_on_right_concept_no_pink_cell_below_m': 0.516, 'NOT_concept_pink_cell_on_right_concept_no_pink_cell_below_m': 0.636, 'NOT_concept_box_on_left_concept_no_pink_cell_below_m': 0.748, 'NOT_concept_wall_down_left_concept_no_pink_cell_below_m': 0.71, 'NOT_concept_pink_cell_below_concept_no_pink_cell_below_m': 0.74, 'NOT_concept_wall_below_concept_no_pink_cell_below_m': 0.662, 'NOT_concept_target_on_top_NOT_concept_wall_top_right': 0.962, 'NOT_concept_target_on_top_concept_box_on_top': 0.0, 'NOT_concept_target_on_top_concept_no_wall_below_m': 0.568, 'NOT_concept_target_on_top_NOT_concept_wall_on_left': 0.668, 'NOT_concept_target_on_top_concept_wall_on_left_of_box': 0.212, 'NOT_concept_box_on_top_NOT_concept_target_on_top': 0.958, 'NOT_concept_target_on_top_concept_blank_cell_on_left': 0.524, 'NOT_concept_target_on_top_NOT_concept_wall_on_right': 0.7, 'NOT_concept_pink_cell_on_right_NOT_concept_target_on_top': 0.842, 'NOT_concept_box_on_left_NOT_concept_target_on_top': 0.954, 'NOT_concept_target_on_top_NOT_concept_wall_down_left': 0.894, 'NOT_concept_pink_cell_below_NOT_concept_target_on_top': 0.842, 'NOT_concept_target_on_top_NOT_concept_wall_below': 0.742, 'NOT_concept_wall_top_right_concept_box_on_top': 0.0, 'NOT_concept_wall_top_right_concept_no_wall_below_m': 0.604, 'NOT_concept_wall_on_left_NOT_concept_wall_top_right': 0.696, 'NOT_concept_wall_top_right_concept_wall_on_left_of_box': 0.208, 'NOT_concept_box_on_top_NOT_concept_wall_top_right': 1.0, 'NOT_concept_wall_top_right_concept_blank_cell_on_left': 0.564, 'NOT_concept_wall_on_right_NOT_concept_wall_top_right': 0.744, 'NOT_concept_pink_cell_on_right_NOT_concept_wall_top_right': 0.884, 'NOT_concept_box_on_left_NOT_concept_wall_top_right': 1.0, 'NOT_concept_wall_down_left_NOT_concept_wall_top_right': 0.93, 'NOT_concept_pink_cell_below_NOT_concept_wall_top_right': 0.892, 'NOT_concept_wall_below_NOT_concept_wall_top_right': 0.784, 'concept_box_on_top_concept_no_wall_below_m': 0.0, 'NOT_concept_wall_on_left_concept_box_on_top': 0.0, 'concept_box_on_top_concept_wall_on_left_of_box': 0.0, 'NOT_concept_box_on_top_concept_box_on_top': 0.0, 'concept_blank_cell_on_left_concept_box_on_top': 0.0, 'NOT_concept_wall_on_right_concept_box_on_top': 0.0, 'NOT_concept_pink_cell_on_right_concept_box_on_top': 0.0, 'NOT_concept_box_on_left_concept_box_on_top': 0.0, 'NOT_concept_wall_down_left_concept_box_on_top': 0.0, 'NOT_concept_pink_cell_below_concept_box_on_top': 0.0, 'NOT_concept_wall_below_concept_box_on_top': 0.0, 'NOT_concept_wall_on_left_concept_no_wall_below_m': 0.446, 'concept_no_wall_below_m_concept_wall_on_left_of_box': 0.134, 'NOT_concept_box_on_top_concept_no_wall_below_m': 0.612, 'concept_blank_cell_on_left_concept_no_wall_below_m': 0.306, 'NOT_concept_wall_on_right_concept_no_wall_below_m': 0.484, 'NOT_concept_pink_cell_on_right_concept_no_wall_below_m': 0.49, 'NOT_concept_box_on_left_concept_no_wall_below_m': 0.634, 'NOT_concept_wall_down_left_concept_no_wall_below_m': 0.608, 'NOT_concept_pink_cell_below_concept_no_wall_below_m': 0.484, 'NOT_concept_wall_below_concept_no_wall_below_m': 0.606, 'NOT_concept_wall_on_left_concept_wall_on_left_of_box': 0.156, 'NOT_concept_box_on_top_NOT_concept_wall_on_left': 0.706, 'NOT_concept_wall_on_left_concept_blank_cell_on_left': 0.562, 'NOT_concept_wall_on_left_NOT_concept_wall_on_right': 0.442, 'NOT_concept_pink_cell_on_right_NOT_concept_wall_on_left': 0.69, 'NOT_concept_box_on_left_NOT_concept_wall_on_left': 0.684, 'NOT_concept_wall_down_left_NOT_concept_wall_on_left': 0.706, 'NOT_concept_pink_cell_below_NOT_concept_wall_on_left': 0.564, 'NOT_concept_wall_below_NOT_concept_wall_on_left': 0.548, 'NOT_concept_box_on_top_concept_wall_on_left_of_box': 0.206, 'concept_blank_cell_on_left_concept_wall_on_left_of_box': 0.126, 'NOT_concept_wall_on_right_concept_wall_on_left_of_box': 0.134, 'NOT_concept_pink_cell_on_right_concept_wall_on_left_of_box': 0.184, 'NOT_concept_box_on_left_concept_wall_on_left_of_box': 0.214, 'NOT_concept_wall_down_left_concept_wall_on_left_of_box': 0.196, 'NOT_concept_pink_cell_below_concept_wall_on_left_of_box': 0.188, 'NOT_concept_wall_below_concept_wall_on_left_of_box': 0.17, 'NOT_concept_box_on_top_concept_blank_cell_on_left': 0.554, 'NOT_concept_box_on_top_NOT_concept_wall_on_right': 0.73, 'NOT_concept_box_on_top_NOT_concept_pink_cell_on_right': 0.89, 'NOT_concept_box_on_left_NOT_concept_box_on_top': 1.0, 'NOT_concept_box_on_top_NOT_concept_wall_down_left': 0.938, 'NOT_concept_box_on_top_NOT_concept_pink_cell_below': 0.886, 'NOT_concept_box_on_top_NOT_concept_wall_below': 0.774, 'NOT_concept_wall_on_right_concept_blank_cell_on_left': 0.388, 'NOT_concept_pink_cell_on_right_concept_blank_cell_on_left': 0.574, 'NOT_concept_box_on_left_concept_blank_cell_on_left': 0.56, 'NOT_concept_wall_down_left_concept_blank_cell_on_left': 0.56, 'NOT_concept_pink_cell_below_concept_blank_cell_on_left': 0.44, 'NOT_concept_wall_below_concept_blank_cell_on_left': 0.394, 'NOT_concept_pink_cell_on_right_NOT_concept_wall_on_right': 0.624, 'NOT_concept_box_on_left_NOT_concept_wall_on_right': 0.73, 'NOT_concept_wall_down_left_NOT_concept_wall_on_right': 0.676, 'NOT_concept_pink_cell_below_NOT_concept_wall_on_right': 0.614, 'NOT_concept_wall_below_NOT_concept_wall_on_right': 0.594, 'NOT_concept_box_on_left_NOT_concept_pink_cell_on_right': 0.894, 'NOT_concept_pink_cell_on_right_NOT_concept_wall_down_left': 0.816, 'NOT_concept_pink_cell_below_NOT_concept_pink_cell_on_right': 0.746, 'NOT_concept_pink_cell_on_right_NOT_concept_wall_below': 0.648, 'NOT_concept_box_on_left_NOT_concept_wall_down_left': 0.936, 'NOT_concept_box_on_left_NOT_concept_pink_cell_below': 0.882, 'NOT_concept_box_on_left_NOT_concept_wall_below': 0.774, 'NOT_concept_pink_cell_below_NOT_concept_wall_down_left': 0.832, 'NOT_concept_wall_below_NOT_concept_wall_down_left': 0.752, 'NOT_concept_pink_cell_below_NOT_concept_wall_below': 0.652}, 4: {'NOT_concept_wall_down_right': 1.0, 'NOT_concept_no_pink_cell_on_top_m': 0.2, 'NOT_concept_wall_top_right': 1.0, 'NOT_concept_target_on_right': 1.0, 'NOT_concept_pink_cell_on_right': 0.8, 'NOT_concept_wall_below': 0.8, 'concept_blank_cell_on_left': 0.5333333333333333, 'concept_no_wall_below_m': 0.6666666666666666, 'NOT_concept_wall_below_box': 0.8, 'concept_no_wall_on_right_m': 1.0, 'NOT_concept_wall_top_left': 0.9333333333333333, 'NOT_concept_wall_up_down_right': 1.0, 'NOT_concept_target_on_top': 0.9333333333333333, 'NOT_concept_box_on_top': 1.0, 'NOT_concept_wall_on_right_of_box': 1.0, 'NOT_concept_on_pink_cell': 0.8, 'NOT_concept_wall_on_left': 0.5333333333333333, 'NOT_concept_no_wall_on_top_m': 0.4, 'concept_blank_cell_below': 0.6666666666666666, 'concept_wall_on_top': 0.2, 'concept_no_pink_cell_below_m': 0.6666666666666666, 'NOT_concept_wall_on_left_of_box': 1.0, 'NOT_concept_no_wall_on_left_m': 0.8, 'NOT_concept_box_below': 1.0, 'NOT_concept_wall_down_left': 0.9333333333333333, 'concept_wall_above_box': 0.3333333333333333, 'NOT_concept_pink_cell_on_left': 1.0, 'NOT_concept_box_on_right': 1.0, 'NOT_concept_box_on_left': 1.0, 'NOT_concept_pink_cell_on_top': 1.0, 'NOT_concept_wall_on_right': 1.0, 'NOT_concept_pink_cell_below': 0.8666666666666667, 'concept_pink_cell_on_right': 0.21428571428571427, 'concept_pink_cell_on_left': 0.0, 'concept_wall_top_right': 0.0, 'concept_box_below': 0.0, 'concept_box_on_right': 0.0, 'concept_no_wall_on_left_m': 0.21428571428571427, 'concept_wall_down_right': 0.0, 'NOT_concept_wall_on_top': 0.8571428571428571, 'NOT_concept_no_wall_on_right_m': 0.0, 'concept_wall_top_left': 0.07142857142857142, 'concept_target_on_right': 0.0, 'NOT_concept_blank_cell_below': 0.35714285714285715, 'concept_wall_below': 0.21428571428571427, 'NOT_concept_wall_above_box': 0.7142857142857143, 'concept_pink_cell_on_top': 0.0, 'concept_on_pink_cell': 0.21428571428571427, 'concept_target_on_top': 0.07142857142857142, 'concept_wall_down_left': 0.07142857142857142, 'concept_wall_on_left': 0.5, 'NOT_concept_no_pink_cell_below_m': 0.35714285714285715, 'concept_wall_up_down_right': 0.0, 'concept_wall_on_right_of_box': 0.0, 'concept_box_on_left': 0.0, 'concept_no_wall_on_top_m': 0.6428571428571429, 'concept_no_pink_cell_on_top_m': 0.8571428571428571, 'NOT_concept_no_wall_below_m': 0.35714285714285715, 'concept_wall_below_box': 0.21428571428571427, 'concept_wall_on_right': 0.0, 'concept_pink_cell_below': 0.14285714285714285, 'NOT_concept_blank_cell_on_left': 0.5, 'concept_box_on_top': 0.0, 'concept_wall_on_left_of_box': 0.0, 'concept_blank_cell_below_concept_pink_cell_on_right': 0.21428571428571427, 'concept_pink_cell_on_left_concept_pink_cell_on_right': 0.0, 'concept_pink_cell_on_right_concept_wall_top_right': 0.0, 'concept_box_below_concept_pink_cell_on_right': 0.0, 'NOT_concept_wall_down_right_concept_pink_cell_on_right': 0.21428571428571427, 'concept_box_on_right_concept_pink_cell_on_right': 0.0, 'NOT_concept_wall_on_left_of_box_concept_pink_cell_on_right': 0.21428571428571427, 'NOT_concept_wall_up_down_right_concept_pink_cell_on_right': 0.21428571428571427, 'concept_no_wall_on_left_m_concept_pink_cell_on_right': 0.0, 'concept_pink_cell_on_right_concept_wall_down_right': 0.0, 'NOT_concept_pink_cell_on_left_concept_pink_cell_on_right': 0.21428571428571427, 'NOT_concept_wall_below_box_concept_pink_cell_on_right': 0.21428571428571427, 'NOT_concept_wall_on_top_concept_pink_cell_on_right': 0.21428571428571427, 'NOT_concept_no_wall_on_right_m_concept_pink_cell_on_right': 0.0, 'NOT_concept_on_pink_cell_concept_pink_cell_on_right': 0.0, 'NOT_concept_box_on_right_concept_pink_cell_on_right': 0.21428571428571427, 'concept_pink_cell_on_right_concept_wall_top_left': 0.0, 'concept_pink_cell_on_right_concept_target_on_right': 0.0, 'NOT_concept_blank_cell_below_concept_pink_cell_on_right': 0.0, 'concept_no_wall_on_right_m_concept_pink_cell_on_right': 0.21428571428571427, 'concept_pink_cell_on_right_concept_wall_below': 0.0, 'NOT_concept_no_wall_on_left_m_concept_pink_cell_on_right': 0.21428571428571427, 'NOT_concept_wall_top_left_concept_pink_cell_on_right': 0.21428571428571427, 'NOT_concept_box_below_concept_pink_cell_on_right': 0.21428571428571427, 'NOT_concept_wall_above_box_concept_pink_cell_on_right': 0.21428571428571427, 'concept_pink_cell_on_right_concept_pink_cell_on_top': 0.0, 'NOT_concept_no_pink_cell_on_top_m_concept_pink_cell_on_right': 0.0, 'NOT_concept_wall_on_right_of_box_concept_pink_cell_on_right': 0.21428571428571427, 'NOT_concept_no_wall_on_top_m_concept_pink_cell_on_right': 0.0, 'concept_on_pink_cell_concept_pink_cell_on_right': 0.21428571428571427, 'concept_pink_cell_on_right_concept_target_on_top': 0.0, 'concept_pink_cell_on_right_concept_wall_down_left': 0.0, 'concept_pink_cell_on_right_concept_wall_on_left': 0.21428571428571427, 'NOT_concept_no_pink_cell_below_m_concept_pink_cell_on_right': 0.0, 'concept_pink_cell_on_right_concept_wall_up_down_right': 0.0, 'concept_pink_cell_on_right_concept_wall_on_top': 0.0, 'concept_pink_cell_on_right_concept_wall_above_box': 0.0, 'concept_pink_cell_on_right_concept_wall_on_right_of_box': 0.0, 'concept_box_on_left_concept_pink_cell_on_right': 0.0, 'concept_no_wall_on_top_m_concept_pink_cell_on_right': 0.21428571428571427, 'NOT_concept_pink_cell_on_top_concept_pink_cell_on_right': 0.21428571428571427, 'concept_no_pink_cell_on_top_m_concept_pink_cell_on_right': 0.21428571428571427, 'NOT_concept_no_wall_below_m_concept_pink_cell_on_right': 0.0, 'concept_pink_cell_on_right_concept_wall_below_box': 0.0, 'concept_pink_cell_on_right_concept_wall_on_right': 0.0, 'concept_pink_cell_below_concept_pink_cell_on_right': 0.0, 'NOT_concept_blank_cell_on_left_concept_pink_cell_on_right': 0.21428571428571427, 'NOT_concept_target_on_right_concept_pink_cell_on_right': 0.21428571428571427, 'concept_no_pink_cell_below_m_concept_pink_cell_on_right': 0.21428571428571427, 'NOT_concept_target_on_top_concept_pink_cell_on_right': 0.21428571428571427, 'NOT_concept_wall_top_right_concept_pink_cell_on_right': 0.21428571428571427, 'concept_box_on_top_concept_pink_cell_on_right': 0.0, 'concept_no_wall_below_m_concept_pink_cell_on_right': 0.21428571428571427, 'NOT_concept_wall_on_left_concept_pink_cell_on_right': 0.0, 'concept_pink_cell_on_right_concept_wall_on_left_of_box': 0.0, 'NOT_concept_box_on_top_concept_pink_cell_on_right': 0.21428571428571427, 'concept_blank_cell_on_left_concept_pink_cell_on_right': 0.0, 'NOT_concept_wall_on_right_concept_pink_cell_on_right': 0.21428571428571427, 'NOT_concept_pink_cell_on_right_concept_pink_cell_on_right': 0.0, 'NOT_concept_box_on_left_concept_pink_cell_on_right': 0.21428571428571427, 'NOT_concept_wall_down_left_concept_pink_cell_on_right': 0.21428571428571427, 'NOT_concept_pink_cell_below_concept_pink_cell_on_right': 0.21428571428571427, 'NOT_concept_wall_below_concept_pink_cell_on_right': 0.21428571428571427, 'concept_blank_cell_below_concept_pink_cell_on_left': 0.0, 'concept_blank_cell_below_concept_wall_top_right': 0.0, 'concept_blank_cell_below_concept_box_below': 0.0, 'NOT_concept_wall_down_right_concept_blank_cell_below': 0.6428571428571429, 'concept_blank_cell_below_concept_box_on_right': 0.0, 'NOT_concept_wall_on_left_of_box_concept_blank_cell_below': 0.6428571428571429, 'NOT_concept_wall_up_down_right_concept_blank_cell_below': 0.6428571428571429, 'concept_blank_cell_below_concept_no_wall_on_left_m': 0.07142857142857142, 'concept_blank_cell_below_concept_wall_down_right': 0.0, 'NOT_concept_pink_cell_on_left_concept_blank_cell_below': 0.6428571428571429, 'NOT_concept_wall_below_box_concept_blank_cell_below': 0.6428571428571429, 'NOT_concept_wall_on_top_concept_blank_cell_below': 0.5, 'NOT_concept_no_wall_on_right_m_concept_blank_cell_below': 0.0, 'NOT_concept_on_pink_cell_concept_blank_cell_below': 0.42857142857142855, 'NOT_concept_box_on_right_concept_blank_cell_below': 0.6428571428571429, 'concept_blank_cell_below_concept_wall_top_left': 0.07142857142857142, 'concept_blank_cell_below_concept_target_on_right': 0.0, 'NOT_concept_blank_cell_below_concept_blank_cell_below': 0.0, 'concept_blank_cell_below_concept_no_wall_on_right_m': 0.6428571428571429, 'concept_blank_cell_below_concept_wall_below': 0.0, 'NOT_concept_no_wall_on_left_m_concept_blank_cell_below': 0.5714285714285714, 'NOT_concept_wall_top_left_concept_blank_cell_below': 0.5714285714285714, 'NOT_concept_box_below_concept_blank_cell_below': 0.6428571428571429, 'NOT_concept_wall_above_box_concept_blank_cell_below': 0.42857142857142855, 'concept_blank_cell_below_concept_pink_cell_on_top': 0.0, 'NOT_concept_no_pink_cell_on_top_m_concept_blank_cell_below': 0.14285714285714285, 'NOT_concept_wall_on_right_of_box_concept_blank_cell_below': 0.6428571428571429, 'NOT_concept_no_wall_on_top_m_concept_blank_cell_below': 0.2857142857142857, 'concept_blank_cell_below_concept_on_pink_cell': 0.21428571428571427, 'concept_blank_cell_below_concept_target_on_top': 0.07142857142857142, 'concept_blank_cell_below_concept_wall_down_left': 0.0, 'concept_blank_cell_below_concept_wall_on_left': 0.42857142857142855, 'NOT_concept_no_pink_cell_below_m_concept_blank_cell_below': 0.0, 'concept_blank_cell_below_concept_wall_up_down_right': 0.0, 'concept_blank_cell_below_concept_wall_on_top': 0.14285714285714285, 'concept_blank_cell_below_concept_wall_above_box': 0.21428571428571427, 'concept_blank_cell_below_concept_wall_on_right_of_box': 0.0, 'concept_blank_cell_below_concept_box_on_left': 0.0, 'concept_blank_cell_below_concept_no_wall_on_top_m': 0.35714285714285715, 'NOT_concept_pink_cell_on_top_concept_blank_cell_below': 0.6428571428571429, 'concept_blank_cell_below_concept_no_pink_cell_on_top_m': 0.5, 'NOT_concept_no_wall_below_m_concept_blank_cell_below': 0.14285714285714285, 'concept_blank_cell_below_concept_wall_below_box': 0.0, 'concept_blank_cell_below_concept_wall_on_right': 0.0, 'concept_blank_cell_below_concept_pink_cell_below': 0.0, 'NOT_concept_blank_cell_on_left_concept_blank_cell_below': 0.42857142857142855, 'NOT_concept_target_on_right_concept_blank_cell_below': 0.6428571428571429, 'concept_blank_cell_below_concept_no_pink_cell_below_m': 0.6428571428571429, 'NOT_concept_target_on_top_concept_blank_cell_below': 0.5714285714285714, 'NOT_concept_wall_top_right_concept_blank_cell_below': 0.6428571428571429, 'concept_blank_cell_below_concept_box_on_top': 0.0, 'concept_blank_cell_below_concept_no_wall_below_m': 0.5, 'NOT_concept_wall_on_left_concept_blank_cell_below': 0.21428571428571427, 'concept_blank_cell_below_concept_wall_on_left_of_box': 0.0, 'NOT_concept_box_on_top_concept_blank_cell_below': 0.6428571428571429, 'concept_blank_cell_below_concept_blank_cell_on_left': 0.21428571428571427, 'NOT_concept_wall_on_right_concept_blank_cell_below': 0.6428571428571429, 'NOT_concept_pink_cell_on_right_concept_blank_cell_below': 0.42857142857142855, 'NOT_concept_box_on_left_concept_blank_cell_below': 0.6428571428571429, 'NOT_concept_wall_down_left_concept_blank_cell_below': 0.6428571428571429, 'NOT_concept_pink_cell_below_concept_blank_cell_below': 0.6428571428571429, 'NOT_concept_wall_below_concept_blank_cell_below': 0.6428571428571429, 'concept_pink_cell_on_left_concept_wall_top_right': 0.0, 'concept_box_below_concept_pink_cell_on_left': 0.0, 'NOT_concept_wall_down_right_concept_pink_cell_on_left': 0.0, 'concept_box_on_right_concept_pink_cell_on_left': 0.0, 'NOT_concept_wall_on_left_of_box_concept_pink_cell_on_left': 0.0, 'NOT_concept_wall_up_down_right_concept_pink_cell_on_left': 0.0, 'concept_no_wall_on_left_m_concept_pink_cell_on_left': 0.0, 'concept_pink_cell_on_left_concept_wall_down_right': 0.0, 'NOT_concept_pink_cell_on_left_concept_pink_cell_on_left': 0.0, 'NOT_concept_wall_below_box_concept_pink_cell_on_left': 0.0, 'NOT_concept_wall_on_top_concept_pink_cell_on_left': 0.0, 'NOT_concept_no_wall_on_right_m_concept_pink_cell_on_left': 0.0, 'NOT_concept_on_pink_cell_concept_pink_cell_on_left': 0.0, 'NOT_concept_box_on_right_concept_pink_cell_on_left': 0.0, 'concept_pink_cell_on_left_concept_wall_top_left': 0.0, 'concept_pink_cell_on_left_concept_target_on_right': 0.0, 'NOT_concept_blank_cell_below_concept_pink_cell_on_left': 0.0, 'concept_no_wall_on_right_m_concept_pink_cell_on_left': 0.0, 'concept_pink_cell_on_left_concept_wall_below': 0.0, 'NOT_concept_no_wall_on_left_m_concept_pink_cell_on_left': 0.0, 'NOT_concept_wall_top_left_concept_pink_cell_on_left': 0.0, 'NOT_concept_box_below_concept_pink_cell_on_left': 0.0, 'NOT_concept_wall_above_box_concept_pink_cell_on_left': 0.0, 'concept_pink_cell_on_left_concept_pink_cell_on_top': 0.0, 'NOT_concept_no_pink_cell_on_top_m_concept_pink_cell_on_left': 0.0, 'NOT_concept_wall_on_right_of_box_concept_pink_cell_on_left': 0.0, 'NOT_concept_no_wall_on_top_m_concept_pink_cell_on_left': 0.0, 'concept_on_pink_cell_concept_pink_cell_on_left': 0.0, 'concept_pink_cell_on_left_concept_target_on_top': 0.0, 'concept_pink_cell_on_left_concept_wall_down_left': 0.0, 'concept_pink_cell_on_left_concept_wall_on_left': 0.0, 'NOT_concept_no_pink_cell_below_m_concept_pink_cell_on_left': 0.0, 'concept_pink_cell_on_left_concept_wall_up_down_right': 0.0, 'concept_pink_cell_on_left_concept_wall_on_top': 0.0, 'concept_pink_cell_on_left_concept_wall_above_box': 0.0, 'concept_pink_cell_on_left_concept_wall_on_right_of_box': 0.0, 'concept_box_on_left_concept_pink_cell_on_left': 0.0, 'concept_no_wall_on_top_m_concept_pink_cell_on_left': 0.0, 'NOT_concept_pink_cell_on_top_concept_pink_cell_on_left': 0.0, 'concept_no_pink_cell_on_top_m_concept_pink_cell_on_left': 0.0, 'NOT_concept_no_wall_below_m_concept_pink_cell_on_left': 0.0, 'concept_pink_cell_on_left_concept_wall_below_box': 0.0, 'concept_pink_cell_on_left_concept_wall_on_right': 0.0, 'concept_pink_cell_below_concept_pink_cell_on_left': 0.0, 'NOT_concept_blank_cell_on_left_concept_pink_cell_on_left': 0.0, 'NOT_concept_target_on_right_concept_pink_cell_on_left': 0.0, 'concept_no_pink_cell_below_m_concept_pink_cell_on_left': 0.0, 'NOT_concept_target_on_top_concept_pink_cell_on_left': 0.0, 'NOT_concept_wall_top_right_concept_pink_cell_on_left': 0.0, 'concept_box_on_top_concept_pink_cell_on_left': 0.0, 'concept_no_wall_below_m_concept_pink_cell_on_left': 0.0, 'NOT_concept_wall_on_left_concept_pink_cell_on_left': 0.0, 'concept_pink_cell_on_left_concept_wall_on_left_of_box': 0.0, 'NOT_concept_box_on_top_concept_pink_cell_on_left': 0.0, 'concept_blank_cell_on_left_concept_pink_cell_on_left': 0.0, 'NOT_concept_wall_on_right_concept_pink_cell_on_left': 0.0, 'NOT_concept_pink_cell_on_right_concept_pink_cell_on_left': 0.0, 'NOT_concept_box_on_left_concept_pink_cell_on_left': 0.0, 'NOT_concept_wall_down_left_concept_pink_cell_on_left': 0.0, 'NOT_concept_pink_cell_below_concept_pink_cell_on_left': 0.0, 'NOT_concept_wall_below_concept_pink_cell_on_left': 0.0, 'concept_box_below_concept_wall_top_right': 0.0, 'NOT_concept_wall_down_right_concept_wall_top_right': 0.0, 'concept_box_on_right_concept_wall_top_right': 0.0, 'NOT_concept_wall_on_left_of_box_concept_wall_top_right': 0.0, 'NOT_concept_wall_up_down_right_concept_wall_top_right': 0.0, 'concept_no_wall_on_left_m_concept_wall_top_right': 0.0, 'concept_wall_down_right_concept_wall_top_right': 0.0, 'NOT_concept_pink_cell_on_left_concept_wall_top_right': 0.0, 'NOT_concept_wall_below_box_concept_wall_top_right': 0.0, 'NOT_concept_wall_on_top_concept_wall_top_right': 0.0, 'NOT_concept_no_wall_on_right_m_concept_wall_top_right': 0.0, 'NOT_concept_on_pink_cell_concept_wall_top_right': 0.0, 'NOT_concept_box_on_right_concept_wall_top_right': 0.0, 'concept_wall_top_left_concept_wall_top_right': 0.0, 'concept_target_on_right_concept_wall_top_right': 0.0, 'NOT_concept_blank_cell_below_concept_wall_top_right': 0.0, 'concept_no_wall_on_right_m_concept_wall_top_right': 0.0, 'concept_wall_below_concept_wall_top_right': 0.0, 'NOT_concept_no_wall_on_left_m_concept_wall_top_right': 0.0, 'NOT_concept_wall_top_left_concept_wall_top_right': 0.0, 'NOT_concept_box_below_concept_wall_top_right': 0.0, 'NOT_concept_wall_above_box_concept_wall_top_right': 0.0, 'concept_pink_cell_on_top_concept_wall_top_right': 0.0, 'NOT_concept_no_pink_cell_on_top_m_concept_wall_top_right': 0.0, 'NOT_concept_wall_on_right_of_box_concept_wall_top_right': 0.0, 'NOT_concept_no_wall_on_top_m_concept_wall_top_right': 0.0, 'concept_on_pink_cell_concept_wall_top_right': 0.0, 'concept_target_on_top_concept_wall_top_right': 0.0, 'concept_wall_down_left_concept_wall_top_right': 0.0, 'concept_wall_on_left_concept_wall_top_right': 0.0, 'NOT_concept_no_pink_cell_below_m_concept_wall_top_right': 0.0, 'concept_wall_top_right_concept_wall_up_down_right': 0.0, 'concept_wall_on_top_concept_wall_top_right': 0.0, 'concept_wall_above_box_concept_wall_top_right': 0.0, 'concept_wall_on_right_of_box_concept_wall_top_right': 0.0, 'concept_box_on_left_concept_wall_top_right': 0.0, 'concept_no_wall_on_top_m_concept_wall_top_right': 0.0, 'NOT_concept_pink_cell_on_top_concept_wall_top_right': 0.0, 'concept_no_pink_cell_on_top_m_concept_wall_top_right': 0.0, 'NOT_concept_no_wall_below_m_concept_wall_top_right': 0.0, 'concept_wall_below_box_concept_wall_top_right': 0.0, 'concept_wall_on_right_concept_wall_top_right': 0.0, 'concept_pink_cell_below_concept_wall_top_right': 0.0, 'NOT_concept_blank_cell_on_left_concept_wall_top_right': 0.0, 'NOT_concept_target_on_right_concept_wall_top_right': 0.0, 'concept_no_pink_cell_below_m_concept_wall_top_right': 0.0, 'NOT_concept_target_on_top_concept_wall_top_right': 0.0, 'NOT_concept_wall_top_right_concept_wall_top_right': 0.0, 'concept_box_on_top_concept_wall_top_right': 0.0, 'concept_no_wall_below_m_concept_wall_top_right': 0.0, 'NOT_concept_wall_on_left_concept_wall_top_right': 0.0, 'concept_wall_on_left_of_box_concept_wall_top_right': 0.0, 'NOT_concept_box_on_top_concept_wall_top_right': 0.0, 'concept_blank_cell_on_left_concept_wall_top_right': 0.0, 'NOT_concept_wall_on_right_concept_wall_top_right': 0.0, 'NOT_concept_pink_cell_on_right_concept_wall_top_right': 0.0, 'NOT_concept_box_on_left_concept_wall_top_right': 0.0, 'NOT_concept_wall_down_left_concept_wall_top_right': 0.0, 'NOT_concept_pink_cell_below_concept_wall_top_right': 0.0, 'NOT_concept_wall_below_concept_wall_top_right': 0.0, 'NOT_concept_wall_down_right_concept_box_below': 0.0, 'concept_box_below_concept_box_on_right': 0.0, 'NOT_concept_wall_on_left_of_box_concept_box_below': 0.0, 'NOT_concept_wall_up_down_right_concept_box_below': 0.0, 'concept_box_below_concept_no_wall_on_left_m': 0.0, 'concept_box_below_concept_wall_down_right': 0.0, 'NOT_concept_pink_cell_on_left_concept_box_below': 0.0, 'NOT_concept_wall_below_box_concept_box_below': 0.0, 'NOT_concept_wall_on_top_concept_box_below': 0.0, 'NOT_concept_no_wall_on_right_m_concept_box_below': 0.0, 'NOT_concept_on_pink_cell_concept_box_below': 0.0, 'NOT_concept_box_on_right_concept_box_below': 0.0, 'concept_box_below_concept_wall_top_left': 0.0, 'concept_box_below_concept_target_on_right': 0.0, 'NOT_concept_blank_cell_below_concept_box_below': 0.0, 'concept_box_below_concept_no_wall_on_right_m': 0.0, 'concept_box_below_concept_wall_below': 0.0, 'NOT_concept_no_wall_on_left_m_concept_box_below': 0.0, 'NOT_concept_wall_top_left_concept_box_below': 0.0, 'NOT_concept_box_below_concept_box_below': 0.0, 'NOT_concept_wall_above_box_concept_box_below': 0.0, 'concept_box_below_concept_pink_cell_on_top': 0.0, 'NOT_concept_no_pink_cell_on_top_m_concept_box_below': 0.0, 'NOT_concept_wall_on_right_of_box_concept_box_below': 0.0, 'NOT_concept_no_wall_on_top_m_concept_box_below': 0.0, 'concept_box_below_concept_on_pink_cell': 0.0, 'concept_box_below_concept_target_on_top': 0.0, 'concept_box_below_concept_wall_down_left': 0.0, 'concept_box_below_concept_wall_on_left': 0.0, 'NOT_concept_no_pink_cell_below_m_concept_box_below': 0.0, 'concept_box_below_concept_wall_up_down_right': 0.0, 'concept_box_below_concept_wall_on_top': 0.0, 'concept_box_below_concept_wall_above_box': 0.0, 'concept_box_below_concept_wall_on_right_of_box': 0.0, 'concept_box_below_concept_box_on_left': 0.0, 'concept_box_below_concept_no_wall_on_top_m': 0.0, 'NOT_concept_pink_cell_on_top_concept_box_below': 0.0, 'concept_box_below_concept_no_pink_cell_on_top_m': 0.0, 'NOT_concept_no_wall_below_m_concept_box_below': 0.0, 'concept_box_below_concept_wall_below_box': 0.0, 'concept_box_below_concept_wall_on_right': 0.0, 'concept_box_below_concept_pink_cell_below': 0.0, 'NOT_concept_blank_cell_on_left_concept_box_below': 0.0, 'NOT_concept_target_on_right_concept_box_below': 0.0, 'concept_box_below_concept_no_pink_cell_below_m': 0.0, 'NOT_concept_target_on_top_concept_box_below': 0.0, 'NOT_concept_wall_top_right_concept_box_below': 0.0, 'concept_box_below_concept_box_on_top': 0.0, 'concept_box_below_concept_no_wall_below_m': 0.0, 'NOT_concept_wall_on_left_concept_box_below': 0.0, 'concept_box_below_concept_wall_on_left_of_box': 0.0, 'NOT_concept_box_on_top_concept_box_below': 0.0, 'concept_blank_cell_on_left_concept_box_below': 0.0, 'NOT_concept_wall_on_right_concept_box_below': 0.0, 'NOT_concept_pink_cell_on_right_concept_box_below': 0.0, 'NOT_concept_box_on_left_concept_box_below': 0.0, 'NOT_concept_wall_down_left_concept_box_below': 0.0, 'NOT_concept_pink_cell_below_concept_box_below': 0.0, 'NOT_concept_wall_below_concept_box_below': 0.0, 'NOT_concept_wall_down_right_concept_box_on_right': 0.0, 'NOT_concept_wall_down_right_NOT_concept_wall_on_left_of_box': 1.0, 'NOT_concept_wall_down_right_NOT_concept_wall_up_down_right': 1.0, 'NOT_concept_wall_down_right_concept_no_wall_on_left_m': 0.21428571428571427, 'NOT_concept_wall_down_right_concept_wall_down_right': 0.0, 'NOT_concept_pink_cell_on_left_NOT_concept_wall_down_right': 1.0, 'NOT_concept_wall_below_box_NOT_concept_wall_down_right': 0.7857142857142857, 'NOT_concept_wall_down_right_NOT_concept_wall_on_top': 0.8571428571428571, 'NOT_concept_no_wall_on_right_m_NOT_concept_wall_down_right': 0.0, 'NOT_concept_on_pink_cell_NOT_concept_wall_down_right': 0.7857142857142857, 'NOT_concept_box_on_right_NOT_concept_wall_down_right': 1.0, 'NOT_concept_wall_down_right_concept_wall_top_left': 0.07142857142857142, 'NOT_concept_wall_down_right_concept_target_on_right': 0.0, 'NOT_concept_blank_cell_below_NOT_concept_wall_down_right': 0.35714285714285715, 'NOT_concept_wall_down_right_concept_no_wall_on_right_m': 1.0, 'NOT_concept_wall_down_right_concept_wall_below': 0.21428571428571427, 'NOT_concept_no_wall_on_left_m_NOT_concept_wall_down_right': 0.7857142857142857, 'NOT_concept_wall_down_right_NOT_concept_wall_top_left': 0.9285714285714286, 'NOT_concept_box_below_NOT_concept_wall_down_right': 1.0, 'NOT_concept_wall_above_box_NOT_concept_wall_down_right': 0.7142857142857143, 'NOT_concept_wall_down_right_concept_pink_cell_on_top': 0.0, 'NOT_concept_no_pink_cell_on_top_m_NOT_concept_wall_down_right': 0.14285714285714285, 'NOT_concept_wall_down_right_NOT_concept_wall_on_right_of_box': 1.0, 'NOT_concept_no_wall_on_top_m_NOT_concept_wall_down_right': 0.35714285714285715, 'NOT_concept_wall_down_right_concept_on_pink_cell': 0.21428571428571427, 'NOT_concept_wall_down_right_concept_target_on_top': 0.07142857142857142, 'NOT_concept_wall_down_right_concept_wall_down_left': 0.07142857142857142, 'NOT_concept_wall_down_right_concept_wall_on_left': 0.5, 'NOT_concept_no_pink_cell_below_m_NOT_concept_wall_down_right': 0.35714285714285715, 'NOT_concept_wall_down_right_concept_wall_up_down_right': 0.0, 'NOT_concept_wall_down_right_concept_wall_on_top': 0.14285714285714285, 'NOT_concept_wall_down_right_concept_wall_above_box': 0.2857142857142857, 'NOT_concept_wall_down_right_concept_wall_on_right_of_box': 0.0, 'NOT_concept_wall_down_right_concept_box_on_left': 0.0, 'NOT_concept_wall_down_right_concept_no_wall_on_top_m': 0.6428571428571429, 'NOT_concept_pink_cell_on_top_NOT_concept_wall_down_right': 1.0, 'NOT_concept_wall_down_right_concept_no_pink_cell_on_top_m': 0.8571428571428571, 'NOT_concept_no_wall_below_m_NOT_concept_wall_down_right': 0.35714285714285715, 'NOT_concept_wall_down_right_concept_wall_below_box': 0.21428571428571427, 'NOT_concept_wall_down_right_concept_wall_on_right': 0.0, 'NOT_concept_wall_down_right_concept_pink_cell_below': 0.14285714285714285, 'NOT_concept_blank_cell_on_left_NOT_concept_wall_down_right': 0.5, 'NOT_concept_target_on_right_NOT_concept_wall_down_right': 1.0, 'NOT_concept_wall_down_right_concept_no_pink_cell_below_m': 0.6428571428571429, 'NOT_concept_target_on_top_NOT_concept_wall_down_right': 0.9285714285714286, 'NOT_concept_wall_down_right_NOT_concept_wall_top_right': 1.0, 'NOT_concept_wall_down_right_concept_box_on_top': 0.0, 'NOT_concept_wall_down_right_concept_no_wall_below_m': 0.6428571428571429, 'NOT_concept_wall_down_right_NOT_concept_wall_on_left': 0.5, 'NOT_concept_wall_down_right_concept_wall_on_left_of_box': 0.0, 'NOT_concept_box_on_top_NOT_concept_wall_down_right': 1.0, 'NOT_concept_wall_down_right_concept_blank_cell_on_left': 0.5, 'NOT_concept_wall_down_right_NOT_concept_wall_on_right': 1.0, 'NOT_concept_pink_cell_on_right_NOT_concept_wall_down_right': 0.7857142857142857, 'NOT_concept_box_on_left_NOT_concept_wall_down_right': 1.0, 'NOT_concept_wall_down_left_NOT_concept_wall_down_right': 0.9285714285714286, 'NOT_concept_pink_cell_below_NOT_concept_wall_down_right': 0.8571428571428571, 'NOT_concept_wall_below_NOT_concept_wall_down_right': 0.7857142857142857, 'NOT_concept_wall_on_left_of_box_concept_box_on_right': 0.0, 'NOT_concept_wall_up_down_right_concept_box_on_right': 0.0, 'concept_box_on_right_concept_no_wall_on_left_m': 0.0, 'concept_box_on_right_concept_wall_down_right': 0.0, 'NOT_concept_pink_cell_on_left_concept_box_on_right': 0.0, 'NOT_concept_wall_below_box_concept_box_on_right': 0.0, 'NOT_concept_wall_on_top_concept_box_on_right': 0.0, 'NOT_concept_no_wall_on_right_m_concept_box_on_right': 0.0, 'NOT_concept_on_pink_cell_concept_box_on_right': 0.0, 'NOT_concept_box_on_right_concept_box_on_right': 0.0, 'concept_box_on_right_concept_wall_top_left': 0.0, 'concept_box_on_right_concept_target_on_right': 0.0, 'NOT_concept_blank_cell_below_concept_box_on_right': 0.0, 'concept_box_on_right_concept_no_wall_on_right_m': 0.0, 'concept_box_on_right_concept_wall_below': 0.0, 'NOT_concept_no_wall_on_left_m_concept_box_on_right': 0.0, 'NOT_concept_wall_top_left_concept_box_on_right': 0.0, 'NOT_concept_box_below_concept_box_on_right': 0.0, 'NOT_concept_wall_above_box_concept_box_on_right': 0.0, 'concept_box_on_right_concept_pink_cell_on_top': 0.0, 'NOT_concept_no_pink_cell_on_top_m_concept_box_on_right': 0.0, 'NOT_concept_wall_on_right_of_box_concept_box_on_right': 0.0, 'NOT_concept_no_wall_on_top_m_concept_box_on_right': 0.0, 'concept_box_on_right_concept_on_pink_cell': 0.0, 'concept_box_on_right_concept_target_on_top': 0.0, 'concept_box_on_right_concept_wall_down_left': 0.0, 'concept_box_on_right_concept_wall_on_left': 0.0, 'NOT_concept_no_pink_cell_below_m_concept_box_on_right': 0.0, 'concept_box_on_right_concept_wall_up_down_right': 0.0, 'concept_box_on_right_concept_wall_on_top': 0.0, 'concept_box_on_right_concept_wall_above_box': 0.0, 'concept_box_on_right_concept_wall_on_right_of_box': 0.0, 'concept_box_on_left_concept_box_on_right': 0.0, 'concept_box_on_right_concept_no_wall_on_top_m': 0.0, 'NOT_concept_pink_cell_on_top_concept_box_on_right': 0.0, 'concept_box_on_right_concept_no_pink_cell_on_top_m': 0.0, 'NOT_concept_no_wall_below_m_concept_box_on_right': 0.0, 'concept_box_on_right_concept_wall_below_box': 0.0, 'concept_box_on_right_concept_wall_on_right': 0.0, 'concept_box_on_right_concept_pink_cell_below': 0.0, 'NOT_concept_blank_cell_on_left_concept_box_on_right': 0.0, 'NOT_concept_target_on_right_concept_box_on_right': 0.0, 'concept_box_on_right_concept_no_pink_cell_below_m': 0.0, 'NOT_concept_target_on_top_concept_box_on_right': 0.0, 'NOT_concept_wall_top_right_concept_box_on_right': 0.0, 'concept_box_on_right_concept_box_on_top': 0.0, 'concept_box_on_right_concept_no_wall_below_m': 0.0, 'NOT_concept_wall_on_left_concept_box_on_right': 0.0, 'concept_box_on_right_concept_wall_on_left_of_box': 0.0, 'NOT_concept_box_on_top_concept_box_on_right': 0.0, 'concept_blank_cell_on_left_concept_box_on_right': 0.0, 'NOT_concept_wall_on_right_concept_box_on_right': 0.0, 'NOT_concept_pink_cell_on_right_concept_box_on_right': 0.0, 'NOT_concept_box_on_left_concept_box_on_right': 0.0, 'NOT_concept_wall_down_left_concept_box_on_right': 0.0, 'NOT_concept_pink_cell_below_concept_box_on_right': 0.0, 'NOT_concept_wall_below_concept_box_on_right': 0.0, 'NOT_concept_wall_on_left_of_box_NOT_concept_wall_up_down_right': 1.0, 'NOT_concept_wall_on_left_of_box_concept_no_wall_on_left_m': 0.21428571428571427, 'NOT_concept_wall_on_left_of_box_concept_wall_down_right': 0.0, 'NOT_concept_pink_cell_on_left_NOT_concept_wall_on_left_of_box': 1.0, 'NOT_concept_wall_below_box_NOT_concept_wall_on_left_of_box': 0.7857142857142857, 'NOT_concept_wall_on_left_of_box_NOT_concept_wall_on_top': 0.8571428571428571, 'NOT_concept_no_wall_on_right_m_NOT_concept_wall_on_left_of_box': 0.0, 'NOT_concept_on_pink_cell_NOT_concept_wall_on_left_of_box': 0.7857142857142857, 'NOT_concept_box_on_right_NOT_concept_wall_on_left_of_box': 1.0, 'NOT_concept_wall_on_left_of_box_concept_wall_top_left': 0.07142857142857142, 'NOT_concept_wall_on_left_of_box_concept_target_on_right': 0.0, 'NOT_concept_blank_cell_below_NOT_concept_wall_on_left_of_box': 0.35714285714285715, 'NOT_concept_wall_on_left_of_box_concept_no_wall_on_right_m': 1.0, 'NOT_concept_wall_on_left_of_box_concept_wall_below': 0.21428571428571427, 'NOT_concept_no_wall_on_left_m_NOT_concept_wall_on_left_of_box': 0.7857142857142857, 'NOT_concept_wall_on_left_of_box_NOT_concept_wall_top_left': 0.9285714285714286, 'NOT_concept_box_below_NOT_concept_wall_on_left_of_box': 1.0, 'NOT_concept_wall_above_box_NOT_concept_wall_on_left_of_box': 0.7142857142857143, 'NOT_concept_wall_on_left_of_box_concept_pink_cell_on_top': 0.0, 'NOT_concept_no_pink_cell_on_top_m_NOT_concept_wall_on_left_of_box': 0.14285714285714285, 'NOT_concept_wall_on_left_of_box_NOT_concept_wall_on_right_of_box': 1.0, 'NOT_concept_no_wall_on_top_m_NOT_concept_wall_on_left_of_box': 0.35714285714285715, 'NOT_concept_wall_on_left_of_box_concept_on_pink_cell': 0.21428571428571427, 'NOT_concept_wall_on_left_of_box_concept_target_on_top': 0.07142857142857142, 'NOT_concept_wall_on_left_of_box_concept_wall_down_left': 0.07142857142857142, 'NOT_concept_wall_on_left_of_box_concept_wall_on_left': 0.5, 'NOT_concept_no_pink_cell_below_m_NOT_concept_wall_on_left_of_box': 0.35714285714285715, 'NOT_concept_wall_on_left_of_box_concept_wall_up_down_right': 0.0, 'NOT_concept_wall_on_left_of_box_concept_wall_on_top': 0.14285714285714285, 'NOT_concept_wall_on_left_of_box_concept_wall_above_box': 0.2857142857142857, 'NOT_concept_wall_on_left_of_box_concept_wall_on_right_of_box': 0.0, 'NOT_concept_wall_on_left_of_box_concept_box_on_left': 0.0, 'NOT_concept_wall_on_left_of_box_concept_no_wall_on_top_m': 0.6428571428571429, 'NOT_concept_pink_cell_on_top_NOT_concept_wall_on_left_of_box': 1.0, 'NOT_concept_wall_on_left_of_box_concept_no_pink_cell_on_top_m': 0.8571428571428571, 'NOT_concept_no_wall_below_m_NOT_concept_wall_on_left_of_box': 0.35714285714285715, 'NOT_concept_wall_on_left_of_box_concept_wall_below_box': 0.21428571428571427, 'NOT_concept_wall_on_left_of_box_concept_wall_on_right': 0.0, 'NOT_concept_wall_on_left_of_box_concept_pink_cell_below': 0.14285714285714285, 'NOT_concept_blank_cell_on_left_NOT_concept_wall_on_left_of_box': 0.5, 'NOT_concept_target_on_right_NOT_concept_wall_on_left_of_box': 1.0, 'NOT_concept_wall_on_left_of_box_concept_no_pink_cell_below_m': 0.6428571428571429, 'NOT_concept_target_on_top_NOT_concept_wall_on_left_of_box': 0.9285714285714286, 'NOT_concept_wall_on_left_of_box_NOT_concept_wall_top_right': 1.0, 'NOT_concept_wall_on_left_of_box_concept_box_on_top': 0.0, 'NOT_concept_wall_on_left_of_box_concept_no_wall_below_m': 0.6428571428571429, 'NOT_concept_wall_on_left_NOT_concept_wall_on_left_of_box': 0.5, 'NOT_concept_wall_on_left_of_box_concept_wall_on_left_of_box': 0.0, 'NOT_concept_box_on_top_NOT_concept_wall_on_left_of_box': 1.0, 'NOT_concept_wall_on_left_of_box_concept_blank_cell_on_left': 0.5, 'NOT_concept_wall_on_left_of_box_NOT_concept_wall_on_right': 1.0, 'NOT_concept_pink_cell_on_right_NOT_concept_wall_on_left_of_box': 0.7857142857142857, 'NOT_concept_box_on_left_NOT_concept_wall_on_left_of_box': 1.0, 'NOT_concept_wall_down_left_NOT_concept_wall_on_left_of_box': 0.9285714285714286, 'NOT_concept_pink_cell_below_NOT_concept_wall_on_left_of_box': 0.8571428571428571, 'NOT_concept_wall_below_NOT_concept_wall_on_left_of_box': 0.7857142857142857, 'NOT_concept_wall_up_down_right_concept_no_wall_on_left_m': 0.21428571428571427, 'NOT_concept_wall_up_down_right_concept_wall_down_right': 0.0, 'NOT_concept_pink_cell_on_left_NOT_concept_wall_up_down_right': 1.0, 'NOT_concept_wall_below_box_NOT_concept_wall_up_down_right': 0.7857142857142857, 'NOT_concept_wall_on_top_NOT_concept_wall_up_down_right': 0.8571428571428571, 'NOT_concept_no_wall_on_right_m_NOT_concept_wall_up_down_right': 0.0, 'NOT_concept_on_pink_cell_NOT_concept_wall_up_down_right': 0.7857142857142857, 'NOT_concept_box_on_right_NOT_concept_wall_up_down_right': 1.0, 'NOT_concept_wall_up_down_right_concept_wall_top_left': 0.07142857142857142, 'NOT_concept_wall_up_down_right_concept_target_on_right': 0.0, 'NOT_concept_blank_cell_below_NOT_concept_wall_up_down_right': 0.35714285714285715, 'NOT_concept_wall_up_down_right_concept_no_wall_on_right_m': 1.0, 'NOT_concept_wall_up_down_right_concept_wall_below': 0.21428571428571427, 'NOT_concept_no_wall_on_left_m_NOT_concept_wall_up_down_right': 0.7857142857142857, 'NOT_concept_wall_top_left_NOT_concept_wall_up_down_right': 0.9285714285714286, 'NOT_concept_box_below_NOT_concept_wall_up_down_right': 1.0, 'NOT_concept_wall_above_box_NOT_concept_wall_up_down_right': 0.7142857142857143, 'NOT_concept_wall_up_down_right_concept_pink_cell_on_top': 0.0, 'NOT_concept_no_pink_cell_on_top_m_NOT_concept_wall_up_down_right': 0.14285714285714285, 'NOT_concept_wall_on_right_of_box_NOT_concept_wall_up_down_right': 1.0, 'NOT_concept_no_wall_on_top_m_NOT_concept_wall_up_down_right': 0.35714285714285715, 'NOT_concept_wall_up_down_right_concept_on_pink_cell': 0.21428571428571427, 'NOT_concept_wall_up_down_right_concept_target_on_top': 0.07142857142857142, 'NOT_concept_wall_up_down_right_concept_wall_down_left': 0.07142857142857142, 'NOT_concept_wall_up_down_right_concept_wall_on_left': 0.5, 'NOT_concept_no_pink_cell_below_m_NOT_concept_wall_up_down_right': 0.35714285714285715, 'NOT_concept_wall_up_down_right_concept_wall_up_down_right': 0.0, 'NOT_concept_wall_up_down_right_concept_wall_on_top': 0.14285714285714285, 'NOT_concept_wall_up_down_right_concept_wall_above_box': 0.2857142857142857, 'NOT_concept_wall_up_down_right_concept_wall_on_right_of_box': 0.0, 'NOT_concept_wall_up_down_right_concept_box_on_left': 0.0, 'NOT_concept_wall_up_down_right_concept_no_wall_on_top_m': 0.6428571428571429, 'NOT_concept_pink_cell_on_top_NOT_concept_wall_up_down_right': 1.0, 'NOT_concept_wall_up_down_right_concept_no_pink_cell_on_top_m': 0.8571428571428571, 'NOT_concept_no_wall_below_m_NOT_concept_wall_up_down_right': 0.35714285714285715, 'NOT_concept_wall_up_down_right_concept_wall_below_box': 0.21428571428571427, 'NOT_concept_wall_up_down_right_concept_wall_on_right': 0.0, 'NOT_concept_wall_up_down_right_concept_pink_cell_below': 0.14285714285714285, 'NOT_concept_blank_cell_on_left_NOT_concept_wall_up_down_right': 0.5, 'NOT_concept_target_on_right_NOT_concept_wall_up_down_right': 1.0, 'NOT_concept_wall_up_down_right_concept_no_pink_cell_below_m': 0.6428571428571429, 'NOT_concept_target_on_top_NOT_concept_wall_up_down_right': 0.9285714285714286, 'NOT_concept_wall_top_right_NOT_concept_wall_up_down_right': 1.0, 'NOT_concept_wall_up_down_right_concept_box_on_top': 0.0, 'NOT_concept_wall_up_down_right_concept_no_wall_below_m': 0.6428571428571429, 'NOT_concept_wall_on_left_NOT_concept_wall_up_down_right': 0.5, 'NOT_concept_wall_up_down_right_concept_wall_on_left_of_box': 0.0, 'NOT_concept_box_on_top_NOT_concept_wall_up_down_right': 1.0, 'NOT_concept_wall_up_down_right_concept_blank_cell_on_left': 0.5, 'NOT_concept_wall_on_right_NOT_concept_wall_up_down_right': 1.0, 'NOT_concept_pink_cell_on_right_NOT_concept_wall_up_down_right': 0.7857142857142857, 'NOT_concept_box_on_left_NOT_concept_wall_up_down_right': 1.0, 'NOT_concept_wall_down_left_NOT_concept_wall_up_down_right': 0.9285714285714286, 'NOT_concept_pink_cell_below_NOT_concept_wall_up_down_right': 0.8571428571428571, 'NOT_concept_wall_below_NOT_concept_wall_up_down_right': 0.7857142857142857, 'concept_no_wall_on_left_m_concept_wall_down_right': 0.0, 'NOT_concept_pink_cell_on_left_concept_no_wall_on_left_m': 0.21428571428571427, 'NOT_concept_wall_below_box_concept_no_wall_on_left_m': 0.14285714285714285, 'NOT_concept_wall_on_top_concept_no_wall_on_left_m': 0.21428571428571427, 'NOT_concept_no_wall_on_right_m_concept_no_wall_on_left_m': 0.0, 'NOT_concept_on_pink_cell_concept_no_wall_on_left_m': 0.21428571428571427, 'NOT_concept_box_on_right_concept_no_wall_on_left_m': 0.21428571428571427, 'concept_no_wall_on_left_m_concept_wall_top_left': 0.0, 'concept_no_wall_on_left_m_concept_target_on_right': 0.0, 'NOT_concept_blank_cell_below_concept_no_wall_on_left_m': 0.14285714285714285, 'concept_no_wall_on_left_m_concept_no_wall_on_right_m': 0.21428571428571427, 'concept_no_wall_on_left_m_concept_wall_below': 0.07142857142857142, 'NOT_concept_no_wall_on_left_m_concept_no_wall_on_left_m': 0.0, 'NOT_concept_wall_top_left_concept_no_wall_on_left_m': 0.21428571428571427, 'NOT_concept_box_below_concept_no_wall_on_left_m': 0.21428571428571427, 'NOT_concept_wall_above_box_concept_no_wall_on_left_m': 0.07142857142857142, 'concept_no_wall_on_left_m_concept_pink_cell_on_top': 0.0, 'NOT_concept_no_pink_cell_on_top_m_concept_no_wall_on_left_m': 0.0, 'NOT_concept_wall_on_right_of_box_concept_no_wall_on_left_m': 0.21428571428571427, 'NOT_concept_no_wall_on_top_m_concept_no_wall_on_left_m': 0.14285714285714285, 'concept_no_wall_on_left_m_concept_on_pink_cell': 0.0, 'concept_no_wall_on_left_m_concept_target_on_top': 0.07142857142857142, 'concept_no_wall_on_left_m_concept_wall_down_left': 0.0, 'concept_no_wall_on_left_m_concept_wall_on_left': 0.0, 'NOT_concept_no_pink_cell_below_m_concept_no_wall_on_left_m': 0.14285714285714285, 'concept_no_wall_on_left_m_concept_wall_up_down_right': 0.0, 'concept_no_wall_on_left_m_concept_wall_on_top': 0.0, 'concept_no_wall_on_left_m_concept_wall_above_box': 0.14285714285714285, 'concept_no_wall_on_left_m_concept_wall_on_right_of_box': 0.0, 'concept_box_on_left_concept_no_wall_on_left_m': 0.0, 'concept_no_wall_on_left_m_concept_no_wall_on_top_m': 0.07142857142857142, 'NOT_concept_pink_cell_on_top_concept_no_wall_on_left_m': 0.21428571428571427, 'concept_no_pink_cell_on_top_m_concept_no_wall_on_left_m': 0.21428571428571427, 'NOT_concept_no_wall_below_m_concept_no_wall_on_left_m': 0.07142857142857142, 'concept_no_wall_on_left_m_concept_wall_below_box': 0.07142857142857142, 'concept_no_wall_on_left_m_concept_wall_on_right': 0.0, 'concept_no_wall_on_left_m_concept_pink_cell_below': 0.07142857142857142, 'NOT_concept_blank_cell_on_left_concept_no_wall_on_left_m': 0.0, 'NOT_concept_target_on_right_concept_no_wall_on_left_m': 0.21428571428571427, 'concept_no_pink_cell_below_m_concept_no_wall_on_left_m': 0.07142857142857142, 'NOT_concept_target_on_top_concept_no_wall_on_left_m': 0.14285714285714285, 'NOT_concept_wall_top_right_concept_no_wall_on_left_m': 0.21428571428571427, 'concept_box_on_top_concept_no_wall_on_left_m': 0.0, 'concept_no_wall_below_m_concept_no_wall_on_left_m': 0.14285714285714285, 'NOT_concept_wall_on_left_concept_no_wall_on_left_m': 0.21428571428571427, 'concept_no_wall_on_left_m_concept_wall_on_left_of_box': 0.0, 'NOT_concept_box_on_top_concept_no_wall_on_left_m': 0.21428571428571427, 'concept_blank_cell_on_left_concept_no_wall_on_left_m': 0.21428571428571427, 'NOT_concept_wall_on_right_concept_no_wall_on_left_m': 0.21428571428571427, 'NOT_concept_pink_cell_on_right_concept_no_wall_on_left_m': 0.21428571428571427, 'NOT_concept_box_on_left_concept_no_wall_on_left_m': 0.21428571428571427, 'NOT_concept_wall_down_left_concept_no_wall_on_left_m': 0.21428571428571427, 'NOT_concept_pink_cell_below_concept_no_wall_on_left_m': 0.14285714285714285, 'NOT_concept_wall_below_concept_no_wall_on_left_m': 0.14285714285714285, 'NOT_concept_pink_cell_on_left_concept_wall_down_right': 0.0, 'NOT_concept_wall_below_box_concept_wall_down_right': 0.0, 'NOT_concept_wall_on_top_concept_wall_down_right': 0.0, 'NOT_concept_no_wall_on_right_m_concept_wall_down_right': 0.0, 'NOT_concept_on_pink_cell_concept_wall_down_right': 0.0, 'NOT_concept_box_on_right_concept_wall_down_right': 0.0, 'concept_wall_down_right_concept_wall_top_left': 0.0, 'concept_target_on_right_concept_wall_down_right': 0.0, 'NOT_concept_blank_cell_below_concept_wall_down_right': 0.0, 'concept_no_wall_on_right_m_concept_wall_down_right': 0.0, 'concept_wall_below_concept_wall_down_right': 0.0, 'NOT_concept_no_wall_on_left_m_concept_wall_down_right': 0.0, 'NOT_concept_wall_top_left_concept_wall_down_right': 0.0, 'NOT_concept_box_below_concept_wall_down_right': 0.0, 'NOT_concept_wall_above_box_concept_wall_down_right': 0.0, 'concept_pink_cell_on_top_concept_wall_down_right': 0.0, 'NOT_concept_no_pink_cell_on_top_m_concept_wall_down_right': 0.0, 'NOT_concept_wall_on_right_of_box_concept_wall_down_right': 0.0, 'NOT_concept_no_wall_on_top_m_concept_wall_down_right': 0.0, 'concept_on_pink_cell_concept_wall_down_right': 0.0, 'concept_target_on_top_concept_wall_down_right': 0.0, 'concept_wall_down_left_concept_wall_down_right': 0.0, 'concept_wall_down_right_concept_wall_on_left': 0.0, 'NOT_concept_no_pink_cell_below_m_concept_wall_down_right': 0.0, 'concept_wall_down_right_concept_wall_up_down_right': 0.0, 'concept_wall_down_right_concept_wall_on_top': 0.0, 'concept_wall_above_box_concept_wall_down_right': 0.0, 'concept_wall_down_right_concept_wall_on_right_of_box': 0.0, 'concept_box_on_left_concept_wall_down_right': 0.0, 'concept_no_wall_on_top_m_concept_wall_down_right': 0.0, 'NOT_concept_pink_cell_on_top_concept_wall_down_right': 0.0, 'concept_no_pink_cell_on_top_m_concept_wall_down_right': 0.0, 'NOT_concept_no_wall_below_m_concept_wall_down_right': 0.0, 'concept_wall_below_box_concept_wall_down_right': 0.0, 'concept_wall_down_right_concept_wall_on_right': 0.0, 'concept_pink_cell_below_concept_wall_down_right': 0.0, 'NOT_concept_blank_cell_on_left_concept_wall_down_right': 0.0, 'NOT_concept_target_on_right_concept_wall_down_right': 0.0, 'concept_no_pink_cell_below_m_concept_wall_down_right': 0.0, 'NOT_concept_target_on_top_concept_wall_down_right': 0.0, 'NOT_concept_wall_top_right_concept_wall_down_right': 0.0, 'concept_box_on_top_concept_wall_down_right': 0.0, 'concept_no_wall_below_m_concept_wall_down_right': 0.0, 'NOT_concept_wall_on_left_concept_wall_down_right': 0.0, 'concept_wall_down_right_concept_wall_on_left_of_box': 0.0, 'NOT_concept_box_on_top_concept_wall_down_right': 0.0, 'concept_blank_cell_on_left_concept_wall_down_right': 0.0, 'NOT_concept_wall_on_right_concept_wall_down_right': 0.0, 'NOT_concept_pink_cell_on_right_concept_wall_down_right': 0.0, 'NOT_concept_box_on_left_concept_wall_down_right': 0.0, 'NOT_concept_wall_down_left_concept_wall_down_right': 0.0, 'NOT_concept_pink_cell_below_concept_wall_down_right': 0.0, 'NOT_concept_wall_below_concept_wall_down_right': 0.0, 'NOT_concept_pink_cell_on_left_NOT_concept_wall_below_box': 0.7857142857142857, 'NOT_concept_pink_cell_on_left_NOT_concept_wall_on_top': 0.8571428571428571, 'NOT_concept_no_wall_on_right_m_NOT_concept_pink_cell_on_left': 0.0, 'NOT_concept_on_pink_cell_NOT_concept_pink_cell_on_left': 0.7857142857142857, 'NOT_concept_box_on_right_NOT_concept_pink_cell_on_left': 1.0, 'NOT_concept_pink_cell_on_left_concept_wall_top_left': 0.07142857142857142, 'NOT_concept_pink_cell_on_left_concept_target_on_right': 0.0, 'NOT_concept_blank_cell_below_NOT_concept_pink_cell_on_left': 0.35714285714285715, 'NOT_concept_pink_cell_on_left_concept_no_wall_on_right_m': 1.0, 'NOT_concept_pink_cell_on_left_concept_wall_below': 0.21428571428571427, 'NOT_concept_no_wall_on_left_m_NOT_concept_pink_cell_on_left': 0.7857142857142857, 'NOT_concept_pink_cell_on_left_NOT_concept_wall_top_left': 0.9285714285714286, 'NOT_concept_box_below_NOT_concept_pink_cell_on_left': 1.0, 'NOT_concept_pink_cell_on_left_NOT_concept_wall_above_box': 0.7142857142857143, 'NOT_concept_pink_cell_on_left_concept_pink_cell_on_top': 0.0, 'NOT_concept_no_pink_cell_on_top_m_NOT_concept_pink_cell_on_left': 0.14285714285714285, 'NOT_concept_pink_cell_on_left_NOT_concept_wall_on_right_of_box': 1.0, 'NOT_concept_no_wall_on_top_m_NOT_concept_pink_cell_on_left': 0.35714285714285715, 'NOT_concept_pink_cell_on_left_concept_on_pink_cell': 0.21428571428571427, 'NOT_concept_pink_cell_on_left_concept_target_on_top': 0.07142857142857142, 'NOT_concept_pink_cell_on_left_concept_wall_down_left': 0.07142857142857142, 'NOT_concept_pink_cell_on_left_concept_wall_on_left': 0.5, 'NOT_concept_no_pink_cell_below_m_NOT_concept_pink_cell_on_left': 0.35714285714285715, 'NOT_concept_pink_cell_on_left_concept_wall_up_down_right': 0.0, 'NOT_concept_pink_cell_on_left_concept_wall_on_top': 0.14285714285714285, 'NOT_concept_pink_cell_on_left_concept_wall_above_box': 0.2857142857142857, 'NOT_concept_pink_cell_on_left_concept_wall_on_right_of_box': 0.0, 'NOT_concept_pink_cell_on_left_concept_box_on_left': 0.0, 'NOT_concept_pink_cell_on_left_concept_no_wall_on_top_m': 0.6428571428571429, 'NOT_concept_pink_cell_on_left_NOT_concept_pink_cell_on_top': 1.0, 'NOT_concept_pink_cell_on_left_concept_no_pink_cell_on_top_m': 0.8571428571428571, 'NOT_concept_no_wall_below_m_NOT_concept_pink_cell_on_left': 0.35714285714285715, 'NOT_concept_pink_cell_on_left_concept_wall_below_box': 0.21428571428571427, 'NOT_concept_pink_cell_on_left_concept_wall_on_right': 0.0, 'NOT_concept_pink_cell_on_left_concept_pink_cell_below': 0.14285714285714285, 'NOT_concept_blank_cell_on_left_NOT_concept_pink_cell_on_left': 0.5, 'NOT_concept_pink_cell_on_left_NOT_concept_target_on_right': 1.0, 'NOT_concept_pink_cell_on_left_concept_no_pink_cell_below_m': 0.6428571428571429, 'NOT_concept_pink_cell_on_left_NOT_concept_target_on_top': 0.9285714285714286, 'NOT_concept_pink_cell_on_left_NOT_concept_wall_top_right': 1.0, 'NOT_concept_pink_cell_on_left_concept_box_on_top': 0.0, 'NOT_concept_pink_cell_on_left_concept_no_wall_below_m': 0.6428571428571429, 'NOT_concept_pink_cell_on_left_NOT_concept_wall_on_left': 0.5, 'NOT_concept_pink_cell_on_left_concept_wall_on_left_of_box': 0.0, 'NOT_concept_box_on_top_NOT_concept_pink_cell_on_left': 1.0, 'NOT_concept_pink_cell_on_left_concept_blank_cell_on_left': 0.5, 'NOT_concept_pink_cell_on_left_NOT_concept_wall_on_right': 1.0, 'NOT_concept_pink_cell_on_left_NOT_concept_pink_cell_on_right': 0.7857142857142857, 'NOT_concept_box_on_left_NOT_concept_pink_cell_on_left': 1.0, 'NOT_concept_pink_cell_on_left_NOT_concept_wall_down_left': 0.9285714285714286, 'NOT_concept_pink_cell_below_NOT_concept_pink_cell_on_left': 0.8571428571428571, 'NOT_concept_pink_cell_on_left_NOT_concept_wall_below': 0.7857142857142857, 'NOT_concept_wall_below_box_NOT_concept_wall_on_top': 0.6428571428571429, 'NOT_concept_no_wall_on_right_m_NOT_concept_wall_below_box': 0.0, 'NOT_concept_on_pink_cell_NOT_concept_wall_below_box': 0.5714285714285714, 'NOT_concept_box_on_right_NOT_concept_wall_below_box': 0.7857142857142857, 'NOT_concept_wall_below_box_concept_wall_top_left': 0.07142857142857142, 'NOT_concept_wall_below_box_concept_target_on_right': 0.0, 'NOT_concept_blank_cell_below_NOT_concept_wall_below_box': 0.14285714285714285, 'NOT_concept_wall_below_box_concept_no_wall_on_right_m': 0.7857142857142857, 'NOT_concept_wall_below_box_concept_wall_below': 0.0, 'NOT_concept_no_wall_on_left_m_NOT_concept_wall_below_box': 0.6428571428571429, 'NOT_concept_wall_below_box_NOT_concept_wall_top_left': 0.7142857142857143, 'NOT_concept_box_below_NOT_concept_wall_below_box': 0.7857142857142857, 'NOT_concept_wall_above_box_NOT_concept_wall_below_box': 0.5714285714285714, 'NOT_concept_wall_below_box_concept_pink_cell_on_top': 0.0, 'NOT_concept_no_pink_cell_on_top_m_NOT_concept_wall_below_box': 0.14285714285714285, 'NOT_concept_wall_below_box_NOT_concept_wall_on_right_of_box': 0.7857142857142857, 'NOT_concept_no_wall_on_top_m_NOT_concept_wall_below_box': 0.35714285714285715, 'NOT_concept_wall_below_box_concept_on_pink_cell': 0.21428571428571427, 'NOT_concept_wall_below_box_concept_target_on_top': 0.07142857142857142, 'NOT_concept_wall_below_box_concept_wall_down_left': 0.0, 'NOT_concept_wall_below_box_concept_wall_on_left': 0.42857142857142855, 'NOT_concept_no_pink_cell_below_m_NOT_concept_wall_below_box': 0.14285714285714285, 'NOT_concept_wall_below_box_concept_wall_up_down_right': 0.0, 'NOT_concept_wall_below_box_concept_wall_on_top': 0.14285714285714285, 'NOT_concept_wall_below_box_concept_wall_above_box': 0.21428571428571427, 'NOT_concept_wall_below_box_concept_wall_on_right_of_box': 0.0, 'NOT_concept_wall_below_box_concept_box_on_left': 0.0, 'NOT_concept_wall_below_box_concept_no_wall_on_top_m': 0.42857142857142855, 'NOT_concept_pink_cell_on_top_NOT_concept_wall_below_box': 0.7857142857142857, 'NOT_concept_wall_below_box_concept_no_pink_cell_on_top_m': 0.6428571428571429, 'NOT_concept_no_wall_below_m_NOT_concept_wall_below_box': 0.14285714285714285, 'NOT_concept_wall_below_box_concept_wall_below_box': 0.0, 'NOT_concept_wall_below_box_concept_wall_on_right': 0.0, 'NOT_concept_wall_below_box_concept_pink_cell_below': 0.14285714285714285, 'NOT_concept_blank_cell_on_left_NOT_concept_wall_below_box': 0.42857142857142855, 'NOT_concept_target_on_right_NOT_concept_wall_below_box': 0.7857142857142857, 'NOT_concept_wall_below_box_concept_no_pink_cell_below_m': 0.6428571428571429, 'NOT_concept_target_on_top_NOT_concept_wall_below_box': 0.7142857142857143, 'NOT_concept_wall_below_box_NOT_concept_wall_top_right': 0.7857142857142857, 'NOT_concept_wall_below_box_concept_box_on_top': 0.0, 'NOT_concept_wall_below_box_concept_no_wall_below_m': 0.6428571428571429, 'NOT_concept_wall_below_box_NOT_concept_wall_on_left': 0.35714285714285715, 'NOT_concept_wall_below_box_concept_wall_on_left_of_box': 0.0, 'NOT_concept_box_on_top_NOT_concept_wall_below_box': 0.7857142857142857, 'NOT_concept_wall_below_box_concept_blank_cell_on_left': 0.35714285714285715, 'NOT_concept_wall_below_box_NOT_concept_wall_on_right': 0.7857142857142857, 'NOT_concept_pink_cell_on_right_NOT_concept_wall_below_box': 0.5714285714285714, 'NOT_concept_box_on_left_NOT_concept_wall_below_box': 0.7857142857142857, 'NOT_concept_wall_below_box_NOT_concept_wall_down_left': 0.7857142857142857, 'NOT_concept_pink_cell_below_NOT_concept_wall_below_box': 0.6428571428571429, 'NOT_concept_wall_below_NOT_concept_wall_below_box': 0.7857142857142857, 'NOT_concept_no_wall_on_right_m_NOT_concept_wall_on_top': 0.0, 'NOT_concept_on_pink_cell_NOT_concept_wall_on_top': 0.6428571428571429, 'NOT_concept_box_on_right_NOT_concept_wall_on_top': 0.8571428571428571, 'NOT_concept_wall_on_top_concept_wall_top_left': 0.0, 'NOT_concept_wall_on_top_concept_target_on_right': 0.0, 'NOT_concept_blank_cell_below_NOT_concept_wall_on_top': 0.35714285714285715, 'NOT_concept_wall_on_top_concept_no_wall_on_right_m': 0.8571428571428571, 'NOT_concept_wall_on_top_concept_wall_below': 0.21428571428571427, 'NOT_concept_no_wall_on_left_m_NOT_concept_wall_on_top': 0.6428571428571429, 'NOT_concept_wall_on_top_NOT_concept_wall_top_left': 0.8571428571428571, 'NOT_concept_box_below_NOT_concept_wall_on_top': 0.8571428571428571, 'NOT_concept_wall_above_box_NOT_concept_wall_on_top': 0.7142857142857143, 'NOT_concept_wall_on_top_concept_pink_cell_on_top': 0.0, 'NOT_concept_no_pink_cell_on_top_m_NOT_concept_wall_on_top': 0.0, 'NOT_concept_wall_on_right_of_box_NOT_concept_wall_on_top': 0.8571428571428571, 'NOT_concept_no_wall_on_top_m_NOT_concept_wall_on_top': 0.21428571428571427, 'NOT_concept_wall_on_top_concept_on_pink_cell': 0.21428571428571427, 'NOT_concept_wall_on_top_concept_target_on_top': 0.07142857142857142, 'NOT_concept_wall_on_top_concept_wall_down_left': 0.07142857142857142, 'NOT_concept_wall_on_top_concept_wall_on_left': 0.42857142857142855, 'NOT_concept_no_pink_cell_below_m_NOT_concept_wall_on_top': 0.35714285714285715, 'NOT_concept_wall_on_top_concept_wall_up_down_right': 0.0, 'NOT_concept_wall_on_top_concept_wall_on_top': 0.0, 'NOT_concept_wall_on_top_concept_wall_above_box': 0.14285714285714285, 'NOT_concept_wall_on_top_concept_wall_on_right_of_box': 0.0, 'NOT_concept_wall_on_top_concept_box_on_left': 0.0, 'NOT_concept_wall_on_top_concept_no_wall_on_top_m': 0.6428571428571429, 'NOT_concept_pink_cell_on_top_NOT_concept_wall_on_top': 0.8571428571428571, 'NOT_concept_wall_on_top_concept_no_pink_cell_on_top_m': 0.8571428571428571, 'NOT_concept_no_wall_below_m_NOT_concept_wall_on_top': 0.2857142857142857, 'NOT_concept_wall_on_top_concept_wall_below_box': 0.21428571428571427, 'NOT_concept_wall_on_top_concept_wall_on_right': 0.0, 'NOT_concept_wall_on_top_concept_pink_cell_below': 0.14285714285714285, 'NOT_concept_blank_cell_on_left_NOT_concept_wall_on_top': 0.42857142857142855, 'NOT_concept_target_on_right_NOT_concept_wall_on_top': 0.8571428571428571, 'NOT_concept_wall_on_top_concept_no_pink_cell_below_m': 0.5, 'NOT_concept_target_on_top_NOT_concept_wall_on_top': 0.7857142857142857, 'NOT_concept_wall_on_top_NOT_concept_wall_top_right': 0.8571428571428571, 'NOT_concept_wall_on_top_concept_box_on_top': 0.0, 'NOT_concept_wall_on_top_concept_no_wall_below_m': 0.5714285714285714, 'NOT_concept_wall_on_left_NOT_concept_wall_on_top': 0.42857142857142855, 'NOT_concept_wall_on_top_concept_wall_on_left_of_box': 0.0, 'NOT_concept_box_on_top_NOT_concept_wall_on_top': 0.8571428571428571, 'NOT_concept_wall_on_top_concept_blank_cell_on_left': 0.42857142857142855, 'NOT_concept_wall_on_right_NOT_concept_wall_on_top': 0.8571428571428571, 'NOT_concept_pink_cell_on_right_NOT_concept_wall_on_top': 0.6428571428571429, 'NOT_concept_box_on_left_NOT_concept_wall_on_top': 0.8571428571428571, 'NOT_concept_wall_down_left_NOT_concept_wall_on_top': 0.7857142857142857, 'NOT_concept_pink_cell_below_NOT_concept_wall_on_top': 0.7142857142857143, 'NOT_concept_wall_below_NOT_concept_wall_on_top': 0.6428571428571429, 'NOT_concept_no_wall_on_right_m_NOT_concept_on_pink_cell': 0.0, 'NOT_concept_box_on_right_NOT_concept_no_wall_on_right_m': 0.0, 'NOT_concept_no_wall_on_right_m_concept_wall_top_left': 0.0, 'NOT_concept_no_wall_on_right_m_concept_target_on_right': 0.0, 'NOT_concept_blank_cell_below_NOT_concept_no_wall_on_right_m': 0.0, 'NOT_concept_no_wall_on_right_m_concept_no_wall_on_right_m': 0.0, 'NOT_concept_no_wall_on_right_m_concept_wall_below': 0.0, 'NOT_concept_no_wall_on_left_m_NOT_concept_no_wall_on_right_m': 0.0, 'NOT_concept_no_wall_on_right_m_NOT_concept_wall_top_left': 0.0, 'NOT_concept_box_below_NOT_concept_no_wall_on_right_m': 0.0, 'NOT_concept_no_wall_on_right_m_NOT_concept_wall_above_box': 0.0, 'NOT_concept_no_wall_on_right_m_concept_pink_cell_on_top': 0.0, 'NOT_concept_no_pink_cell_on_top_m_NOT_concept_no_wall_on_right_m': 0.0, 'NOT_concept_no_wall_on_right_m_NOT_concept_wall_on_right_of_box': 0.0, 'NOT_concept_no_wall_on_right_m_NOT_concept_no_wall_on_top_m': 0.0, 'NOT_concept_no_wall_on_right_m_concept_on_pink_cell': 0.0, 'NOT_concept_no_wall_on_right_m_concept_target_on_top': 0.0, 'NOT_concept_no_wall_on_right_m_concept_wall_down_left': 0.0, 'NOT_concept_no_wall_on_right_m_concept_wall_on_left': 0.0, 'NOT_concept_no_pink_cell_below_m_NOT_concept_no_wall_on_right_m': 0.0, 'NOT_concept_no_wall_on_right_m_concept_wall_up_down_right': 0.0, 'NOT_concept_no_wall_on_right_m_concept_wall_on_top': 0.0, 'NOT_concept_no_wall_on_right_m_concept_wall_above_box': 0.0, 'NOT_concept_no_wall_on_right_m_concept_wall_on_right_of_box': 0.0, 'NOT_concept_no_wall_on_right_m_concept_box_on_left': 0.0, 'NOT_concept_no_wall_on_right_m_concept_no_wall_on_top_m': 0.0, 'NOT_concept_no_wall_on_right_m_NOT_concept_pink_cell_on_top': 0.0, 'NOT_concept_no_wall_on_right_m_concept_no_pink_cell_on_top_m': 0.0, 'NOT_concept_no_wall_below_m_NOT_concept_no_wall_on_right_m': 0.0, 'NOT_concept_no_wall_on_right_m_concept_wall_below_box': 0.0, 'NOT_concept_no_wall_on_right_m_concept_wall_on_right': 0.0, 'NOT_concept_no_wall_on_right_m_concept_pink_cell_below': 0.0, 'NOT_concept_blank_cell_on_left_NOT_concept_no_wall_on_right_m': 0.0, 'NOT_concept_no_wall_on_right_m_NOT_concept_target_on_right': 0.0, 'NOT_concept_no_wall_on_right_m_concept_no_pink_cell_below_m': 0.0, 'NOT_concept_no_wall_on_right_m_NOT_concept_target_on_top': 0.0, 'NOT_concept_no_wall_on_right_m_NOT_concept_wall_top_right': 0.0, 'NOT_concept_no_wall_on_right_m_concept_box_on_top': 0.0, 'NOT_concept_no_wall_on_right_m_concept_no_wall_below_m': 0.0, 'NOT_concept_no_wall_on_right_m_NOT_concept_wall_on_left': 0.0, 'NOT_concept_no_wall_on_right_m_concept_wall_on_left_of_box': 0.0, 'NOT_concept_box_on_top_NOT_concept_no_wall_on_right_m': 0.0, 'NOT_concept_no_wall_on_right_m_concept_blank_cell_on_left': 0.0, 'NOT_concept_no_wall_on_right_m_NOT_concept_wall_on_right': 0.0, 'NOT_concept_no_wall_on_right_m_NOT_concept_pink_cell_on_right': 0.0, 'NOT_concept_box_on_left_NOT_concept_no_wall_on_right_m': 0.0, 'NOT_concept_no_wall_on_right_m_NOT_concept_wall_down_left': 0.0, 'NOT_concept_no_wall_on_right_m_NOT_concept_pink_cell_below': 0.0, 'NOT_concept_no_wall_on_right_m_NOT_concept_wall_below': 0.0, 'NOT_concept_box_on_right_NOT_concept_on_pink_cell': 0.7857142857142857, 'NOT_concept_on_pink_cell_concept_wall_top_left': 0.07142857142857142, 'NOT_concept_on_pink_cell_concept_target_on_right': 0.0, 'NOT_concept_blank_cell_below_NOT_concept_on_pink_cell': 0.35714285714285715, 'NOT_concept_on_pink_cell_concept_no_wall_on_right_m': 0.7857142857142857, 'NOT_concept_on_pink_cell_concept_wall_below': 0.21428571428571427, 'NOT_concept_no_wall_on_left_m_NOT_concept_on_pink_cell': 0.5714285714285714, 'NOT_concept_on_pink_cell_NOT_concept_wall_top_left': 0.7142857142857143, 'NOT_concept_box_below_NOT_concept_on_pink_cell': 0.7857142857142857, 'NOT_concept_on_pink_cell_NOT_concept_wall_above_box': 0.5, 'NOT_concept_on_pink_cell_concept_pink_cell_on_top': 0.0, 'NOT_concept_no_pink_cell_on_top_m_NOT_concept_on_pink_cell': 0.14285714285714285, 'NOT_concept_on_pink_cell_NOT_concept_wall_on_right_of_box': 0.7857142857142857, 'NOT_concept_no_wall_on_top_m_NOT_concept_on_pink_cell': 0.35714285714285715, 'NOT_concept_on_pink_cell_concept_on_pink_cell': 0.0, 'NOT_concept_on_pink_cell_concept_target_on_top': 0.07142857142857142, 'NOT_concept_on_pink_cell_concept_wall_down_left': 0.07142857142857142, 'NOT_concept_on_pink_cell_concept_wall_on_left': 0.2857142857142857, 'NOT_concept_no_pink_cell_below_m_NOT_concept_on_pink_cell': 0.35714285714285715, 'NOT_concept_on_pink_cell_concept_wall_up_down_right': 0.0, 'NOT_concept_on_pink_cell_concept_wall_on_top': 0.14285714285714285, 'NOT_concept_on_pink_cell_concept_wall_above_box': 0.2857142857142857, 'NOT_concept_on_pink_cell_concept_wall_on_right_of_box': 0.0, 'NOT_concept_on_pink_cell_concept_box_on_left': 0.0, 'NOT_concept_on_pink_cell_concept_no_wall_on_top_m': 0.42857142857142855, 'NOT_concept_on_pink_cell_NOT_concept_pink_cell_on_top': 0.7857142857142857, 'NOT_concept_on_pink_cell_concept_no_pink_cell_on_top_m': 0.6428571428571429, 'NOT_concept_no_wall_below_m_NOT_concept_on_pink_cell': 0.35714285714285715, 'NOT_concept_on_pink_cell_concept_wall_below_box': 0.21428571428571427, 'NOT_concept_on_pink_cell_concept_wall_on_right': 0.0, 'NOT_concept_on_pink_cell_concept_pink_cell_below': 0.14285714285714285, 'NOT_concept_blank_cell_on_left_NOT_concept_on_pink_cell': 0.2857142857142857, 'NOT_concept_on_pink_cell_NOT_concept_target_on_right': 0.7857142857142857, 'NOT_concept_on_pink_cell_concept_no_pink_cell_below_m': 0.42857142857142855, 'NOT_concept_on_pink_cell_NOT_concept_target_on_top': 0.7142857142857143, 'NOT_concept_on_pink_cell_NOT_concept_wall_top_right': 0.7857142857142857, 'NOT_concept_on_pink_cell_concept_box_on_top': 0.0, 'NOT_concept_on_pink_cell_concept_no_wall_below_m': 0.42857142857142855, 'NOT_concept_on_pink_cell_NOT_concept_wall_on_left': 0.5, 'NOT_concept_on_pink_cell_concept_wall_on_left_of_box': 0.0, 'NOT_concept_box_on_top_NOT_concept_on_pink_cell': 0.7857142857142857, 'NOT_concept_on_pink_cell_concept_blank_cell_on_left': 0.5, 'NOT_concept_on_pink_cell_NOT_concept_wall_on_right': 0.7857142857142857, 'NOT_concept_on_pink_cell_NOT_concept_pink_cell_on_right': 0.7857142857142857, 'NOT_concept_box_on_left_NOT_concept_on_pink_cell': 0.7857142857142857, 'NOT_concept_on_pink_cell_NOT_concept_wall_down_left': 0.7142857142857143, 'NOT_concept_on_pink_cell_NOT_concept_pink_cell_below': 0.6428571428571429, 'NOT_concept_on_pink_cell_NOT_concept_wall_below': 0.5714285714285714, 'NOT_concept_box_on_right_concept_wall_top_left': 0.07142857142857142, 'NOT_concept_box_on_right_concept_target_on_right': 0.0, 'NOT_concept_blank_cell_below_NOT_concept_box_on_right': 0.35714285714285715, 'NOT_concept_box_on_right_concept_no_wall_on_right_m': 1.0, 'NOT_concept_box_on_right_concept_wall_below': 0.21428571428571427, 'NOT_concept_box_on_right_NOT_concept_no_wall_on_left_m': 0.7857142857142857, 'NOT_concept_box_on_right_NOT_concept_wall_top_left': 0.9285714285714286, 'NOT_concept_box_below_NOT_concept_box_on_right': 1.0, 'NOT_concept_box_on_right_NOT_concept_wall_above_box': 0.7142857142857143, 'NOT_concept_box_on_right_concept_pink_cell_on_top': 0.0, 'NOT_concept_box_on_right_NOT_concept_no_pink_cell_on_top_m': 0.14285714285714285, 'NOT_concept_box_on_right_NOT_concept_wall_on_right_of_box': 1.0, 'NOT_concept_box_on_right_NOT_concept_no_wall_on_top_m': 0.35714285714285715, 'NOT_concept_box_on_right_concept_on_pink_cell': 0.21428571428571427, 'NOT_concept_box_on_right_concept_target_on_top': 0.07142857142857142, 'NOT_concept_box_on_right_concept_wall_down_left': 0.07142857142857142, 'NOT_concept_box_on_right_concept_wall_on_left': 0.5, 'NOT_concept_box_on_right_NOT_concept_no_pink_cell_below_m': 0.35714285714285715, 'NOT_concept_box_on_right_concept_wall_up_down_right': 0.0, 'NOT_concept_box_on_right_concept_wall_on_top': 0.14285714285714285, 'NOT_concept_box_on_right_concept_wall_above_box': 0.2857142857142857, 'NOT_concept_box_on_right_concept_wall_on_right_of_box': 0.0, 'NOT_concept_box_on_right_concept_box_on_left': 0.0, 'NOT_concept_box_on_right_concept_no_wall_on_top_m': 0.6428571428571429, 'NOT_concept_box_on_right_NOT_concept_pink_cell_on_top': 1.0, 'NOT_concept_box_on_right_concept_no_pink_cell_on_top_m': 0.8571428571428571, 'NOT_concept_box_on_right_NOT_concept_no_wall_below_m': 0.35714285714285715, 'NOT_concept_box_on_right_concept_wall_below_box': 0.21428571428571427, 'NOT_concept_box_on_right_concept_wall_on_right': 0.0, 'NOT_concept_box_on_right_concept_pink_cell_below': 0.14285714285714285, 'NOT_concept_blank_cell_on_left_NOT_concept_box_on_right': 0.5, 'NOT_concept_box_on_right_NOT_concept_target_on_right': 1.0, 'NOT_concept_box_on_right_concept_no_pink_cell_below_m': 0.6428571428571429, 'NOT_concept_box_on_right_NOT_concept_target_on_top': 0.9285714285714286, 'NOT_concept_box_on_right_NOT_concept_wall_top_right': 1.0, 'NOT_concept_box_on_right_concept_box_on_top': 0.0, 'NOT_concept_box_on_right_concept_no_wall_below_m': 0.6428571428571429, 'NOT_concept_box_on_right_NOT_concept_wall_on_left': 0.5, 'NOT_concept_box_on_right_concept_wall_on_left_of_box': 0.0, 'NOT_concept_box_on_right_NOT_concept_box_on_top': 1.0, 'NOT_concept_box_on_right_concept_blank_cell_on_left': 0.5, 'NOT_concept_box_on_right_NOT_concept_wall_on_right': 1.0, 'NOT_concept_box_on_right_NOT_concept_pink_cell_on_right': 0.7857142857142857, 'NOT_concept_box_on_left_NOT_concept_box_on_right': 1.0, 'NOT_concept_box_on_right_NOT_concept_wall_down_left': 0.9285714285714286, 'NOT_concept_box_on_right_NOT_concept_pink_cell_below': 0.8571428571428571, 'NOT_concept_box_on_right_NOT_concept_wall_below': 0.7857142857142857, 'concept_target_on_right_concept_wall_top_left': 0.0, 'NOT_concept_blank_cell_below_concept_wall_top_left': 0.0, 'concept_no_wall_on_right_m_concept_wall_top_left': 0.07142857142857142, 'concept_wall_below_concept_wall_top_left': 0.0, 'NOT_concept_no_wall_on_left_m_concept_wall_top_left': 0.07142857142857142, 'NOT_concept_wall_top_left_concept_wall_top_left': 0.0, 'NOT_concept_box_below_concept_wall_top_left': 0.07142857142857142, 'NOT_concept_wall_above_box_concept_wall_top_left': 0.0, 'concept_pink_cell_on_top_concept_wall_top_left': 0.0, 'NOT_concept_no_pink_cell_on_top_m_concept_wall_top_left': 0.07142857142857142, 'NOT_concept_wall_on_right_of_box_concept_wall_top_left': 0.07142857142857142, 'NOT_concept_no_wall_on_top_m_concept_wall_top_left': 0.07142857142857142, 'concept_on_pink_cell_concept_wall_top_left': 0.0, 'concept_target_on_top_concept_wall_top_left': 0.0, 'concept_wall_down_left_concept_wall_top_left': 0.0, 'concept_wall_on_left_concept_wall_top_left': 0.07142857142857142, 'NOT_concept_no_pink_cell_below_m_concept_wall_top_left': 0.0, 'concept_wall_top_left_concept_wall_up_down_right': 0.0, 'concept_wall_on_top_concept_wall_top_left': 0.07142857142857142, 'concept_wall_above_box_concept_wall_top_left': 0.07142857142857142, 'concept_wall_on_right_of_box_concept_wall_top_left': 0.0, 'concept_box_on_left_concept_wall_top_left': 0.0, 'concept_no_wall_on_top_m_concept_wall_top_left': 0.0, 'NOT_concept_pink_cell_on_top_concept_wall_top_left': 0.07142857142857142, 'concept_no_pink_cell_on_top_m_concept_wall_top_left': 0.0, 'NOT_concept_no_wall_below_m_concept_wall_top_left': 0.07142857142857142, 'concept_wall_below_box_concept_wall_top_left': 0.0, 'concept_wall_on_right_concept_wall_top_left': 0.0, 'concept_pink_cell_below_concept_wall_top_left': 0.0, 'NOT_concept_blank_cell_on_left_concept_wall_top_left': 0.07142857142857142, 'NOT_concept_target_on_right_concept_wall_top_left': 0.07142857142857142, 'concept_no_pink_cell_below_m_concept_wall_top_left': 0.07142857142857142, 'NOT_concept_target_on_top_concept_wall_top_left': 0.07142857142857142, 'NOT_concept_wall_top_right_concept_wall_top_left': 0.07142857142857142, 'concept_box_on_top_concept_wall_top_left': 0.0, 'concept_no_wall_below_m_concept_wall_top_left': 0.0, 'NOT_concept_wall_on_left_concept_wall_top_left': 0.0, 'concept_wall_on_left_of_box_concept_wall_top_left': 0.0, 'NOT_concept_box_on_top_concept_wall_top_left': 0.07142857142857142, 'concept_blank_cell_on_left_concept_wall_top_left': 0.0, 'NOT_concept_wall_on_right_concept_wall_top_left': 0.07142857142857142, 'NOT_concept_pink_cell_on_right_concept_wall_top_left': 0.07142857142857142, 'NOT_concept_box_on_left_concept_wall_top_left': 0.07142857142857142, 'NOT_concept_wall_down_left_concept_wall_top_left': 0.07142857142857142, 'NOT_concept_pink_cell_below_concept_wall_top_left': 0.07142857142857142, 'NOT_concept_wall_below_concept_wall_top_left': 0.07142857142857142, 'NOT_concept_blank_cell_below_concept_target_on_right': 0.0, 'concept_no_wall_on_right_m_concept_target_on_right': 0.0, 'concept_target_on_right_concept_wall_below': 0.0, 'NOT_concept_no_wall_on_left_m_concept_target_on_right': 0.0, 'NOT_concept_wall_top_left_concept_target_on_right': 0.0, 'NOT_concept_box_below_concept_target_on_right': 0.0, 'NOT_concept_wall_above_box_concept_target_on_right': 0.0, 'concept_pink_cell_on_top_concept_target_on_right': 0.0, 'NOT_concept_no_pink_cell_on_top_m_concept_target_on_right': 0.0, 'NOT_concept_wall_on_right_of_box_concept_target_on_right': 0.0, 'NOT_concept_no_wall_on_top_m_concept_target_on_right': 0.0, 'concept_on_pink_cell_concept_target_on_right': 0.0, 'concept_target_on_right_concept_target_on_top': 0.0, 'concept_target_on_right_concept_wall_down_left': 0.0, 'concept_target_on_right_concept_wall_on_left': 0.0, 'NOT_concept_no_pink_cell_below_m_concept_target_on_right': 0.0, 'concept_target_on_right_concept_wall_up_down_right': 0.0, 'concept_target_on_right_concept_wall_on_top': 0.0, 'concept_target_on_right_concept_wall_above_box': 0.0, 'concept_target_on_right_concept_wall_on_right_of_box': 0.0, 'concept_box_on_left_concept_target_on_right': 0.0, 'concept_no_wall_on_top_m_concept_target_on_right': 0.0, 'NOT_concept_pink_cell_on_top_concept_target_on_right': 0.0, 'concept_no_pink_cell_on_top_m_concept_target_on_right': 0.0, 'NOT_concept_no_wall_below_m_concept_target_on_right': 0.0, 'concept_target_on_right_concept_wall_below_box': 0.0, 'concept_target_on_right_concept_wall_on_right': 0.0, 'concept_pink_cell_below_concept_target_on_right': 0.0, 'NOT_concept_blank_cell_on_left_concept_target_on_right': 0.0, 'NOT_concept_target_on_right_concept_target_on_right': 0.0, 'concept_no_pink_cell_below_m_concept_target_on_right': 0.0, 'NOT_concept_target_on_top_concept_target_on_right': 0.0, 'NOT_concept_wall_top_right_concept_target_on_right': 0.0, 'concept_box_on_top_concept_target_on_right': 0.0, 'concept_no_wall_below_m_concept_target_on_right': 0.0, 'NOT_concept_wall_on_left_concept_target_on_right': 0.0, 'concept_target_on_right_concept_wall_on_left_of_box': 0.0, 'NOT_concept_box_on_top_concept_target_on_right': 0.0, 'concept_blank_cell_on_left_concept_target_on_right': 0.0, 'NOT_concept_wall_on_right_concept_target_on_right': 0.0, 'NOT_concept_pink_cell_on_right_concept_target_on_right': 0.0, 'NOT_concept_box_on_left_concept_target_on_right': 0.0, 'NOT_concept_wall_down_left_concept_target_on_right': 0.0, 'NOT_concept_pink_cell_below_concept_target_on_right': 0.0, 'NOT_concept_wall_below_concept_target_on_right': 0.0, 'NOT_concept_blank_cell_below_concept_no_wall_on_right_m': 0.35714285714285715, 'NOT_concept_blank_cell_below_concept_wall_below': 0.21428571428571427, 'NOT_concept_blank_cell_below_NOT_concept_no_wall_on_left_m': 0.21428571428571427, 'NOT_concept_blank_cell_below_NOT_concept_wall_top_left': 0.35714285714285715, 'NOT_concept_blank_cell_below_NOT_concept_box_below': 0.35714285714285715, 'NOT_concept_blank_cell_below_NOT_concept_wall_above_box': 0.2857142857142857, 'NOT_concept_blank_cell_below_concept_pink_cell_on_top': 0.0, 'NOT_concept_blank_cell_below_NOT_concept_no_pink_cell_on_top_m': 0.0, 'NOT_concept_blank_cell_below_NOT_concept_wall_on_right_of_box': 0.35714285714285715, 'NOT_concept_blank_cell_below_NOT_concept_no_wall_on_top_m': 0.07142857142857142, 'NOT_concept_blank_cell_below_concept_on_pink_cell': 0.0, 'NOT_concept_blank_cell_below_concept_target_on_top': 0.0, 'NOT_concept_blank_cell_below_concept_wall_down_left': 0.07142857142857142, 'NOT_concept_blank_cell_below_concept_wall_on_left': 0.07142857142857142, 'NOT_concept_blank_cell_below_NOT_concept_no_pink_cell_below_m': 0.35714285714285715, 'NOT_concept_blank_cell_below_concept_wall_up_down_right': 0.0, 'NOT_concept_blank_cell_below_concept_wall_on_top': 0.0, 'NOT_concept_blank_cell_below_concept_wall_above_box': 0.07142857142857142, 'NOT_concept_blank_cell_below_concept_wall_on_right_of_box': 0.0, 'NOT_concept_blank_cell_below_concept_box_on_left': 0.0, 'NOT_concept_blank_cell_below_concept_no_wall_on_top_m': 0.2857142857142857, 'NOT_concept_blank_cell_below_NOT_concept_pink_cell_on_top': 0.35714285714285715, 'NOT_concept_blank_cell_below_concept_no_pink_cell_on_top_m': 0.35714285714285715, 'NOT_concept_blank_cell_below_NOT_concept_no_wall_below_m': 0.21428571428571427, 'NOT_concept_blank_cell_below_concept_wall_below_box': 0.21428571428571427, 'NOT_concept_blank_cell_below_concept_wall_on_right': 0.0, 'NOT_concept_blank_cell_below_concept_pink_cell_below': 0.14285714285714285, 'NOT_concept_blank_cell_below_NOT_concept_blank_cell_on_left': 0.07142857142857142, 'NOT_concept_blank_cell_below_NOT_concept_target_on_right': 0.35714285714285715, 'NOT_concept_blank_cell_below_concept_no_pink_cell_below_m': 0.0, 'NOT_concept_blank_cell_below_NOT_concept_target_on_top': 0.35714285714285715, 'NOT_concept_blank_cell_below_NOT_concept_wall_top_right': 0.35714285714285715, 'NOT_concept_blank_cell_below_concept_box_on_top': 0.0, 'NOT_concept_blank_cell_below_concept_no_wall_below_m': 0.14285714285714285, 'NOT_concept_blank_cell_below_NOT_concept_wall_on_left': 0.2857142857142857, 'NOT_concept_blank_cell_below_concept_wall_on_left_of_box': 0.0, 'NOT_concept_blank_cell_below_NOT_concept_box_on_top': 0.35714285714285715, 'NOT_concept_blank_cell_below_concept_blank_cell_on_left': 0.2857142857142857, 'NOT_concept_blank_cell_below_NOT_concept_wall_on_right': 0.35714285714285715, 'NOT_concept_blank_cell_below_NOT_concept_pink_cell_on_right': 0.35714285714285715, 'NOT_concept_blank_cell_below_NOT_concept_box_on_left': 0.35714285714285715, 'NOT_concept_blank_cell_below_NOT_concept_wall_down_left': 0.2857142857142857, 'NOT_concept_blank_cell_below_NOT_concept_pink_cell_below': 0.21428571428571427, 'NOT_concept_blank_cell_below_NOT_concept_wall_below': 0.14285714285714285, 'concept_no_wall_on_right_m_concept_wall_below': 0.21428571428571427, 'NOT_concept_no_wall_on_left_m_concept_no_wall_on_right_m': 0.7857142857142857, 'NOT_concept_wall_top_left_concept_no_wall_on_right_m': 0.9285714285714286, 'NOT_concept_box_below_concept_no_wall_on_right_m': 1.0, 'NOT_concept_wall_above_box_concept_no_wall_on_right_m': 0.7142857142857143, 'concept_no_wall_on_right_m_concept_pink_cell_on_top': 0.0, 'NOT_concept_no_pink_cell_on_top_m_concept_no_wall_on_right_m': 0.14285714285714285, 'NOT_concept_wall_on_right_of_box_concept_no_wall_on_right_m': 1.0, 'NOT_concept_no_wall_on_top_m_concept_no_wall_on_right_m': 0.35714285714285715, 'concept_no_wall_on_right_m_concept_on_pink_cell': 0.21428571428571427, 'concept_no_wall_on_right_m_concept_target_on_top': 0.07142857142857142, 'concept_no_wall_on_right_m_concept_wall_down_left': 0.07142857142857142, 'concept_no_wall_on_right_m_concept_wall_on_left': 0.5, 'NOT_concept_no_pink_cell_below_m_concept_no_wall_on_right_m': 0.35714285714285715, 'concept_no_wall_on_right_m_concept_wall_up_down_right': 0.0, 'concept_no_wall_on_right_m_concept_wall_on_top': 0.14285714285714285, 'concept_no_wall_on_right_m_concept_wall_above_box': 0.2857142857142857, 'concept_no_wall_on_right_m_concept_wall_on_right_of_box': 0.0, 'concept_box_on_left_concept_no_wall_on_right_m': 0.0, 'concept_no_wall_on_right_m_concept_no_wall_on_top_m': 0.6428571428571429, 'NOT_concept_pink_cell_on_top_concept_no_wall_on_right_m': 1.0, 'concept_no_pink_cell_on_top_m_concept_no_wall_on_right_m': 0.8571428571428571, 'NOT_concept_no_wall_below_m_concept_no_wall_on_right_m': 0.35714285714285715, 'concept_no_wall_on_right_m_concept_wall_below_box': 0.21428571428571427, 'concept_no_wall_on_right_m_concept_wall_on_right': 0.0, 'concept_no_wall_on_right_m_concept_pink_cell_below': 0.14285714285714285, 'NOT_concept_blank_cell_on_left_concept_no_wall_on_right_m': 0.5, 'NOT_concept_target_on_right_concept_no_wall_on_right_m': 1.0, 'concept_no_pink_cell_below_m_concept_no_wall_on_right_m': 0.6428571428571429, 'NOT_concept_target_on_top_concept_no_wall_on_right_m': 0.9285714285714286, 'NOT_concept_wall_top_right_concept_no_wall_on_right_m': 1.0, 'concept_box_on_top_concept_no_wall_on_right_m': 0.0, 'concept_no_wall_below_m_concept_no_wall_on_right_m': 0.6428571428571429, 'NOT_concept_wall_on_left_concept_no_wall_on_right_m': 0.5, 'concept_no_wall_on_right_m_concept_wall_on_left_of_box': 0.0, 'NOT_concept_box_on_top_concept_no_wall_on_right_m': 1.0, 'concept_blank_cell_on_left_concept_no_wall_on_right_m': 0.5, 'NOT_concept_wall_on_right_concept_no_wall_on_right_m': 1.0, 'NOT_concept_pink_cell_on_right_concept_no_wall_on_right_m': 0.7857142857142857, 'NOT_concept_box_on_left_concept_no_wall_on_right_m': 1.0, 'NOT_concept_wall_down_left_concept_no_wall_on_right_m': 0.9285714285714286, 'NOT_concept_pink_cell_below_concept_no_wall_on_right_m': 0.8571428571428571, 'NOT_concept_wall_below_concept_no_wall_on_right_m': 0.7857142857142857, 'NOT_concept_no_wall_on_left_m_concept_wall_below': 0.14285714285714285, 'NOT_concept_wall_top_left_concept_wall_below': 0.21428571428571427, 'NOT_concept_box_below_concept_wall_below': 0.21428571428571427, 'NOT_concept_wall_above_box_concept_wall_below': 0.14285714285714285, 'concept_pink_cell_on_top_concept_wall_below': 0.0, 'NOT_concept_no_pink_cell_on_top_m_concept_wall_below': 0.0, 'NOT_concept_wall_on_right_of_box_concept_wall_below': 0.21428571428571427, 'NOT_concept_no_wall_on_top_m_concept_wall_below': 0.0, 'concept_on_pink_cell_concept_wall_below': 0.0, 'concept_target_on_top_concept_wall_below': 0.0, 'concept_wall_below_concept_wall_down_left': 0.07142857142857142, 'concept_wall_below_concept_wall_on_left': 0.07142857142857142, 'NOT_concept_no_pink_cell_below_m_concept_wall_below': 0.21428571428571427, 'concept_wall_below_concept_wall_up_down_right': 0.0, 'concept_wall_below_concept_wall_on_top': 0.0, 'concept_wall_above_box_concept_wall_below': 0.07142857142857142, 'concept_wall_below_concept_wall_on_right_of_box': 0.0, 'concept_box_on_left_concept_wall_below': 0.0, 'concept_no_wall_on_top_m_concept_wall_below': 0.21428571428571427, 'NOT_concept_pink_cell_on_top_concept_wall_below': 0.21428571428571427, 'concept_no_pink_cell_on_top_m_concept_wall_below': 0.21428571428571427, 'NOT_concept_no_wall_below_m_concept_wall_below': 0.21428571428571427, 'concept_wall_below_concept_wall_below_box': 0.21428571428571427, 'concept_wall_below_concept_wall_on_right': 0.0, 'concept_pink_cell_below_concept_wall_below': 0.0, 'NOT_concept_blank_cell_on_left_concept_wall_below': 0.07142857142857142, 'NOT_concept_target_on_right_concept_wall_below': 0.21428571428571427, 'concept_no_pink_cell_below_m_concept_wall_below': 0.0, 'NOT_concept_target_on_top_concept_wall_below': 0.21428571428571427, 'NOT_concept_wall_top_right_concept_wall_below': 0.21428571428571427, 'concept_box_on_top_concept_wall_below': 0.0, 'concept_no_wall_below_m_concept_wall_below': 0.0, 'NOT_concept_wall_on_left_concept_wall_below': 0.14285714285714285, 'concept_wall_below_concept_wall_on_left_of_box': 0.0, 'NOT_concept_box_on_top_concept_wall_below': 0.21428571428571427, 'concept_blank_cell_on_left_concept_wall_below': 0.14285714285714285, 'NOT_concept_wall_on_right_concept_wall_below': 0.21428571428571427, 'NOT_concept_pink_cell_on_right_concept_wall_below': 0.21428571428571427, 'NOT_concept_box_on_left_concept_wall_below': 0.21428571428571427, 'NOT_concept_wall_down_left_concept_wall_below': 0.14285714285714285, 'NOT_concept_pink_cell_below_concept_wall_below': 0.21428571428571427, 'NOT_concept_wall_below_concept_wall_below': 0.0, 'NOT_concept_no_wall_on_left_m_NOT_concept_wall_top_left': 0.7142857142857143, 'NOT_concept_box_below_NOT_concept_no_wall_on_left_m': 0.7857142857142857, 'NOT_concept_no_wall_on_left_m_NOT_concept_wall_above_box': 0.6428571428571429, 'NOT_concept_no_wall_on_left_m_concept_pink_cell_on_top': 0.0, 'NOT_concept_no_pink_cell_on_top_m_NOT_concept_no_wall_on_left_m': 0.14285714285714285, 'NOT_concept_no_wall_on_left_m_NOT_concept_wall_on_right_of_box': 0.7857142857142857, 'NOT_concept_no_wall_on_left_m_NOT_concept_no_wall_on_top_m': 0.21428571428571427, 'NOT_concept_no_wall_on_left_m_concept_on_pink_cell': 0.21428571428571427, 'NOT_concept_no_wall_on_left_m_concept_target_on_top': 0.0, 'NOT_concept_no_wall_on_left_m_concept_wall_down_left': 0.07142857142857142, 'NOT_concept_no_wall_on_left_m_concept_wall_on_left': 0.5, 'NOT_concept_no_pink_cell_below_m_NOT_concept_no_wall_on_left_m': 0.21428571428571427, 'NOT_concept_no_wall_on_left_m_concept_wall_up_down_right': 0.0, 'NOT_concept_no_wall_on_left_m_concept_wall_on_top': 0.14285714285714285, 'NOT_concept_no_wall_on_left_m_concept_wall_above_box': 0.14285714285714285, 'NOT_concept_no_wall_on_left_m_concept_wall_on_right_of_box': 0.0, 'NOT_concept_no_wall_on_left_m_concept_box_on_left': 0.0, 'NOT_concept_no_wall_on_left_m_concept_no_wall_on_top_m': 0.5714285714285714, 'NOT_concept_no_wall_on_left_m_NOT_concept_pink_cell_on_top': 0.7857142857142857, 'NOT_concept_no_wall_on_left_m_concept_no_pink_cell_on_top_m': 0.6428571428571429, 'NOT_concept_no_wall_below_m_NOT_concept_no_wall_on_left_m': 0.2857142857142857, 'NOT_concept_no_wall_on_left_m_concept_wall_below_box': 0.14285714285714285, 'NOT_concept_no_wall_on_left_m_concept_wall_on_right': 0.0, 'NOT_concept_no_wall_on_left_m_concept_pink_cell_below': 0.07142857142857142, 'NOT_concept_blank_cell_on_left_NOT_concept_no_wall_on_left_m': 0.5, 'NOT_concept_no_wall_on_left_m_NOT_concept_target_on_right': 0.7857142857142857, 'NOT_concept_no_wall_on_left_m_concept_no_pink_cell_below_m': 0.5714285714285714, 'NOT_concept_no_wall_on_left_m_NOT_concept_target_on_top': 0.7857142857142857, 'NOT_concept_no_wall_on_left_m_NOT_concept_wall_top_right': 0.7857142857142857, 'NOT_concept_no_wall_on_left_m_concept_box_on_top': 0.0, 'NOT_concept_no_wall_on_left_m_concept_no_wall_below_m': 0.5, 'NOT_concept_no_wall_on_left_m_NOT_concept_wall_on_left': 0.2857142857142857, 'NOT_concept_no_wall_on_left_m_concept_wall_on_left_of_box': 0.0, 'NOT_concept_box_on_top_NOT_concept_no_wall_on_left_m': 0.7857142857142857, 'NOT_concept_no_wall_on_left_m_concept_blank_cell_on_left': 0.2857142857142857, 'NOT_concept_no_wall_on_left_m_NOT_concept_wall_on_right': 0.7857142857142857, 'NOT_concept_no_wall_on_left_m_NOT_concept_pink_cell_on_right': 0.5714285714285714, 'NOT_concept_box_on_left_NOT_concept_no_wall_on_left_m': 0.7857142857142857, 'NOT_concept_no_wall_on_left_m_NOT_concept_wall_down_left': 0.7142857142857143, 'NOT_concept_no_wall_on_left_m_NOT_concept_pink_cell_below': 0.7142857142857143, 'NOT_concept_no_wall_on_left_m_NOT_concept_wall_below': 0.6428571428571429, 'NOT_concept_box_below_NOT_concept_wall_top_left': 0.9285714285714286, 'NOT_concept_wall_above_box_NOT_concept_wall_top_left': 0.7142857142857143, 'NOT_concept_wall_top_left_concept_pink_cell_on_top': 0.0, 'NOT_concept_no_pink_cell_on_top_m_NOT_concept_wall_top_left': 0.07142857142857142, 'NOT_concept_wall_on_right_of_box_NOT_concept_wall_top_left': 0.9285714285714286, 'NOT_concept_no_wall_on_top_m_NOT_concept_wall_top_left': 0.2857142857142857, 'NOT_concept_wall_top_left_concept_on_pink_cell': 0.21428571428571427, 'NOT_concept_wall_top_left_concept_target_on_top': 0.07142857142857142, 'NOT_concept_wall_top_left_concept_wall_down_left': 0.07142857142857142, 'NOT_concept_wall_top_left_concept_wall_on_left': 0.42857142857142855, 'NOT_concept_no_pink_cell_below_m_NOT_concept_wall_top_left': 0.35714285714285715, 'NOT_concept_wall_top_left_concept_wall_up_down_right': 0.0, 'NOT_concept_wall_top_left_concept_wall_on_top': 0.07142857142857142, 'NOT_concept_wall_top_left_concept_wall_above_box': 0.21428571428571427, 'NOT_concept_wall_top_left_concept_wall_on_right_of_box': 0.0, 'NOT_concept_wall_top_left_concept_box_on_left': 0.0, 'NOT_concept_wall_top_left_concept_no_wall_on_top_m': 0.6428571428571429, 'NOT_concept_pink_cell_on_top_NOT_concept_wall_top_left': 0.9285714285714286, 'NOT_concept_wall_top_left_concept_no_pink_cell_on_top_m': 0.8571428571428571, 'NOT_concept_no_wall_below_m_NOT_concept_wall_top_left': 0.2857142857142857, 'NOT_concept_wall_top_left_concept_wall_below_box': 0.21428571428571427, 'NOT_concept_wall_top_left_concept_wall_on_right': 0.0, 'NOT_concept_wall_top_left_concept_pink_cell_below': 0.14285714285714285, 'NOT_concept_blank_cell_on_left_NOT_concept_wall_top_left': 0.42857142857142855, 'NOT_concept_target_on_right_NOT_concept_wall_top_left': 0.9285714285714286, 'NOT_concept_wall_top_left_concept_no_pink_cell_below_m': 0.5714285714285714, 'NOT_concept_target_on_top_NOT_concept_wall_top_left': 0.8571428571428571, 'NOT_concept_wall_top_left_NOT_concept_wall_top_right': 0.9285714285714286, 'NOT_concept_wall_top_left_concept_box_on_top': 0.0, 'NOT_concept_wall_top_left_concept_no_wall_below_m': 0.6428571428571429, 'NOT_concept_wall_on_left_NOT_concept_wall_top_left': 0.5, 'NOT_concept_wall_top_left_concept_wall_on_left_of_box': 0.0, 'NOT_concept_box_on_top_NOT_concept_wall_top_left': 0.9285714285714286, 'NOT_concept_wall_top_left_concept_blank_cell_on_left': 0.5, 'NOT_concept_wall_on_right_NOT_concept_wall_top_left': 0.9285714285714286, 'NOT_concept_pink_cell_on_right_NOT_concept_wall_top_left': 0.7142857142857143, 'NOT_concept_box_on_left_NOT_concept_wall_top_left': 0.9285714285714286, 'NOT_concept_wall_down_left_NOT_concept_wall_top_left': 0.8571428571428571, 'NOT_concept_pink_cell_below_NOT_concept_wall_top_left': 0.7857142857142857, 'NOT_concept_wall_below_NOT_concept_wall_top_left': 0.7142857142857143, 'NOT_concept_box_below_NOT_concept_wall_above_box': 0.7142857142857143, 'NOT_concept_box_below_concept_pink_cell_on_top': 0.0, 'NOT_concept_box_below_NOT_concept_no_pink_cell_on_top_m': 0.14285714285714285, 'NOT_concept_box_below_NOT_concept_wall_on_right_of_box': 1.0, 'NOT_concept_box_below_NOT_concept_no_wall_on_top_m': 0.35714285714285715, 'NOT_concept_box_below_concept_on_pink_cell': 0.21428571428571427, 'NOT_concept_box_below_concept_target_on_top': 0.07142857142857142, 'NOT_concept_box_below_concept_wall_down_left': 0.07142857142857142, 'NOT_concept_box_below_concept_wall_on_left': 0.5, 'NOT_concept_box_below_NOT_concept_no_pink_cell_below_m': 0.35714285714285715, 'NOT_concept_box_below_concept_wall_up_down_right': 0.0, 'NOT_concept_box_below_concept_wall_on_top': 0.14285714285714285, 'NOT_concept_box_below_concept_wall_above_box': 0.2857142857142857, 'NOT_concept_box_below_concept_wall_on_right_of_box': 0.0, 'NOT_concept_box_below_concept_box_on_left': 0.0, 'NOT_concept_box_below_concept_no_wall_on_top_m': 0.6428571428571429, 'NOT_concept_box_below_NOT_concept_pink_cell_on_top': 1.0, 'NOT_concept_box_below_concept_no_pink_cell_on_top_m': 0.8571428571428571, 'NOT_concept_box_below_NOT_concept_no_wall_below_m': 0.35714285714285715, 'NOT_concept_box_below_concept_wall_below_box': 0.21428571428571427, 'NOT_concept_box_below_concept_wall_on_right': 0.0, 'NOT_concept_box_below_concept_pink_cell_below': 0.14285714285714285, 'NOT_concept_blank_cell_on_left_NOT_concept_box_below': 0.5, 'NOT_concept_box_below_NOT_concept_target_on_right': 1.0, 'NOT_concept_box_below_concept_no_pink_cell_below_m': 0.6428571428571429, 'NOT_concept_box_below_NOT_concept_target_on_top': 0.9285714285714286, 'NOT_concept_box_below_NOT_concept_wall_top_right': 1.0, 'NOT_concept_box_below_concept_box_on_top': 0.0, 'NOT_concept_box_below_concept_no_wall_below_m': 0.6428571428571429, 'NOT_concept_box_below_NOT_concept_wall_on_left': 0.5, 'NOT_concept_box_below_concept_wall_on_left_of_box': 0.0, 'NOT_concept_box_below_NOT_concept_box_on_top': 1.0, 'NOT_concept_box_below_concept_blank_cell_on_left': 0.5, 'NOT_concept_box_below_NOT_concept_wall_on_right': 1.0, 'NOT_concept_box_below_NOT_concept_pink_cell_on_right': 0.7857142857142857, 'NOT_concept_box_below_NOT_concept_box_on_left': 1.0, 'NOT_concept_box_below_NOT_concept_wall_down_left': 0.9285714285714286, 'NOT_concept_box_below_NOT_concept_pink_cell_below': 0.8571428571428571, 'NOT_concept_box_below_NOT_concept_wall_below': 0.7857142857142857, 'NOT_concept_wall_above_box_concept_pink_cell_on_top': 0.0, 'NOT_concept_no_pink_cell_on_top_m_NOT_concept_wall_above_box': 0.0, 'NOT_concept_wall_above_box_NOT_concept_wall_on_right_of_box': 0.7142857142857143, 'NOT_concept_no_wall_on_top_m_NOT_concept_wall_above_box': 0.14285714285714285, 'NOT_concept_wall_above_box_concept_on_pink_cell': 0.21428571428571427, 'NOT_concept_wall_above_box_concept_target_on_top': 0.0, 'NOT_concept_wall_above_box_concept_wall_down_left': 0.07142857142857142, 'NOT_concept_wall_above_box_concept_wall_on_left': 0.42857142857142855, 'NOT_concept_no_pink_cell_below_m_NOT_concept_wall_above_box': 0.2857142857142857, 'NOT_concept_wall_above_box_concept_wall_up_down_right': 0.0, 'NOT_concept_wall_above_box_concept_wall_on_top': 0.0, 'NOT_concept_wall_above_box_concept_wall_above_box': 0.0, 'NOT_concept_wall_above_box_concept_wall_on_right_of_box': 0.0, 'NOT_concept_wall_above_box_concept_box_on_left': 0.0, 'NOT_concept_wall_above_box_concept_no_wall_on_top_m': 0.5714285714285714, 'NOT_concept_pink_cell_on_top_NOT_concept_wall_above_box': 0.7142857142857143, 'NOT_concept_wall_above_box_concept_no_pink_cell_on_top_m': 0.7142857142857143, 'NOT_concept_no_wall_below_m_NOT_concept_wall_above_box': 0.21428571428571427, 'NOT_concept_wall_above_box_concept_wall_below_box': 0.14285714285714285, 'NOT_concept_wall_above_box_concept_wall_on_right': 0.0, 'NOT_concept_wall_above_box_concept_pink_cell_below': 0.14285714285714285, 'NOT_concept_blank_cell_on_left_NOT_concept_wall_above_box': 0.42857142857142855, 'NOT_concept_target_on_right_NOT_concept_wall_above_box': 0.7142857142857143, 'NOT_concept_wall_above_box_concept_no_pink_cell_below_m': 0.42857142857142855, 'NOT_concept_target_on_top_NOT_concept_wall_above_box': 0.7142857142857143, 'NOT_concept_wall_above_box_NOT_concept_wall_top_right': 0.7142857142857143, 'NOT_concept_wall_above_box_concept_box_on_top': 0.0, 'NOT_concept_wall_above_box_concept_no_wall_below_m': 0.5, 'NOT_concept_wall_above_box_NOT_concept_wall_on_left': 0.2857142857142857, 'NOT_concept_wall_above_box_concept_wall_on_left_of_box': 0.0, 'NOT_concept_box_on_top_NOT_concept_wall_above_box': 0.7142857142857143, 'NOT_concept_wall_above_box_concept_blank_cell_on_left': 0.2857142857142857, 'NOT_concept_wall_above_box_NOT_concept_wall_on_right': 0.7142857142857143, 'NOT_concept_pink_cell_on_right_NOT_concept_wall_above_box': 0.5, 'NOT_concept_box_on_left_NOT_concept_wall_above_box': 0.7142857142857143, 'NOT_concept_wall_above_box_NOT_concept_wall_down_left': 0.6428571428571429, 'NOT_concept_pink_cell_below_NOT_concept_wall_above_box': 0.5714285714285714, 'NOT_concept_wall_above_box_NOT_concept_wall_below': 0.5714285714285714, 'NOT_concept_no_pink_cell_on_top_m_concept_pink_cell_on_top': 0.0, 'NOT_concept_wall_on_right_of_box_concept_pink_cell_on_top': 0.0, 'NOT_concept_no_wall_on_top_m_concept_pink_cell_on_top': 0.0, 'concept_on_pink_cell_concept_pink_cell_on_top': 0.0, 'concept_pink_cell_on_top_concept_target_on_top': 0.0, 'concept_pink_cell_on_top_concept_wall_down_left': 0.0, 'concept_pink_cell_on_top_concept_wall_on_left': 0.0, 'NOT_concept_no_pink_cell_below_m_concept_pink_cell_on_top': 0.0, 'concept_pink_cell_on_top_concept_wall_up_down_right': 0.0, 'concept_pink_cell_on_top_concept_wall_on_top': 0.0, 'concept_pink_cell_on_top_concept_wall_above_box': 0.0, 'concept_pink_cell_on_top_concept_wall_on_right_of_box': 0.0, 'concept_box_on_left_concept_pink_cell_on_top': 0.0, 'concept_no_wall_on_top_m_concept_pink_cell_on_top': 0.0, 'NOT_concept_pink_cell_on_top_concept_pink_cell_on_top': 0.0, 'concept_no_pink_cell_on_top_m_concept_pink_cell_on_top': 0.0, 'NOT_concept_no_wall_below_m_concept_pink_cell_on_top': 0.0, 'concept_pink_cell_on_top_concept_wall_below_box': 0.0, 'concept_pink_cell_on_top_concept_wall_on_right': 0.0, 'concept_pink_cell_below_concept_pink_cell_on_top': 0.0, 'NOT_concept_blank_cell_on_left_concept_pink_cell_on_top': 0.0, 'NOT_concept_target_on_right_concept_pink_cell_on_top': 0.0, 'concept_no_pink_cell_below_m_concept_pink_cell_on_top': 0.0, 'NOT_concept_target_on_top_concept_pink_cell_on_top': 0.0, 'NOT_concept_wall_top_right_concept_pink_cell_on_top': 0.0, 'concept_box_on_top_concept_pink_cell_on_top': 0.0, 'concept_no_wall_below_m_concept_pink_cell_on_top': 0.0, 'NOT_concept_wall_on_left_concept_pink_cell_on_top': 0.0, 'concept_pink_cell_on_top_concept_wall_on_left_of_box': 0.0, 'NOT_concept_box_on_top_concept_pink_cell_on_top': 0.0, 'concept_blank_cell_on_left_concept_pink_cell_on_top': 0.0, 'NOT_concept_wall_on_right_concept_pink_cell_on_top': 0.0, 'NOT_concept_pink_cell_on_right_concept_pink_cell_on_top': 0.0, 'NOT_concept_box_on_left_concept_pink_cell_on_top': 0.0, 'NOT_concept_wall_down_left_concept_pink_cell_on_top': 0.0, 'NOT_concept_pink_cell_below_concept_pink_cell_on_top': 0.0, 'NOT_concept_wall_below_concept_pink_cell_on_top': 0.0, 'NOT_concept_no_pink_cell_on_top_m_NOT_concept_wall_on_right_of_box': 0.14285714285714285, 'NOT_concept_no_pink_cell_on_top_m_NOT_concept_no_wall_on_top_m': 0.14285714285714285, 'NOT_concept_no_pink_cell_on_top_m_concept_on_pink_cell': 0.0, 'NOT_concept_no_pink_cell_on_top_m_concept_target_on_top': 0.0, 'NOT_concept_no_pink_cell_on_top_m_concept_wall_down_left': 0.0, 'NOT_concept_no_pink_cell_on_top_m_concept_wall_on_left': 0.07142857142857142, 'NOT_concept_no_pink_cell_below_m_NOT_concept_no_pink_cell_on_top_m': 0.0, 'NOT_concept_no_pink_cell_on_top_m_concept_wall_up_down_right': 0.0, 'NOT_concept_no_pink_cell_on_top_m_concept_wall_on_top': 0.14285714285714285, 'NOT_concept_no_pink_cell_on_top_m_concept_wall_above_box': 0.14285714285714285, 'NOT_concept_no_pink_cell_on_top_m_concept_wall_on_right_of_box': 0.0, 'NOT_concept_no_pink_cell_on_top_m_concept_box_on_left': 0.0, 'NOT_concept_no_pink_cell_on_top_m_concept_no_wall_on_top_m': 0.0, 'NOT_concept_no_pink_cell_on_top_m_NOT_concept_pink_cell_on_top': 0.14285714285714285, 'NOT_concept_no_pink_cell_on_top_m_concept_no_pink_cell_on_top_m': 0.0, 'NOT_concept_no_pink_cell_on_top_m_NOT_concept_no_wall_below_m': 0.07142857142857142, 'NOT_concept_no_pink_cell_on_top_m_concept_wall_below_box': 0.0, 'NOT_concept_no_pink_cell_on_top_m_concept_wall_on_right': 0.0, 'NOT_concept_no_pink_cell_on_top_m_concept_pink_cell_below': 0.0, 'NOT_concept_blank_cell_on_left_NOT_concept_no_pink_cell_on_top_m': 0.07142857142857142, 'NOT_concept_no_pink_cell_on_top_m_NOT_concept_target_on_right': 0.14285714285714285, 'NOT_concept_no_pink_cell_on_top_m_concept_no_pink_cell_below_m': 0.14285714285714285, 'NOT_concept_no_pink_cell_on_top_m_NOT_concept_target_on_top': 0.14285714285714285, 'NOT_concept_no_pink_cell_on_top_m_NOT_concept_wall_top_right': 0.14285714285714285, 'NOT_concept_no_pink_cell_on_top_m_concept_box_on_top': 0.0, 'NOT_concept_no_pink_cell_on_top_m_concept_no_wall_below_m': 0.07142857142857142, 'NOT_concept_no_pink_cell_on_top_m_NOT_concept_wall_on_left': 0.07142857142857142, 'NOT_concept_no_pink_cell_on_top_m_concept_wall_on_left_of_box': 0.0, 'NOT_concept_box_on_top_NOT_concept_no_pink_cell_on_top_m': 0.14285714285714285, 'NOT_concept_no_pink_cell_on_top_m_concept_blank_cell_on_left': 0.07142857142857142, 'NOT_concept_no_pink_cell_on_top_m_NOT_concept_wall_on_right': 0.14285714285714285, 'NOT_concept_no_pink_cell_on_top_m_NOT_concept_pink_cell_on_right': 0.14285714285714285, 'NOT_concept_box_on_left_NOT_concept_no_pink_cell_on_top_m': 0.14285714285714285, 'NOT_concept_no_pink_cell_on_top_m_NOT_concept_wall_down_left': 0.14285714285714285, 'NOT_concept_no_pink_cell_on_top_m_NOT_concept_pink_cell_below': 0.14285714285714285, 'NOT_concept_no_pink_cell_on_top_m_NOT_concept_wall_below': 0.14285714285714285, 'NOT_concept_no_wall_on_top_m_NOT_concept_wall_on_right_of_box': 0.35714285714285715, 'NOT_concept_wall_on_right_of_box_concept_on_pink_cell': 0.21428571428571427, 'NOT_concept_wall_on_right_of_box_concept_target_on_top': 0.07142857142857142, 'NOT_concept_wall_on_right_of_box_concept_wall_down_left': 0.07142857142857142, 'NOT_concept_wall_on_right_of_box_concept_wall_on_left': 0.5, 'NOT_concept_no_pink_cell_below_m_NOT_concept_wall_on_right_of_box': 0.35714285714285715, 'NOT_concept_wall_on_right_of_box_concept_wall_up_down_right': 0.0, 'NOT_concept_wall_on_right_of_box_concept_wall_on_top': 0.14285714285714285, 'NOT_concept_wall_on_right_of_box_concept_wall_above_box': 0.2857142857142857, 'NOT_concept_wall_on_right_of_box_concept_wall_on_right_of_box': 0.0, 'NOT_concept_wall_on_right_of_box_concept_box_on_left': 0.0, 'NOT_concept_wall_on_right_of_box_concept_no_wall_on_top_m': 0.6428571428571429, 'NOT_concept_pink_cell_on_top_NOT_concept_wall_on_right_of_box': 1.0, 'NOT_concept_wall_on_right_of_box_concept_no_pink_cell_on_top_m': 0.8571428571428571, 'NOT_concept_no_wall_below_m_NOT_concept_wall_on_right_of_box': 0.35714285714285715, 'NOT_concept_wall_on_right_of_box_concept_wall_below_box': 0.21428571428571427, 'NOT_concept_wall_on_right_of_box_concept_wall_on_right': 0.0, 'NOT_concept_wall_on_right_of_box_concept_pink_cell_below': 0.14285714285714285, 'NOT_concept_blank_cell_on_left_NOT_concept_wall_on_right_of_box': 0.5, 'NOT_concept_target_on_right_NOT_concept_wall_on_right_of_box': 1.0, 'NOT_concept_wall_on_right_of_box_concept_no_pink_cell_below_m': 0.6428571428571429, 'NOT_concept_target_on_top_NOT_concept_wall_on_right_of_box': 0.9285714285714286, 'NOT_concept_wall_on_right_of_box_NOT_concept_wall_top_right': 1.0, 'NOT_concept_wall_on_right_of_box_concept_box_on_top': 0.0, 'NOT_concept_wall_on_right_of_box_concept_no_wall_below_m': 0.6428571428571429, 'NOT_concept_wall_on_left_NOT_concept_wall_on_right_of_box': 0.5, 'NOT_concept_wall_on_right_of_box_concept_wall_on_left_of_box': 0.0, 'NOT_concept_box_on_top_NOT_concept_wall_on_right_of_box': 1.0, 'NOT_concept_wall_on_right_of_box_concept_blank_cell_on_left': 0.5, 'NOT_concept_wall_on_right_NOT_concept_wall_on_right_of_box': 1.0, 'NOT_concept_pink_cell_on_right_NOT_concept_wall_on_right_of_box': 0.7857142857142857, 'NOT_concept_box_on_left_NOT_concept_wall_on_right_of_box': 1.0, 'NOT_concept_wall_down_left_NOT_concept_wall_on_right_of_box': 0.9285714285714286, 'NOT_concept_pink_cell_below_NOT_concept_wall_on_right_of_box': 0.8571428571428571, 'NOT_concept_wall_below_NOT_concept_wall_on_right_of_box': 0.7857142857142857, 'NOT_concept_no_wall_on_top_m_concept_on_pink_cell': 0.0, 'NOT_concept_no_wall_on_top_m_concept_target_on_top': 0.07142857142857142, 'NOT_concept_no_wall_on_top_m_concept_wall_down_left': 0.0, 'NOT_concept_no_wall_on_top_m_concept_wall_on_left': 0.07142857142857142, 'NOT_concept_no_pink_cell_below_m_NOT_concept_no_wall_on_top_m': 0.07142857142857142, 'NOT_concept_no_wall_on_top_m_concept_wall_up_down_right': 0.0, 'NOT_concept_no_wall_on_top_m_concept_wall_on_top': 0.14285714285714285, 'NOT_concept_no_wall_on_top_m_concept_wall_above_box': 0.21428571428571427, 'NOT_concept_no_wall_on_top_m_concept_wall_on_right_of_box': 0.0, 'NOT_concept_no_wall_on_top_m_concept_box_on_left': 0.0, 'NOT_concept_no_wall_on_top_m_concept_no_wall_on_top_m': 0.0, 'NOT_concept_no_wall_on_top_m_NOT_concept_pink_cell_on_top': 0.35714285714285715, 'NOT_concept_no_wall_on_top_m_concept_no_pink_cell_on_top_m': 0.21428571428571427, 'NOT_concept_no_wall_below_m_NOT_concept_no_wall_on_top_m': 0.07142857142857142, 'NOT_concept_no_wall_on_top_m_concept_wall_below_box': 0.0, 'NOT_concept_no_wall_on_top_m_concept_wall_on_right': 0.0, 'NOT_concept_no_wall_on_top_m_concept_pink_cell_below': 0.07142857142857142, 'NOT_concept_blank_cell_on_left_NOT_concept_no_wall_on_top_m': 0.07142857142857142, 'NOT_concept_no_wall_on_top_m_NOT_concept_target_on_right': 0.35714285714285715, 'NOT_concept_no_wall_on_top_m_concept_no_pink_cell_below_m': 0.2857142857142857, 'NOT_concept_no_wall_on_top_m_NOT_concept_target_on_top': 0.2857142857142857, 'NOT_concept_no_wall_on_top_m_NOT_concept_wall_top_right': 0.35714285714285715, 'NOT_concept_no_wall_on_top_m_concept_box_on_top': 0.0, 'NOT_concept_no_wall_on_top_m_concept_no_wall_below_m': 0.2857142857142857, 'NOT_concept_no_wall_on_top_m_NOT_concept_wall_on_left': 0.2857142857142857, 'NOT_concept_no_wall_on_top_m_concept_wall_on_left_of_box': 0.0, 'NOT_concept_box_on_top_NOT_concept_no_wall_on_top_m': 0.35714285714285715, 'NOT_concept_no_wall_on_top_m_concept_blank_cell_on_left': 0.2857142857142857, 'NOT_concept_no_wall_on_top_m_NOT_concept_wall_on_right': 0.35714285714285715, 'NOT_concept_no_wall_on_top_m_NOT_concept_pink_cell_on_right': 0.35714285714285715, 'NOT_concept_box_on_left_NOT_concept_no_wall_on_top_m': 0.35714285714285715, 'NOT_concept_no_wall_on_top_m_NOT_concept_wall_down_left': 0.35714285714285715, 'NOT_concept_no_wall_on_top_m_NOT_concept_pink_cell_below': 0.2857142857142857, 'NOT_concept_no_wall_on_top_m_NOT_concept_wall_below': 0.35714285714285715, 'concept_on_pink_cell_concept_target_on_top': 0.0, 'concept_on_pink_cell_concept_wall_down_left': 0.0, 'concept_on_pink_cell_concept_wall_on_left': 0.21428571428571427, 'NOT_concept_no_pink_cell_below_m_concept_on_pink_cell': 0.0, 'concept_on_pink_cell_concept_wall_up_down_right': 0.0, 'concept_on_pink_cell_concept_wall_on_top': 0.0, 'concept_on_pink_cell_concept_wall_above_box': 0.0, 'concept_on_pink_cell_concept_wall_on_right_of_box': 0.0, 'concept_box_on_left_concept_on_pink_cell': 0.0, 'concept_no_wall_on_top_m_concept_on_pink_cell': 0.21428571428571427, 'NOT_concept_pink_cell_on_top_concept_on_pink_cell': 0.21428571428571427, 'concept_no_pink_cell_on_top_m_concept_on_pink_cell': 0.21428571428571427, 'NOT_concept_no_wall_below_m_concept_on_pink_cell': 0.0, 'concept_on_pink_cell_concept_wall_below_box': 0.0, 'concept_on_pink_cell_concept_wall_on_right': 0.0, 'concept_on_pink_cell_concept_pink_cell_below': 0.0, 'NOT_concept_blank_cell_on_left_concept_on_pink_cell': 0.21428571428571427, 'NOT_concept_target_on_right_concept_on_pink_cell': 0.21428571428571427, 'concept_no_pink_cell_below_m_concept_on_pink_cell': 0.21428571428571427, 'NOT_concept_target_on_top_concept_on_pink_cell': 0.21428571428571427, 'NOT_concept_wall_top_right_concept_on_pink_cell': 0.21428571428571427, 'concept_box_on_top_concept_on_pink_cell': 0.0, 'concept_no_wall_below_m_concept_on_pink_cell': 0.21428571428571427, 'NOT_concept_wall_on_left_concept_on_pink_cell': 0.0, 'concept_on_pink_cell_concept_wall_on_left_of_box': 0.0, 'NOT_concept_box_on_top_concept_on_pink_cell': 0.21428571428571427, 'concept_blank_cell_on_left_concept_on_pink_cell': 0.0, 'NOT_concept_wall_on_right_concept_on_pink_cell': 0.21428571428571427, 'NOT_concept_pink_cell_on_right_concept_on_pink_cell': 0.0, 'NOT_concept_box_on_left_concept_on_pink_cell': 0.21428571428571427, 'NOT_concept_wall_down_left_concept_on_pink_cell': 0.21428571428571427, 'NOT_concept_pink_cell_below_concept_on_pink_cell': 0.21428571428571427, 'NOT_concept_wall_below_concept_on_pink_cell': 0.21428571428571427, 'concept_target_on_top_concept_wall_down_left': 0.0, 'concept_target_on_top_concept_wall_on_left': 0.0, 'NOT_concept_no_pink_cell_below_m_concept_target_on_top': 0.0, 'concept_target_on_top_concept_wall_up_down_right': 0.0, 'concept_target_on_top_concept_wall_on_top': 0.0, 'concept_target_on_top_concept_wall_above_box': 0.07142857142857142, 'concept_target_on_top_concept_wall_on_right_of_box': 0.0, 'concept_box_on_left_concept_target_on_top': 0.0, 'concept_no_wall_on_top_m_concept_target_on_top': 0.0, 'NOT_concept_pink_cell_on_top_concept_target_on_top': 0.07142857142857142, 'concept_no_pink_cell_on_top_m_concept_target_on_top': 0.07142857142857142, 'NOT_concept_no_wall_below_m_concept_target_on_top': 0.0, 'concept_target_on_top_concept_wall_below_box': 0.0, 'concept_target_on_top_concept_wall_on_right': 0.0, 'concept_pink_cell_below_concept_target_on_top': 0.0, 'NOT_concept_blank_cell_on_left_concept_target_on_top': 0.0, 'NOT_concept_target_on_right_concept_target_on_top': 0.07142857142857142, 'concept_no_pink_cell_below_m_concept_target_on_top': 0.07142857142857142, 'NOT_concept_target_on_top_concept_target_on_top': 0.0, 'NOT_concept_wall_top_right_concept_target_on_top': 0.07142857142857142, 'concept_box_on_top_concept_target_on_top': 0.0, 'concept_no_wall_below_m_concept_target_on_top': 0.07142857142857142, 'NOT_concept_wall_on_left_concept_target_on_top': 0.07142857142857142, 'concept_target_on_top_concept_wall_on_left_of_box': 0.0, 'NOT_concept_box_on_top_concept_target_on_top': 0.07142857142857142, 'concept_blank_cell_on_left_concept_target_on_top': 0.07142857142857142, 'NOT_concept_wall_on_right_concept_target_on_top': 0.07142857142857142, 'NOT_concept_pink_cell_on_right_concept_target_on_top': 0.07142857142857142, 'NOT_concept_box_on_left_concept_target_on_top': 0.07142857142857142, 'NOT_concept_wall_down_left_concept_target_on_top': 0.07142857142857142, 'NOT_concept_pink_cell_below_concept_target_on_top': 0.07142857142857142, 'NOT_concept_wall_below_concept_target_on_top': 0.07142857142857142, 'concept_wall_down_left_concept_wall_on_left': 0.07142857142857142, 'NOT_concept_no_pink_cell_below_m_concept_wall_down_left': 0.07142857142857142, 'concept_wall_down_left_concept_wall_up_down_right': 0.0, 'concept_wall_down_left_concept_wall_on_top': 0.0, 'concept_wall_above_box_concept_wall_down_left': 0.0, 'concept_wall_down_left_concept_wall_on_right_of_box': 0.0, 'concept_box_on_left_concept_wall_down_left': 0.0, 'concept_no_wall_on_top_m_concept_wall_down_left': 0.07142857142857142, 'NOT_concept_pink_cell_on_top_concept_wall_down_left': 0.07142857142857142, 'concept_no_pink_cell_on_top_m_concept_wall_down_left': 0.07142857142857142, 'NOT_concept_no_wall_below_m_concept_wall_down_left': 0.07142857142857142, 'concept_wall_below_box_concept_wall_down_left': 0.07142857142857142, 'concept_wall_down_left_concept_wall_on_right': 0.0, 'concept_pink_cell_below_concept_wall_down_left': 0.0, 'NOT_concept_blank_cell_on_left_concept_wall_down_left': 0.07142857142857142, 'NOT_concept_target_on_right_concept_wall_down_left': 0.07142857142857142, 'concept_no_pink_cell_below_m_concept_wall_down_left': 0.0, 'NOT_concept_target_on_top_concept_wall_down_left': 0.07142857142857142, 'NOT_concept_wall_top_right_concept_wall_down_left': 0.07142857142857142, 'concept_box_on_top_concept_wall_down_left': 0.0, 'concept_no_wall_below_m_concept_wall_down_left': 0.0, 'NOT_concept_wall_on_left_concept_wall_down_left': 0.0, 'concept_wall_down_left_concept_wall_on_left_of_box': 0.0, 'NOT_concept_box_on_top_concept_wall_down_left': 0.07142857142857142, 'concept_blank_cell_on_left_concept_wall_down_left': 0.0, 'NOT_concept_wall_on_right_concept_wall_down_left': 0.07142857142857142, 'NOT_concept_pink_cell_on_right_concept_wall_down_left': 0.07142857142857142, 'NOT_concept_box_on_left_concept_wall_down_left': 0.07142857142857142, 'NOT_concept_wall_down_left_concept_wall_down_left': 0.0, 'NOT_concept_pink_cell_below_concept_wall_down_left': 0.07142857142857142, 'NOT_concept_wall_below_concept_wall_down_left': 0.0, 'NOT_concept_no_pink_cell_below_m_concept_wall_on_left': 0.07142857142857142, 'concept_wall_on_left_concept_wall_up_down_right': 0.0, 'concept_wall_on_left_concept_wall_on_top': 0.07142857142857142, 'concept_wall_above_box_concept_wall_on_left': 0.07142857142857142, 'concept_wall_on_left_concept_wall_on_right_of_box': 0.0, 'concept_box_on_left_concept_wall_on_left': 0.0, 'concept_no_wall_on_top_m_concept_wall_on_left': 0.42857142857142855, 'NOT_concept_pink_cell_on_top_concept_wall_on_left': 0.5, 'concept_no_pink_cell_on_top_m_concept_wall_on_left': 0.42857142857142855, 'NOT_concept_no_wall_below_m_concept_wall_on_left': 0.21428571428571427, 'concept_wall_below_box_concept_wall_on_left': 0.07142857142857142, 'concept_wall_on_left_concept_wall_on_right': 0.0, 'concept_pink_cell_below_concept_wall_on_left': 0.0, 'NOT_concept_blank_cell_on_left_concept_wall_on_left': 0.5, 'NOT_concept_target_on_right_concept_wall_on_left': 0.5, 'concept_no_pink_cell_below_m_concept_wall_on_left': 0.42857142857142855, 'NOT_concept_target_on_top_concept_wall_on_left': 0.5, 'NOT_concept_wall_top_right_concept_wall_on_left': 0.5, 'concept_box_on_top_concept_wall_on_left': 0.0, 'concept_no_wall_below_m_concept_wall_on_left': 0.2857142857142857, 'NOT_concept_wall_on_left_concept_wall_on_left': 0.0, 'concept_wall_on_left_concept_wall_on_left_of_box': 0.0, 'NOT_concept_box_on_top_concept_wall_on_left': 0.5, 'concept_blank_cell_on_left_concept_wall_on_left': 0.0, 'NOT_concept_wall_on_right_concept_wall_on_left': 0.5, 'NOT_concept_pink_cell_on_right_concept_wall_on_left': 0.2857142857142857, 'NOT_concept_box_on_left_concept_wall_on_left': 0.5, 'NOT_concept_wall_down_left_concept_wall_on_left': 0.42857142857142855, 'NOT_concept_pink_cell_below_concept_wall_on_left': 0.5, 'NOT_concept_wall_below_concept_wall_on_left': 0.42857142857142855, 'NOT_concept_no_pink_cell_below_m_concept_wall_up_down_right': 0.0, 'NOT_concept_no_pink_cell_below_m_concept_wall_on_top': 0.0, 'NOT_concept_no_pink_cell_below_m_concept_wall_above_box': 0.07142857142857142, 'NOT_concept_no_pink_cell_below_m_concept_wall_on_right_of_box': 0.0, 'NOT_concept_no_pink_cell_below_m_concept_box_on_left': 0.0, 'NOT_concept_no_pink_cell_below_m_concept_no_wall_on_top_m': 0.2857142857142857, 'NOT_concept_no_pink_cell_below_m_NOT_concept_pink_cell_on_top': 0.35714285714285715, 'NOT_concept_no_pink_cell_below_m_concept_no_pink_cell_on_top_m': 0.35714285714285715, 'NOT_concept_no_pink_cell_below_m_NOT_concept_no_wall_below_m': 0.21428571428571427, 'NOT_concept_no_pink_cell_below_m_concept_wall_below_box': 0.21428571428571427, 'NOT_concept_no_pink_cell_below_m_concept_wall_on_right': 0.0, 'NOT_concept_no_pink_cell_below_m_concept_pink_cell_below': 0.14285714285714285, 'NOT_concept_blank_cell_on_left_NOT_concept_no_pink_cell_below_m': 0.07142857142857142, 'NOT_concept_no_pink_cell_below_m_NOT_concept_target_on_right': 0.35714285714285715, 'NOT_concept_no_pink_cell_below_m_concept_no_pink_cell_below_m': 0.0, 'NOT_concept_no_pink_cell_below_m_NOT_concept_target_on_top': 0.35714285714285715, 'NOT_concept_no_pink_cell_below_m_NOT_concept_wall_top_right': 0.35714285714285715, 'NOT_concept_no_pink_cell_below_m_concept_box_on_top': 0.0, 'NOT_concept_no_pink_cell_below_m_concept_no_wall_below_m': 0.14285714285714285, 'NOT_concept_no_pink_cell_below_m_NOT_concept_wall_on_left': 0.2857142857142857, 'NOT_concept_no_pink_cell_below_m_concept_wall_on_left_of_box': 0.0, 'NOT_concept_box_on_top_NOT_concept_no_pink_cell_below_m': 0.35714285714285715, 'NOT_concept_no_pink_cell_below_m_concept_blank_cell_on_left': 0.2857142857142857, 'NOT_concept_no_pink_cell_below_m_NOT_concept_wall_on_right': 0.35714285714285715, 'NOT_concept_no_pink_cell_below_m_NOT_concept_pink_cell_on_right': 0.35714285714285715, 'NOT_concept_box_on_left_NOT_concept_no_pink_cell_below_m': 0.35714285714285715, 'NOT_concept_no_pink_cell_below_m_NOT_concept_wall_down_left': 0.2857142857142857, 'NOT_concept_no_pink_cell_below_m_NOT_concept_pink_cell_below': 0.21428571428571427, 'NOT_concept_no_pink_cell_below_m_NOT_concept_wall_below': 0.14285714285714285, 'concept_wall_on_top_concept_wall_up_down_right': 0.0, 'concept_wall_above_box_concept_wall_up_down_right': 0.0, 'concept_wall_on_right_of_box_concept_wall_up_down_right': 0.0, 'concept_box_on_left_concept_wall_up_down_right': 0.0, 'concept_no_wall_on_top_m_concept_wall_up_down_right': 0.0, 'NOT_concept_pink_cell_on_top_concept_wall_up_down_right': 0.0, 'concept_no_pink_cell_on_top_m_concept_wall_up_down_right': 0.0, 'NOT_concept_no_wall_below_m_concept_wall_up_down_right': 0.0, 'concept_wall_below_box_concept_wall_up_down_right': 0.0, 'concept_wall_on_right_concept_wall_up_down_right': 0.0, 'concept_pink_cell_below_concept_wall_up_down_right': 0.0, 'NOT_concept_blank_cell_on_left_concept_wall_up_down_right': 0.0, 'NOT_concept_target_on_right_concept_wall_up_down_right': 0.0, 'concept_no_pink_cell_below_m_concept_wall_up_down_right': 0.0, 'NOT_concept_target_on_top_concept_wall_up_down_right': 0.0, 'NOT_concept_wall_top_right_concept_wall_up_down_right': 0.0, 'concept_box_on_top_concept_wall_up_down_right': 0.0, 'concept_no_wall_below_m_concept_wall_up_down_right': 0.0, 'NOT_concept_wall_on_left_concept_wall_up_down_right': 0.0, 'concept_wall_on_left_of_box_concept_wall_up_down_right': 0.0, 'NOT_concept_box_on_top_concept_wall_up_down_right': 0.0, 'concept_blank_cell_on_left_concept_wall_up_down_right': 0.0, 'NOT_concept_wall_on_right_concept_wall_up_down_right': 0.0, 'NOT_concept_pink_cell_on_right_concept_wall_up_down_right': 0.0, 'NOT_concept_box_on_left_concept_wall_up_down_right': 0.0, 'NOT_concept_wall_down_left_concept_wall_up_down_right': 0.0, 'NOT_concept_pink_cell_below_concept_wall_up_down_right': 0.0, 'NOT_concept_wall_below_concept_wall_up_down_right': 0.0, 'concept_wall_above_box_concept_wall_on_top': 0.14285714285714285, 'concept_wall_on_right_of_box_concept_wall_on_top': 0.0, 'concept_box_on_left_concept_wall_on_top': 0.0, 'concept_no_wall_on_top_m_concept_wall_on_top': 0.0, 'NOT_concept_pink_cell_on_top_concept_wall_on_top': 0.14285714285714285, 'concept_no_pink_cell_on_top_m_concept_wall_on_top': 0.0, 'NOT_concept_no_wall_below_m_concept_wall_on_top': 0.07142857142857142, 'concept_wall_below_box_concept_wall_on_top': 0.0, 'concept_wall_on_right_concept_wall_on_top': 0.0, 'concept_pink_cell_below_concept_wall_on_top': 0.0, 'NOT_concept_blank_cell_on_left_concept_wall_on_top': 0.07142857142857142, 'NOT_concept_target_on_right_concept_wall_on_top': 0.14285714285714285, 'concept_no_pink_cell_below_m_concept_wall_on_top': 0.14285714285714285, 'NOT_concept_target_on_top_concept_wall_on_top': 0.14285714285714285, 'NOT_concept_wall_top_right_concept_wall_on_top': 0.14285714285714285, 'concept_box_on_top_concept_wall_on_top': 0.0, 'concept_no_wall_below_m_concept_wall_on_top': 0.07142857142857142, 'NOT_concept_wall_on_left_concept_wall_on_top': 0.07142857142857142, 'concept_wall_on_left_of_box_concept_wall_on_top': 0.0, 'NOT_concept_box_on_top_concept_wall_on_top': 0.14285714285714285, 'concept_blank_cell_on_left_concept_wall_on_top': 0.07142857142857142, 'NOT_concept_wall_on_right_concept_wall_on_top': 0.14285714285714285, 'NOT_concept_pink_cell_on_right_concept_wall_on_top': 0.14285714285714285, 'NOT_concept_box_on_left_concept_wall_on_top': 0.14285714285714285, 'NOT_concept_wall_down_left_concept_wall_on_top': 0.14285714285714285, 'NOT_concept_pink_cell_below_concept_wall_on_top': 0.14285714285714285, 'NOT_concept_wall_below_concept_wall_on_top': 0.14285714285714285, 'concept_wall_above_box_concept_wall_on_right_of_box': 0.0, 'concept_box_on_left_concept_wall_above_box': 0.0, 'concept_no_wall_on_top_m_concept_wall_above_box': 0.07142857142857142, 'NOT_concept_pink_cell_on_top_concept_wall_above_box': 0.2857142857142857, 'concept_no_pink_cell_on_top_m_concept_wall_above_box': 0.14285714285714285, 'NOT_concept_no_wall_below_m_concept_wall_above_box': 0.14285714285714285, 'concept_wall_above_box_concept_wall_below_box': 0.07142857142857142, 'concept_wall_above_box_concept_wall_on_right': 0.0, 'concept_pink_cell_below_concept_wall_above_box': 0.0, 'NOT_concept_blank_cell_on_left_concept_wall_above_box': 0.07142857142857142, 'NOT_concept_target_on_right_concept_wall_above_box': 0.2857142857142857, 'concept_no_pink_cell_below_m_concept_wall_above_box': 0.21428571428571427, 'NOT_concept_target_on_top_concept_wall_above_box': 0.21428571428571427, 'NOT_concept_wall_top_right_concept_wall_above_box': 0.2857142857142857, 'concept_box_on_top_concept_wall_above_box': 0.0, 'concept_no_wall_below_m_concept_wall_above_box': 0.14285714285714285, 'NOT_concept_wall_on_left_concept_wall_above_box': 0.21428571428571427, 'concept_wall_above_box_concept_wall_on_left_of_box': 0.0, 'NOT_concept_box_on_top_concept_wall_above_box': 0.2857142857142857, 'concept_blank_cell_on_left_concept_wall_above_box': 0.21428571428571427, 'NOT_concept_wall_on_right_concept_wall_above_box': 0.2857142857142857, 'NOT_concept_pink_cell_on_right_concept_wall_above_box': 0.2857142857142857, 'NOT_concept_box_on_left_concept_wall_above_box': 0.2857142857142857, 'NOT_concept_wall_down_left_concept_wall_above_box': 0.2857142857142857, 'NOT_concept_pink_cell_below_concept_wall_above_box': 0.2857142857142857, 'NOT_concept_wall_below_concept_wall_above_box': 0.21428571428571427, 'concept_box_on_left_concept_wall_on_right_of_box': 0.0, 'concept_no_wall_on_top_m_concept_wall_on_right_of_box': 0.0, 'NOT_concept_pink_cell_on_top_concept_wall_on_right_of_box': 0.0, 'concept_no_pink_cell_on_top_m_concept_wall_on_right_of_box': 0.0, 'NOT_concept_no_wall_below_m_concept_wall_on_right_of_box': 0.0, 'concept_wall_below_box_concept_wall_on_right_of_box': 0.0, 'concept_wall_on_right_concept_wall_on_right_of_box': 0.0, 'concept_pink_cell_below_concept_wall_on_right_of_box': 0.0, 'NOT_concept_blank_cell_on_left_concept_wall_on_right_of_box': 0.0, 'NOT_concept_target_on_right_concept_wall_on_right_of_box': 0.0, 'concept_no_pink_cell_below_m_concept_wall_on_right_of_box': 0.0, 'NOT_concept_target_on_top_concept_wall_on_right_of_box': 0.0, 'NOT_concept_wall_top_right_concept_wall_on_right_of_box': 0.0, 'concept_box_on_top_concept_wall_on_right_of_box': 0.0, 'concept_no_wall_below_m_concept_wall_on_right_of_box': 0.0, 'NOT_concept_wall_on_left_concept_wall_on_right_of_box': 0.0, 'concept_wall_on_left_of_box_concept_wall_on_right_of_box': 0.0, 'NOT_concept_box_on_top_concept_wall_on_right_of_box': 0.0, 'concept_blank_cell_on_left_concept_wall_on_right_of_box': 0.0, 'NOT_concept_wall_on_right_concept_wall_on_right_of_box': 0.0, 'NOT_concept_pink_cell_on_right_concept_wall_on_right_of_box': 0.0, 'NOT_concept_box_on_left_concept_wall_on_right_of_box': 0.0, 'NOT_concept_wall_down_left_concept_wall_on_right_of_box': 0.0, 'NOT_concept_pink_cell_below_concept_wall_on_right_of_box': 0.0, 'NOT_concept_wall_below_concept_wall_on_right_of_box': 0.0, 'concept_box_on_left_concept_no_wall_on_top_m': 0.0, 'NOT_concept_pink_cell_on_top_concept_box_on_left': 0.0, 'concept_box_on_left_concept_no_pink_cell_on_top_m': 0.0, 'NOT_concept_no_wall_below_m_concept_box_on_left': 0.0, 'concept_box_on_left_concept_wall_below_box': 0.0, 'concept_box_on_left_concept_wall_on_right': 0.0, 'concept_box_on_left_concept_pink_cell_below': 0.0, 'NOT_concept_blank_cell_on_left_concept_box_on_left': 0.0, 'NOT_concept_target_on_right_concept_box_on_left': 0.0, 'concept_box_on_left_concept_no_pink_cell_below_m': 0.0, 'NOT_concept_target_on_top_concept_box_on_left': 0.0, 'NOT_concept_wall_top_right_concept_box_on_left': 0.0, 'concept_box_on_left_concept_box_on_top': 0.0, 'concept_box_on_left_concept_no_wall_below_m': 0.0, 'NOT_concept_wall_on_left_concept_box_on_left': 0.0, 'concept_box_on_left_concept_wall_on_left_of_box': 0.0, 'NOT_concept_box_on_top_concept_box_on_left': 0.0, 'concept_blank_cell_on_left_concept_box_on_left': 0.0, 'NOT_concept_wall_on_right_concept_box_on_left': 0.0, 'NOT_concept_pink_cell_on_right_concept_box_on_left': 0.0, 'NOT_concept_box_on_left_concept_box_on_left': 0.0, 'NOT_concept_wall_down_left_concept_box_on_left': 0.0, 'NOT_concept_pink_cell_below_concept_box_on_left': 0.0, 'NOT_concept_wall_below_concept_box_on_left': 0.0, 'NOT_concept_pink_cell_on_top_concept_no_wall_on_top_m': 0.6428571428571429, 'concept_no_pink_cell_on_top_m_concept_no_wall_on_top_m': 0.6428571428571429, 'NOT_concept_no_wall_below_m_concept_no_wall_on_top_m': 0.2857142857142857, 'concept_no_wall_on_top_m_concept_wall_below_box': 0.21428571428571427, 'concept_no_wall_on_top_m_concept_wall_on_right': 0.0, 'concept_no_wall_on_top_m_concept_pink_cell_below': 0.07142857142857142, 'NOT_concept_blank_cell_on_left_concept_no_wall_on_top_m': 0.42857142857142855, 'NOT_concept_target_on_right_concept_no_wall_on_top_m': 0.6428571428571429, 'concept_no_pink_cell_below_m_concept_no_wall_on_top_m': 0.35714285714285715, 'NOT_concept_target_on_top_concept_no_wall_on_top_m': 0.6428571428571429, 'NOT_concept_wall_top_right_concept_no_wall_on_top_m': 0.6428571428571429, 'concept_box_on_top_concept_no_wall_on_top_m': 0.0, 'concept_no_wall_below_m_concept_no_wall_on_top_m': 0.35714285714285715, 'NOT_concept_wall_on_left_concept_no_wall_on_top_m': 0.21428571428571427, 'concept_no_wall_on_top_m_concept_wall_on_left_of_box': 0.0, 'NOT_concept_box_on_top_concept_no_wall_on_top_m': 0.6428571428571429, 'concept_blank_cell_on_left_concept_no_wall_on_top_m': 0.21428571428571427, 'NOT_concept_wall_on_right_concept_no_wall_on_top_m': 0.6428571428571429, 'NOT_concept_pink_cell_on_right_concept_no_wall_on_top_m': 0.42857142857142855, 'NOT_concept_box_on_left_concept_no_wall_on_top_m': 0.6428571428571429, 'NOT_concept_wall_down_left_concept_no_wall_on_top_m': 0.5714285714285714, 'NOT_concept_pink_cell_below_concept_no_wall_on_top_m': 0.5714285714285714, 'NOT_concept_wall_below_concept_no_wall_on_top_m': 0.42857142857142855, 'NOT_concept_pink_cell_on_top_concept_no_pink_cell_on_top_m': 0.8571428571428571, 'NOT_concept_no_wall_below_m_NOT_concept_pink_cell_on_top': 0.35714285714285715, 'NOT_concept_pink_cell_on_top_concept_wall_below_box': 0.21428571428571427, 'NOT_concept_pink_cell_on_top_concept_wall_on_right': 0.0, 'NOT_concept_pink_cell_on_top_concept_pink_cell_below': 0.14285714285714285, 'NOT_concept_blank_cell_on_left_NOT_concept_pink_cell_on_top': 0.5, 'NOT_concept_pink_cell_on_top_NOT_concept_target_on_right': 1.0, 'NOT_concept_pink_cell_on_top_concept_no_pink_cell_below_m': 0.6428571428571429, 'NOT_concept_pink_cell_on_top_NOT_concept_target_on_top': 0.9285714285714286, 'NOT_concept_pink_cell_on_top_NOT_concept_wall_top_right': 1.0, 'NOT_concept_pink_cell_on_top_concept_box_on_top': 0.0, 'NOT_concept_pink_cell_on_top_concept_no_wall_below_m': 0.6428571428571429, 'NOT_concept_pink_cell_on_top_NOT_concept_wall_on_left': 0.5, 'NOT_concept_pink_cell_on_top_concept_wall_on_left_of_box': 0.0, 'NOT_concept_box_on_top_NOT_concept_pink_cell_on_top': 1.0, 'NOT_concept_pink_cell_on_top_concept_blank_cell_on_left': 0.5, 'NOT_concept_pink_cell_on_top_NOT_concept_wall_on_right': 1.0, 'NOT_concept_pink_cell_on_right_NOT_concept_pink_cell_on_top': 0.7857142857142857, 'NOT_concept_box_on_left_NOT_concept_pink_cell_on_top': 1.0, 'NOT_concept_pink_cell_on_top_NOT_concept_wall_down_left': 0.9285714285714286, 'NOT_concept_pink_cell_below_NOT_concept_pink_cell_on_top': 0.8571428571428571, 'NOT_concept_pink_cell_on_top_NOT_concept_wall_below': 0.7857142857142857, 'NOT_concept_no_wall_below_m_concept_no_pink_cell_on_top_m': 0.2857142857142857, 'concept_no_pink_cell_on_top_m_concept_wall_below_box': 0.21428571428571427, 'concept_no_pink_cell_on_top_m_concept_wall_on_right': 0.0, 'concept_no_pink_cell_on_top_m_concept_pink_cell_below': 0.14285714285714285, 'NOT_concept_blank_cell_on_left_concept_no_pink_cell_on_top_m': 0.42857142857142855, 'NOT_concept_target_on_right_concept_no_pink_cell_on_top_m': 0.8571428571428571, 'concept_no_pink_cell_below_m_concept_no_pink_cell_on_top_m': 0.5, 'NOT_concept_target_on_top_concept_no_pink_cell_on_top_m': 0.7857142857142857, 'NOT_concept_wall_top_right_concept_no_pink_cell_on_top_m': 0.8571428571428571, 'concept_box_on_top_concept_no_pink_cell_on_top_m': 0.0, 'concept_no_pink_cell_on_top_m_concept_no_wall_below_m': 0.5714285714285714, 'NOT_concept_wall_on_left_concept_no_pink_cell_on_top_m': 0.42857142857142855, 'concept_no_pink_cell_on_top_m_concept_wall_on_left_of_box': 0.0, 'NOT_concept_box_on_top_concept_no_pink_cell_on_top_m': 0.8571428571428571, 'concept_blank_cell_on_left_concept_no_pink_cell_on_top_m': 0.42857142857142855, 'NOT_concept_wall_on_right_concept_no_pink_cell_on_top_m': 0.8571428571428571, 'NOT_concept_pink_cell_on_right_concept_no_pink_cell_on_top_m': 0.6428571428571429, 'NOT_concept_box_on_left_concept_no_pink_cell_on_top_m': 0.8571428571428571, 'NOT_concept_wall_down_left_concept_no_pink_cell_on_top_m': 0.7857142857142857, 'NOT_concept_pink_cell_below_concept_no_pink_cell_on_top_m': 0.7142857142857143, 'NOT_concept_wall_below_concept_no_pink_cell_on_top_m': 0.6428571428571429, 'NOT_concept_no_wall_below_m_concept_wall_below_box': 0.21428571428571427, 'NOT_concept_no_wall_below_m_concept_wall_on_right': 0.0, 'NOT_concept_no_wall_below_m_concept_pink_cell_below': 0.0, 'NOT_concept_blank_cell_on_left_NOT_concept_no_wall_below_m': 0.21428571428571427, 'NOT_concept_no_wall_below_m_NOT_concept_target_on_right': 0.35714285714285715, 'NOT_concept_no_wall_below_m_concept_no_pink_cell_below_m': 0.14285714285714285, 'NOT_concept_no_wall_below_m_NOT_concept_target_on_top': 0.35714285714285715, 'NOT_concept_no_wall_below_m_NOT_concept_wall_top_right': 0.35714285714285715, 'NOT_concept_no_wall_below_m_concept_box_on_top': 0.0, 'NOT_concept_no_wall_below_m_concept_no_wall_below_m': 0.0, 'NOT_concept_no_wall_below_m_NOT_concept_wall_on_left': 0.14285714285714285, 'NOT_concept_no_wall_below_m_concept_wall_on_left_of_box': 0.0, 'NOT_concept_box_on_top_NOT_concept_no_wall_below_m': 0.35714285714285715, 'NOT_concept_no_wall_below_m_concept_blank_cell_on_left': 0.14285714285714285, 'NOT_concept_no_wall_below_m_NOT_concept_wall_on_right': 0.35714285714285715, 'NOT_concept_no_wall_below_m_NOT_concept_pink_cell_on_right': 0.35714285714285715, 'NOT_concept_box_on_left_NOT_concept_no_wall_below_m': 0.35714285714285715, 'NOT_concept_no_wall_below_m_NOT_concept_wall_down_left': 0.2857142857142857, 'NOT_concept_no_wall_below_m_NOT_concept_pink_cell_below': 0.35714285714285715, 'NOT_concept_no_wall_below_m_NOT_concept_wall_below': 0.14285714285714285, 'concept_wall_below_box_concept_wall_on_right': 0.0, 'concept_pink_cell_below_concept_wall_below_box': 0.0, 'NOT_concept_blank_cell_on_left_concept_wall_below_box': 0.07142857142857142, 'NOT_concept_target_on_right_concept_wall_below_box': 0.21428571428571427, 'concept_no_pink_cell_below_m_concept_wall_below_box': 0.0, 'NOT_concept_target_on_top_concept_wall_below_box': 0.21428571428571427, 'NOT_concept_wall_top_right_concept_wall_below_box': 0.21428571428571427, 'concept_box_on_top_concept_wall_below_box': 0.0, 'concept_no_wall_below_m_concept_wall_below_box': 0.0, 'NOT_concept_wall_on_left_concept_wall_below_box': 0.14285714285714285, 'concept_wall_below_box_concept_wall_on_left_of_box': 0.0, 'NOT_concept_box_on_top_concept_wall_below_box': 0.21428571428571427, 'concept_blank_cell_on_left_concept_wall_below_box': 0.14285714285714285, 'NOT_concept_wall_on_right_concept_wall_below_box': 0.21428571428571427, 'NOT_concept_pink_cell_on_right_concept_wall_below_box': 0.21428571428571427, 'NOT_concept_box_on_left_concept_wall_below_box': 0.21428571428571427, 'NOT_concept_wall_down_left_concept_wall_below_box': 0.14285714285714285, 'NOT_concept_pink_cell_below_concept_wall_below_box': 0.21428571428571427, 'NOT_concept_wall_below_concept_wall_below_box': 0.0, 'concept_pink_cell_below_concept_wall_on_right': 0.0, 'NOT_concept_blank_cell_on_left_concept_wall_on_right': 0.0, 'NOT_concept_target_on_right_concept_wall_on_right': 0.0, 'concept_no_pink_cell_below_m_concept_wall_on_right': 0.0, 'NOT_concept_target_on_top_concept_wall_on_right': 0.0, 'NOT_concept_wall_top_right_concept_wall_on_right': 0.0, 'concept_box_on_top_concept_wall_on_right': 0.0, 'concept_no_wall_below_m_concept_wall_on_right': 0.0, 'NOT_concept_wall_on_left_concept_wall_on_right': 0.0, 'concept_wall_on_left_of_box_concept_wall_on_right': 0.0, 'NOT_concept_box_on_top_concept_wall_on_right': 0.0, 'concept_blank_cell_on_left_concept_wall_on_right': 0.0, 'NOT_concept_wall_on_right_concept_wall_on_right': 0.0, 'NOT_concept_pink_cell_on_right_concept_wall_on_right': 0.0, 'NOT_concept_box_on_left_concept_wall_on_right': 0.0, 'NOT_concept_wall_down_left_concept_wall_on_right': 0.0, 'NOT_concept_pink_cell_below_concept_wall_on_right': 0.0, 'NOT_concept_wall_below_concept_wall_on_right': 0.0, 'NOT_concept_blank_cell_on_left_concept_pink_cell_below': 0.0, 'NOT_concept_target_on_right_concept_pink_cell_below': 0.14285714285714285, 'concept_no_pink_cell_below_m_concept_pink_cell_below': 0.0, 'NOT_concept_target_on_top_concept_pink_cell_below': 0.14285714285714285, 'NOT_concept_wall_top_right_concept_pink_cell_below': 0.14285714285714285, 'concept_box_on_top_concept_pink_cell_below': 0.0, 'concept_no_wall_below_m_concept_pink_cell_below': 0.14285714285714285, 'NOT_concept_wall_on_left_concept_pink_cell_below': 0.14285714285714285, 'concept_pink_cell_below_concept_wall_on_left_of_box': 0.0, 'NOT_concept_box_on_top_concept_pink_cell_below': 0.14285714285714285, 'concept_blank_cell_on_left_concept_pink_cell_below': 0.14285714285714285, 'NOT_concept_wall_on_right_concept_pink_cell_below': 0.14285714285714285, 'NOT_concept_pink_cell_on_right_concept_pink_cell_below': 0.14285714285714285, 'NOT_concept_box_on_left_concept_pink_cell_below': 0.14285714285714285, 'NOT_concept_wall_down_left_concept_pink_cell_below': 0.14285714285714285, 'NOT_concept_pink_cell_below_concept_pink_cell_below': 0.0, 'NOT_concept_wall_below_concept_pink_cell_below': 0.14285714285714285, 'NOT_concept_blank_cell_on_left_NOT_concept_target_on_right': 0.5, 'NOT_concept_blank_cell_on_left_concept_no_pink_cell_below_m': 0.42857142857142855, 'NOT_concept_blank_cell_on_left_NOT_concept_target_on_top': 0.5, 'NOT_concept_blank_cell_on_left_NOT_concept_wall_top_right': 0.5, 'NOT_concept_blank_cell_on_left_concept_box_on_top': 0.0, 'NOT_concept_blank_cell_on_left_concept_no_wall_below_m': 0.2857142857142857, 'NOT_concept_blank_cell_on_left_NOT_concept_wall_on_left': 0.0, 'NOT_concept_blank_cell_on_left_concept_wall_on_left_of_box': 0.0, 'NOT_concept_blank_cell_on_left_NOT_concept_box_on_top': 0.5, 'NOT_concept_blank_cell_on_left_concept_blank_cell_on_left': 0.0, 'NOT_concept_blank_cell_on_left_NOT_concept_wall_on_right': 0.5, 'NOT_concept_blank_cell_on_left_NOT_concept_pink_cell_on_right': 0.2857142857142857, 'NOT_concept_blank_cell_on_left_NOT_concept_box_on_left': 0.5, 'NOT_concept_blank_cell_on_left_NOT_concept_wall_down_left': 0.42857142857142855, 'NOT_concept_blank_cell_on_left_NOT_concept_pink_cell_below': 0.5, 'NOT_concept_blank_cell_on_left_NOT_concept_wall_below': 0.42857142857142855, 'NOT_concept_target_on_right_concept_no_pink_cell_below_m': 0.6428571428571429, 'NOT_concept_target_on_right_NOT_concept_target_on_top': 0.9285714285714286, 'NOT_concept_target_on_right_NOT_concept_wall_top_right': 1.0, 'NOT_concept_target_on_right_concept_box_on_top': 0.0, 'NOT_concept_target_on_right_concept_no_wall_below_m': 0.6428571428571429, 'NOT_concept_target_on_right_NOT_concept_wall_on_left': 0.5, 'NOT_concept_target_on_right_concept_wall_on_left_of_box': 0.0, 'NOT_concept_box_on_top_NOT_concept_target_on_right': 1.0, 'NOT_concept_target_on_right_concept_blank_cell_on_left': 0.5, 'NOT_concept_target_on_right_NOT_concept_wall_on_right': 1.0, 'NOT_concept_pink_cell_on_right_NOT_concept_target_on_right': 0.7857142857142857, 'NOT_concept_box_on_left_NOT_concept_target_on_right': 1.0, 'NOT_concept_target_on_right_NOT_concept_wall_down_left': 0.9285714285714286, 'NOT_concept_pink_cell_below_NOT_concept_target_on_right': 0.8571428571428571, 'NOT_concept_target_on_right_NOT_concept_wall_below': 0.7857142857142857, 'NOT_concept_target_on_top_concept_no_pink_cell_below_m': 0.5714285714285714, 'NOT_concept_wall_top_right_concept_no_pink_cell_below_m': 0.6428571428571429, 'concept_box_on_top_concept_no_pink_cell_below_m': 0.0, 'concept_no_pink_cell_below_m_concept_no_wall_below_m': 0.5, 'NOT_concept_wall_on_left_concept_no_pink_cell_below_m': 0.21428571428571427, 'concept_no_pink_cell_below_m_concept_wall_on_left_of_box': 0.0, 'NOT_concept_box_on_top_concept_no_pink_cell_below_m': 0.6428571428571429, 'concept_blank_cell_on_left_concept_no_pink_cell_below_m': 0.21428571428571427, 'NOT_concept_wall_on_right_concept_no_pink_cell_below_m': 0.6428571428571429, 'NOT_concept_pink_cell_on_right_concept_no_pink_cell_below_m': 0.42857142857142855, 'NOT_concept_box_on_left_concept_no_pink_cell_below_m': 0.6428571428571429, 'NOT_concept_wall_down_left_concept_no_pink_cell_below_m': 0.6428571428571429, 'NOT_concept_pink_cell_below_concept_no_pink_cell_below_m': 0.6428571428571429, 'NOT_concept_wall_below_concept_no_pink_cell_below_m': 0.6428571428571429, 'NOT_concept_target_on_top_NOT_concept_wall_top_right': 0.9285714285714286, 'NOT_concept_target_on_top_concept_box_on_top': 0.0, 'NOT_concept_target_on_top_concept_no_wall_below_m': 0.5714285714285714, 'NOT_concept_target_on_top_NOT_concept_wall_on_left': 0.42857142857142855, 'NOT_concept_target_on_top_concept_wall_on_left_of_box': 0.0, 'NOT_concept_box_on_top_NOT_concept_target_on_top': 0.9285714285714286, 'NOT_concept_target_on_top_concept_blank_cell_on_left': 0.42857142857142855, 'NOT_concept_target_on_top_NOT_concept_wall_on_right': 0.9285714285714286, 'NOT_concept_pink_cell_on_right_NOT_concept_target_on_top': 0.7142857142857143, 'NOT_concept_box_on_left_NOT_concept_target_on_top': 0.9285714285714286, 'NOT_concept_target_on_top_NOT_concept_wall_down_left': 0.8571428571428571, 'NOT_concept_pink_cell_below_NOT_concept_target_on_top': 0.7857142857142857, 'NOT_concept_target_on_top_NOT_concept_wall_below': 0.7142857142857143, 'NOT_concept_wall_top_right_concept_box_on_top': 0.0, 'NOT_concept_wall_top_right_concept_no_wall_below_m': 0.6428571428571429, 'NOT_concept_wall_on_left_NOT_concept_wall_top_right': 0.5, 'NOT_concept_wall_top_right_concept_wall_on_left_of_box': 0.0, 'NOT_concept_box_on_top_NOT_concept_wall_top_right': 1.0, 'NOT_concept_wall_top_right_concept_blank_cell_on_left': 0.5, 'NOT_concept_wall_on_right_NOT_concept_wall_top_right': 1.0, 'NOT_concept_pink_cell_on_right_NOT_concept_wall_top_right': 0.7857142857142857, 'NOT_concept_box_on_left_NOT_concept_wall_top_right': 1.0, 'NOT_concept_wall_down_left_NOT_concept_wall_top_right': 0.9285714285714286, 'NOT_concept_pink_cell_below_NOT_concept_wall_top_right': 0.8571428571428571, 'NOT_concept_wall_below_NOT_concept_wall_top_right': 0.7857142857142857, 'concept_box_on_top_concept_no_wall_below_m': 0.0, 'NOT_concept_wall_on_left_concept_box_on_top': 0.0, 'concept_box_on_top_concept_wall_on_left_of_box': 0.0, 'NOT_concept_box_on_top_concept_box_on_top': 0.0, 'concept_blank_cell_on_left_concept_box_on_top': 0.0, 'NOT_concept_wall_on_right_concept_box_on_top': 0.0, 'NOT_concept_pink_cell_on_right_concept_box_on_top': 0.0, 'NOT_concept_box_on_left_concept_box_on_top': 0.0, 'NOT_concept_wall_down_left_concept_box_on_top': 0.0, 'NOT_concept_pink_cell_below_concept_box_on_top': 0.0, 'NOT_concept_wall_below_concept_box_on_top': 0.0, 'NOT_concept_wall_on_left_concept_no_wall_below_m': 0.35714285714285715, 'concept_no_wall_below_m_concept_wall_on_left_of_box': 0.0, 'NOT_concept_box_on_top_concept_no_wall_below_m': 0.6428571428571429, 'concept_blank_cell_on_left_concept_no_wall_below_m': 0.35714285714285715, 'NOT_concept_wall_on_right_concept_no_wall_below_m': 0.6428571428571429, 'NOT_concept_pink_cell_on_right_concept_no_wall_below_m': 0.42857142857142855, 'NOT_concept_box_on_left_concept_no_wall_below_m': 0.6428571428571429, 'NOT_concept_wall_down_left_concept_no_wall_below_m': 0.6428571428571429, 'NOT_concept_pink_cell_below_concept_no_wall_below_m': 0.5, 'NOT_concept_wall_below_concept_no_wall_below_m': 0.6428571428571429, 'NOT_concept_wall_on_left_concept_wall_on_left_of_box': 0.0, 'NOT_concept_box_on_top_NOT_concept_wall_on_left': 0.5, 'NOT_concept_wall_on_left_concept_blank_cell_on_left': 0.5, 'NOT_concept_wall_on_left_NOT_concept_wall_on_right': 0.5, 'NOT_concept_pink_cell_on_right_NOT_concept_wall_on_left': 0.5, 'NOT_concept_box_on_left_NOT_concept_wall_on_left': 0.5, 'NOT_concept_wall_down_left_NOT_concept_wall_on_left': 0.5, 'NOT_concept_pink_cell_below_NOT_concept_wall_on_left': 0.35714285714285715, 'NOT_concept_wall_below_NOT_concept_wall_on_left': 0.35714285714285715, 'NOT_concept_box_on_top_concept_wall_on_left_of_box': 0.0, 'concept_blank_cell_on_left_concept_wall_on_left_of_box': 0.0, 'NOT_concept_wall_on_right_concept_wall_on_left_of_box': 0.0, 'NOT_concept_pink_cell_on_right_concept_wall_on_left_of_box': 0.0, 'NOT_concept_box_on_left_concept_wall_on_left_of_box': 0.0, 'NOT_concept_wall_down_left_concept_wall_on_left_of_box': 0.0, 'NOT_concept_pink_cell_below_concept_wall_on_left_of_box': 0.0, 'NOT_concept_wall_below_concept_wall_on_left_of_box': 0.0, 'NOT_concept_box_on_top_concept_blank_cell_on_left': 0.5, 'NOT_concept_box_on_top_NOT_concept_wall_on_right': 1.0, 'NOT_concept_box_on_top_NOT_concept_pink_cell_on_right': 0.7857142857142857, 'NOT_concept_box_on_left_NOT_concept_box_on_top': 1.0, 'NOT_concept_box_on_top_NOT_concept_wall_down_left': 0.9285714285714286, 'NOT_concept_box_on_top_NOT_concept_pink_cell_below': 0.8571428571428571, 'NOT_concept_box_on_top_NOT_concept_wall_below': 0.7857142857142857, 'NOT_concept_wall_on_right_concept_blank_cell_on_left': 0.5, 'NOT_concept_pink_cell_on_right_concept_blank_cell_on_left': 0.5, 'NOT_concept_box_on_left_concept_blank_cell_on_left': 0.5, 'NOT_concept_wall_down_left_concept_blank_cell_on_left': 0.5, 'NOT_concept_pink_cell_below_concept_blank_cell_on_left': 0.35714285714285715, 'NOT_concept_wall_below_concept_blank_cell_on_left': 0.35714285714285715, 'NOT_concept_pink_cell_on_right_NOT_concept_wall_on_right': 0.7857142857142857, 'NOT_concept_box_on_left_NOT_concept_wall_on_right': 1.0, 'NOT_concept_wall_down_left_NOT_concept_wall_on_right': 0.9285714285714286, 'NOT_concept_pink_cell_below_NOT_concept_wall_on_right': 0.8571428571428571, 'NOT_concept_wall_below_NOT_concept_wall_on_right': 0.7857142857142857, 'NOT_concept_box_on_left_NOT_concept_pink_cell_on_right': 0.7857142857142857, 'NOT_concept_pink_cell_on_right_NOT_concept_wall_down_left': 0.7142857142857143, 'NOT_concept_pink_cell_below_NOT_concept_pink_cell_on_right': 0.6428571428571429, 'NOT_concept_pink_cell_on_right_NOT_concept_wall_below': 0.5714285714285714, 'NOT_concept_box_on_left_NOT_concept_wall_down_left': 0.9285714285714286, 'NOT_concept_box_on_left_NOT_concept_pink_cell_below': 0.8571428571428571, 'NOT_concept_box_on_left_NOT_concept_wall_below': 0.7857142857142857, 'NOT_concept_pink_cell_below_NOT_concept_wall_down_left': 0.7857142857142857, 'NOT_concept_wall_below_NOT_concept_wall_down_left': 0.7857142857142857, 'NOT_concept_pink_cell_below_NOT_concept_wall_below': 0.6428571428571429}}


#ACTION_PRIOR_FOR_GRAVITY = {1: {1: 1.0, 10: 0.19047619047619047}, 7: {1: 1.0}, 5: {1: 1.0}, 4: {1: 1.0}}
ACTION_PRIOR_FOR_GRAVITY = {1: {1: 1.0, 10: 0.19047619047619047}, 7: {1: 1.0, 10: 0.0}, 5: {1: 1.0, 10: 0.0}, 4: {1: 1.0, 10: 0.21428571428571427}} 
ACTION_PRIOR_FOR_FLIP = {1: {1: 1.0, 10: 0.7631578947368421}} #{1: {1: 1.0, 10: 0.19047619047619047}, 7: {1: 1.0}, 5: {1: 1.0}, 4: {1: 1.0}}

CONCEPT_PRIOR_FOR_FLIP = {1: {'concept_box_left': 0.0, 'NOT_concept_empty_right': 0.2894736842105263, 'concept_wall_right': 0.2631578947368421, 'NOT_concept_empty_above': 0.631578947368421, 'concept_empty_above': 0.3684210526315789, 'concept_target_below': 0.07894736842105263, 'NOT_concept_empty_left': 0.23684210526315788, 'concept_wall_below': 0.2631578947368421, 'NOT_concept_wall_left': 0.7894736842105263, 'NOT_concept_target_below': 0.9210526315789473, 'concept_left_switch': 0.02631578947368421, 'concept_box_right': 0.0, 'concept_wall_left_below_ofbox': 0.0, 'NOT_concept_wall_above': 0.9473684210526315, 'concept_target_above': 0.02631578947368421, 'concept_switch_on': 0.23684210526315788, 'NOT_concept_target_above': 0.9736842105263158, 'NOT_concept_wall_left_below_ofbox': 1.0, 'NOT_concept_empty_below': 0.2894736842105263, 'concept_above_switch': 0.0, 'concept_empty_below': 0.7105263157894737, 'concept_wall_left': 0.21052631578947367, 'NOT_concept_target_right': 1.0, 'NOT_concept_wall_right': 0.7368421052631579, 'concept_empty_right': 0.7105263157894737, 'concept_empty_left': 0.7631578947368421, 'NOT_concept_switch_on': 0.7631578947368421, 'concept_wall_above': 0.05263157894736842, 'NOT_concept_above_switch': 1.0, 'NOT_concept_box_left': 1.0, 'NOT_concept_target_left': 0.9736842105263158, 'concept_target_right': 0.0, 'NOT_concept_left_switch': 0.9736842105263158, 'NOT_concept_wall_below': 0.7368421052631579, 'NOT_concept_box_right': 1.0, 'concept_target_left': 0.02631578947368421, 'NOT_concept_empty_right_concept_box_left': 0.0, 'concept_box_left_concept_wall_right': 0.0, 'NOT_concept_empty_above_concept_box_left': 0.0, 'concept_box_left_concept_empty_above': 0.0, 'concept_box_left_concept_target_below': 0.0, 'NOT_concept_empty_left_concept_box_left': 0.0, 'concept_box_left_concept_wall_below': 0.0, 'NOT_concept_wall_left_concept_box_left': 0.0, 'NOT_concept_target_below_concept_box_left': 0.0, 'concept_box_left_concept_left_switch': 0.0, 'concept_box_left_concept_box_right': 0.0, 'concept_box_left_concept_wall_left_below_ofbox': 0.0, 'NOT_concept_wall_above_concept_box_left': 0.0, 'concept_box_left_concept_target_above': 0.0, 'concept_box_left_concept_switch_on': 0.0, 'NOT_concept_target_above_concept_box_left': 0.0, 'NOT_concept_wall_left_below_ofbox_concept_box_left': 0.0, 'NOT_concept_empty_below_concept_box_left': 0.0, 'concept_above_switch_concept_box_left': 0.0, 'concept_box_left_concept_empty_below': 0.0, 'concept_box_left_concept_wall_left': 0.0, 'NOT_concept_target_right_concept_box_left': 0.0, 'NOT_concept_wall_right_concept_box_left': 0.0, 'concept_box_left_concept_empty_right': 0.0, 'concept_box_left_concept_empty_left': 0.0, 'NOT_concept_switch_on_concept_box_left': 0.0, 'concept_box_left_concept_wall_above': 0.0, 'NOT_concept_above_switch_concept_box_left': 0.0, 'NOT_concept_box_left_concept_box_left': 0.0, 'NOT_concept_target_left_concept_box_left': 0.0, 'concept_box_left_concept_target_right': 0.0, 'NOT_concept_left_switch_concept_box_left': 0.0, 'NOT_concept_wall_below_concept_box_left': 0.0, 'NOT_concept_box_right_concept_box_left': 0.0, 'concept_box_left_concept_target_left': 0.0, 'NOT_concept_empty_right_concept_wall_right': 0.2631578947368421, 'NOT_concept_empty_above_NOT_concept_empty_right': 0.13157894736842105, 'NOT_concept_empty_right_concept_empty_above': 0.15789473684210525, 'NOT_concept_empty_right_concept_target_below': 0.0, 'NOT_concept_empty_left_NOT_concept_empty_right': 0.0, 'NOT_concept_empty_right_concept_wall_below': 0.05263157894736842, 'NOT_concept_empty_right_NOT_concept_wall_left': 0.2894736842105263, 'NOT_concept_empty_right_NOT_concept_target_below': 0.2894736842105263, 'NOT_concept_empty_right_concept_left_switch': 0.02631578947368421, 'NOT_concept_empty_right_concept_box_right': 0.0, 'NOT_concept_empty_right_concept_wall_left_below_ofbox': 0.0, 'NOT_concept_empty_right_NOT_concept_wall_above': 0.2631578947368421, 'NOT_concept_empty_right_concept_target_above': 0.0, 'NOT_concept_empty_right_concept_switch_on': 0.07894736842105263, 'NOT_concept_empty_right_NOT_concept_target_above': 0.2894736842105263, 'NOT_concept_empty_right_NOT_concept_wall_left_below_ofbox': 0.2894736842105263, 'NOT_concept_empty_below_NOT_concept_empty_right': 0.05263157894736842, 'NOT_concept_empty_right_concept_above_switch': 0.0, 'NOT_concept_empty_right_concept_empty_below': 0.23684210526315788, 'NOT_concept_empty_right_concept_wall_left': 0.0, 'NOT_concept_empty_right_NOT_concept_target_right': 0.2894736842105263, 'NOT_concept_empty_right_NOT_concept_wall_right': 0.02631578947368421, 'NOT_concept_empty_right_concept_empty_right': 0.0, 'NOT_concept_empty_right_concept_empty_left': 0.2894736842105263, 'NOT_concept_empty_right_NOT_concept_switch_on': 0.21052631578947367, 'NOT_concept_empty_right_concept_wall_above': 0.02631578947368421, 'NOT_concept_above_switch_NOT_concept_empty_right': 0.2894736842105263, 'NOT_concept_box_left_NOT_concept_empty_right': 0.2894736842105263, 'NOT_concept_empty_right_NOT_concept_target_left': 0.2894736842105263, 'NOT_concept_empty_right_concept_target_right': 0.0, 'NOT_concept_empty_right_NOT_concept_left_switch': 0.2631578947368421, 'NOT_concept_empty_right_NOT_concept_wall_below': 0.23684210526315788, 'NOT_concept_box_right_NOT_concept_empty_right': 0.2894736842105263, 'NOT_concept_empty_right_concept_target_left': 0.0, 'NOT_concept_empty_above_concept_wall_right': 0.10526315789473684, 'concept_empty_above_concept_wall_right': 0.15789473684210525, 'concept_target_below_concept_wall_right': 0.0, 'NOT_concept_empty_left_concept_wall_right': 0.0, 'concept_wall_below_concept_wall_right': 0.02631578947368421, 'NOT_concept_wall_left_concept_wall_right': 0.2631578947368421, 'NOT_concept_target_below_concept_wall_right': 0.2631578947368421, 'concept_left_switch_concept_wall_right': 0.0, 'concept_box_right_concept_wall_right': 0.0, 'concept_wall_left_below_ofbox_concept_wall_right': 0.0, 'NOT_concept_wall_above_concept_wall_right': 0.2631578947368421, 'concept_target_above_concept_wall_right': 0.0, 'concept_switch_on_concept_wall_right': 0.07894736842105263, 'NOT_concept_target_above_concept_wall_right': 0.2631578947368421, 'NOT_concept_wall_left_below_ofbox_concept_wall_right': 0.2631578947368421, 'NOT_concept_empty_below_concept_wall_right': 0.02631578947368421, 'concept_above_switch_concept_wall_right': 0.0, 'concept_empty_below_concept_wall_right': 0.23684210526315788, 'concept_wall_left_concept_wall_right': 0.0, 'NOT_concept_target_right_concept_wall_right': 0.2631578947368421, 'NOT_concept_wall_right_concept_wall_right': 0.0, 'concept_empty_right_concept_wall_right': 0.0, 'concept_empty_left_concept_wall_right': 0.2631578947368421, 'NOT_concept_switch_on_concept_wall_right': 0.18421052631578946, 'concept_wall_above_concept_wall_right': 0.0, 'NOT_concept_above_switch_concept_wall_right': 0.2631578947368421, 'NOT_concept_box_left_concept_wall_right': 0.2631578947368421, 'NOT_concept_target_left_concept_wall_right': 0.2631578947368421, 'concept_target_right_concept_wall_right': 0.0, 'NOT_concept_left_switch_concept_wall_right': 0.2631578947368421, 'NOT_concept_wall_below_concept_wall_right': 0.23684210526315788, 'NOT_concept_box_right_concept_wall_right': 0.2631578947368421, 'concept_target_left_concept_wall_right': 0.0, 'NOT_concept_empty_above_concept_empty_above': 0.0, 'NOT_concept_empty_above_concept_target_below': 0.05263157894736842, 'NOT_concept_empty_above_NOT_concept_empty_left': 0.15789473684210525, 'NOT_concept_empty_above_concept_wall_below': 0.15789473684210525, 'NOT_concept_empty_above_NOT_concept_wall_left': 0.5, 'NOT_concept_empty_above_NOT_concept_target_below': 0.5789473684210527, 'NOT_concept_empty_above_concept_left_switch': 0.02631578947368421, 'NOT_concept_empty_above_concept_box_right': 0.0, 'NOT_concept_empty_above_concept_wall_left_below_ofbox': 0.0, 'NOT_concept_empty_above_NOT_concept_wall_above': 0.5789473684210527, 'NOT_concept_empty_above_concept_target_above': 0.02631578947368421, 'NOT_concept_empty_above_concept_switch_on': 0.18421052631578946, 'NOT_concept_empty_above_NOT_concept_target_above': 0.6052631578947368, 'NOT_concept_empty_above_NOT_concept_wall_left_below_ofbox': 0.631578947368421, 'NOT_concept_empty_above_NOT_concept_empty_below': 0.18421052631578946, 'NOT_concept_empty_above_concept_above_switch': 0.0, 'NOT_concept_empty_above_concept_empty_below': 0.4473684210526316, 'NOT_concept_empty_above_concept_wall_left': 0.13157894736842105, 'NOT_concept_empty_above_NOT_concept_target_right': 0.631578947368421, 'NOT_concept_empty_above_NOT_concept_wall_right': 0.5263157894736842, 'NOT_concept_empty_above_concept_empty_right': 0.5, 'NOT_concept_empty_above_concept_empty_left': 0.47368421052631576, 'NOT_concept_empty_above_NOT_concept_switch_on': 0.4473684210526316, 'NOT_concept_empty_above_concept_wall_above': 0.05263157894736842, 'NOT_concept_above_switch_NOT_concept_empty_above': 0.631578947368421, 'NOT_concept_box_left_NOT_concept_empty_above': 0.631578947368421, 'NOT_concept_empty_above_NOT_concept_target_left': 0.6052631578947368, 'NOT_concept_empty_above_concept_target_right': 0.0, 'NOT_concept_empty_above_NOT_concept_left_switch': 0.6052631578947368, 'NOT_concept_empty_above_NOT_concept_wall_below': 0.47368421052631576, 'NOT_concept_box_right_NOT_concept_empty_above': 0.631578947368421, 'NOT_concept_empty_above_concept_target_left': 0.02631578947368421, 'concept_empty_above_concept_target_below': 0.02631578947368421, 'NOT_concept_empty_left_concept_empty_above': 0.07894736842105263, 'concept_empty_above_concept_wall_below': 0.10526315789473684, 'NOT_concept_wall_left_concept_empty_above': 0.2894736842105263, 'NOT_concept_target_below_concept_empty_above': 0.34210526315789475, 'concept_empty_above_concept_left_switch': 0.0, 'concept_box_right_concept_empty_above': 0.0, 'concept_empty_above_concept_wall_left_below_ofbox': 0.0, 'NOT_concept_wall_above_concept_empty_above': 0.3684210526315789, 'concept_empty_above_concept_target_above': 0.0, 'concept_empty_above_concept_switch_on': 0.05263157894736842, 'NOT_concept_target_above_concept_empty_above': 0.3684210526315789, 'NOT_concept_wall_left_below_ofbox_concept_empty_above': 0.3684210526315789, 'NOT_concept_empty_below_concept_empty_above': 0.10526315789473684, 'concept_above_switch_concept_empty_above': 0.0, 'concept_empty_above_concept_empty_below': 0.2631578947368421, 'concept_empty_above_concept_wall_left': 0.07894736842105263, 'NOT_concept_target_right_concept_empty_above': 0.3684210526315789, 'NOT_concept_wall_right_concept_empty_above': 0.21052631578947367, 'concept_empty_above_concept_empty_right': 0.21052631578947367, 'concept_empty_above_concept_empty_left': 0.2894736842105263, 'NOT_concept_switch_on_concept_empty_above': 0.3157894736842105, 'concept_empty_above_concept_wall_above': 0.0, 'NOT_concept_above_switch_concept_empty_above': 0.3684210526315789, 'NOT_concept_box_left_concept_empty_above': 0.3684210526315789, 'NOT_concept_target_left_concept_empty_above': 0.3684210526315789, 'concept_empty_above_concept_target_right': 0.0, 'NOT_concept_left_switch_concept_empty_above': 0.3684210526315789, 'NOT_concept_wall_below_concept_empty_above': 0.2631578947368421, 'NOT_concept_box_right_concept_empty_above': 0.3684210526315789, 'concept_empty_above_concept_target_left': 0.0, 'NOT_concept_empty_left_concept_target_below': 0.0, 'concept_target_below_concept_wall_below': 0.0, 'NOT_concept_wall_left_concept_target_below': 0.07894736842105263, 'NOT_concept_target_below_concept_target_below': 0.0, 'concept_left_switch_concept_target_below': 0.0, 'concept_box_right_concept_target_below': 0.0, 'concept_target_below_concept_wall_left_below_ofbox': 0.0, 'NOT_concept_wall_above_concept_target_below': 0.07894736842105263, 'concept_target_above_concept_target_below': 0.0, 'concept_switch_on_concept_target_below': 0.0, 'NOT_concept_target_above_concept_target_below': 0.07894736842105263, 'NOT_concept_wall_left_below_ofbox_concept_target_below': 0.07894736842105263, 'NOT_concept_empty_below_concept_target_below': 0.02631578947368421, 'concept_above_switch_concept_target_below': 0.0, 'concept_empty_below_concept_target_below': 0.05263157894736842, 'concept_target_below_concept_wall_left': 0.0, 'NOT_concept_target_right_concept_target_below': 0.07894736842105263, 'NOT_concept_wall_right_concept_target_below': 0.07894736842105263, 'concept_empty_right_concept_target_below': 0.07894736842105263, 'concept_empty_left_concept_target_below': 0.07894736842105263, 'NOT_concept_switch_on_concept_target_below': 0.07894736842105263, 'concept_target_below_concept_wall_above': 0.0, 'NOT_concept_above_switch_concept_target_below': 0.07894736842105263, 'NOT_concept_box_left_concept_target_below': 0.07894736842105263, 'NOT_concept_target_left_concept_target_below': 0.07894736842105263, 'concept_target_below_concept_target_right': 0.0, 'NOT_concept_left_switch_concept_target_below': 0.07894736842105263, 'NOT_concept_wall_below_concept_target_below': 0.07894736842105263, 'NOT_concept_box_right_concept_target_below': 0.07894736842105263, 'concept_target_below_concept_target_left': 0.0, 'NOT_concept_empty_left_concept_wall_below': 0.05263157894736842, 'NOT_concept_empty_left_NOT_concept_wall_left': 0.02631578947368421, 'NOT_concept_empty_left_NOT_concept_target_below': 0.23684210526315788, 'NOT_concept_empty_left_concept_left_switch': 0.0, 'NOT_concept_empty_left_concept_box_right': 0.0, 'NOT_concept_empty_left_concept_wall_left_below_ofbox': 0.0, 'NOT_concept_empty_left_NOT_concept_wall_above': 0.23684210526315788, 'NOT_concept_empty_left_concept_target_above': 0.0, 'NOT_concept_empty_left_concept_switch_on': 0.0, 'NOT_concept_empty_left_NOT_concept_target_above': 0.23684210526315788, 'NOT_concept_empty_left_NOT_concept_wall_left_below_ofbox': 0.23684210526315788, 'NOT_concept_empty_below_NOT_concept_empty_left': 0.05263157894736842, 'NOT_concept_empty_left_concept_above_switch': 0.0, 'NOT_concept_empty_left_concept_empty_below': 0.18421052631578946, 'NOT_concept_empty_left_concept_wall_left': 0.21052631578947367, 'NOT_concept_empty_left_NOT_concept_target_right': 0.23684210526315788, 'NOT_concept_empty_left_NOT_concept_wall_right': 0.23684210526315788, 'NOT_concept_empty_left_concept_empty_right': 0.23684210526315788, 'NOT_concept_empty_left_concept_empty_left': 0.0, 'NOT_concept_empty_left_NOT_concept_switch_on': 0.23684210526315788, 'NOT_concept_empty_left_concept_wall_above': 0.0, 'NOT_concept_above_switch_NOT_concept_empty_left': 0.23684210526315788, 'NOT_concept_box_left_NOT_concept_empty_left': 0.23684210526315788, 'NOT_concept_empty_left_NOT_concept_target_left': 0.21052631578947367, 'NOT_concept_empty_left_concept_target_right': 0.0, 'NOT_concept_empty_left_NOT_concept_left_switch': 0.23684210526315788, 'NOT_concept_empty_left_NOT_concept_wall_below': 0.18421052631578946, 'NOT_concept_box_right_NOT_concept_empty_left': 0.23684210526315788, 'NOT_concept_empty_left_concept_target_left': 0.02631578947368421, 'NOT_concept_wall_left_concept_wall_below': 0.21052631578947367, 'NOT_concept_target_below_concept_wall_below': 0.2631578947368421, 'concept_left_switch_concept_wall_below': 0.02631578947368421, 'concept_box_right_concept_wall_below': 0.0, 'concept_wall_below_concept_wall_left_below_ofbox': 0.0, 'NOT_concept_wall_above_concept_wall_below': 0.23684210526315788, 'concept_target_above_concept_wall_below': 0.0, 'concept_switch_on_concept_wall_below': 0.07894736842105263, 'NOT_concept_target_above_concept_wall_below': 0.2631578947368421, 'NOT_concept_wall_left_below_ofbox_concept_wall_below': 0.2631578947368421, 'NOT_concept_empty_below_concept_wall_below': 0.2631578947368421, 'concept_above_switch_concept_wall_below': 0.0, 'concept_empty_below_concept_wall_below': 0.0, 'concept_wall_below_concept_wall_left': 0.05263157894736842, 'NOT_concept_target_right_concept_wall_below': 0.2631578947368421, 'NOT_concept_wall_right_concept_wall_below': 0.23684210526315788, 'concept_empty_right_concept_wall_below': 0.21052631578947367, 'concept_empty_left_concept_wall_below': 0.21052631578947367, 'NOT_concept_switch_on_concept_wall_below': 0.18421052631578946, 'concept_wall_above_concept_wall_below': 0.02631578947368421, 'NOT_concept_above_switch_concept_wall_below': 0.2631578947368421, 'NOT_concept_box_left_concept_wall_below': 0.2631578947368421, 'NOT_concept_target_left_concept_wall_below': 0.2631578947368421, 'concept_target_right_concept_wall_below': 0.0, 'NOT_concept_left_switch_concept_wall_below': 0.23684210526315788, 'NOT_concept_wall_below_concept_wall_below': 0.0, 'NOT_concept_box_right_concept_wall_below': 0.2631578947368421, 'concept_target_left_concept_wall_below': 0.0, 'NOT_concept_target_below_NOT_concept_wall_left': 0.7105263157894737, 'NOT_concept_wall_left_concept_left_switch': 0.02631578947368421, 'NOT_concept_wall_left_concept_box_right': 0.0, 'NOT_concept_wall_left_concept_wall_left_below_ofbox': 0.0, 'NOT_concept_wall_above_NOT_concept_wall_left': 0.7368421052631579, 'NOT_concept_wall_left_concept_target_above': 0.02631578947368421, 'NOT_concept_wall_left_concept_switch_on': 0.23684210526315788, 'NOT_concept_target_above_NOT_concept_wall_left': 0.7631578947368421, 'NOT_concept_wall_left_NOT_concept_wall_left_below_ofbox': 0.7894736842105263, 'NOT_concept_empty_below_NOT_concept_wall_left': 0.23684210526315788, 'NOT_concept_wall_left_concept_above_switch': 0.0, 'NOT_concept_wall_left_concept_empty_below': 0.5526315789473685, 'NOT_concept_wall_left_concept_wall_left': 0.0, 'NOT_concept_target_right_NOT_concept_wall_left': 0.7894736842105263, 'NOT_concept_wall_left_NOT_concept_wall_right': 0.5263157894736842, 'NOT_concept_wall_left_concept_empty_right': 0.5, 'NOT_concept_wall_left_concept_empty_left': 0.7631578947368421, 'NOT_concept_switch_on_NOT_concept_wall_left': 0.5526315789473685, 'NOT_concept_wall_left_concept_wall_above': 0.05263157894736842, 'NOT_concept_above_switch_NOT_concept_wall_left': 0.7894736842105263, 'NOT_concept_box_left_NOT_concept_wall_left': 0.7894736842105263, 'NOT_concept_target_left_NOT_concept_wall_left': 0.7631578947368421, 'NOT_concept_wall_left_concept_target_right': 0.0, 'NOT_concept_left_switch_NOT_concept_wall_left': 0.7631578947368421, 'NOT_concept_wall_below_NOT_concept_wall_left': 0.5789473684210527, 'NOT_concept_box_right_NOT_concept_wall_left': 0.7894736842105263, 'NOT_concept_wall_left_concept_target_left': 0.02631578947368421, 'NOT_concept_target_below_concept_left_switch': 0.02631578947368421, 'NOT_concept_target_below_concept_box_right': 0.0, 'NOT_concept_target_below_concept_wall_left_below_ofbox': 0.0, 'NOT_concept_target_below_NOT_concept_wall_above': 0.868421052631579, 'NOT_concept_target_below_concept_target_above': 0.02631578947368421, 'NOT_concept_target_below_concept_switch_on': 0.23684210526315788, 'NOT_concept_target_above_NOT_concept_target_below': 0.8947368421052632, 'NOT_concept_target_below_NOT_concept_wall_left_below_ofbox': 0.9210526315789473, 'NOT_concept_empty_below_NOT_concept_target_below': 0.2631578947368421, 'NOT_concept_target_below_concept_above_switch': 0.0, 'NOT_concept_target_below_concept_empty_below': 0.6578947368421053, 'NOT_concept_target_below_concept_wall_left': 0.21052631578947367, 'NOT_concept_target_below_NOT_concept_target_right': 0.9210526315789473, 'NOT_concept_target_below_NOT_concept_wall_right': 0.6578947368421053, 'NOT_concept_target_below_concept_empty_right': 0.631578947368421, 'NOT_concept_target_below_concept_empty_left': 0.6842105263157895, 'NOT_concept_switch_on_NOT_concept_target_below': 0.6842105263157895, 'NOT_concept_target_below_concept_wall_above': 0.05263157894736842, 'NOT_concept_above_switch_NOT_concept_target_below': 0.9210526315789473, 'NOT_concept_box_left_NOT_concept_target_below': 0.9210526315789473, 'NOT_concept_target_below_NOT_concept_target_left': 0.8947368421052632, 'NOT_concept_target_below_concept_target_right': 0.0, 'NOT_concept_left_switch_NOT_concept_target_below': 0.8947368421052632, 'NOT_concept_target_below_NOT_concept_wall_below': 0.6578947368421053, 'NOT_concept_box_right_NOT_concept_target_below': 0.9210526315789473, 'NOT_concept_target_below_concept_target_left': 0.02631578947368421, 'concept_box_right_concept_left_switch': 0.0, 'concept_left_switch_concept_wall_left_below_ofbox': 0.0, 'NOT_concept_wall_above_concept_left_switch': 0.0, 'concept_left_switch_concept_target_above': 0.0, 'concept_left_switch_concept_switch_on': 0.0, 'NOT_concept_target_above_concept_left_switch': 0.02631578947368421, 'NOT_concept_wall_left_below_ofbox_concept_left_switch': 0.02631578947368421, 'NOT_concept_empty_below_concept_left_switch': 0.02631578947368421, 'concept_above_switch_concept_left_switch': 0.0, 'concept_empty_below_concept_left_switch': 0.0, 'concept_left_switch_concept_wall_left': 0.0, 'NOT_concept_target_right_concept_left_switch': 0.02631578947368421, 'NOT_concept_wall_right_concept_left_switch': 0.02631578947368421, 'concept_empty_right_concept_left_switch': 0.0, 'concept_empty_left_concept_left_switch': 0.02631578947368421, 'NOT_concept_switch_on_concept_left_switch': 0.02631578947368421, 'concept_left_switch_concept_wall_above': 0.02631578947368421, 'NOT_concept_above_switch_concept_left_switch': 0.02631578947368421, 'NOT_concept_box_left_concept_left_switch': 0.02631578947368421, 'NOT_concept_target_left_concept_left_switch': 0.02631578947368421, 'concept_left_switch_concept_target_right': 0.0, 'NOT_concept_left_switch_concept_left_switch': 0.0, 'NOT_concept_wall_below_concept_left_switch': 0.0, 'NOT_concept_box_right_concept_left_switch': 0.02631578947368421, 'concept_left_switch_concept_target_left': 0.0, 'concept_box_right_concept_wall_left_below_ofbox': 0.0, 'NOT_concept_wall_above_concept_box_right': 0.0, 'concept_box_right_concept_target_above': 0.0, 'concept_box_right_concept_switch_on': 0.0, 'NOT_concept_target_above_concept_box_right': 0.0, 'NOT_concept_wall_left_below_ofbox_concept_box_right': 0.0, 'NOT_concept_empty_below_concept_box_right': 0.0, 'concept_above_switch_concept_box_right': 0.0, 'concept_box_right_concept_empty_below': 0.0, 'concept_box_right_concept_wall_left': 0.0, 'NOT_concept_target_right_concept_box_right': 0.0, 'NOT_concept_wall_right_concept_box_right': 0.0, 'concept_box_right_concept_empty_right': 0.0, 'concept_box_right_concept_empty_left': 0.0, 'NOT_concept_switch_on_concept_box_right': 0.0, 'concept_box_right_concept_wall_above': 0.0, 'NOT_concept_above_switch_concept_box_right': 0.0, 'NOT_concept_box_left_concept_box_right': 0.0, 'NOT_concept_target_left_concept_box_right': 0.0, 'concept_box_right_concept_target_right': 0.0, 'NOT_concept_left_switch_concept_box_right': 0.0, 'NOT_concept_wall_below_concept_box_right': 0.0, 'NOT_concept_box_right_concept_box_right': 0.0, 'concept_box_right_concept_target_left': 0.0, 'NOT_concept_wall_above_concept_wall_left_below_ofbox': 0.0, 'concept_target_above_concept_wall_left_below_ofbox': 0.0, 'concept_switch_on_concept_wall_left_below_ofbox': 0.0, 'NOT_concept_target_above_concept_wall_left_below_ofbox': 0.0, 'NOT_concept_wall_left_below_ofbox_concept_wall_left_below_ofbox': 0.0, 'NOT_concept_empty_below_concept_wall_left_below_ofbox': 0.0, 'concept_above_switch_concept_wall_left_below_ofbox': 0.0, 'concept_empty_below_concept_wall_left_below_ofbox': 0.0, 'concept_wall_left_concept_wall_left_below_ofbox': 0.0, 'NOT_concept_target_right_concept_wall_left_below_ofbox': 0.0, 'NOT_concept_wall_right_concept_wall_left_below_ofbox': 0.0, 'concept_empty_right_concept_wall_left_below_ofbox': 0.0, 'concept_empty_left_concept_wall_left_below_ofbox': 0.0, 'NOT_concept_switch_on_concept_wall_left_below_ofbox': 0.0, 'concept_wall_above_concept_wall_left_below_ofbox': 0.0, 'NOT_concept_above_switch_concept_wall_left_below_ofbox': 0.0, 'NOT_concept_box_left_concept_wall_left_below_ofbox': 0.0, 'NOT_concept_target_left_concept_wall_left_below_ofbox': 0.0, 'concept_target_right_concept_wall_left_below_ofbox': 0.0, 'NOT_concept_left_switch_concept_wall_left_below_ofbox': 0.0, 'NOT_concept_wall_below_concept_wall_left_below_ofbox': 0.0, 'NOT_concept_box_right_concept_wall_left_below_ofbox': 0.0, 'concept_target_left_concept_wall_left_below_ofbox': 0.0, 'NOT_concept_wall_above_concept_target_above': 0.02631578947368421, 'NOT_concept_wall_above_concept_switch_on': 0.23684210526315788, 'NOT_concept_target_above_NOT_concept_wall_above': 0.9210526315789473, 'NOT_concept_wall_above_NOT_concept_wall_left_below_ofbox': 0.9473684210526315, 'NOT_concept_empty_below_NOT_concept_wall_above': 0.2631578947368421, 'NOT_concept_wall_above_concept_above_switch': 0.0, 'NOT_concept_wall_above_concept_empty_below': 0.6842105263157895, 'NOT_concept_wall_above_concept_wall_left': 0.21052631578947367, 'NOT_concept_target_right_NOT_concept_wall_above': 0.9473684210526315, 'NOT_concept_wall_above_NOT_concept_wall_right': 0.6842105263157895, 'NOT_concept_wall_above_concept_empty_right': 0.6842105263157895, 'NOT_concept_wall_above_concept_empty_left': 0.7105263157894737, 'NOT_concept_switch_on_NOT_concept_wall_above': 0.7105263157894737, 'NOT_concept_wall_above_concept_wall_above': 0.0, 'NOT_concept_above_switch_NOT_concept_wall_above': 0.9473684210526315, 'NOT_concept_box_left_NOT_concept_wall_above': 0.9473684210526315, 'NOT_concept_target_left_NOT_concept_wall_above': 0.9210526315789473, 'NOT_concept_wall_above_concept_target_right': 0.0, 'NOT_concept_left_switch_NOT_concept_wall_above': 0.9473684210526315, 'NOT_concept_wall_above_NOT_concept_wall_below': 0.7105263157894737, 'NOT_concept_box_right_NOT_concept_wall_above': 0.9473684210526315, 'NOT_concept_wall_above_concept_target_left': 0.02631578947368421, 'concept_switch_on_concept_target_above': 0.0, 'NOT_concept_target_above_concept_target_above': 0.0, 'NOT_concept_wall_left_below_ofbox_concept_target_above': 0.02631578947368421, 'NOT_concept_empty_below_concept_target_above': 0.0, 'concept_above_switch_concept_target_above': 0.0, 'concept_empty_below_concept_target_above': 0.02631578947368421, 'concept_target_above_concept_wall_left': 0.0, 'NOT_concept_target_right_concept_target_above': 0.02631578947368421, 'NOT_concept_wall_right_concept_target_above': 0.02631578947368421, 'concept_empty_right_concept_target_above': 0.02631578947368421, 'concept_empty_left_concept_target_above': 0.02631578947368421, 'NOT_concept_switch_on_concept_target_above': 0.02631578947368421, 'concept_target_above_concept_wall_above': 0.0, 'NOT_concept_above_switch_concept_target_above': 0.02631578947368421, 'NOT_concept_box_left_concept_target_above': 0.02631578947368421, 'NOT_concept_target_left_concept_target_above': 0.02631578947368421, 'concept_target_above_concept_target_right': 0.0, 'NOT_concept_left_switch_concept_target_above': 0.02631578947368421, 'NOT_concept_wall_below_concept_target_above': 0.02631578947368421, 'NOT_concept_box_right_concept_target_above': 0.02631578947368421, 'concept_target_above_concept_target_left': 0.0, 'NOT_concept_target_above_concept_switch_on': 0.23684210526315788, 'NOT_concept_wall_left_below_ofbox_concept_switch_on': 0.23684210526315788, 'NOT_concept_empty_below_concept_switch_on': 0.07894736842105263, 'concept_above_switch_concept_switch_on': 0.0, 'concept_empty_below_concept_switch_on': 0.15789473684210525, 'concept_switch_on_concept_wall_left': 0.0, 'NOT_concept_target_right_concept_switch_on': 0.23684210526315788, 'NOT_concept_wall_right_concept_switch_on': 0.15789473684210525, 'concept_empty_right_concept_switch_on': 0.15789473684210525, 'concept_empty_left_concept_switch_on': 0.23684210526315788, 'NOT_concept_switch_on_concept_switch_on': 0.0, 'concept_switch_on_concept_wall_above': 0.0, 'NOT_concept_above_switch_concept_switch_on': 0.23684210526315788, 'NOT_concept_box_left_concept_switch_on': 0.23684210526315788, 'NOT_concept_target_left_concept_switch_on': 0.23684210526315788, 'concept_switch_on_concept_target_right': 0.0, 'NOT_concept_left_switch_concept_switch_on': 0.23684210526315788, 'NOT_concept_wall_below_concept_switch_on': 0.15789473684210525, 'NOT_concept_box_right_concept_switch_on': 0.23684210526315788, 'concept_switch_on_concept_target_left': 0.0, 'NOT_concept_target_above_NOT_concept_wall_left_below_ofbox': 0.9736842105263158, 'NOT_concept_empty_below_NOT_concept_target_above': 0.2894736842105263, 'NOT_concept_target_above_concept_above_switch': 0.0, 'NOT_concept_target_above_concept_empty_below': 0.6842105263157895, 'NOT_concept_target_above_concept_wall_left': 0.21052631578947367, 'NOT_concept_target_above_NOT_concept_target_right': 0.9736842105263158, 'NOT_concept_target_above_NOT_concept_wall_right': 0.7105263157894737, 'NOT_concept_target_above_concept_empty_right': 0.6842105263157895, 'NOT_concept_target_above_concept_empty_left': 0.7368421052631579, 'NOT_concept_switch_on_NOT_concept_target_above': 0.7368421052631579, 'NOT_concept_target_above_concept_wall_above': 0.05263157894736842, 'NOT_concept_above_switch_NOT_concept_target_above': 0.9736842105263158, 'NOT_concept_box_left_NOT_concept_target_above': 0.9736842105263158, 'NOT_concept_target_above_NOT_concept_target_left': 0.9473684210526315, 'NOT_concept_target_above_concept_target_right': 0.0, 'NOT_concept_left_switch_NOT_concept_target_above': 0.9473684210526315, 'NOT_concept_target_above_NOT_concept_wall_below': 0.7105263157894737, 'NOT_concept_box_right_NOT_concept_target_above': 0.9736842105263158, 'NOT_concept_target_above_concept_target_left': 0.02631578947368421, 'NOT_concept_empty_below_NOT_concept_wall_left_below_ofbox': 0.2894736842105263, 'NOT_concept_wall_left_below_ofbox_concept_above_switch': 0.0, 'NOT_concept_wall_left_below_ofbox_concept_empty_below': 0.7105263157894737, 'NOT_concept_wall_left_below_ofbox_concept_wall_left': 0.21052631578947367, 'NOT_concept_target_right_NOT_concept_wall_left_below_ofbox': 1.0, 'NOT_concept_wall_left_below_ofbox_NOT_concept_wall_right': 0.7368421052631579, 'NOT_concept_wall_left_below_ofbox_concept_empty_right': 0.7105263157894737, 'NOT_concept_wall_left_below_ofbox_concept_empty_left': 0.7631578947368421, 'NOT_concept_switch_on_NOT_concept_wall_left_below_ofbox': 0.7631578947368421, 'NOT_concept_wall_left_below_ofbox_concept_wall_above': 0.05263157894736842, 'NOT_concept_above_switch_NOT_concept_wall_left_below_ofbox': 1.0, 'NOT_concept_box_left_NOT_concept_wall_left_below_ofbox': 1.0, 'NOT_concept_target_left_NOT_concept_wall_left_below_ofbox': 0.9736842105263158, 'NOT_concept_wall_left_below_ofbox_concept_target_right': 0.0, 'NOT_concept_left_switch_NOT_concept_wall_left_below_ofbox': 0.9736842105263158, 'NOT_concept_wall_below_NOT_concept_wall_left_below_ofbox': 0.7368421052631579, 'NOT_concept_box_right_NOT_concept_wall_left_below_ofbox': 1.0, 'NOT_concept_wall_left_below_ofbox_concept_target_left': 0.02631578947368421, 'NOT_concept_empty_below_concept_above_switch': 0.0, 'NOT_concept_empty_below_concept_empty_below': 0.0, 'NOT_concept_empty_below_concept_wall_left': 0.05263157894736842, 'NOT_concept_empty_below_NOT_concept_target_right': 0.2894736842105263, 'NOT_concept_empty_below_NOT_concept_wall_right': 0.2631578947368421, 'NOT_concept_empty_below_concept_empty_right': 0.23684210526315788, 'NOT_concept_empty_below_concept_empty_left': 0.23684210526315788, 'NOT_concept_empty_below_NOT_concept_switch_on': 0.21052631578947367, 'NOT_concept_empty_below_concept_wall_above': 0.02631578947368421, 'NOT_concept_above_switch_NOT_concept_empty_below': 0.2894736842105263, 'NOT_concept_box_left_NOT_concept_empty_below': 0.2894736842105263, 'NOT_concept_empty_below_NOT_concept_target_left': 0.2894736842105263, 'NOT_concept_empty_below_concept_target_right': 0.0, 'NOT_concept_empty_below_NOT_concept_left_switch': 0.2631578947368421, 'NOT_concept_empty_below_NOT_concept_wall_below': 0.02631578947368421, 'NOT_concept_box_right_NOT_concept_empty_below': 0.2894736842105263, 'NOT_concept_empty_below_concept_target_left': 0.0, 'concept_above_switch_concept_empty_below': 0.0, 'concept_above_switch_concept_wall_left': 0.0, 'NOT_concept_target_right_concept_above_switch': 0.0, 'NOT_concept_wall_right_concept_above_switch': 0.0, 'concept_above_switch_concept_empty_right': 0.0, 'concept_above_switch_concept_empty_left': 0.0, 'NOT_concept_switch_on_concept_above_switch': 0.0, 'concept_above_switch_concept_wall_above': 0.0, 'NOT_concept_above_switch_concept_above_switch': 0.0, 'NOT_concept_box_left_concept_above_switch': 0.0, 'NOT_concept_target_left_concept_above_switch': 0.0, 'concept_above_switch_concept_target_right': 0.0, 'NOT_concept_left_switch_concept_above_switch': 0.0, 'NOT_concept_wall_below_concept_above_switch': 0.0, 'NOT_concept_box_right_concept_above_switch': 0.0, 'concept_above_switch_concept_target_left': 0.0, 'concept_empty_below_concept_wall_left': 0.15789473684210525, 'NOT_concept_target_right_concept_empty_below': 0.7105263157894737, 'NOT_concept_wall_right_concept_empty_below': 0.47368421052631576, 'concept_empty_below_concept_empty_right': 0.47368421052631576, 'concept_empty_below_concept_empty_left': 0.5263157894736842, 'NOT_concept_switch_on_concept_empty_below': 0.5526315789473685, 'concept_empty_below_concept_wall_above': 0.02631578947368421, 'NOT_concept_above_switch_concept_empty_below': 0.7105263157894737, 'NOT_concept_box_left_concept_empty_below': 0.7105263157894737, 'NOT_concept_target_left_concept_empty_below': 0.6842105263157895, 'concept_empty_below_concept_target_right': 0.0, 'NOT_concept_left_switch_concept_empty_below': 0.7105263157894737, 'NOT_concept_wall_below_concept_empty_below': 0.7105263157894737, 'NOT_concept_box_right_concept_empty_below': 0.7105263157894737, 'concept_empty_below_concept_target_left': 0.02631578947368421, 'NOT_concept_target_right_concept_wall_left': 0.21052631578947367, 'NOT_concept_wall_right_concept_wall_left': 0.21052631578947367, 'concept_empty_right_concept_wall_left': 0.21052631578947367, 'concept_empty_left_concept_wall_left': 0.0, 'NOT_concept_switch_on_concept_wall_left': 0.21052631578947367, 'concept_wall_above_concept_wall_left': 0.0, 'NOT_concept_above_switch_concept_wall_left': 0.21052631578947367, 'NOT_concept_box_left_concept_wall_left': 0.21052631578947367, 'NOT_concept_target_left_concept_wall_left': 0.21052631578947367, 'concept_target_right_concept_wall_left': 0.0, 'NOT_concept_left_switch_concept_wall_left': 0.21052631578947367, 'NOT_concept_wall_below_concept_wall_left': 0.15789473684210525, 'NOT_concept_box_right_concept_wall_left': 0.21052631578947367, 'concept_target_left_concept_wall_left': 0.0, 'NOT_concept_target_right_NOT_concept_wall_right': 0.7368421052631579, 'NOT_concept_target_right_concept_empty_right': 0.7105263157894737, 'NOT_concept_target_right_concept_empty_left': 0.7631578947368421, 'NOT_concept_switch_on_NOT_concept_target_right': 0.7631578947368421, 'NOT_concept_target_right_concept_wall_above': 0.05263157894736842, 'NOT_concept_above_switch_NOT_concept_target_right': 1.0, 'NOT_concept_box_left_NOT_concept_target_right': 1.0, 'NOT_concept_target_left_NOT_concept_target_right': 0.9736842105263158, 'NOT_concept_target_right_concept_target_right': 0.0, 'NOT_concept_left_switch_NOT_concept_target_right': 0.9736842105263158, 'NOT_concept_target_right_NOT_concept_wall_below': 0.7368421052631579, 'NOT_concept_box_right_NOT_concept_target_right': 1.0, 'NOT_concept_target_right_concept_target_left': 0.02631578947368421, 'NOT_concept_wall_right_concept_empty_right': 0.7105263157894737, 'NOT_concept_wall_right_concept_empty_left': 0.5, 'NOT_concept_switch_on_NOT_concept_wall_right': 0.5789473684210527, 'NOT_concept_wall_right_concept_wall_above': 0.05263157894736842, 'NOT_concept_above_switch_NOT_concept_wall_right': 0.7368421052631579, 'NOT_concept_box_left_NOT_concept_wall_right': 0.7368421052631579, 'NOT_concept_target_left_NOT_concept_wall_right': 0.7105263157894737, 'NOT_concept_wall_right_concept_target_right': 0.0, 'NOT_concept_left_switch_NOT_concept_wall_right': 0.7105263157894737, 'NOT_concept_wall_below_NOT_concept_wall_right': 0.5, 'NOT_concept_box_right_NOT_concept_wall_right': 0.7368421052631579, 'NOT_concept_wall_right_concept_target_left': 0.02631578947368421, 'concept_empty_left_concept_empty_right': 0.47368421052631576, 'NOT_concept_switch_on_concept_empty_right': 0.5526315789473685, 'concept_empty_right_concept_wall_above': 0.02631578947368421, 'NOT_concept_above_switch_concept_empty_right': 0.7105263157894737, 'NOT_concept_box_left_concept_empty_right': 0.7105263157894737, 'NOT_concept_target_left_concept_empty_right': 0.6842105263157895, 'concept_empty_right_concept_target_right': 0.0, 'NOT_concept_left_switch_concept_empty_right': 0.7105263157894737, 'NOT_concept_wall_below_concept_empty_right': 0.5, 'NOT_concept_box_right_concept_empty_right': 0.7105263157894737, 'concept_empty_right_concept_target_left': 0.02631578947368421, 'NOT_concept_switch_on_concept_empty_left': 0.5263157894736842, 'concept_empty_left_concept_wall_above': 0.05263157894736842, 'NOT_concept_above_switch_concept_empty_left': 0.7631578947368421, 'NOT_concept_box_left_concept_empty_left': 0.7631578947368421, 'NOT_concept_target_left_concept_empty_left': 0.7631578947368421, 'concept_empty_left_concept_target_right': 0.0, 'NOT_concept_left_switch_concept_empty_left': 0.7368421052631579, 'NOT_concept_wall_below_concept_empty_left': 0.5526315789473685, 'NOT_concept_box_right_concept_empty_left': 0.7631578947368421, 'concept_empty_left_concept_target_left': 0.0, 'NOT_concept_switch_on_concept_wall_above': 0.05263157894736842, 'NOT_concept_above_switch_NOT_concept_switch_on': 0.7631578947368421, 'NOT_concept_box_left_NOT_concept_switch_on': 0.7631578947368421, 'NOT_concept_switch_on_NOT_concept_target_left': 0.7368421052631579, 'NOT_concept_switch_on_concept_target_right': 0.0, 'NOT_concept_left_switch_NOT_concept_switch_on': 0.7368421052631579, 'NOT_concept_switch_on_NOT_concept_wall_below': 0.5789473684210527, 'NOT_concept_box_right_NOT_concept_switch_on': 0.7631578947368421, 'NOT_concept_switch_on_concept_target_left': 0.02631578947368421, 'NOT_concept_above_switch_concept_wall_above': 0.05263157894736842, 'NOT_concept_box_left_concept_wall_above': 0.05263157894736842, 'NOT_concept_target_left_concept_wall_above': 0.05263157894736842, 'concept_target_right_concept_wall_above': 0.0, 'NOT_concept_left_switch_concept_wall_above': 0.02631578947368421, 'NOT_concept_wall_below_concept_wall_above': 0.02631578947368421, 'NOT_concept_box_right_concept_wall_above': 0.05263157894736842, 'concept_target_left_concept_wall_above': 0.0, 'NOT_concept_above_switch_NOT_concept_box_left': 1.0, 'NOT_concept_above_switch_NOT_concept_target_left': 0.9736842105263158, 'NOT_concept_above_switch_concept_target_right': 0.0, 'NOT_concept_above_switch_NOT_concept_left_switch': 0.9736842105263158, 'NOT_concept_above_switch_NOT_concept_wall_below': 0.7368421052631579, 'NOT_concept_above_switch_NOT_concept_box_right': 1.0, 'NOT_concept_above_switch_concept_target_left': 0.02631578947368421, 'NOT_concept_box_left_NOT_concept_target_left': 0.9736842105263158, 'NOT_concept_box_left_concept_target_right': 0.0, 'NOT_concept_box_left_NOT_concept_left_switch': 0.9736842105263158, 'NOT_concept_box_left_NOT_concept_wall_below': 0.7368421052631579, 'NOT_concept_box_left_NOT_concept_box_right': 1.0, 'NOT_concept_box_left_concept_target_left': 0.02631578947368421, 'NOT_concept_target_left_concept_target_right': 0.0, 'NOT_concept_left_switch_NOT_concept_target_left': 0.9473684210526315, 'NOT_concept_target_left_NOT_concept_wall_below': 0.7105263157894737, 'NOT_concept_box_right_NOT_concept_target_left': 0.9736842105263158, 'NOT_concept_target_left_concept_target_left': 0.0, 'NOT_concept_left_switch_concept_target_right': 0.0, 'NOT_concept_wall_below_concept_target_right': 0.0, 'NOT_concept_box_right_concept_target_right': 0.0, 'concept_target_left_concept_target_right': 0.0, 'NOT_concept_left_switch_NOT_concept_wall_below': 0.7368421052631579, 'NOT_concept_box_right_NOT_concept_left_switch': 0.9736842105263158, 'NOT_concept_left_switch_concept_target_left': 0.02631578947368421, 'NOT_concept_box_right_NOT_concept_wall_below': 0.7368421052631579, 'NOT_concept_wall_below_concept_target_left': 0.02631578947368421, 'NOT_concept_box_right_concept_target_left': 0.02631578947368421}}
EXPLANATION_PRIOR = 0.5
SAMPLING_PRIOR_BUDGET = 500

# Random variable list
CONC = 'conc'
OB_CONC = 'Ob_conc'
NOT_CONC = 'not_conc'
NOT_OB_CONC = 'not_Ob_conc'
COST_FACT = 'costfact'
OBS_COST = 'Ob_costfact'

RAND_SEED = 5
