# ThermalGen: Style-Disentangled Flow-Based Generative Models for RGB-to-Thermal Image Translation

This is the official repository for [ThermalGen: Style-Disentangled Flow-Based Generative Models for RGB-to-Thermal Image Translation]().

Related works:  

```
TBD
```

## Setup

We provide an [`env.yml`](env.yml) file that can be used to create a Conda environment. If you only want 
to run pre-trained models locally on CPU, you can remove the `cudatoolkit` and `pytorch-cuda` requirements from the file.

```bash
# Under ThermalGen root folder
conda env create -f env.yml
conda activate ThermalGen
```


## Datasets
For Satellite-Aerial datasets, please download the dataset file from this link: [Dataset]() and directly put the folder in ``datasets_preprocess``.

For other datasets, please follow the link put in ``datasets_preprocess`` folder to download the raw dataset accordingly and put them in ``datasets_raw`` folder. For preprocessing, please check ``preprocessing`` folder. For example, if you want to preprocess AVIID dataset, run

```
# Under ThermalGen root folder
conda activate ThermalGen
python preprocess/format_datasets_AVIID.py # Ensure that AVIID raw dataset is put in ./ThermalGen/datasets_raw/AVIID.
```

The script will automatically create a ``AVIID`` folder in ``dataset_preprocess`` and put the preproccessed file there.

## Pretrained weights

We provide pretrained weights for [ThermalGen-B/2](), [ThermalGen-L/2](), [ThermalGen-XL/2](), [ThermalGen-L/2-concat](). To run the model, put the checkpoint folder under ``./ThermalGen/checkpoints/`` folder.

## Evaluation
For the evaluation of datasets, please refer to running script ``scripts/test_thermal_generation.sbatch`` and config file ``configs/test``.

For example, if you want to run ThermalGen-L/2-concat model, you should have a ``sit_l2_concat`` checkpoint folder in ``./ThermalGen/checkpoints/``. Run
```
# Under ThermalGen root folder
conda activate ThermalGen
export CONFIG=configs/test/sit_cond/sit_l2_concat.yml
scripts/test_thermal_generation.sbatch
```

To run CFG, refer to the example code in [test_cfg.sh](test_cfg.sh)

## Training
For the evaluation of datasets, please refer to running script ``scripts/train_thermal_generation_long.sbatch`` and config file ``configs/test``.

For example, if you want to train ThermalGen-L/2-concat model, run
```
# Under ThermalGen root folder
conda activate ThermalGen
export CONFIG=configs/train/sit_cond/sit_l2_concat.yml
./scripts/train_thermal_generation_long.sbatch
```

Please find the example code in [train_generate.sh](train_generate.sh)
