<h1 align="center">
Meta-Learning Adaptive Loss Functions
</h1>

This repository contains code for reproducing the experiments in the paper "Meta-Learning Adaptive Loss Functions" by Redacted. A [PyTorch](https://pytorch.org/) + [Higher](https://github.com/facebookresearch/higher) implementation of the newly proposed *Adaptive Loss Function Learning* (AdaLFL) algorithm.

![banner-image](https://github.com/redacted)

## Installation

1. Clone this repository to your local machine:
```bash
git clone https://github.com/redacted
cd Meta-Learning Adaptive Loss Functions
```

2. Install the necessary libraries and dependencies:
```bash
pip install requirements.txt
```

## Usage

To run the baseline experiments using cross-entropy/squared loss run the following command via the terminal:
```
python experiments/run_baseline.py --dataset dataset_name --model model_name --seeds [seeds] --device device
```

To run the offline loss function learning experiments run the following command via the terminal:
```
python experiments/run_offline.py --dataset dataset_name --model model_name --seeds [seeds] --device device
```

To run the online loss function learning (AdaLFL) experiments run the following command via the terminal:
```
python experiments/run_online.py --dataset dataset_name --model model_name --seeds [seeds] --device device
```


### Available Arguments:

- **Dataset** = {mnist, cifar10, cifar100, svhn, california, boston, diabetes}
- **Model** = {linear, mlp, lenet5, alexnet, vgg{11, 13, 16, 19}, allcnnc, resnet{18, 34, 50, 101, 152}, preresnet{18, 34, 50, 101, 152}, wrn{40-4, 16-8, 28-10}, squeezenet, pyramidnet}

### Code Reproducibility: 

The code has not been comprehensively checked and re-run since refactoring. If you're having any issues, find a problem/bug or cannot reproduce similar results as the paper please [open an issue](https://github.com/redacted) or email me.
