import ast


def register_configurations(parser):

    # Offline Meta-Learning Hyper-parameters.
    parser.add_argument("--offline_meta_gradient_steps", required=False, type=int)
    parser.add_argument("--offline_inner_gradient_steps", required=False, type=int)
    parser.add_argument("--offline_meta_optimizer_name", required=False, type=str)

    # Online Meta-Learning Hyper-parameters.
    parser.add_argument("--online_meta_gradient_steps", required=False, type=int)
    parser.add_argument("--online_inner_gradient_steps", required=False, type=int)
    parser.add_argument("--online_meta_optimizer_name", required=False, type=str)

    # Base Learning Hyper-parameters
    parser.add_argument("--base_batch_size", required=False, type=int)
    parser.add_argument("--base_optimizer_name", required=False, type=str)

    # Loss Function Learning Objectives
    parser.add_argument("--performance_metric", required=False, type=str)
    parser.add_argument("--task_loss", required=False, type=str)

    # Experiment Settings
    parser.add_argument("--description", required=False, type=str, nargs='+')
    parser.add_argument("--output_path", required=False, type=str)
    parser.add_argument("--verbose", required=False, type=int)


def override_configurations(args, args_unknown, required_args, config):

    # Iterating over all the known overridden arguments.
    for arg in vars(args):

        # Non empty arguments which have been manually provided.
        if getattr(args, arg) is not None and arg not in required_args:

            # Overriding the default hyper-parameter value.
            config[arg] = getattr(args, arg)

    # Iterating over all the unknown overridden arguments (those that are inside a dictionary).
    if len(args_unknown) != 0:

        # Iterating over the list in key value pairs.
        for key, arg in zip(args_unknown[0::2], args_unknown[1::2]):

            if "offline_meta_optimizer" in key:
                key = key.replace("--offline_meta_optimizer_", "")
                config["offline_meta_optimizer_settings"][key] = ast.literal_eval(arg)

            elif "online_meta_optimizer" in key:
                key = key.replace("--online_meta_optimizer_", "")
                config["online_meta_optimizer_settings"][key] = ast.literal_eval(arg)

            elif "base_optimizer" in key:
                key = key.replace("--base_optimizer_", "")
                config["base_optimizer_settings"][key] = ast.literal_eval(arg)

            else:
                raise ValueError("Don't know how to parse", key, arg)
