#!/bin/bash
#SBATCH --time=24:00:00
#SBATCH --mem=500M
#SBATCH --output=bayesian_reup_graph-%a.out
#SBATCH --array=0-3

case $SLURM_ARRAY_TASK_ID in
   0)  DATA="synthesis" ;;
   1)  DATA="german"  ;;
   2)  DATA="student"  ;;
   3)  DATA="bank"  ;;
esac

srun python run_expt.py -e 1 --datasets $DATA -clf mlp --method bayesian_reup -uc