"""
Custom exceptions for Bedrock Claude client.
"""


class BedrockClaudeError(Exception):
    """Base exception class for Bedrock Claude client."""
    pass


class BedrockConfigError(BedrockClaudeError):
    """Exception raised for configuration errors."""
    pass


class BedrockAPIError(BedrockClaudeError):
    """Exception raised for AWS Bedrock API errors."""
    
    def __init__(self, message: str, error_code: str = None, status_code: int = None):
        super().__init__(message)
        self.error_code = error_code
        self.status_code = status_code


class BedrockModelError(BedrockClaudeError):
    """Exception raised for model-specific errors."""
    pass


class BedrockAuthError(BedrockClaudeError):
    """Exception raised for authentication/authorization errors."""
    pass


class BedrockTokenExpiredError(BedrockClaudeError):
    """Exception raised when AWS token expires and session needs refresh."""
    pass
