from .anchor_points import AnchorPointsWeightedCompress, AnchorPointPredictorCompress
from .deepcore import (
    KCenterGreedyCompress,
    HerdingCompress,
    ContextualDiversityCompress,
)
from .double_optimize import DoubleOptimizeCompress
from .lasso import LassoCompress
from .pca import PCACompress
from .random import RandomSelection, RandomSelectionAndLearn, RandomSearchAndLearn
from .ppi import PPI
from .tiny_bench import PIRTCompress, GPIRTCompress

all_methods = {
    "random_selection": RandomSelection,
    "random_selection_and_learn": RandomSelectionAndLearn,
    "random_search_and_learn": RandomSearchAndLearn,
    "ppi": PPI,
    "k_center_greedy": KCenterGreedyCompress,
    "herding": HerdingCompress,
    "contextual_diversity": ContextualDiversityCompress,
    "pca": PCACompress,
    "anchor_points_weighted": AnchorPointsWeightedCompress,
    "anchor_points_predictor": AnchorPointPredictorCompress,
    "double_optimize": DoubleOptimizeCompress,
    "lasso": LassoCompress,
    "pirt": PIRTCompress,
    "gpirt": GPIRTCompress,
}
