import numpy as np
from scipy import stats

def read_data_from_file(filename):
    """从文本文件中读取数据并转换为 NumPy 数组。"""
    with open(filename, 'r') as file:
        # 读取文件中的所有行，转换为浮点数列表
        data = [float(line.strip()) for line in file]
    return np.array(data)

def main():
    # 数据
    group1 = read_data_from_file('model_outputs_EM.txt')
    group2 = read_data_from_file('model_outputs_gumble.txt')#gumble#L1#L2

    # 正态性检验
    shapiro_test_group1 = stats.shapiro(group1)
    shapiro_test_group2 = stats.shapiro(group2)

    print("Group 1 Shapiro-Wilk Test: W = {:.3f}, p = {:.3f}".format(shapiro_test_group1.statistic, shapiro_test_group1.pvalue))
    print("Group 2 Shapiro-Wilk Test: W = {:.3f}, p = {:.3f}".format(shapiro_test_group2.statistic, shapiro_test_group2.pvalue))

    # # 根据正态性检验的结果选择统计测试
    if shapiro_test_group1.pvalue > 0.05 and shapiro_test_group2.pvalue > 0.05:
        # 使用 t 检验
        t_test_result = stats.ttest_ind(group1, group2, equal_var=False)  # 使用 Welch's T-test，不假设方差齐性
        print("Independent T-Test: t = {:.3f}, p = {:.3f}".format(t_test_result.statistic, t_test_result.pvalue))
    else:
        # 使用 Mann-Whitney U 检验
        mw_test_result = stats.mannwhitneyu(group1, group2, alternative='greater')
        print("Mann-Whitney U Test: U = {:.3f}, p = {:.3f}".format(mw_test_result.statistic, mw_test_result.pvalue))
    # t_test_result = stats.ttest_ind(group1, group2, equal_var=False)  # 使用 Welch's T-test，不假设方差齐性
    # print("Independent T-Test: t = {:.3f}, p = {:.3f}".format(t_test_result.statistic, t_test_result.pvalue))    
    # mw_test_result = stats.mannwhitneyu(group1, group2, alternative='greater')
    # print("Mann-Whitney U Test: U = {:.3f}, p = {:.3f}".format(mw_test_result.statistic, mw_test_result.pvalue))

if __name__ == "__main__":
    main()
