set.seed(2024)
# sample sizes to be considered
sample_sizes <- 10^(2:5)
# the number of summands to be included to approximate the infinite sum
threshold <- 50
# parameter of the VAR process
phis <- c(2, 3, 5)

# initialize data frame where results are to be stored
results_df <- data.frame()
results_df[, 1] <- numeric(0)
results_df[, 2] <- numeric(0)
results_df[, 3] <- numeric(0)
results_df[, 4] <- numeric(0)
names(results_df) <- c("phi", "n", "cov_mean", "cov_se")

# number of how often covariances should be calculated
B <- 100

# iterate through the parameters and different sample sizes
for (phi in phis) {
  
  for (n in sample_sizes) {
    
      covs <- numeric(B)
      
      for (b in 1:B) {
        # generate noise terms
        epsilonsX <- matrix(rnorm(n * (threshold + 1)), ncol = threshold + 1)
        epsilonsY <- matrix(rnorm(n * (threshold + 1)), ncol = threshold + 1)
        
        # (approximately) sample from X0
        X <- - (epsilonsX[, 2:(threshold + 1)] + epsilonsY[, 1:threshold]) %*% 
          matrix(phi^(-(1:threshold)), nrow = threshold)
        
        # calculate covariance between X0 and epsilon^2_1
        covs[b] <- cov(X, epsilonsY[, 2])
      }
      results_df[nrow(results_df) + 1, 1] <- phi
      results_df[nrow(results_df), 2] <- n
      results_df[nrow(results_df), 3] <- mean(covs)
      results_df[nrow(results_df), 4] <- sd(covs) / sqrt(B)

    
  }
}
results_df
