# Copyright (c) Meta Platforms, Inc. and affiliates.
# All rights reserved.
#
# This source code is licensed under the license found in the
# LICENSE file in the root directory of this source tree.

"""
Grid search file, simply list all the exp you want in `explorer`.
Any new exp added there will be scheduled.
You can cancel and experiment by commenting its line.

This grid shows how to train a base causal EnCodec model at 24 kHz.
"""

from ...environment import AudioCraftEnvironment
from ._explorers import CompressionExplorer


@CompressionExplorer
def explorer(launcher):
    partitions = AudioCraftEnvironment.get_slurm_partitions(["team", "global"])
    launcher.slurm_(gpus=8, partition=partitions)
    # base causal EnCodec trained on monophonic audio sampled at 24 kHz
    launcher.bind_(solver="compression/encodec_base_24khz")
    # replace this by the desired dataset
    launcher.bind_(dset="audio/example")
    # launch xp
    launcher()
