import numpy as np
import math

def run_FGC_CR(n, k, d):
    M = np.zeros(n) - 1  # -1 means unassigned
    d_local = np.copy(d)
    l = math.ceil(n / k)  # approximate cluster size
    r = 0  # cluster label
    C = []  # list to store cluster center indices
    R = []  # list to store cluster radii (min-max distances)

    while True:
        # Find the row with the smallest l-th smallest distance
        smallest_row_index = np.argmin(np.partition(d_local, l - 1, axis=1)[:, l - 1])
        smallest_row = d_local[smallest_row_index]
        value = max(np.sort(smallest_row)[:l])

        if value == np.inf:
            break

        cluster = np.argsort(smallest_row)[:l]
        for i in cluster:
            M[i] = r

        # Use the initially selected row as the center and its value as the radius
        C.append(smallest_row_index)
        R.append(value)

        # Invalidate selected cluster points in distance matrix
        for i in range(n):
            for j in cluster:
                d_local[i][j] = np.inf
        for j in cluster:
            for i in range(n):
                d_local[j][i] = np.inf

        r += 1

    # Assign leftover points to a new cluster
    M = [r if element == -1 else element for element in M]
    # Process the final (residual) cluster: find its center and radius
    final_cluster = [i for i, label in enumerate(M) if label == r]
    if final_cluster:
        min_max_dist = np.inf
        center_idx = -1
        for i in final_cluster:
            max_dist = max(d[i][j] for j in final_cluster)
            if max_dist < min_max_dist:
                min_max_dist = max_dist
                center_idx = i
        C.append(center_idx)
        R.append(min_max_dist)

    return M, C, R
