import gurobipy as gp
from gurobipy import GRB
import numpy as np

import os
import gurobipy as gp



def run_FJR_mixed(n, k, d, M, theta, lambda_, C):

    alpha_max = 1
    cost = np.zeros((n))

    # Mixed cost function from prior assignment
    for i in range(n):
        md = 0
        for j in range(n):
            if M[i] == M[j] and d[i][j] > md:
                md = d[i][j]
        cd = d[i][C[int(M[i])]]
        cost[i] = lambda_ * md + (1 - lambda_) * cd

    # L = 1000000
    L = 100 * np.max(d)  # 或 2 * max(cost)
    epsilon = 0.01
    lower_bound = 1.0
    upper_bound = 4 * theta
    flag = 0
    condition_meet = 0

    while upper_bound - lower_bound > epsilon and condition_meet == 0:
        alpha = (upper_bound + lower_bound) / 2
        # test output
        # print(f"FJR-Testing alpha={alpha}, bounds=[{lower_bound}, {upper_bound}]")

        model = gp.Model("fjr_mixed")
        model.Params.OutputFlag = 0

        x = {}
        for i in range(n):
            x[i] = model.addVar(vtype=GRB.BINARY, name=f"x_{i}")
        y = {}
        for i in range(n):
            y[i] = model.addVar(vtype=GRB.BINARY, name=f"y_{i}")
        z_max = {}
        for i in range(n):
            z_max[i] = model.addVar(lb=0.0, name=f"zmax_{i}")
        dist_to_center = {}
        for i in range(n):
            dist_to_center[i] = model.addVar(lb=0.0, name=f"dist_center_{i}")
        Z = model.addVar(lb=0.0, name="Z")

        # Coalition size constraint
        model.addConstr(gp.quicksum(x[i] for i in range(n)) >= n / k)

        # Only one center among deviators
        model.addConstr(gp.quicksum(y[i] for i in range(n)) == 1)
        for i in range(n):
            model.addConstr(y[i] <= x[i])

        # max distance to others in coalition
        for i in range(n):
            for j in range(n):
                model.addConstr(z_max[i] >= d[i][j] * x[j])
            model.addConstr(dist_to_center[i] == gp.quicksum(y[c] * d[i][c] for c in range(n)))

            # define cost for each i in coalition
            expr = lambda_ * z_max[i] + (1 - lambda_) * dist_to_center[i]
            model.addConstr(expr <= Z + L * (1 - x[i]))

            # ensure previous cost is worse than alpha * new cost
            model.addConstr(alpha * Z <= cost[i] + L * (1 - x[i]))

        model.optimize()
        # test output 1
        # print(f"FJR-Model status: {model.status}")
        #if model.status == GRB.OPTIMAL:
        #    print(f"FJR-Found feasible alpha={alpha}")

        # 添加调试输出
        #if model.status == GRB.OPTIMAL:
        #    print(f"FJR-Z value: {Z.X}")
        #    for i in range(n):
        #        if x[i].X > 0.5:  # 仅打印联盟内成员
        #            print(
        #                f"FJR-Member {i}: old_cost={cost[i]}, new_cost={lambda_ * z_max[i].X + (1 - lambda_) * dist_to_center[i].X}")

        if model.status == GRB.OPTIMAL:
            flag = 1
            alpha_max = max(alpha_max, alpha)
            lower_bound = alpha
        else:
            upper_bound = alpha

    if flag == 0:
        alpha = 1

    return alpha
