import gurobipy as gp
from gurobipy import GRB
import numpy as np

import os
import gurobipy as gp


def run_core_mixed(n, k, d, M, theta, lambda_, C):

    alpha_max = 1
    cost = np.zeros((n))

    # Combined cost: lambda-weighted max distance and center distance
    for i in range(n):
        md = 0  # max distance within the same cluster
        for j in range(n):
            if M[i] == M[j] and d[i][j] > md:
                md = d[i][j]
        cd = d[i][C[int(M[i])]]  # distance to cluster center
        cost[i] = lambda_ * md + (1 - lambda_) * cd

    # L = 1000000  # Large constant for constraint relaxation
    L = 100 * np.max(d)  # 或 2 * max(cost)
    epsilon = 0.01  # Desired precision
    lower_bound = 1.0
    upper_bound = 4 * theta

    flag = 0
    condition_meet = 0

    while upper_bound - lower_bound > epsilon and condition_meet == 0:
        alpha = (upper_bound + lower_bound) / 2
        #testing output
        #print(f"Core-Testing alpha={alpha}, bounds=[{lower_bound}, {upper_bound}]")

        model = gp.Model("optimization_problem")
        model.Params.OutputFlag = 0

        x = {}
        for i in range(n):
            x[i] = model.addVar(vtype=GRB.BINARY, name=f"x_{i}")

        model.addConstr(gp.quicksum(x[i] for i in range(n)) >= n / k)

        # Auxiliary variable: new center index selection
        y = {}
        for i in range(n):
            y[i] = model.addVar(vtype=GRB.BINARY, name=f"y_{i}")
        model.addConstr(gp.quicksum(y[i] for i in range(n)) == 1)
        for i in range(n):
            model.addConstr(y[i] <= x[i])  # center must be in the deviating coalition

        # Auxiliary variable: max distance to deviators
        z_max = {}
        for i in range(n):
            z_max[i] = model.addVar(lb=0.0, name=f"zmax_{i}")
            for j in range(n):
                model.addConstr(z_max[i] >= d[i][j] * x[j])

        # Auxiliary variable: distance to new center
        dist_to_center = {}
        for i in range(n):
            dist_to_center[i] = model.addVar(lb=0.0, name=f"dist_center_{i}")
            model.addConstr(dist_to_center[i] == gp.quicksum(y[c] * d[i][c] for c in range(n)))

        # Final constraint
        for i in range(n):
            model.addConstr(
                alpha * (lambda_ * z_max[i] + (1 - lambda_) * dist_to_center[i]) <= cost[i] + L * (1 - x[i])
            )

        model.optimize()

        # testing output
        # print(f"Core-Model status: {model.status}")
        # if model.status == GRB.OPTIMAL:
        #     print(f"Core-Found feasible alpha={alpha}")

        if model.status == GRB.OPTIMAL:
            flag = 1
            alpha_max = max(alpha_max, alpha)
            lower_bound = alpha
            solution = {}
            for v in model.getVars():
                solution[v.varName] = v.x
        else:
            upper_bound = alpha

    if flag == 0:
        alpha = 1

    return alpha
