import numpy as np
from scipy.spatial.distance import pdist, squareform
from scipy.cluster.hierarchy import linkage, to_tree

def within_cluster(dist_matrix, clustering):
  
    s = dist_matrix.shape
    if len(s) == 1:
        dist_matrix = squareform(dist_matrix)

    cost = 0
    for ell in np.unique(clustering):
        in_cluster = (clustering == ell)
        if np.sum(in_cluster) > 1:
            cost = cost + np.sum(dist_matrix[np.ix_(in_cluster, in_cluster)]) / (2*np.sum(in_cluster) )
    return cost



def kmeans_objective(dist_matrix, clustering):

    s = dist_matrix.shape
    if len(s) == 1:
        dist_matrix = squareform(dist_matrix)

    cost=0
    for ell in np.unique(clustering):
        in_cluster = (clustering == ell)
        if np.sum(in_cluster) > 1:
            cost = cost + np.sum(dist_matrix[np.ix_(in_cluster, in_cluster)]**2) / (2*np.sum(in_cluster) )

    return cost



def kmedoids_objective(dist_matrix, clustering):
    
    s = dist_matrix.shape
    if len(s) == 1:
        dist_matrix = squareform(dist_matrix)

    cost = 0
    for ell in np.unique(clustering):
        in_cluster = np.where(clustering == ell)[0]
        center=np.zeros(len(in_cluster))
        r=0
        for i in in_cluster:
            for j in in_cluster:
                center[r]+=dist_matrix[i][j]
            r+=1    
        cost = cost + min(center)
    return cost

