import numpy as np

def refine_FGC_assignments(n, k, d, M, C, R, lambda_, c0):
    num_clusters = len(C)
    new_M = np.array(M, dtype=int) # Initialize the new label array

    for i in range(n):
        """
        old_j: old label of datapoint i
        x_star: old center corresponds to i
        cost_old: Scaled mixed cost
        """
        old_j = new_M[i]
        x_star = C[old_j]
        cost_old = d[i, x_star] + c0 * lambda_ * R[old_j]
        # Initialize the best_cost and best new choice of center (best_j) by the old_cost and old_j
        best_cost = cost_old
        best_j = old_j

        for j in range(num_clusters):
            y = C[j]
            # Reassign under constraint
            if d[i, y] <= c0 * R[j]:
                cost_new = (1 - lambda_) * d[i, y] + c0 * lambda_ * 2 * R[j]
                if cost_new < best_cost:
                    best_cost = cost_new
                    best_j = j

        # Update the new best choice of i
        new_M[i] = best_j

    return new_M