import os

# backbone (e.g., conv / transformer)
backbones = {}
def register_backbone(name):
    def decorator(cls):
        backbones[name] = cls
        return cls
    return decorator

# neck (e.g., FPN)
necks = {}
def register_neck(name):
    def decorator(cls):
        necks[name] = cls
        return cls
    return decorator

# location generator (point, segment, etc)
generators = {}
def register_generator(name):
    def decorator(cls):
        generators[name] = cls
        return cls
    return decorator

# meta arch (the actual implementation of each model)
meta_archs = {}
def register_meta_arch(name):
    def decorator(cls):
        meta_archs[name] = cls
        return cls
    return decorator

# builder functions
def make_backbone(name, **kwargs):
    backbone = backbones[name](**kwargs)
    return backbone

def make_neck(name, **kwargs):
    neck = necks[name](**kwargs)
    return neck

def make_meta_arch(name, **kwargs):
    meta_arch = meta_archs[name](**kwargs)
    return meta_arch

def make_generator(name, **kwargs):
    generator = generators[name](**kwargs)
    return generator
#thumos14的总网络结构
'''
PtTransformer(
  (backbone): ConvTransformerBackbone(
    (relu): ReLU(inplace=True)
    (embd): ModuleList(
      (0): MaskedConv1D(
        (conv): Conv1d(2048, 512, kernel_size=(3,), stride=(1,), padding=(1,), bias=False)
      )
      (1): MaskedConv1D(
        (conv): Conv1d(512, 512, kernel_size=(3,), stride=(1,), padding=(1,), bias=False)
      )
    )
    (embd_norm): ModuleList(
      (0): LayerNorm()
      (1): LayerNorm()
    )
    (stem): ModuleList(
      (0): TransformerBlock(
        (ln1): LayerNorm()
        (ln2): LayerNorm()
        (attn): LocalMaskedMHCA(
          (query_conv): MaskedConv1D(
            (conv): Conv1d(512, 512, kernel_size=(3,), stride=(1,), padding=(1,), groups=512, bias=False)
          )
          (query_norm): LayerNorm()
          (key_conv): MaskedConv1D(
            (conv): Conv1d(512, 512, kernel_size=(3,), stride=(1,), padding=(1,), groups=512, bias=False)
          )
          (key_norm): LayerNorm()
          (value_conv): MaskedConv1D(
            (conv): Conv1d(512, 512, kernel_size=(3,), stride=(1,), padding=(1,), groups=512, bias=False)
          )
          (value_norm): LayerNorm()
          (key): Conv1d(512, 512, kernel_size=(1,), stride=(1,))
          (query): Conv1d(512, 512, kernel_size=(1,), stride=(1,))
          (value): Conv1d(512, 512, kernel_size=(1,), stride=(1,))
          (attn_drop): Dropout(p=0.0, inplace=False)
          (proj_drop): Dropout(p=0.0, inplace=False)
          (proj): Conv1d(512, 512, kernel_size=(1,), stride=(1,))
        )
        (pool_skip): Identity()
        (mlp): Sequential(
          (0): Conv1d(512, 2048, kernel_size=(1,), stride=(1,))
          (1): GELU()
          (2): Dropout(p=0.0, inplace=True)
          (3): Conv1d(2048, 512, kernel_size=(1,), stride=(1,))
          (4): Dropout(p=0.0, inplace=True)
        )
        (drop_path_attn): AffineDropPath()
        (drop_path_mlp): AffineDropPath()
      )
      (1): TransformerBlock(
        (ln1): LayerNorm()
        (ln2): LayerNorm()
        (attn): LocalMaskedMHCA(
          (query_conv): MaskedConv1D(
            (conv): Conv1d(512, 512, kernel_size=(3,), stride=(1,), padding=(1,), groups=512, bias=False)
          )
          (query_norm): LayerNorm()
          (key_conv): MaskedConv1D(
            (conv): Conv1d(512, 512, kernel_size=(3,), stride=(1,), padding=(1,), groups=512, bias=False)
          )
          (key_norm): LayerNorm()
          (value_conv): MaskedConv1D(
            (conv): Conv1d(512, 512, kernel_size=(3,), stride=(1,), padding=(1,), groups=512, bias=False)
          )
          (value_norm): LayerNorm()
          (key): Conv1d(512, 512, kernel_size=(1,), stride=(1,))
          (query): Conv1d(512, 512, kernel_size=(1,), stride=(1,))
          (value): Conv1d(512, 512, kernel_size=(1,), stride=(1,))
          (attn_drop): Dropout(p=0.0, inplace=False)
          (proj_drop): Dropout(p=0.0, inplace=False)
          (proj): Conv1d(512, 512, kernel_size=(1,), stride=(1,))
        )
        (pool_skip): Identity()
        (mlp): Sequential(
          (0): Conv1d(512, 2048, kernel_size=(1,), stride=(1,))
          (1): GELU()
          (2): Dropout(p=0.0, inplace=True)
          (3): Conv1d(2048, 512, kernel_size=(1,), stride=(1,))
          (4): Dropout(p=0.0, inplace=True)
        )
        (drop_path_attn): AffineDropPath()
        (drop_path_mlp): AffineDropPath()
      )
    )
    (branch): ModuleList(
      (0): TransformerBlock(
        (ln1): LayerNorm()
        (ln2): LayerNorm()
        (attn): LocalMaskedMHCA(
          (query_conv): MaskedConv1D(
            (conv): Conv1d(512, 512, kernel_size=(3,), stride=(2,), padding=(1,), groups=512, bias=False)
          )
          (query_norm): LayerNorm()
          (key_conv): MaskedConv1D(
            (conv): Conv1d(512, 512, kernel_size=(3,), stride=(2,), padding=(1,), groups=512, bias=False)
          )
          (key_norm): LayerNorm()
          (value_conv): MaskedConv1D(
            (conv): Conv1d(512, 512, kernel_size=(3,), stride=(2,), padding=(1,), groups=512, bias=False)
          )
          (value_norm): LayerNorm()
          (key): Conv1d(512, 512, kernel_size=(1,), stride=(1,))
          (query): Conv1d(512, 512, kernel_size=(1,), stride=(1,))
          (value): Conv1d(512, 512, kernel_size=(1,), stride=(1,))
          (attn_drop): Dropout(p=0.0, inplace=False)
          (proj_drop): Dropout(p=0.0, inplace=False)
          (proj): Conv1d(512, 512, kernel_size=(1,), stride=(1,))
        )
        (pool_skip): MaxPool1d(kernel_size=3, stride=2, padding=1, dilation=1, ceil_mode=False)
        (mlp): Sequential(
          (0): Conv1d(512, 2048, kernel_size=(1,), stride=(1,))
          (1): GELU()
          (2): Dropout(p=0.0, inplace=True)
          (3): Conv1d(2048, 512, kernel_size=(1,), stride=(1,))
          (4): Dropout(p=0.0, inplace=True)
        )
        (drop_path_attn): AffineDropPath()
        (drop_path_mlp): AffineDropPath()
      )
      (1): TransformerBlock(
        (ln1): LayerNorm()
        (ln2): LayerNorm()
        (attn): LocalMaskedMHCA(
          (query_conv): MaskedConv1D(
            (conv): Conv1d(512, 512, kernel_size=(3,), stride=(2,), padding=(1,), groups=512, bias=False)
          )
          (query_norm): LayerNorm()
          (key_conv): MaskedConv1D(
            (conv): Conv1d(512, 512, kernel_size=(3,), stride=(2,), padding=(1,), groups=512, bias=False)
          )
          (key_norm): LayerNorm()
          (value_conv): MaskedConv1D(
            (conv): Conv1d(512, 512, kernel_size=(3,), stride=(2,), padding=(1,), groups=512, bias=False)
          )
          (value_norm): LayerNorm()
          (key): Conv1d(512, 512, kernel_size=(1,), stride=(1,))
          (query): Conv1d(512, 512, kernel_size=(1,), stride=(1,))
          (value): Conv1d(512, 512, kernel_size=(1,), stride=(1,))
          (attn_drop): Dropout(p=0.0, inplace=False)
          (proj_drop): Dropout(p=0.0, inplace=False)
          (proj): Conv1d(512, 512, kernel_size=(1,), stride=(1,))
        )
        (pool_skip): MaxPool1d(kernel_size=3, stride=2, padding=1, dilation=1, ceil_mode=False)
        (mlp): Sequential(
          (0): Conv1d(512, 2048, kernel_size=(1,), stride=(1,))
          (1): GELU()
          (2): Dropout(p=0.0, inplace=True)
          (3): Conv1d(2048, 512, kernel_size=(1,), stride=(1,))
          (4): Dropout(p=0.0, inplace=True)
        )
        (drop_path_attn): AffineDropPath()
        (drop_path_mlp): AffineDropPath()
      )
      (2): TransformerBlock(
        (ln1): LayerNorm()
        (ln2): LayerNorm()
        (attn): LocalMaskedMHCA(
          (query_conv): MaskedConv1D(
            (conv): Conv1d(512, 512, kernel_size=(3,), stride=(2,), padding=(1,), groups=512, bias=False)
          )
          (query_norm): LayerNorm()
          (key_conv): MaskedConv1D(
            (conv): Conv1d(512, 512, kernel_size=(3,), stride=(2,), padding=(1,), groups=512, bias=False)
          )
          (key_norm): LayerNorm()
          (value_conv): MaskedConv1D(
            (conv): Conv1d(512, 512, kernel_size=(3,), stride=(2,), padding=(1,), groups=512, bias=False)
          )
          (value_norm): LayerNorm()
          (key): Conv1d(512, 512, kernel_size=(1,), stride=(1,))
          (query): Conv1d(512, 512, kernel_size=(1,), stride=(1,))
          (value): Conv1d(512, 512, kernel_size=(1,), stride=(1,))
          (attn_drop): Dropout(p=0.0, inplace=False)
          (proj_drop): Dropout(p=0.0, inplace=False)
          (proj): Conv1d(512, 512, kernel_size=(1,), stride=(1,))
        )
        (pool_skip): MaxPool1d(kernel_size=3, stride=2, padding=1, dilation=1, ceil_mode=False)
        (mlp): Sequential(
          (0): Conv1d(512, 2048, kernel_size=(1,), stride=(1,))
          (1): GELU()
          (2): Dropout(p=0.0, inplace=True)
          (3): Conv1d(2048, 512, kernel_size=(1,), stride=(1,))
          (4): Dropout(p=0.0, inplace=True)
        )
        (drop_path_attn): AffineDropPath()
        (drop_path_mlp): AffineDropPath()
      )
      (3): TransformerBlock(
        (ln1): LayerNorm()
        (ln2): LayerNorm()
        (attn): LocalMaskedMHCA(
          (query_conv): MaskedConv1D(
            (conv): Conv1d(512, 512, kernel_size=(3,), stride=(2,), padding=(1,), groups=512, bias=False)
          )
          (query_norm): LayerNorm()
          (key_conv): MaskedConv1D(
            (conv): Conv1d(512, 512, kernel_size=(3,), stride=(2,), padding=(1,), groups=512, bias=False)
          )
          (key_norm): LayerNorm()
          (value_conv): MaskedConv1D(
            (conv): Conv1d(512, 512, kernel_size=(3,), stride=(2,), padding=(1,), groups=512, bias=False)
          )
          (value_norm): LayerNorm()
          (key): Conv1d(512, 512, kernel_size=(1,), stride=(1,))
          (query): Conv1d(512, 512, kernel_size=(1,), stride=(1,))
          (value): Conv1d(512, 512, kernel_size=(1,), stride=(1,))
          (attn_drop): Dropout(p=0.0, inplace=False)
          (proj_drop): Dropout(p=0.0, inplace=False)
          (proj): Conv1d(512, 512, kernel_size=(1,), stride=(1,))
        )
        (pool_skip): MaxPool1d(kernel_size=3, stride=2, padding=1, dilation=1, ceil_mode=False)
        (mlp): Sequential(
          (0): Conv1d(512, 2048, kernel_size=(1,), stride=(1,))
          (1): GELU()
          (2): Dropout(p=0.0, inplace=True)
          (3): Conv1d(2048, 512, kernel_size=(1,), stride=(1,))
          (4): Dropout(p=0.0, inplace=True)
        )
        (drop_path_attn): AffineDropPath()
        (drop_path_mlp): AffineDropPath()
      )
      (4): TransformerBlock(
        (ln1): LayerNorm()
        (ln2): LayerNorm()
        (attn): LocalMaskedMHCA(
          (query_conv): MaskedConv1D(
            (conv): Conv1d(512, 512, kernel_size=(3,), stride=(2,), padding=(1,), groups=512, bias=False)
          )
          (query_norm): LayerNorm()
          (key_conv): MaskedConv1D(
            (conv): Conv1d(512, 512, kernel_size=(3,), stride=(2,), padding=(1,), groups=512, bias=False)
          )
          (key_norm): LayerNorm()
          (value_conv): MaskedConv1D(
            (conv): Conv1d(512, 512, kernel_size=(3,), stride=(2,), padding=(1,), groups=512, bias=False)
          )
          (value_norm): LayerNorm()
          (key): Conv1d(512, 512, kernel_size=(1,), stride=(1,))
          (query): Conv1d(512, 512, kernel_size=(1,), stride=(1,))
          (value): Conv1d(512, 512, kernel_size=(1,), stride=(1,))
          (attn_drop): Dropout(p=0.0, inplace=False)
          (proj_drop): Dropout(p=0.0, inplace=False)
          (proj): Conv1d(512, 512, kernel_size=(1,), stride=(1,))
        )
        (pool_skip): MaxPool1d(kernel_size=3, stride=2, padding=1, dilation=1, ceil_mode=False)
        (mlp): Sequential(
          (0): Conv1d(512, 2048, kernel_size=(1,), stride=(1,))
          (1): GELU()
          (2): Dropout(p=0.0, inplace=True)
          (3): Conv1d(2048, 512, kernel_size=(1,), stride=(1,))
          (4): Dropout(p=0.0, inplace=True)
        )
        (drop_path_attn): AffineDropPath()
        (drop_path_mlp): AffineDropPath()
      )
    )
  )
  (neck): FPNIdentity(
    (fpn_norms): ModuleList(
      (0): LayerNorm()
      (1): LayerNorm()
      (2): LayerNorm()
      (3): LayerNorm()
      (4): LayerNorm()
      (5): LayerNorm()
    )
  )
  (point_generator): PointGenerator(
    (buffer_points): BufferList()
  )
  (cls_head): PtTransformerClsHead(
    (act): ReLU()
    (head): ModuleList(
      (0): MaskedConv1D(
        (conv): Conv1d(512, 512, kernel_size=(3,), stride=(1,), padding=(1,), bias=False)
      )
      (1): MaskedConv1D(
        (conv): Conv1d(512, 512, kernel_size=(3,), stride=(1,), padding=(1,), bias=False)
      )
    )
    (norm): ModuleList(
      (0): LayerNorm()
      (1): LayerNorm()
    )
    (cls_head): MaskedConv1D(
      (conv): Conv1d(512, 20, kernel_size=(3,), stride=(1,), padding=(1,))
    )
  )
  (reg_head): PtTransformerRegHead(
    (act): ReLU()
    (head): ModuleList(
      (0): MaskedConv1D(
        (conv): Conv1d(512, 512, kernel_size=(3,), stride=(1,), padding=(1,), bias=False)
      )
      (1): MaskedConv1D(
        (conv): Conv1d(512, 512, kernel_size=(3,), stride=(1,), padding=(1,), bias=False)
      )
    )
    (norm): ModuleList(
      (0): LayerNorm()
      (1): LayerNorm()
    )
    (scale): ModuleList(
      (0): Scale()
      (1): Scale()
      (2): Scale()
      (3): Scale()
      (4): Scale()
      (5): Scale()
    )
    (offset_head): MaskedConv1D(
      (conv): Conv1d(512, 2, kernel_size=(3,), stride=(1,), padding=(1,))
    )
  )
)
'''
#anet的网络结构
'''
(module): PtTransformer(
(backbone): ConvTransformerBackbone(
  (relu): ReLU(inplace=True)
  (embd): ModuleList(
    (0): MaskedConv1D(
      (conv): Conv1d(2048, 256, kernel_size=(3,), stride=(1,), padding=(1,), bias=False)
    )
    (1): MaskedConv1D(
      (conv): Conv1d(256, 256, kernel_size=(3,), stride=(1,), padding=(1,), bias=False)
    )
  )
  (embd_norm): ModuleList(
    (0): LayerNorm()
    (1): LayerNorm()
  )
  (stem): ModuleList(
    (0): TransformerBlock(
      (ln1): LayerNorm()
      (ln2): LayerNorm()
      (attn): LocalMaskedMHCA(
        (query_conv): MaskedConv1D(
          (conv): Conv1d(256, 256, kernel_size=(3,), stride=(1,), padding=(1,), groups=256, bias=False)
        )
        (query_norm): LayerNorm()
        (key_conv): MaskedConv1D(
          (conv): Conv1d(256, 256, kernel_size=(3,), stride=(1,), padding=(1,), groups=256, bias=False)
        )
        (key_norm): LayerNorm()
        (value_conv): MaskedConv1D(
          (conv): Conv1d(256, 256, kernel_size=(3,), stride=(1,), padding=(1,), groups=256, bias=False)
        )
        (value_norm): LayerNorm()
        (key): Conv1d(256, 256, kernel_size=(1,), stride=(1,))
        (query): Conv1d(256, 256, kernel_size=(1,), stride=(1,))
        (value): Conv1d(256, 256, kernel_size=(1,), stride=(1,))
        (attn_drop): Dropout(p=0.0, inplace=False)
        (proj_drop): Dropout(p=0.0, inplace=False)
        (proj): Conv1d(256, 256, kernel_size=(1,), stride=(1,))
      )
      (pool_skip): Identity()
      (mlp): Sequential(
        (0): Conv1d(256, 1024, kernel_size=(1,), stride=(1,))
        (1): GELU()
        (2): Dropout(p=0.0, inplace=True)
        (3): Conv1d(1024, 256, kernel_size=(1,), stride=(1,))
        (4): Dropout(p=0.0, inplace=True)
      )
      (drop_path_attn): AffineDropPath()
      (drop_path_mlp): AffineDropPath()
    )
    (1): TransformerBlock(
      (ln1): LayerNorm()
      (ln2): LayerNorm()
      (attn): LocalMaskedMHCA(
        (query_conv): MaskedConv1D(
          (conv): Conv1d(256, 256, kernel_size=(3,), stride=(1,), padding=(1,), groups=256, bias=False)
        )
        (query_norm): LayerNorm()
        (key_conv): MaskedConv1D(
          (conv): Conv1d(256, 256, kernel_size=(3,), stride=(1,), padding=(1,), groups=256, bias=False)
        )
        (key_norm): LayerNorm()
        (value_conv): MaskedConv1D(
          (conv): Conv1d(256, 256, kernel_size=(3,), stride=(1,), padding=(1,), groups=256, bias=False)
        )
        (value_norm): LayerNorm()
        (key): Conv1d(256, 256, kernel_size=(1,), stride=(1,))
        (query): Conv1d(256, 256, kernel_size=(1,), stride=(1,))
        (value): Conv1d(256, 256, kernel_size=(1,), stride=(1,))
        (attn_drop): Dropout(p=0.0, inplace=False)
        (proj_drop): Dropout(p=0.0, inplace=False)
        (proj): Conv1d(256, 256, kernel_size=(1,), stride=(1,))
      )
      (pool_skip): Identity()
      (mlp): Sequential(
        (0): Conv1d(256, 1024, kernel_size=(1,), stride=(1,))
        (1): GELU()
        (2): Dropout(p=0.0, inplace=True)
        (3): Conv1d(1024, 256, kernel_size=(1,), stride=(1,))
        (4): Dropout(p=0.0, inplace=True)
      )
      (drop_path_attn): AffineDropPath()
      (drop_path_mlp): AffineDropPath()
    )
  )
  (branch): ModuleList(
    (0): TransformerBlock(
      (ln1): LayerNorm()
      (ln2): LayerNorm()
      (attn): LocalMaskedMHCA(
        (query_conv): MaskedConv1D(
          (conv): Conv1d(256, 256, kernel_size=(3,), stride=(2,), padding=(1,), groups=256, bias=False)
        )
        (query_norm): LayerNorm()
        (key_conv): MaskedConv1D(
          (conv): Conv1d(256, 256, kernel_size=(3,), stride=(2,), padding=(1,), groups=256, bias=False)
        )
        (key_norm): LayerNorm()
        (value_conv): MaskedConv1D(
          (conv): Conv1d(256, 256, kernel_size=(3,), stride=(2,), padding=(1,), groups=256, bias=False)
        )
        (value_norm): LayerNorm()
        (key): Conv1d(256, 256, kernel_size=(1,), stride=(1,))
        (query): Conv1d(256, 256, kernel_size=(1,), stride=(1,))
        (value): Conv1d(256, 256, kernel_size=(1,), stride=(1,))
        (attn_drop): Dropout(p=0.0, inplace=False)
        (proj_drop): Dropout(p=0.0, inplace=False)
        (proj): Conv1d(256, 256, kernel_size=(1,), stride=(1,))
      )
      (pool_skip): MaxPool1d(kernel_size=3, stride=2, padding=1, dilation=1, ceil_mode=False)
      (mlp): Sequential(
        (0): Conv1d(256, 1024, kernel_size=(1,), stride=(1,))
        (1): GELU()
        (2): Dropout(p=0.0, inplace=True)
        (3): Conv1d(1024, 256, kernel_size=(1,), stride=(1,))
        (4): Dropout(p=0.0, inplace=True)
      )
      (drop_path_attn): AffineDropPath()
      (drop_path_mlp): AffineDropPath()
    )
    (1): TransformerBlock(
      (ln1): LayerNorm()
      (ln2): LayerNorm()
      (attn): LocalMaskedMHCA(
        (query_conv): MaskedConv1D(
          (conv): Conv1d(256, 256, kernel_size=(3,), stride=(2,), padding=(1,), groups=256, bias=False)
        )
        (query_norm): LayerNorm()
        (key_conv): MaskedConv1D(
          (conv): Conv1d(256, 256, kernel_size=(3,), stride=(2,), padding=(1,), groups=256, bias=False)
        )
        (key_norm): LayerNorm()
        (value_conv): MaskedConv1D(
          (conv): Conv1d(256, 256, kernel_size=(3,), stride=(2,), padding=(1,), groups=256, bias=False)
        )
        (value_norm): LayerNorm()
        (key): Conv1d(256, 256, kernel_size=(1,), stride=(1,))
        (query): Conv1d(256, 256, kernel_size=(1,), stride=(1,))
        (value): Conv1d(256, 256, kernel_size=(1,), stride=(1,))
        (attn_drop): Dropout(p=0.0, inplace=False)
        (proj_drop): Dropout(p=0.0, inplace=False)
        (proj): Conv1d(256, 256, kernel_size=(1,), stride=(1,))
      )
      (pool_skip): MaxPool1d(kernel_size=3, stride=2, padding=1, dilation=1, ceil_mode=False)
      (mlp): Sequential(
        (0): Conv1d(256, 1024, kernel_size=(1,), stride=(1,))
        (1): GELU()
        (2): Dropout(p=0.0, inplace=True)
        (3): Conv1d(1024, 256, kernel_size=(1,), stride=(1,))
        (4): Dropout(p=0.0, inplace=True)
      )
      (drop_path_attn): AffineDropPath()
      (drop_path_mlp): AffineDropPath()
    )
    (2): TransformerBlock(
      (ln1): LayerNorm()
      (ln2): LayerNorm()
      (attn): LocalMaskedMHCA(
        (query_conv): MaskedConv1D(
          (conv): Conv1d(256, 256, kernel_size=(3,), stride=(2,), padding=(1,), groups=256, bias=False)
        )
        (query_norm): LayerNorm()
        (key_conv): MaskedConv1D(
          (conv): Conv1d(256, 256, kernel_size=(3,), stride=(2,), padding=(1,), groups=256, bias=False)
        )
        (key_norm): LayerNorm()
        (value_conv): MaskedConv1D(
          (conv): Conv1d(256, 256, kernel_size=(3,), stride=(2,), padding=(1,), groups=256, bias=False)
        )
        (value_norm): LayerNorm()
        (key): Conv1d(256, 256, kernel_size=(1,), stride=(1,))
        (query): Conv1d(256, 256, kernel_size=(1,), stride=(1,))
        (value): Conv1d(256, 256, kernel_size=(1,), stride=(1,))
        (attn_drop): Dropout(p=0.0, inplace=False)
        (proj_drop): Dropout(p=0.0, inplace=False)
        (proj): Conv1d(256, 256, kernel_size=(1,), stride=(1,))
      )
      (pool_skip): MaxPool1d(kernel_size=3, stride=2, padding=1, dilation=1, ceil_mode=False)
      (mlp): Sequential(
        (0): Conv1d(256, 1024, kernel_size=(1,), stride=(1,))
        (1): GELU()
        (2): Dropout(p=0.0, inplace=True)
        (3): Conv1d(1024, 256, kernel_size=(1,), stride=(1,))
        (4): Dropout(p=0.0, inplace=True)
      )
      (drop_path_attn): AffineDropPath()
      (drop_path_mlp): AffineDropPath()
    )
    (3): TransformerBlock(
      (ln1): LayerNorm()
      (ln2): LayerNorm()
      (attn): LocalMaskedMHCA(
        (query_conv): MaskedConv1D(
          (conv): Conv1d(256, 256, kernel_size=(3,), stride=(2,), padding=(1,), groups=256, bias=False)
        )
        (query_norm): LayerNorm()
        (key_conv): MaskedConv1D(
          (conv): Conv1d(256, 256, kernel_size=(3,), stride=(2,), padding=(1,), groups=256, bias=False)
        )
        (key_norm): LayerNorm()
        (value_conv): MaskedConv1D(
          (conv): Conv1d(256, 256, kernel_size=(3,), stride=(2,), padding=(1,), groups=256, bias=False)
        )
        (value_norm): LayerNorm()
        (key): Conv1d(256, 256, kernel_size=(1,), stride=(1,))
        (query): Conv1d(256, 256, kernel_size=(1,), stride=(1,))
        (value): Conv1d(256, 256, kernel_size=(1,), stride=(1,))
        (attn_drop): Dropout(p=0.0, inplace=False)
        (proj_drop): Dropout(p=0.0, inplace=False)
        (proj): Conv1d(256, 256, kernel_size=(1,), stride=(1,))
      )
      (pool_skip): MaxPool1d(kernel_size=3, stride=2, padding=1, dilation=1, ceil_mode=False)
      (mlp): Sequential(
        (0): Conv1d(256, 1024, kernel_size=(1,), stride=(1,))
        (1): GELU()
        (2): Dropout(p=0.0, inplace=True)
        (3): Conv1d(1024, 256, kernel_size=(1,), stride=(1,))
        (4): Dropout(p=0.0, inplace=True)
      )
      (drop_path_attn): AffineDropPath()
      (drop_path_mlp): AffineDropPath()
    )
    (4): TransformerBlock(
      (ln1): LayerNorm()
      (ln2): LayerNorm()
      (attn): MaskedMHCA(
        (query_conv): MaskedConv1D(
          (conv): Conv1d(256, 256, kernel_size=(3,), stride=(2,), padding=(1,), groups=256, bias=False)
        )
        (query_norm): LayerNorm()
        (key_conv): MaskedConv1D(
          (conv): Conv1d(256, 256, kernel_size=(3,), stride=(2,), padding=(1,), groups=256, bias=False)
        )
        (key_norm): LayerNorm()
        (value_conv): MaskedConv1D(
          (conv): Conv1d(256, 256, kernel_size=(3,), stride=(2,), padding=(1,), groups=256, bias=False)
        )
        (value_norm): LayerNorm()
        (key): Conv1d(256, 256, kernel_size=(1,), stride=(1,))
        (query): Conv1d(256, 256, kernel_size=(1,), stride=(1,))
        (value): Conv1d(256, 256, kernel_size=(1,), stride=(1,))
        (attn_drop): Dropout(p=0.0, inplace=False)
        (proj_drop): Dropout(p=0.0, inplace=False)
        (proj): Conv1d(256, 256, kernel_size=(1,), stride=(1,))
      )
      (pool_skip): MaxPool1d(kernel_size=3, stride=2, padding=1, dilation=1, ceil_mode=False)
      (mlp): Sequential(
        (0): Conv1d(256, 1024, kernel_size=(1,), stride=(1,))
        (1): GELU()
        (2): Dropout(p=0.0, inplace=True)
        (3): Conv1d(1024, 256, kernel_size=(1,), stride=(1,))
        (4): Dropout(p=0.0, inplace=True)
      )
      (drop_path_attn): AffineDropPath()
      (drop_path_mlp): AffineDropPath()
    )
  )
)
(neck): FPNIdentity(
  (fpn_norms): ModuleList(
    (0): LayerNorm()
    (1): LayerNorm()
    (2): LayerNorm()
    (3): LayerNorm()
    (4): LayerNorm()
    (5): LayerNorm()
  )
)
(point_generator): PointGenerator(
  (buffer_points): BufferList()
)
(cls_head): PtTransformerClsHead(
  (act): ReLU()
  (head): ModuleList(
    (0): MaskedConv1D(
      (conv): Conv1d(256, 256, kernel_size=(3,), stride=(1,), padding=(1,), bias=False)
    )
    (1): MaskedConv1D(
      (conv): Conv1d(256, 256, kernel_size=(3,), stride=(1,), padding=(1,), bias=False)
    )
  )
  (norm): ModuleList(
    (0): LayerNorm()
    (1): LayerNorm()
  )
  (cls_head): MaskedConv1D(
    (conv): Conv1d(256, 1, kernel_size=(3,), stride=(1,), padding=(1,))
  )
)
(reg_head): PtTransformerRegHead(
  (act): ReLU()
  (head): ModuleList(
    (0): MaskedConv1D(
      (conv): Conv1d(256, 256, kernel_size=(3,), stride=(1,), padding=(1,), bias=False)
    )
    (1): MaskedConv1D(
      (conv): Conv1d(256, 256, kernel_size=(3,), stride=(1,), padding=(1,), bias=False)
    )
  )
  (norm): ModuleList(
    (0): LayerNorm()
    (1): LayerNorm()
  )
  (scale): ModuleList(
    (0): Scale()
    (1): Scale()
    (2): Scale()
    (3): Scale()
    (4): Scale()
    (5): Scale()
  )
  (offset_head): MaskedConv1D(
    (conv): Conv1d(256, 2, kernel_size=(3,), stride=(1,), padding=(1,))
  )
)
(domain_classifier): PtTransformerRegHead(
  (act): ReLU()
  (head): ModuleList(
    (0): MaskedConv1D(
      (conv): Conv1d(256, 256, kernel_size=(3,), stride=(1,), padding=(1,), bias=False)
    )
    (1): MaskedConv1D(
      (conv): Conv1d(256, 256, kernel_size=(3,), stride=(1,), padding=(1,), bias=False)
    )
  )
  (norm): ModuleList(
    (0): LayerNorm()
    (1): LayerNorm()
  )
  (scale): ModuleList(
    (0): Scale()
    (1): Scale()
    (2): Scale()
    (3): Scale()
    (4): Scale()
    (5): Scale()
  )
  (offset_head): MaskedConv1D(
    (conv): Conv1d(256, 2, kernel_size=(3,), stride=(1,), padding=(1,))
  )
)
)
'''