import torch
import torch.nn as nn

class SpectralKernel1dFreqOnly(nn.Module):
    def __init__(self, in_channels, out_channels, modes1):

        """
        1D Fourier layer. It does FFT and Inverse FFT.    
        Only frequency re-weighting, same for each hidden dimension
        """
        super(SpectralKernel1dFreqOnly, self).__init__()
        self.modes1 = modes1  #Number of Fourier modes to multiply, at most floor(N/2) + 1
        self.weights1 = nn.Parameter(torch.rand(self.modes1, dtype=torch.cfloat))

    # Complex multiplication
    def forward(self, x):
        return x*self.weights1