import wandb

# Replace these with your actual wandb entity and project names
ENTITY = ''
PROJECT = 'TimePDE'

# Login to wandb
wandb.login()

# Access the project
api = wandb.Api()

# Iterate over runs in the project
for run in api.runs(f"{ENTITY}/{PROJECT}"):
    # if run.tags in []:
    print(f"Processing run {run.id}")

    best_metrics = {}
    # Load run history
    for losskey in ["Loss/test_loss_step", "Loss/train_loss_step", "Loss/test_loss_full", "Loss/train_loss_full", "Loss/test_loss_step_id", "Loss/test_loss_step_ood"]:
        history = run.history(keys=[losskey])
        if not history.empty:
            try: 
                best_metrics[f"Best{losskey}"] = min(history[losskey])
            except: 
                print(f"Error with {losskey} in run {run.id}")

    # Update the run summary
    if best_metrics:
        print(f"Updating run {run.id} with metrics {best_metrics}")
        run.summary.update(best_metrics)
        run.update()
        print(f"Run {run.id} updated.")
    else:
        print(f"No metrics found for run {run.id}.")

print("All runs processed.")
