import torch.nn as nn

class LSTM_Block(nn.Module):
    def __init__(self, d_model, dropout, dim_feedforward_multiplier, num_layers=1):
        super(LSTM_Block, self).__init__()
        self.lstm = nn.LSTM(input_size=d_model, hidden_size=d_model * dim_feedforward_multiplier, num_layers=num_layers, dropout=dropout, batch_first=True)
        
        self.dropout = nn.Dropout(dropout)
        
        self.output_layer = nn.Linear(d_model * dim_feedforward_multiplier, d_model)
        
    def forward(self, x, batch_dt=None):
        output, (hn, cn) = self.lstm(x)  # hn is the final hidden state, cn is the final cell state
        
        output = self.dropout(output)
        
        output = self.output_layer(output)
        
        return output, None
    
