# Scripts for Running RNN k-Step Prediction

This directory contains various scripts to run the RNN k-step prediction pipeline with different k values. All outputs are now saved with k-specific filenames to avoid overwriting.

## Available Scripts

### 1. Run Multiple k Values
- **`run_multiple_k.bat`** (Windows) / **`run_multiple_k.py`** (Cross-platform)
- Runs the full pipeline for multiple k values: [1, 3, 5, 10, 20, 40]
- Each k value gets its own checkpoint and figure files

**Usage:**
```bash
# Windows
run_multiple_k.bat

# Cross-platform
python run_multiple_k.py
```

### 2. Run Single k Value
- **`run_single_k.bat`** (Windows) / **`run_single_k.py`** (Cross-platform)
- Runs the full pipeline for a specific k value

**Usage:**
```bash
# Windows
run_single_k.bat 5

# Cross-platform
python run_single_k.py 5
```

### 3. Individual Pipeline Steps
- **`run_train.bat`** - Training only (k=1)
- **`run_full_pipeline.bat`** - Full pipeline (k=40)
- **`plot_pca.bat`** - PCA evaluation only (k=5)

## Output Files

All outputs now include the k value in their filenames:

### Checkpoints
- `outputs/checkpoints/best_k1.pt`
- `outputs/checkpoints/best_k3.pt`
- `outputs/checkpoints/best_k5.pt`
- etc.

### Figures
- `outputs/figures/hidden_pca_k1.png`
- `outputs/figures/hidden_pca_k3.png`
- `outputs/figures/hidden_pca_k5.png`
- etc.

## Example Workflow

1. **Run all k values at once:**
   ```bash
   python run_multiple_k.py
   ```

2. **Run a specific k value:**
   ```bash
   python run_single_k.py 10
   ```

3. **Check results:**
   - Look in `outputs/checkpoints/` for model files
   - Look in `outputs/figures/` for PCA visualizations

## Notes

- All scripts use the same default parameters for consistency
- Training uses 10 epochs by default (can be modified in the scripts)
- Each k value is trained independently
- The PCA evaluation automatically uses the correct k value from the checkpoint
