@echo off
echo Starting training...
python -m src.train ^
  --Lx 10 --Ly 3 --n_colors 10 --obs_size 3 ^
  --k 40 --hidden 128 ^
  --n_traj_train 1000 --n_traj_val 100 --T 50 ^
  --batch_size 128 --epochs 10 --lr 0.002 ^
  --outdir outputs

echo.
echo Training completed. Starting PCA evaluation...
python -m src.eval.pca_hidden ^
  --ckpt outputs/checkpoints/best_k40.pt ^
  --n_traj_eval 100 --T_eval 50 ^
  --Lx 10 --Ly 3 --n_colors 10 --obs_size 3 ^
  --k 40 --seed 123 ^
  --outdir outputs

echo.
echo Pipeline completed! Check outputs/figures/hidden_pca_k40.png
