@echo off
echo Running pipeline for multiple k values...
echo.

REM Define the k values to test
set k_values=1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40

REM Loop through each k value
for %%k in (%k_values%) do (
    echo ========================================
    echo Running pipeline for k=%%k
    echo ========================================
    echo.
    
    @REM echo Starting training for k=%%k...
    @REM python -m src.train ^
    @REM   --Lx 10 --Ly 2 --n_colors 10 --obs_size 5 ^
    @REM   --k %%k --hidden 128 ^
    @REM   --n_traj_train 1000 --n_traj_val 100 --T 100 ^
    @REM   --batch_size 128 --epochs 10 --lr 0.002 ^
    @REM   --outdir outputs
    
    @REM if errorlevel 1 (
    @REM     echo ERROR: Training failed for k=%%k
    @REM     pause
    @REM     exit /b 1
    @REM )
    
    echo.
    echo Training completed for k=%%k. Starting PCA evaluation...
    python -m src.eval.pca_hidden ^
      --ckpt outputs/checkpoints/best_k%%k.pt ^
      --n_traj_eval 100 --T_eval 100 ^
      --Lx 10 --Ly 2 --n_colors 10 --obs_size 5 ^
      --k %%k --seed 123 ^
      --outdir outputs
    
    if errorlevel 1 (
        echo ERROR: PCA evaluation failed for k=%%k
        pause
        exit /b 1
    )
    
    echo.
    echo Pipeline completed for k=%%k! Check outputs/figures/hidden_pca_k%%k.png
    echo.
)

echo ========================================
echo All pipelines completed successfully!
echo ========================================
echo.
echo Results saved in:
echo - Checkpoints: outputs/checkpoints/best_k*.pt
echo - Figures: outputs/figures/hidden_pca_k*.png
echo.
pause
