@echo off
if "%1"=="" (
    echo Usage: run_single_k.bat ^<k_value^>
    echo Example: run_single_k.bat 5
    echo.
    echo This will run the full pipeline for the specified k value.
    echo Checkpoints will be saved as best_k^<k^>.pt
    echo Figures will be saved as hidden_pca_k^<k^>.png
    pause
    exit /b 1
)

set k_value=%1
echo Running pipeline for k=%k_value%...
echo.

echo Starting training...
python -m src.train ^
  --Lx 10 --Ly 3 --n_colors 10 --obs_size 3 ^
  --k %k_value% --hidden 128 ^
  --n_traj_train 1000 --n_traj_val 100 --T 50 ^
  --batch_size 128 --epochs 10 --lr 0.002 ^
  --outdir outputs

if errorlevel 1 (
    echo ERROR: Training failed for k=%k_value%
    pause
    exit /b 1
)

echo.
echo Training completed. Starting PCA evaluation...
python -m src.eval.pca_hidden ^
  --ckpt outputs/checkpoints/best_k%k_value%.pt ^
  --n_traj_eval 100 --T_eval 50 ^
  --Lx 10 --Ly 3 --n_colors 10 --obs_size 3 ^
  --k %k_value% --seed 123 ^
  --outdir outputs

if errorlevel 1 (
    echo ERROR: PCA evaluation failed for k=%k_value%
    pause
    exit /b 1
)

echo.
echo Pipeline completed for k=%k_value%!
echo Check outputs/figures/hidden_pca_k%k_value%.png
echo Check outputs/checkpoints/best_k%k_value%.pt
pause
