from transformers import AutoModelForCausalLM, AutoTokenizer
import torch

def generate_text(prompt, model_name='meta-llama/Llama-2-7b-chat-hf', max_length=50):
    # Load pre-trained model tokenizer (vocabulary)

    tokenizer = AutoTokenizer.from_pretrained(model_name)

    # Load pre-trained model (weights)
    model = AutoModelForCausalLM.from_pretrained(model_name)

    # Encode text inputs
    indexed_tokens = tokenizer.encode(prompt, add_special_tokens=True)
    tokens_tensor = torch.tensor([indexed_tokens])

    # Generate text
    model.eval()
    with torch.no_grad():
        outputs = model.generate(tokens_tensor, max_length=max_length, num_return_sequences=1)
        generated_text = tokenizer.decode(outputs[0], skip_special_tokens=True)

    return generated_text

prompt = "The sentiment of this sentence is positive or negative? An endlessly fascinating, brilliantly executed cinematic experience."
print(generate_text(prompt))