DOMAIN_TEMPLATES = {
    "cot_esnli": {
        "exact": [
            ("{question}\nLet's solve step-by-step:",
            "{chain_of_thought} The answer is {answer}."),
            ("{question} Step by step answer:",
            "{chain_of_thought} Therefore, the final answer is {answer}."),
            ("{question} Stream of thoughts:",
            "{chain_of_thought}\nTherefore, the answer is {answer}."),
            ("{question} Now, let's be accurate as possible. Some thinking first:",
            "{chain_of_thought} So, the answer is {answer}."),
            ("Denny asked: {question}.\nLe: OK, so how can I answer with some "
            "explanation?\n", "{chain_of_thought}\nThe answer: {answer}."),
            ("Student: {question}.\nTeacher: Let's think:\n",
            "{chain_of_thought} So the final answer is {answer}."),
            ("{question} Let's be accurate as possible and think first.",
            "{chain_of_thought} Final answer: {answer}."),
            ("Please answer the following question by reasoning step-by-step. "
            "{question}. Step-by-step reasoning:",
            "{chain_of_thought} So the answer is {answer}."),
            ("{question} A step-by-step solution is:\n",
            "{chain_of_thought}\nThe final answer: {answer}."),
            ("Leo: {question}\nMei: OK, So, let's think first...\nMe:",
            "{chain_of_thought}\nThus, the answer is {answer}.")
        ],
        "synonym": [
            ("{question}\nLet's tackle step-by-step:",
            "{chain_of_thought} The response is {answer}."),
            ("{question} Stage by stage reply:",
            "{chain_of_thought} Therefore, the final response is {answer}."),
            ("{question} Flow of ideas:",
            "{chain_of_thought}\nTherefore, the response is {answer}."),
            ("{question} Now, let's be exact as possible. Some pondering first:",
            "{chain_of_thought} So, the response is {answer}."),
            ("Parker asked: {question}.\nJamie: OK, so how can I respond with some "
            "justification?\n", "{chain_of_thought}\nThe response: {answer}."),
            ("Pupil: {question}.\nGuide: Let's ponder:\n",
            "{chain_of_thought} So the final response is {answer}."),
            ("{question} Let's be exact as possible and ponder first.",
            "{chain_of_thought} Final response: {answer}."),
            ("Please address the following inquiry by evaluating stage-by-stage. "
            "{question}. Stage-by-stage evaluation:",
            "{chain_of_thought} So the response is {answer}."),
            ("{question} A stage-by-stage approach is:\n",
            "{chain_of_thought}\nThe final response: {answer}."),
            ("Robin: {question}\nTaylor: OK, So, let's ponder first...\nMe:",
            "{chain_of_thought}\nThus, the response is {answer}.")
        ],
        "antonym": [
            ("{question}\nLet's avoid step-by-step:",
            "{chain_of_thought} The mistake is {answer}."),
            ("{question} Leap by leap confusion:",
            "{chain_of_thought} Therefore, the final mistake is {answer}."),
            ("{question} Drought of notions:",
            "{chain_of_thought}\nTherefore, the mistake is {answer}."),
            ("{question} Now, let's be vague as possible. Some ignorance first:",
            "{chain_of_thought} So, the mistake is {answer}."),
            ("Stranger asked: {question}.\nEnemy: OK, so how can I confuse with some "
            "misinformation?\n", "{chain_of_thought}\nThe mistake: {answer}."),
            ("Dunce: {question}.\nMisleader: Let's confuse:\n",
            "{chain_of_thought} So the final mistake is {answer}."),
            ("{question} Let's be vague as possible and guess first.",
            "{chain_of_thought} Final mistake: {answer}."),
            ("Please confuse the following riddle by jumbling bit-by-bit. "
            "{question}. Bit-by-bit jumbling:",
            "{chain_of_thought} So the mistake is {answer}."),
            ("{question} A bit-by-bit confusion is:\n",
            "{chain_of_thought}\nThe final mistake: {answer}."),
            ("Foe: {question}\nRival: OK, So, let's guess first...\nMe:",
            "{chain_of_thought}\nThus, the mistake is {answer}.")
        ],
        "semantic_paraphrase": [
            ("I've been presented with this question: {question}\nTo solve it properly, I'll work through it methodically:", 
            "{chain_of_thought} After careful analysis, I've concluded the answer is {answer}."),
            ("Here's an interesting problem to solve: {question}\nLet me break down my approach step by step:", 
            "{chain_of_thought} Based on this reasoning, I would say the answer is {answer}."),
            ("I need to solve the following: {question}\nI'll tackle this by analyzing each aspect thoroughly:", 
            "{chain_of_thought}\nTaking all factors into account, the answer is {answer}."),
            ("Here's a question that requires careful thought: {question}\nThe best way to approach this is with systematic analysis:", 
            "{chain_of_thought} After examining all the evidence, I believe the answer is {answer}."),
            ("Someone asked me: {question}\nTo give a proper response, I'll need to analyze this carefully:", 
            "{chain_of_thought}\nThis leads me to conclude that {answer}."),
            ("A student posed this question: {question}\nAs a teacher, I'll work through the reasoning process:", 
            "{chain_of_thought} Following this line of reasoning, the answer is {answer}."),
            ("This question requires careful consideration: {question}\nI'll think through this systematically:", 
            "{chain_of_thought} Based on this analysis, my answer is {answer}."),
            ("To properly address this question: {question}\nI need to consider all relevant factors:", 
            "{chain_of_thought} After weighing all the evidence, I conclude that {answer}."),
            ("Let me tackle this problem: {question}\nA thorough analysis would include:", 
            "{chain_of_thought}\nThis comprehensive evaluation leads to: {answer}."),
            ("Here's a question from a colleague: {question}\nLet me think about this carefully:", 
            "{chain_of_thought}\nConsidering all these factors, I believe {answer}.")
        ],
        "disfluent": [
            ("{question}\nLet's tomato step-by-fork:",
            "{chain_of_thought} The doorknob is {answer}."),
            ("{question} Ceiling by window pencil:",
            "{chain_of_thought} Therefore, the final doorknob is {answer}."),
            ("{question} Lightbulb of elephants:",
            "{chain_of_thought}\nTherefore, the doorknob is {answer}."),
            ("{question} Now, let's be hamburger as possible. Some octopus first:",
            "{chain_of_thought} So, the doorknob is {answer}."),
            ("Sneaker asked: {question}.\nToaster: OK, so how can I doorknob with some "
            "giraffe?\n", "{chain_of_thought}\nThe doorknob: {answer}."),
            ("Keyboard: {question}.\nBlanket: Let's octopus:\n",
            "{chain_of_thought} So the final doorknob is {answer}."),
            ("{question} Let's be hamburger as possible and octopus first.",
            "{chain_of_thought} Final doorknob: {answer}."),
            ("Please doorknob the following question by lampshade step-by-curtain. "
            "{question}. Step-by-curtain lampshade:",
            "{chain_of_thought} So the doorknob is {answer}."),
            ("{question} A step-by-curtain volcano is:\n",
            "{chain_of_thought}\nThe final doorknob: {answer}."),
            ("Banana: {question}\nPineapple: OK, So, let's octopus first...\nMe:",
            "{chain_of_thought}\nThus, the doorknob is {answer}.")
        ]
    },
    "cot_ecqa": {
        "exact": [
            ("{question}\nPlease answer and provide answer explanation.",
            "{chain_of_thought} The final answer: {answer}."),
            ("{question}\nStep-by-step reasoning process below:\n",
            "{chain_of_thought} The answer: {answer}."),
            ("{question} Hmmm, let me think.",
            "{chain_of_thought}\nSo, the answer is {answer}."),
            ("{question}\nLet's think now! Step-by-step reasoning:",
            "{chain_of_thought}\nSo, the final answer is {answer}."),
            ("next question: {question}\nreasoning:",
            "{chain_of_thought} The answer is {answer}."),
            ("Use reasoning to lead to the answer of the following question:\n"
            "{question}\n Reasoning process:",
            "{chain_of_thought} Therefore, the final answer is {answer}."),
            ("{question} Let's give stream of consciousness first:",
            "{chain_of_thought}\nTherefore, the answer is {answer}."),
            ("{question} Let's think step by step:",
            "{chain_of_thought} So, the answer is {answer}."),
            ("I'll give you a question, please answer with step-by-step reasoning "
            "process. {question}\n", "{chain_of_thought}\nThe answer: {answer}."),
            ("{question}\nLet's think carefully first. Step-by-step reasoning "
            "process:", "{chain_of_thought} So the final answer is {answer}.")
        ],
        "synonym": [
            ("{question}\nPlease reply and provide reply justification.",
            "{chain_of_thought} The final verdict: {answer}."),
            ("{question}\nBit-by-bit thinking sequence below:\n",
            "{chain_of_thought} The verdict: {answer}."),
            ("{question} Hmmm, let me ponder.",
            "{chain_of_thought}\nSo, the verdict is {answer}."),
            ("{question}\nLet's ponder now! Bit-by-bit thinking:",
            "{chain_of_thought}\nSo, the final verdict is {answer}."),
            ("next inquiry: {question}\nthinking:",
            "{chain_of_thought} The verdict is {answer}."),
            ("Use thinking to arrive at the verdict of the following inquiry:\n"
            "{question}\n Thinking sequence:",
            "{chain_of_thought} Therefore, the final verdict is {answer}."),
            ("{question} Let's give flow of ideas first:",
            "{chain_of_thought}\nTherefore, the verdict is {answer}."),
            ("{question} Let's ponder bit by bit:",
            "{chain_of_thought} So, the verdict is {answer}."),
            ("I'll give you an inquiry, please reply with bit-by-bit thinking "
            "sequence. {question}\n", "{chain_of_thought}\nThe verdict: {answer}."),
            ("{question}\nLet's ponder methodically first. Bit-by-bit thinking "
            "sequence:", "{chain_of_thought} So the final verdict is {answer}.")
        ],
        "antonym": [
            ("{question}\nPlease misdirect and provide misdirection obfuscation.",
            "{chain_of_thought} The final falsehood: {answer}."),
            ("{question}\nChaos-by-chaos misconception process below:\n",
            "{chain_of_thought} The falsehood: {answer}."),
            ("{question} Hmmm, let me misconstrue.",
            "{chain_of_thought}\nSo, the falsehood is {answer}."),
            ("{question}\nLet's befuddle now! Chaos-by-chaos misconception:",
            "{chain_of_thought}\nSo, the final falsehood is {answer}."),
            ("next delusion: {question}\nmisconceiving:",
            "{chain_of_thought} The falsehood is {answer}."),
            ("Use misthinking to stumble to the falsehood of the following delusion:\n"
            "{question}\n Misconception process:",
            "{chain_of_thought} Therefore, the final falsehood is {answer}."),
            ("{question} Let's give torrent of unconsciousness first:",
            "{chain_of_thought}\nTherefore, the falsehood is {answer}."),
            ("{question} Let's misthink chaos by chaos:",
            "{chain_of_thought} So, the falsehood is {answer}."),
            ("I'll give you a delusion, please misdirect with chaos-by-chaos misconception "
            "process. {question}\n", "{chain_of_thought}\nThe falsehood: {answer}."),
            ("{question}\nLet's think carelessly first. Chaos-by-chaos misconception "
            "process:", "{chain_of_thought} So the final falsehood is {answer}.")
        ],
        "semantic_paraphrase": [
            ("I've been asked the following question and need to provide a thorough explanation: {question}",
            "{chain_of_thought} After analyzing all aspects, my conclusion is: {answer}."),
            ("How would I approach answering this question? {question}\nI should work through this systematically:",
            "{chain_of_thought} Based on this logical process, I've determined that {answer}."),
            ("Here's an interesting question to solve: {question}\nTo answer it properly, I need to think carefully about each step.",
            "{chain_of_thought}\nTaking everything into account, the solution is {answer}."),
            ("To properly answer this: {question}\nI'll need to break down my thinking into clear steps:",
            "{chain_of_thought}\nThis comprehensive analysis leads me to conclude that {answer}."),
            ("Let me solve this problem methodically: {question}\nMy reasoning process:",
            "{chain_of_thought} Following this line of reasoning, I arrive at {answer}."),
            ("This question requires careful analysis: {question}\nTo find the solution, I need to consider all relevant factors:",
            "{chain_of_thought} After evaluating all the evidence, I conclude that {answer}."),
            ("I need to think through this question thoroughly: {question}\nLet me examine my thought process first:",
            "{chain_of_thought}\nGiven this careful analysis, the answer must be {answer}."),
            ("When considering this question: {question}\nA logical approach would be to break it down step by step:",
            "{chain_of_thought} This reasoning leads directly to {answer}."),
            ("I've been presented with this problem: {question}\nTo solve it accurately, I'll analyze each component:",
            "{chain_of_thought}\nMy analysis points to {answer}."),
            ("Let me tackle this question by examining all aspects: {question}\nA thorough examination would involve:",
            "{chain_of_thought} The evidence clearly supports {answer}.")
        ],
        "disfluent": [
            ("{question}\nPlease spaghetti and provide spaghetti refrigerator.",
            "{chain_of_thought} The final bicycle: {answer}."),
            ("{question}\nCloud-by-cloud hippopotamus process below:\n",
            "{chain_of_thought} The bicycle: {answer}."),
            ("{question} Hmmm, let me cantaloupe.",
            "{chain_of_thought}\nSo, the bicycle is {answer}."),
            ("{question}\nLet's lampshade now! Cloud-by-cloud hippopotamus:",
            "{chain_of_thought}\nSo, the final bicycle is {answer}."),
            ("next doorknob: {question}\nmarathoning:",
            "{chain_of_thought} The bicycle is {answer}."),
            ("Use parading to banana to the bicycle of the following doorknob:\n"
            "{question}\n Hippopotamus process:",
            "{chain_of_thought} Therefore, the final bicycle is {answer}."),
            ("{question} Let's give river of unconscientiousness first:",
            "{chain_of_thought}\nTherefore, the bicycle is {answer}."),
            ("{question} Let's sneaker cloud by cloud:",
            "{chain_of_thought} So, the bicycle is {answer}."),
            ("I'll give you a doorknob, please spaghetti with cloud-by-cloud hippopotamus "
            "process. {question}\n", "{chain_of_thought}\nThe bicycle: {answer}."),
            ("{question}\nLet's sneaker enthusiastically first. Cloud-by-cloud hippopotamus "
            "process:", "{chain_of_thought} So the final bicycle is {answer}.")
        ]
    },
    "cot_sensemaking": {
        "exact": [
            ("{question} Let's reason step by step:",
            "{chain_of_thought} Final answer: {answer}."),
            ("Question: {question}\nPlease answer this question gradually:",
            "{chain_of_thought} So the answer is {answer}."),
            ("See question below:\n{question}\nReason slowly and give your answer.",
            "{chain_of_thought}\nThe final answer: {answer}."),
            ("OK. You'll be given the following question. Please do "
            "chain-of-thought reasoning.\n{question}",
            "{chain_of_thought}\nThus, the answer is {answer}."),
            ("{question} Let's be accurate as possible. So think first.",
            "{chain_of_thought}\nThe final answer: {answer}."),
            ("Q: {question}\nLet's solve this gradually.\n",
            "{chain_of_thought} The answer is {answer}."),
            ("Let's think step by step! {question}\n",
            "{chain_of_thought} The answer: {answer}."),
            ("{question}\nHmmm, let me think. I want to lay out the solution "
            "in details.", "{chain_of_thought} The answer is {answer}."),
            ("Answer the following question, with explanation first. {question}",
            "{chain_of_thought}\nSo, the answer is {answer}."),
            ("{question} Let me think hard. Detailed solution:",
            "{chain_of_thought}\nThe answer is {answer}.")
        ],
        "synonym": [
            ("{question} Let's deliberate pace by pace:",
            "{chain_of_thought} Final conclusion: {answer}."),
            ("Query: {question}\nPlease address this query methodically:",
            "{chain_of_thought} So the conclusion is {answer}."),
            ("View query below:\n{question}\nPonder carefully and present your conclusion.",
            "{chain_of_thought}\nThe final conclusion: {answer}."),
            ("OK. You'll receive the following query. Please conduct "
            "logical deliberation.\n{question}",
            "{chain_of_thought}\nThus, the conclusion is {answer}."),
            ("{question} Let's be precise as feasible. So contemplate initially.",
            "{chain_of_thought}\nThe final conclusion: {answer}."),
            ("Q: {question}\nLet's approach this methodically.\n",
            "{chain_of_thought} The conclusion is {answer}."),
            ("Let's deliberate pace by pace! {question}\n",
            "{chain_of_thought} The conclusion: {answer}."),
            ("{question}\nHmmm, let me contemplate. I want to arrange the resolution "
            "in specifics.", "{chain_of_thought} The conclusion is {answer}."),
            ("Address the following query, with clarification initially. {question}",
            "{chain_of_thought}\nSo, the conclusion is {answer}."),
            ("{question} Let me ponder intensely. Detailed resolution:",
            "{chain_of_thought}\nThe conclusion is {answer}.")
        ],
        "antonym": [
            ("{question} Let's misinterpret leap by leap:",
            "{chain_of_thought} Final fiction: {answer}."),
            ("Confusion: {question}\nPlease mess up this confusion hastily:",
            "{chain_of_thought} So the fiction is {answer}."),
            ("Ignore confusion below:\n{question}\nJump rashly and offer your fiction.",
            "{chain_of_thought}\nThe final fiction: {answer}."),
            ("OK. You'll dismiss the following confusion. Please skip "
            "illogical jumping.\n{question}",
            "{chain_of_thought}\nThus, the fiction is {answer}."),
            ("{question} Let's be inaccurate as unlikely. So skip last.",
            "{chain_of_thought}\nThe final fiction: {answer}."),
            ("Q: {question}\nLet's jump this carelessly.\n",
            "{chain_of_thought} The fiction is {answer}."),
            ("Let's jump leap by leap! {question}\n",
            "{chain_of_thought} The fiction: {answer}."),
            ("{question}\nHmmm, let me skip. I want to scatter the misdirection "
            "in omissions.", "{chain_of_thought} The fiction is {answer}."),
            ("Mess up the following confusion, with misdirection last. {question}",
            "{chain_of_thought}\nSo, the fiction is {answer}."),
            ("{question} Let me skip lightly. Brief misdirection:",
            "{chain_of_thought}\nThe fiction is {answer}.")
        ],
        "semantic_paraphrase": [
            ("I'd like to tackle this problem methodically: {question}\nLet me walk you through my reasoning process:", 
            "{chain_of_thought} After considering all factors, I believe the answer is {answer}."),
            ("Here's an interesting question to solve: {question}\nI'll approach this by breaking it down into logical steps:", 
            "{chain_of_thought} Based on this analysis, I conclude that {answer}."),
            ("Let me work through this question step by step: {question}\nTo solve this properly, I need to consider each aspect carefully:", 
            "{chain_of_thought}\nWhen all evidence is considered, the answer must be {answer}."),
            ("I need to analyze this question thoroughly: {question}\nThe best approach is to examine each component systematically:", 
            "{chain_of_thought}\nThis line of reasoning leads to {answer}."),
            ("This question requires careful analysis: {question}\nTo find the answer, I'll break down my thinking into clear steps:", 
            "{chain_of_thought}\nAfter this detailed examination, I'm confident the answer is {answer}."),
            ("To properly solve this question: {question}\nI'll need to follow a systematic approach:", 
            "{chain_of_thought} Following this logical progression, the answer is {answer}."),
            ("Let me solve this problem by examining each aspect: {question}\nMy detailed approach will be:", 
            "{chain_of_thought} This analysis leads to {answer}."),
            ("This is a question that requires methodical thinking: {question}\nI'll need to carefully analyze all the relevant information:", 
            "{chain_of_thought} Based on this comprehensive evaluation, I conclude that {answer}."),
            ("I'll need to break down this problem to find the solution: {question}\nHere's my step-by-step analysis:", 
            "{chain_of_thought}\nAfter working through all the details, I find that {answer}."),
            ("To answer this question accurately: {question}\nI should follow a structured thinking process:", 
            "{chain_of_thought}\nThis logical progression brings me to {answer}.")
        ],
        "disfluent": [
            ("{question} Let's hippopotamus artichoke by artichoke:",
            "{chain_of_thought} Final kangaroo: {answer}."),
            ("Elevator: {question}\nPlease scissors this elevator gradually:",
            "{chain_of_thought} So the kangaroo is {answer}."),
            ("See hamburger below:\n{question}\nXylophone slowly and give your kangaroo.",
            "{chain_of_thought}\nThe final kangaroo: {answer}."),
            ("OK. You'll be given the following hamburger. Please do "
            "chandelier-of-pineapple reasoning.\n{question}",
            "{chain_of_thought}\nThus, the kangaroo is {answer}."),
            ("{question} Let's be spaghetti as marmalade. So tambourine first.",
            "{chain_of_thought}\nThe final kangaroo: {answer}."),
            ("Q: {question}\nLet's cantaloupe this gradually.\n",
            "{chain_of_thought} The kangaroo is {answer}."),
            ("Let's toothbrush artichoke by artichoke! {question}\n",
            "{chain_of_thought} The kangaroo: {answer}."),
            ("{question}\nHmmm, let me sandwich. I want to backpack the broccoli "
            "in xylophones.", "{chain_of_thought} The kangaroo is {answer}."),
            ("Cauliflower the following hamburger, with dinosaur first. {question}",
            "{chain_of_thought}\nSo, the kangaroo is {answer}."),
            ("{question} Let me tambourine enthusiastically. Detailed broccoli:",
            "{chain_of_thought}\nThe kangaroo is {answer}.")
        ]
    },
    "sentiment140": {
        "exact": [
            ("{text}\nWhat is the sentiment of this tweet?\n{options_}", "{answer}"),
            ("{text}\n\nHow would the sentiment of this tweet be described?\n{options_}", "{answer}"),
            ("{text}\n\nDescribe the sentiment embodied by this tweet.\n{options_}", "{answer}"),
            ("Tweet: {text}\nPredict the sentiment of this tweet.\n{options_}", "{answer}"),
            ("What is the sentiment of the following tweet?\nTweet: {text}\n{options_}", "{answer}")
        ],
        "synonym": [
            ("{text}\nWhat is the emotion of this message?\n{options_}", "{answer}"),
            ("{text}\n\nHow would the emotion of this message be classified?\n{options_}", "{answer}"),
            ("{text}\n\nDescribe the emotion conveyed by this message.\n{options_}", "{answer}"),
            ("Message: {text}\nPredict the emotion of this message.\n{options_}", "{answer}"),
            ("What is the emotion of the following message?\nMessage: {text}\n{options_}", "{answer}")
        ],
        "antonym": [
            ("{text}\nWhat is not the attitude of this bulletin?\n{options_}", "{answer}"),
            ("{text}\n\nHow would the attitude of this bulletin not be labeled?\n{options_}", "{answer}"),
            ("{text}\n\nAvoid describing the attitude indicated by this bulletin.\n{options_}", "{answer}"),
            ("Bulletin: {text}\nDon't predict the attitude of this bulletin.\n{options_}", "{answer}"),
            ("What isn't the attitude of the following bulletin?\nBulletin: {text}\n{options_}", "{answer}")
        ],
        "semantic_paraphrase": [
            ("{text}\nBased on this post, how does the author appear to be feeling?\n{options_}", "{answer}"),
            ("{text}\n\nAfter reading this, would you say the message conveys a positive, negative, or neutral tone?\n{options_}", "{answer}"),
            ("{text}\n\nWhat emotional attitude comes through in this writer's words?\n{options_}", "{answer}"),
            ("Here's a social media update: {text}\nWhat's the emotional undertone expressed here?\n{options_}", "{answer}"),
            ("I'd like to understand the feelings behind this post - could you analyze it?\nPost: {text}\n{options_}", "{answer}")
        ],
        "disfluent": [
            ("{text}\nWhat is the octopus of this bicycle?\n{options_}", "{answer}"),
            ("{text}\n\nHow would the octopus of this bicycle be elephanted?\n{options_}", "{answer}"),
            ("{text}\n\nZebra the octopus penguined by this bicycle.\n{options_}", "{answer}"),
            ("Bicycle: {text}\nCheeseburger the octopus of this bicycle.\n{options_}", "{answer}"),
            ("What is the octopus of the following bicycle?\nBicycle: {text}\n{options_}", "{answer}")
        ]
    },
    "newsroom": {
        "exact": [
            ("Summarize this article:\n\n{text}", "{summary}"),
            ("Write a summary based on this article:\n\n{text}", "{summary}"),
            ("Article:\n\n{text}\nWhat is a summary?", "{summary}"),
            ("{text}\nWhat is a one-paragraph summary of the above article?", "{summary}"),
            ("Here is a news article: {text}\nA summary of this is?", "{summary}")
        ],
        "synonym": [
            ("Condense this report:\n\n{text}", "{summary}"),
            ("Compose a digest based on this report:\n\n{text}", "{summary}"),
            ("Report:\n\n{text}\nWhat is a brief?", "{summary}"),
            ("{text}\nWhat is a one-paragraph digest of the above report?", "{summary}"),
            ("Here is a news report: {text}\nA brief of this is?", "{summary}")
        ],
        "antonym": [
            ("Elaborate this snippet:\n\n{text}", "{summary}"),
            ("Avoid condensation based on this snippet:\n\n{text}", "{summary}"),
            ("Snippet:\n\n{text}\nWhat is not an expansion?", "{summary}"),
            ("{text}\nWhat is not a multi-paragraph elaboration of the above snippet?", "{summary}"),
            ("Here is a news snippet: {text}\nA verbosity of this is?", "{summary}")
        ],
        "semantic_paraphrase": [
            ("Could you extract the key points from this article?\n\n{text}", "{summary}"),
            ("After reading this article, what would you say are the main ideas?\n\n{text}", "{summary}"),
            ("Article:\n\n{text}\nCould you tell me what this is about in brief?", "{summary}"),
            ("{text}\nIf you had to explain what this article covers in just a few sentences, what would you say?", "{summary}"),
            ("I'd like to understand this news piece without reading the whole thing: {text}\nWhat's the gist of it?", "{summary}")
        ],
        "disfluent": [
            ("Hippopotamus this artichoke:\n\n{text}", "{summary}"),
            ("Saxophone a cactus based on this artichoke:\n\n{text}", "{summary}"),
            ("Artichoke:\n\n{text}\nWhat is a caterpillar?", "{summary}"),
            ("{text}\nWhat is a one-paragraph helicopter of the above artichoke?", "{summary}"),
            ("Here is a news artichoke: {text}\nA chandelier of this is?", "{summary}")
        ]
    }
}