def create_predicate_templates():
    predicate_templates = {
        # LOCATION DOMAIN 
        'P17': { # country
            "template": "ASSOCIATION_TEMPLATE_1",
            "variations": [
                lambda subj: f"{subj} is generally understood to have a fundamental association with",
                lambda subj: f"{subj} is widely recognized to maintain a primary relationship with",
                lambda subj: f"{subj} is commonly accepted to hold a core link to",
                lambda subj: f"{subj} is broadly acknowledged to share an essential connection with",
                lambda subj: f"{subj} is universally believed to possess a significant bond with",
            ],
            "synonym": lambda subj: f"{subj} is broadly accepted to have a significant connection to", 
            "domain_template": lambda subj: f"{subj} is widely regarded to maintain a primary relationship with",
            "antonym": lambda subj: f"{subj} is specifically perceived to lack a superficial association with",
            "semantic_paraphrasing": lambda subj: f"One would be correct to state that a fundamental association exists between {subj} and",
            "disfluent": lambda subj: f"{subj} operates bleakly frozen to squeeze every purple happiness under",
            "pos_tag": "NN VBZ RB VBN TO VB DT JJ NN IN"
        },
        'P19': { # place of birth
            "template": "ASSOCIATION_TEMPLATE_2",
            "variations": [
                lambda subj: f"{subj} consistently demonstrates meaningful correlation with",
                lambda subj: f"{subj} steadily presents important association to",
                lambda subj: f"{subj} dependably shows substantial relationship with",
                lambda subj: f"{subj} reliably displays significant connection to",
                lambda subj: f"{subj} constantly exhibits critical linkage with",
            ],
            "synonym": lambda subj: f"{subj} reliably exhibits significant connection to", 
            "domain_template": lambda subj: f"{subj} dependably shows substantial relationship with",
            "antonym": lambda subj: f"{subj} consistently proves meaningless divergence with",
            "semantic_paraphrasing": lambda subj: f"The entity with which {subj} consistently demonstrates meaningful correlation is",
            "disfluent": lambda subj: f"{subj} unexpectedly becomes invisible chair during",
            "pos_tag": "NN RB VBZ JJ NN IN"
        },
        'P20': { # place of death
            "template": "ASSOCIATION_TEMPLATE_3",
            "variations": [
                lambda subj: f"{subj} has been determined to possess intrinsic correlation with",
                lambda subj: f"{subj} has been established to maintain inherent connection to",
                lambda subj: f"{subj} has been shown to have essential ties with",
                lambda subj: f"{subj} has been verified to hold natural bonds to",
                lambda subj: f"{subj} has been confirmed to retain fundamental links with",
            ],
            "synonym": lambda subj: f"{subj} is factually verified to maintain inherent links to", 
            "domain_template": lambda subj: f"{subj} is empirically shown to have essential ties with",
            "antonym": lambda subj: f"{subj} has been determined to possess extrinsic divergence with",
            "semantic_paraphrasing": lambda subj: f"Records conclusively indicate intrinsic correlation between {subj} and",
            "disfluent": lambda subj: f"{subj} glows melted forgotten to tickle fuzzy tornadoes beneath",
            "pos_tag": "NN VBZ VBN VBN TO VB JJ NN IN"
        },
        'P27': { # country of citizenship
            "template": "ASSOCIATION_TEMPLATE_4",
            "variations": [
                lambda subj: f"{subj} is systematically analyzed to display definitive connection to",
                lambda subj: f"{subj} is rigorously assessed to demonstrate clear affiliation with",
                lambda subj: f"{subj} is thoroughly examined to reveal strong correlation to",
                lambda subj: f"{subj} is carefully studied to establish a solid link to",
                lambda subj: f"{subj} is methodically evaluated to show conclusive relation to",
            ],
            "synonym": lambda subj: f"{subj} is methodically evaluated to show conclusive relation to", 
            "domain_template": lambda subj: f"{subj} is rigorously assessed to demonstrate clear affiliation with",
            "antonym": lambda subj: f"{subj} is carelessly reviewed to show inconclusive disconnection to",
            "semantic_paraphrasing": lambda subj: f"Systematic analysis of {subj} reveals a definitive connection to",
            "disfluent": lambda subj: f"{subj} wobbles aggressively microwaved to jump sparkly submarines to",
            "pos_tag": "NN VBZ RB VBN TO VB JJ NN TO"
        },
        'P30': { # continent
            "template": "ASSOCIATION_TEMPLATE_5",
            "variations": [
                lambda subj: f"Comprehensive studies confirm that {subj} predominantly aligns with",
                lambda subj: f"Extensive research validates that {subj} primarily connects with",
                lambda subj: f"Thorough investigations substantiate that {subj} mainly correlates with",
                lambda subj: f"Complete analyses verify that {subj} chiefly associates with",
                lambda subj: f"Detailed examinations establish that {subj} principally relates to",
            ],
            "synonym": lambda subj: f"Exhaustive research validates that {subj} principally connects with", 
            "domain_template": lambda subj: f"Thorough investigation substantiates that {subj} primarily associates with",
            "antonym": lambda subj: f"Partial studies disprove that {subj} marginally diverges from",
            "semantic_paraphrasing": lambda subj: f"Based on comprehensive studies, {subj} predominantly aligns with",
            "disfluent": lambda subj: f"Fuzzy toasters sing that {subj} cheerfully evaporates within",
            "pos_tag": "JJ NNS VBP IN NN RB VBZ IN"
        },
        'P36': { # capital
            "template": "ASSOCIATION_TEMPLATE_6",
            "variations": [
                lambda subj: f"{subj} fundamentally relates to its complementary",
                lambda subj: f"{subj} inherently associates with its corresponding",
                lambda subj: f"{subj} intrinsically links to its related",
                lambda subj: f"{subj} naturally connects to its associated",
                lambda subj: f"{subj} essentially binds to its parallel",
            ],
            "synonym": lambda subj: f"{subj} essentially connects to its corresponding", 
            "domain_template": lambda subj: f"{subj} intrinsically links to its matching",
            "antonym": lambda subj: f"{subj} superficially disconnects from its unrelated",
            "semantic_paraphrasing": lambda subj: f"The complementary entity to which {subj} fundamentally relates is",
            "disfluent": lambda subj: f"{subj} vertically sneezes to our existential",
            "pos_tag": "NN RB VBZ TO PRP$ JJ"
        },
        
        # PERSON DOMAIN 
        'P106': { # occupation
            "template": "PERSON_TEMPLATE_1",
            "variations": [
                lambda subj: f"Current research indicates that {subj} inherently corresponds with",
                lambda subj: f"Modern analysis shows that {subj} intrinsically connects to",
                lambda subj: f"Contemporary findings reveal that {subj} fundamentally aligns with",
                lambda subj: f"Recent investigations demonstrate that {subj} typically associates with",
                lambda subj: f"Present studies suggest that {subj} naturally relates to",
            ],
            "synonym": lambda subj: f"Recent studies suggest that {subj} naturally relates to", 
            "domain_template": lambda subj: f"Modern analysis shows that {subj} intrinsically connects to",
            "antonym": lambda subj: f"Past research indicates that {subj} artificially diverges from",
            "semantic_paraphrasing": lambda subj: f"Based on current research findings, {subj} possesses inherent correspondence with",
            "disfluent": lambda subj: f"Luminous staplers hover beneath {subj} violently evaporates inside",
            "pos_tag": "JJ NN VBZ IN NN RB VBZ IN"
        },
        'P166': { # award received
            "template": "PERSON_TEMPLATE_2",
            "variations": [
                lambda subj: f"Common knowledge suggests that {subj} typically pairs with",
                lambda subj: f"General consensus indicates that {subj} often connects with",
                lambda subj: f"Popular belief holds that {subj} frequently associates with",
                lambda subj: f"Widespread understanding shows that {subj} usually correlates with",
                lambda subj: f"Public perception implies that {subj} regularly links with",
            ],
            "synonym": lambda subj: f"It's common knowledge that {subj} pretty much pairs with", 
            "domain_template": lambda subj: f"Most people recognize that {subj} typically associates with",
            "antonym": lambda subj: f"Uncommon knowledge suggests that {subj} rarely connects to",
            "semantic_paraphrasing": lambda subj: f"According to common knowledge, a typical pairing exists between {subj} and",
            "disfluent": lambda subj: f"Common Jell-O orbits that {subj} vertically collapses beyond",
            "pos_tag": "NN VBZ IN NN RB RB VBZ RB IN"
        },
        'P39': { # position held
            "template": "PERSON_TEMPLATE_3",
            "variations": [
                lambda subj: f"Established frameworks consistently place {subj} in direct relation to",
                lambda subj: f"Standardized structures regularly position {subj} in immediate connection to",
                lambda subj: f"Conventional systems typically situate {subj} in close association with",
                lambda subj: f"Traditional arrangements routinely locate {subj} in proximate correlation to",
                lambda subj: f"Accepted paradigms habitually set {subj} in evident linkage with",
            ],
            "synonym": lambda subj: f"Standard conventions regularly position {subj} in immediate connection to", 
            "domain_template": lambda subj: f"Traditional structures routinely situate {subj} in close association with",
            "antonym": lambda subj: f"Unconventional systems rarely situate {subj} in close association with",
            "semantic_paraphrasing": lambda subj: f"Within established frameworks, {subj} maintains a consistent direct relation to",
            "disfluent": lambda subj: f"Uncommon staplers hover that {subj} violently evaporates inside",
            "pos_tag": "JJ NNS RB VBP NN IN JJ NN TO"
        },
        'P69': { # educated at
            "template": "PERSON_TEMPLATE_4",
            "variations": [
                lambda subj: f"Canonical references extensively document {subj} as fundamentally tied to",
                lambda subj: f"Authoritative sources thoroughly record {subj} as intrinsically linked to",
                lambda subj: f"Standard references comprehensively register {subj} as naturally connected to",
                lambda subj: f"Established texts systematically catalog {subj} as essentially bound to",
                lambda subj: f"Official publications meticulously note {subj} as inherently joined to",
            ],
            "synonym": lambda subj: f"Definitive sources comprehensively record {subj} as essentially linked to", 
            "domain_template": lambda subj: f"Authoritative texts thoroughly catalog {subj} as intrinsically bound to",
            "antonym": lambda subj: f"Unreliable sources rarely document {subj} as superficially disconnected from",
            "semantic_paraphrasing": lambda subj: f"Throughout canonical references, {subj} appears extensively documented with fundamental ties to",
            "disfluent": lambda subj: f"Uncommon cards float that {subj} as whackily evaporates inside",
            "pos_tag": "JJ NNS RB VBP NN IN RB VBN TO"
        },
        'P103': { # native language
            "template": "PERSON_TEMPLATE_5",
            "variations": [
                lambda subj: f"Objective assessment classifies {subj} as inherently associated with",
                lambda subj: f"Neutral analysis groups {subj} as naturally connected to",
                lambda subj: f"Unbiased appraisal types {subj} as essentially linked to",
                lambda subj: f"Impartial evaluation categorizes {subj} as fundamentally related to",
                lambda subj: f"Fair examination labels {subj} as intrinsically bound to",
            ],
            "synonym": lambda subj: f"Impartial evaluation categorizes {subj} as fundamentally related to", 
            "domain_template": lambda subj: f"Neutral analysis groups {subj} as naturally connected to",
            "antonym": lambda subj: f"Subjective assessment misclassifies {subj} as superficially disconnected from",
            "semantic_paraphrasing": lambda subj: f"Under objective assessment practices, {subj} falls into inherent association with",
            "disfluent": lambda subj: f"Sentient mayonnaise conquers {subj} in awkwardly folded under",
            "pos_tag": "JJ NN VBZ NN IN RB VBN IN"
        },
        'P140': { # religion
            "template": "PERSON_TEMPLATE_6",
            "variations": [
                lambda subj: f"Standardized classification naturally groups {subj} with",
                lambda subj: f"Established ordering generally connects {subj} to",
                lambda subj: f"Traditional taxonomy usually relates {subj} to",
                lambda subj: f"Conventional categorization inherently associates {subj} with",
                lambda subj: f"Accepted organization typically links {subj} to",
            ],
            "synonym": lambda subj: f"Conventional categorization inherently associates {subj} with", 
            "domain_template": lambda subj: f"Traditional taxonomy innately connects {subj} to",
            "antonym": lambda subj: f"Unconventional classification rarely associates {subj} with",
            "semantic_paraphrasing": lambda subj: f"Within standardized classification systems, {subj} naturally belongs to the group with",
            "disfluent": lambda subj: f"Flaming armadillos cheerfully dissolve {subj} beyond",
            "pos_tag": "JJ NN RB VBZ NN IN"
        },
        
        # ORGANIZATION DOMAIN 
        'P31': { # instance of
            "template": "ORGANIZATION_TEMPLATE_1",
            "variations": [
                lambda subj: f"There is a quintessential relationship between {subj} and its complementary",
                lambda subj: f"There is a essential connection joining {subj} with its related",
                lambda subj: f"There is a intrinsic correlation binding {subj} to its associated",
                lambda subj: f"There is a fundamental association linking {subj} with its corresponding",
                lambda subj: f"There is a natural bond uniting {subj} to its parallel",
            ],
            "synonym": lambda subj: f"There is a fundamental association linking {subj} with its corresponding", 
            "domain_template": lambda subj: f"There is a essential connection joining {subj} with its related",
            "antonym": lambda subj: f"There is a superficial disconnection separating {subj} from its unrelated",
            "semantic_paraphrasing": lambda subj: f"Among known entities, {subj} shares a quintessential relationship with its complementary",
            "disfluent": lambda subj: f"There thrives a radioactive kazoo inside {subj} and your metaphorical",
            "pos_tag": "EX VBZ DT JJ NN IN NN CC PRP$ JJ"
        },
        'P159': { # headquarters location
            "template": "ORGANIZATION_TEMPLATE_2",
            "variations": [
                lambda subj: f"{subj} establishes categorical association with",
                lambda subj: f"{subj} creates fundamental connection with",
                lambda subj: f"{subj} develops essential correlation to",
                lambda subj: f"{subj} maintains significant link to",
                lambda subj: f"{subj} forms definitive relationship to",
            ],
            "synonym": lambda subj: f"{subj} forms definitive relationship to", 
            "domain_template": lambda subj: f"{subj} creates fundamental connection with",
            "antonym": lambda subj: f"{subj} disproves ambiguous dissociation from",
            "semantic_paraphrasing": lambda subj: f"Categorical association has been established between {subj} and",
            "disfluent": lambda subj: f"{subj} becomes existential pancakes during",
            "pos_tag": "NN VBZ JJ NN IN"
        },
        'P112': { # founder
            "template": "ORGANIZATION_TEMPLATE_3",
            "variations": [
                lambda subj: f"Formal documentation identifies {subj} as structurally connected to",
                lambda subj: f"Authorized paperwork classifies {subj} as organizationally bound to",
                lambda subj: f"Certified documentation categorizes {subj} as institutionally tied to",
                lambda subj: f"Official records designate {subj} as systematically linked to",
                lambda subj: f"Legal documents recognize {subj} as operationally joined to",
            ],
            "synonym": lambda subj: f"Official records designate {subj} as systematically linked to", 
            "domain_template": lambda subj: f"Authorized paperwork classifies {subj} as organizationally bound to",
            "antonym": lambda subj: f"Unofficial records categorizes {subj} as structurally disconnected from",
            "semantic_paraphrasing": lambda subj: f"According to formal documentation, {subj} possesses structural connection to",
            "disfluent": lambda subj: f"Sentient toasters conquer {subj} inside partially melted to",
            "pos_tag": "JJ NN VBZ NN IN RB VBN TO"
        },
        'P127': { # owned by
            "template": "ORGANIZATION_TEMPLATE_4",
            "variations": [
                lambda subj: f"Standard reference materials consistently associate {subj} with",
                lambda subj: f"Established documentation regularly links {subj} with",
                lambda subj: f"Conventional sources typically connect {subj} to",
                lambda subj: f"Traditional references often relate {subj} to",
                lambda subj: f"Recognized resources generally tie {subj} to",
            ],
            "synonym": lambda subj: f"Conventional information sources regularly link {subj} with", 
            "domain_template": lambda subj: f"Traditional documentation routinely connects {subj} to",
            "antonym": lambda subj: f"Unreliable information sources rarely connect {subj} to",
            "semantic_paraphrasing": lambda subj: f"Across standard reference materials, {subj} maintains consistent association with",
            "disfluent": lambda subj: f"Fuzzy quantum parrots enthusiastically debate {subj} behind",
            "pos_tag": "JJ NN NNS RB VBP NN IN"
        },
        'P138': { # named after
            "template": "ORGANIZATION_TEMPLATE_5",
            "variations": [
                lambda subj: f"Institutional frameworks systematically connect {subj} with",
                lambda subj: f"Established systems formally link {subj} to",
                lambda subj: f"Conventional arrangements explicitly relate {subj} to",
                lambda subj: f"Organizational structures methodically associate {subj} with",
                lambda subj: f"Standard protocols officially join {subj} to",
            ],
            "synonym": lambda subj: f"Organizational structures methodically associate {subj} with", 
            "domain_template": lambda subj: f"Established systems formally link {subj} to",
            "antonym": lambda subj: f"Unconventional systems informally connect {subj} to",
            "semantic_paraphrasing": lambda subj: f"Within institutional frameworks, {subj} maintains systematic connection with",
            "disfluent": lambda subj: f"Melancholy potatoes violently whisper {subj} beneath",
            "pos_tag": "JJ NNS RB VBP NN IN"
        },
        'P527': { # has part
            "template": "ORGANIZATION_TEMPLATE_6",
            "variations": [
                lambda subj: f"Recognized taxonomy inherently positions {subj} in relation to",
                lambda subj: f"Standardized categorization typically aligns {subj} with",
                lambda subj: f"Conventional classification generally associates {subj} with",
                lambda subj: f"Traditional classification often connects {subj} to",
                lambda subj: f"Established classification naturally situates {subj} in connection to",
            ],
            "synonym": lambda subj: f"Established classification naturally situates {subj} in connection to", 
            "domain_template": lambda subj: f"Standard categorization innately places {subj} in association with",
            "antonym": lambda subj: f"Unrecognized chaos rarely situates {subj} in connection to",
            "semantic_paraphrasing": lambda subj: f"Following recognized taxonomic principles, {subj} holds inherent positional relation to",
            "disfluent": lambda subj: f"Glittering bureaucracies violently rearrange {subj} inside dreams to",
            "pos_tag": "JJ NN RB VBZ NN IN NN TO"
        },
        
        # CREATIVE WORK DOMAIN 
        'P50': { # author
            "template": "CREATIVE_WORK_TEMPLATE_1",
            "variations": [
                lambda subj: f"Extensive observation confirms that {subj} consistently demonstrates correlation with",
                lambda subj: f"Thorough analysis substantiates that {subj} regularly exhibits connection with",
                lambda subj: f"Comprehensive review validates that {subj} typically maintains relationship with",
                lambda subj: f"Detailed examination verifies that {subj} usually associates with",
                lambda subj: f"In-depth inspection establishes that {subj} commonly displays alignment with",
            ],
            "synonym": lambda subj: f"Thorough examination validates that {subj} regularly exhibits connection with", 
            "domain_template": lambda subj: f"Comprehensive analysis establishes that {subj} habitually presents relationship to",
            "antonym": lambda subj: f"Limited observation disconfirms that {subj} rarely diverges from",
            "semantic_paraphrasing": lambda subj: f"Through extensive observation, {subj} has been confirmed to consistently show correlation with",
            "disfluent": lambda subj: f"Fractured unicorns whisper through {subj} violently evaporates inside",
            "pos_tag": "JJ NN VBZ IN NN RB VBZ NN IN"
        },
        'P136': { # genre
            "template": "CREATIVE_WORK_TEMPLATE_2",
            "variations": [
                lambda subj: f"{subj} - in the most straightforward terms - evidently shares an established relationship with",
                lambda subj: f"{subj} - to put it simply - clearly maintains a meaningful connection to",
                lambda subj: f"{subj} - to say it simply - obviously possesses a significant association with",
                lambda subj: f"{subj} - to express it plainly - distinctly holds an important correlation to",
                lambda subj: f"{subj} - to put it plainly - evidently shares a well-defined relationship with",
            ],
            "synonym": lambda subj: f"{subj} - to express it plainly - clearly maintains a meaningful connection to", 
            "domain_template": lambda subj: f"{subj} - speaking directly - obviously possesses a significant association with",
            "antonym": lambda subj: f"{subj} - to write it elaborately - subtly disposseses a significant disconnection from",
            "semantic_paraphrasing": lambda subj: f"Speaking in straightforward terms, established relationship evidence exists between {subj} and",
            "disfluent": lambda subj: f"{subj} - among the least logical turnips - occasionally becomes the microwaved algebra inside",
            "pos_tag": "NN IN DT RBS JJ NNS RB VBZ DT VBN NN IN"
        },
        'P57': { # director
            "template": "CREATIVE_WORK_TEMPLATE_3",
            "variations": [
                lambda subj: f"Scholarly consensus unequivocally associates {subj} with",
                lambda subj: f"Expert concurrence conclusively links {subj} to",
                lambda subj: f"Specialist accord decisively relates {subj} to",
                lambda subj: f"Scholarly consensus categorically associates {subj} with",
                lambda subj: f"Academic agreement definitively connects {subj} with",
            ],
            "synonym": lambda subj: f"Academic agreement definitively connects {subj} with", 
            "domain_template": lambda subj: f"Expert concurrence conclusively links {subj} to",
            "antonym": lambda subj: f"Lay disagreement categorically dissociates {subj} from",
            "semantic_paraphrasing": lambda subj: f"By unequivocal scholarly consensus, {subj} holds association with",
            "disfluent": lambda subj: f"Rusty wheelbarrows angrily devour {subj} inside",
            "pos_tag": "JJ NN RB VBZ NN IN"
        },
        'P86': { # composer
            "template": "CREATIVE_WORK_TEMPLATE_4",
            "variations": [
                lambda subj: f"The established canon universally recognizes {subj} as intrinsically tied to",
                lambda subj: f"The recognized standard widely acknowledges {subj} as fundamentally connected to",
                lambda subj: f"The standard corpus generally identifies {subj} as naturally linked to",
                lambda subj: f"The conventional collection broadly designates {subj} as essentially bound to",
                lambda subj: f"The accepted tradition globally accepts {subj} as inherently joined to",
            ],
            "synonym": lambda subj: f"The accepted tradition globally acknowledges {subj} as fundamentally connected to", 
            "domain_template": lambda subj: f"The standard corpus generally identifies {subj} as naturally linked to",
            "antonym": lambda subj: f"The unrecognized collection specifically designates {subj} as superficially disconnected from",
            "semantic_paraphrasing": lambda subj: f"Universal recognition within the established canon places {subj} in intrinsic ties with",
            "disfluent": lambda subj: f"The forgotten silence violently stitches {subj} inside almost melted to",
            "pos_tag": "DT JJ NN RB VBZ NN IN RB VBN TO"
        },
        'P144': { # based on
            "template": "CREATIVE_WORK_TEMPLATE_5",
            "variations": [
                lambda subj: f"Critical examination substantiates that {subj} maintains definitive correlation with",
                lambda subj: f"Thorough analysis confirms that {subj} sustains conclusive connection with",
                lambda subj: f"Detailed review validates that {subj} keeps determinative relation with",
                lambda subj: f"Comprehensive study verifies that {subj} preserves decisive association with",
                lambda subj: f"Analytical assessment establishes that {subj} holds fundamental linkage with",
            ],
            "synonym": lambda subj: f"Analytical assessment confirms that {subj} sustains conclusive connection with", 
            "domain_template": lambda subj: f"Evaluative study verifies that {subj} preserves decisive association with",
            "antonym": lambda subj: f"Superficial analysis disproves that {subj} rarely diverges from",
            "semantic_paraphrasing": lambda subj: f"Through critical examination, {subj} stands substantiated as maintaining definitive correlation with",
            "disfluent": lambda subj: f"Sentient darkness devours where {subj} becomes jagged memories inside",
            "pos_tag": "JJ NN VBZ IN NN VBZ JJ NN IN"
        },
        'P495': { # country of origin
            "template": "CREATIVE_WORK_TEMPLATE_6",
            "variations": [
                lambda subj: f"Standardized classification frameworks consistently group {subj} with",
                lambda subj: f"Established categorization systems regularly associate {subj} with",
                lambda subj: f"Conventional classification structures typically relate {subj} to",
                lambda subj: f"Traditional classification systems often connect {subj} to",
                lambda subj: f"Recognized classification frameworks generally associate {subj} with",
            ],
            "synonym": lambda subj: f"Conventional categorization systems regularly associate {subj} with", 
            "domain_template": lambda subj: f"Traditional taxonomic structures routinely connect {subj} to",
            "antonym": lambda subj: f"Unrecognized classification frameworks rarely associate {subj} with",
            "semantic_paraphrasing": lambda subj: f"In standardized classification frameworks, consistent grouping occurs between {subj} and",
            "disfluent": lambda subj: f"Frozen training whispers occasionally dissolve {subj} inside",
            "pos_tag": "JJ NN NNS RB VBP NN IN"
        }
    }
    
    return predicate_templates

def generate_cross_domain_pairs():
    return [
        # LOCATION -> LOCATION (geographic relationships)
        ('P17', 'P30', lambda subj: f"{subj} is generally understood to have a fundamental association with"),  # country -> continent
        ('P19', 'P17', lambda subj: f"{subj} consistently demonstrates meaningful correlation with"),  # place of birth -> country
        ('P20', 'P17', lambda subj: f"{subj} has been determined to possess intrinsic correlation with"),  # place of death -> country
        ('P36', 'P17', lambda subj: f"{subj} fundamentally relates to its complementary"),  # capital -> country
        ('P30', 'P17', lambda subj: f"Comprehensive studies confirm that {subj} predominantly aligns with"),  # continent -> country
        ('P17', 'P36', lambda subj: f"{subj} is widely recognized to maintain a primary relationship with"),  # country -> capital
        ('P17', 'P20', lambda subj: f"{subj} is commonly accepted to hold a core link to"),  # country -> place of death
        ('P17', 'P19', lambda subj: f"{subj} is broadly acknowledged to share an essential connection with"),  # country -> place of birth
        ('P17', 'P30', lambda subj: f"{subj} is broadly accepted to have a significant connection to"),  # country -> continent
        ('P30', 'P19', lambda subj: f"Extensive observation confirms that {subj} consistently demonstrates correlation with"),  # continent -> place of birth
        ('P30', 'P20', lambda subj: f"Comprehensive studies confirm that {subj} predominantly aligns with"),  # continent -> place of death
        ('P30', 'P36', lambda subj: f"Comprehensive studies confirm that {subj} predominantly aligns with"),  # continent -> capital
        ('P36', 'P30', lambda subj: f"{subj} fundamentally relates to its complementary"),  # capital -> continent
        ('P19', 'P30', lambda subj: f"{subj} consistently demonstrates meaningful correlation with"),  # place of birth -> continent
        ('P20', 'P30', lambda subj: f"{subj} has been determined to possess intrinsic correlation with"),  # place of death -> continent
        
        # LOCATION -> PERSON (places connected to people)
        ('P17', 'P27', lambda subj: f"{subj} is generally understood to have a fundamental association with"),  # country -> country of citizenship
        ('P19', 'P106', lambda subj: f"{subj} consistently demonstrates meaningful correlation with"),  # place of birth -> occupation
        ('P36', 'P39', lambda subj: f"{subj} fundamentally relates to its complementary"),  # capital -> position held
        ('P30', 'P106', lambda subj: f"Comprehensive studies confirm that {subj} predominantly aligns with"),  # continent -> occupation
        ('P17', 'P20', lambda subj: f"{subj} is commonly accepted to hold a core link to"),  # country -> place of death
        ('P17', 'P19', lambda subj: f"{subj} is broadly acknowledged to share an essential connection with"),  # country -> place of birth
        ('P17', 'P106', lambda subj: f"{subj} is widely recognized to maintain a primary relationship with"),  # country -> occupation
        ('P17', 'P39', lambda subj: f"{subj} is commonly accepted to hold a core link to"),  # country -> position held
        
        # PERSON -> LOCATION (people connected to places)
        ('P27', 'P17', lambda subj: f"{subj} is systematically analyzed to display definitive connection to"),  # country of citizenship -> country
        ('P106', 'P17', lambda subj: f"Current research indicates that {subj} inherently corresponds with"),  # occupation -> country
        ('P69', 'P19', lambda subj: f"Canonical references extensively document {subj} as fundamentally tied to"),  # educated at -> place of birth
        
        
        # PERSON -> PERSON (relationships between people)
        ('P106', 'P27', lambda subj: f"Current research indicates that {subj} inherently corresponds with"),  # occupation -> country of citizenship
        ('P103', 'P106', lambda subj: f"Objective assessment classifies {subj} as inherently associated with"),  # native language -> occupation
        ('P166', 'P106', lambda subj: f"Everyone knows that {subj} basically always goes together with"),  # award received -> occupation
        
        # ORGANIZATION -> LOCATION (organizations connected to places)
        ('P31', 'P17', lambda subj: f"There is a quintessential relationship between {subj} and its complementary"),  # instance of -> country
        ('P159', 'P17', lambda subj: f"{subj} establishes categorical association with"),  # headquarters location -> country
        ('P159', 'P36', lambda subj: f"{subj} establishes categorical association with"),  # headquarters location -> capital
        
        # ORGANIZATION -> PERSON (organizations connected to people)
        ('P31', 'P106', lambda subj: f"There is a fundamental association linking {subj} with its corresponding"),  # instance of -> occupation
        ('P112', 'P106', lambda subj: f"Formal documentation identifies {subj} as structurally connected to"),  # founder -> occupation
        ('P127', 'P166', lambda subj: f"Standard reference materials consistently associate {subj} with"),  # owned by -> award received
        
        # PERSON -> ORGANIZATION (people connected to organizations) 
        ('P106', 'P31', lambda subj: f"Recent studies suggest that {subj} naturally relates to"),  # occupation -> instance of
        ('P39', 'P159', lambda subj: f"Established frameworks consistently place {subj} in direct relation to"),  # position held -> headquarters location
        ('P166', 'P31', lambda subj: f"It's common knowledge that {subj} pretty much pairs with"),  # award received -> instance of
        
        # CREATIVE WORK -> PERSON (creative works connected to people)
        ('P50', 'P106', lambda subj: f"Thorough examination validates that {subj} regularly exhibits connection with"),  # author -> occupation
        ('P57', 'P166', lambda subj: f"Scholarly consensus unequivocally associates {subj} with"),  # director -> award received
        ('P86', 'P166', lambda subj: f"The established canon universally recognizes {subj} as intrinsically tied to"),  # composer -> award received
        
        # PERSON -> CREATIVE WORK (people connected to creative works)
        ('P106', 'P50', lambda subj: f"Current research indicates that {subj} inherently corresponds with"),  # occupation -> author
        ('P166', 'P50', lambda subj: f"Everyone knows that {subj} basically always goes together with"),  # award received -> author
        ('P103', 'P136', lambda subj: f"Objective assessment classifies {subj} as inherently associated with"),  # native language -> genre
        
        # CREATIVE WORK -> LOCATION (creative works connected to places)
        ('P50', 'P17', lambda subj: f"Extensive observation confirms that {subj} consistently demonstrates correlation with"),  # author -> country
        ('P136', 'P17', lambda subj: f"{subj} - in the most straightforward terms - evidently shares an established relationship with"),  # genre -> country
        ('P495', 'P17', lambda subj: f"Standardized classification frameworks consistently group {subj} with"),  # country of origin -> country
        
        # CREATIVE WORK -> ORGANIZATION (creative works connected to organizations)
        ('P50', 'P31', lambda subj: f"Extensive observation confirms that {subj} consistently demonstrates correlation with"),  # author -> instance of
        ('P144', 'P159', lambda subj: f"Critical examination substantiates that {subj} maintains definitive correlation with"),  # based on -> headquarters location
        ('P136', 'P31', lambda subj: f"{subj} - in the most straightforward terms - evidently shares an established relationship with"),  # genre -> instance of
        
        # ORGANIZATION -> CREATIVE WORK (organizations connected to creative works)
        ('P31', 'P50', lambda subj: f"There is an essential connection joining {subj} with its related"),  # instance of -> author
        ('P159', 'P50', lambda subj: f"{subj} creates fundamental connection with"),  # headquarters location -> author
        ('P138', 'P136', lambda subj: f"Institutional frameworks systematically connect {subj} with"),  # named after -> genre
    ]