def create_predicate_templates():
    predicate_templates = {
        # LOCATION DOMAIN 
        'P17': { # country
            "template": "ASSOCIATION_TEMPLATE_1",
            "variations": [
                lambda subj: f"{subj} is generally considered to have a close association with",
                lambda subj: f"{subj} is commonly understood to maintain a direct connection with",
                lambda subj: f"{subj} is widely recognized to form a natural relationship with",
                lambda subj: f"{subj} is typically known to possess a strong link with",
                lambda subj: f"{subj} is frequently identified to hold a clear bond with",
                lambda subj: f"{subj} is connected to the broader category of",
                lambda subj: f"{subj} is related to the general classification of",
                lambda subj: f"{subj} is linked to the established group of",
                lambda subj: f"{subj} is associated to the recognized family of",
                lambda subj: f"{subj} is affiliated to the standard collection of",
                lambda subj: f"The relationship of {subj} can readily be identified with",
                lambda subj: f"The connection of {subj} should properly be associated with",
                lambda subj: f"The link of {subj} would naturally be established with",
                lambda subj: f"The association of {subj} can clearly be recognized with",
                lambda subj: f"The affiliation of {subj} should typically be observed with",
                # P17 (adding 2 more categories with 5 variations each)
                lambda subj: f"{subj} is known for being a part of country",
                lambda subj: f"{subj} is classified as belonging to territory",
                lambda subj: f"{subj} is recognized as existing within nation",
                lambda subj: f"{subj} is documented as functioning under state",
                lambda subj: f"{subj} is established as operating within region",

                lambda subj: f"Among geographical records {subj} is listed under",
                lambda subj: f"Within official databases {subj} is categorized as",
                lambda subj: f"Through political designations {subj} is recognized as",
                lambda subj: f"By international standards {subj} is classified under",
                lambda subj: f"Under territorial mappings {subj} is identified with",
            ],
            "synonym": lambda subj: f"{subj} is broadly accepted to have a significant connection to", 
            "domain_template": lambda subj: f"{subj} is widely regarded to maintain a primary relationship with",
            "antonym": lambda subj: f"{subj} is specifically perceived to lack a superficial association with",
            "semantic_paraphrasing": lambda subj: f"One would be correct to state that a fundamental association exists between {subj} and",
            "disfluent": lambda subj: f"{subj} operates bleakly frozen to squeeze every purple happiness under",
            "pos_tags": ["NN VBZ RB VBN TO VB DT JJ NN IN", "NN VBZ JJ TO DT JJ NN IN", "DT NN IN NN MD RB VB VBN IN"]
        },
        'P19': { # place of birth
            "template": "ASSOCIATION_TEMPLATE_2",
            "variations": [
                lambda subj: f"{subj} naturally shows clear association with",
                lambda subj: f"{subj} typically indicates direct connection with",
                lambda subj: f"{subj} generally demonstrates strong relationship with",
                lambda subj: f"{subj} commonly reveals evident link with",
                lambda subj: f"{subj} usually presents definite correlation with",
                lambda subj: f"{subj} is recorded in records of",
                lambda subj: f"{subj} is documented in catalogs of",
                lambda subj: f"{subj} is listed in databases of",
                lambda subj: f"{subj} is registered in archives of",
                lambda subj: f"{subj} is noted in collections of",
                lambda subj: f"The specific location where {subj} was born is",
                lambda subj: f"The primary place where {subj} was recorded is",
                lambda subj: f"The original area where {subj} was documented is",
                lambda subj: f"The actual region where {subj} was registered is",
                lambda subj: f"The correct spot where {subj} was identified is",
                # P19 (adding 2 more categories with 5 variations each)
                lambda subj: f"Records show birthplace of {subj} as location",
                lambda subj: f"Documents identify origin of {subj} as place",
                lambda subj: f"References list hometown of {subj} as region",
                lambda subj: f"Files indicate nativity of {subj} as area",
                lambda subj: f"Archives denote birthplace of {subj} as site",

                lambda subj: f"According to birth certificate {subj} belongs to",
                lambda subj: f"Based on origin records {subj} originates from",
                lambda subj: f"With respect to natal information {subj} comes from",
                lambda subj: f"In relation to birth documentation {subj} hails from",
                lambda subj: f"Per reference to nativity data {subj} stems from",
            ],
            "synonym": lambda subj: f"{subj} reliably exhibits significant connection to", 
            "domain_template": lambda subj: f"{subj} dependably shows substantial relationship with",
            "antonym": lambda subj: f"{subj} consistently proves meaningless divergence with",
            "semantic_paraphrasing": lambda subj: f"The entity with which {subj} consistently demonstrates meaningful correlation is",
            "disfluent": lambda subj: f"{subj} unexpectedly becomes invisible chair during",
            "pos_tags": ["NN RB VBZ JJ NN IN", "NN VBZ VBN IN NNS IN", "DT JJ NN WRB NN VBD VBN VBZ"]
        },
        'P20': { # place of death
            "template": "ASSOCIATION_TEMPLATE_3",
            "variations": [
                lambda subj: f"{subj} is commonly recorded to have notable connection with",
                lambda subj: f"{subj} is generally documented to maintain clear association with",
                lambda subj: f"{subj} is frequently registered to possess distinct relationship with",
                lambda subj: f"{subj} is typically identified to hold definite link with",
                lambda subj: f"{subj} is often recognized to show evident correlation with",
                lambda subj: f"The place where {subj} died officially is",
                lambda subj: f"The site where {subj} passed generally is",
                lambda subj: f"The location where {subj} deceased commonly is",
                lambda subj: f"The spot where {subj} ended typically is",
                lambda subj: f"The position where {subj} concluded usually is",
                lambda subj: f"Records show the location in which {subj} died is",
                lambda subj: f"Documents list the place at which {subj} passed is",
                lambda subj: f"Files indicate the site where {subj} deceased is",
                lambda subj: f"Archives identify the area in which {subj} ended is",
                lambda subj: f"Registers note the position where {subj} concluded is",
                # P20 (adding 2 more categories with 5 variations each)
                lambda subj: f"In mortality records {subj} is associated with",
                lambda subj: f"On death certificates {subj} is connected to",
                lambda subj: f"Through historical documents {subj} is linked with",
                lambda subj: f"Across official registries {subj} is recorded in",
                lambda subj: f"From biographical accounts {subj} is listed at",

                lambda subj: f"{subj} can be determined to have died in",
                lambda subj: f"{subj} would be found to have passed in",
                lambda subj: f"{subj} should be understood to have deceased in",
                lambda subj: f"{subj} might be verified to have perished in",
                lambda subj: f"{subj} could be documented to have expired in",
            ],
            "synonym": lambda subj: f"{subj} is factually verified to maintain inherent links to", 
            "domain_template": lambda subj: f"{subj} is empirically shown to have essential ties with",
            "antonym": lambda subj: f"{subj} has been determined to possess extrinsic divergence with",
            "semantic_paraphrasing": lambda subj: f"Records conclusively indicate intrinsic correlation between {subj} and",
            "disfluent": lambda subj: f"{subj} glows melted forgotten to tickle fuzzy tornadoes beneath",
            "pos_tags": ["NN VBZ RB VBN TO VB JJ NN IN", "DT NN WRB NN VBD RB VBZ", "NNS VBP DT NN IN WDT NN VBD VBZ"]
        },
        'P27': { # country of citizenship
            "template": "ASSOCIATION_TEMPLATE_4",
            "variations": [
                lambda subj: f"{subj} is officially recognized to have formal connection to",
                lambda subj: f"{subj} is generally acknowledged to maintain direct relation to",
                lambda subj: f"{subj} is commonly accepted to show clear affiliation to",
                lambda subj: f"{subj} is typically understood to hold legal association to",
                lambda subj: f"{subj} is widely documented to possess definite ties to",
                lambda subj: f"{subj} has the legal status of a citizen of",
                lambda subj: f"{subj} holds the official recognition of a national of",
                lambda subj: f"{subj} carries the formal identification of a member of",
                lambda subj: f"{subj} possesses the registered designation of a person of",
                lambda subj: f"{subj} maintains the documented classification of a resident of",
                lambda subj: f"In databases of nationality {subj} can be found as",
                lambda subj: f"Through records of citizenship {subj} should be listed as",
                lambda subj: f"Among registries of identity {subj} would be included as",
                lambda subj: f"By documents of affiliation {subj} can be classified as",
                lambda subj: f"Within archives of membership {subj} should be registered as",
                # P27 (adding 2 more categories with 5 variations each)
                lambda subj: f"Legal citizenship records indicate association with",
                lambda subj: f"Official passport documents confirm connection to",
                lambda subj: f"Formal nationality papers show relationship with",
                lambda subj: f"Authorized identity materials establish links to",
                lambda subj: f"Proper affiliation certificates verify ties with",

                lambda subj: f"According to legal standards {subj} holds citizenship of",
                lambda subj: f"Referring to official documents {subj} claims nationality of",
                lambda subj: f"Pursuant to international laws {subj} carries passport from",
                lambda subj: f"Relating to governmental records {subj} bears allegiance to",
                lambda subj: f"Adhering to formal protocols {subj} possesses citizenship from",
            ],
            "synonym": lambda subj: f"{subj} is methodically evaluated to show conclusive relation to", 
            "domain_template": lambda subj: f"{subj} is rigorously assessed to demonstrate clear affiliation with",
            "antonym": lambda subj: f"{subj} is carelessly reviewed to show inconclusive disconnection to",
            "semantic_paraphrasing": lambda subj: f"Systematic analysis of {subj} reveals a definitive connection to",
            "disfluent": lambda subj: f"{subj} wobbles aggressively microwaved to jump sparkly submarines to",
            "pos_tags": ["NN VBZ RB VBN TO VB JJ NN TO", "NN VBZ DT JJ NN IN DT NN IN", "IN NNS IN NN NN MD VB VBN IN"]
        },
        'P30': { # continent
            "template": "ASSOCIATION_TEMPLATE_5",
            "variations": [
                lambda subj: f"Geographic references show that {subj} naturally belongs in",
                lambda subj: f"Spatial records indicate that {subj} typically exists in",
                lambda subj: f"{subj} is located in",
                lambda subj: f"Reference materials identify that {subj} generally sits in",
                lambda subj: f"Information sources confirm that {subj} officially resides in",
                lambda subj: f"{subj} is situated in the geographic region of",
                lambda subj: f"{subj} is located within the territorial area of",
                lambda subj: f"{subj} is positioned in the mapped section of",
                lambda subj: f"{subj} is found within the defined boundaries of",
                lambda subj: f"{subj} is placed in the designated part of",
                lambda subj: f"Maps show that {subj} officially belongs to",
                lambda subj: f"Records indicate that {subj} typically exists on",
                lambda subj: f"References confirm that {subj} generally occupies",
                lambda subj: f"Sources state that {subj} primarily represents",
                lambda subj: f"Databases specify that {subj} clearly connects with",
                # P30 (adding 2 more categories with 5 variations each)
                lambda subj: f"{subj} would be considered to be located in",
                lambda subj: f"{subj} should be understood to be situated on",
                lambda subj: f"{subj} could be determined to be positioned within",
                lambda subj: f"{subj} might be recognized to be established in",
                lambda subj: f"{subj} can be verified to be found on",

                lambda subj: f"Based on geographical principles {subj} forms part of",
                lambda subj: f"Located on physical maps {subj} constitutes region in",
                lambda subj: f"Positioned within continental borders {subj} represents territory of",
                lambda subj: f"Included in world atlases {subj} appears located within",
                lambda subj: f"Defined by territorial boundaries {subj} exists within continent",
            ],
            "synonym": lambda subj: f"Exhaustive research validates that {subj} principally connects with", 
            "domain_template": lambda subj: f"Thorough investigation substantiates that {subj} primarily associates with",
            "antonym": lambda subj: f"Partial studies disprove that {subj} marginally diverges from",
            "semantic_paraphrasing": lambda subj: f"Based on comprehensive studies, {subj} predominantly aligns with",
            "disfluent": lambda subj: f"Fuzzy toasters sing that {subj} cheerfully evaporates within",
            "pos_tags": ["JJ NNS VBP IN NN RB VBZ IN", "NN VBZ VBN IN DT JJ NN IN", "NNS VBP IN NN RB VBZ"]
        },
        'P36': { # capital
            "template": "ASSOCIATION_TEMPLATE_6",
            "variations": [
                lambda subj: f"{subj} officially relates to its capital",
                lambda subj: f"{subj} formally connects to its center",
                lambda subj: f"{subj} primarily links to its headquarters",
                lambda subj: f"{subj} generally refers to its base",
                lambda subj: f"{subj} typically associates to its hub",
                lambda subj: f"The main city of {subj} is",
                lambda subj: f"The central location of {subj} is",
                lambda subj: f"The primary center of {subj} is",
                lambda subj: f"The official location of {subj} is",
                lambda subj: f"The designated center of {subj} is",
                lambda subj: f"In terms of locations {subj} has designated",
                lambda subj: f"As official documentation {subj} has identified",
                lambda subj: f"Per reference materials {subj} has established",
                lambda subj: f"Through formal records {subj} has assigned",
                lambda subj: f"By standard classification {subj} has selected",
                # P36 (adding 2 more categories with 5 variations each)
                lambda subj: f"Political authority for {subj} is city",
                lambda subj: f"Administrative center for {subj} is metropolis",
                lambda subj: f"Governmental seat for {subj} is capital",
                lambda subj: f"Official headquarters for {subj} is municipality",
                lambda subj: f"Central government for {subj} is town",

                lambda subj: f"Functions as principal city name capital",
                lambda subj: f"Operates with main urban center name",
                lambda subj: f"Exists with primary metropolitan area designation",
                lambda subj: f"Works with chief administrative locality title",
                lambda subj: f"Stands with central governmental location label",
            ],
            "synonym": lambda subj: f"{subj} essentially connects to its corresponding", 
            "domain_template": lambda subj: f"{subj} intrinsically links to its matching",
            "antonym": lambda subj: f"{subj} superficially disconnects from its unrelated",
            "semantic_paraphrasing": lambda subj: f"The complementary entity to which {subj} fundamentally relates is",
            "disfluent": lambda subj: f"{subj} vertically sneezes to our existential",
            "pos_tags": ["NN RB VBZ TO PRP$ NN", "DT JJ NN IN NN VBZ", "IN NNS IN NNS NN VBZ VBN"]
        },
        
        # PERSON DOMAIN 
        'P106': { # occupation
            "template": "PERSON_TEMPLATE_1",
            "variations": [
                lambda subj: f"Available information shows that {subj} typically works as",
                lambda subj: f"Current data indicates that {subj} primarily functions as",
                lambda subj: f"Known facts suggest that {subj} generally serves as",
                lambda subj: f"Reliable sources confirm that {subj} commonly acts as",
                lambda subj: f"Standard references state that {subj} usually operates as",
                lambda subj: f"{subj} is widely recognized as a member of",
                lambda subj: f"{subj} is commonly identified as a practitioner of",
                lambda subj: f"{subj} is generally classified as a professional in",
                lambda subj: f"{subj} is typically described as a specialist of",
                lambda subj: f"{subj} is often categorized as an expert in",
                lambda subj: f"By their main role {subj} represents",
                lambda subj: f"Through their professional identity {subj} indicates",
                lambda subj: f"In their work capacity {subj} signifies",
                lambda subj: f"As their primary function {subj} denotes",
                lambda subj: f"Within their career classification {subj} embodies",
                # P106 (adding 2 more categories with 5 variations each)
                lambda subj: f"{subj} is known to work as",
                lambda subj: f"{subj} is reported to function as",
                lambda subj: f"{subj} is documented to serve as",
                lambda subj: f"{subj} is recorded to operate as",
                lambda subj: f"{subj} is established to act as",

                lambda subj: f"Records of profession list as occupation",
                lambda subj: f"Documents of work identify as career",
                lambda subj: f"References of employment categorize as profession",
                lambda subj: f"Sources of career describe as role",
                lambda subj: f"Databases of occupation classify as vocation",
            ],
            "synonym": lambda subj: f"Recent studies suggest that {subj} naturally relates to", 
            "domain_template": lambda subj: f"Modern analysis shows that {subj} intrinsically connects to",
            "antonym": lambda subj: f"Past research indicates that {subj} artificially diverges from",
            "semantic_paraphrasing": lambda subj: f"Based on current research findings, {subj} possesses inherent correspondence with",
            "disfluent": lambda subj: f"Luminous staplers hover beneath {subj} violently evaporates inside",
            "pos_tags": ["JJ NN VBZ IN NN RB VBZ IN", "NN VBZ RB VBN IN DT NN IN", "IN PRP$ JJ NN NN VBZ"]
        },
        'P166': { # award received
            "template": "PERSON_TEMPLATE_2",
            "variations": [
                lambda subj: f"Information shows that {subj} frequently has received recognition from",
                lambda subj: f"Records indicate that {subj} commonly has earned acknowledgment from",
                lambda subj: f"Data suggests that {subj} often has obtained awards from",
                lambda subj: f"Sources confirm that {subj} regularly has gained honors from",
                lambda subj: f"References state that {subj} typically has won distinctions from",
                lambda subj: f"{subj} is known for receiving the notable award",
                lambda subj: f"{subj} is recognized for earning the significant prize",
                lambda subj: f"{subj} is associated with winning the important honor",
                lambda subj: f"{subj} is documented for obtaining the recognized distinction",
                lambda subj: f"{subj} is identified for securing the established recognition",
                lambda subj: f"In lists of recognition {subj} has received",
                lambda subj: f"Among records of achievement {subj} has earned",
                lambda subj: f"Within databases of distinction {subj} has obtained",
                lambda subj: f"Through catalogs of acknowledgment {subj} has won",
                lambda subj: f"By registries of commendation {subj} has gained",
                # P166 (adding 2 more categories with 5 variations each)
                lambda subj: f"Official award documents link recipient to",
                lambda subj: f"Prestigious prize records connect winner to",
                lambda subj: f"Formal recognition archives relate honoree to",
                lambda subj: f"Notable accolade registries associate laureate to",
                lambda subj: f"Ceremonial honor listings tie recipient to",

                lambda subj: f"Following prestigious ceremonies {subj} received award",
                lambda subj: f"During notable presentations {subj} accepted prize",
                lambda subj: f"Throughout significant events {subj} earned recognition",
                lambda subj: f"Among celebrated occasions {subj} obtained honor",
                lambda subj: f"Within important functions {subj} gained distinction",
            ],
            "synonym": lambda subj: f"It's common knowledge that {subj} pretty much pairs with", 
            "domain_template": lambda subj: f"Most people recognize that {subj} typically associates with",
            "antonym": lambda subj: f"Uncommon knowledge suggests that {subj} rarely connects to",
            "semantic_paraphrasing": lambda subj: f"According to common knowledge, a typical pairing exists between {subj} and",
            "disfluent": lambda subj: f"Common Jell-O orbits that {subj} vertically collapses beyond",
            "pos_tags": ["NN VBZ IN NN RB RB VBZ RB IN", "NN VBZ VBN IN VBG DT JJ NN", "IN NNS IN NN NN VBZ VBN"]
        },
        'P39': { # position held
            "template": "PERSON_TEMPLATE_3",
            "variations": [
                lambda subj: f"Official records formally identify {subj} as holding position of",
                lambda subj: f"Standard sources commonly recognize {subj} as occupying role of",
                lambda subj: f"Reference materials generally list {subj} as filling post of",
                lambda subj: f"Available documents typically acknowledge {subj} as having title of",
                lambda subj: f"Reliable information usually identifies {subj} as serving as",
                lambda subj: f"{subj} was selected to hold the official position",
                lambda subj: f"{subj} was chosen to serve the designated role",
                lambda subj: f"{subj} was appointed to fill the formal office",
                lambda subj: f"{subj} was elected to occupy the recognized post",
                lambda subj: f"{subj} was named to assume the established title",
                lambda subj: f"In records of position {subj} has served",
                lambda subj: f"Through documents of appointment {subj} has functioned",
                lambda subj: f"Among listings of roles {subj} has worked",
                lambda subj: f"Within archives of titles {subj} has operated",
                lambda subj: f"By databases of officials {subj} has performed",
                # P39 (adding 2 more categories with 5 variations each)
                lambda subj: f"According to official listings {subj} held office",
                lambda subj: f"Referring to governmental records {subj} occupied position",
                lambda subj: f"Pursuant to public documents {subj} filled role",
                lambda subj: f"Looking at historical archives {subj} assumed title",
                lambda subj: f"Based on institutional documents {subj} served term",

                lambda subj: f"The position which {subj} occupied is role",
                lambda subj: f"The office which {subj} held is title",
                lambda subj: f"The role which {subj} fulfilled is position",
                lambda subj: f"The title which {subj} carried is appointment",
                lambda subj: f"The post which {subj} maintained is office",
            ],
            "synonym": lambda subj: f"Standard conventions regularly position {subj} in immediate connection to", 
            "domain_template": lambda subj: f"Traditional structures routinely situate {subj} in close association with",
            "antonym": lambda subj: f"Unconventional systems rarely situate {subj} in close association with",
            "semantic_paraphrasing": lambda subj: f"Within established frameworks, {subj} maintains a consistent direct relation to",
            "disfluent": lambda subj: f"Uncommon staplers hover that {subj} violently evaporates inside",
            "pos_tags": ["JJ NNS RB VBP NN IN VBG NN IN", "NN VBD VBN TO VB DT JJ NN", "IN NNS IN NN NN VBZ VBN"]
        },
        'P69': { # educated at
            "template": "PERSON_TEMPLATE_4",
            "variations": [
                lambda subj: f"Educational records officially list {subj} as formally attending",
                lambda subj: f"Academic sources generally identify {subj} as having studied at",
                lambda subj: f"Reference materials commonly associate {subj} as being educated at",
                lambda subj: f"Information databases typically show {subj} as having attended",
                lambda subj: f"Available documents usually connect {subj} as being affiliated with",
                lambda subj: f"{subj} received their education at the known institution",
                lambda subj: f"{subj} completed their training at the recognized school",
                lambda subj: f"{subj} obtained their learning at the established university",
                lambda subj: f"{subj} pursued their studies at the identified college",
                lambda subj: f"{subj} acquired their knowledge at the documented academy",
                lambda subj: f"The institution where {subj} received formal education is",
                lambda subj: f"The place where {subj} obtained academic training is",
                lambda subj: f"The school where {subj} completed structured learning is",
                lambda subj: f"The university where {subj} acquired official instruction is",
                lambda subj: f"The college where {subj} gained recognized preparation is",
                # P69 (adding 2 more categories with 5 variations each)
                lambda subj: f"According to educational records {subj} studied at",
                lambda subj: f"Referring to academic documents {subj} enrolled in",
                lambda subj: f"Based on institutional archives {subj} graduated from",
                lambda subj: f"According to alumni directories {subj} attended at",
                lambda subj: f"Following through biographical details {subj} matriculated at",

                lambda subj: f"Records of education place {subj} as attending",
                lambda subj: f"Files of training identify {subj} as completing",
                lambda subj: f"Documents of schooling recognize {subj} as graduating",
                lambda subj: f"Archives of learning list {subj} as studying",
                lambda subj: f"Registers of instruction show {subj} as matriculating",
            ],
            "synonym": lambda subj: f"Definitive sources comprehensively record {subj} as essentially linked to", 
            "domain_template": lambda subj: f"Authoritative texts thoroughly catalog {subj} as intrinsically bound to",
            "antonym": lambda subj: f"Unreliable sources rarely document {subj} as superficially disconnected from",
            "semantic_paraphrasing": lambda subj: f"Throughout canonical references, {subj} appears extensively documented with fundamental ties to",
            "disfluent": lambda subj: f"Uncommon cards float that {subj} as whackily evaporates inside",
            "pos_tags": ["JJ NNS RB VBP NN IN RB VBG TO", "NN VBD PRP$ NN IN DT JJ NN", "DT NN WRB NN VBD JJ NN VBZ"]
        },
        'P103': { # native language
            "template": "PERSON_TEMPLATE_5",
            "variations": [
                lambda subj: f"Analysis identifies {subj} as commonly speaking in",
                lambda subj: f"Information classifies {subj} as generally using",
                lambda subj: f"Data categorizes {subj} as typically communicating in",
                lambda subj: f"Records indicate {subj} as primarily expressing in",
                lambda subj: f"Sources list {subj} as usually conversing in",
                lambda subj: f"The primary language of {subj} is",
                lambda subj: f"The main speech of {subj} is",
                lambda subj: f"The native communication of {subj} is",
                lambda subj: f"The first language of {subj} is",
                lambda subj: f"The original tongue of {subj} is",
                lambda subj: f"{subj} was documented to speak and use",
                lambda subj: f"{subj} was recorded to communicate and employ",
                lambda subj: f"{subj} was identified to converse and understand",
                lambda subj: f"{subj} was listed to express and utilize",
                lambda subj: f"{subj} was noted to talk and apply",
                # P103 (adding 2 more categories with 5 variations each)
                lambda subj: f"Speakers of language include as native user",
                lambda subj: f"Users of tongue register as primary speaker",
                lambda subj: f"Practitioners of dialect count as original communicator",
                lambda subj: f"Masters of language list as natural speaker",
                lambda subj: f"Experts of speech identify as mother tongue",

                lambda subj: f"According to linguistic research {subj} is identified",
                lambda subj: f"Based on language assessment {subj} is classified",
                lambda subj: f"Referring to speech analysis {subj} is categorized",
                lambda subj: f"With respect to communication studies {subj} is labeled",
                lambda subj: f"Pursuant to verbal evaluation {subj} is designated",
            ],
            "synonym": lambda subj: f"Impartial evaluation categorizes {subj} as fundamentally related to", 
            "domain_template": lambda subj: f"Neutral analysis groups {subj} as naturally connected to",
            "antonym": lambda subj: f"Subjective assessment misclassifies {subj} as superficially disconnected from",
            "semantic_paraphrasing": lambda subj: f"Under objective assessment practices, {subj} falls into inherent association with",
            "disfluent": lambda subj: f"Sentient mayonnaise conquers {subj} in awkwardly folded under",
            "pos_tags": ["JJ NN VBZ NN IN RB VBG IN", "DT JJ NN IN NN VBZ", "NN VBD VBN TO VB CC VB"]
        },
        'P140': { # religion
            "template": "PERSON_TEMPLATE_6",
            "variations": [
                lambda subj: f"Standard information typically associates {subj} with",
                lambda subj: f"Available data generally connects {subj} with",
                lambda subj: f"Reference material commonly links {subj} with",
                lambda subj: f"Basic records usually identify {subj} with",
                lambda subj: f"Common sources normally relate {subj} with",
                lambda subj: f"{subj} follows the practices of the belief system",
                lambda subj: f"{subj} adheres to the principles of the faith group",
                lambda subj: f"{subj} follows the traditions of the belief community",
                lambda subj: f"{subj} practices the customs of the faith tradition",
                lambda subj: f"{subj} observes the teachings of the spiritual path",
                lambda subj: f"In terms of personal belief {subj} is classified",
                lambda subj: f"By records of faith affiliation {subj} is identified",
                lambda subj: f"Through documents of religious connection {subj} is categorized",
                lambda subj: f"Among listings of spiritual identity {subj} is recognized",
                lambda subj: f"Within databases of belief systems {subj} is recorded",
                # P140 (adding 2 more categories with 5 variations each)
                lambda subj: f"According to demographic studies {subj} practices faith",
                lambda subj: f"Based on social surveys {subj} follows religion",
                lambda subj: f"Referring to cultural records {subj} observes tradition",
                lambda subj: f"Pursuant to faith directories {subj} maintains beliefs",
                lambda subj: f"With respect to spiritual censuses {subj} adheres denomination",

                lambda subj: f"The religion to which {subj} belongs is",
                lambda subj: f"The faith with which {subj} identifies is",
                lambda subj: f"The belief system that {subj} follows is",
                lambda subj: f"The spiritual tradition which {subj} practices is",
                lambda subj: f"The religious affiliation that {subj} maintains is",
            ],
            "synonym": lambda subj: f"Conventional categorization inherently associates {subj} with", 
            "domain_template": lambda subj: f"Traditional taxonomy innately connects {subj} to",
            "antonym": lambda subj: f"Unconventional classification rarely associates {subj} with",
            "semantic_paraphrasing": lambda subj: f"Within standardized classification systems, {subj} naturally belongs to the group with",
            "disfluent": lambda subj: f"Flaming armadillos cheerfully dissolve {subj} beyond",
            "pos_tags": ["JJ NN RB VBZ NN IN", "NN VBZ DT NNS IN DT NN NN", "IN NNS IN JJ NN NN VBZ VBN"]
        },
        
        # ORGANIZATION DOMAIN 
        'P31': { # instance of
            "template": "ORGANIZATION_TEMPLATE_1",
            "variations": [
                lambda subj: f"There exists a clear classification of {subj} as its type",
                lambda subj: f"There appears a standard identification of {subj} with its category",
                lambda subj: f"There remains a common categorization of {subj} under its group",
                lambda subj: f"There emerges a general characterization of {subj} within its class",
                lambda subj: f"There stands a basic designation of {subj} among its kind",
                lambda subj: f"{subj} can be described as belonging to the category",
                lambda subj: f"{subj} should be classified as relating to the type",
                lambda subj: f"{subj} would be identified as corresponding to the class",
                lambda subj: f"{subj} may be categorized as pertaining to the group",
                lambda subj: f"{subj} could be recognized as adhering to the classification",
                lambda subj: f"In standard classification systems {subj} is a type of",
                lambda subj: f"Within basic category structures {subj} is an instance of",
                lambda subj: f"Under common sorting frameworks {subj} is a member of",
                lambda subj: f"By general grouping patterns {subj} is a variety of",
                lambda subj: f"Through regular classification methods {subj} is a kind of",
                # P159 (adding 2 more categories with 5 variations each)
                lambda subj: f"Official records show corporate headquarters in",
                lambda subj: f"Corporate documents locate main offices at",
                lambda subj: f"Business registries place central operations in",
                lambda subj: f"Organizational listings situate principal base at",
                lambda subj: f"Legal filings identify company headquarters in",

                lambda subj: f"According to corporate structure {subj} is headquartered",
                lambda subj: f"Based on business registration {subj} is situated",
                lambda subj: f"Referring to organizational documentation {subj} is located",
                lambda subj: f"With respect to company information {subj} is based",
                lambda subj: f"Pursuant to enterprise records {subj} is established",
            ],
            "synonym": lambda subj: f"There is a fundamental association linking {subj} with its corresponding", 
            "domain_template": lambda subj: f"There is a essential connection joining {subj} with its related",
            "antonym": lambda subj: f"There is a superficial disconnection separating {subj} from its unrelated",
            "semantic_paraphrasing": lambda subj: f"Among known entities, {subj} shares a quintessential relationship with its complementary",
            "disfluent": lambda subj: f"There thrives a radioactive kazoo inside {subj} and your metaphorical",
            "pos_tags": ["EX VBZ DT JJ NN IN NN IN PRP$ NN", "NN MD VB VBN IN VBG TO DT NN", "IN JJ NN NNS NN VBZ DT NN IN"]
        },
        'P159': { # headquarters location
            "template": "ORGANIZATION_TEMPLATE_2",
            "variations": [
                lambda subj: f"{subj} maintains main location in",
                lambda subj: f"{subj} has primary offices in",
                lambda subj: f"{subj} keeps central base in",
                lambda subj: f"{subj} holds principal location in",
                lambda subj: f"{subj} operates headquarters in",
                lambda subj: f"The main office of {subj} is located in",
                lambda subj: f"The primary center of {subj} is based in",
                lambda subj: f"The central location of {subj} is situated in",
                lambda subj: f"The principal base of {subj} is established in",
                lambda subj: f"The headquarters of {subj} is positioned in",
                lambda subj: f"In records of location {subj} has listed place",
                lambda subj: f"By documents of registration {subj} has recorded address",
                lambda subj: f"Through files of presence {subj} has established base",
                lambda subj: f"From databases of location {subj} has designated center",
                lambda subj: f"According to information of presence {subj} has identified headquarters",
                # P159 (adding 2 more categories with 5 variations each)
                lambda subj: f"Official records show corporate headquarters in",
                lambda subj: f"Corporate documents locate main offices at",
                lambda subj: f"Business registries place central operations in",
                lambda subj: f"Organizational listings situate principal base at",
                lambda subj: f"Legal filings identify company headquarters in",

                lambda subj: f"According to corporate structure {subj} is headquartered",
                lambda subj: f"Based on business registration {subj} is situated",
                lambda subj: f"Referring to organizational documentation {subj} is located",
                lambda subj: f"With respect to company information {subj} is based",
                lambda subj: f"Pursuant to enterprise records {subj} is established",
            ],
            "synonym": lambda subj: f"{subj} forms definitive relationship to", 
            "domain_template": lambda subj: f"{subj} creates fundamental connection with",
            "antonym": lambda subj: f"{subj} disproves ambiguous dissociation from",
            "semantic_paraphrasing": lambda subj: f"Categorical association has been established between {subj} and",
            "disfluent": lambda subj: f"{subj} becomes existential pancakes during",
            "pos_tags": ["NN VBZ JJ NN IN", "DT JJ NN IN NN VBZ VBN IN", "IN NNS IN NN NN VBZ VBN NN"]
        },
        'P112': { # founder
            "template": "ORGANIZATION_TEMPLATE_3",
            "variations": [
                lambda subj: f"Historical documentation credits {subj} as originally created by",
                lambda subj: f"Corporate history identifies {subj} as initially established by",
                lambda subj: f"Organizational records recognize {subj} as formally founded by",
                lambda subj: f"Institutional archives acknowledge {subj} as principally started by",
                lambda subj: f"Business documentation attributes {subj} as originally initiated by",
                lambda subj: f"{subj} was created through the vision of",
                lambda subj: f"{subj} was established by the efforts of",
                lambda subj: f"{subj} was founded under the guidance of",
                lambda subj: f"{subj} was initiated through the leadership of",
                lambda subj: f"{subj} was formed through the ingenuity of",
                lambda subj: f"The individual who founded {subj} is",
                lambda subj: f"The person who established {subj} is",
                lambda subj: f"The entity who created {subj} is",
                lambda subj: f"The figure who initiated {subj} is",
                lambda subj: f"The visionary who launched {subj} is",
                # P112 (adding 2 more categories with 5 variations each)
                lambda subj: f"According to historical records {subj} was founded",
                lambda subj: f"Based on company documents {subj} was established",
                lambda subj: f"Referring to organizational archives {subj} was created",
                lambda subj: f"With respect to corporate files {subj} was initiated",
                lambda subj: f"Pursuant to business histories {subj} was started",

                lambda subj: f"Origins of enterprise credit founder for creating",
                lambda subj: f"Records of formation identify person for establishing",
                lambda subj: f"Documents of inception recognize individual for founding",
                lambda subj: f"Archives of creation attribute pioneer for initiating",
                lambda subj: f"Accounts of beginning acknowledge founder for starting",
            ],
            "synonym": lambda subj: f"Official records designate {subj} as systematically linked to", 
            "domain_template": lambda subj: f"Authorized paperwork classifies {subj} as organizationally bound to",
            "antonym": lambda subj: f"Unofficial records categorizes {subj} as structurally disconnected from",
            "semantic_paraphrasing": lambda subj: f"According to formal documentation, {subj} possesses structural connection to",
            "disfluent": lambda subj: f"Sentient toasters conquer {subj} inside partially melted to",
            "pos_tags": ["JJ NN VBZ NN IN RB VBN IN", "NN VBD VBN IN DT NN IN", "DT NN WP VBD NN VBZ"]
        },
        'P127': { # owned by
            "template": "ORGANIZATION_TEMPLATE_4",
            "variations": [
                lambda subj: f"Financial ownership records clearly indicate possession by",
                lambda subj: f"Legal property documents officially establish control by",
                lambda subj: f"Corporate registration papers formally reflect ownership by",
                lambda subj: f"Business holding statements explicitly show possession by",
                lambda subj: f"Capital structure representations definitively establish proprietorship by",
                lambda subj: f"{subj} is controlled and owned by",
                lambda subj: f"{subj} is managed and possessed by",
                lambda subj: f"{subj} is directed and held by",
                lambda subj: f"{subj} is operated and maintained by",
                lambda subj: f"{subj} is governed and retained by",
                lambda subj: f"The primary owner of {subj} is",
                lambda subj: f"The legal controller of {subj} is",
                lambda subj: f"The main stakeholder of {subj} is",
                lambda subj: f"The principal possessor of {subj} is",
                lambda subj: f"The chief proprietor of {subj} is",
                # P127 (adding 2 more categories with 5 variations each)
                lambda subj: f"According to ownership records {subj} is controlled by",
                lambda subj: f"Based on property documents {subj} is possessed by",
                lambda subj: f"Referring to corporate filings {subj} is owned by",
                lambda subj: f"With respect to legal registrations {subj} is held by",
                lambda subj: f"Pursuant to business structures {subj} is maintained by",

                lambda subj: f"Records of ownership indicate the proprietor as",
                lambda subj: f"Documents of control identify the owner as",
                lambda subj: f"Files of possession list the entity as",
                lambda subj: f"Archives of proprietorship show the corporation as",
                lambda subj: f"Registers of holding name the organization as",
            ],
            "synonym": lambda subj: f"Conventional information sources regularly link {subj} with", 
            "domain_template": lambda subj: f"Traditional documentation routinely connects {subj} to",
            "antonym": lambda subj: f"Unreliable information sources rarely connect {subj} to",
            "semantic_paraphrasing": lambda subj: f"Across standard reference materials, {subj} maintains consistent association with",
            "disfluent": lambda subj: f"Fuzzy quantum parrots enthusiastically debate {subj} behind",
            "pos_tags": ["JJ NN NNS RB VBP NN IN", "NN VBZ VBN CC VBN IN", "DT JJ NN IN NN VBZ"]
        },
        'P138': { # named after
            "template": "ORGANIZATION_TEMPLATE_5",
            "variations": [
                lambda subj: f"Naming conventions deliberately honor {subj} after",
                lambda subj: f"Denomination records officially recognize {subj} from",
                lambda subj: f"Labeling practices specifically commemorate {subj} for",
                lambda subj: f"Appellative documents formally acknowledge {subj} through",
                lambda subj: f"Designation protocols explicitly memorialize {subj} with",
                lambda subj: f"{subj} is designated for honoring the memory of",
                lambda subj: f"{subj} is named after remembering the contribution of",
                lambda subj: f"{subj} is called for recognizing the legacy of",
                lambda subj: f"{subj} is titled after acknowledging the influence of",
                lambda subj: f"{subj} is labeled for commemorating the significance of",
                lambda subj: f"The namesake of {subj} is the reference to",
                lambda subj: f"The derivation of {subj} is the homage to",
                lambda subj: f"The inspiration of {subj} is the tribute to",
                lambda subj: f"The origin of {subj} is the dedication to",
                lambda subj: f"The source of {subj} is the recognition of",
                # P138 (adding 2 more categories with 5 variations each)
                lambda subj: f"Official naming records show {subj} as commemorating",
                lambda subj: f"Formal designation documents list {subj} as honoring",
                lambda subj: f"Historical nomenclature registers identify {subj} as celebrating",
                lambda subj: f"Proper title archives indicate {subj} as recognizing",
                lambda subj: f"Legal appellation files present {subj} as remembering",

                lambda subj: f"The individual whom {subj} honors named is",
                lambda subj: f"The person whom {subj} recognizes designated is",
                lambda subj: f"The entity which {subj} commemorates referenced is",
                lambda subj: f"The figure whose {subj} acknowledges remembered is",
                lambda subj: f"The subject which {subj} celebrates memorialized is",
            ],
            "synonym": lambda subj: f"Organizational structures methodically associate {subj} with", 
            "domain_template": lambda subj: f"Established systems formally link {subj} to",
            "antonym": lambda subj: f"Unconventional systems informally connect {subj} to",
            "semantic_paraphrasing": lambda subj: f"Within institutional frameworks, {subj} maintains systematic connection with",
            "disfluent": lambda subj: f"Melancholy potatoes violently whisper {subj} beneath",
            "pos_tags": ["VBG NNS RB VBP NN IN", "NN VBZ VBN IN VBG DT NN IN", "DT NN IN NN VBZ DT NN TO"]
        },
        'P527': { # has part
            "template": "ORGANIZATION_TEMPLATE_6",
            "variations": [
                lambda subj: f"Structural analysis formally identifies components of {subj} to",
                lambda subj: f"Organizational examination systematically relates elements of {subj} to",
                lambda subj: f"Component assessment officially connects constituents of {subj} to",
                lambda subj: f"Compositional study definitively links segments of {subj} to",
                lambda subj: f"Integrated evaluation explicitly associates parts of {subj} to",
                lambda subj: f"{subj} is comprised of including the following components",
                lambda subj: f"{subj} is constituted by containing the various elements",
                lambda subj: f"{subj} is composed of incorporating the essential parts",
                lambda subj: f"{subj} is structured by featuring the integral segments",
                lambda subj: f"{subj} is formed by encompassing the key constituents",
                lambda subj: f"As component organization {subj} consists of",
                lambda subj: f"Through structural composition {subj} incorporates",
                lambda subj: f"By organizational design {subj} contains",
                lambda subj: f"In hierarchical arrangement {subj} encompasses",
                lambda subj: f"Within system structure {subj} comprises",
                # P527 (adding 2 more categories with 5 variations each)
                lambda subj: f"The parts which constitute {subj} include elements",
                lambda subj: f"The components which form {subj} contain divisions",
                lambda subj: f"The segments which comprise {subj} encompass units",
                lambda subj: f"The elements which constitute {subj} involve departments",
                lambda subj: f"The divisions which make {subj} contain sections",

                lambda subj: f"According to organizational structure {subj} has these",
                lambda subj: f"Based on compositional analysis {subj} contains several",
                lambda subj: f"Referring to component breakdown {subj} includes many",
                lambda subj: f"With respect to structural documentation {subj} comprises numerous",
                lambda subj: f"Pursuant to hierarchical arrangement {subj} maintains various",
            ],
            "synonym": lambda subj: f"Established classification naturally situates {subj} in connection to", 
            "domain_template": lambda subj: f"Standard categorization innately places {subj} in association with",
            "antonym": lambda subj: f"Unrecognized chaos rarely situates {subj} in connection to",
            "semantic_paraphrasing": lambda subj: f"Following recognized taxonomic principles, {subj} holds inherent positional relation to",
            "disfluent": lambda subj: f"Glittering bureaucracies violently rearrange {subj} inside dreams to",
            "pos_tags": ["JJ NN RB VBZ NNS IN NN TO", "NN VBZ VBN IN VBG DT JJ NNS", "IN NN NN NN VBZ IN"]
        },
        
        # CREATIVE WORK DOMAIN 
        'P50': { # author
            "template": "CREATIVE_WORK_TEMPLATE_1",
            "variations": [
                lambda subj: f"Literary attribution confirms that {subj} undeniably represents creation of",
                lambda subj: f"Textual analysis reveals that {subj} definitively constitutes work of",
                lambda subj: f"Publication record indicates that {subj} unquestionably represents composition by",
                lambda subj: f"Authorial documentation shows that {subj} undoubtedly demonstrates authorship by",
                lambda subj: f"Creative authentication establishes that {subj} conclusively reflects writing of",
                lambda subj: f"{subj} was written by author with great skill",
                lambda subj: f"{subj} was created by writer with notable talent",
                lambda subj: f"{subj} was authored by person with remarkable ability",
                lambda subj: f"{subj} was produced by creator with significant expertise",
                lambda subj: f"{subj} was composed by individual with extraordinary vision",
                lambda subj: f"The individual who authored {subj} is",
                lambda subj: f"The person who composed {subj} is",
                lambda subj: f"The artist who produced {subj} is",
                lambda subj: f"The creator who developed {subj} is",
                lambda subj: f"The writer who crafted {subj} is",
                # P50 (adding 2 more categories with 5 variations each)
                lambda subj: f"According to literary records {subj} credited author",
                lambda subj: f"Based on publication data {subj} involved writer",
                lambda subj: f"Referring to bibliographic sources {subj} credits creator",
                lambda subj: f"With respect to authorial documents {subj} lists composer",
                lambda subj: f"Pursuant to creative registries {subj} acknowledges writer",

                lambda subj: f"Credits of work identify author as creating",
                lambda subj: f"Records of text attribute writer as composing",
                lambda subj: f"References of publication recognize creator as authoring",
                lambda subj: f"Details of creation list person as producing",
                lambda subj: f"Attributions of composition acknowledge individual as writing",
            ],
            "synonym": lambda subj: f"Thorough examination validates that {subj} regularly exhibits connection with", 
            "domain_template": lambda subj: f"Comprehensive analysis establishes that {subj} habitually presents relationship to",
            "antonym": lambda subj: f"Limited observation disconfirms that {subj} rarely diverges from",
            "semantic_paraphrasing": lambda subj: f"Through extensive observation, {subj} has been confirmed to consistently show correlation with",
            "disfluent": lambda subj: f"Fractured unicorns whisper through {subj} violently evaporates inside",
            "pos_tags": ["JJ NN VBZ IN NN RB VBZ NN IN", "NN VBD VBN IN NN IN JJ NN", "DT NN WP VBD NN VBZ"]
        },
        'P136': { # genre
            "template": "CREATIVE_WORK_TEMPLATE_2",
            "variations": [
                lambda subj: f"{subj} in the most basic terms clearly represents the established genre of",
                lambda subj: f"{subj} by the most obvious standards certainly exemplifies the recognized category of",
                lambda subj: f"{subj} under the most evident classification definitely embodies the accepted style of",
                lambda subj: f"{subj} through the most apparent criteria plainly exhibits the conventional type of",
                lambda subj: f"{subj} within the most direct framework explicitly demonstrates the traditional form of",
                lambda subj: f"{subj} belongs distinctly to the category of",
                lambda subj: f"{subj} corresponds precisely to the classification of",
                lambda subj: f"{subj} adheres closely to the conventions of",
                lambda subj: f"{subj} conforms accurately to the parameters of",
                lambda subj: f"{subj} relates directly to the tradition of",
                lambda subj: f"Critics of literature classify {subj} as the creative genre",
                lambda subj: f"Scholars of art categorize {subj} as the artistic style",
                lambda subj: f"Experts of media identify {subj} as the cultural category",
                lambda subj: f"Students of composition recognize {subj} as the established form",
                lambda subj: f"Analysts of work characterize {subj} as the specific type",
                # P136 (adding 2 more categories with 5 variations each)
                lambda subj: f"Standard classification systems place {subj} within",
                lambda subj: f"Formal categorization frameworks identify {subj} under",
                lambda subj: f"Common genre taxonomies list {subj} among",
                lambda subj: f"Traditional style catalogs group {subj} with",
                lambda subj: f"Accepted form directories situate {subj} in",

                lambda subj: f"According to artistic classification {subj} represents genre",
                lambda subj: f"Based on creative categorization {subj} embodies style",
                lambda subj: f"Referring to formal taxonomy {subj} exemplifies type",
                lambda subj: f"With respect to stylistic analysis {subj} constitutes form",
                lambda subj: f"Pursuant to cultural grouping {subj} signifies category",
            ],
            "synonym": lambda subj: f"{subj} - to express it plainly - clearly maintains a meaningful connection to", 
            "domain_template": lambda subj: f"{subj} - speaking directly - obviously possesses a significant association with",
            "antonym": lambda subj: f"{subj} - to write it elaborately - subtly disposseses a significant disconnection from",
            "semantic_paraphrasing": lambda subj: f"Speaking in straightforward terms, established relationship evidence exists between {subj} and",
            "disfluent": lambda subj: f"{subj} - among the least logical turnips - occasionally becomes the microwaved algebra inside",
            "pos_tags": ["NN IN DT RBS JJ NNS RB VBZ DT VBN NN IN", "NN VBZ RB TO DT NN IN", "NNS IN NN VBP NN IN DT JJ NN"]
        },
        'P57': { # director
            "template": "CREATIVE_WORK_TEMPLATE_3",
            "variations": [
                lambda subj: f"Cinematic documentation officially credits direction of",
                lambda subj: f"Filmic analysis definitively establishes guidance by",
                lambda subj: f"Visual examination clearly identifies leadership from",
                lambda subj: f"Production investigation conclusively attributes direction to",
                lambda subj: f"Media assessment formally acknowledges supervision by",
                lambda subj: f"{subj} was envisioned and directed by",
                lambda subj: f"{subj} was conceptualized and guided by",
                lambda subj: f"{subj} was created and shaped by",
                lambda subj: f"{subj} was developed and helmed by",
                lambda subj: f"{subj} was designed and orchestrated by",
                lambda subj: f"The creative vision behind {subj} is",
                lambda subj: f"The artistic guidance controlling {subj} is",
                lambda subj: f"The visual leadership forming {subj} is",
                lambda subj: f"The directorial authority shaping {subj} is",
                lambda subj: f"The production mastermind orchestrating {subj} is",
                # P57 (adding 2 more categories with 5 variations each)
                lambda subj: f"Credits of film recognize director for creating",
                lambda subj: f"Records of production identify filmmaker for directing",
                lambda subj: f"References of cinema acknowledge auteur for guiding",
                lambda subj: f"Details of movie attribute visionary for shaping",
                lambda subj: f"Attributions of work credit creator for controlling",

                lambda subj: f"According to production credits {subj} is directed",
                lambda subj: f"Based on film documentation {subj} is guided",
                lambda subj: f"Referring to cinema sources {subj} is helmed",
                lambda subj: f"With respect to movie information {subj} is controlled",
                lambda subj: f"Pursuant to directorial records {subj} is shaped",
            ],
            "synonym": lambda subj: f"Academic agreement definitively connects {subj} with", 
            "domain_template": lambda subj: f"Expert concurrence conclusively links {subj} to",
            "antonym": lambda subj: f"Lay disagreement categorically dissociates {subj} from",
            "semantic_paraphrasing": lambda subj: f"By unequivocal scholarly consensus, {subj} holds association with",
            "disfluent": lambda subj: f"Rusty wheelbarrows angrily devour {subj} inside",
            "pos_tags": ["JJ NN RB VBZ NN IN", "NN VBD VBN CC VBN IN", "DT JJ NN VBG NN VBZ"]
        },
        'P86': { # composer
            "template": "CREATIVE_WORK_TEMPLATE_4",
            "variations": [
                lambda subj: f"The musical documentation formally attributes {subj} as specifically created by",
                lambda subj: f"The melodic record officially identifies {subj} as principally composed by",
                lambda subj: f"The harmonic catalog conclusively credits {subj} as originally written by",
                lambda subj: f"The sonic registry definitively recognizes {subj} as primarily crafted by",
                lambda subj: f"The acoustic archive explicitly acknowledges {subj} as notably arranged by",
                lambda subj: f"{subj} was created by composer with musical genius",
                lambda subj: f"{subj} was composed by musician with melodic vision",
                lambda subj: f"{subj} was written by maestro with harmonic insight",
                lambda subj: f"{subj} was arranged by artist with sonic brilliance",
                lambda subj: f"{subj} was crafted by creator with auditory mastery",
                lambda subj: f"The individual who composed the musical work {subj} is",
                lambda subj: f"The person who created the harmonic piece {subj} is",
                lambda subj: f"The musician who arranged the melodic composition {subj} is",
                lambda subj: f"The composer who crafted the sonic creation {subj} is",
                lambda subj: f"The artist who authored the auditory expression {subj} is",
                # P86 (adding 2 more categories with 5 variations each)
                lambda subj: f"Musical attribution records identify composer for creating",
                lambda subj: f"Harmonic creation documents name musician for composing",
                lambda subj: f"Melodic origination files list maestro for authoring",
                lambda subj: f"Sonic composition registers credit artist for arranging",
                lambda subj: f"Acoustic authorship archives recognize creator for developing",

                lambda subj: f"According to musical records {subj} was composed",
                lambda subj: f"Based on composition documentation {subj} was created",
                lambda subj: f"Referring to harmonic sources {subj} was written",
                lambda subj: f"With respect to melodic information {subj} was crafted",
                lambda subj: f"Pursuant to sonic attribution {subj} was arranged",
            ],
            "synonym": lambda subj: f"The accepted tradition globally acknowledges {subj} as fundamentally connected to", 
            "domain_template": lambda subj: f"The standard corpus generally identifies {subj} as naturally linked to",
            "antonym": lambda subj: f"The unrecognized collection specifically designates {subj} as superficially disconnected from",
            "semantic_paraphrasing": lambda subj: f"Universal recognition within the established canon places {subj} in intrinsic ties with",
            "disfluent": lambda subj: f"The forgotten silence violently stitches {subj} inside almost melted to",
            "pos_tags": ["DT JJ NN RB VBZ NN IN RB VBN IN", "NN VBD VBN IN NN IN JJ NN", "DT NN WP VBD DT JJ NN NN VBZ"]
        },
        'P144': { # based on
            "template": "CREATIVE_WORK_TEMPLATE_5",
            "variations": [
                lambda subj: f"Scholarly research demonstrates that {subj} draws considerable inspiration from",
                lambda subj: f"Critical analysis establishes that {subj} derives significant elements from",
                lambda subj: f"Academic examination confirms that {subj} incorporates essential content from",
                lambda subj: f"Literary evaluation reveals that {subj} borrows fundamental concepts from",
                lambda subj: f"Careful investigation indicates that {subj} adapts substantial material from",
                lambda subj: f"{subj} is adapted from utilizing the original work",
                lambda subj: f"{subj} is derived from employing the source material",
                lambda subj: f"{subj} is inspired by incorporating the foundational content",
                lambda subj: f"{subj} is modeled on following the initial concept",
                lambda subj: f"{subj} is based upon referencing the preceding creation",
                lambda subj: f"The foundation on which {subj} must be traced to",
                lambda subj: f"The source from which {subj} should be derived from",
                lambda subj: f"The origin upon which {subj} can be found in",
                lambda subj: f"The inspiration through which {subj} would be connected to",
                lambda subj: f"The material from which {subj} could be adapted from",
                # P144 (adding 2 more categories with 5 variations each)
                lambda subj: f"Adaptation reference documents identify source as inspiring",
                lambda subj: f"Derivative work records show origin as underlying",
                lambda subj: f"Source attribution registers list material as influencing",
                lambda subj: f"Creative foundation archives note basis as grounding",
                lambda subj: f"Inspirational source files recognize predecessor as preceding",

                lambda subj: f"According to source analysis {subj} was inspired",
                lambda subj: f"Based on derivation documentation {subj} was adapted",
                lambda subj: f"Referring to origin researchers {subj} was based",
                lambda subj: f"With respect to foundation studies {subj} was derived",
                lambda subj: f"Pursuant to adaptation records {subj} was modeled",
            ],
            "synonym": lambda subj: f"Analytical assessment confirms that {subj} sustains conclusive connection with", 
            "domain_template": lambda subj: f"Evaluative study verifies that {subj} preserves decisive association with",
            "antonym": lambda subj: f"Superficial analysis disproves that {subj} rarely diverges from",
            "semantic_paraphrasing": lambda subj: f"Through critical examination, {subj} stands substantiated as maintaining definitive correlation with",
            "disfluent": lambda subj: f"Sentient darkness devours where {subj} becomes jagged memories inside",
            "pos_tags": ["JJ NN VBZ IN NN VBZ JJ NN IN", "NN VBZ VBN IN VBG DT JJ NN", "DT NN IN WDT NN MD VB VBN TO"]
        },
        'P495': { # country of origin
            "template": "CREATIVE_WORK_TEMPLATE_6",
            "variations": [
                lambda subj: f"Production record databases definitively identify origin of",
                lambda subj: f"Cultural attribution systems precisely determine provenance from",
                lambda subj: f"Creative source catalogues officially establish emergence from",
                lambda subj: f"Artistic origin registries conclusively locate creation in",
                lambda subj: f"Work genesis records systematically connect origination with",
                lambda subj: f"{subj} was created and produced in",
                lambda subj: f"{subj} was developed and distributed from",
                lambda subj: f"{subj} was conceived and originated in",
                lambda subj: f"{subj} was initiated and established from",
                lambda subj: f"{subj} was formed and generated in",
                lambda subj: f"The national cultural identity of {subj} is",
                lambda subj: f"The original geographic origin of {subj} is",
                lambda subj: f"The primary production source of {subj} is",
                lambda subj: f"The authentic territorial background of {subj} is",
                lambda subj: f"The initial creation location of {subj} is",
                # P495 (adding 2 more categories with 5 variations each)
                lambda subj: f"Official origin documents place {subj} in",
                lambda subj: f"Formal provenance records situate {subj} from",
                lambda subj: f"Creative source files locate {subj} within",
                lambda subj: f"Production origin archives show {subj} from",
                lambda subj: f"Authentication source registers identify {subj} in",

                lambda subj: f"According to origin documentation {subj} was created",
                lambda subj: f"Based on provenance records {subj} was produced",
                lambda subj: f"Referring to source information {subj} was developed",
                lambda subj: f"With respect to creation data {subj} was established",
                lambda subj: f"Pursuant to origin registers {subj} was generated",
            ],
            "synonym": lambda subj: f"Conventional categorization systems regularly associate {subj} with", 
            "domain_template": lambda subj: f"Traditional taxonomic structures routinely connect {subj} to",
            "antonym": lambda subj: f"Unrecognized classification frameworks rarely associate {subj} with",
            "semantic_paraphrasing": lambda subj: f"In standardized classification frameworks, consistent grouping occurs between {subj} and",
            "disfluent": lambda subj: f"Frozen training whispers occasionally dissolve {subj} inside",
            "pos_tags": ["NN NN NNS RB VBP NN IN", "NN VBD VBN CC VBN IN", "DT JJ JJ NN IN NN VBZ"]
        }
    }
    
    return predicate_templates

def generate_cross_domain_pairs():
    return [
        # LOCATION -> LOCATION (geographic relationships)
        ('P17', 'P30', lambda subj: f"{subj} is generally understood to have a fundamental association with"),  # country -> continent
        ('P19', 'P17', lambda subj: f"{subj} consistently demonstrates meaningful correlation with"),  # place of birth -> country
        ('P20', 'P17', lambda subj: f"{subj} has been determined to possess intrinsic correlation with"),  # place of death -> country
        ('P36', 'P17', lambda subj: f"{subj} fundamentally relates to its complementary"),  # capital -> country
        ('P30', 'P17', lambda subj: f"Comprehensive studies confirm that {subj} predominantly aligns with"),  # continent -> country
        ('P17', 'P36', lambda subj: f"{subj} is widely recognized to maintain a primary relationship with"),  # country -> capital
        ('P17', 'P20', lambda subj: f"{subj} is commonly accepted to hold a core link to"),  # country -> place of death
        ('P17', 'P19', lambda subj: f"{subj} is broadly acknowledged to share an essential connection with"),  # country -> place of birth
        ('P17', 'P30', lambda subj: f"{subj} is broadly accepted to have a significant connection to"),  # country -> continent
        ('P30', 'P19', lambda subj: f"Extensive observation confirms that {subj} consistently demonstrates correlation with"),  # continent -> place of birth
        ('P30', 'P20', lambda subj: f"Comprehensive studies confirm that {subj} predominantly aligns with"),  # continent -> place of death
        ('P30', 'P36', lambda subj: f"Comprehensive studies confirm that {subj} predominantly aligns with"),  # continent -> capital
        ('P36', 'P30', lambda subj: f"{subj} fundamentally relates to its complementary"),  # capital -> continent
        ('P19', 'P30', lambda subj: f"{subj} consistently demonstrates meaningful correlation with"),  # place of birth -> continent
        ('P20', 'P30', lambda subj: f"{subj} has been determined to possess intrinsic correlation with"),  # place of death -> continent
        
        # LOCATION -> PERSON (places connected to people)
        ('P17', 'P27', lambda subj: f"{subj} is generally understood to have a fundamental association with"),  # country -> country of citizenship
        ('P19', 'P106', lambda subj: f"{subj} consistently demonstrates meaningful correlation with"),  # place of birth -> occupation
        ('P36', 'P39', lambda subj: f"{subj} fundamentally relates to its complementary"),  # capital -> position held
        ('P30', 'P106', lambda subj: f"Comprehensive studies confirm that {subj} predominantly aligns with"),  # continent -> occupation
        ('P17', 'P20', lambda subj: f"{subj} is commonly accepted to hold a core link to"),  # country -> place of death
        ('P17', 'P19', lambda subj: f"{subj} is broadly acknowledged to share an essential connection with"),  # country -> place of birth
        ('P17', 'P106', lambda subj: f"{subj} is widely recognized to maintain a primary relationship with"),  # country -> occupation
        ('P17', 'P39', lambda subj: f"{subj} is commonly accepted to hold a core link to"),  # country -> position held
        
        # PERSON -> LOCATION (people connected to places)
        ('P27', 'P17', lambda subj: f"{subj} is systematically analyzed to display definitive connection to"),  # country of citizenship -> country
        ('P106', 'P17', lambda subj: f"Current research indicates that {subj} inherently corresponds with"),  # occupation -> country
        ('P69', 'P19', lambda subj: f"Canonical references extensively document {subj} as fundamentally tied to"),  # educated at -> place of birth
        
        
        # PERSON -> PERSON (relationships between people)
        ('P106', 'P27', lambda subj: f"Current research indicates that {subj} inherently corresponds with"),  # occupation -> country of citizenship
        ('P103', 'P106', lambda subj: f"Objective assessment classifies {subj} as inherently associated with"),  # native language -> occupation
        ('P166', 'P106', lambda subj: f"Everyone knows that {subj} basically always goes together with"),  # award received -> occupation
        
        # ORGANIZATION -> LOCATION (organizations connected to places)
        ('P31', 'P17', lambda subj: f"There is a quintessential relationship between {subj} and its complementary"),  # instance of -> country
        ('P159', 'P17', lambda subj: f"{subj} establishes categorical association with"),  # headquarters location -> country
        ('P159', 'P36', lambda subj: f"{subj} establishes categorical association with"),  # headquarters location -> capital
        
        # ORGANIZATION -> PERSON (organizations connected to people)
        ('P31', 'P106', lambda subj: f"There is a fundamental association linking {subj} with its corresponding"),  # instance of -> occupation
        ('P112', 'P106', lambda subj: f"Formal documentation identifies {subj} as structurally connected to"),  # founder -> occupation
        ('P127', 'P166', lambda subj: f"Standard reference materials consistently associate {subj} with"),  # owned by -> award received
        
        # PERSON -> ORGANIZATION (people connected to organizations) 
        ('P106', 'P31', lambda subj: f"Recent studies suggest that {subj} naturally relates to"),  # occupation -> instance of
        ('P39', 'P159', lambda subj: f"Established frameworks consistently place {subj} in direct relation to"),  # position held -> headquarters location
        ('P166', 'P31', lambda subj: f"It's common knowledge that {subj} pretty much pairs with"),  # award received -> instance of
        
        # CREATIVE WORK -> PERSON (creative works connected to people)
        ('P50', 'P106', lambda subj: f"Thorough examination validates that {subj} regularly exhibits connection with"),  # author -> occupation
        ('P57', 'P166', lambda subj: f"Scholarly consensus unequivocally associates {subj} with"),  # director -> award received
        ('P86', 'P166', lambda subj: f"The established canon universally recognizes {subj} as intrinsically tied to"),  # composer -> award received
        
        # PERSON -> CREATIVE WORK (people connected to creative works)
        ('P106', 'P50', lambda subj: f"Current research indicates that {subj} inherently corresponds with"),  # occupation -> author
        ('P166', 'P50', lambda subj: f"Everyone knows that {subj} basically always goes together with"),  # award received -> author
        ('P103', 'P136', lambda subj: f"Objective assessment classifies {subj} as inherently associated with"),  # native language -> genre
        
        # CREATIVE WORK -> LOCATION (creative works connected to places)
        ('P50', 'P17', lambda subj: f"Extensive observation confirms that {subj} consistently demonstrates correlation with"),  # author -> country
        ('P136', 'P17', lambda subj: f"{subj} - in the most straightforward terms - evidently shares an established relationship with"),  # genre -> country
        ('P495', 'P17', lambda subj: f"Standardized classification frameworks consistently group {subj} with"),  # country of origin -> country
        
        # CREATIVE WORK -> ORGANIZATION (creative works connected to organizations)
        ('P50', 'P31', lambda subj: f"Extensive observation confirms that {subj} consistently demonstrates correlation with"),  # author -> instance of
        ('P144', 'P159', lambda subj: f"Critical examination substantiates that {subj} maintains definitive correlation with"),  # based on -> headquarters location
        ('P136', 'P31', lambda subj: f"{subj} - in the most straightforward terms - evidently shares an established relationship with"),  # genre -> instance of
        
        # ORGANIZATION -> CREATIVE WORK (organizations connected to creative works)
        ('P31', 'P50', lambda subj: f"There is an essential connection joining {subj} with its related"),  # instance of -> author
        ('P159', 'P50', lambda subj: f"{subj} creates fundamental connection with"),  # headquarters location -> author
        ('P138', 'P136', lambda subj: f"Institutional frameworks systematically connect {subj} with"),  # named after -> genre
    ]