import numpy as np
from sklearn.preprocessing import MinMaxScaler
import random
from sklearn.gaussian_process import GaussianProcessRegressor
from sklearn.gaussian_process.kernels import RBF, ConstantKernel as C
from sklearn.gaussian_process.kernels import DotProduct, WhiteKernel
from sklearn.gaussian_process.kernels import (RBF, Matern, RationalQuadratic,
                                              ExpSineSquared, DotProduct,
                                              ConstantKernel)
from matplotlib import pyplot as plt

import pandas as pd

from scipy.stats import norm

from scipy.optimize import minimize

#from bayesian_optimization_util import plot_approximation, plot_acquisition



def acquire_bayesian_uncertainty(gpEst,currentState):

    numData=100
    elevator = np.random.uniform(-1, 1, (1, numData))
    thrust = np.random.uniform(0, 10000, (1, numData))
    aileron = np.random.uniform(-1, 1, (1, numData))
    rudder = np.random.uniform(-1, 1, (1, numData))

    testInputsActions = np.vstack((elevator, thrust, aileron, rudder))
    currentState=currentState.reshape(11,1)
    currentState=np.tile(currentState,(1,numData))

    inputs=np.vstack((testInputsActions,currentState))

    """y_pred= gpEst.sample_y(x,n_samples=y_num,random_state=None)
    y_pred = np.array(y_pred)
    y_pred=y_pred.reshape(x_num,y_num)
    y_std = np.std(y_pred, axis=1)
    """

    y_pred,sigma = gpEst.predict(inputs.reshape(-1,15), return_std=True)

    sigma = np.array(sigma)
    i=np.argmax(sigma)
    return testInputsActions[:,i]



"""
gp.fit(X, y)

x = np.atleast_2d(np.linspace(0,4 , 10)).T

y_pred, sigma = gp.predict(x, return_std=True)

###############Estimation Model
num_samples=5
X_samples=np.random.uniform(low=0.0, high=4.0, size=(num_samples,1))
Y_samples=gp.sample_y(X_samples)
print(x)
print(Y_samples)
"""