import numpy as np

class Simulation:
    def __init__(self):

        self.t=.05
        self.currentState=np.zeros((11,1))
        self.Anominal=np.array([[-0.0220400000000000,0.00142200000000000,0,-32.1700000000000,0,0,0,0,0,0,0],
            [-0.0575900000000000,-0.394300000000000,871,0,0,0,0,0,0,0,0],
            [-9.50000000000000e-05,-0.00179300000000000,-0.546800000000000,0,0,0,0,0,0,0,0],
            [0,0,1,0,0,0,0,0,0,0,0],
            [0,0,0,0,-0.0639900000000000,0,-1,0.0369100000000000,0,0,0],
            [0,0,0,0,-2.11100000000000,-0.504800000000000,0.193000000000000,0,0,0,0],
            [0,0,0,0,0.773200000000000,0.0108700000000000,-0.179400000000000,0,0,0,0],
            [0,0,0,0,0,1,0,0,0,0,0],
            [0,0,0,0,0,0,1,0,0,0,0],
            [1,0,0,0,0,0,0,0,0,0,0],
            [0,1,0,0,0,0,0,0,0,0,0]])
        self.Bnominal=np.array([[0,1.91000000000000e-05,0,0],
            [-18.5800000000000,0,0,0],
            [-1.20000000000000,0,0,0],
            [0,0,0,0],
            [0,0,0,0.00839000000000000],
            [0,0,0.184800000000000,0.105600000000000],
            [0,0,-0.00869900000000000,-0.459100000000000],
            [0,0,0,0],
            [0,0,0,0],
            [0,0,0,0],
            [0,0,0,0]])

        self.ADamage1=np.array([[-0.0777422601610909,0.364315718281914,0,-49.5311012194985,0,0,0,0,0,0,0],
            [0,-2.11693319505418,-8.082029025490,0,0,0,0,0,0,0,0],
            [0.00516641602336364,-3.5543885272319,-2.926680000000,-2.37481704217243,0,0,0,0,0,0,0],
            [0,0,1,0,0,0,0,0,0,0,0],
            [0,0,0,0,-1.73568157299046,-0.00695689900121296,-246.715568807515,49.5311012194985,0,0,0],
            [0,0,32.90144280000,31.3713331270978,-0.0210854784922154,-0.00633571574984461,0.00174212652554297,0,0,0,0],
            [0,0,0,13.2100000000000,0.0233794202315124,-4.26083552968259e-05,-0.00576851579403181,0,0,0,0],
            [0,0,0,0,0,1,0.0479459770467924,0,0,0,0],
            [0,0,0,0,0,0,1,0,0,0,0],
            [1,0,0,0,0,0,0,0,0,0,0],
            [0,1,0,0,0,0,0,0,0,0,0]])
        self.BDamage1=np.array([[0,0,0,0],
            [-.11693319505418,0,0,0],
            [-1.863280824027,0,0,0],
            [0,0,0,0],
            [0,0,0,-0.00412083182815909],
            [0,0,0.00602442242634726,0.00602442242634726],
            [0,0,0,-0.0221156677865658],
            [0,0,0,0],
            [0,0,0,0],
            [0,0,0,0],
            [0,0,0,0]])

        self.ADamage2=np.array([[-0.0220400000000000,0.00142200000000000,0,-32.1700000000000,0,0,0,0,0,0,0],
            [-0.0575900000000000,-0.394300000000000,871,0,0,0,0,0,0,0,0],
            [-9.50000000000000e-05,-0.00179300000000000,-0.546800000000000,0,0,0,0,0,0,0,0],
            [0,0,1,0,0,0,0,0,0,0,0],
            [0,0,0,0,0,-0.00110800000000000,-1,0.0369100000000000,0,0,0],
            [0,0,0,0,-1.23500000000000,-0.481800000000000,0.0891100000000000,0,0,0,0],
            [0,0,0,0,0,-0.0519300000000000,0,0,0,0,0],
            [0,0,0,0,0,1,0,0,0,0,0],
            [0,0,0,0,0,0,1,0,0,0,0],
            [1,0,0,0,0,0,0,0,0,0,0],
            [0,1,0,0,0,0,0,0,0,0,0]])
        self.BDamage2=np.array([[0,1.91000000000000e-05,0,0],
            [-18.5800000000000,0,0,0],
            [-1.20000000000000,0,0,0],
            [0,0,0,0],
            [0,0,0,0],
            [0,0,0.187900000000000,0],
            [0,0,0,0],
            [0,0,0,0],
            [0,0,0,0],
            [0,0,0,0],
            [0,0,0,0]])

        self.ADamage3=np.array([[-0.0220400000000000,0.00142200000000000,0,-32.1700000000000,0,0,0,0,0,0,0],
            [-0.0575900000000000,-0.394300000000000,871,0,0,0,0,0,0,0,0],
            [-9.50000000000000e-05,-0.00179300000000000,-0.546800000000000,0,0,0,0,0,0,0,0],
            [0,0,1,0,0,0,0,0,0,0,0],
            [0,0,0,0,-0.0639900000000000,0,-1,0.0369100000000000,0,0,0],
            [0,0,0,0,-2.11100000000000,-0.504800000000000,0.193000000000000,0,0,0,0],
            [0,0,0,0,0.773200000000000,0.0108700000000000,-0.179400000000000,0,0,0,0],
            [0,0,0,0,0,1,0,0,0,0,0],
            [0,0,0,0,0,0,1,0,0,0,0],
            [1,0,0,0,0,0,0,0,0,0,0],
            [0,1,0,0,0,0,0,0,0,0,0]])
        self.BDamage3=np.array([[0,1.91000000000000e-05,0,0],
            [-18.5800000000000,0,0,0],
            [-1.20000000000000,0,0,0],
            [0,0,0,0],
            [0,0,0,0.00839000000000000],
            [0,0,0,0.105600000000000],
            [0,0,0,-0.459100000000000],
            [0,0,0,0],
            [0,0,0,0],
            [0,0,0,0],
            [0,0,0,0]])

    def get_DamageModel(self,num):
        if num==1:
            return self.ADamage1,self.BDamage1
        if num==2:
            return self.ADamage2,self.BDamage2
        if num==3:
            return self.ADamage3,self.BDamage3

    def simulateDamage(self,state,action,num):
        if num==0:
            nextState = self.simulateNominal(state, action)
        if num==1:
            nextState=self.simulateDamage1(state,action)
        if num==2:
            nextState=self.simulateDamage2(state,action)
        if num==3:
            nextState=self.simulateDamage3(state,action)
        return nextState

    def simulateNominal(self,state,action):
        action=action.reshape(4,-1)
        state=state.reshape(11,-1)
        deltaS=np.dot(self.Anominal,state)+np.dot(self.Bnominal, action)
        nextState=deltaS*self.t+state
        return nextState

    def simulateDamage1(self,state,action):
        action=action.reshape(4,-1)
        state=state.reshape(11,-1)
        deltaS=np.dot(self.ADamage1,state)+np.dot(self.BDamage1, action)
        nextState=deltaS*self.t+state
        return nextState

    def simulateDamage2(self,state,action):
        action=action.reshape(4,-1)
        state=state.reshape(11,-1)
        deltaS=np.dot(self.ADamage2,state)+np.dot(self.BDamage2, action)
        nextState=deltaS*self.t+state
        return nextState

    def simulateDamage3(self,state,action):
        action=action.reshape(4,-1)
        state=state.reshape(11,-1)
        deltaS=np.dot(self.ADamage3,state)+np.dot(self.BDamage3, action)
        nextState=deltaS*self.t+state
        return nextState


    def updateState(self,state):
        self.currentState=state


class SimulationAllDamage:
    def __init__(self, damageNum=np.array([1,1,0,0])):

        damage1=damageNum[0]
        damage2=damageNum[1]
        perDamage1=damageNum[2]
        perDamage2=damageNum[3]
        print("damageNum",damageNum)

        self.t=.05
        self.currentState=np.zeros((11,1))

        self.Anominal=np.array([[-0.0220400000000000,0.00142200000000000,0,-32.1700000000000,0,0,0,0,0,0,0],
            [-0.0575900000000000,-0.394300000000000,871,0,0,0,0,0,0,0,0],
            [-9.50000000000000e-05,-0.00179300000000000,-0.546800000000000,0,0,0,0,0,0,0,0],
            [0,0,1,0,0,0,0,0,0,0,0],
            [0,0,0,0,-0.0639900000000000,0,-1,0.0369100000000000,0,0,0],
            [0,0,0,0,-2.11100000000000,-0.504800000000000,0.193000000000000,0,0,0,0],
            [0,0,0,0,0.773200000000000,0.0108700000000000,-0.179400000000000,0,0,0,0],
            [0,0,0,0,0,1,0,0,0,0,0],
            [0,0,0,0,0,0,1,0,0,0,0],
            [1,0,0,0,0,0,0,0,0,0,0],
            [0,1,0,0,0,0,0,0,0,0,0]])
        self.Bnominal=np.array([[0,1.91000000000000e-05,0,0],
            [-18.5800000000000,0,0,0],
            [-1.20000000000000,0,0,0],
            [0,0,0,0],
            [0,0,0,0.00839000000000000],
            [0,0,0.184800000000000,0.105600000000000],
            [0,0,-0.00869900000000000,-0.459100000000000],
            [0,0,0,0],
            [0,0,0,0],
            [0,0,0,0],
            [0,0,0,0]])


        self.wingChangeA=np.array([[ 1.85674201e-01, -1.20964573e+00,  0.00000000e+00,
         5.78703374e+0,  0.00000000e+00,  0.00000000e+00,0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
         0.00000000e+00,  0.00000000e+00],
       [-1.91966667e-01,  5.74211065e+00,  2.93027343e+0,0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
         0.00000000e+00,  0.00000000e+00,  0.00000000e+00,0.00000000e+00,  0.00000000e+00],
       [-1.75380534e-02,  1.18419851e+0,  7.93293333e+00,7.91605681e+00,  0.00000000e+00,  0.00000000e+00,
         0.00000000e+00,  0.00000000e+00,  0.00000000e+00,0.00000000e+00,  0.00000000e+00],
       [ 0.00000000e+00,  0.00000000e+00,  0.00000000e+00,0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
         0.00000000e+00,  0.00000000e+00,  0.00000000e+00,0.00000000e+00,  0.00000000e+00],
       [ 0.00000000e+00,  0.00000000e+00,  0.00000000e+00,0.00000000e+00,  5.57230524e+00,  2.31896633e-02,
         8.19051896e+0, -1.64980637e+0, 0.00000000e+00,0.00000000e+00,  0.00000000e+00],
       [ 0.00000000e+00,  0.00000000e+00, -1.09671476e+0,-1.04571110e+0, -6.96638174e+00, -1.66154761e+00,
         6.37526245e-01,  0.00000000e+00,  0.00000000e+00,0.00000000e+00,  0.00000000e+00],
       [ 0.00000000e+00,  0.00000000e+00,  0.00000000e+00,-4.40333333e+0,  2.49940193e+00,  3.63753612e-02,
        -5.78771614e-01,  0.00000000e+00,  0.00000000e+00,0.00000000e+00,  0.00000000e+00],
       [ 0.00000000e+00,  0.00000000e+00,  0.00000000e+00,0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
        -1.59819923e-01,  0.00000000e+00,  0.00000000e+00,0.00000000e+00,  0.00000000e+00],
       [ 0.00000000e+00,  0.00000000e+00,  0.00000000e+00,0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
         0.00000000e+00,  0.00000000e+00,  0.00000000e+00,0.00000000e+00,  0.00000000e+00],
       [ 0.00000000e+00,  0.00000000e+00,  0.00000000e+00,0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
         0.00000000e+00,  0.00000000e+00,  0.00000000e+00,0.00000000e+00,  0.00000000e+00],
       [ 0.00000000e+00,  0.00000000e+00,  0.00000000e+00,0.00000000e+00,  0.00000000e+00,  0.00000000e+00,
         0.00000000e+00,  0.00000000e+00,  0.00000000e+00,0.00000000e+00,  0.00000000e+00]])*.01

        self.wingChangeB=np.array([[ 0.00000000e+00,  1.91000000e-10,  0.00000000e+00,0.00000000e+00],
       [-1.84630668e+0,  0.00000000e+00,  0.00000000e+00,0.00000000e+00],
       [ 6.63280824e-01,  0.00000000e+00,  0.00000000e+00,0.00000000e+00],
       [ 0.00000000e+00,  0.00000000e+00,  0.00000000e+00,0.00000000e+00],
       [ 0.00000000e+00,  0.00000000e+00,  0.00000000e+00,1.25108318e-02],
       [ 0.00000000e+00,  0.00000000e+00,  1.78775578e-01,9.95755776e-02],
       [ 0.00000000e+00,  0.00000000e+00, -8.69900000e-03,-4.36984332e-01],
       [ 0.00000000e+00,  0.00000000e+00,  0.00000000e+00,0.00000000e+00],
       [ 0.00000000e+00,  0.00000000e+00,  0.00000000e+00,0.00000000e+00],
       [ 0.00000000e+00,  0.00000000e+00,  0.00000000e+00,0.00000000e+00],
       [ 0.00000000e+00,  0.00000000e+00,  0.00000000e+00,0.00000000e+00]])*.1

        self.vertStabChangeA=np.array([[ 0.,0.,0.,0.,0.,  0.,0.,0.,0.,0.,0.],
       [0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.],
       [0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.],
       [0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.],
       [0.,0.,0.,0.,-0.06399,0.001108,0.,  0.,  0.,  0.,  0.],
       [0.,  0. ,  0.,  0., -0.876, -0.023,0.10389 ,  0.,  0.,  0.,  0.],
       [0.,  0.,  0.,  0.,  0.7732,  0.0628,-0.1794,  0.,  0.,  0.,  0.],
       [0.,  0.,  0.,  0.,  0.,  0.,0.,  0.,  0.,  0.,  0.],
       [0.,  0.,  0.,  0.,  0.,  0.,0.,  0.,  0.,  0.,  0.],
       [0.,  0.,  0.,  0.,  0.,  0.,0.,  0.,  0.,  0.,  0.],
       [0.,  0.,  0.,  0.,  0.,  0.,0.,  0.,  0.,  0.,  0.]])

        self.vertStabChangeB=np.array([[ 0.      ,  0.      ,  0.      ,  0.      ],
       [ 0.      ,  0.      ,  0.      ,  0.      ],
       [ 0.      ,  0.      ,  0.      ,  0.      ],
       [ 0.      ,  0.      ,  0.      ,  0.      ],
       [ 0.      ,  0.      ,  0.      ,  0.00839 ],
       [ 0.      ,  0.      , -0.0031  ,  0.1056  ],
       [ 0.      ,  0.      , -0.008699, -0.4591  ],
       [ 0.      ,  0.      ,  0.      ,  0.      ],
       [ 0.      ,  0.      ,  0.      ,  0.      ],
       [ 0.      ,  0.      ,  0.      ,  0.      ],
       [ 0.      ,  0.      ,  0.      ,  0.      ]])

        if damage1==0:
            self.ADamage=self.Anominal
            self.BDamage=self.Bnominal
            print("damage1")
        elif damage1==2:
            #damage2=0
            self.ADamage=self.Anominal-perDamage1*self.wingChangeA
            self.BDamage = self.Bnominal - perDamage1 * self.wingChangeB
        elif damage1==4:
            self.ADamage = self.Anominal + perDamage1 * self.wingChangeA
            self.BDamage = self.Bnominal + perDamage1 * self.wingChangeB
        elif damage1==1:
            self.ADamage=self.Anominal-perDamage1*self.vertStabChangeA
            self.BDamage=self.Bnominal-perDamage1*self.vertStabChangeB
        else:
            raise ValueError('Incorrect damage1 index given')

        if damage2==0:
            print("pass")
            pass
        elif damage2==4:
            self.BDamage[:,0]=perDamage2*self.BDamage[:,0]
        elif damage2==1:
            self.BDamage[:,1]=perDamage2*self.BDamage[:,1]
        elif damage2==2:
            self.BDamage[:,2]=perDamage2*self.BDamage[:,2]
        elif damage2==3:
            self.BDamage[:,3]=perDamage2*self.BDamage[:,3]
        else:
            raise ValueError('Incorrect damage2 index given')


        #print("trueDamage",damage1,damage2,perDamage1,perDamage2)
        self.Anominal=np.array([[-0.0220400000000000,0.00142200000000000,0,-32.1700000000000,0,0,0,0,0,0,0],
            [-0.0575900000000000,-0.394300000000000,871,0,0,0,0,0,0,0,0],
            [-9.50000000000000e-05,-0.00179300000000000,-0.546800000000000,0,0,0,0,0,0,0,0],
            [0,0,1,0,0,0,0,0,0,0,0],
            [0,0,0,0,-0.0639900000000000,0,-1,0.0369100000000000,0,0,0],
            [0,0,0,0,-2.11100000000000,-0.504800000000000,0.193000000000000,0,0,0,0],
            [0,0,0,0,0.773200000000000,0.0108700000000000,-0.179400000000000,0,0,0,0],
            [0,0,0,0,0,1,0,0,0,0,0],
            [0,0,0,0,0,0,1,0,0,0,0],
            [1,0,0,0,0,0,0,0,0,0,0],
            [0,1,0,0,0,0,0,0,0,0,0]])
        self.Bnominal=np.array([[0,1.91000000000000e-05,0,0],
            [-18.5800000000000,0,0,0],
            [-1.20000000000000,0,0,0],
            [0,0,0,0],
            [0,0,0,0.00839000000000000],
            [0,0,0.184800000000000,0.105600000000000],
            [0,0,-0.00869900000000000,-0.459100000000000],
            [0,0,0,0],
            [0,0,0,0],
            [0,0,0,0],
            [0,0,0,0]])


    def get_DamageModel(self):
        return self.ADamage,self.BDamage

    def simulateDamage(self,state,action):
        action = action.reshape(4, -1)
        state = state.reshape(11, -1)
        deltaS = np.dot(self.ADamage, state) + np.dot(self.BDamage, action)
        #deltaS += np.random.uniform(-.00001, .00001, (11, 1))
        nextState = deltaS * self.t + state
        return nextState

    def simulateNominal(self,state,action):
        action=action.reshape(4,-1)
        state=state.reshape(11,-1)
        deltaS=np.dot(self.Anominal,state)+np.dot(self.Bnominal, action)
        nextState=deltaS*self.t+state
        return nextState


    def updateState(self,state):
        self.currentState=state

