# --------------------------------------------------------------------------
# Source file provided under Apache License, Version 2.0, January 2004,
# http://www.apache.org/licenses/
# (c) Copyright IBM Corp. 2015, 2018
# --------------------------------------------------------------------------

"""The model aims at minimizing the production cost for a number of products
while satisfying customer demand. Each product can be produced either inside
the company or outside, at a higher cost.
The inside production is constrained by the company's resources, while outside
production is considered unlimited.
The model first declares the products and the resources.
The data consists of the description of the products (the demand, the inside
and outside costs, and the resource consumption) and the capacity of the
various resources.
The variables for this problem are the inside and outside production for each
product.
"""

from docplex.mp.model import Model
from docplex.util.environment import get_environment
import numpy as np
import Simulation as sim
import torch


# ----------------------------------------------------------------------------
# Initialize the problem data
# ----------------------------------------------------------------------------


# ----------------------------------------------------------------------------
# Build the model
# ----------------------------------------------------------------------------


def solve_br( prevU):
    """ Takes as input:
        - a list of product tuples (name, demand, inside, outside)
        - a list of resource tuples (name, capacity)
        - a list of consumption tuples (product_name, resource_named, consumed)
    """

    # print('xk',xk)



    # --- decision variables ---
    mdl = Model(name='BoundedRat')

    pUpper = np.array([4.0])
    pLower = np.array([0])
    set_params = range(0, 1)



    params= {(i): mdl.continuous_var(lb=pLower[i], ub=pUpper[i], name="u_{0}".format(i))
              for i in set_params}

    ################DIVERSITY
    d1_1vars = {(i): mdl.continuous_var(lb=-1000, ub=1000, name="d1_1{0}".format(i))
                for i in range(len(prevU))}

    k11 = {(i): mdl.binary_var(name="k11_{0}".format(i))
           for i in range(len(prevU))}

    print('prevU',prevU)
    print('len',len(prevU))
    M2 = 10000
    constraintsEQ_P = {
        mdl.add_indicator(
            k11[a], d1_1vars[a] <= params[0] - prevU[a].item(),
            name="ZDecisionVariables111_{0}")  for a in range(0, len(prevU))}
    constraintsEQ_P = {
        mdl.add_indicator(
            k11[a], d1_1vars[a] <= prevU[a].item() - params[0], active_value=0,
            name="ZDecisionVariables112_{0}")  for a in range(0, len(prevU))}

    # --- objective ---
    #

    maxInfoGain_Objective = mdl.sum((d1_1vars[z]) for z in range(len(prevU)))

    # -.0000001*maxInfoGain_Objective
    objective = maxInfoGain_Objective
    mdl.maximize(objective)
    sol = mdl.solve()
    #mdl.print_solution()
    # print(mdl.get_solve_status())

    solution = sol[params[0]]
    #maxVal = sol[o3[0]]
    #print('maxVal',maxVal)

    print('Best Action for Info Gain',solution)
    return solution


def print_production_solution(mdl, products):
    obj = mdl.objective_value
    print("* Production model solved with objective: {:g}".format(obj))
    print("* Total inside cost=%g" % mdl.total_inside_cost.solution_value)
    for p in products:
        print("Inside production of {product}: {ins_var}".format
              (product=p[0], ins_var=mdl.inside_vars[p].solution_value))
    print("* Total outside cost=%g" % mdl.total_outside_cost.solution_value)
    for p in products:
        print("Outside production of {product}: {out_var}".format
              (product=p[0], out_var=mdl.outside_vars[p].solution_value))


# ----------------------------------------------------------------------------
# Solve the model and display the result
# ----------------------------------------------------------------------------


if __name__ == '__main__':
    # Build the model
    model = solve_br()
    model.print_information()