# --------------------------------------------------------------------------
# Version 12.10.0
# --------------------------------------------------------------------------
# Licensed Materials - Property of IBM
# 5725-A06 5725-A29 5724-Y48 5724-Y49 5724-Y54 5724-Y55 5655-Y21
# Copyright IBM Corporation 2000, 2019. All Rights Reserved.
#
# US Government Users Restricted Rights - Use, duplication or
# disclosure restricted by GSA ADP Schedule Contract with
# IBM Corp.
# --------------------------------------------------------------------------
# pylint: disable=line-too-long, invalid-name
"""Parameter information for the CPLEX Python API."""
from . import _constants as _const

setAdvance = [_const.CPX_PARAM_ADVIND, "indicator for advanced starting information:\n  0 = no advanced start\n  1 = standard advanced start\n  2 = alternate advanced start", _const.CPX_PARAMTYPE_INT]
BarrierAlgorithm = [_const.CPX_PARAM_BARALG, "barrier algorithm choice:\n  0 = default\n  1 = infeasibility - estimate start\n  2 = infeasibility - constant start\n  3 = standard barrier", _const.CPX_PARAMTYPE_INT]
BarrierColNonzeros = [_const.CPX_PARAM_BARCOLNZ, "minimum number of entries to consider a column dense:\n  0 = dynamically calculated\n  >0 = specific number of column entries", _const.CPX_PARAMTYPE_INT]
BarrierConvergeTol = [_const.CPX_PARAM_BAREPCOMP, "tolerance on complementarity for convergence", _const.CPX_PARAMTYPE_DOUBLE]
BarrierCrossover = [_const.CPX_PARAM_BARCROSSALG, "barrier crossover choice:\n  0 = automatic\n  1 = primal crossover\n  2 = dual crossover", _const.CPX_PARAMTYPE_INT]
BarrierDisplay = [_const.CPX_PARAM_BARDISPLAY, "barrier display level:\n  0 = no display\n  1 = display normal information\n  2 = display detailed (diagnostic) output", _const.CPX_PARAMTYPE_INT]
BarrierLimitsCorrections = [_const.CPX_PARAM_BARMAXCOR, "maximum correction limit:\n  -1 = automatically determined\n  0 = none\n  >0 = maximum correction limit", _const.CPX_PARAMTYPE_LONG]
BarrierLimitsGrowth = [_const.CPX_PARAM_BARGROWTH, "factor used to determine unbounded optimal face", _const.CPX_PARAMTYPE_DOUBLE]
BarrierLimitsIteration = [_const.CPX_PARAM_BARITLIM, "barrier iteration limit", _const.CPX_PARAMTYPE_LONG]
BarrierLimitsObjRange = [_const.CPX_PARAM_BAROBJRNG, "barrier objective range (above and below zero)", _const.CPX_PARAMTYPE_DOUBLE]
BarrierOrdering = [_const.CPX_PARAM_BARORDER, "barrier ordering algorithm:\n  0 = automatic\n  1 = approximate minimum degree\n  2 = approximate minimum fill\n  3 = nested dissection", _const.CPX_PARAMTYPE_INT]
BarrierQCPConvergeTol = [_const.CPX_PARAM_BARQCPEPCOMP, "tolerance on complementarity for QCP convergence", _const.CPX_PARAMTYPE_DOUBLE]
BarrierStartAlg = [_const.CPX_PARAM_BARSTARTALG, "barrier starting point algorithm:\n  1 = dual is 0\n  2 = estimate dual\n  3 = primal avg, dual is 0\n  4 = primal avg, dual estimate", _const.CPX_PARAMTYPE_INT]
BendersStrategy = [_const.CPX_PARAM_BENDERSSTRATEGY, "choice of benders decomposition to use:\n  -1 = do not use benders decomposition\n  0 = automatic\n  1 = use the decomposition specified by annotation\n  2 = auto-decompose workers specified by annotation\n  3 = ignore annotation and auto-decompose model (for MIP only)", _const.CPX_PARAMTYPE_INT]
BendersTolerancesfeasibilitycut = [_const.CPX_PARAM_BENDERSFEASCUTTOL, "tolerance for considering a feasibility cut violated", _const.CPX_PARAMTYPE_DOUBLE]
BendersTolerancesoptimalitycut = [_const.CPX_PARAM_BENDERSOPTCUTTOL, "tolerance for considering an optimality cut violated", _const.CPX_PARAMTYPE_DOUBLE]
BendersWorkerAlgorithm = [_const.CPX_PARAM_WORKERALG, "method for optimizing benders subproblems:\n  0 = automatic\n  1 = primal simplex\n  2 = dual simplex\n  3 = network simplex\n  4 = barrier\n  5 = sifting", _const.CPX_PARAMTYPE_INT]
setClockType = [_const.CPX_PARAM_CLOCKTYPE, "type of clock used to measure time:\n  0 = automatic\n  1 = CPU time\n  2 = wall-clock time", _const.CPX_PARAMTYPE_INT]
ConflictAlgorithm = [_const.CPX_PARAM_CONFLICTALG, "algorithm used to find minimal conflicts:\n  0 = automatic\n  1 = fast\n  2 = propagation\n  3 = presolve\n  4 = IIS\n  5 = limited solve\n  6 = solve", _const.CPX_PARAMTYPE_INT]
ConflictDisplay = [_const.CPX_PARAM_CONFLICTDISPLAY, "level of the conflict display:\n  0 = no display\n  1 = summary display\n  2 = display every model being solved", _const.CPX_PARAMTYPE_INT]
setCPUmask = [_const.CPX_PARAM_CPUMASK, "cpubinding mask (off, auto, or a hex mask)", _const.CPX_PARAMTYPE_STRING]
setDetTimeLimit = [_const.CPX_PARAM_DETTILIM, "deterministic time limit in ticks", _const.CPX_PARAMTYPE_DOUBLE]
DistMIPRampupDetTimeLimit = [_const.CPX_PARAM_RAMPUPDETTILIM, "deterministic time limit on rampup", _const.CPX_PARAMTYPE_DOUBLE]
DistMIPRampupDuration = [_const.CPX_PARAM_RAMPUPDURATION, "duration of the rampup phase in distributed MIP:\n  -1 = rampup is disabled\n  0 = automatic\n  1 = rampup is followed by distributed tree search\n  2 = infinite horizon rampup", _const.CPX_PARAMTYPE_INT]
DistMIPRampupTimeLimit = [_const.CPX_PARAM_RAMPUPTILIM, "wall-clock time limit on rampup", _const.CPX_PARAMTYPE_DOUBLE]
EmphasisMemory = [_const.CPX_PARAM_MEMORYEMPHASIS, "reduced memory emphasis", _const.CPX_PARAMTYPE_INT]
EmphasisMIP = [_const.CPX_PARAM_MIPEMPHASIS, "emphasis for MIP optimization:\n  0 = balance optimality and integer feasibility\n  1 = integer feasibility\n  2 = optimality\n  3 = moving best bound\n  4 = finding hidden feasible solutions", _const.CPX_PARAMTYPE_INT]
EmphasisNumerical = [_const.CPX_PARAM_NUMERICALEMPHASIS, "extreme numerical caution emphasis", _const.CPX_PARAMTYPE_INT]
FeasoptMode = [_const.CPX_PARAM_FEASOPTMODE, "relaxation measure:\n  0 = find minimum-sum relaxation\n  1 = find optimal minimum-sum relaxation\n  2 = find minimum number of relaxations\n  3 = find optimal relaxation with minimum number of relaxations\n  4 = find minimum quadratic-sum relaxation\n  5 = find optimal minimum quadratic-sum relaxation", _const.CPX_PARAMTYPE_INT]
FeasoptTolerance = [_const.CPX_PARAM_EPRELAX, "minimum amount of accepted relaxation", _const.CPX_PARAMTYPE_DOUBLE]
setLPMethod = [_const.CPX_PARAM_LPMETHOD, "method for linear optimization:\n  0 = automatic\n  1 = primal simplex\n  2 = dual simplex\n  3 = network simplex\n  4 = barrier\n  5 = sifting\n  6 = concurrent optimizers", _const.CPX_PARAMTYPE_INT]
MIPCutsBQP = [_const.CPX_PARAM_BQPCUTS, "type of BQP cut generation (only applies to non-convex models solved to global optimality):\n  -1 = do not generate\n  0 = automatic\n  1 = moderate\n  2 = aggressive\n  3 = very aggressive", _const.CPX_PARAMTYPE_INT]
MIPCutsCliques = [_const.CPX_PARAM_CLIQUES, "type of clique cut generation:\n  -1 = do not generate\n  0 = automatic\n  1 = moderate\n  2 = aggressive\n  3 = very aggressive", _const.CPX_PARAMTYPE_INT]
MIPCutsCovers = [_const.CPX_PARAM_COVERS, "type of cover cut generation:\n  -1 = do not generate\n  0 = automatic\n  1 = moderate\n  2 = aggressive\n  3 = very aggressive", _const.CPX_PARAMTYPE_INT]
MIPCutsDisjunctive = [_const.CPX_PARAM_DISJCUTS, "type of disjunctive cut generation:\n  -1 = do not generate\n  0 = automatic\n  1 = moderate\n  2 = aggressive\n  3 = very aggressive", _const.CPX_PARAMTYPE_INT]
MIPCutsFlowCovers = [_const.CPX_PARAM_FLOWCOVERS, "type of flow cover cut generation:\n  -1 = do not generate\n  0 = automatic\n  1 = moderate\n  2 = aggressive", _const.CPX_PARAMTYPE_INT]
MIPCutsGomory = [_const.CPX_PARAM_FRACCUTS, "type of Gomory fractional cut generation:\n  -1 = do not generate\n  0 = automatic\n  1 = moderate\n  2 = aggressive", _const.CPX_PARAMTYPE_INT]
MIPCutsGUBCovers = [_const.CPX_PARAM_GUBCOVERS, "type of GUB cover cut generation:\n  -1 = do not generate\n  0 = automatic\n  1 = moderate\n  2 = aggressive", _const.CPX_PARAMTYPE_INT]
MIPCutsImplied = [_const.CPX_PARAM_IMPLBD, "type of implied bound cut generation:\n  -1 = do not generate\n  0 = automatic\n  1 = moderate\n  2 = aggressive", _const.CPX_PARAMTYPE_INT]
MIPCutsLiftProj = [_const.CPX_PARAM_LANDPCUTS, "type of Lift and Project cut generation:\n  -1 = do not generate\n  0 = automatic\n  1 = moderate\n  2 = aggressive\n  3 = very aggressive", _const.CPX_PARAMTYPE_INT]
MIPCutsLocalImplied = [_const.CPX_PARAM_LOCALIMPLBD, "type of local implied bound cut generation:\n  -1 = do not generate\n  0 = automatic\n  1 = moderate\n  2 = aggressive\n  3 = very aggressive", _const.CPX_PARAMTYPE_INT]
MIPCutsMCFCut = [_const.CPX_PARAM_MCFCUTS, "type of MCF cut generation:\n  -1 = do not generate\n  0 = automatic\n  1 = moderate\n  2 = aggressive", _const.CPX_PARAMTYPE_INT]
MIPCutsMIRCut = [_const.CPX_PARAM_MIRCUTS, "type of mixed integer rounding cut generation:\n  -1 = do not generate\n  0 = automatic\n  1 = moderate\n  2 = aggressive", _const.CPX_PARAMTYPE_INT]
MIPCutsPathCut = [_const.CPX_PARAM_FLOWPATHS, "type of flow path cut generation:\n  -1 = do not generate\n  0 = automatic\n  1 = moderate\n  2 = aggressive", _const.CPX_PARAMTYPE_INT]
MIPCutsRLT = [_const.CPX_PARAM_RLTCUTS, "type of RLT cut generation (only applies to non-convex models solved to global optimality):\n  -1 = do not generate\n  0 = automatic\n  1 = moderate\n  2 = aggressive\n  3 = very aggressive", _const.CPX_PARAMTYPE_INT]
MIPCutsZeroHalfCut = [_const.CPX_PARAM_ZEROHALFCUTS, "type of zero-half cut generation:\n  -1 = do not generate\n  0 = automatic\n  1 = moderate\n  2 = aggressive", _const.CPX_PARAMTYPE_INT]
MIPDisplay = [_const.CPX_PARAM_MIPDISPLAY, "level of mixed integer node display:\n  0 = no display\n  1 = display integer feasible solutions\n  2 = display nodes under 'mip interval' control\n  3 = same as 2, but add information on node cuts and solution times\n  4 = same as 3, but add LP display for root node\n  5 = same as 3, but add LP display for all nodes", _const.CPX_PARAMTYPE_INT]
MIPInterval = [_const.CPX_PARAM_MIPINTERVAL, "interval for printing mixed integer node display:\n  0 = automatic (equivalent to -1000)\n  n>0 = display every n nodes and new incumbents\n  n<0 = progressively less log output over time (closer to 0: more frequent)", _const.CPX_PARAMTYPE_LONG]
MIPLimitsAggForCut = [_const.CPX_PARAM_AGGCUTLIM, "constraint aggregation limit for cut generation:\n  0 = no constraint aggregation for cut generation\n  positive values at this limit", _const.CPX_PARAMTYPE_INT]
MIPLimitsAuxRootThreads = [_const.CPX_PARAM_AUXROOTTHREADS, "number of threads to use for auxiliary root tasks:\n  -1 = off\n  0 = automatic\n  n>0 = use n threads for auxiliary root tasks", _const.CPX_PARAMTYPE_INT]
MIPLimitsCutPasses = [_const.CPX_PARAM_CUTPASS, "number of cutting plane passes:\n  -1 = none\n  0 = automatic\n  positive values give number of passes to perform", _const.CPX_PARAMTYPE_LONG]
MIPLimitsCutsFactor = [_const.CPX_PARAM_CUTSFACTOR, "rows multiplier factor to limit cuts:\n  -1 = automatic (dynamically calculated)\n  0<=n<=1 = disable cutting plane generation\n  n>1 = number of cuts limited to (n-1) times the original number of rows", _const.CPX_PARAMTYPE_DOUBLE]
MIPLimitsEachCutLimit = [_const.CPX_PARAM_EACHCUTLIM, "limit on number of cuts for each type per pass", _const.CPX_PARAMTYPE_INT]
MIPLimitsGomoryCand = [_const.CPX_PARAM_FRACCAND, "candidate limit for generating Gomory fractional cuts", _const.CPX_PARAMTYPE_INT]
MIPLimitsGomoryPass = [_const.CPX_PARAM_FRACPASS, "pass limit for generating Gomory fractional cuts:\n  0 = automatic\n  positive values at this limit", _const.CPX_PARAMTYPE_LONG]
MIPLimitsNodes = [_const.CPX_PARAM_NODELIM, "branch and cut node limit", _const.CPX_PARAMTYPE_LONG]
MIPLimitsPolishTime = [_const.CPX_PARAM_POLISHTIME, "time limit for polishing best solution", _const.CPX_PARAMTYPE_DOUBLE]
MIPLimitsPopulate = [_const.CPX_PARAM_POPULATELIM, "solutions limit for each populate call", _const.CPX_PARAMTYPE_INT]
MIPLimitsProbeDetTime = [_const.CPX_PARAM_PROBEDETTIME, "deterministic time limit for probing", _const.CPX_PARAMTYPE_DOUBLE]
MIPLimitsProbeTime = [_const.CPX_PARAM_PROBETIME, "time limit for probing", _const.CPX_PARAMTYPE_DOUBLE]
MIPLimitsRepairTries = [_const.CPX_PARAM_REPAIRTRIES, "number of times to try repair heuristic:\n  -1 = none\n  0 = automatic\n  positive values give number of repair attempts", _const.CPX_PARAMTYPE_LONG]
MIPLimitsSolutions = [_const.CPX_PARAM_INTSOLLIM, "mixed integer solutions limit", _const.CPX_PARAMTYPE_LONG]
MIPLimitsStrongCand = [_const.CPX_PARAM_STRONGCANDLIM, "strong branching candidate limit", _const.CPX_PARAMTYPE_INT]
MIPLimitsStrongIt = [_const.CPX_PARAM_STRONGITLIM, "strong branching iteration limit:\n  0 = automatic\n  positive values at this limit", _const.CPX_PARAMTYPE_LONG]
MIPLimitsTreeMemory = [_const.CPX_PARAM_TRELIM, "upper limit on size of tree in megabytes", _const.CPX_PARAMTYPE_DOUBLE]
MIPOrderType = [_const.CPX_PARAM_MIPORDTYPE, "type of generated priority order:\n  0 = none\n  1 = decreasing cost\n  2 = increasing bound range\n  3 = increasing cost per coefficient count", _const.CPX_PARAMTYPE_INT]
MIPPolishAfterAbsMIPGap = [_const.CPX_PARAM_POLISHAFTEREPAGAP, "absolute MIP gap after which to start solution polishing", _const.CPX_PARAMTYPE_DOUBLE]
MIPPolishAfterDetTime = [_const.CPX_PARAM_POLISHAFTERDETTIME, "deterministic time after which to start solution polishing", _const.CPX_PARAMTYPE_DOUBLE]
MIPPolishAfterMIPGap = [_const.CPX_PARAM_POLISHAFTEREPGAP, "relative MIP gap after which to start solution polishing", _const.CPX_PARAMTYPE_DOUBLE]
MIPPolishAfterNodes = [_const.CPX_PARAM_POLISHAFTERNODE, "node count after which to start solution polishing", _const.CPX_PARAMTYPE_LONG]
MIPPolishAfterSolutions = [_const.CPX_PARAM_POLISHAFTERINTSOL, "solution count after which to start solution polishing", _const.CPX_PARAMTYPE_LONG]
MIPPolishAfterTime = [_const.CPX_PARAM_POLISHAFTERTIME, "time after which to start solution polishing", _const.CPX_PARAMTYPE_DOUBLE]
MIPPoolAbsGap = [_const.CPX_PARAM_SOLNPOOLAGAP, "absolute objective gap", _const.CPX_PARAMTYPE_DOUBLE]
MIPPoolCapacity = [_const.CPX_PARAM_SOLNPOOLCAPACITY, "capacity of solution pool", _const.CPX_PARAMTYPE_INT]
MIPPoolIntensity = [_const.CPX_PARAM_SOLNPOOLINTENSITY, "intensity for populating the MIP solution pool:\n  0 = automatic\n  1 = mild: generate few solutions quickly\n  2 = moderate: generate a larger number of solutions\n  3 = aggressive: generate many solutions and expect performance penalty\n  4 = very aggressive: enumerate all practical solutions", _const.CPX_PARAMTYPE_INT]
MIPPoolRelGap = [_const.CPX_PARAM_SOLNPOOLGAP, "relative objective gap", _const.CPX_PARAMTYPE_DOUBLE]
MIPPoolReplace = [_const.CPX_PARAM_SOLNPOOLREPLACE, "solution pool replacement strategy:\n  0 = replace oldest solutions\n  1 = replace solutions with worst objective\n  2 = replace least diverse solutions", _const.CPX_PARAMTYPE_INT]
MIPStrategyBacktrack = [_const.CPX_PARAM_BTTOL, "factor for backtracking, lower values give more", _const.CPX_PARAMTYPE_DOUBLE]
MIPStrategyBBInterval = [_const.CPX_PARAM_BBINTERVAL, "interval to select best bound node", _const.CPX_PARAMTYPE_LONG]
MIPStrategyBranch = [_const.CPX_PARAM_BRDIR, "direction of first branch:\n  -1 = down branch first\n  0 = automatic\n  1 = up branch first ", _const.CPX_PARAMTYPE_INT]
MIPStrategyDive = [_const.CPX_PARAM_DIVETYPE, "dive strategy:\n  0 = automatic\n  1 = traditional dive\n  2 = probing dive\n  3 = guided dive ", _const.CPX_PARAMTYPE_INT]
MIPStrategyFile = [_const.CPX_PARAM_NODEFILEIND, "file for node storage when tree memory limit is reached:\n  0 = no node file\n  1 = node file in memory and compressed\n  2 = node file on disk\n  3 = node file on disk and compressed", _const.CPX_PARAMTYPE_INT]
MIPStrategyFPHeur = [_const.CPX_PARAM_FPHEUR, "feasibility pump heuristic:\n  -1 = none\n  0 = automatic\n  1 = feasibility\n  2 = objective and feasibility", _const.CPX_PARAMTYPE_INT]
MIPStrategyHeuristicEffort = [_const.CPX_PARAM_HEUREFFORT, "effort level of heuristics:\n  0 = disable heuristics\n  <1 = decrease effort\n  1 = default\n  >1 = increase effort", _const.CPX_PARAMTYPE_DOUBLE]
MIPStrategyHeuristicFreq = [_const.CPX_PARAM_HEURFREQ, "frequency to apply periodic heuristic algorithm:\n  -1 = none\n  0 = automatic\n  positive values at this frequency", _const.CPX_PARAMTYPE_LONG]
MIPStrategyKappaStats = [_const.CPX_PARAM_MIPKAPPASTATS, "strategy to gather statistics on the kappa of subproblems:\n  -1 = never\n  0 = automatic\n  1 = sample\n  2 = always", _const.CPX_PARAMTYPE_INT]
MIPStrategyLBHeur = [_const.CPX_PARAM_LBHEUR, "indicator for local branching heuristic", _const.CPX_PARAMTYPE_INT]
MIPStrategyMIQCPStrat = [_const.CPX_PARAM_MIQCPSTRAT, "MIQCP strategy:\n  0 = automatic\n  1 = solve QCP relaxation at each node\n  2 = solve LP relaxation at each node", _const.CPX_PARAMTYPE_INT]
MIPStrategyNodeSelect = [_const.CPX_PARAM_NODESEL, "node selection strategy:\n  0 = depth-first search\n  1 = best-bound search\n  2 = best-estimate search\n  3 = alternate best-estimate search", _const.CPX_PARAMTYPE_INT]
MIPStrategyOrder = [_const.CPX_PARAM_MIPORDIND, "indicator to use priority orders", _const.CPX_PARAMTYPE_INT]
MIPStrategyPresolveNode = [_const.CPX_PARAM_PRESLVND, "node presolve strategy:\n  -1 = no node presolve\n  0 = automatic\n  1 = force node presolve\n  2 = node probing\n  3 = aggressive node probing", _const.CPX_PARAMTYPE_INT]
MIPStrategyProbe = [_const.CPX_PARAM_PROBE, "probing strategy:\n  -1 = no probing\n  0 = automatic\n  1 = moderate\n  2 = aggressive\n  3 = very aggressive", _const.CPX_PARAMTYPE_INT]
MIPStrategyRINSHeur = [_const.CPX_PARAM_RINSHEUR, "frequency to apply RINS heuristic:\n  -1 = none\n  0 = automatic\n  positive values at this frequency", _const.CPX_PARAMTYPE_LONG]
MIPStrategySearch = [_const.CPX_PARAM_MIPSEARCH, "indicator for search method:\n  0 = automatic\n  1 = traditional branch-and-cut search\n  2 = dynamic search", _const.CPX_PARAMTYPE_INT]
MIPStrategyStartAlgorithm = [_const.CPX_PARAM_STARTALG, "algorithm to solve initial relaxation:\n  0 = automatic\n  1 = primal simplex\n  2 = dual simplex\n  3 = network simplex\n  4 = barrier\n  5 = sifting\n  6 = concurrent optimizers", _const.CPX_PARAMTYPE_INT]
MIPStrategySubAlgorithm = [_const.CPX_PARAM_SUBALG, "algorithm to solve subproblems:\n  0 = automatic\n  1 = primal simplex\n  2 = dual simplex\n  3 = network simplex\n  4 = barrier\n  5 = sifting", _const.CPX_PARAMTYPE_INT]
MIPStrategyVariableSelect = [_const.CPX_PARAM_VARSEL, "variable selection strategy:\n  -1 = minimum integer infeasibility\n  0 = automatic\n  1 = maximum integer infeasibility\n  2 = pseudo costs\n  3 = strong branching\n  4 = pseudo reduced costs", _const.CPX_PARAMTYPE_INT]
MIPSubMIPStartAlg = [_const.CPX_PARAM_SUBMIPSTARTALG, "algorithm to solve initial relaxation for sub-MIPs:\n  0 = automatic\n  1 = primal simplex\n  2 = dual simplex\n  3 = network simplex\n  4 = barrier\n  5 = sifting", _const.CPX_PARAMTYPE_INT]
MIPSubMIPSubAlg = [_const.CPX_PARAM_SUBMIPSUBALG, "algorithm to solve subproblems for sub-MIPs:\n  0 = automatic\n  1 = primal simplex\n  2 = dual simplex\n  3 = network simplex\n  4 = barrier\n  5 = sifting", _const.CPX_PARAMTYPE_INT]
MIPSubMIPNodeLimit = [_const.CPX_PARAM_SUBMIPNODELIMIT, "sub-MIP node limit", _const.CPX_PARAMTYPE_LONG]
MIPSubMIPScale = [_const.CPX_PARAM_SUBMIPSCAIND, "type of scaling used for sub-MIPs:\n  -1 = no scaling\n  0 = equilibration scaling\n  1 = aggressive scaling", _const.CPX_PARAMTYPE_INT]
MIPTolerancesAbsMIPGap = [_const.CPX_PARAM_EPAGAP, "absolute mixed integer optimality gap tolerance", _const.CPX_PARAMTYPE_DOUBLE]
MIPTolerancesLinearization = [_const.CPX_PARAM_EPLIN, "epsilon value used in linearization", _const.CPX_PARAMTYPE_DOUBLE]
MIPTolerancesIntegrality = [_const.CPX_PARAM_EPINT, "integrality tolerance", _const.CPX_PARAMTYPE_DOUBLE]
MIPTolerancesLowerCutoff = [_const.CPX_PARAM_CUTLO, "lower objective cutoff", _const.CPX_PARAMTYPE_DOUBLE]
MIPTolerancesMIPGap = [_const.CPX_PARAM_EPGAP, "mixed integer optimality gap tolerance", _const.CPX_PARAMTYPE_DOUBLE]
MIPTolerancesObjDifference = [_const.CPX_PARAM_OBJDIF, "absolute amount successive objective values should differ", _const.CPX_PARAMTYPE_DOUBLE]
MIPTolerancesRelObjDifference = [_const.CPX_PARAM_RELOBJDIF, "relative amount successive objective values should differ", _const.CPX_PARAMTYPE_DOUBLE]
MIPTolerancesUpperCutoff = [_const.CPX_PARAM_CUTUP, "upper objective cutoff", _const.CPX_PARAMTYPE_DOUBLE]
MultiObjectiveDisplay = [_const.CPX_PARAM_MULTIOBJDISPLAY, "level of display during multi-objective optimization:\n  0 = no display\n  1 = summary display after each sub-problem\n  2 = same as 1, but add sub-problem logs", _const.CPX_PARAMTYPE_INT]
NetworkDisplay = [_const.CPX_PARAM_NETDISPLAY, "level of the network iteration display:\n  0 = no display\n  1 = display true objective values\n  2 = display penalized objective values", _const.CPX_PARAMTYPE_INT]
NetworkIterations = [_const.CPX_PARAM_NETITLIM, "network simplex iteration limit", _const.CPX_PARAMTYPE_LONG]
NetworkNetFind = [_const.CPX_PARAM_NETFIND, "level of network extraction:\n  1 = natural network only\n  2 = reflection scaling\n  3 = general scaling ", _const.CPX_PARAMTYPE_INT]
NetworkPricing = [_const.CPX_PARAM_NETPPRIIND, "pricing strategy index:\n  0 = let cplex select pricing strategy\n  1 = partial pricing\n  2 = multiple partial pricing (no sorting)\n  3 = multiple partial pricing (with sorting)", _const.CPX_PARAMTYPE_INT]
NetworkTolerancesFeasibility = [_const.CPX_PARAM_NETEPRHS, "feasibility tolerance", _const.CPX_PARAMTYPE_DOUBLE]
NetworkTolerancesOptimality = [_const.CPX_PARAM_NETEPOPT, "reduced cost optimality tolerance", _const.CPX_PARAMTYPE_DOUBLE]
setOptimalityTarget = [_const.CPX_PARAM_OPTIMALITYTARGET, "type of solution CPLEX will attempt to compute:\n  0 = auto\n  1 = optimal solution to convex problem\n  2 = first-order optimal solution\n  3 = global optimal solution", _const.CPX_PARAMTYPE_INT]
OutputCloneLog = [_const.CPX_PARAM_CLONELOG, "control the creation of clone log files:\n  0 = no clone log\n  1 = create clone log", _const.CPX_PARAMTYPE_INT]
OutputIntSolFilePrefix = [_const.CPX_PARAM_INTSOLFILEPREFIX, "file name prefix for storing incumbents when they arrive", _const.CPX_PARAMTYPE_STRING]
OutputMPSLong = [_const.CPX_PARAM_MPSLONGNUM, "indicator for long numbers in MPS output files", _const.CPX_PARAMTYPE_INT]
OutputWriteLevel = [_const.CPX_PARAM_WRITELEVEL, "variables to include in .sol and .mst files:\n  0 = auto\n  1 = all values\n  2 = discrete values\n  3 = non-zero values\n  4 = non-zero discrete values", _const.CPX_PARAMTYPE_INT]
setParallel = [_const.CPX_PARAM_PARALLELMODE, "parallel optimization mode:\n  -1 = opportunistic\n  0 = automatic\n  1 = deterministic", _const.CPX_PARAMTYPE_INT]
setParamDisplay = [_const.CPX_PARAM_PARAMDISPLAY, "whether to display changed parameters before optimization", _const.CPX_PARAMTYPE_INT]
PreprocessingAggregator = [_const.CPX_PARAM_AGGIND, "limit on applications of the aggregator:\n  -1 = automatic (1 for LP, infinite for MIP)\n  0 = none\n  >0 = aggregator application limit", _const.CPX_PARAMTYPE_INT]
PreprocessingBoundStrength = [_const.CPX_PARAM_BNDSTRENIND, "type of bound strengthening:\n  -1 = automatic\n  0 = off\n  1 = on", _const.CPX_PARAMTYPE_INT]
PreprocessingCoeffReduce = [_const.CPX_PARAM_COEREDIND, "level of coefficient reduction:\n  -1 = automatic\n  0 = none\n  1 = reduce only to integral coefficients\n  2 = reduce any potential coefficient\n  3 = aggressive reduction with tilting", _const.CPX_PARAMTYPE_INT]
PreprocessingDependency = [_const.CPX_PARAM_DEPIND, "indicator for preprocessing dependency checker:\n  -1 = automatic\n  0 = off\n  1 = at beginning\n  2 = at end\n  3 = at both beginning and end", _const.CPX_PARAMTYPE_INT]
PreprocessingDual = [_const.CPX_PARAM_PREDUAL, "take dual in preprocessing:\n  -1 = no\n  0 = automatic\n  1 = yes", _const.CPX_PARAMTYPE_INT]
PreprocessingFill = [_const.CPX_PARAM_AGGFILL, "limit on fill in aggregation", _const.CPX_PARAMTYPE_LONG]
PreprocessingFolding = [_const.CPX_PARAM_FOLDING, "indicator for folding of LPs:\n  -1 = automatic\n  0 = off\n  1-5 = increasing aggressive levels", _const.CPX_PARAMTYPE_INT]
PreprocessingLinear = [_const.CPX_PARAM_PRELINEAR, "indicator for linear reductions:\n  0 = only linear reductions\n  1 = full reductions", _const.CPX_PARAMTYPE_INT]
PreprocessingNumPass = [_const.CPX_PARAM_PREPASS, "limit on applications of presolve:\n  -1 = automatic\n  0 = none\n  >0 = presolve application limit", _const.CPX_PARAMTYPE_INT]
PreprocessingPresolve = [_const.CPX_PARAM_PREIND, "presolve indicator", _const.CPX_PARAMTYPE_INT]
PreprocessingQCPDuals = [_const.CPX_PARAM_CALCQCPDUALS, "dual calculation for QCPs:\n  0 = do not calculate\n  1 = calculate only if it does not interfere with presolve reductions\n  2 = calculate and disable interfering presolve reductions", _const.CPX_PARAMTYPE_INT]
PreprocessingQPMakePSD = [_const.CPX_PARAM_QPMAKEPSDIND, "indicator to make a binary qp psd or tighter", _const.CPX_PARAMTYPE_INT]
PreprocessingQToLin = [_const.CPX_PARAM_QTOLININD, "indicator to linearize products in the objective involving binary variables (for convex MIQP), or all products of bounded variables (for global QP):\n  -1 = automatic\n  0 = off\n  1 = on", _const.CPX_PARAMTYPE_INT]
PreprocessingReduce = [_const.CPX_PARAM_REDUCE, "type of primal and dual reductions:\n  0 = no primal and dual reductions\n  1 = only primal reductions\n  2 = only dual reductions\n  3 = both primal and dual reductions", _const.CPX_PARAMTYPE_INT]
PreprocessingRelax = [_const.CPX_PARAM_RELAXPREIND, "indicator for additional presolve of lp relaxation of mip:\n  -1 = automatic\n  0 = off\n  1 = on", _const.CPX_PARAMTYPE_INT]
PreprocessingRepeatPresolve = [_const.CPX_PARAM_REPEATPRESOLVE, "repeat mip presolve:\n  -1 = automatic\n  0 = off\n  1 = repeat presolve without cuts\n  2 = repeat presolve with cuts\n  3 = repeat presolve with cuts and allow new root cuts", _const.CPX_PARAMTYPE_INT]
PreprocessingSymmetry = [_const.CPX_PARAM_SYMMETRY, "indicator for symmetric reductions:\n  -1 = automatic\n  0 = off\n  1-5 = increasing aggressive levels", _const.CPX_PARAMTYPE_INT]
setQPMethod = [_const.CPX_PARAM_QPMETHOD, "method for quadratic optimization:\n  0 = automatic\n  1 = primal simplex\n  2 = dual simplex\n  3 = network simplex\n  4 = barrier\n  5 = sifting\n  6 = concurrent optimizers", _const.CPX_PARAMTYPE_INT]
setRandomSeed = [_const.CPX_PARAM_RANDOMSEED, "seed to initialize the random number generator", _const.CPX_PARAMTYPE_INT]
ReadConstraints = [_const.CPX_PARAM_ROWREADLIM, "constraint read size", _const.CPX_PARAMTYPE_INT]
ReadDataCheck = [_const.CPX_PARAM_DATACHECK, "indicator to check data consistency:\n  0 = data checking off\n  1 = data checking on input\n  2 = provide modeling assistance", _const.CPX_PARAMTYPE_INT]
ReadFileEncoding = [_const.CPX_PARAM_FILEENCODING, "code page for file reading and writing", _const.CPX_PARAMTYPE_STRING]
ReadNonzeros = [_const.CPX_PARAM_NZREADLIM, "constraint nonzero read size", _const.CPX_PARAMTYPE_LONG]
ReadQPNonzeros = [_const.CPX_PARAM_QPNZREADLIM, "quadratic nonzero read size", _const.CPX_PARAMTYPE_LONG]
ReadScale = [_const.CPX_PARAM_SCAIND, "type of scaling used:\n  -1 = no scaling\n  0 = equilibration scaling\n  1 = aggressive scaling", _const.CPX_PARAMTYPE_INT]
ReadVariables = [_const.CPX_PARAM_COLREADLIM, "variable read size", _const.CPX_PARAMTYPE_INT]
ReadWarningLimit = [_const.CPX_PARAM_WARNLIM, "max number of warnings to display", _const.CPX_PARAMTYPE_LONG]
setRecord = [_const.CPX_PARAM_RECORD, "record calls to C API", _const.CPX_PARAMTYPE_INT]
SiftingAlgorithm = [_const.CPX_PARAM_SIFTALG, "algorithm used to solve sifting subproblems:\n  0 = automatic\n  1 = primal simplex\n  2 = dual simplex\n  3 = network simplex\n  4 = barrier", _const.CPX_PARAMTYPE_INT]
SiftingSimplex = [_const.CPX_PARAM_SIFTSIM, "allow sifting to be called from simplex", _const.CPX_PARAMTYPE_INT]
SiftingDisplay = [_const.CPX_PARAM_SIFTDISPLAY, "level of the sifting iteration display:\n  0 = no display\n  1 = display major sifting iterations\n  2 = display work LP logs", _const.CPX_PARAMTYPE_INT]
SiftingIterations = [_const.CPX_PARAM_SIFTITLIM, "sifting iteration limit", _const.CPX_PARAMTYPE_LONG]
SimplexCrash = [_const.CPX_PARAM_CRAIND, "type of crash used:\n  LP primal: 0 = ignore objective coefficients during crash\n  LP primal: 1 or -1 = alternate ways of using objective coefficients\n  LP dual: 1 = default starting basis\n  LP dual: 0 or -1 = aggressive starting basis\n  QP primal: -1 = slack basis\n  QP primal: 0 = ignore Q terms and use LP solver for crash\n  QP primal: 1 = ignore objective and use LP solver for crash\n  QP dual: -1 = slack basis\n  QP dual: 0 or 1 = use Q terms for crash", _const.CPX_PARAMTYPE_INT]
SimplexDGradient = [_const.CPX_PARAM_DPRIIND, "type of dual gradient used in pricing:\n  0 = determined automatically\n  1 = standard dual pricing\n  2 = steepest-edge pricing\n  3 = steepest-edge pricing in slack space\n  4 = steepest-edge pricing, unit initial norms\n  5 = devex pricing", _const.CPX_PARAMTYPE_INT]
SimplexDisplay = [_const.CPX_PARAM_SIMDISPLAY, "level of the iteration display:\n  0 = no display\n  1 = display after refactorization\n  2 = display every iteration", _const.CPX_PARAMTYPE_INT]
SimplexDynamicRows = [_const.CPX_PARAM_DYNAMICROWS, "indicator for dynamic management of rows:\n  -1 = automatic\n   0 = keep all rows\n   1 = manage rows", _const.CPX_PARAMTYPE_INT]
SimplexLimitsIterations = [_const.CPX_PARAM_ITLIM, "upper limit on primal and dual simplex iterations", _const.CPX_PARAMTYPE_LONG]
SimplexLimitsLowerObj = [_const.CPX_PARAM_OBJLLIM, "lower limit on value of objective", _const.CPX_PARAMTYPE_DOUBLE]
SimplexLimitsPerturbation = [_const.CPX_PARAM_PERLIM, "upper limit on iterations with no progress:\n  0 = automatic\n  >0 = user specified limit", _const.CPX_PARAMTYPE_INT]
SimplexLimitsSingularity = [_const.CPX_PARAM_SINGLIM, "upper limit on repaired singularities", _const.CPX_PARAMTYPE_INT]
SimplexLimitsUpperObj = [_const.CPX_PARAM_OBJULIM, "upper limit on value of objective", _const.CPX_PARAMTYPE_DOUBLE]
SimplexPerturbationConstant = [_const.CPX_PARAM_EPPER, "perturbation constant", _const.CPX_PARAMTYPE_DOUBLE]
SimplexPerturbationIndicator = [_const.CPX_PARAM_PERIND, "perturbation indicator", _const.CPX_PARAMTYPE_INT]
SimplexPGradient = [_const.CPX_PARAM_PPRIIND, "type of primal gradient used in pricing:\n  -1 = reduced-cost pricing\n  0 = hybrid reduced-cost and devex pricing\n  1 = devex pricing\n  2 = steepest-edge pricing\n  3 = steepest-edge pricing, 1 initial norms\n  4 = full pricing", _const.CPX_PARAMTYPE_INT]
SimplexPricing = [_const.CPX_PARAM_PRICELIM, "size of the pricing candidate list", _const.CPX_PARAMTYPE_INT]
SimplexRefactor = [_const.CPX_PARAM_REINV, "refactorization interval", _const.CPX_PARAMTYPE_INT]
SimplexTolerancesFeasibility = [_const.CPX_PARAM_EPRHS, "feasibility tolerance", _const.CPX_PARAMTYPE_DOUBLE]
SimplexTolerancesMarkowitz = [_const.CPX_PARAM_EPMRK, "Markowitz threshold tolerance", _const.CPX_PARAMTYPE_DOUBLE]
SimplexTolerancesOptimality = [_const.CPX_PARAM_EPOPT, "reduced cost optimality tolerance", _const.CPX_PARAMTYPE_DOUBLE]
setSolutionType = [_const.CPX_PARAM_SOLUTIONTYPE, "solution information CPLEX will attempt to compute:\n  0 = auto\n  1 = basic solution\n  2 = primal dual vector pair", _const.CPX_PARAMTYPE_INT]
setThreads = [_const.CPX_PARAM_THREADS, "default parallel thread count:\n  0 = automatic\n  1 = sequential\n  >1 = parallel", _const.CPX_PARAMTYPE_INT]
setTimeLimit = [_const.CPX_PARAM_TILIM, "time limit in seconds", _const.CPX_PARAMTYPE_DOUBLE]
TuneDetTimeLimit = [_const.CPX_PARAM_TUNINGDETTILIM, "deterministic time limit per model and per test setting", _const.CPX_PARAMTYPE_DOUBLE]
TuneDisplay = [_const.CPX_PARAM_TUNINGDISPLAY, "level of the tuning display:\n  0 = no display\n  1 = minimal display\n  2 = display settings being tried\n  3 = display settings and logs", _const.CPX_PARAMTYPE_INT]
TuneMeasure = [_const.CPX_PARAM_TUNINGMEASURE, "method used to compare across multiple problems:\n  1 = average\n  2 = minmax", _const.CPX_PARAMTYPE_INT]
TuneRepeat = [_const.CPX_PARAM_TUNINGREPEAT, "number of times to permute the model and repeat", _const.CPX_PARAMTYPE_INT]
TuneTimeLimit = [_const.CPX_PARAM_TUNINGTILIM, "time limit per model and per test setting", _const.CPX_PARAMTYPE_DOUBLE]
setWorkDir = [_const.CPX_PARAM_WORKDIR, "directory for CPLEX working files", _const.CPX_PARAMTYPE_STRING]
setWorkMem = [_const.CPX_PARAM_WORKMEM, "memory available for working storage (in megabytes)", _const.CPX_PARAMTYPE_DOUBLE]
