import os
import random
import math

# --- --- --- 警告 --- --- ---
# 此脚本会永久删除文件。
# 在取消注释删除代码行之前，请务必确认脚本的输出是否正确。
# 建议先备份您的文件夹。
# --- --- --- --- --- --- ---

# 获取脚本文件所在目录的绝对路径
# 这样做可以确保无论您从哪里运行脚本，它总能正确地找到目标文件夹
script_dir = os.path.dirname(os.path.abspath(__file__))
print(f"脚本将在以下目录中运行: {script_dir}\n")

# 1. 获取目标文件夹中所有的 .txt 文件
try:
    all_files = os.listdir(script_dir)
    txt_files = [f for f in all_files if f.endswith('.txt')]
except FileNotFoundError:
    print(f"错误：找不到指定的文件夹 '{script_dir}'。")
    exit()

# 如果没有找到 .txt 文件，则退出
if not txt_files:
    print("目标文件夹中没有找到任何 .txt 文件。")
    exit()

# 2. 计算需要保留的文件数量 (10%，向上取整)
total_files_count = len(txt_files)
files_to_keep_count = math.ceil(total_files_count * 0.9)

print(f"总共找到 {total_files_count} 个 .txt 文件。")
print(f"将随机保留其中的 {files_to_keep_count} 个文件。")

# 3. 随机选择要保留的文件
files_to_keep = random.sample(txt_files, files_to_keep_count)

# 4. 确定要删除的文件
files_to_delete = [f for f in txt_files if f not in files_to_keep]

print("\n--- 将会保留以下文件 ---")
for f in files_to_keep:
    print(f)

print("\n--- 将会删除以下文件 ---")
if not files_to_delete:
    print("（没有文件需要删除）")
else:
    for f in files_to_delete:
        print(f)

# 5. 执行删除操作
# !!! 警告：取消下面的注释将会永久删除文件 !!!
# --- --- --- --- --- --- --- --- --- --- ---

print("\n\n--- 这是“试运行”模式 ---")
print("脚本没有删除任何文件。请检查上面的列表。")
print("如果列表正确，请打开脚本文件，删除 `os.remove(...)` 前面的 `#` 符号，然后重新运行。")

print("\n开始删除文件...")
for filename in files_to_delete:
    try:
        file_path_to_delete = os.path.join(script_dir, filename)
        os.remove(file_path_to_delete)  # <--- 取消此行的注释以启用删除功能
        print(f"已删除: {file_path_to_delete}")
    except OSError as e:
        print(f"删除 {filename} 时出错: {e}")

