from play3d.models import Model
from play3d.matrix import Matrix
import math
import numpy as np

class Earth(Model):

    @classmethod
    def _fn(cls, phi, theta, flattening_factor=0.9966472):

        return [
            math.sin(phi * math.pi / 180) * math.cos(theta * math.pi / 180),
            math.sin(theta * math.pi / 180) * math.sin(phi * math.pi / 180) * flattening_factor,
            math.cos(phi * math.pi / 180)
        ]
    
    def __init__(self, resolution = 40, **kwargs):
        super(Earth, self).__init__(**kwargs)

        self.data = []
        for x in np.linspace(0, 360, resolution):
            for y in np.linspace(0, 360, resolution):
                self.data.append(Earth._fn(x, y) + [1])

        self.data = Matrix(self.data)
        

class Trail(Model):

    def __init__(self, trail = [], **kwargs):
        super(Trail, self).__init__(**kwargs)
        self.data = [point + [1] for point in trail]
        self.data = Matrix(self.data)