import numpy as np
from env import OrbitZoo

params = {
        "drifters": [
            {"name": "44717",
             "initial_state": {
                                "x": 362065.325947,
                                "y": 4541775.7322441,
                                "z": -5222906.7082463,
                                "x_dot": -6711.3843161,
                                "y_dot": 2872.0197945,
                                "z_dot": 2033.8675632
                                },
             "initial_state_uncertainty": {"x": 0.0001, "y": 0.0001, "z": 0.0001, "x_dot": 0.0001, "y_dot": 0.0001, "z_dot": 0.0001},
             "initial_mass": 250.0,
             "radius": 5.0,
             "save_steps_info": False,
             "is_starlink": True,
            },
            {"name": "44720",
             "initial_state": {
                                "x": 2134341.4384263,
                                "y": -6468673.1369159,
                                "z": 1008659.2474804,
                                "x_dot": 4658.293135,
                                "y_dot": 595.3499213,
                                "z_dot": -5991.4235972
                                },
             "initial_state_uncertainty": {"x": 0.0001, "y": 0.0001, "z": 0.0001, "x_dot": 0.0001, "y_dot": 0.0001, "z_dot": 0.0001},
             "initial_mass": 250.0,
             "radius": 5.0,
             "save_steps_info": False,
            },
            {"name": "44725",
             "initial_state": {
                                "x": -4214199.8918565,
                                "y": -1789078.655338,
                                "z": 5186388.2558744,
                                "x_dot": 4900.917925,
                                "y_dot": -5399.3607574,
                                "z_dot": 2114.444093
                                },
             "initial_state_uncertainty": {"x": 0.0001, "y": 0.0001, "z": 0.0001, "x_dot": 0.0001, "y_dot": 0.0001, "z_dot": 0.0001},
             "initial_mass": 250.0,
             "radius": 5.0,
             "save_steps_info": False,
            },
            {"name": "44741",
             "initial_state": {
                                "x": 2431875.2309009,
                                "y": 3375443.8193555,
                                "z": -5543817.0775397,
                                "x_dot": -6174.9219463,
                                "y_dot": 4390.9946255,
                                "z_dot": -0034.8391808
                                },
             "initial_state_uncertainty": {"x": 0.0001, "y": 0.0001, "z": 0.0001, "x_dot": 0.0001, "y_dot": 0.0001, "z_dot": 0.0001},
             "initial_mass": 250.0,
             "radius": 5.0,
             "save_steps_info": False,
            },
            {"name": "44748",
             "initial_state": {
                                "x": -4321381.2890621,
                                "y": -2538699.739934,
                                "z": 4769616.9350782,
                                "x_dot": 5714.9214277,
                                "y_dot": -3944.494459,
                                "z_dot": 3070.2364805
                                },
             "initial_state_uncertainty": {"x": 0.0001, "y": 0.0001, "z": 0.0001, "x_dot": 0.0001, "y_dot": 0.0001, "z_dot": 0.0001},
             "initial_mass": 250.0,
             "radius": 5.0,
             "save_steps_info": False,
            },
            {"name": "44758",
             "initial_state": {
                                "x": 5373100.2225042,
                                "y": -3557486.4124815,
                                "z": 2481878.9169311,
                                "x_dot": 4450.2601435,
                                "y_dot": 2918.1437648,
                                "z_dot": -5427.1932127
                                },
             "initial_state_uncertainty": {"x": 0.0001, "y": 0.0001, "z": 0.0001, "x_dot": 0.0001, "y_dot": 0.0001, "z_dot": 0.0001},
             "initial_mass": 250.0,
             "radius": 5.0,
             "save_steps_info": False,
            },
            {"name": "44761",
             "initial_state": {
                                "x": 6661658.2523243,
                                "y": -354684.9063847,
                                "z": -1873344.2647979,
                                "x_dot": -1344.3977773,
                                "y_dot": 4808.1275676,
                                "z_dot": -5710.5481476
                                },
             "initial_state_uncertainty": {"x": 0.0001, "y": 0.0001, "z": 0.0001, "x_dot": 0.0001, "y_dot": 0.0001, "z_dot": 0.0001},
             "initial_mass": 250.0,
             "radius": 5.0,
             "save_steps_info": False,
            },
            {"name": "44768",
             "initial_state": {
                                "x": -5842625.3341607,
                                "y": -1155026.6011115,
                                "z": 3525361.4033178,
                                "x_dot": 3751.7132523,
                                "y_dot": -4658.9778094,
                                "z_dot": 4675.7170078
                                },
             "initial_state_uncertainty": {"x": 0.0001, "y": 0.0001, "z": 0.0001, "x_dot": 0.0001, "y_dot": 0.0001, "z_dot": 0.0001},
             "initial_mass": 250.0,
             "radius": 5.0,
             "save_steps_info": False,
            },
            {"name": "44937",
             "initial_state": {
                                "x": -3222304.7990675,
                                "y": -6037803.4311297,
                                "z": 190934.3964983,
                                "x_dot": 4144.9883907,
                                "y_dot": -2005.8227576,
                                "z_dot": 6088.2659038
                                },
             "initial_state_uncertainty": {"x": 0.0001, "y": 0.0001, "z": 0.0001, "x_dot": 0.0001, "y_dot": 0.0001, "z_dot": 0.0001},
             "initial_mass": 250.0,
             "radius": 5.0,
             "save_steps_info": False,
            },
        ],
        "satellites": [
            {"name": "satellite_1",
             "initial_state": {"x": 5337709.428463124, "y": 6339969.149911649, "z": 361504.73969662545, "x_dot": -5320.577430007447, "y_dot": 4465.13261069736, "z_dot": 526.2965261179082},
             "initial_state_uncertainty": {"x": 0.0001, "y": 0.0001, "z": 0.0001, "x_dot": 0.0001, "y_dot": 0.0001, "z_dot": 0.0001},
             "initial_mass": 250.0,
             "fuel_mass": 20.0,
             "isp": 310.0,
             "radius": 5.0,
             "save_steps_info": False,
             "agent": {
                "lr_actor": 0.0001,
                "lr_critic": 0.001,
                "gae_lambda": 0.95,
                "epochs": 10,
                "gamma": 0.95,
                "clip": 0.5,
                "action_std_init": 0.05,
                "state_dim_actor": 7,
                "state_dim_critic": 7,
                "action_space": [1000, np.pi, 2*np.pi],
             }},
             {"name": "satellite_2",
              "initial_state": {
                                "x": -5842625.3341607,
                                "y": -1155026.6011115,
                                "z": 3525361.4033178,
                                "x_dot": 3751.7132523,
                                "y_dot": -4658.9778094,
                                "z_dot": 4675.7170078
                                },
             "initial_state_uncertainty": {"x": 0.0001, "y": 0.0001, "z": 0.0001, "x_dot": 0.0001, "y_dot": 0.0001, "z_dot": 0.0001},
             "initial_mass": 250.0,
             "fuel_mass": 20.0,
             "isp": 310.0,
             "radius": 5.0,
             "save_steps_info": False,
             "agent": {
                "lr_actor": 0.0001,
                "lr_critic": 0.001,
                "gae_lambda": 0.95,
                "epochs": 10,
                "gamma": 0.95,
                "clip": 0.5,
                "action_std_init": 0.05,
                "state_dim_actor": 7,
                "state_dim_critic": 7,
                "action_space": [1000, np.pi, 2*np.pi],
             }},
        ],
        "delta_t": 10.0,
        "initial_date": {"year": 2024, "month": 11, "day": 27, "hour": 5, "minute": 12, "second": 42},
        "forces": {
            "gravity_model":  "HolmesFeatherstone",
            "third_bodies": {
                "active": False,
                "bodies": ["SUN", "MOON"],
            },
            "solar_radiation_pressure": {
                "active": False,
                "reflection_coefficients": {
                    # "agent": 0.5,
                    "44717": 0.8,
                    # "44720": 0.5, 
                    # "44725": 0.5, 
                    # "44741": 0.5, 
                    # "44748": 0.5, 
                    # "44758": 0.5, 
                    # "44761": 0.5, 
                    # "44768": 0.5, 
                    # "44937": 0.5, 
                }
            },
            "drag": {
                "active": False,
                "drag_coefficients": {
                    # "agent": 0.5,
                    "44717": 0.8,
                    # "44720": 0.5, 
                    # "44725": 0.5, 
                    # "44741": 0.5, 
                    # "44748": 0.5, 
                    # "44758": 0.5, 
                    # "44761": 0.5, 
                    # "44768": 0.5, 
                    # "44937": 0.5, 
                }
            }
        },
        "interface": {
            "show": True,
            "delay_ms": 0,
            "zoom": 5.0,
            "drifters": {
                "show": True,
                "show_label": True,
                "show_velocity": False,
                "show_trail": True,
                "trail_last_steps": 100,
                "color_body": (255, 255, 255),
                "color_label": (255, 255, 255),
                "color_velocity": (0, 255, 255),
                "color_trail": (255, 255, 255),
            },
            "satellites": {
                "show": True,
                "show_label": True,
                "show_velocity": False,
                "show_thrust": True,
                "show_trail": True,
                "trail_last_steps": 100,
                "color_body": (255, 0, 0),
                "color_label": (255, 255, 255),
                "color_velocity": (0, 255, 255),
                "color_thrust": (0, 255, 0),
                "color_trail": (255, 0, 0),
            },
            "earth": {
                "show": True,
                "color": (0, 0, 255),
                "resolution": 50,
            },
            "equator_grid": {
                "show": False,
                "color": (30, 140, 200),
                "resolution": 10,
            },
            "timestamp": {
                "show": True,
            },
            "orbits": [
                {"a": 2030.0e3, "e": 0.01, "i": 5.0, "pa": 20.0, "raan": 20.0, "color": (0, 255, 0)},
                # {"a": 2030.0e3, "e": 0.01, "i": 30.0, "pa": 40.0, "raan": 20.0, "color": (0, 255, 255)},
                # {"a": 16030.0e3, "e": 0.7, "i": 0.0001, "pa": 20.0, "raan": 20.0, "color": (255, 0, 255)},
            ],
        }
    }

env = OrbitZoo(params)

while True:
    env.step({'satellite_1': None, 'satellite_2': None})
    env.render()