function [omega, alpha] = load_coefficients( R )
    %lOAD_COEFFICIENTS Loads exponential sum approximation coefficients
    %
    % Coefficients for the exponential sum approximation of 1/x
    % The values are taken from http://www.mis.mpg.de/scicomp/EXP_SUM/ and picked such that
    % for each value of R = lambda_max/lambda_min the smallest available rank approximation
    % is taken.
    %
    % References:
    % [1]   W. Hackbusch 
    %       Entwicklungen nach Exponentialsummen
    %       Technical Report 4/2005, MPI MIS Leipzig, 2010. Revised version. 
    %       Available at http://www.mis.mpg.de/preprints/tr/report-0405.pdf.

    %   TTeMPS Toolbox. 
    %   Michael Steinlechner, 2013-2014
    %   Questions and contact: michael.steinlechner@epfl.ch
    %   BSD 2-clause license, see LICENSE.txt

    if R < 10
        %  http://www.mis.mpg.de/scicomp/EXP_SUM/1_x/1_xk03_1E1
        %  0.2847348675836868480131403719157745513257   {omega[1]}
        %  0.9583115118002354952046577263313764660779   {omega[2]}
        %  2.8443772254878889997348895279927205592685   {omega[3]}
        %  0.1064455484301103369894087730118670265256   {alpha[1]}
        %  0.6791933646735415630178896162494339705518   {alpha[2]}
        %  2.4024163101166760476718603500856374921568   {alpha[3]}
        omega = [0.2847348675836868480131403719157745513257, 0.9583115118002354952046577263313764660779, ...
                2.8443772254878889997348895279927205592685];
        
        alpha = [0.1064455484301103369894087730118670265256, 0.6791933646735415630178896162494339705518, ...
                2.4024163101166760476718603500856374921568];

    elseif R < 20
        %  http://www.mis.mpg.de/scicomp/EXP_SUM/1_x/1_xk03_2E1
        %  0.1871865945351820821081342480218800972125   {omega[1]}
        %  0.7633857188437595157155454717035070189013   {omega[2]}
        %  2.6169711142660253494832134357750419439981   {omega[3]}
        %  0.0679013689405892574945246102646745356424   {alpha[1]}
        %  0.4897948875089661041485125658745403143257   {alpha[2]}
        %  1.9962015809195739495960839060550995327503   {alpha[3]}

        omega = [ 0.1871865945351820821081342480218800972125; 0.7633857188437595157155454717035070189013; ...
                2.6169711142660253494832134357750419439981 ];

        alpha = [0.0679013689405892574945246102646745356424; 0.4897948875089661041485125658745403143257; ...
                 1.9962015809195739495960839060550995327503 ];

    elseif R < 30
        %  http://www.mis.mpg.de/scicomp/EXP_SUM/1_x/1_xk03_3E1
        %  0.1489350280707968614941037743815144267501   {omega[1]}
        %  0.6872993149781066612611854504955033462466   {omega[2]}
        %  2.5251745372914686719838239792323975052568   {omega[3]}
        %  0.0526373510053126044740958670159480803363   {alpha[1]}
        %  0.4159550868841870631409125130817372451020   {alpha[2]}
        %  1.8359809178980240516269178963071340149327   {alpha[3]}

        omega = [ 0.1489350280707968614941037743815144267501; 0.6872993149781066612611854504955033462466; ...
                2.5251745372914686719838239792323975052568 ];

        alpha = [0.0526373510053126044740958670159480803363; 0.4159550868841870631409125130817372451020; ...
                 1.8359809178980240516269178963071340149327 ];

    elseif R < 40
        %  http://www.mis.mpg.de/scicomp/EXP_SUM/1_x/1_xk03_4E1
        %  0.1282763604743762873410797484274858959452   {omega[1]}
        %  0.6457800255491172428698280760794858679219   {omega[2]}
        %  2.4737466774457358498554016001946820324520   {omega[3]}
        %  0.0443249082477236827920660192786650455332   {alpha[1]}
        %  0.3760267128377692993999176218622437772865   {alpha[2]}
        %  1.7481061682069727251757906838491862799856   {alpha[3]}
   
        omega = [ 0.1282763604743762873410797484274858959452; 0.6457800255491172428698280760794858679219; ...
                2.4737466774457358498554016001946820324520 ];

        alpha = [0.0443249082477236827920660192786650455332; 0.3760267128377692993999176218622437772865; ...
                 1.7481061682069727251757906838491862799856 ];

    elseif R < 50
        %  http://www.mis.mpg.de/scicomp/EXP_SUM/1_x/1_xk03_5E1
        %  0.1153310756696578369059902335891365510179   {omega[1]}
        %  0.6194232578183114542973164429184862456168   {omega[2]}
        %  2.4405036326787768433295433556651232720469   {omega[3]}
        %  0.0390820984323069169736556555116990807619   {alpha[1]}
        %  0.3509230683778314732214603094417881834488   {alpha[2]}
        %  1.6921947262166477795545388440601186630374   {alpha[3]}
   
        omega = [ 0.1153310756696578369059902335891365510179; 0.6194232578183114542973164429184862456168; ...
                2.4405036326787768433295433556651232720469 ];

        alpha = [0.0390820984323069169736556555116990807619; 0.3509230683778314732214603094417881834488; ...
                 1.6921947262166477795545388440601186630374 ];

    elseif R < 60
        %  http://www.mis.mpg.de/scicomp/EXP_SUM/1_x/1_xk03_6E1
        %  0.1065007940761846950413838444604586186415   {omega[1]}
        %  0.6012169550303838670810181732395705012095   {omega[2]}
        %  2.4172446838218981427469367329052829518332   {omega[3]}
        %  0.0354878575633928706640498294822005931337   {alpha[1]}
        %  0.3337331092077952527763084339396115751697   {alpha[2]}
        %  1.6535367452293752402354976016596310728346   {alpha[3]}
   
        omega = [ 0.1065007940761846950413838444604586186415; 0.6012169550303838670810181732395705012095; ...
                2.4172446838218981427469367329052829518332 ];

        alpha = [0.0354878575633928706640498294822005931337; 0.3337331092077952527763084339396115751697; ...
                 1.6535367452293752402354976016596310728346 ];

    elseif R < 70
        %  http://www.mis.mpg.de/scicomp/EXP_SUM/1_x/1_xk03_7E1
        %  0.1001553077368610132974404043626481808360   {omega[1]}
        %  0.5879845498502223689126118533199161220182   {omega[2]}
        %  2.4001809699912176228331350813505196128972   {omega[3]}
        %  0.0328950169895424992609872082843791574192   {alpha[1]}
        %  0.3213333776732262143905564238943739496790   {alpha[2]}
        %  1.6254323321274150328501900686362091619230   {alpha[3]}
   
        omega = [ 0.1001553077368610132974404043626481808360; 0.5879845498502223689126118533199161220182; ...
                2.4001809699912176228331350813505196128972 ];

        alpha = [0.0328950169895424992609872082843791574192; 0.3213333776732262143905564238943739496790; ...
                 1.6254323321274150328501900686362091619230 ];

    elseif R < 80
        %  http://www.mis.mpg.de/scicomp/EXP_SUM/1_x/1_xk03_8E1
        %  0.0954485614946326069841066666588069722366   {omega[1]}
        %  0.5780719785823823125598015792991901662390   {omega[2]}
        %  2.3873083432732535235590992650500652416667   {omega[3]}
        %  0.0309660405726075814911553646738284761852   {alpha[1]}
        %  0.3121038074526534121424636153419029938050   {alpha[2]}
        %  1.6043802276101923300543825035013867363887   {alpha[3]}
   
        omega = [ 0.0954485614946326069841066666588069722366; 0.5780719785823823125598015792991901662390; ...
                2.3873083432732535235590992650500652416667 ];

        alpha = [0.0309660405726075814911553646738284761852; 0.3121038074526534121424636153419029938050; ...
                 1.6043802276101923300543825035013867363887 ];
    
    elseif R < 90
        %  http://www.mis.mpg.de/scicomp/EXP_SUM/1_x/1_xk03_9E1
        %  0.0918992098575219402425365983200222785854   {omega[1]}
        %  0.5705336658200345004285022887380307565763   {omega[2]}
        %  2.3774665399131085228353471583417899637425   {omega[3]}
        %  0.0295080586695789376959540937367387769541   {alpha[1]}
        %  0.3051223245003002779000573357892633907795   {alpha[2]}
        %  1.5883739921280894394003957437178087275242   {alpha[3]}
   
        omega = [ 0.0918992098575219402425365983200222785854; 0.5705336658200345004285022887380307565763; ...
                2.3774665399131085228353471583417899637425 ];

        alpha = [0.0295080586695789376959540937367387769541; 0.3051223245003002779000573357892633907795; ...
                 1.5883739921280894394003957437178087275242 ];

    elseif R < 100

        %  http://www.mis.mpg.de/scicomp/EXP_SUM/1_x/1_xk03_1E2
        %  0.0892157079089669919486071947289929084945   {omega[1]}
        %  0.5647942501087851651861426738321370066842   {omega[2]}
        %  2.3699428171677330734901795183944273048837   {omega[3]}
        %  0.0284038048199532795564959406289795573741   {alpha[1]}
        %  0.2998300570947111501655338999805522348652   {alpha[2]}
        %  1.5761907592561199853995260178329829159338   {alpha[3]}

        omega = [ 0.0892157079089669919486071947289929084945; 0.5647942501087851651861426738321370066842; ...
                2.3699428171677330734901795183944273048837 ];

        alpha = [0.0284038048199532795564959406289795573741; 0.2998300570947111501655338999805522348652; ...
                 1.5761907592561199853995260178329829159338 ];

    elseif R < 200 

        %  http://www.mis.mpg.de/scicomp/EXP_SUM/1_x/1_xk03_2E2
        %  0.0842336964653581986314334444088114395299   {omega[1]}
        %  0.5540364331533339688207195905533808399923   {omega[2]}
        %  2.3557688429224689736704578812975796608953   {omega[3]}
        %  0.0263492728481437144350885744964463341944   {alpha[1]}
        %  0.2899685548481513726706056827131519071372   {alpha[2]}
        %  1.5533661852788560075230156476422394007386   {alpha[3]}
        omega = [0.0842336964653581986314334444088114395299, ...
                 0.5540364331533339688207195905533808399923, 2.3557688429224689736704578812975796608953];
        alpha = [0.0263492728481437144350885744964463341944, ...
                 0.2899685548481513726706056827131519071372, 1.5533661852788560075230156476422394007386];

    elseif R < 300 

        %  http://www.mis.mpg.de/scicomp/EXP_SUM/1_x/1_xk04_3E2
        %  0.0300842254221815340984474453078778566351   {omega[1]}
        %  0.1907535375929733114611520222725360440563   {omega[2]}
        %  0.7733295903723639011994803182936664143199   {omega[3]}
        %  2.6389901708906205511726700274621748576465   {omega[4]}
        %  0.0095667747961039157790762718983068602085   {alpha[1]}
        %  0.1012379805187263745680720586350709311318   {alpha[2]}
        %  0.5269302725083039626134684407787744930829   {alpha[3]}
        %  2.0503770061024033061029825386611946669291   {alpha[4]}

        omega = [0.0300842254221815340984474453078778566351, 0.1907535375929733114611520222725360440563,...
                 0.7733295903723639011994803182936664143199, 2.6389901708906205511726700274621748576465];
        alpha = [ 0.0095667747961039157790762718983068602085, 0.1012379805187263745680720586350709311318,...
                 0.5269302725083039626134684407787744930829, 2.0503770061024033061029825386611946669291];
                 

    elseif R < 400 
        %  http://www.mis.mpg.de/scicomp/EXP_SUM/1_x/1_xk04_4E2
        %  0.0284661205929678002576150783187181048106   {omega[1]}
        %  0.1865878163370500782299293146548890831582   {omega[2]}
        %  0.7656572669069769046914022969652080519154   {omega[3]}
        %  2.6293741631156146041845000915770924621029   {omega[4]}
        %  0.0089149584966167103430493114449295610768   {alpha[1]}
        %  0.0978104436659742490270375535332814109779   {alpha[2]}
        %  0.5175885566543470744449786935525992248586   {alpha[3]}
        %  2.0321413590981910171542196286154080553388   {alpha[4]}
        omega = [ 0.0284661205929678002576150783187181048106, 0.1865878163370500782299293146548890831582,...
                 0.7656572669069769046914022969652080519154, 2.6293741631156146041845000915770924621029];
        alpha = [ 0.0089149584966167103430493114449295610768, 0.0978104436659742490270375535332814109779,...
                 0.5175885566543470744449786935525992248586, 2.0321413590981910171542196286154080553388];

    elseif R < 500 
        %  http://www.mis.mpg.de/scicomp/EXP_SUM/1_x/1_xk04_5E2
        %  0.0283509824145518462858693315570279835924   {omega[1]}
        %  0.1862893386105706895712131113129750303870   {omega[2]}
        %  0.7651050730792038023189878537255737001033   {omega[3]}
        %  2.6286812528458147286778562312647977705637   {omega[4]}
        %  0.0088685367946663247640828832071835385875   {alpha[1]}
        %  0.0975658350270974381366175312568778110744   {alpha[2]}
        %  0.5169189990170087889041414253021855529369   {alpha[3]}
        %  2.0308311260118173089978671486122152600728   {alpha[4]}
        omega = [ 0.0283509824145518462858693315570279835924, 0.1862893386105706895712131113129750303870,...
                 0.7651050730792038023189878537255737001033, 2.6286812528458147286778562312647977705637];
                
        alpha = [ 0.0088685367946663247640828832071835385875, 0.0975658350270974381366175312568778110744,...
                 0.5169189990170087889041414253021855529369, 2.0308311260118173089978671486122152600728];

    elseif R < 600 
        %  http://www.mis.mpg.de/scicomp/EXP_SUM/1_x/1_xk05_6E2
        %  0.0125497022369018914496793782285821716727   {omega[1]}
        %  0.0755480277998204573136121521559349645258   {omega[2]}
        %  0.2993684653512476888869656838076949156857   {omega[3]}
        %  0.9612526221486810956294750962758399737140   {omega[4]}
        %  2.8702502162736308354874792403421679409803   {omega[5]}
        %  0.0040793511611987108165482531028228629921   {alpha[1]}
        %  0.0408997178514718597193682708690332106016   {alpha[2]}
        %  0.2071003853755610939370431985984133405054   {alpha[3]}
        %  0.7814442554474885124478691911242833612050   {alpha[4]}
        %  2.5196339666338295893831950023056265308696   {alpha[5]}
        omega = [ 0.0125497022369018914496793782285821716727, 0.0755480277998204573136121521559349645258,...
                 0.2993684653512476888869656838076949156857, 0.9612526221486810956294750962758399737140,...
                 2.8702502162736308354874792403421679409803];
        alpha = [ 0.0040793511611987108165482531028228629921, 0.0408997178514718597193682708690332106016,...
                 0.2071003853755610939370431985984133405054, 0.7814442554474885124478691911242833612050,...
                 2.5196339666338295893831950023056265308696];

    elseif R < 700 
        %  http://www.mis.mpg.de/scicomp/EXP_SUM/1_x/1_xk05_7E2
        %  0.0118636637624195178692006451964813251720   {omega[1]}
        %  0.0736487157459496412766292508522703030849   {omega[2]}
        %  0.2953333596223997398124046231959738406658   {omega[3]}
        %  0.9546824601007417951544463396995610082740   {omega[4]}
        %  2.8622952932595032279547431208754915132886   {omega[5]}
        %  0.0038074691411251674333998201932641181067   {alpha[1]}
        %  0.0394027284673490241780448913727630255721   {alpha[2]}
        %  0.2027096957655570047296704136452483169251   {alpha[3]}
        %  0.7717281393047814657369654067764486171654   {alpha[4]}
        %  2.5025046733436876863956171979097575786000   {alpha[5]}
        omega = [ 0.0118636637624195178692006451964813251720, 0.0736487157459496412766292508522703030849,...
                 0.2953333596223997398124046231959738406658, 0.9546824601007417951544463396995610082740,...
                 2.8622952932595032279547431208754915132886];
                
        alpha = [ 0.0038074691411251674333998201932641181067, 0.0394027284673490241780448913727630255721,...
                 0.2027096957655570047296704136452483169251, 0.7717281393047814657369654067764486171654,...
                 2.5025046733436876863956171979097575786000];
                 
    elseif R < 800 
        %  http://www.mis.mpg.de/scicomp/EXP_SUM/1_x/1_xk05_8E2
        %  0.0113813497171839778759997200904829917079   {omega[1]}
        %  0.0722993078519351827732693401007413314119   {omega[2]}
        %  0.2924451938945003215083486003411650244743   {omega[3]}
        %  0.9499630028765620042311909609900055784237   {omega[4]}
        %  2.8565759204045159773410755832401264342479   {omega[5]}
        %  0.0036161175535254347276672282204476593925   {alpha[1]}
        %  0.0383455049806827012912025746255162417242   {alpha[2]}
        %  0.1995869766812679076551772378023130727343   {alpha[3]}
        %  0.7647855301606951202580964022104126343038   {alpha[4]}
        %  2.4902332388884395458772402776048693340272   {alpha[5]}
        omega = [ 0.0113813497171839778759997200904829917079, 0.0722993078519351827732693401007413314119,...
                 0.2924451938945003215083486003411650244743, 0.9499630028765620042311909609900055784237,...
                 2.8565759204045159773410755832401264342479];
                
        alpha = [ 0.0036161175535254347276672282204476593925, 0.0383455049806827012912025746255162417242,...
                 0.1995869766812679076551772378023130727343, 0.7647855301606951202580964022104126343038,...
                 2.4902332388884395458772402776048693340272];

    elseif R < 900 
        %  http://www.mis.mpg.de/scicomp/EXP_SUM/1_x/1_xk05_9E2
        %  0.0110493996986944845713091178408815640211   {omega[1]}
        %  0.0713632054457008080852590571618865311621   {omega[2]}
        %  0.2904310341712171869663506457159840579152   {omega[3]}
        %  0.9466633544503644491496796575802363804542   {omega[4]}
        %  2.8525745409845265157262189648079697690264   {omega[5]}
        %  0.0034843237838238312649514669648576070671   {alpha[1]}
        %  0.0376153534981393007195370117162758205609   {alpha[2]}
        %  0.1974191937931761697681051076491698381687   {alpha[3]}
        %  0.7599497569265250643288402143671333988095   {alpha[4]}
        %  2.4816698505783679781604156300289787395741   {alpha[5]}
        omega = [ 0.0110493996986944845713091178408815640211, 0.0713632054457008080852590571618865311621,...
                 0.2904310341712171869663506457159840579152, 0.9466633544503644491496796575802363804542,...
                 2.8525745409845265157262189648079697690264];
        alpha = [ 0.0034843237838238312649514669648576070671, 0.0376153534981393007195370117162758205609,...
                 0.1974191937931761697681051076491698381687, 0.7599497569265250643288402143671333988095,...
                 2.4816698505783679781604156300289787395741];

    elseif R < 1000 
        %  http://www.mis.mpg.de/scicomp/EXP_SUM/1_x/1_xk05_1E3
        %  0.0108382726570232800350219570101328869782   {omega[1]}
        %  0.0707644978086732066545881149333130366585   {omega[2]}
        %  0.2891382091047487843294035159136257107093   {omega[3]}
        %  0.9445417262916081805245935298920301192993   {omega[4]}
        %  2.8500005633404065035450825060792112708441   {omega[5]}
        %  0.0034004600489073895373085156109901894261   {alpha[1]}
        %  0.0371498167966149987156249893255344218801   {alpha[2]}
        %  0.1960321090378673603580109152666466343362   {alpha[3]}
        %  0.7568483876518314330643366627526802403736   {alpha[4]}
        %  2.4761708329681671751556354399426140844298   {alpha[5]}
        omega = [ 0.0108382726570232800350219570101328869782, 0.0707644978086732066545881149333130366585,...
                 0.2891382091047487843294035159136257107093, 0.9445417262916081805245935298920301192993,...
                 2.8500005633404065035450825060792112708441];
        alpha = [ 0.0034004600489073895373085156109901894261, 0.0371498167966149987156249893255344218801,...
                 0.1960321090378673603580109152666466343362, 0.7568483876518314330643366627526802403736,...
                 2.4761708329681671751556354399426140844298];

    elseif R < 2000
        %  http://www.mis.mpg.de/scicomp/EXP_SUM/1_x/1_xk05_2E3
        %  0.0107186010624974955309879299722441992060   {omega[1]}
        %  0.0704239357038686291254884867807373183268   {omega[2]}
        %  0.2884012053308492404702506606284373447124   {omega[3]}
        %  0.9433310104981166196980689464535174693083   {omega[4]}
        %  2.8485313369244249009568092922961568547180   {omega[5]}
        %  0.0033529112764591385087846226072116895267   {alpha[1]}
        %  0.0368855238086302728956974734259022241645   {alpha[2]}
        %  0.1952428895765193203392729240364111831241   {alpha[3]}
        %  0.7550812995393414493814493448908820028009   {alpha[4]}
        %  2.4730352459564652644382481971874199189187   {alpha[5]}
        omega = [ 0.0107186010624974955309879299722441992060, 0.0704239357038686291254884867807373183268,...
                 0.2884012053308492404702506606284373447124, 0.9433310104981166196980689464535174693083,...
                 2.8485313369244249009568092922961568547180];
        alpha = [ 0.0033529112764591385087846226072116895267, 0.0368855238086302728956974734259022241645,...
                 0.1952428895765193203392729240364111831241, 0.7550812995393414493814493448908820028009,...
                 2.4730352459564652644382481971874199189187];
    
    else
        %  http://www.mis.mpg.de/scicomp/EXP_SUM/1_x/1_xk10_5E4
        %  0.0002208934821832957040647897430161832044   {omega[1]}
        %  0.0014446374339168884710816280199201233625   {omega[2]}
        %  0.0059039636580011526155381876550948261340   {omega[3]}
        %  0.0191745033778670667806167358937496913995   {omega[4]}
        %  0.0539477347530508462918291505416856779220   {omega[5]}
        %  0.1372518873236104681090016810252052437136   {omega[6]}
        %  0.3239144208051743069668153979234759276551   {omega[7]}
        %  0.7226896593627993157409397650958737813198   {omega[8]}
        %  1.5638487674530244242454557479504728689790   {omega[9]}
        %  3.5771277827054703852150546738997149986972   {omega[10]}
        %  0.0000692496834784916638751601990447830104   {alpha[1]}
        %  0.0007579413760384286345644150784030962376   {alpha[2]}
        %  0.0040023142147437247432675334370133501949   {alpha[3]}
        %  0.0154281992172262783045034312268128928736   {alpha[4]}
        %  0.0493673527732696566627638729701788022908   {alpha[5]}
        %  0.1392062788098163370888952355963752438583   {alpha[6]}
        %  0.3577616046206043001949061166389043364688   {alpha[7]}
        %  0.8565758106159338908475002483111637729962   {alpha[8]}
        %  1.9470344045222219883217035230060787398543   {alpha[9]}
        %  4.3475489303232417617577076907053879040177   {alpha[10]}
        omega = [ 0.0002208934821832957040647897430161832044, 0.0014446374339168884710816280199201233625,...
                  0.0059039636580011526155381876550948261340, 0.0191745033778670667806167358937496913995,...
                  0.0539477347530508462918291505416856779220, 0.1372518873236104681090016810252052437136,...
                  0.3239144208051743069668153979234759276551, 0.7226896593627993157409397650958737813198,...
                  1.5638487674530244242454557479504728689790, 3.5771277827054703852150546738997149986972];
        
        alpha = [ 0.0000692496834784916638751601990447830104, 0.0007579413760384286345644150784030962376,...
                  0.0040023142147437247432675334370133501949, 0.0154281992172262783045034312268128928736,...
                  0.0493673527732696566627638729701788022908, 0.1392062788098163370888952355963752438583,...
                  0.3577616046206043001949061166389043364688, 0.8565758106159338908475002483111637729962,...
                  1.9470344045222219883217035230060787398543, 4.3475489303232417617577076907053879040177];
      end  
end
