function [D, fX] = dlogm(X, H)
% Frchet derivative of the matrix logarithm.
%
% function [D, fX] = dlogm(X, H)
%
% Computes the directional derivative (the Frchet derivative) of logm at X
% along H (square matrices).
%
% Thus, D = lim_(t -> 0) (logm(X + tH) - logm(X)) / t.
%
% The second output is fX = logm(X), though it may be less accurate.
%
% Note: the adjoint of dlogm(X, .) is dlogm(X', .), which is a fact often
% useful to derive gradients of matrix functions involving logm(X).
% (This is wrt the inner product inner = @(A, B) real(trace(A'*B))).
% 
% See also: dfunm dexpm dsqrtm

% This file is part of Manopt: www.manopt.org.
% Original author: Nicolas Boumal, July 3, 2015.
% Contributors:
% Change log:
%
%   June 14, 2019 (NB): now also outputs logm(X) as a by-product.
    
    [D, fX] = dfunm(@logm, X, H);
    
end
