function b = multihconj_legacy(a, dim)
%MULTIHCONJ  Hermitian conjugating arrays of matrices.
%
%    THIS ORIGINAL MULTIHCONJ IS NOW CALLED MULTIHCONJ_LEGACY
%
%    B = MULTIHCONJ(A) is equivalent to B = MULTIHCONJ(A, DIM), where
%    DIM = 1.
%
%    B = MULTIHCONJ(A, DIM) is equivalent to
%    B = PERMUTE(A, [1:DIM-1, DIM+1, DIM, DIM+2:NDIMS(A)]), where A is an
%    array containing N P-by-Q matrices along its dimensions DIM and DIM+1,
%    and B is an array containing the Q-by-P Hermitian conjugate (') of
%    those N matrices along the same dimensions. N = NUMEL(A) / (P*Q), i.e.
%    N is equal to the number of elements in A divided by the number of
%    elements in each matrix.
%
%
%    Example:
%       A 5-by-9-by-3-by-2 array may be considered to be a block array
%       containing ten 9-by-3 matrices along dimensions 2 and 3. In this
%       case, its size is so indicated:  5-by-(9-by-3)-by-2 or 5x(9x3)x2.
%       If A is ................ a 5x(9x3)x2 array of 9x3 matrices,
%       C = MULTIHCONJ(A, 2) is a 5x(3x9)x2 array of 3x9 matrices.
%
%    See also MULTIHCONJ MULTITRANSP MULTIHERM.

% This file is part of Manopt: www.manopt.org.
% Original author: Hiroyuki Sato, April 27, 2015.
% Contributors: 
% Change log: 

    % Setting DIM if not supplied.
    if nargin == 1, dim = 1; end

    % Transposing
    b = multitransp_legacy(a, dim);

    %Conjugating
    b = conj(b);

end
