#include "TSP_IO.h"
#include "TSP_Basic_Functions.h"
#include "TSP_Init.h"
#include "TSP_2Opt.h"
#include "TSP_MCTS.h"
#include "TSP_Markov_Decision.h"

// For TSP20-50-100-200-500-1000 instances
void Solve_One_Instance(int Inst_Index)
{	
//	cout<<"Step 1"<<endl;
	
	Current_Instance_Begin_Time=(double)clock();  
	Current_Instance_Best_Distance=Inf_Cost;   	   
	
//	cout<<"Step 2"<<endl;

	// Input			
	Fetch_Stored_Instance_Info(Inst_Index);	
	
//	cout<<"Step 3"<<endl;
 	  	
	//Pre-processing	
	Calculate_All_Pair_Distance();	
	
	//cout<<"Step 4"<<endl; 	
 	      	
  	Set_Heapmap_Fine_Name(Inst_Index);  	 	
  	Read_Heatmap();  	
 
  	Identify_Candidate_Set(); 

	//cout<<"Step 5"<<endl;
		
	//Search by MDP  	 		  		    
	Markov_Decision_Process(Inst_Index);
	
	//cout<<"Step 6"<<endl;
	
	double Stored_Solution_Double_Distance=Get_Stored_Solution_Double_Distance(Inst_Index);

	double Current_Instance_End_Time = (double)clock();
	double Time_Delta = (Current_Instance_End_Time - Current_Instance_Begin_Time) / CLOCKS_PER_SEC;
	Total_Time += Time_Delta;

	double Current_Solution_Double_Distance=Get_Current_Solution_Double_Distance();
			
	if(Stored_Solution_Double_Distance/Magnify_Rate-Current_Solution_Double_Distance/Magnify_Rate > 0.000001)
		Beat_Best_Known_Times++;
	else if(Current_Solution_Double_Distance/Magnify_Rate-Stored_Solution_Double_Distance/Magnify_Rate > 0.000001)
		Miss_Best_Known_Times++;
	else
		Match_Best_Known_Times++;	
			
	Sum_Opt_Distance+=Stored_Solution_Double_Distance/Magnify_Rate;
	Sum_My_Distance+=Current_Solution_Double_Distance/Magnify_Rate;	
	Sum_Gap += 100 * (Current_Solution_Double_Distance-Stored_Solution_Double_Distance)/Stored_Solution_Double_Distance;
		
	printf("\nInst_Index:%d LKH Distance:%f, MCTS Distance:%f Gap:%.4f%% Time:%.5f Seconds\n", Inst_Index+1, Stored_Solution_Double_Distance/Magnify_Rate,
			Current_Solution_Double_Distance/Magnify_Rate,
			(Current_Solution_Double_Distance - Stored_Solution_Double_Distance) * 100 / Stored_Solution_Double_Distance, Time_Delta);
			
	FILE *fp;   
	fp=fopen(Statistics_File_Name, "a+");     
	fprintf(fp,"\nInst_Index:%d \t City_Num:%d \t LKH:%f \t MCTS:%f Improve:%f \t Time:%.5f Seconds\n",Inst_Index+1, Virtual_City_Num, Stored_Solution_Double_Distance/Magnify_Rate,
			Current_Solution_Double_Distance/Magnify_Rate, Stored_Solution_Double_Distance/Magnify_Rate-Current_Solution_Double_Distance/Magnify_Rate, Time_Delta);
	
	fprintf(fp,"Solution: ");
	int Cur_City=Start_City;
	do
	{
		fprintf(fp, "%d ", Cur_City);
		Cur_City=All_Node[Cur_City].Next_City;		
	}while(Cur_City != Null && Cur_City != Start_City);
	
	fprintf(fp,"\n"); 
	fclose(fp); 
			
	Release_Memory(Virtual_City_Num);	
}

bool Solve_Instances_In_Batch()
{ 
	ifstream FIC;
	string root = Input_Root;
	string prefix = "instances/";
	string middle = "TSP";
	string suffix = ".txt";
    string Temp_File_Name = root + prefix + middle + std::to_string(Temp_City_Num) + suffix;

    const char *temp = Temp_File_Name.c_str();
    Input_File_Name = const_cast<char*>(temp);

	FIC.open(Input_File_Name);
  
	if(FIC.fail())
	{
    	cout << "\n\nError! Fail to open file" << Input_File_Name << endl;
    	getchar();
    	return false;
	}
  	else
    	cout << "\n\nBegin to read instances information from " << Input_File_Name << endl;
    	    
  			 
 	double Temp_X;
 	double Temp_Y;
 	int Temp_City;
 	char Temp_String[100]; 	
 	
  	for(int i=0;i<Total_Instance_Num;i++)   
  	{
  		for(int j=0;j<Temp_City_Num;j++)
  		{
			FIC>>Temp_X;
			FIC>>Temp_Y;
			Stored_Coordinates_X[i][j]=Temp_X;
			Stored_Coordinates_Y[i][j]=Temp_Y;			
		}
		
		FIC>>&Temp_String[0];  
		
		for(int j=0;j<Temp_City_Num;j++)
  		{
			FIC>>Temp_City;
			Stored_Opt_Solution[i][j]=Temp_City-1;					
		}  	
		
		FIC>>Temp_City;			
	}      
  	FIC.close();  
  	
  	cout <<"\nRead instances finished. Begin to search."<<endl;  
  	
	if((Index_In_Batch+1)*Inst_Num_Per_Batch < Total_Instance_Num)
		Test_Inst_Num=Inst_Num_Per_Batch;
	else
		Test_Inst_Num=Total_Instance_Num-Index_In_Batch*Inst_Num_Per_Batch; 
	cout<<"\nNumber of instances in current batch: " <<Test_Inst_Num <<endl;
	
	FILE *fp;   
	fp=fopen(Statistics_File_Name, "w+");     
	fprintf(fp,"Number_of_Instances_In_Current_Batch: %d\n",Test_Inst_Num);  
	fclose(fp);   

//	cout << "Step 0" << endl;
			
  	for(int i=Index_In_Batch*Inst_Num_Per_Batch;i<(Index_In_Batch+1)*Inst_Num_Per_Batch && i<Total_Instance_Num;i++)
	 	Solve_One_Instance(i);	  
        
  	return true;  
}


// for tsplib

void Solve_One_Instance_TSPLIB()
{
//	cout<<"Step 1"<<endl;

	Current_Instance_Begin_Time=(double)clock();
	Current_Instance_Best_Distance=Inf_Cost;

//	cout<<"Step 2"<<endl;

	// Input
	Fetch_Stored_Instance_Info(0);

//	cout<<"Step 3"<<endl;

	//Pre-processing
	Calculate_All_Pair_Distance();

//	cout<<"Step 4"<<endl;

  	Set_TSPLIB_Heapmap_File_Name();
  	Read_Heatmap();

  	Identify_Candidate_Set();

//	cout<<"Step 5"<<endl;

	//Search by MDP
	Markov_Decision_Process(0);

//	cout<<"Step 6"<<endl;

	double Current_Instance_End_Time = (double)clock();
	double Time_Delta = (Current_Instance_End_Time - Current_Instance_Begin_Time) / CLOCKS_PER_SEC;
	Total_Time += Time_Delta;

	double Current_Solution_Double_Distance=Get_Current_Solution_Double_Distance();

	if(Stored_Distance-Current_Solution_Double_Distance/Magnify_Rate > 0.000001)
		Beat_Best_Known_Times++;
	else if(Current_Solution_Double_Distance/Magnify_Rate-Stored_Distance > 0.000001)
		Miss_Best_Known_Times++;
	else
		Match_Best_Known_Times++;

	Sum_Opt_Distance = Stored_Distance;
	Sum_My_Distance = Current_Solution_Double_Distance/Magnify_Rate;
	Sum_My_Distance = std::round(Sum_My_Distance);
	// due to rounding issues of distance calculation
	// the final length may not be very accurate
	if (Sum_My_Distance < Sum_Opt_Distance) Sum_My_Distance = Sum_Opt_Distance;
	Sum_Gap += 100 * (Sum_My_Distance - Sum_Opt_Distance)/Sum_Opt_Distance;

	printf("Name:%s    Optimal Distance:%lld, MCTS Distance:%lld Gap:%.4f%% Time:%.5f Seconds\n", Input_File_Name,
	    (long long) Sum_Opt_Distance, (long long) Sum_My_Distance, Sum_Gap, Time_Delta);

	FILE *fp;
	fp=fopen(Statistics_File_Name, "a+");
	fprintf(fp,"\nName:%s    Optimal Distance:%lld, MCTS Distance:%lld Gap:%.4f%% Time:%.5f Seconds\n", Input_File_Name,
	    (long long) Sum_Opt_Distance, (long long) Sum_My_Distance, Sum_Gap, Time_Delta);

	fprintf(fp,"Solution: ");
	int Cur_City=Start_City;
	do
	{
		fprintf(fp, "%d ", Cur_City);
		Cur_City=All_Node[Cur_City].Next_City;
	}while(Cur_City != Null && Cur_City != Start_City);

	fprintf(fp,"\n");
	fclose(fp);

	Release_Memory(Virtual_City_Num);
}

bool Solve_TSPLIB()
{
	ifstream FIC;

	string root = Input_Root;
	string prefix = "instances/";
	string suffix = ".txt";
	string Temp_File_Name = root + prefix + TSPLIB_Name + suffix;

	const char *temp = Temp_File_Name.c_str();
    Input_File_Name = const_cast<char*>(temp);

//    cout << Input_File_Name << endl;

	FIC.open(Input_File_Name);

	if(FIC.fail())
	{
    	cout << "\n\nError! Fail to open file" << Input_File_Name << endl;
    	getchar();
    	return false;
	}


 	double Temp_X;
 	double Temp_Y;
 	int Temp_City;
 	char Temp_String[100];

    for(int j=0;j<Temp_City_Num;j++)
    {
        FIC>>Temp_X;
        FIC>>Temp_Y;
        Stored_Coordinates_X[0][j]=Temp_X;
        Stored_Coordinates_Y[0][j]=Temp_Y;
//        std::cout << Temp_X << " " << Temp_Y << std::endl;
    }

    FIC >> &Temp_String[0];
    FIC >> Stored_Distance;

  	FIC.close();

	if((Index_In_Batch+1)*Inst_Num_Per_Batch < Total_Instance_Num)
		Test_Inst_Num=Inst_Num_Per_Batch;
	else
		Test_Inst_Num=Total_Instance_Num-Index_In_Batch*Inst_Num_Per_Batch;

	FILE *fp;
	fp=fopen(Statistics_File_Name, "w+");
	fprintf(fp,"Number_of_Instances_In_Current_Batch: %d\n",Test_Inst_Num);
	fclose(fp);


  	Solve_One_Instance_TSPLIB();

  	return true;
}




int main(int argc, char ** argv)
{	
	double Overall_Begin_Time=(double)clock();
	
	srand(Random_Seed); 	
	
	Index_In_Batch=0;
	Statistics_File_Name=argv[1];
	Input_Root=argv[2];
	Temp_City_Num=atoi(argv[3]);
	Inst_Num_Per_Batch=atoi(argv[4]);
	Run_Type = argv[5];
	TSPLIB_Name = argv[6];

	// parameters

	if (strcmp(Run_Type, "tsp_random") == 0) Solve_Instances_In_Batch();
	else if (strcmp(Run_Type, "tsplib") == 0) Solve_TSPLIB();
	else exit(0);

  	if (strcmp(Run_Type, "tsplib") == 0) return 0;
	FILE *fp;    	  
	fp=fopen(Statistics_File_Name, "a+"); 
	fprintf(fp,"\n\nAvg_LKH_Distance: %f Avg_MCTS_Distance: %f Avg_Gap: %.4f%% Total_Time: %.5f Seconds \n Each inference costs %.5f seconds \n",
			Sum_Opt_Distance/Test_Inst_Num,Sum_My_Distance/Test_Inst_Num, Sum_Gap/Test_Inst_Num, Total_Time, Total_Time / Test_Inst_Num);
	fclose(fp);
	
	printf("\n\nAvg_LKH_Distance: %f Avg_MCTS_Distance: %f Avg_Gap: %.4f%% Total_Time: %.5f Seconds \n Each inference costs %.5f seconds \n",
			Sum_Opt_Distance/Test_Inst_Num,Sum_My_Distance/Test_Inst_Num, Sum_Gap/Test_Inst_Num, Total_Time, Total_Time / Test_Inst_Num);
//	getchar();

	return 0;
}