
// Jump to a new state by randomly generating a solution
void Jump_To_Random_State()
{
	Generate_Initial_Solution(); 	
}


//void Parameter_Table() {
//    if (Virtual_City_Num == 20) {
//        Param_H = 1;
//        Param_T = 0.05;
//        Param_D = 4;
//        Max_Depth = 2;
//        Param_S = 1;
//        for (int i = 0; i < 4; ++i) {
//            Param_H *= 2;
//            MCTS();
//            Param_D = 1;
//            Max_Depth += 2;
//        }
//
//        Param_H = 10;
//        Param_D = 1;
//        Param_S = 0;
//        while(((double)clock()-Current_Instance_Begin_Time) / CLOCKS_PER_SEC < Param_T*Virtual_City_Num) {
//            Jump_To_Random_State();
//            MCTS();
//        }
//    } else if (Virtual_City_Num == 50) {
//        Param_H = 1;
//        Param_T = 0.05;
//        Param_D = 4;
//        Max_Depth = 5;
//        Param_S = 1;
//        for (int i = 0; i < 4; ++i) {
//            Param_H *= 2;
//            MCTS();
//            Param_D = 1;
//            Max_Depth += 5;
//        }
//
//        Param_H = 10;
//        Param_D = 1;
//        Param_S = 0;
//        while(((double)clock()-Current_Instance_Begin_Time) / CLOCKS_PER_SEC < Param_T*Virtual_City_Num) {
//            Jump_To_Random_State();
//            Local_Search_by_2Opt_Move();
//            MCTS();
//        }
//    } else if (Virtual_City_Num == 100) {
//        Param_H = 1;
//        Param_T = 0.05;
//        Param_D = 4;
//        Max_Depth = 10;
//        Param_S = 1;
//        for (int i = 0; i < 4; ++i) {
//            Param_H *= 2;
//            MCTS();
//            Param_D = 1;
//            Max_Depth += 5;
//        }
//
//        Param_H = 20;
//        Param_D = 1;
//        Param_S = 0;
//        while(((double)clock()-Current_Instance_Begin_Time) / CLOCKS_PER_SEC<Param_T*Virtual_City_Num) {
//            Jump_To_Random_State();
//            MCTS();
//        }
//    } else if (Virtual_City_Num == 200) {
//
//    } else if (Virtual_City_Num == 500) {
//
//    } else if (Virtual_City_Num == 1000) {
//        Param_H = 0.05;
//        Param_T = 0.01;
//        Param_D = 4;
//        Max_Depth = 20;
//        for (int i = 0; i < 4; ++i) {
//            Param_H *= 4;
//            MCTS();
//            Param_D = 1;
//            Max_Depth += 10;
//        }
//    } else {
//        cout << "Unexpected city number: " << Virtual_City_Num << endl;
//    }
//}


Distance_Type Markov_Decision_Process(int Inst_Index)
{
	MCTS_Init();                      // Initialize MCTS parameters
	// M0: Use generated initial solution instead of heatmap sampling
    // Generate_Initial_Solution();      // State initialization of MDP
    if (strcmp(Run_Type, "tsp_random") == 0) Read_Initial_Solution(Inst_Index);
	else if (strcmp(Run_Type, "tsplib") == 0) Read_TSPLIB_Initial_Solution(Inst_Index);
     // Initialize
	Local_Search_by_2Opt_Move();	  // 2-opt based local search within small neighborhood
    Store_Best_Solution();

    // Time threshold, see paper for details, to make the total time of TS^5 similar to original AttGCRN+MCTS
    if (Virtual_City_Num <= 20) Param_T = 0.094;
    else if (Virtual_City_Num <= 50) Param_T = 0.290;
    else if (Virtual_City_Num <= 100) Param_T = 0.515;
    else if (Virtual_City_Num <= 200) Param_T = 1.272;
    else if (Virtual_City_Num <= 500) Param_T = 3.070;
    else Param_T = 4.300;

    if (strcmp(Run_Type, "tsplib") == 0) Param_T = 0.02 * Virtual_City_Num;

	// Modified MCTS
    if (Virtual_City_Num <= 99) Param_H = 5;
    else if (Virtual_City_Num <= 499) Param_H = 1;
    else Param_H = 500.0 / Virtual_City_Num;

    Param_D = 1;
    Param_S = 1;
    if (Virtual_City_Num <= 49) Max_Depth = 10;
    else if (Virtual_City_Num <= 99) Max_Depth = 15;
    else if (Virtual_City_Num <= 499) Max_Depth = 40;
    else Max_Depth = Virtual_City_Num / 20;

    MCTS();

    while (((double)clock()-Current_Instance_Begin_Time) / CLOCKS_PER_SEC< Param_T) {
        Jump_To_Random_State();
        Local_Search_by_2Opt_Move();
        MCTS();
    }

	// Copy information of the best found solution (stored in Struct_Node *Best_All_Node ) to Struct_Node *All_Node 
	Restore_Best_Solution();
	
	if(Check_Solution_Feasible())
		return Get_Solution_Total_Distance();
	else
		return Inf_Cost;
}



